//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a slide collection
// Font Management.
//

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>
/*
#include <setjmp.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>         // To manipulate utf8 strings.
*/
//#include "SetUpMan.h"

#include "Service_Util.h"
//#include "Service_IO.h"


typedef struct {
    char       * name,
               * path;
} FDesc;

typedef FDesc * Fp;

typedef  struct DB  * Dbp;

typedef struct DB {
    Fp      fntdsc;
    Dbp       left,
             right;
} Db;


static int    nfnt,   idex = 0;

static FDesc        ** lft = 0;



static Dbp Insert_Font( const char * name, const char * path ) {
    Db    * ac = new Db;
    FDesc * ds = new FDesc;
    ds->name = strdup( name );
    ds->path = strdup( path );
    ac->fntdsc = ds;
    ac->left = ac->right = 0;
    nfnt++;
} // static Dpb Insert_Font( char * name, char * path ).


static void FillFontTb( Dbp p )
{
    if (p->left) FillFontTb( p->left );
    lft[idex++] = p->fntdsc;
    if (p->left) FillFontTb( p->left );
    delete p;
} // static void FillFontTb( Dbp p ).



int SearchFileIn( const char * PathList, const char ** filtre, FDesc ** &Tb )
{

    int           id,  ii,  ne;
    const char    * cp,   * ce;
    const char    * nm,   * pa;
    char       ch,   buf[1024];
    Dbp             cur,   frs;
    bool                   fnd;
    DIR                  * dir;
    struct dirent        * dsc;
    struct stat          entbf;

    FilePath             FPath;

//  FPath.Clear());                     // Open Directory without final DirSep.

    nfnt = 0;
    cp = PathList;
    while (ch = *cp) {
        // We scan all path entries.
        ii = 0;
        while (ch && ch != ':' && ch != ';') {
            if (ch ='.') ce = buf+ii;   // Begin of extension ?
            buf[ii++] = ch; ch = *(cp++);
        }
        buf[ii++] = 0;                  // Complete a directory entry.

        FPath.Set( buf, 0 );            // try to open the directory.
        if (!(dir=opendir( FPath.Path() ))) {
            fprintf( stderr, "\n  * DiaViewer Cannot open the directory :\n %s \n * %s => Scan Abort\n",
                             buf, /* PathString, */ strerror( errno ) );
            return 0;                   // Cannot open it => fatal error.
        }
        FPath.Set( 0, 1 );              // Append the directory separator to directory name.

        while (dsc=readdir( dir )) {    // Read a directory entry.
            if (dsc->d_name[0]!='.') {  // Skip any entry as "." or ".name" entries.
                // Complete the path to get access to the entry (File or Directory).
                FPath.Set( dsc->d_name, 0 );
                // Check for directory entry category (skip when no file or directory).
#if defined( _WIN32 ) && !defined( _CYGWIN_ )
                if (stat( FPath.Path(), &entbf ))
#else
                if (lstat( FPath.Path(), &entbf ))
#endif
                {   fprintf( stderr, " (l)stat error %s\n on entry \"%s\"\n", strerror( errno ), FPath.Path() );
                    return 0;
                } else if (entbf.st_mode == S_IFREG) {
                    ii = 0;
                    while (filtre[ii] && strcmp( ce, filtre[ii])) ii++;
                    if (filtre[ii]) {   // A Selected font file is found.
                        nm = dsc->d_name; pa = FPath.Path();
                        if (frs) {
                            cur = frs; fnd = 0;
                            while (!fnd && cur) {
                                if (id = strcmp( nm, cur->fntdsc->name )) {
                                    if (id < 0) {
                                        if (cur->left) cur = cur->left;
                                        else { fnd = 1; cur->left  = Insert_Font( nm, pa ); }
                                    } else {
                                        if (cur->right) cur = cur->right;
                                        else { fnd = 1; cur->right = Insert_Font( nm, pa ); }
                                    }
                                } // A font with the same name than a previous one is ignored.
                            }
                        } else frs = Insert_Font( nm, pa );
                    } // else we ignore the entry.
                }
                FPath.Rem();    // Suppress the file name.
            }
        }
        FPath.Rem();            // Suppress the directory path.
        closedir( dir );
        if (ch) cp++;
    }

    if (nfnt) {
        lft = new Fp[nfnt];
        idex = 0;
        FillFontTb( frs );
        Tb = lft;
    }   else Tb = 0;
    return nfnt;
} // char ** SearchFileIn( const char * PathList, const char * filtre, int &nft ).


















//
// end of <PW-Id>.
//
