//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a slide collection
// DCM = DiaViewer Collection Management.
//

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>

#include <setjmp.h>


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>

#include "Service_DIR.h"
#include "Service_Sort.h"
#include "Service_IO.h"


#include "DiaViewer_GBL.h"
#include "DiaViewer_DIA.h"
#include "DiaViewer_DCM.h"
#include "DiaViewer_PRG.h"
#include "DiaViewer_MVL.h"
#include "DiaViewer_VRFL.h"
#include "DiaViewer_V_MN.h"






//
// Each diapositive/slide is identified by a unique IIde_t integer.
// This identifier include three part. The volume identifier number,
// the directory identifier number (in the volume) and the slide identifier
// unique in the volume. The three field in the IIde_t identifier can be
// defined by a definition as :
// #define LARGE_UNI_IDENT
// to have a 64 bits identifier type (the default is 32 bits), and by
// #define UNIQUE_IDE_FIELDS {<sld>,<dir>}
// For example, for 32 bits identifiers:
// #define  UNIQUE_IDE_FIELDS {16,10}
// while by used to get a slide field of 16 bits and a directories field of 10 bits,
// that keep 6 bits (32 - 16 - 10 = 6) for the volume. With this, you can have a
// maximum of 2**16-1 = 65535 slides in each directory, 2**10-1 = 1023 directories
// in each volume and 2**(32-16-10)-1 = 64 volumes. The default 32 bits IIde Identifier
// is defined at the compilation time but the UNIQUE_IDE_FIELDS is keep in the user's
// local data context and can be changed when the DiaViewer software is restarted and
// it should be possible to change these field sizes by using the setup menu in some
// future versions.
// The default fields size values are :
//    #define UNIQUE_IDE_FIELDS {14,10} in 32 bits that allows
//           16,383 slides in each directory,
//             1023 directories in each volume and
//              255 opened volumes.
//
//    #define UNIQUE_IDE_FIELDS {32,16} in 64 bits that allows
//    4,294,967,297 slides in each directory,
//           65,535 directories in each volume and
//           65,535 opened volumes.
//
// The default DiaViewer software generation is with Unique Identifiers of 32 bits.
//
//



// The default fields size values are :
//    #define UNIQUE_IDE_FIELDS {14,10} in 32 bits that allows
//           16,383 slides in each directory,
//             1023 directories in each volume and
//              255 opened volumes.
//
//    #define UNIQUE_IDE_FIELDS {32,16} in 64 bits that allows
//    4,294,967,297 slides in each directory,
//           65,535 directories in each volume and
//           65,535 opened volumes.
//
// The default DiaViewer software generation is with Unique Identifiers of 32 bits.
//
//


static sigjmp_buf       JmpBuf; // Buffer for long jump on I/O context error.



//
// Entry type defined to directory entries.
//


/*
typedef struct { // Define the element of Entry table (for sorting).
    int    use,  // Used size.
           all;  // Allocated size.
    Entry *tab;  // The table of name.
} EntryTable;

*/



const char * ImgExt[] = { "jpeg", "JPEG", "jpg", "JPG", "png", "PNG", "bmp", "BMP", 0 };

static char        ErrMsg[512]; // To keep the last Io Error Message.
static int        ErrMsglength; //



static int Err_Handler( int ie, const char * msg, void * d ) {
    LogF.Write( "%s", msg );
    fl_alert( "%s", msg );
    siglongjmp( JmpBuf, ie );
} // static int Err_Handler( int ie, const char * msg, void * d ).




static DirEntry * ScanFoundDir( const char * root ) {
    // pdir is the parent directory descriptor,
    // path is the complete path where is founded the new directory entry,
    // name is the name of the new directory entry.
    //

    AnySort<SliEntry>    SliSort( 32 ); // Create the sorting table for ...
    AnySort<DirEntry>    DirSort( 12 ); // ... directories and files.

    DirEntry              * nwdir, // Pointer to the current directory descriptor,
                         ** tbdir; // Pointer to the current directory sort list of directories.
    SliEntry              * nwsli, // Pointer to the current slide descriptor,
                         ** tbsli; // Pointer to the current directory sort list of slides.

    SrvDir                    Dsc; // Create the service directory tree scan object, ...
    int                       lvl, // ... the nesting context index copy.
                             mlvl, // The maximum  degree of nesting.
                              irp, // The flag to stop the Tree exploration (if false).
                              sts, // The Scan Step status.
                       nd,     ns; // The count of directories and slides.

    // Total count of slide and directory for the current directory and its sub-diretories.
    int             ncdir,  ncsli;

    int       idp = 0, idperr = 0; // Use for deep error with context (possible slide volume overlay).

    Dsc.ErrHdl( Err_Handler );          // Install the error handler.
    Dsc.SetFltExt( (SrvDir::FTypLst) ImgExt );  // Install the list of file extension to search.
    Dsc.UsrLevel( lvl );                // Install lvl has copy of directory lex level (deep in the tree).
    Dsc.Init( root, 0 );                // Initialize the scan in the directory tree.

    ncdir = ncsli = mlvl = 0;           // Init the total counts of directories, slides ...
                                        // ... and maximumnesting level.

    irp = 1;
    while (irp) {                       // Loop to scan all the directory tree.
        sts = Dsc.Scan();               // Perform one step in the tree.
//      Cnt = &(Cntx_Tab[lvl]);         // Update the context pointer.
        switch (sts) {
            case SrvDir::Scan_IDir:     // Begin of a directory or sub-directory.
//              Cnt->ndir = Cnt->nsli = Cnt->ncdir = Cnt->ncsli = 0;

                SliSort.Push();         // Prepare  new lists for the
                DirSort.Push();
            break;

            case SrvDir::Scan_File:     // Regular selected file.
                                        // We must build the slide record.

                nwsli = new SliEntry( Dsc.Name() );     // Create the Slide record ...
                SliSort.NewEntry( nwsli );              // ... put it it the Sort Table.
//              Cnt->nsli++;
//              Cnt->ncsli++;
            break;

            case SrvDir::Scan_DiRf:     // Sub-Directory Reference found (cannot exist for us.).
            break;

            case SrvDir::Scan_Eodi:     // End of (sub-)directory.
                if (ncsli) {            // When this directory (including sub-directory) includes some slide(s) :
                    nwdir = new DirEntry( Dsc.Name() ); // We create the directory record,
                    if (ns = SliSort.Size()) {          // When we have find some slides inside ...
                        if (ns > 1) SliSort.Sort();     // ... we the Sort them and ...
                        nwdir->Slide( ns, SliSort.GetTable() ); // ... build the Directory list of slides.
                        ncsli += ns;
                    }
                    if (nd = DirSort.Size()) {          // When we have some sub-directories with slide(s), ...
                        if (nd > 1) DirSort.Sort();     // ... we the Sort them and ...
                        nwdir->SbDir( nd, DirSort.GetTable() ); // ... build the Directory list of sub-directory-ies.
                        ncdir += nd;
                    }


                    if (lvl > 0) {
                        SliSort.Pop();                  // Pop the slides and directory sort list.
                        DirSort.Pop();


                        Dsc.Set( CNTX_FNAME );          // We read the context file when its existing.
                        idp = nwdir->ReadCntxFile( Dsc.Path() );
                        if (!idperr) idperr = idp;      // To signal a nesting level error.
                        Dsc.Rem();

                        nwdir->LDeep( lvl );            // Set the Nesting level of directory ...
                        if (mlvl < lvl) mlvl = lvl;     // ... and update the maximum.
                        nwdir->CnSli( ncsli );          // Update the total count of slides for the current directory.
                        DirSort.NewEntry( nwdir );      // Put it in the sort list of owner Directory.
                    }


////    Attention : A ce niveau le champ owner_ (udeep_ ne sert à rien pour le moment) n'est pas défini
////    car le directory propriétaire n'est pas encore créé. De même, les identificateurs de cache d'image
////    ne peuvent être définis qu'une fois la construction complète du graphe réalisée.
////    ... Et il y a aussi le champ IIde_t ident_ qui être manipulé pas IIde_t Ident() et void Ident( IIde_t ).
////    Enfin le champ *stext_ des DirEntry ne sert à rien !! .
////
////    Caution: At this point, the owner_ field (udeep_ is currently useless) is not defined because the owner
////    directory has not yet been created. Similarly, image cache identifiers can only be defined once the graph
////    has been fully constructed.
////    ... And there's also the IIde_t ident_ field, which can be manipulated by IIde_t Ident() and
////    void Ident( IIde_t ).
////    Finally, the *stext_ field of the DirEntry is useless!
////
                }
            break;

            case SrvDir::Scan_Stop:     // Begin of a directory or sub-directory.
            default: irp = 0;
        } // switch ...
    } // While (irp);





    return nwdir;
    // We must complete the scan.

} // static DirEntry * ScanFoundDir( const char * name ).




static VolEntry * CreateVolume( const char    * path,
                                DirEntry      * root,
                                int           newdir,
                                VolRef * vref = NULL
                               )

// Function to create a new Volume of slides (diapositives).
// The name argument is the volume root directory.
// If <newdir> is true (!=0), a new volume directory is created
// with the path <name>. else the directory access is checked
// for read access.
//
{
  int            flg = 1;
  VolEntry  * vol = NULL;

  if (newdir) { // We create a new slides volume directory.
    flg = fl_mkdir( path, 0 );
  } else {      // We use an existing slides volume directory.
    flg = fl_access( path, R_OK );
  }

  if (!flg) {
    // The creator of VolEntry put the Volume reference in the table OpenVolTable.
    vol = new VolEntry( path, root, vref );     // Allocate the Volume Entry.
    // Now, complete the volume initialization.
    vol->VRoot( root );
    vol->TDeep( maxi_deep );
    vol->TnDir( curr_tdir );
    vol->TnSli( curr_tsli );
  }
  maxi_deep = 0;        // Reset the deep maximum for a next volume creation.
  curr_tsli = 0;
  curr_tdir = 0;
  return vol;
} // CreateVolume( const char * name, DirEntry * root, VolRef * vref = NULL ).



static void SetVolumeIdents( VolEntry *vol )
// Set the Unique integer identifier for a complete volume.
{
  if (vol) {
    vol->SetVolIdents();    // Setup the volume identifier.
    if (IIdeOverflow)  {
      if (IIdeOverflow&1) fl_alert( "\n  * DiaViewer : Too many slides.\n" );
      if (IIdeOverflow&2) fl_alert( "\n  * DiaViewer : Too many slides'directories.\n" );
      if (IIdeOverflow&4) fl_alert( "\n  * DiaViewer : Too many slides'volumes.\n" );
      // Actions correctrices !!!

    }
  }
} // static void SetVolumeIdents( VolEntry *vol ).



int CreateVolumeTree( VolRef * vref )
// Scan and create the diapositives (Slides) tree list.
// The total number of found diapositives is returned (<0 on error or 0 for empty slide volume).
// The procedure return this OpenVolTable number index of the volume or -1 on fatal error.
//
{
    DirEntry            * root;
    VolEntry            *  vol;
    const char       * dirfnam;

    dirfnam = vref->path;
    CurrPath.Clear();           // Force new path to be built.
    CurrPath.Set( dirfnam, 1 ); // Set PathString initial value for a Directory.
    maxi_deep              = 0; // Initialize the directory maximum deep ...
    deep_error             = 0; // ... and deep error flag.

    root = ScanFoundDir( dirfnam );     // Scan the directory.
    // Here the PathString is restored at dirfnam initial value.

//  printf( " DCM fdir Root? %d\n", root? 1 : 0 );

    if (root) {
        vol = CreateVolume( dirfnam, root, 0, vref );
        vol->SetVolContext();           // Set the Volume specific data.
        SetVolumeIdents( vol );         // Set all vol/dir/slide integer identifiers.
        SlidePrg * prg = new SlidePrg( vol );

        prg->Display();

        vol->RelPrg( (void*)prg );
    } else vol = NULL;

    CurrPath.Clear();                   // Clear the Path.

    if (deep_error) {
        // Positive value : The volume include an other one..
        // Negative value : The volume is include in an other one.
        fl_alert(
            " *** DiaViewer Overlay Error on the volume :\n Path = \"%s\"\n Read only use recommanded",
            vol->VRoot()->FName()
        );
    }
    LogF.Write( " Open Volume %s : ID %3d, Path = %s\n",
                (vref->name)?vref->name:"?", vref->iide, (vref->path)?vref->path:"<>" );

    return (root)? OpenVolTable.TabUse(): -1;
} // static int CreateVolumeTree( VolRef * vref ).








static void CleanWindowsTable( int * idt )
// To suppress the window of volume reference # idt.
// idt is the OpenVolTable indexies table for each VolToOpen table element.
//
{
    int   ip,   ir,   iv,  iw,   nv;
    int * jdt;

    nv = OpenVolTable.TabUse();                 // Get the number of opened slides volumes.
    // Create an init the volume table use.
    jdt = new int[nv];
    for(iv = 0; iv < nv; iv++) jdt[iv] = 0;

//printf( " Clr A idt[] : %d, %d\n", idt[0], idt[1] );
    if (WinTable.size) {
        // Loop for examine the View(s) to create table and ...
        // ... flags each window without opened volume reference.
        for( iw = 0; iw < WinTable.size; iw += 4) {
            ip = WinTable.tab.i[iw] - 1;        // Get the original VolToOpen table index of this View ...
            iv = idt[ip];                       // ... and the related OpenVolTable index (or -1).
//printf( " Clr B L iw=%d, ip=%d, iv=%d, jdt[iv]=%d\n", iw, ip, iv, jdt[iv] );
            if (iv < 0) {                       // When we have a volume Open Error ...
                iv = -iv - 1;                   // Restore the Opened Volume index.
                if (iv < 1 && nv > 0) iv = 1;   // Select an opened volume when possible.
                if (jdt[iv] > 1)                // We should supress this View.
                    WinTable.tab.i[iw]   = -1;  // Mark window to suppress.
                else {
                    WinTable.tab.i[iw+1] =  0;
                    WinTable.tab.i[iw+2] = -1;  // Force the initial position to be ...
                    WinTable.tab.i[iw+3] = -1;  // ... the position saved in Volume context.
                }
            } else {
                jdt[iv]++;                      // Flag for normal View Volume ref.
            }
            WinTable.tab.i[iw+0]   = iv;        // Set the OpenVolume index volume.
//printf( " Clr M L iw=%d, iv=%d, jdt[iv]=%d\n", iw, iv, jdt[iv] );
//printf( " Clr M LW Win : %d, %d, %d, %d\n", WinTable.tab.i[iw+0],
//          WinTable.tab.i[iw+1], WinTable.tab.i[iw+2], WinTable.tab.i[iw+3] );
        }
    }

//printf( " Clr T\n" );
    // View scan to compress window table.
    ir = 0;
    for(ip = 0; ip < WinTable.size; ip) {
        if (!(ip % 4) && (WinTable.tab.i[ir] < 0)) ir += 4;
        if (ir != ip) WinTable.tab.i[ip] = WinTable.tab.i[ir];
        ip++; ir++;
    }
    WinTable.size = ip;                         // Adjust the Window view table size.
//printf( " Clr Z\n" );
} // static void CleanWindowsTable( int * idt ).




//
// Initial process to open all volume as specified in configuration file.
//



static void VolVersionTransfert()
// Manage the transition with the verions 1.2. where the volume path list is ...
// ... keep in the specific file ~/.DiaViewer/DVW_Vol_List.Dvl .
{
    int        ij,  ll;
    char          * vp;

    ij = 0;
    ll = VolP2Open.size;                // Get the number of volume to open.
    VolToOpen.tab.i = new int[ll];      // Allocate the VolToOpen table.
    VolToOpen.size = ll;
    for(int ii = 0; ii < ll; ii++) {    // For each volume to open ...
        vp = VolP2Open.tab.s[ii];       // Get the Volume path.
        if (vp) {                       // Protection for empty !
            VolP2Open.tab.s[ii] = NULL; // To previous a string delete on VolP2Open delete.
            VolList.Append( vp );       // Allocate a volume reference and set it..
            VolToOpen.tab.i[ij++]=ii+1; // Set this volume for automatic open.
        }
    }
    delete[] VolP2Open.tab.i;           // Delete the old standard volume to open list.
    VolP2Open.size = 0;
} // static void VolVersionTransfert().



void OpenVolumeQuList()
// Scan the volume to open table VolToOpen and open each ones.
//
{
    int    nvol, ide, idn, idv;
    VolEntry     * svol = NULL;
    const char  * path, * vnam;
    int                  * idt;
    int     ie,  ii, oldfl = 0;
    VolRef               * rec;
    VolEntry           ** vlst;

    svol = MemVolume();                 // Create the memory volume.

    if (VolP2Open.size) {
        oldfl = 1;
        VolVersionTransfert();          // When old version setup we build the new VolList ...
    }
    else {
        ie = VolList.Read();            // ... else we get the actual Volume list.
        if (!VolList.ListSize()) {      // When the list of volume is empty ...
            VolMN_StartDef();           // Request the User to define a first Slides Volume.
            if (VolList.ListSize()) {   // If it is OK, we flag it for open.
                VolToOpen.tab.i = new int[1];
                VolToOpen.size = 1;
                VolToOpen.tab.i[0] = 1;
            }
        }
    }

    // Here, the list of known slides volume (reference) is in the memory list VolList.

    if (VolList.ListSize()) {           // For a minimum of One Volume is defined ...
        if (!VolToOpen.size) {          // Some volume are defined but no Volume selected to be open.
            VolToOpen.tab.i=new int[1]; // We take the first one.
            VolToOpen.size = 1;
            // Get the integer identifier from the first Slide Volume Reference.
            VolToOpen.tab.i[0] = VolList.IdxVolRef( 0 )->iide;
        }
        if (!WinTable.size) {           // When we have no window(s) table, we create one ...
            WinTable.tab.i=new int[4];  // ... for a first window to display the first opened volume.
            WinTable.size = 4;
            WinTable.tab.i[0] = 1;      // Here, we give the index in the VolToOpen table.
            for(ii = 1; ii < 4; ii++)  WinTable.tab.i[ii] = 0;
        }
    }

    // Now, the table VolList is the Known Volume reference list, ...
    // ... and the VolToOpen is the list of volume to open index in VolList.

    idt = new int[VolToOpen.size + 1];  // Table of OpenVolTable from VolToOpen table. Maximum possible !
    for(ii = 0; ii <= VolToOpen.size; ii++) idt[ii] = 0;
    idn = 0;                            // Init the count for open volume error(s).

    if (nvol = VolToOpen.size) {        // Get the number of Volume to open.
        for(ii = 0; ii < nvol; ii++) {
            ide = VolToOpen.tab.i[ii];  // Get a Volume integer identifier and then locate ...
            rec = VolList.Locate( ide );        // ... and get its volume reference record.
            if (rec) {
                idv = CreateVolumeTree( rec ) - 1;
                // idv is the index (in OpenVolTable) of the new slide volume ...
                // ... or -1 when an open error occurs.
                if (idv < 0) { // The Slides Volume loading is not a success.
                    // Send an Alert message and remove the Volume.
                    fl_alert( "Open Slide Volume Error %d :\n%s", idv, ErrMsg );
//                  fl_alert( "Open Slide Volume Error %d : \n path = %s with message\n *** %s\n",
//                            -idv, path );
                    // Select the previous opened volume or memory volume.
                    idv = -(OpenVolTable.TabUse());
                    idn++;              // To signal some volume open error.
                }
            }
            idt[ii] = idv;              // Keep corresponding index in OpenvolTab.
        }
    }
    if (idn) {
      ie = fl_choice( " *** DiaViewer cannot get access to some defined slides volume(s) :\n *** %s\n *** %s",
                      "Try to continue", "Stop DiaViewer", 0,
                      "You can stop DiaViewer (to take some preventive actions (ex: mount a device),",
                      "or try to continue the DiaViewer execution (but some parts of setup can be lost.) :");
      if (ie) exit( 1 );
    }
    delete[] VolToOpen.tab.i;  // Now we can free the Volume to open table and we protect ...
    VolToOpen.tab.i = NULL;    // ... ourselves from possible deallocation from a garbage collector.
//printf( " M idt[] %d : %d, %d\n", VolToOpen.size, idt[0], idt[1] );

    if (idn) CleanWindowsTable( idt );  // When some open error was detected.
//printf( " R\n" );

  // When we use the old DiaViewer env., we create the first Volume list.
    if (oldfl) {
        VolList.CheckAllNames();
/*      nvol = OpenVolTable.TabUse();
        vlst = (VolEntry**)OpenVolTable.GetObjs();
        for(ii = 1; ii < nvol; ii++) {
            vnam = vlst[ii]->VName();
            if (!vnam) vnam = VolList.DefName();
            vlst[ii]->VRefer()->name = strdup( vnam );
        }
*/
        VolList.Write();
    }
    delete[] idt;
    delete[] VolToOpen.tab.i;

    for(ii = 1; ii <= nvol; ii++) {
        rec = VolList.Locate( ii );
        LogF.Write( " Find Volume <%s> : %02d, \"%s\"",
                    (rec->name) ? rec->name : "*", rec->iide,
                    (rec->path) ? rec->path : "*" );
    }
    IniSelSlide = NULL;
} // void OpenVolumeQuList().



