//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//
//


//
// Define a user adjustable FTGL Layout for freetype2 font.
//
// This module is very close to the FTSimpleLayout of FTGL,
// This module allows you to define layouts with a wide variety of shapes.
// To do this, you simply need to define two small virtual functions that
// correspond to the desired shape of the right and left edges of the layout.
//
// The form of these functions is :
//
// por le bord droit BLine et pour le bord gauche ELine :
//   virtual float BLine( float ) = 0;
//   virtual float ELine( float ) = 0;
//
//


#include <stdio.h>
#include <string.h>

#include <ctype.h>
#include <wctype.h>
/*
#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_Gl_Window.H>
*/
#include <FTGL/ftgl.h>

#include <FTGL/sys/FTInternals.h>
#include <FTGL/sys/FTUnicode.h>

//#include <FTGL/sys/FTGlyphContainer.h>



#include "Fancy_Layout.h"



#define MAX_TEXT_SIZE   4096
#define NoTextLengthTest


//
//
//




int  Fancy_Layout::SetFont( FTFont * ft )
{
    crx_ = cry_ = crz_ = 0.0;
    fnt_ =  ft;
    if (fnt_) {
        asc_ = fnt_->Ascender();
        dsc_ = fnt_->Descender();
        lsp_ = 1.0;
        ali_ = fnt_->Advance( "    " ); // space for alinea = 4 spaces.
        return 1;
    } return 0;
} // void Fancy_Layout::SetFont( FTFont * ft ).



template <typename T>
inline FTBBox Fancy_Layout::BBoxI( const T* string, const int len, FTPoint position )
{
    FTBBox tmp;

    WrapText( string, len, position, 0, &tmp );
    return tmp;
}


FTBBox Fancy_Layout::BBox(const char *string, const int len, FTPoint position )
{
    return BBoxI( string, len, position );
}


FTBBox Fancy_Layout::BBox( const wchar_t *string, const int len, FTPoint position )
{
    return BBoxI( string, len, position );
}


template <typename T>
inline void Fancy_Layout::RenderI( const T *string, const int len, FTPoint position, int renderMode )
{
    pen_ = FTPoint( 0.0f, 0.0f );
    WrapText( string, len, position, renderMode, NULL );
}


void Fancy_Layout::Render( const char *string, const int len, FTPoint position, int renderMode )
{
    RenderI( string, len, position, renderMode );
}


void Fancy_Layout::Render( const wchar_t* string, const int len, FTPoint position, int renderMode )
{
    RenderI( string, len, position, renderMode );
}


inline float Fancy_Layout::BXI( float y )
{
    float x, t;

    x = BX_( y + asc_, UD_ );
    if  ((t = BX_( y - dsc_, UD_ )) > x) return t; else return x;
} // Interface of BLine.



inline float Fancy_Layout::EXI( float y )
{
    float x, t;

    x = EX_( y + asc_, UD_ );
    if  ((t = EX_( y - dsc_, UD_ )) < x) return t; else return x;
} // Interface of virtual ELine.



template <typename T>
inline void Fancy_Layout::WrapTextI( const T *buf, const int len,
                                     FTPoint position, int renderMode, FTBBox *bounds )
{   //  buf the string to render,
    //  len its lebgth of (< 0 default), all the string until null character.
    //  pos the position of coordinate origin in agreement with limits user functions in the layout plane.
    //
    FTUnicodeStringItr<T> breakItr( buf );
    FTUnicodeStringItr<T> lineStart( buf );
    float   nextStart  =   0.0, // -- nextStart
            breakWidth =   0.0, // Width of the line up ti the last word break.
            currentWidth = 0.0, // Width of all characters on the current line.
            prevWidth,          // Width of all characters but the current glyph.
            wordLength =   0.0, // Length of the block since the last break char.
            lineLength =   0.0; // Length of each line.  LineLength can be changed for each line.
    int     charCount =      0, // Number of characters so far on the line.
            breakCharCount = 0; // Number of characters before the breakItr (Glyph/char).

    float           glyphWidth,
                       advance,
            cry,    bex,   enx, // Abscissa of the start and end of each line.
            minx,         maxx;

    FTBBox         glyphBounds;

    if (!(BX_ && EX_ && fnt_)) return;

    // Reset the pen position.
    pen_.Y( cry_ = 0.0 );

    // If we have bounds mark them invalid.
    if (bounds)
    {
        bounds->Invalidate();
    }

    bex = BX_( cry_, UD_ );     // P.W.: Get the position of the begin of  ...
    enx = EX_( cry_, UD_ );     // P.W.: ... first line and its end of ...
    lineLength    =  enx - bex; // P.W.: ...  first layout line and its length.
    crx_ = bex;

    minx = bex; maxx = enx;

    pen_.X( bex );              // P.W. Set the pen at the begin of the first line.

    FTUnicodeStringItr<T> prevItr( buf );
    for (FTUnicodeStringItr<T> itr( buf ); *itr; prevItr = itr++, charCount++)
    {
        if (minx > bex) minx = bex;
        if (maxx < enx) maxx = enx;

        // Find thewidth of the current glyphs
        glyphBounds = fnt_->BBox( itr.getBufferFromHere(), 1 );
        glyphWidth  = glyphBounds.Upper().Xf() - glyphBounds.Lower().Xf();

        advance = fnt_->Advance( itr.getBufferFromHere(), 1 );
        prevWidth = currentWidth;

        // Compute the width of all glyphs up to the end of buf[i].
        currentWidth = nextStart + glyphWidth;
        // Compute the position of the next gliph.
        nextStart += advance;

        //See if the current character is a space, a break or a regular character.
        if ((currentWidth > lineLength) || (*itr == '\n'))
        {
            float remainingWidth;

            // A non whitespace character has exceeded the line length. Or a
            // newline character has forced a line break.  Output the last
            // line and start a new line after the break character.
            // If we have not yet found a break, break on the last character
            if (breakItr == lineStart || (*itr == '\n'))
            {
                // Break on the previous character
                breakItr = prevItr;
                breakCharCount = charCount - 1;
                breakWidth = prevWidth;
                // None of the previous words will be  carried to the next line
                wordLength = 0;
                // If the current character is a newline discard its advance
                if (*itr == '\n') advance = 0;
            }

            if (*itr == '\n' && aln_ == FTGL::ALIGN_JUSTIFY) remainingWidth = 0;
                                                        else remainingWidth = lineLength - breakWidth;

            // Render the current substring
            FTUnicodeStringItr<T> breakChar = breakItr;
            // move past the break character and don't count it on the next line either
            ++breakChar; --charCount;
            // If the break character is a newline do not render it
            if (*breakChar == '\n')
            {
                ++breakChar; --charCount;
            }

            if (breakCharCount >= 0)
            {
                OutputWrapped( lineStart.getBufferFromHere(), breakCharCount,
                               // breakItr.getBufferFromHere() -lineStart.getBufferFromHere()
                               position, renderMode, remainingWidth, bounds );
            }

            // Store the start of next line
            lineStart = breakChar;

            // TOTO: Is Height() the right value here?
            cry_ -= fnt_->LineHeight() * lsp_;  // PW lsp_ <--> lineSpacing

            bex = BX_( cry_, UD_ );    // P.W.: Get the position of the begin and end of ...
            enx = EX_( cry_, UD_ );
            crx_ = bex;
            lineLength   =  enx - bex; // P.W.: ...  first layout line and its length.
            pen_ = FTPoint(crx_, cry_);// P.W. Set the pen at the begin of the first line.

            // The current width is the width since the last break
            nextStart = wordLength + advance;
            wordLength += advance;
            currentWidth = wordLength + advance;
            // Reset the safe break for the next line.
            breakItr = lineStart;
            charCount -= breakCharCount;
        }
        else if (iswspace( *itr ))
        {
            // This is the last word break position
            wordLength = 0;
            breakItr = itr;
            breakCharCount = charCount;

            // Check to see if this is the first whitspace character in a run
            if (buf == itr.getBufferFromHere() || !iswspace( *prevItr ))
            {
                // Record the width of the start of the block
                breakWidth = currentWidth;
            }
        }
        else
        {
            wordLength += advance;
        }
    }

    float remainingWidth = lineLength - currentWidth;
    // Render any remaining text on the last line
    // Disable justification for the last row
    if (aln_ == FTGL::ALIGN_JUSTIFY) {
        aln_ = FTGL::ALIGN_LEFT;
        OutputWrapped( lineStart.getBufferFromHere(), -1, position, renderMode,
                       remainingWidth, bounds );
        aln_ = FTGL::ALIGN_JUSTIFY;
    } else {
        OutputWrapped( lineStart.getBufferFromHere(), -1, position, renderMode,
                       remainingWidth, bounds );
    }
} // inline void Fancy_Layout::WrapText( const char *buf, const int len, FTPoint pos, int rdm, FTBBox * bnd ).



void Fancy_Layout::WrapText( const char *buf, const int len,
                             FTPoint position, int renderMode, FTBBox *bounds )
{
    WrapTextI(buf, len, position, renderMode, bounds);
}


void Fancy_Layout::WrapText( const wchar_t* buf, const int len,
                             FTPoint position, int renderMode, FTBBox *bounds )
{
    WrapTextI( buf, len, position, renderMode, bounds );
}



template <typename T>
inline void Fancy_Layout::OutputWrappedI( const T *buf, const int len, FTPoint position, int renderMode,
                                          const float remaining, FTBBox *bounds )
{
    float distributeWidth = 0.0;
    // Align the text according as specified by Alignment
    switch (aln_)
    {
        case FTGL::ALIGN_LEFT:
            pen_.X( crx_ ); // pen_.X(0);
            break;
        case FTGL::ALIGN_CENTER:
            pen_.X( crx_ + remaining / 2 ); // pen_.X(remaining / 2);
            break;
        case FTGL::ALIGN_RIGHT:
            pen_.X( crx_ + remaining ); // pen_.X(remaining);
            break;
        case FTGL::ALIGN_JUSTIFY:
            pen_.X( crx_ ); // pen_.X(0);
            distributeWidth = remaining;
            break;
    }

    // If we have bounds expand them by the line's bounds, otherwise render
    // the line.
    if(bounds)
    {
        FTBBox temp = fnt_->BBox( buf, len );

        // Add the extra space to the upper x dimension
        temp = FTBBox(temp.Lower() + pen_,
                      temp.Upper() + pen_ + FTPoint(distributeWidth, 0));

        // See if this is the first area to be added to the bounds
        if(bounds->IsValid()) {
            *bounds |= temp;
        } else {
            *bounds = temp;
        }
    }
    else
    {
        RenderSpace( buf, len, position, renderMode, distributeWidth );
    }
}



void Fancy_Layout::OutputWrapped( const char *buf, const int len, FTPoint position, int renderMode,
                                  const float remaining, FTBBox *bounds )
{
    OutputWrappedI( buf, len, position, renderMode, remaining, bounds );
}



void Fancy_Layout::OutputWrapped( const wchar_t *buf, const int len, FTPoint position, int renderMode,
                                  const float remaining, FTBBox *bounds )
{
    OutputWrappedI( buf, len, position, renderMode, remaining, bounds );
}





template <typename T>
inline void Fancy_Layout::RenderSpaceI( const T *string, const int len, FTPoint position,
                                        int renderMode, const float extraSpace )
{
    (void)position;

    float space = 0.0;

    // If there is space to distribute, count the number of spaces
    if(extraSpace > 0.0)
    {
        int numSpaces = 0;

        // Count the number of space blocks in the input
        FTUnicodeStringItr<T> prevItr(string), itr(string);
        for(int i = 0; ((len < 0) && *itr) || ((len >= 0) && (i <= len));
            ++i, prevItr = itr++)
        {
            // If this is the end of a space block, increment the counter
            if((i > 0) && !iswspace(*itr) && iswspace(*prevItr))
            {
                numSpaces++;
            }
        }

        space = extraSpace/numSpaces;
    }

    // Output all characters of the string
    FTUnicodeStringItr<T> prevItr(string), itr(string);
    for(int i = 0; ((len < 0) && *itr) || ((len >= 0) && (i <= len));
        ++i, prevItr = itr++)
    {
        // If this is the end of a space block, distribute the extra space
        // inside it

        if((i > 0) && !iswspace(*itr) && iswspace(*prevItr))
        {
            pen_ += FTPoint(space, 0);
        }

        pen_ = fnt_->Render(itr.getBufferFromHere(), 1, pen_, FTPoint(), renderMode);
    }
}


void Fancy_Layout::RenderSpace( const char *string, const int len, FTPoint position,
                                int renderMode, const float extraSpace )
{
    RenderSpaceI( string, len, position, renderMode, extraSpace );
}


void Fancy_Layout::RenderSpace( const wchar_t *string, const int len, FTPoint position,
                                int renderMode, const float extraSpace )
{
    RenderSpaceI( string, len, position, renderMode, extraSpace );
}



//
// end of <PW-Id>.
//

