//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Ranking Context environment.
//
//

#ifndef DIAVIEWER_RCT_H
#define DIAVIEWER_RCT_H



#include "DiaViewer_DIA.h"



class DirRefer {

private:

    typedef struct Sli_Refer {
        struct Sli_Refer     * rfs_nxt_; // Pointer to the next slide reference.
        char                 * rfs_nam_; // File name of the new slide file.
        SliEntry             * rfs_sli_; // Slide descriptor pointer in the old slide volume.
    } SliRefer;


    DirRefer       * rfd_own_; // Owner directory reference (Null for the root volume).
    SliRefer       * rfd_frs_, // Pointer to the first and last slide references,
                   * rfd_lst_;
    int              rfd_nsl_; // Number of slide reference in the directory reference.

public:

    DirRefer( DirRefer * );                     //
    DirRefer * DelRef( DirRefer * );
    void AddSliRef( const char *, SliEntry * );
    void WriteDirCntxFile( int, const char * );

};



#endif

//
// end of <PW-Id>.
//
