//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for slide Preview.
//


#include <string.h>
#include <errno.h>

#include <FL/Fl.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Gl_Window.H>

#include "DiaViewer_PRV.h"

#include "DiaViewer_PRV_UI.h"




#define DEF_SIZE    14          // Default font size for slide text/Comment.






#ifdef BIG_WIN
#   define MAX_WIN_BD 2520
#   define MAX_WIN_SD 2164
#else
#   ifdef LARGE_WIN
#       define MAX_WIN_BD 1260
#       define MAX_WIN_SD 1082
#   else
#       define MAX_WIN_BD  898
#       define MAX_WIN_SD  630
#   endif
#endif



//
// This class is inspired of the the class FontDisplay in the
// source file FLTK test/fonts.cxx of the FLTK Source kit.
//


Prv_View * Prev_View;

static Prv_View_UI * PreView_UI = 0;






SliT_Display::SliT_Display( int x, int y, int w, int h, const char * L ) :
                            Fl_Multiline_Input( x, y, w, h, L )
{
    font = 0;
    size = DEF_SIZE;
} // Text_Display::Text_Display(Fl: Boxtype,
  //                       int b, int x, int y, int w, int h, const char * L ).


void SliT_Display::draw()
{

} //void SliT_Display::draw().





Fl_RGB_Image * Prv_View::BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh )
{
  int       src_rsz,   dst_rsz,
            src_wid,   src_hig,
            dst_siz,  ira, ipc,
                            pp;

  uchar   * src_cra, * src_cco,
          * dst_cra, * dst_cco;
  uchar   * src_map, * dst_map; // Define the source and destination pixel map pointers.

  Fl_RGB_Image         * flimg;


  pp            =     src->P(); // Get the pixel size and raw alignement mask.
  src_wid       =     src->W(); // Get the original width (in pixels) of image.
  src_hig       =     src->H(); // Get the original hight (in pixels) of image.
  src_map       =   src->Map(); // Get the source (src) image pi=xel map.

  if (ww > src_wid) ww = src_wid;
  if (xx < 0) xx = 0;
  else if (xx + ww > src_wid) xx = src_wid - ww;

  if (hh > src_hig) hh = src_hig;
  if (yy < 0) yy = 0;
  else if (yy + hh > src_hig) yy = src_hig - hh;

  src_rsz       =   pp*src_wid; // Get the original size (in byte) of image raws.
  dst_rsz       =        pp*ww; // Get the size (in byte) of final pixel map raws.
  dst_siz       =   dst_rsz*hh; // Get the final pixel map image size.

  dst_map = new GLubyte[dst_siz];       // Allocate the print map and ...

  src_cra = src_map + yy*src_rsz+xx*pp; // Set the src current raw -> first pixel of the src image (first dst pixel) (at image bottom).
  dst_cra = dst_map + dst_siz;          // dst_raw -> first not existing dst pixel map raw (below the bottom image).
  for(ira = 0; ira < hh; ira++) {
    dst_cra -= dst_rsz;                 // dst_cra -> first pixel of src current raw (starting from bottom raw).
    dst_cco  = dst_cra;                 // dst_cco = dst_cra to init the dst raw filling.
    src_cco  = src_cra;                 // src_cco -> first byte to copy in the destination.
    for(ipc = 0; ipc < dst_rsz; ipc++)  // Loop to fill all pixels (dst_rsz bytes) of the raw.
      *(dst_cco++) = *(src_cco++);
    src_cra += src_rsz;                 // src_cra -> first pixel of dst for next raw (starting from the top raw).
  }

  flimg = new Fl_RGB_Image( dst_map, ww, hh, pp, dst_rsz );
  flimg->alloc_array = 1;

  return flimg;
} // static Fl_Image * Prv_View::BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh ).


/*
void Prv_View::Ini_Setup()
{


} // void Prv_View::Ini_Setup().
*/



void Prv_View::Load( DiaViewer_GL * wgl )
{
    int x, y, w, h;

    curvol_ =    wgl->Curr_Vol;
    cursli_ =    wgl->Curr_Sli;
    imgpos_ =       Image_C_Up;
    txtprp_ =             0.05;
    margin_ =                5;
    curtxt_ =  cursli_->Text();
    nt_     =  cursli_->Note();
    ch_     =  cursli_->Chap();
    fl_     =  cursli_->Film();
    sn_     =  cursli_->Numb();

    wgl->ImgSizes( x, y, w, h );

    curimg_ = BuildImage( cursli_, x, y, w, h );
    txtchg_ =                0;
} // void Prv_View::Load( DiaViewer_GL * wgl ).




void Prv_View::LoadImage( Fl_RGB_Image * img )
{
#if FLTK_ABI_VERSION >= 10304
    W_img->image( img );
    img->scale( w_img->w(), w_img->h() );
#else
    if (img->w() <= W_img->w() && img->h() <= W_img->h()) W_img->image( img );
    else {
        float fw = img->w() /float( W_img->w() );
        float fh = img->h() /float( W_img->h() );
        float f  = fw > fh ? fw : fh;
        W_img->image( img->copy( int( img->w()/f ), int( img->h()/f )));
//      img->release(); // Pas de release pour Fl_RGB_Image.
    }
#endif
    W_img->label( NULL );
//  W_img->redraw();
} // void Prv_View::LoadImage( Fl_RGB_Image * ).



Prv_View::Prv_View( DiaViewer_GL * wgl )
{
    PreView_UI = new Prv_View_UI( this, wgl->w(), wgl->h() );

    W_grp   = PreView_UI->w_grp;
    W_img   = PreView_UI->w_img;
    W_txt   = PreView_UI->w_tx1;

    g_w_    = W_grp->w();
    g_h_    = W_grp->h();

    Geometry();                                // Compute the Displays geometry.

    Load( wgl );

    LoadImage( curimg_ );

//  prvusi_->w_img->value( cursli_ );

    W_txt->value( curtxt_ );

    PreView_UI->show( svargc, svargv );

//  prvusi_->show();


} // Prv_View::Prv_View().


void Prv_View::GiveUp()
{
    PreView_UI->close();
    delete Prev_View;
    Prev_View = 0;
} // void Prv_View::GiveUp().



void Prv_View::ToPrint()
{


} // void Prv_View::ToPrint().



void Prv_View::ChangeFont()
{


} // void Prv_View::ChangeFont().



void Prv_View::SliImagePos( Image_Position ip )
{
    if ( ip != imgpos_ ) {
        switch (ip) {
            case Image_C_Left:
            case Image_C_Right:

            break;

            case Image_C_Up:
            case Image_C_Down:
            default:

            break;
        }
        imgpos_ = ip;
    }
} // void Prv_View::SliTextPos( int ).



void Prv_View::Geometry()
{
    int  eia,  paa,
         maa,  itw,  ith;
    float   fx, fy, fs, fm, fp;

    printf( " Geometry is called\n"); fflush( stdout );

    fp = 1.0 - txtprp_;
    fx = float( g_w_ ) / i_w_; fy = float( g_h_ ) / i_h_;
    fs = fx < fy ? fx : fy;
    // We get the maximum scale (with possible too small surface for text).
    eiw_ = round( fs*i_w_ ); eih_ = round( fs*i_h_ );
    paa = g_w_*g_h_;
    if (curtxt_ && curtxt_[0]) { itw = eiw_ + margin_; ith = eih_ + margin_; }
                          else { itw = eiw_; ith = eih_; }
    eia = itw*ith;
    // When the place is too small for text ...
    if (curtxt_ && eia > round( fm = fp*paa )) { // ... we reduce the image sizes.
        fm = sqrt( fm / eia );
        eiw_ *= fm; eih_ *= fm;
    }

    if (imgpos_ & Image_Center) {               // For image centered on X or y.
        switch (imgpos_) {
            case Image_C_Left:                  // Image at Left (centered on y).
                tx1_ =        itw; ty1_ =          0;
                tw1_ = g_w_ - itw; th1_ =       g_h_;
                eix_ = 0;
                eiy_ = (g_h_ - eih_)/2;
            break;

            case Image_C_Down:                  // Image on Bottom (centered on x).
                tx1_ =          0; ty1_ =          0;
                tw1_ =       g_w_; th1_ = g_h_ - ith;
                eix_ = (g_w_ - eiw_)/2;
                eiy_ =          0;
            break;

            case Image_C_Right:                 // Image at Right (centered on y).
                tx1_ =          0; ty1_ =          0;
                tw1_ = g_w_ - itw; th1_ =       g_h_;
                eix_ =          0;
                eiy_ = (g_h_ - eih_)/2;
            break;

            case Image_C_Up:                    // Image on Top (centered on x).
            default:
                tx1_ =          0; ty1_ =        ith;
                tw1_ =       g_w_; th1_ = g_h_ - ith;
                eix_ = (g_w_ - eiw_)/2;
                eiy_ =          0;
            break;
        }
    } else {
        if (imgpos_ & Image_Up) {               // Image on Top.
            eiy_ = 0; ty1_ = ith; th1_ = g_h_ - ty1_;
            if (imgpos_ & Image_Left) {         // Image at Top and Left.
                eix_ = 0; tx1_ = g_w_ - itw; tw1_ = g_w_ - tx1_;
            } else {                            // Image at Top and Right.
                eix_ = g_w_ - eiw_; tx1_ = 0; tw1_ = g_w_ - itw;
            }
            tx2_ = 0; ty2_ = g_h_ - ith; tw2_ = g_w_; th2_ = g_h_ - ith;
        } else {                                // Image on bottom.
            tx1_ = 0; ty1_ = 0; tw1_ = g_w_; th1_ = g_h_ - ith;
            eiy_ = g_h_ - ith; ty2_ = th1_; th2_ = g_h_ - th1_;
            if (imgpos_ & Image_Left) {         // Image at Bottom and Left.
                eix_ = 0; tx2_ = itw; tw2_ = g_w_ - itw;
            } else {                            // Image at Bottom and Right.
                eix_ = g_w_ - eiw_; tx2_ = 0; tw2_ = eix_;
            }
        }
    }

} // void Prv_View::Geometry().


/*

static void Length_String( const char * str, Fl_Font fo, Fl_Fontsize sz, int &w, int &h )
{
    w = h = 0;
    fl_font( fo, sz );
    fl_measure( str, w, h );
} // static void length_string( char * str, Fl_Font fo, Fl_Fontsize sz, int &w, int &h ).



static const char * Text_Organizer( const char * text, Fl_Font fo, Fl_Fontsize sz, int t_w, int t_h  )
{
    static char buf[1024];

    int    w_w,  w_h,  r_w,  r_h,  m_h;
    int    nwd,  pwd,  nli,   ew,   ii;
    char             ch,           ech;
    const char * cch;
    int wtb[512];

    if (text && text[0]) {
        // Supress any head space characters.
        cch = text;
        while ((ch = *cch) && ch <= ' ') cch++;         // Skip any head space characters.

        // Try to use directly.
        Length_String( cch, fo, sz, w_w, w_h );
        if (w_w <= t_w && w_h <= t_h) return cch;       // Don't change the original string.'

        // Scan to delimite each word and each line.
        wtb[0] = 0; nwd = ii = nli = 0;
        while ((ch = *cch++) && ii < 1023) {
            if (ch <= ' ' || ch == '\n') {              // We are at the end of a word.
                if (!wtb[ii]) {                         // When a space is found and the current end of word ...
                    wtb[nwd++] = ii; wtb[nwd] = 0;      // ... was not find, we set it in wtb.
                }
                if (ch == '\n') nli++;                  // For end of line we update the line count.
            }
            buf[ii++] = ch;                             // We store the corrent char and continue.
        }
        if (!wtb[nwd]) wtb[nwd] = ii;                   // Set the position of end of last word.
        buf[wtb[nwd]] = 0;                              // Set the end of last word as the end of text.

        r_w = t_w; r_h = t_h;
        ii = 0;
        cch = buf; pwd = m_h = 0;
        while (ii < nwd) {                              // Loop an all words in the text.
            ew = wtb[ii]; ech = buf[ew];                // Save the end char of the current word ...
            buf[ew] = 0;                                // ... and simule a end of string.
            Length_String( cch, fo, sz, w_w, w_h );     // Get the sizes of the word (with some previous space).
            if (m_h < w_h) m_h = w_h;                   // Adjust the current line heigth.
            if (r_h > m_h) {                            // The vertical space exist.
                if (r_w > w_w) {                        // The horizontal space exist.
                    if (pwd) {                          // If it is not the first word of the line.
                        if (buf[pwd] == '\n')           // When the previous space char was end-of-line (eoln), ...
                            buf[pwd] = ' ';             // ... we replace it by a space
                    }
                    buf[ew] = ech;                      // We restore the original end of word char.
                    r_w -= w_w;                         // Update the reminded width.
                } else {                                // When the line is too long.
                    m_h = w_h;
                    if (r_h > m_h) {
                        buf[ew] = '\n';
                        r_w = t_w - w_w;
                        r_h -= m_h;
                    }
                }
            } else {
                buf[wtb[ii - 1]] = 0;                   // The space is full. Cut the output ...
                return 0;                               // ... send the overflow return.
            }
        }
        return buf;
    } return 0;
} // static char * Text_Organizer( const char * text, int tw, int th, char * buf, int * wtb ).







void Smp_Printer::Print_VueImage( Fl_Image * img, float pt )
{
    int  l_w,  l_h,  i_w,  i_h,
         b_x,  b_y,  b_w,  b_h,
         t_x,  t_y,  t_w,  t_h;

    float sx, sy, sc, fx, fy, fs;

    const char * txt;


    if (!img) return;

    // Adjust in the range 0.02 .. 0.30 the portion os window allocated to the text.
    if (utext_) {
        if (pt > 0.3) pt = 0.3;
        else if (pt < 0.02) pt = 0.02;
    } else pt = 0.0;

    // Start printer to know the paper sizes (and orientation).

    if (p_lpt.start_job( 1 )) return;

    i_w = img->w(); i_h = img->h();

    p_lpt.start_page();
    p_lpt.printable_rect( &g_w_, &g_h_ );

    // Measure the label size if it is defined.
    if (utitl_ && utitl_[0])
        Length_String( utitl_, ftitl_, fstitl_, l_w, l_h );
    else l_w = l_h = 0;

    if (pos_ < Smp_Default || pos_ > Smp_Right) pos_ = Smp_Default;

    // Set the size of window.
    if (g_w_ > g_h_) {                            // Lanscape orientation.
        w_w_ = MAX_WIN_BD; w_h_ = MAX_WIN_SD;
        if (pos_ == Smp_Default) pos_ = Smp_Down;
    } else {                                    // Portait orientation.
        w_w_ = MAX_WIN_SD; w_h_ = MAX_WIN_BD;
        if (pos_ == Smp_Default) pos_ = Smp_Left;
    }


    switch (pos_) {
        case Smp_Down: case Smp_Up:
            b_x = t_x = 0; t_w = w_w_; t_h = round( w_h_*pt );
            b_w = w_w_; b_h = w_h_ - t_h;
            sx = b_w / float( i_w ); sy = b_h / float( i_h );
            if (sx > sy) {
                sc = sx; b_h = round( sc * i_h );
                b_w = w_w_; t_h = w_h_ - b_h;
            } else {
                sc = sy; b_w = round( sc * i_w );
                b_x = (w_w_ - b_w)/2;
            }
            if (pos_ == Smp_Up) { t_y = 0; b_y = t_y + t_h; }
                           else { b_y = 0; t_y = b_y + b_h; }

        break;

        case Smp_Left: case Smp_Right:
//          b_y = t_y = l_h; b_h = t_h = w_h_;
            b_y = t_y =   0; b_h = t_h = w_h_;
            t_w = round( pt*w_w_ ); b_w = w_w_ - t_w;
            sx = b_w / float( i_w ); sy = b_h / float( i_h );
            if (sx > sy) {
                sc = sx; b_h = round( sc * i_h );
                b_y = (w_h_ - b_h)/2;
            } else {
                sc = sy; b_w = round( sc * i_w );
                t_w = w_w_ - b_w;
            }
            if (pos_ == Smp_Left) { t_x = 0; b_x = t_x + t_w; }
                             else { b_x = 0; t_x = b_x + b_w; }
        break;
    }

    txt = Text_Organizer( utext_, ftext_, fstext_, t_w, t_h );

    //
    // Now we can create the printer widget.
    //

    p_lpt.set_current();

    p_win = new Fl_Double_Window( w_w_, w_h_, utitl_ );
    p_win->labelfont( ftitl_ ); p_win->labelsize( fstitl_ );


    p_box = new Fl_Box( b_x, b_y, b_w, b_h );
    p_box->box( FL_THIN_DOWN_BOX );
    p_box->image( img );

    if (txt) {
        p_txt = new Fl_Multiline_Output( t_x, t_y, t_w, t_h );
        p_txt->textfont( ftext_ ); p_txt->textsize( fstext_);
        p_txt->color( color_ );
        p_txt->value( txt );
    }

    p_win->end();

    fx = p_win->decorated_w() / float( w_w_ );
    fy = p_win->decorated_h() / float( w_h_ );
    fs = fx > fy ? fx : fy;
    p_lpt.scale( 1/fs );

    p_lpt.print_widget( p_win );
//  p_lpt.print_window( p_win );
    p_lpt.end_page();
    p_lpt.end_job();

    Fl_Display_Device::display_device()->set_current();

    delete p_win;


} // Smp_Printer::Print( float pt ).


*/



int  Prv_View::Show_PreView( DiaViewer_GL * wgl )
{
    if (!Prev_View) {
        Prev_View = new Prv_View( wgl );


    } else
        fl_alert( " The pre-View is already actif" );

} // Prv_View::Show_PreView( DiaViewer_GL * wgl ).



/*
Prv_View::~Prv_View()
{


} // Prv_View::~Prv_View().
*/



void Prv_View::draw()
{
    printf( " Draw called.\n" );

} // void Prv_View::draw().





#ifdef MainDebug


Prv_View TestView();


int main( int argc, char ** argv )
{

    return Fl::run();

} // main( int argc, char ** argv ).


#endif

//
// end of <PW-Id>.
//
