//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a Default Slide Volume.
//

#include <stdio.h>
#include <string.h>

#include "DiaViewer_MVL.h"
#include "DiaViewer_PRG.h"

#include "DiaViewer_VOL.cdata"


static const int MaxImgNb = 5;

static  SliEntry  * FrstImg =     NULL, // First and last pointer to form  ...
                  * LastIMg =     NULL; // ... an internal slide list.
//


static  uchar * ImgTbl[] = {
  ImgBlk_00,
//ImgBlk_01,
  NULL
};



VolEntry * MemVolume()
//
// Routine to create the memory volume from ...
// ... the data block(images) in the file "DiaViewer_VOL.cdata".
// This volume must be the first in OpenVolTable (Index 0).
//
{
    int      nb  = 0,  ii  = 0;
    uchar                * dat;
    SliEntry      * SliTab[64];
    SliEntry             * sli;
    DirEntry             * dir;
    VolEntry             * vol;
    SlidePrg             * prg;
    VolRef               * vrf;
    char               txt[64];

    while (ImgTbl[nb]) nb++;
    if (!nb) return NULL;

    dir = new DirEntry( "<MemDir>", 0 );
    for(ii = 1; ii <= nb; ii++) {
        SliTab[ii-1] = sli = new SliEntry( ImgTbl[ii-1], ii, 0, NULL );
        snprintf( txt, 63, " Default Volume page %2d.", ii ); 
        sli->Text( strdup( txt ) );
        sli->Owner( dir );
        sli->FlgSet( Context_Protect|Context_MemImg|Context_Data );
    }
    dir->Slide( nb, SliTab );
    dir->CnSli( nb );
    dir->FlgSet( Context_Protect|Context_MemImg );

    vrf = new VolRef;
    vrf->iide = 0;
    vrf->path = strdup( " " );
    vrf->name = strdup( "<Default Volume>" );

    vol = new VolEntry( NULL, dir, vrf );
    vol->TDeep( 1 );
    vol->TnSli( nb );
    vol->FlgSet( Context_Protect|Context_MemImg|Context_VDiRam );
    vol->SetVolIdents();

    prg = new SlidePrg( vol );
    vol->RelPrg( (void*)prg );

    return vol;
} // VolEntry * MemVolume().



//
// end of <PW-Id>.
//
