//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environment of Service Stack of any objects.
//


#ifndef SERVICE_VRECSTK_H
#define SERVICE_VRECSTK_H

#include <unistd.h>


#include "Service_ENV.h"


#define AREA_SIZE_B 65536
#define AREA_SIZE_W 32768
#define AREA_SIZE_L 16384
#define AREA_SIZE_Q  8192

// Define the record to store.

#define MASK_ALIGN    7

class VRecStk {
public:
    // Define the record to store.
    typedef union {
#ifdef Adr64
        void *     ad[64];
#else
        void *     ad[128];
#endif
        double     db[64];
        UInt64     uq[64];
        SInt64     sq[64];
        float      fl[128];
        SInt32     sl[128];
        UInt32     ul[128];
        SInt16     sw[256];
        UInt16     uw[256];
        SInt_8     sb[512];
        UInt_8     ub[512];
        char       ch[512];
    } Record;


private:
    typedef struct AREA {
        AREA            * nxt_, // Pointer to next area.
                        * prv_; // Pointer to previous area.
        UInt32            thd_, // Position of top HeadRec.
                          top_; // Area used size.
        SInt64 tab_[AREA_SIZE_Q];// Area memory.
    } Area;

    typedef struct {
        UInt16   link_, // The Index distance with previous RecHeader ...
                 size_; // ... and current (Record+Header) size (in Uint32 units)
    } Header;

    typedef union {
        Header   he_;
        UInt64   ll_;   // Is here just to force alignement on 64 bits words.
    } HeadRec;

    Area                 area_; // The internal area (always allocated) is the first ...
    Area       * fst_ = &area_, // ... in the used Area and cannot be free except when ...
               * lst_ = &area_, // ... the Varobj object is destroye.
               * cur_ = &area_, // Pointer to the current Area for allocation.
               * own_ = &area_; // Pointer to last area  wher is find a Record (used by
                                // RecNb, NextUp and NextDown).

    UInt32       fre_ =      0; // Pointer to the last found element (used by RecNb, NextUp
                                // and NextDown)

    void     URecCopy( Record *, Record *, int );

    Area *   NewArea();         // To allocate a new Area.
    void     DelArea( Area * ); // To free an Area.
    void     Init();            // Initialize the class.


public:
    void Zero();

    VRecStk() { Init(); }
    ~VRecStk() { Zero(); }

    Record * Push( Record *, int );
    Record * Get( int = 0 );

    int      Size( int = 0 );

    Record * Remove( Record * = 0 );
    Record * Remove( int = 1 );

    int      Pop( Record * );

    Record * RecNb( int );
    Record * NextUp();
    Record * NextDown();

    void    Statistic(int &, int &, int & );


}; // class VRecStk.





//
// Small template class to use with various type of record (at varible sizes).
//


template <class Ty>
class Any_VRecStk : public VRecStk {
public:
    Any_VRecStk <Ty> () : VRecStk() { }
    Ty * Push( Ty * r, int sz ) { return (Ty *) VRecStk::Push( (Record*) &r, sz ); }
    Ty * Get() { return (Ty *) VRecStk::Get(); }
    Ty * Remove( int n = 0 ) { return (Ty *) VRecStk::Remove( n ); }
    Ty * Remove( Ty * r = 0 ) { return (Ty *) VRecStk::Remove( (Record*)r ); }
    int  Pop( Ty * r ) { return VRecStk::Pop( (Record*) r ); }
    Ty * RecNb( int n ) { return (Ty *)RecNb( n ); }
    Ty * NextUp() { return (Ty *)NextUp(); }
    Ty * NextDown() { return (Ty *)NextDown(); }
};



#endif

//
// end of <PW-Id>.
//


