//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to sort a list of user defined record (struct or class).
// the string are always in UTF8.
// Service_Sort module.
//

#include <stdio.h>

#include <FL/Fl.H>
#include <FL/fl_utf8.h>
#include "Service_Sort.h"


// Define the increment(step) to allocate (or extend) a dynamic table of item.
#define TABLE_ALLOC_STEP      8

// Define the limit table length to select the quick sort process.
#define QSORT_LIMIT          16



// Constructor of the SrvTable.
SrvSort::SrvSort( int incr, enm_t enm ) {
    enm_ = enm;
    inc_ = TABLE_ALLOC_STEP;
    while (inc_ < incr) inc_ *= 2;
    tab_ = 0; all_ = use_ = bas_ = top_ = 0;
} //SrvSort::SrvSort_( int incr ).



void SrvSort::Fatal() {
    printf( " *** SvrSort Fatal Error : Not defined CallBack function to get the Entry names.\n" );
    exit( 1 );
} // SrvSort::Fatal()



int  SrvSort::CmpName( int jp, ent_t_ id ) {
    return fl_utf_strcasecmp( EName( tab_[jp] ), EName( id ) );
} // int  SrvSort::CmpName( int jp, Entry id ).



void SrvSort::SimplSort( int min, int max ) {
    int     jj;
    ent_t_  id;

    for(int ii = min+1; ii <= max; ii++) {
        id = tab_[ii];
        jj = ii - 1;
        while (jj >= min && CmpName( jj, id ) >= 0) {
            tab_[jj+1] = tab_[jj];
            jj--;
        }
        tab_[jj+1] = id;
    }
} // void SrvSort::SimplSort( int min, int max ).



void SrvSort::QuickSort( int min, int max ) {
    int      ic,   ip;
    ent_t_   pi,   tm;

  if (min >= max) return;

  ip =   (min + max)/2; // Get the middle Sort table index ...
  pi =        tab_[ip]; // ... as the pivot.

  tab_[ip] = tab_[min]; // Put the pivot item in first position.
  tab_[min] = pi;       //

  ic = min;             //
  for(int ii = min; ii <= max; ii++) {
    // Loop on all entries.
    if (CmpName( ii, pi ) < 0) {
      if (ii != ++ic) {
        // When the entry are differents, we exchange them.
        tm = tab_[ii]; tab_[ii] = tab_[ic]; tab_[ic] = tm;
      }
    }
  }
  // Put the middle entry to its right place.
  tm = tab_[ic]; tab_[ic] = tab_[min]; tab_[min] = tm;

  if (ic - min < QSORT_LIMIT) SimplSort( min, ic - 1 );
                         else QuickSort( min, ic - 1 );
  if (max - ic < QSORT_LIMIT) SimplSort( ic + 1, max );
                         else QuickSort( ic + 1, max );
} // void SrvSort::QuickSort( int min, int max ).



void SrvSort::Sort() {
    if (use_ < QSORT_LIMIT) SimplSort( 0, use_ - 1 );
                       else QuickSort( 0, use_ - 1 );
} // void SrvSort_::Sort().



// Set a new object in a SrvTable.
int  SrvSort::NewEntry( ent_t_ obj ) {
    ent_t_     *tm;
    int       size;

    if (all_ < 0 || !obj) return -1;
    // We append a new entry in the table.
    size = use_ + 1;
    if (size > all_) {
        size = (size + inc_)&~(inc_ - 1);
        tm = new ent_t_[size];
        if (use_)
            for(int ii = 0;ii < use_;ii++) tm[ii] = tab_[ii];
        if (tab_) delete[] tab_;
        tab_ = tm;
        all_ = size;
    }
    tab_[use_++] = obj; top_++;
    return use_ - bas_;
} // void SrvSort::NewEntry( void * obj ).





#ifdef SORT_DEBUG

const char * tnam[] = { "Arthur", "Totor", "Pierre", "François", "Jean", "René", "Daniel", "Paul", "Andre", 0 };

#ifdef SPC_CLASS

class  Rec { // Defined to be used with the generic class AnySort.
public:
    int           age,
               taille;
    const char * name;

    Rec( int a, int t, const char * n ) { age = a; taille = t; name = strdup( n ); }
    const char * Name() { return name; } // The name of this method member must be Name (virtual method).
    int Age() { return age; }
    int Taille() { return taille; }
};


#else

typedef struct  { int           age,
                             taille;
                  const char * name;
                } Rec;



class SortPers : public SrvSort{
public:
    SortPers(int i = 0 ) : SrvSort( i ) { }
    //  This virtal method can be defined for auser object class as this :
//  const char * EName( void * p ) { return ((Rec *)p)->Name(); }       // Definition for a rclass with member Name().
    const char * EName( void * p ) { return ((Rec *)p)->name; }         // Definition for a structure.
    int NewEntry( Rec * p ) { return SrvSort::NewEntry( (void*)p ); }
    Rec * GetEntry( int i ) { return (Rec *)SrvSort::GetEntry( i ); }
};


#endif

int main( int argc, char ** argv ) {
    int         ij, sz;
    Rec          * pnm;

#ifdef SPC_CLASS

    AnySort<Rec> S( 12 );
    ij = 0;
    do {
        pnm = new Rec( 18, 180, tnam[ij++] );
        S.NewEntry( pnm );
    } while (tnam[ij]);

#else

    SortPers   S( 12 );
    ij = 0;
    do {
        pnm = new Rec;
        pnm->age    =   14;
        pnm->taille =  180;
        pnm->name = strdup( tnam[ij++] );
        S.NewEntry( pnm );
    } while (tnam[ij]);

#endif

    printf( " Il y a %d noms à triés.\n\n", sz = S.Size() );

    S.Sort();

    for (ij = 0; ij < sz; ij++) {
        pnm = S.GetEntry( ij );

#ifdef SPC_CLASS
        printf( " %2d / %s : %2d ans, %3d cm.\n", ij, pnm->Name(), pnm->Age(), pnm->Taille() );
#else
        printf( " %2d / %s : %2d ans, %3d cm.\n", ij, pnm->name, pnm->age, pnm->taille );
#endif

    }

    return 0;
}

#endif

//
// end of <PW-Id>.
//
