//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Environment Module  to scan a directory tree.
//
//

#ifndef SERVICE_DIR_H
#define SERVICE_DIR_H

#include <dirent.h>
#include <sys/stat.h>

#include "Service_Util.h"

#define MAX_LEX_DIR 32


class SrvDir : public FilePath {
private:

    DIR   * dtbl_[MAX_LEX_DIR]; // The table for directory lex.

    static
    const int   Stat_Stop =  0, // Define the Internal Scan status.
                Stat_Init =  1, // The Scan is ready to start.
                Stat_Rdir =  2, // The is ready to read a directory entry.

                Fnd_Null  =  0, // Null value.
                Fnd_File  =  1, // A File entry is found,
                Fnd_Dire  =  2, // a directory entry to scan is found,
                Fnd_Dirt  =  3, // a directory entry to does not scan is found,
                Fnd_Eodi  =  4, // a End Of DIrectory is reached.
                Fnd_Erro  =  5; // a fatal error was detected.

public:

    // Use do define a user catch error.
    typedef int (*ErrCatch_t) ( int, const char *, void * );

    // Define a file types list.
    typedef char    ** FTypLst;

    static
    const int   Scan_Null =  0, //
                Scan_IDir =  1, // We init a selected Directory/Sub-Directory scan.
                Scan_File =  2, // We find a selected File.
                Scan_DiRf =  3, // We find a seleted directory but will not be scanned.
                Scan_Eodi =  4, // For the end of direcory scan, to resume the directory use.
                Scan_Stop =  5, // The Scan is finished.
                Scan_Erro =  6, // A fatal error was detected.

                SDir_NCEx =  1, // Does not distiguish the different cases for file extensions.
                SDir_NCas =  2, // Does not distiguish the different cases for all filename.
                SDir_Hidd =  4, // Can see the hidden files.
                SDir_SLnk =  8, // On Unix/Linux, Follow any symbolic link.
                SDir_PrDi = 16; // If set, the Open_Dir error is not ignored, else ...
                                // ... the directory is ignored.

    const int   MAX_ERROR = 32; // Maximum accepted of not fatal error.

private:
    ErrCatch_t           ehdl_; // Call on error with argument error code.
    void               * data_; // Data for any user class.

    DIR   * dirf_[MAX_LEX_DIR]; // The opendir stack file.
    int                  stat_, // Current scan state.
                         llvl_, // Directectory Lex level.
                         flgs_, // Flags for symbolic links.
                         ierr_, // Error code.
                         nerr_, // Count of not fatal error.
                         exti_, // Found extention idndex or -1.
                         news_, // New Scan status keep here.
                         olds_; // Old Scan status keep here.

    int                * ulvl_; // User copy address llvl_.

    const char *         name_; // Name of current entry.

FTypLst                 typls_; // List of matching regular file types.

    int  Open_Dir( const char * );
    int  Close_Dir();
    void Clean_Stack();

    int  Error_Manager( int, const char *, ... );
    int  Check_FName( const char * );
    int  Get_Entry();

protected:
    virtual int Filter( int, const char * );

public:

    // Creator of an SrvDir service.
    SrvDir() : FilePath()
        { exti_ = llvl_ = -1; ehdl_ = 0; data_ = 0; typls_ = 0; ulvl_ = 0; stat_ = flgs_ = ierr_ = nerr_ = 0; }

    // Install a user Error handler.
    void ErrHdl( ErrCatch_t r, void * d = 0 ) { ehdl_ = r; if (d) data_ = d; }

    void SetFlg( int v ) { flgs_ |= v; }
    void ClrFlg( int v ) { flgs_ &= ~v; }
    int  TstFlg( int v ) { return flgs_ & v; }
    int  FileEi() { return exti_; }

    const char * Name() { return name_; }

    // To give the list of file extentions to select.
    void SetFltExt( const FTypLst extb );

    // Init the scan on from the root path <root> with the default flags :
    //    No Symlink use, skip hidden, skip entry without access Read access but without error.
    void Init( const char * root, int flgs = 0 );

    void UsrLevel( int & ll ) { ulvl_ = &ll; }

    // Get the current directry deep.
    // Warning: Return the internal level not always equal to a level copy, because ...
    // ... during the Scan_Eodi step. the internal level is decremented but its copy ...
    // ... is updated at the end diring the next call of SrvDIT::Scan() call.
    // This  is more convenient to acceed to user environment stack managment.
    int  Level() { return llvl_; }

    // Get the current object SrvDir path from parent FilePath.
    // const char * Path().

    // Make a step in the scan.
    // Return -1 on fatal error (if ierr_ != 0) or else scan end.
    // Return  2 for a directory and 1 for a regular file.
    //  The file/dir path is given by        SrvDir::Path(),
    //  the file/dir protection is given by  SrvDir::Access.
    //
    int  Scan();
    void Abort() { Clean_Stack(); stat_ = -1; }

};


#endif

//
// end of <PW-Id>.
//
