//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a slide collection
// DCM = DiaViewer Collection Management.
//

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>

#include <setjmp.h>


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>

#include "Service_DIR.h"
#include "Service_Sort.h"
#include "Service_IO.h"


#include "DiaViewer_GBL.h"
#include "DiaViewer_DIA.h"
#include "DiaViewer_DCM.h"
#include "DiaViewer_PRG.h"
#include "DiaViewer_MVL.h"
#include "DiaViewer_VRFL.h"
#include "DiaViewer_V_MN.h"






//
// Each diapositive/slide is identified by a unique IIde_t integer.
// This identifier include three part. The volume identifier number,
// the directory identifier number (in the volume) and the slide identifier
// unique in the volume. The three field in the IIde_t identifier can be
// defined by a definition as :
// #define LARGE_UNI_IDENT
// to have a 64 bits identifier type (the default is 32 bits), and by
// #define UNIQUE_IDE_FIELDS {<sld>,<dir>}
// For example, for 32 bits identifiers:
// #define  UNIQUE_IDE_FIELDS {16,10}
// while by used to get a slide field of 16 bits and a directories field of 10 bits,
// that keep 6 bits (32 - 16 - 10 = 6) for the volume. With this, you can have a
// maximum of 2**16-1 = 65535 slides in each directory, 2**10-1 = 1023 directories
// in each volume and 2**(32-16-10)-1 = 64 volumes. The default 32 bits IIde Identifier
// is defined at the compilation time but the UNIQUE_IDE_FIELDS is keep in the user's
// local data context and can be changed when the DiaViewer software is restarted and
// it should be possible to change these field sizes by using the setup menu in some
// future versions.
// The default fields size values are :
//    #define UNIQUE_IDE_FIELDS {14,10} in 32 bits that allows
//           16,383 slides in each directory,
//             1023 directories in each volume and
//              255 opened volumes.
//
//    #define UNIQUE_IDE_FIELDS {32,16} in 64 bits that allows
//    4,294,967,297 slides in each directory,
//           65,535 directories in each volume and
//           65,535 opened volumes.
//
// The default DiaViewer software generation is with Unique Identifiers of 32 bits.
//
//



static int DirFlg = 0; // for sorting directories/slides entries.


// The default fields size values are :
//    #define UNIQUE_IDE_FIELDS {14,10} in 32 bits that allows
//           16,383 slides in each directory,
//             1023 directories in each volume and
//              255 opened volumes.
//
//    #define UNIQUE_IDE_FIELDS {32,16} in 64 bits that allows
//    4,294,967,297 slides in each directory,
//           65,535 directories in each volume and
//           65,535 opened volumes.
//
// The default DiaViewer software generation is with Unique Identifiers of 32 bits.
//
//


static sigjmp_buf       JmpBuf; // Buffer for long jump on I/O context error.



//
// Entry type defined to directory entries.
//


/*
typedef struct { // Define the element of Entry table (for sorting).
    int    use,  // Used size.
           all;  // Allocated size.
    Entry *tab;  // The table of name.
} EntryTable;

*/



const char * ImgExt[] = { "jpeg", "JPEG", "jpg", "JPG", "png", "PNG", "bmp", "BMP", 0 };

static char        ErrMsg[512]; // To keep the last Io Error Message.
static int        ErrMsglength; //



static int Err_Handler( int ie, const char * msg, void * d ) {
    LogF.Write( "%s", msg );
    fl_alert( "%s", msg );
    siglongjmp( JmpBuf, ie );
} // static int Err_Handler( int ie, const char * msg, void * d ).



static DirEntry * ScanFoundDir( const char * root ) {
    // pdir is the parent directory descriptor,
    // path is the complete path where is founded the new directory entry,
    // name is the name of the new directory entry.
    //

    AnySort<SliEntry>    SliSort( 32 ); // Create the sorting table for ...
    AnySort<DirEntry>    DirSort( 12 ); // ... directories and files.

    DirEntry              * nwdir, // Pointer to the current directory descriptor,
                         ** tbdir; // Pointer to the current directory sort list of directories.
    SliEntry              * nwsli, // Pointer to the current slide descriptor,
                         ** tbsli; // Pointer to the current directory sort list of slides.

    SrvDir                    Dsc; // Create the service directory tree scan object, ...
    int                       lvl, // ... the nesting context index copy.
                            irp,
                            sts;

    // Total count of slide and directory for the current directory and its sub-diretories.
    int             ncdir,  ncsli;

    Dsc.ErrHdl( Err_Handler );          // Install the error handler.
    Dsc.SetFltExt( )( SrvDir:FTLst) ImgExt );   // Install the list of file extension to search.
    Dsc.UsrLevel( lvl );                // Install lvl has copy of directory lex level (deep in the tree).
    Dsc.Init( root, 0 );                // Initialize the scan in the directory tree.

    ncdir = ncsli = 0;                  // Init the total counts of directories and slides.

    irp = 1;
    while (irp) {                       // Loop to scan all the directory tree.
        sts = Dsc.Scan();               // Perform one step in the tree.
        Cnt = &(Cntx_Tab[lvl]);         // Update the context pointer.
        switch (scs) {
            case SrvDir::Scan_IDir: {   // Begin of a directory or sub-directory.
                Cnt->ndir = Cnt->nsli = Cnt->ncdir = Cnt->ncsli = 0;

                SliSort.Push();         // Prepare  new lists for the
                DirSort.Push();
            break;

            case SrvDir::Scan_File: {   // Regular selected file.
                                        // We must build the slide record.

                nwsli = new SliEntry( Dsc.Name() );     // Create the Slide record ...
                SliSort.NewEntry( nwsli );              // ... put it it the Sort Table.
                Cnt->nsli++;
                Cnt->ncsli++;
            break;

            case SrvDir::Scan_DiRf: {   // Sub-Directory Reference found (cannot exist for us.).
            break;

            case SrvDir::Scan_Eodi: {   // End of (sub-)directory.
                if (Cnt->ncsli) {       // When this directory (includes sub-directory) includes some slide(s) :
                    nwdir = new DirEntry( Dsc.Name() ); // We create the directory record,
                    if (ns = SliSort.Size()) {          // When we have find some slides inside ...
                        if (ns > 1) SliSort.Sort();     // ... we the Sort them and ...
                        Slide( ns, SliSort.GetTable() );// ... build the Directory list of slides.
                        ncsli += ns;
                    }
                    if (nd = DirSort.Size()) {          // When we have some sub-directories with slide(s), ...
                        if (nd > 1) DirSort.Sort();     // ... we the Sort them and ...
                        SbDir( nd, DirSort.GetTable() );// ... build the Directory list of sub-directory-ies.
                        ncdir += nd;
                    }


                    if (lvl > 0) {
                        SliSort.Pop();                  // Pop the slides and directory sort list.
                        DirSort.Pop();


                        Set( CNTX_FNAME );              // We read the context file when its existing.
                        ideep = nwdir->ReadCntxFile( Path() );
                        Rem();

                        nwdir->CnSli( ncsli );          // Update the total count of slides for the current directory.
                        DirSort.NewEntry( nwdir );      // Put it in the sort list of owner Directory.
                    }


////  Attention : A ce niveau les champs owner_, deep_ et udeep_ ne sont pas definis.
////  lvl qui est la profondeur pourrait peut-être servir à le faire.
////  ... Et il y a aussi le champ IIde_t ident_ qui être manipulé pas IIde_t Ident() et void Ident( IIde_t ).
////  Enfin le champ *stext_ des DirEntry ne sert à rien !! .
////

                }
            break;

            case SrvDir::Scan_Stop: {   // Begin of a directory or sub-directory.
            default: ir = 0;
        } // switch ...
    } // While ...
    return nwdir;
    // We must complete the scan.

} // static DirEntry * ScanFoundDir( const char * name ).
