//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//
//

#include <FL/gl.h>
#include <GL/glu.h>

#include <FTGL/ftgl.h>



#ifndef VIEW_LAYOUT_H
#define VIEW_LAYOUT_H



#define MAX_TEXT_SIZE   4096

//
// Define the plane outline limits function.
// These functions must provide the abscissas of the beginnings ...
// ... and ends of each line from the ordinate of the line.
//



class Fancy_Layout {
public:

    // Define the limit function type.
    typedef float (Lim_Fnc)( float, void * );


private:

    static const int Max_Siz = MAX_TEXT_SIZE;

    typedef struct WORD * Wrd_Ptr;

    typedef struct WORD {       // One record for each word.
        int              idwd_, // Index of first byte of the word (can be a TAB).
                         lnwd_; // Length in byte of the word (if TAB its included).
        float            adwd_; // Length in 1/72" (Font unit).
    } Wrd_Rec;


    Wrd_Rec Wrd_Tab[Max_Siz/2]; // The word table.
    char       txtbuf[Max_Siz]; // To store the clean user string.

    Lim_Fnc     * BX_,   * EX_; // User functions to get X of begin and end of each line.
    void                 * UD_; // Second arg. (a pointer of user object) for BX() and EX().

    FTFont              * fnt_; // The used FTFont.

    float                 ali_, // Advance/Space for alinea value.
                          asc_, // Font ascender value.
                          dsc_, // Font descender value.
                          lsp_; // LieSpacing <--> lineSpacing.

    FTPoint               pen_;


    GLdouble  crx_, cry_, crz_; // Point to render (GL coordinates).

    FTGL::TextAlignment   aln_; // Alignment choice.

    float BXI( float );         // Interface functions for user function BX() and EX().
    float EXI( float );

    void Wrap_Text( const char *, const int, FTPoint, int, FTBBox * );

public:
    Fancy_Layout() { BX_ = EX_ = 0; UD_ = 0; }

    void SetLinesLimits( Lim_Fnc * bf, Lim_Fnc * ef, void * d )
                        { BX_ = bf; EX_ = ef; UD_ = d; }

    int  SetFont( FTFont * ft );

    FTFont * GetFont() { return fnt_; }


    FTBBox BBox(const char* string, const int len = -1, FTPoint position = FTPoint());
    FTBBox BBox(const wchar_t* string, const int len = -1, FTPoint position = FTPoint());

    void Render(const char *, const int = -1, FTPoint position = FTPoint(), int = 0 );
    void Render(const wchar_t *, const int = -1, FTPoint position = FTPoint(), int = 0 );

    void SetLineSpacing( float lh ) { lsp_ = lh; }
    void SetAlignment( const FTGL::TextAlignment  al ) { aln_ = al; }
    void SetAlinea( float al ) { ali_ = al; }

    GLdouble Ascender() { return asc_; }
    GLdouble Descender() { return dsc_; }
    const FTGL::TextAlignment GetAlignment() { return aln_; }




    void RenderSpace( const char *string, const int len,
                      FTPoint position, int renderMode, const float extraSpace);

    void RenderSpace( const wchar_t *string, const int len,
                      FTPoint position, int renderMode, const float extraSpace);

private:

        void WrapText( const char *buf, const int len,
                       FTPoint position, int renderMode,
                       FTBBox *bounds);

        void WrapText( const wchar_t *buf, const int len,
                       FTPoint position, int renderMode,
                       FTBBox *bounds);

        void OutputWrapped( const char *buf, const int len,
                            FTPoint position, int renderMode,
                            const float RemainingWidth, FTBBox *bounds );

        void OutputWrapped( const wchar_t *buf, const int len,
                            FTPoint position, int renderMode,
                            const float RemainingWidth, FTBBox *bounds );


        template <typename T>
        inline FTBBox BBoxI(const T* string, const int len, FTPoint position);

        /* Internal generic Render() implementation */
        template <typename T>
        inline void RenderI( const T* string, const int len,
                             FTPoint position, int renderMode );

        /* Internal generic RenderSpace() implementation */
        template <typename T>
        inline void RenderSpaceI( const T* string, const int len,
                                  FTPoint position, int renderMode,
                                  const float extraSpace );

        /* Internal generic WrapText() implementation */
        template <typename T>
        void WrapTextI( const T* buf, const int len, FTPoint position,
                        int renderMode, FTBBox *bounds );

        /* Internal generic OutputWrapped() implementation */
        template <typename T>
        void OutputWrappedI( const T* buf, const int len, FTPoint position,
                             int renderMode, const float RemainingWidth,
                             FTBBox *bounds) ;



};



#endif


//
// end of <PW-Id>.
//

