//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Ranking module.
//
//

#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>


#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Text_Buffer.H>


#include "SetUpMan.h"

#include "DiaViewer_DIA.h"
#include "DiaViewer_RkgUI.h"

#include "DiaViewer_RKG.h"
#include "Service_Util.h"
#include "Text_Display.h"

#include "DiaViewer_RKGCN.h"




// #define GL_DEBUG



extern DiaViewer_GL      ** Viewer_GLT; // Define the external GL Windows pointer table.




// Define the default value of the string in Slide and Folder formats.
char                  Null    =      0;  
char           IniSliHde[]    =   "Ph",
               IniSliSep[]    =    "-",
               IniDirHde[]    =  "Gph",
               IniTrgFnm[]="my_slides",
               IniDirTra[]    = {Null};

int             rktb_wid      =    850, // Slide Ranking map ...
                rktb_hig      =    300, // ... sizes.
                rktb_tsz      =     12, // Slide Ranking Map Title font size ...
                rktb_esz      =     10; // and table element Font size.

int             slid_dig      =      3, // Number of figures for Slide#,
                film_dig      =      3, // Number of figures for Film#,
                fold_dig      =      2, // Number of figures for Directory/folder,
                flmn_max      =     64, // Maximum value of film number (#),
                slin_max      =     64, // Maximum value of slide number (#),
                dirslisz      =     50, // Max. number of slides/folder in the target volume,
                dirdirsz      =     10; // Max. number of Folder/folder in the target volume.

char          * slid_hde      =   NULL, // Slide filename header string,
              * slid_sep      =   NULL, // Slide filename separator string,
              * fold_hde      =   NULL, // Folder/Directory filename header string.
              * fold_tra      =   NULL, // Folder/Directory filename trailer string.
              * tvol_pth      =   NULL, // Initial file path of target volume.
              * tvol_nam      =   NULL; // Initial target Volume Name.

static char   * slid_tra      =   NULL; // Slide trailer (internal use only.)


static int      RankInit      =      1, // To perform the init sequence at the first call.
                Rank_OK       =      0, // Flag to allow the ranking process.
                VerFlag       =      0, // Flag of Films/Slides Chart open.
                wind_id       =      0, // Base window index.
            UniquRankAccess   =      0; // Static value to lock or unlock the ...
                                        // ... classement/Ranking functions access.

static FilePath   * DstPath   =   NULL; // Path to create the Ranked destination volume.

static int        * DeepTab   =   NULL; // The Deep table to manage the Destination Directories.

static int          DstDeep   =      0, // The destination sub-directory deep.
                    NumbrSli  =      0; // Total number of slide of the source volume.

static char           RootPathStr[256], // The Target Volume root path is keep here.
                      RootVNameStr[64]; // The Target Volume Name.

static int                      FlmIdx; // Use as index of end of target root dir path (without filename).


static DirRefer      * CurDref  = NULL; // Current pointer reference directory and slides.

static RkgTabCnt     * RkgCntx  = NULL; // The Ranking Context tables.


//
// Define the format to use to create slides and directories names.
//

const char slifrm[] ="%s%0*d%s%0*d%s%s",// Slide file name format.
           dirfrm[] =   "%s_%d_%0*d%s"; // Directory filename format.


// Define MkDir as the same for all operating system.
#if defined( WIN32 ) && !defined( _CYGWIN_ )
# define MkDir( p ) mkdir( p )
#else
# define MkDir( p ) mkdir( p, S_IRWXU|S_IRGRP|S_IROTH )
#endif

#define MAX_SLI_DISPLAY 256




static void RequiredDirEval( int nsli, int &deep, int &dirnb )
//
// Routine to evaluate the suited values to build the dirname format.
// nsli = number of slide to put in new volume,
// deep is the resulting deep (or number of directories to cross from root to slides),
// and dirnb is the number of figures tu use for the directories number in name.
//
{
    int    ncnt,  ndir;

    // Compute the required sub-directory deep level.
    ndir = (nsli + dirslisz - 1)/ dirslisz;     // Get the maximum number of final directories.
    if (ndir > 1) {                             // When the root directory is not enough, ...
        ncnt = dirdirsz;
        deep = 1;                               // ... one deep allow <dirdirsz> sub-directories.
        while (ncnt < ndir) {                   // Loop to determine the Total sub-directory ...
            ncnt *= dirdirsz;  deep++;          // ... that is required.
        }
        // Here, deep is the required sub-directory deep level.
        // Now, we must determine the suited number of figures ...
        // ... to put the ordering number of each directory.
        ncnt = 1; dirnb = 0;
        while (ncnt < ndir) { ncnt *= 10; dirnb++; }
    } else { deep = 0; dirnb = 0; }            // We use only the root directory.

} // static void RequiredDirEval( int &tdep, int &ndf ).



static void EditSliExa()
{
    char str[32];

    snprintf( str, 31, slifrm, slid_hde, film_dig, 5, slid_sep, slid_dig, 3, slid_tra, ".jpeg" );
    cs_example->value( str );
} //static void EditSliExa().




static void EditDirExa()
{
    char str[32];

    snprintf( str, 31, dirfrm, fold_hde, DstDeep, fold_dig, 9, fold_tra );
    cf_example->value( str );
} //static void EditDirExa().



static char * NumWidth( int nbd )
{
    static char str[64];
    int           i = 0;

    while (i < nbd) { str[i] = '0'+ i; i++; }
    str[i] = 0;
    return str;
} // static char * NumWidth( int nbd ).



static int  SizesSliFlm() {
    int mfl, msl, npw, nsl;

    RkgCntx->FlmSliCount( mfl, msl, nsl );     // Get the maximums of films and Slides numbers.

    // Set Minimum values of films and slides numbers.
    if (cs_mxflm->value() < mfl) { cs_mxflm->value( mfl ); cs_mxflm->minimum( mfl ); }
                            else { cs_mxflm->minimum( mfl ); flmn_max = cs_mxflm->value(); }
    if (cs_mxsli->value() < msl) { cs_mxsli->value( msl ); cs_mxsli->minimum( msl ); }
                            else { cs_mxsli->minimum( msl ); slin_max = cs_mxsli->value(); }

    // Get the final (to use) maximum numbers of file and slides/film ...
    mfl = cs_mxflm->value(); msl = cs_mxsli->value();

    // ... and set the related minimums of figures.
    film_dig = 1; npw = 10;
    while (mfl >= npw) { npw *= 10; film_dig++; }
    if (film_dig > cs_nbflm->value()) cs_nbflm->value( film_dig );
    cs_nbflm->minimum( film_dig );

    slid_dig = 1; npw = 10;
    while (msl >= npw) { npw *= 10; slid_dig++; }
    if (slid_dig > cs_nbsli->value()) cs_nbsli->value( slid_dig );
    cs_nbsli->minimum( slid_dig );

    return nsl;
} // static void SizesSliFlm().



void Rkg_Setup( DiaViewer_GL * wgl )
// Call to enter in the Classification sub-system.
//
{
    char       str[64];
    char          * s1;
    int   len,     did,
          tdp,    nsli,
          mfl,     msl;

    if (UniquRankAccess) {                      // Classement is already in use.
        fl_alert( "You cannot simultaneously activate two the ranking subsystems." );
    } else if (wgl->GetRkgMap()||wgl->Curr_Vol->FlgTst( Context_VRkMap )) {
        fl_alert( "You cannot start ranking subsystem while a Films/Slides chart\n is opened on the same volume." );
    } else {
        if (!(wgl->Curr_Vol&&wgl->Curr_Dir&&wgl->Curr_Sli)) {
            fl_alert( "To enter in ranking context, you must open:select a slide volume." );
            return;
        }
        UniquRankAccess     =    1;             // Lock the access to ranking function.

        wgl->Curr_Vol->FlgSet( Context_VRkMap|Context_RankOn );
        // Set GL flag to link Ranking Quit with the GL Window as sub-window(s).
        // This action cancel ranking (not runing) on Close Volume, Select other Volume or
        // close the GL Window.
        wgl->SwFSet( SwFlg_Ranking );
        RkgCntx = new RkgTabCnt( wgl );         // Create the ranking context.

        wind_id = wgl->ViewIndex() + 1;         // Get the base View index.

        OpenRkgSetup( svargc,svargv, wind_id ); // Create the specific ranking window.

        if (RankInit) {                         // To perform an init sequence ...
            Rank_OK  = 1;                       // Assume success.
            RankInit = 0;                       // ... only for the first call.
            slid_tra = strdup( "-m" );          // Define the middle index trailer for normal slides.
        }
        // Assume default value when not already set (first DiaViewer run).
        if (!slid_hde) slid_hde = IniSliHde;
        if (!slid_sep) slid_sep = IniSliSep;
        if (!fold_hde) fold_hde = IniDirHde;
        if (!fold_tra) fold_tra = IniDirTra;

        // Define the source volume access.
        rkg_volsrc->value( RkgCntx->SrcDir->FName() );  // Display the name/path of source volume.

        // Define the default target volume root.
        if (tvol_pth&&tvol_pth[0]) {            // Use the previously used dir. as default ...
            strncpy( RootPathStr,tvol_pth,248 );// ... when defined ...
            len = strlen( RootPathStr );
            if (RootPathStr[len-1] != DIRSEP) RootPathStr[len++]=DIRSEP;
        } else {                                // ... else use the user's home directory.
            if (tvol_pth) { delete[] tvol_pth; tvol_pth = NULL; }
            strncpy( RootPathStr, User_Dir, 248 );
            s1 = RootPathStr;                   // Append a directory separator when not present.
            if (s1[len-1] != DIRSEP) s1[len++]=DIRSEP;
            s1[len] = 0;
            FlmIdx = len;                       // Keep the size of path (without dir. name).
            strncpy( s1+len,IniTrgFnm,255-len );// Append the default root filename.
        }
        if (tvol_nam&&tvol_nam[0]) {            // Use the previously used dir. as default ...
            strncpy( RootVNameStr,tvol_nam,62 );// ... when defined ...
            len = strlen( RootVNameStr );
        } else {                                // ... else use a default name.
            if (tvol_nam) { delete[] tvol_nam; tvol_nam = NULL; }
            tvol_nam = strdup( "Ranking Volume" );
            strncpy( RootVNameStr, tvol_nam, 62 );
        }
        rkg_root->value( RootPathStr );         // Set it, in the setup window.
        rkg_vname->value( RootVNameStr );       //

        NumbrSli=nsli=RkgCntx->SrcDir->CnSli(); // Get the total possible count of slides ...
                                                // ... when we keep all slides.

        // Forces compatibility of maximum sizes with the state of the volume.
        nsli = SizesSliFlm();                   // nsli = number of slides to rank.

        RequiredDirEval( nsli, tdp, did );      // Evaluate the minimum deep and fold_dig.

        DstDeep  = tdp;
        if (did > fold_dig) fold_dig = did;     // We set the minimum value if too small.
        cf_nbfd->value( fold_dig );             // Display the value (changed if too small).
        cf_nbfd->minimum( did );                // Set the minimum required.
        cf_head->value( fold_hde );             //
        cf_trailer->value( fold_tra );          //
        cf_dirnb->value( NumWidth( fold_dig ) );
        EditDirExa();                           // Display the folder name example.

        cs_mxflm->value( flmn_max );
        cs_mxsli->value( slin_max );
        sprintf( str, "corresponding to\n %d slides max.", (flmn_max - 1)*(slin_max - 1) );
        cs_slitmx->value( strdup( str ) );
        cs_head->value(  slid_hde );
        cs_nbflm->value( film_dig );
        cs_flmnb->value( NumWidth( film_dig ) );
        cs_separ->value( slid_sep );
        cs_nbsli->value( slid_dig );
        cs_slinb->value( NumWidth( slid_dig ) );
        cs_trailer->value( slid_tra );
        EditSliExa();                           // Display the slide filename example.

//      RkgCntx->RequiredSliEval( nsli, film_dig, slid_dig );       // Check for Rank_OK.

    }
} // Rkg_Setup( int argc, char** argv ).



void Rkg_Quit()
// To Quit the classification sub-system.
//
{
/// int len;
    RkgCntx->TextExit();
    RkgCntx->SrcVol->FlgClr( Context_VRkMap|Context_RankOn );
    // Clear ranking flag to unlink Ranking with the GL Window.
    Viewer_GLT[wind_id-1]->SwFClr( SwFlg_Ranking );

    strncpy( RootPathStr, rkg_root->value(), 255 ); RootPathStr[255] = '\0';
/// len = strlen( RootPathStr );
/// while (RootPathStr[len] != DIRSEP) len--;
/// RootPathStr[len] = 0;
    delete rkg_win;

    if (tvol_pth) delete[] tvol_pth;
    tvol_pth = strdup( RootPathStr );
    delete RkgCntx;
    UniquRankAccess   =  0;                     // Unlock the classement access.
    Rank_OK = 0;
} // void Rkg_Quit().



void Rkg_Maximas( int fl, int val )
{
    int tmsli;
    char str[64];

    if (fl) if (val*slin_max > IIdeMaxSli) cs_mxflm->value( flmn_max );
            else flmn_max = val;
       else if (val*flmn_max > IIdeMaxSli) cs_mxsli->value( slin_max );
            else slin_max = val;
    tmsli = (flmn_max - 1)*(slin_max - 1);
    snprintf( str, 63, "corresponding to\n %d slides max.", tmsli );
    cs_slitmx->value( strdup( str ) );
} // void Rkg_Maximas( int fl ).



//
// Routines/functions to perform the checking of Rank data.
//

static void ChangeProtFlg( DirEntry * dir, int flm, int fla, int flv )
{
    int nd = dir->NDir(),
        ns = dir->NSli();
    SliEntry       * sli;

    for(int i=1; i<=nd; i++) ChangeProtFlg( dir->SbDir( i ), flm, fla, flv );

    for(int i=1; i<=ns; i++) {
        sli = dir->Slide( i );
        if (flm == sli->Film()) {
            if (flv) sli->FlgSet( fla );
                else sli->FlgClr( fla );
        }
    }    
} // static void ChangeProtFlg( DirEntry * dir ).



void Rkg_ProtFlg( SliEntry * slb, int pty, int flg )
//
// For all slide of the current film, set(flg=1) or Clear(flg=0) ...
// ... the slide protection(pty=1) or slide ranking lock(pty=0) flags.
//
{
    DirEntry * dir = slb->Owner();
    int        flm =  slb->Film(),
        fla = (pty)? Context_Protect : Context_LckRank;

    while (dir->LDeep()) dir = dir->Owner();     // Locate the volume root directory.
    if (dir)  ChangeProtFlg( dir, flm, fla, flg );
} // void Rkg_PrtFlg( SliEntry * sli, int pty, int flg ).



void Rkg_ProtectMan( SliEntry * sli )
{

} // void Rkg_ProtectMan( SliEntry * sli ).


void Rkg_Verify()
//
// To verify the data coherence for ranking before to perform it.
//
{
    Rank_OK = (RkgCntx->FlmSliChart( 0 ))? 2 : 1;
    if (Rank_OK > 1) {
        rkg_go->labelcolor( FL_FOREGROUND_COLOR );
        rkg_go->redraw();
    }
} // void Rkg_Verify().



//
// Routines/functions to perform the ranking.
//

#define BUFSIZE 8192
#define UNIX_IO


static int FileCopy( const char * dstpth, const char * srcpth )
// Copy one file.
// Used to copy the image files from the source volume to the target one.
// It is binary level copy.
{
    int           ierr = 0,
                      size;
    char   buffer[BUFSIZE];

    if (!access( srcpth, F_OK )) {

#ifdef UNIX_IO
        int       src, dst;
        struct stat stasrc;

        if ((src = open( srcpth, O_RDONLY|O_BINARY )) == -1) {
            fl_alert( "Cannot open the slide file \"%s\":\n\t%s", srcpth, strerror( errno ) );
            ierr = -1;            
        } else {
            fstat( src, &stasrc );
            
            if ((dst = open( dstpth, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, stasrc.st_mode )) == -1) {
                fl_alert( "Cannot create the slide file \"%s\":\n\t%s", dstpth, strerror( errno ) );
                ierr = -1;
            } else {
                while ((size = read( src, buffer, BUFSIZE )) > 0)
                    if (write( dst, buffer, size ) == -1) {
                        fl_alert( "Write Error one slide file \"%s\":\n\t%s", srcpth, strerror( errno ) );
                        ierr = -1; break; 
                    }
                if (size == -1) {
                    fl_alert( "Read Error one slide file \"%s\":\n\t%s", srcpth, strerror( errno ) );
                    ierr = -1;
                }
                close( dst );
            }
            close( src );
        }

#else
        FILE  * src, * dst;

        if (src = fl_fopen( srcpth, "r" )) {
            if (dst = fl_fopen( dstpth, "w" )) {
                while ((size = fread( buffer, sizeof( char ), BUFSIZE, src )) > 0) {
                    if (fwrite( buffer, sizeof( char ), size, dst ) != size) {
                        fl_alert( "IO Error one slide file \"%s\":\n\t%s", srcpth, strerror( errno ) );
                        ierr = -1; break;                        
                    }
                }
                fclose( dst );
            } else {
                fl_alert( "Cannot create the slide file \"%s\":\n\t%s", dstpth, strerror( errno ) );
                ierr = -1;
            }
            fclose( src );
        } else {
            fl_alert( "Cannot open the slide file \"%s\":\n\t%s", srcpth, strerror( errno ) );
            ierr = -1;
        }
#endif
    }
    return ierr;
} // static int FileCopy( const char * dst, const char * src ).



static int TreeCreate( int deep, int idd )
// Recursive Routine to create any path element of a given path ...
// ... and prepare path builting of a new (ranked) volume.
//
{
    int            dii;
    char     dfnam[64];
    const char  * path;

    dii = DeepTab[deep];                // Get the current directory index (or -1 when no existing).
    if (dii != idd) {                   // When the expected directory is not in the current path.
        if (dii >= 0) {                 // When, a previous directory is existing, remove it from path ...
            DstPath->Set( CNTX_FNAME ); // ... after the context file creation.
            CurDref->WriteDirCntxFile( deep, DstPath->Path() );
            CurDref = CurDref->DelRef( CurDref );
            DstPath->Rem();
            DstPath->Rem();
        }
        // Check for parent directory and stop on error.
        if (TreeCreate( deep-1, idd/dirdirsz )) return -1;
        // Build the filename of the expected directory and ...
        snprintf( dfnam, 63, dirfrm, fold_hde, deep, fold_dig, idd, fold_tra );
        DstPath->Set( dfnam, 1 );       // ... put it in the path.
        path = DstPath->Path();         // Keep the complete path and ...
        DeepTab[deep] = idd;            // ... put its index in the deep table.
        if (access( path, F_OK ))       // If the expected directory does nos exist, we create it.
            if (MkDir( path )) return -1;       // On error we return.
        CurDref = new DirRefer(CurDref);// Create the directory/slide reference structure.
    }
    return 0;
} // static int TreeCreate( int deep, int idd ).



static int SlideCopy( SliEntry * sli )
{
    char                    nsname[32];
    const char   * src,  * dst,  * ext;
    int i;

    // Compute the slide index as a combinaison of film and slide numbers.
    int ids = (sli->Film() - 1)*dirslisz + sli->Numb() - 1;
    // Create any subdirectory to be ready to copy the slide.
    if (TreeCreate( DstDeep, ids/dirslisz )) { 
        // On error send the message.
        fl_alert( "Error : Cannot use the path \"%s\"\n\t%s\n", DstPath->Path(), strerror( errno ) );
        return -1;
    }
    src = sli->BltPath();
    i = strlen( src );
    while ((i>0)&&(src[--i] != '.')) ;  // Locate the last dot separator.
    ext = src + i;
    // Build the new filename (in the new ranked volume) of the slide.
    snprintf( nsname, 31, slifrm, slid_hde, film_dig, sli->Film(), slid_sep,
                                            slid_dig, sli->Numb(), slid_tra, ext );
    // Put it in the path and perform the slide copy.
    DstPath->Set( nsname, 0 );
    dst = DstPath->Path();
    if (access( dst, F_OK)) {
        if (FileCopy( dst, src )) {
            // On error send the message.
            fl_alert( "Error : Cannot copy the slide \"%s\"\n\t%s\n", DstPath->Path(), strerror( errno ) );
            return -1;
        }
    }
    DstPath->Rem();
    CurDref->AddSliRef( nsname, sli );
    return 0;
} // static int SlideCopy( const char * path, SliEntry * osli ).




void Rkg_CreateVolume()
//
// Call to define the new ranked volume path.
//
{
    SliEntry             * sli;
    const char          * root;
    int    flcnt, sliid, fdeep;

    if (Rank_OK <= 1) {
        fl_alert( "You cannot perform the Ranking process.\n\t%s",
                  "before to get success in the Data Check test." );
        return;
    }

    root = rkg_root->value();                           // Get the user root path.
    if (tvol_pth) delete[] tvol_pth;
    tvol_pth = strdup( root );                          // keep copy for SetManager.
    if (access( root, F_OK|R_OK|W_OK|X_OK )) {
        if (errno != ENOENT) {
            fl_alert( "Error: Can't create a new volume in the path \"%s\"\n\t%s",
                    root, strerror( errno ) );
            return;
        }
///     char question[256];

        if (fl_choice( "The directory %s does not exist.\n\tDo you want create it ?",
                           "Yes and continue", "Quit", 0, root ))
            return;
        else
            if (MkDir( root )) {
                fl_alert( "Cannot create the directory \"%s\"\n\t%s", root, strerror( errno ) );
                return;
            }
    }

    strncpy( RootPathStr, root, 248 );
    DstPath = new FilePath;                             // Create the destination Path and ...
    DstPath->Set( RootPathStr, 1 );                     // ... set it as root of the new volume.

    CPath = new FilePath;                               // Init the Source Filepath.

    DeepTab = new int[DstDeep+1];                       // Create the deep table to manage the ...
    DeepTab[0] = 0;
    for(int i=1; i<=DstDeep; i++)  DeepTab[i] = -1;     // ... volume tree creation.

    CurDref = new DirRefer( NULL );                     // Create the root reference directory.

    RkgCntx->SlideScan( (Slide_Process_t)SlideCopy );

    // We must close all pending directory.
    fdeep = DstDeep;
    do {
        DstPath->Set( CNTX_FNAME );                     // Create context files for each not closed directories.
        CurDref->WriteDirCntxFile( fdeep, DstPath->Path() );
        CurDref = CurDref->DelRef( CurDref );
        DstPath->Rem();
        DstPath->Rem();
    } while (fdeep-- );

    delete[] DeepTab;
    delete CPath; CPath = NULL;;
    delete DstPath;

    fl_message( "The new slide volume \"%s\" on path\n\t%s\n\t is created (appended) with success.",
                RootVNameStr, RootPathStr );


    // Now we must open the new slide volume, ...
    // ... set it all its context data and ...
    // ... save them.
    //
    

} // void Rkg_CreateVolume().



int  Rkg_SlideCopy( const char * src, const char * dst )
{
    return FileCopy( dst, src );
} // Rkg_SlideCopy( const char * src, const char * dst )



//
// Routines to manage the Ranking setup changes.
//

void Rkg_ChangeTrgPath()
{
    strncpy( RootPathStr, rkg_root->value(), 248 );
    if (tvol_pth) delete[] tvol_pth;
    tvol_pth = strdup( RootPathStr );
} // void Rkg_ChangeTrgPath().



void Rkg_ChangeTrgName()
{
    strncpy( RootVNameStr, rkg_vname->value(), 62 );
    if (tvol_nam) delete[] tvol_nam;
    tvol_nam = strdup( RootVNameStr );
} // void Rkg_ChangeTrgName().



void Rkg_NVolSelect()
{
    const char * path;
    
    path = FSvSel.Dir( "DiaViewer: Folder selection for new ranked volume", RootPathStr  );
    if (!path) return;

    if (!access( path, F_OK|R_OK|W_OK|X_OK )||(errno = ENOENT)) {
        strncpy( RootPathStr, path, 248 );
        rkg_root->value( RootPathStr );
    } else fl_alert( "Cannot get access to path \"%s\"\n\t%s", path, strerror( errno ));
} // void Rkg_NVolSelect().



static int CheckChar( char ch )
{
    if (((ch >= 'O')&&(ch <= '9'))||
        ((ch >= 'A')&&(ch <= 'Z'))||
        ((ch >= 'a')&&(ch <= 'z'))) return ch;
    switch (ch) {
        case '/':
        case '\\':
            return DIRSEP;

        case '-':
        case '_':
            return ch;
        default:
            return 0;
    }
} // CheckChar( char ch ).



static char * FiltreChar( const char * str )
{
    static char       buf[256];
    char            ch1,   ch2;
    int       i = 0,     j = 0;

    while ((i < 255)&&(ch1 = str[i])) {
        ch2 = CheckChar( ch1 );
        if (ch2) buf[j++] = ch2;
        i++;
    }
    buf[j] = 0;
    return buf;
} // static char * FiltreChar( const char * str ).



void Rkg_EnterSliHead()
// Call to define the slide head filename (a short string).
//
{
    char * str = FiltreChar( cs_head->value() );

    cs_head->value( str );
    if (slid_hde ) free( slid_hde );
    slid_hde = strdup( str );
    EditSliExa();
} // void Rkg_EnterSliHead().


void Rkg_EnterSliSepa()
// Call to define the separator between film# and slide# (a very short string/char).
//
{
    char * str = FiltreChar( cs_separ->value() );

    cs_separ->value( str );
    if (slid_sep ) free( slid_sep );
    slid_sep = strdup( str );
    EditSliExa();
} // void Rkg_EnterSliSepa().



void Rkg_ChangFlmNbLg()
// Call to define the number of figures for the film#.
//
{
    film_dig = cs_nbflm->value();
    cs_flmnb->value( NumWidth( film_dig ) );
    EditSliExa();
    SizesSliFlm(); ////
//  RkgCntx->RequiredSliEval( NumbrSli, film_dig, slid_dig );
} // void Rkg_ChangFlmNbLg().



void Rkg_ChangSliNbLg()
// Call to define the number of figures for the slide#.
//
{
    slid_dig = cs_nbsli->value();
    cs_slinb->value( NumWidth( slid_dig ) );
    EditSliExa();
    SizesSliFlm(); ////
//  RkgCntx->RequiredSliEval( NumbrSli, film_dig, slid_dig );
} // void Rkg_ChangSliNbLg().



void Rkg_EnterDirHead()
// Call to define the folder head filename (a short string).
//
{
    char * str = FiltreChar( cf_head->value() );

    cf_head->value( str );
    if (fold_hde) free( fold_hde );
    fold_hde = strdup( str );
    EditDirExa();
} // void Rkg_EnterSliHead().



void Rkg_ChangDirNbLg()
// Call to define the number of figures for the slide#.
//
{
    fold_dig = cf_nbfd->value();
    cf_dirnb->value( NumWidth( fold_dig ) );
    EditDirExa();
} // void Rkg_ChangSliNbLg().



void Rkg_EnterDirTrai()
// Call to define the folder head filename (a short string).
//
{
    char * str = FiltreChar( cf_trailer->value() );

    cf_trailer->value( str );
    if (fold_tra ) free( fold_tra );
    fold_tra = strdup( str );
    EditDirExa();
} // void Rkg_EnterSliTrai().


//
// end of <PW-Id>.
//
