//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer GL picture diaporama interpretor environment..
//

//
#ifndef DiaViewer_PRG
# define DiaViewer_PRG



#include "DiaViewer_GBL.h"
#include "DiaViewer_DIA.h"

//#include "ImageMan_REF.h"



class SlidePrg {

friend VolEntry;
friend DirEntry;
friend SliEntry;



public:
    
    int   siz_;
    char *ptb_;

    void AddCode( char ch );    
    void AddInt( int iv );
    void Build( DirEntry *, int );
    
    char * Program() { return ptb_; }
    int   ProgSize() { return siz_; }

//
// Class DiaViewer_PRG public methodes.
//

public:


    SlidePrg( VolEntry * );
    
    ~SlidePrg();
    
    void Display();

};


#endif


class SlideExec {
friend FilePath;
friend SlidePrg;
friend VolEntry;
friend DirEntry;
friend SliEntry;

private:
    VolEntry   * vol_; // The current slide volume.
    DirEntry   * dir_; // The current related directory.
    SliEntry   * sli_; // The current related slide.
    char       * prg_; // The program to execute.
    FilePath  * path_; // The current path.
    int           sz_, // The size of the code.
                stks_, // Operational stack size.
             * stack_, // The operational stack.
                  sp_, // The related stack pointer.
                  pc_, // The ordinal counter.
                  st_, // The status register.
                 idx_, // The index for slides and directories.
                 spc_, // The Search saved pc_ and ...
                 sid_, // ... slide index.
                 sdi_, // The search direction.
                 lpf_; // Loop flag for search.

    int DirPush( int );
    int DirPop();

    // Match test routine for slide search.
    int SlideMatch( int, int, int, int, const char * );

public:

    int  prsn_, prfl_, // Previous Slide Serial Number, Film Number, Paragraph Number ...
         prpa_, prch_; // ... and Chapter Number, only for left to right slide change (0 otherwise).

    int  PrgPc() { return pc_; }       // Get the Ordinal counter ...
    void PrgPc( int pc ) { pc_ = pc; } // ... and set it.

    void PrvRkgClear() { prsn_ = prfl_ = prpa_ = prch_ = 0; }
    void PrvRkgSet( int sn, int fl, int pa, int ch )
         { prsn_ = sn; prfl_ = fl;  prpa_ = pa; prch_ = ch; }
    void PrvRkgGet( int &sn, int &fl, int &pa, int &ch )
         { sn = prsn_; fl = prfl_; pa = prpa_; ch = prch_; }
    int  PrvRkgTest() { return (prsn_&&prfl_&&prpa_&&prch_); }


    SlideExec( VolEntry *, SlidePrg *); // Create the virtual processor.

    ~SlideExec();                       // Destroy the virtual processor.
    
    int Start( SlidePrg *, int = 0, int = 0, int = 0 ); // Install and start the specified slide program.
    
    int Start( int, int );              // Start execution from begin or end (use SlidePrior).
    
    int Abort();                        // Abort the execution.
    
    int Continue( int, int );           // Continue after a pause (can be change direction).

    int SlideScan( int );               // Scan slides in current directory.

    int PrgId() { return idx_; }        // return the current index.

    DirEntry * CurrDir() { return dir_; }       // Get the current directory descriptor.
    SliEntry * CurrSli() { return sli_; }       // Get the current slide descriptor.
    const char * CurrPath() { return path_->Path(); }   // Get the current directory path.

    int  SetPosition( int, int );       // Set the complete slide position in volume.

    int  Search( int, int, int, int,    // Slide Search function.
                 int, const char *, int = 0 );

    int  SearchRestore( int fl );       // To restore initial slide after a search.

    int  LoopFlg() { return lpf_; }     // To get Loop flag of Search.

};



//
// end of <PW-Id>.
//
