//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Environment of Service routines/object.
//


#ifndef DIAVIEWER_SRV_H
#define DIAVIEWER_SRV_H

#include "Service_IO.h"
#include "Service_Util.h"
#include "SetUpMan.h"




// Define MkDir as the same for all operating system.
#if defined( WIN32 ) && !defined( _CYGWIN_ )
# define MkDir( p ) mkdir( p )
#else
# define MkDir( p ) mkdir( p, S_IRWXU|S_IRGRP|S_IROTH )
#endif

#define MAX_SLI_DISPLAY 256



//
// Some global definitions.
//

//
// Define the DiaViewer Version for possible future changes.
//
#define DIAVIEWER_VERSION                     1
#define DIAVIEWER_SUB_VERSION                 2
#define DIAVIEWER_RELEASE                 "A01"
#define DIAVIEWER_VERFORMAT "DVW %3d.%3.3u-%3s"

// The next definition must be in agreement with the previous one and ...
// ... the fixed format "DVW %3d.%3.3u-%3s"
#define DIAVIEWER_STRVERS     "DVW   1.001-A01"


// User environment file space (depending of operating system).

#if defined( WINHOME ) || defined( WIN32 ) 
# define USER_ENV "LOCALAPPDATA:.DiaViewer,LOCALAPPDATA:"
# define USER_DIR "USERPROFILE:"
#else
# define USER_ENV "HOME:.DiaViewer,HOME:"
# define USER_DIR "HOME:"
#endif



#define PATH_ALLOC_STEP 64



//
// Define some common types.
//
typedef unsigned  char   UChar; // Our insigned character or unsigned 8 bits.
typedef unsigned short  UInt16; // Our Insigned 16 bits.
typedef unsigned   int  UInt32; // Our Insigned 32 bits.
typedef            char  SChar; // Our signed character or signed 8 bits.
typedef          short  SInt16; // Our Signed 16 bits.
typedef            int  SInt32; // Our Signed 32 bits.
typedef         void *  ObjPtr; // Define a pointer a undefined object.



typedef enum {
    PrintGL_Full    =        1, // Flag to print the Full DiaViewer window.
    PrintGL_Text    =        2, // Print image with the text comment.
    PrintGL_Ident   =        4, // Print the slide identifiers (in the Title).
    PrintGL_OIdent  =        8  // Display the originam slide reference (in the text).
} PrintGLFlags;


typedef  enum {
    SwFlg_Ranking   =        1, // Flag for opened ranking sub-window,
    SwFlg_Search    =        2, // Flag for opened search sub-window,
    SwFlg_SliChart  =        4  // Flag for opened slide chart Map sub-window.
} SwFlg_t;


typedef enum {
    Glbf_ScLim      =        1, // Flag for Scan Directory Limits Ignored,
    Glbf_SliPr      =        2, // Flag for scan in deep before (deep prior).
    Glbf_NtOpn      =        4, // Flag to use system native open/select files.
    Glbf_FuPrt      =        8  // Flag to valid the direct Print of DiaViwer_GL window.
} Glb_Flags;


extern int           Glb_Flagw; // Flags for DiaViewer Global effects.

extern int            DfntSize; // DiaViewer font size to for use Comment/Text.
extern char *         DfntName; // DiaViewer font name to for use Comment/Text.

extern float          View_frm; // To save the last View_GL used format.
extern int            View_geo, // To save the last View_GL used geometry.
                      View_mrg, // To save the magin between text and image.
            View_wid, View_hei, // To save the last sizes of Prev_View.
                      VfntSize; // Prev_View font size.
extern char *         VfntName; // Prev_View font name.

extern int        Jpeg_Quality; // Jpeg Quality factor use when create a jpeg/jpeg2000 file.

extern int  screen_w, screen_h, // Usable size of the screen (to size any windows) ...
                      screen_n; //  ... and its number.

extern float scrdpi_x,scrdpi_y; // Screen resolutions pixel/Inch.

extern int              svargc; // To keep the task arguments number ...
extern char          ** svargv; // ... and the task arguments list.
extern char        *  User_Dir; // Path directory of the user.

extern SetUpDynTab   VolToOpen, // Table of index of volume to open on start.
                     VolP2Open, // Table of volume to open at application start time (temp.).
                      WinTable, // To keep all windows (to create at start time) data.
                     //  The next tables should be replaced by the table WinTable.
                     WinVolume, // Table of assigned Volume for each window.
                     WinSelSli; // Table of values to select previous dispalyed slides.

extern int            rktb_wid, // Slide Ranking map ...
                      rktb_hig, // ... sizes.
                      rktb_tsz, // Slide Ranking Map Title font size ...
                      rktb_esz; // ... and table element Font size.

extern int            vltb_wid, // Window width ...
                      vltb_hig, // ... and high.
                      vltb_tsz, // Font size for the text title ...
                      vltb_esz; // ... and table elements.

extern int            slid_dig, // Number of figures for Slide#,
                      film_dig, // Number of figures for Film#,
                      fold_dig, // Number of figures for Directory/folder,
                      flmn_max, // Maximum value of film number (#),
                      slin_max, // Maximum value of slide number (#),
                      dirslisz, // Max. number of slides/folder in the target volume,
                      dirdirsz; // Max. number of Folder/folder in the target volume.

extern char         * slid_hde, // Slide filename header string,
                    * slid_sep, // Slide filename separator string,
                    * fold_hde, // Folder/Directory filename header string.
                    * fold_tra; // Folder/Directory filename trailer string.

extern char         * tvol_pth, // The Path of ranking target volume.
                    * tvol_nam; // The Name of ranking target volume.




//
// Main SetUp definitions
//


extern LogFile            LogF; // Log file to write historic and/or operation debug.

extern char       MsgBuf[1024]; // Buffer for any message.

extern FilePath      *   CPath; // The CPath common FilePath must be visible out of any class.

extern int  win_dx,     win_dy; // Default Window size.

extern int          SlidePrior, // Flag for scan priority for directories ...
                                // ... (for 0) or for slides if not 0.
                    NativeOFil; // Flag to use native openfile and directory.


//
// Image_Ref definitions
//
extern      int   IIdeOverflow, // Flag for IIde_t overflow.
                  SliCacheSize, // Size to use for Image Cache.
                  IIdeMaxSli,   // Maximum possible # of a slide.
                  IIdeFld[2];   // Sizes of ident fields [0/1] slides/Directories. 

//
// Main Program and GL definitions
//
extern ObjTable   OpenVolTable; // The table of all opened slides volumes ...


extern char      * OpenVolPath, // Default Open Volume Path.
                 * UserHelpUri, // User Help HTML URI.
                * SlideEditPrg; // Slide Editor program.


//
// Some external function definitions.
//

bool  GlbTst( Glb_Flags fl );
void  GlbSet( Glb_Flags fl );
void  GlbClr( Glb_Flags fl );

//const char * DLG_DirChooser( const char * msg, const char * fnm ); // From DL module.




#endif

//
// end of <PW-Id>.
//
