//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for slide comment editor.
//

#include <string.h>
#include <stdio.h>

#include <FL/Fl.H>
#include <fl_ask.H>
#include <FL/utf8.H>


#include "DiaViewer_SPCH.h"


// Use to connect the special activation of special character key to the Spch_TextEdit class.
static Spch_TextEdit * edit;


Spch_TextEdit::Spch_TextEdit( int x, int y, int w, int h, const char *title )
             : Fl_Text_Editor( x, y, w, h, title )
{
    edit = this;
    textfont( FL_COURIER );
    textsize( 16 );
    add_key_binding( 'i', FL_CTRL, (Key_Func)Link_Display, &key_bindings );
} //



int Spch_TextEdit::Link_Display( int ch, Fl_Text_Editor * e )
{
    edit->Show_Display( ch);
    edit = 0;
}


void Spch_TextEdit::Show_Display( int ch )
// Display the special characters table to select and insert.
{



} // void Spch_TextEdit::ShowDisplay( int ch ).



//
// end of <PW-Id>.
//
