//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environment of Service Stack of any objects.
//

//#include <bits/types.h>
//#include <stdlib.h>
#include <string.h>

#include "Service_STACK.h"

//#define STACK_DEBUG

//
// Object Stack class routines to manage a table of undefined objects.
// The size of object are free but, all in the table must have the same size.
//
//
//

#define MASK_ALIGN    7

void ObjStack::InitStk( size_t els, UInt_8 ** usp, int incr )
{
    if (inc_ || tab_ || use_) return;

    if (incr < 16) incr = 16;
    els_ =   els;  incr *=    els_;     // Set the element size and comput .
    nal_ =  (els_ & MASK_ALIGN);        // Get alignement Mask for the element type.
    inc_ = 16;
    while (inc_ < incr) inc_ *= 2;      // Find an allocation increment for a minimum of 8 elem.
    usp_ = usp;
    if (*usp_) *usp = 0;
} // void ObjStack::InitStk( int els, void * usp).



void ObjStack::Increment( int incr )
{
    if (!inc_) return;
    if (incr < 16) incr = 16;
    if (inc_ && els_) {
        incr *= els_;
        inc_ = 16;
        while (inc_ < incr) inc_ *= 2;
    }
} // void ObjStack::Increment( int incr ).



void ObjStack::IniAlloc( int size )
{
    int rsz = 32;

    if ( !tab_ && inc_ && els_) {
        while(rsz < size) rsz *= 2;
        tab_ = new UInt_8[rsz];
        stp_ = tab_ - els_;
        if (usp_) *usp_ = 0;
    }
} // void ObjStack::IniAlloc( int size ).



ObjStack::ObjStack()
          { els_ = nal_ = inc_ = use_ = all_ = 0; tab_ = stp_ = 0; usp_ = 0; ovf_ = 0; }

ObjStack::ObjStack( int els, UInt_8 ** usp )
// Arg 1 : The element size is in bytes.
// Arg 2 : The pointer of the user stack pointer (if defined, update for each stack operation.)
// Arg 3 : The flag
//
{
    int minc = 8;                       // Define a minimum increment.

    InitStk( els, usp );                // Fit the Stack parameter with object size.
    all_ =          use_ =           0; //
    ovf_ =    0;    tab_ =  stp_ =   0; // Allocate the starting stack size.
                                        // Default on Init : No Overflow routine.
} // ObjStack::ObjStack( int els, int pw2i, int fal ).


ObjStack::ObjStack( int els, int tbs, UInt_8 * tab, UInt_8 ** usp )
// Specific construction to use a localy stack array (extern/static/automatic stack table).
//
{
    els_ = els;                         // Set the element size.
    nal_ =      (els_ & MASK_ALIGN);    // Get alignement Mask for the element type.
    inc_ =   0;                         // Pas d'increment when fixed stack size.
    all_ = tbs; use_ = 0;               // Set the stack size and stack empty.
    usp_ = usp;  tab_ = tab;            // Link the user stack pointer, set stack table ...
    stp_ = tab_ - els_;                 // ... adress and init the stack pointer.
    ovf_ =   0;                         // Default on Init : No Overflow routine.
    if (usp_) *usp_ = 0;
} // ObjStack::ObjStack( int els, int tbs, UInt_8 * tb, UInt_8 ** usp ).


void ObjStack::Fix_Init( int els, int tbs, UInt_8 * tab, UInt_8 ** usp )
{
    els_ = els;                         // Set the element size.
    nal_ =      (els_ & MASK_ALIGN);    // Get alignement Mask for the element type.
    inc_ =   0;                         // Pas d'increment when fixed stack size.
    all_ = tbs; use_ = 0;               // Set the stack size and stack empty.
    usp_ = usp;  tab_ = tab;            // Link the user stack pointer, set stack table ...
    stp_ = tab_ - els_;                 // ... adress and init the stack pointer.
    ovf_ =   0;                         // Default on Init : No Overflow routine.
    if (usp_) *usp_ = 0;
} // void ObjStack::Fix_Init( int els, int tbs, UInt_8 * tab, UInt_8 ** usp ).



void ObjStack::ElmCpy( UInt_8 *p, UInt_8 *q, int sz ) {
    sz *= els_;
    switch( nal_ ) {
        case 1: case 3: case 5: case 7: MemCpy( p, q, sz );
        case 2: case 6: MemCpy( (UInt16*)p, (UInt16*)q, sz >>1 );
        case 4: MemCpy( (UInt32*)p, (UInt32*)q, sz >>2 );
        case 0: MemCpy( (UInt64*)p, (UInt64*)q, sz >>3 );
    }
} // void ObjStack::ElmCpy( UInt_8 *p, UInt_8 *q, int sz ).



UInt_8 * ObjStack::Push( UInt_8 * src ) {
    UInt_8       * ntab;
    int     nsz,    ovf;

    nsz = use_ + els_;                  // Compute the required space.
    if (nsz > all_) {                   // If we have a stack size overflow ...
        // For ObjStack_F or for ObjStack (if any user handler return True) we stop the Push.
        if ((ErrHandler(use_) || !inc_))// If OverFlow error handler return TRUE,
            return 0;                   //  we stop push and return null pointer.
        nsz = all_ + inc_;              // ... we compute the nnew stack size.
        ntab = new UInt_8[nsz];         // Create the new increased stack space.
        if (tab_) {
            ElmCpy( ntab, tab_, use_ ); // Copy the old stack in the new one.
            delete[] tab_;              // Free the old stack ...
        }
        tab_ = ntab; ntab = 0;          // ... and install the new one and ...
        all_ = nsz;                     // ... Set the new stack size, edit the ...
        stp_ = tab_ + use_ - els_;      // ... edit the local stack pointer and ...
                                        // ... copy and the new size of the stack.
        if (usp_) *usp_ = stp_;         // If defined, set user copy of stack pointer.
    }
    stp_ += els_;                       // Update the Stack pointer.
    if (usp_) *usp_ = stp_;
    use_ += els_;
    ElmCpy( stp_, src );                // Put the new element in the stack.
    return stp_;                        // Return the Top Stack pointer.
} // UInt_8 * ObjStack::Push( UInt_8 * elm ).



UInt_8 * ObjStack::Pop( UInt_8 * dst ) {
    if (use_ < els_) return 0;          // Return NULL if the stack is empty (underflow).
    ElmCpy( dst, stp_ );                // Copy the element to the user location ...
    use_ -= els_;                       // Edit the used stack size and the stack pointer.
    stp_ -= els_;                       // Set the copy just at the base of last element of stack.
    if (usp_ && stp_ >= tab_) {         // If the stack is not empty ...
        *usp_ = stp_;                   // ... we update the stack pointer user copy ...
        return stp_;                    // ... and return it to the user, ...
    } else return (*usp_ = 0);          // ... else return null stack pointer.
} // UInt_8 * ObjStack::Pop( UInt_8 * ).




#ifdef STACK_DEBUG

#include <stdio.h>

typedef struct { double f, g; int t[5]; } ST;



void prt_st( const char * nm, ST s ) {
    printf( " %s = { %5.2lf, %5.2lf,", nm, s.f, s.g );
    for(int i = 0; i < 5; i++) printf( " %4d", s.t[i] );
    printf( " }\n" );
} // void prt_st( const char * nm, ST s ).


/*
#ifdef ST_SPECIFIC

class ST_STK : public ObjStack {
public:
    ST_STK() : ObjStack( sizeof( ST ) ) { }

    ST * Push( ST * o )  { return (ST *) ObjStack::Push( (UnByte *) o ); }

    ST * Pop(  ST * o )  { return (ST *) ObjStack::Pop(  (UnByte *) o ); }

    void ElmCpy( ST *p, ST *q ) { ObjStack::ElmCpy( (UnByte*)p, (UnByte*)q ); }
}; // class ST_STK.


#endif
*/


int main() {

    Any_STK<ST> * ptr, * qtr;


    ST * sp = 0, * fsp = 0;
    ST * pp;

    ST st1 = { 3.5, 3.14, -1,  2, -3,  4, -5 },
       st2 = { 1.0, 0.50,  1,  1,  2,  3,  5 };

//  ptr = new Any_STK<ST>( sizeof( ST ), &pp );     // Creation direct du stack
//  ptr = new Any_STK_D( ST, stk, pp );

//  Any_STK<ST> stk( sizeof( ST ), &sp );           // Creation direct du stack
    Any_STK_L( ST, stk, sp );                       // Creation du Stack par la macro.
//  stk.Setup( 300, (UInt_8**)(&sp) );
    ST fstktb[12];

    printf( " %d %d\n", (int) sizeof( fstktb ), (int) sizeof( fstktb[0] ) );
//  FixStack<ST> fstk( sizeof( ST ), sizeof( fstktb ), (ST*)fstktb, & fsp );

    Any_STK_F( ST, fstk, fstktb, fsp );

    printf( " size( ST ) = %d\n", (int) sizeof( ST ) );

    ST st3;

    prt_st( "st1", st1 );
    prt_st( "st2", st2 );

    stk.Push( st1 ); printf( " 1er  Push : st1 fait\n" );
    stk.Push( st2 ); printf( " 2eme Push : st2 fait\n" );
    stk.Push( st1 ); printf( " 3eme Push : st1 fait\n" );
    prt_st( " Apres 3eme : Push( st1 ) accée par le pointer: sp", *sp );

    printf( " Accée des 3 éléments dans le stack par le pointer sp\n" );

    prt_st( " Stack dyn top sp[ 0] ", sp[ 0] );
    prt_st( " Stack dyn top sp[-1] ", sp[-1] );
    prt_st( " Stack dyn top sp[-2] ", sp[-2] );

    printf( " Avec 3 éléments   sp = %x\n", sp );

    stk.Pop( st3 ); printf( " Pop -> st3\n" );
    pp = stk.Pop( st1 ); printf( " Pop -> st1\n" );

    printf( " Avec encore 1 élément :  sp = %x, pp = %x\n", sp, pp );

    stk.Pop( st2 ); printf( " Pop -> st2\n" );

    printf( " Sans éléments  sp = %x\n", sp );

    prt_st( "st1", st1 );
    prt_st( "st2", st2 );
    prt_st( "st3", st3 );

    if (stk.Empty()) printf( " Le stack est vide !\n" );

    printf( " Avant un underflow :  sp = %x, pp = %x\n", sp, pp );

    pp = stk.Pop( st3 );

    printf( " Après un underflow :  sp = %x, pp = %x\n", sp, pp );

    printf( " with Fix stack\n" );
    fstk.Push( st1 );
    fstk.Push( st2 );

    prt_st( " Stack fix top fsp[ 0] ", fsp[ 0] );
    prt_st( " Stack fix top fsp[-1] ", fsp[-1] );

    fstk.Pop( st1 );
    fstk.Pop( st2 );

    printf( " st1 and st2 retrouve leus valeurs initiales\n");

    prt_st( "st1", st1 );
    prt_st( "st2", st2 );

    return 0;
}  // int main().

#endif


