//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Module for a View (Image and or text).
//


#include <stdio.h>
#include <string.h>
#include <math.h>


#include <FL/Fl.H>
#include <FL/gl.h>
#include <FL/fl_draw.H>
#include <FL/fl_utf8.h>
#include <FL/fl_message.H>
#include <FL/Fl_Gl_Window.H>

#include <GL/glu.h>

//#include <map>
//#include <FTGL/ftgl.h>

#include "View_Win_new.h"
#include "View_GL_UI.h"






void View_GL::SetFormat( float R )
{
    int w_gx, w_gy, w_gw, w_gh,
        g_cx, g_cy;

    float   rg;

    w_gx = W_ggl->x(); w_gy = W_ggl->y();
    w_gw = W_ggl->w(); w_gh = W_ggl->h();
    g_cx = w_gw/2 + w_gx; g_cy = w_gh/2 + w_gy;

    rg = float( g_cy )/float( g_cx );
    if (rg > R) {
        w_glh_ = w_gh; w_glw_ = w_gh/R;
        w_glx_ = (w_gw - w_glw_)/2;
        w_gly_ = w_gy;
    } else {
        w_glw_ = w_gw; w_glh_ = w_gw*R;
        w_gly_ = (w_gh - w_glh_)/2;
        w_glx_  = w_gx;
    }
    resize( w_glx_, w_gly_, w_glw_, w_glh_ );
} // View_GL::SetFormat()



View_GL::View_GL( int x, int y, int w, int h, const char * L ):
          Fl_Gl_Window( x, y, w, h, L )
{
    Vgl_ui = new View_GL_UI( x, y, w, h, L );
    Vgl_ui->w_main = this;

    W_ggl    = Vgl_ui->w_ggl;
    W_frame  = Vgl_ui->w_frame;
    W_ftname = Vgl_ui->w_ftname;
    W_ftsize = Vgl_ui->w_ftsize;

    ratiof_ = 0.75;                             // Default to 3/4 Landscape.
    SetFormat( ratiof_ );

} // View_GL::View( int x, int y, int w, int h, const char * L ).



void View_GL::Quit_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Quit_CB( Fl_Widget *, void * data ).


void View_GL::Format_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Format_CB( Fl_Widget *, void * data ).


void View_GL::Geometry_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Geometry_CB( Fl_Widget *, void * data ).


void View_GL::Print_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Print_CB( Fl_Widget *, void * data ).


*
void View_GL::SaveAs_CB( Fl_Widget * w, void * data ) {

} // void View_GL::SaveAs_CB( Fl_Widget *, void * data ).


void View_GL::Reload_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Reload_CB( Fl_Widget *, void * data ).


void View_GL::UnZoom_CB( Fl_Widget * w, void * data ) {

} // void View_GL::UnZoom_CB( Fl_Widget *, void * data ).


void View_GL::About_CB( Fl_Widget * w, void * data ) {

} // void View_GL::About_CB( Fl_Widget *, void * data ).


void View_GL::Help_CB( Fl_Widget * w, void * data ) {

} // void View_GL::Help_CB_CB( Fl_Widget *, void * data ).


void View_GL::ChangeFont_CB( Fl_Widget * w, void * data ) {

} // void View_GL::ChangeFont_CB_CB( Fl_Widget *, void * data ).


void View_GL::ChangeFtsize_CB( Fl_Widget * w, void * data ) {

} // void View_GL::ChangeFtsize_CB( Fl_Widget *, void * data ).






View_Win::View_Win( int x, int y, int w, int h, const char * L ) : Fl_Gl_Window( x, y, w, h, L )
{
//  Win_Init      =            1; // To force GL context init on the first call of draw() method.
//  Win_UInb      = ViewerNumber, // Get the DiaViewer_Ui index in DiaViewer_GL class.
//  Win_Start     =            0; // Default is not created at start time.




    w_widt   =  w; w_high   =  h; // Default GL windows as 24*36 ??? Landscape Diapositive, ...
                                  // ... with a scale of ww/24 pixels/mm.

    geometry_   =                    Img_Undef; // Default for automatic config choice.
    txt_img_    =                          0.2; // Defaut when a text is given.
    format_     =                            1; // A Landscape.
    vfsize_     =                           14; // default for fontname and font size.
    vfname_     =        strdup( "Helvetica" );
    vtitle_     =  (L&&L[0]) ? strdup( L ) : 0; // Set the label/title is given.
    vitext_     =                            0;
    rgb_img_    =                            0;

    // The initiale Diapositive is an empty diapositive (black).
    r_scale       =          1.0; // Just to initialize.
    ViewReady    9 =            0; // To force the GL and Viewer Initialisation.


} // View_Win::View_Win( int x, int y, int w, int h, const char * L ).




Fl_RGB_Image * View_Win::BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh )
{
  int       src_rsz,   dst_rsz,
            src_wid,   src_hig,
            dst_siz,  ira, ipc,
                            pp;

  uchar   * src_cra, * src_cco,
          * dst_cra, * dst_cco;
  uchar   * src_map, * dst_map; // Define the source and destination pixel map pointers.

  Fl_RGB_Image         * flimg;


  pp            =     src->P(); // Get the pixel size and raw alignement mask.
  src_wid       =     src->W(); // Get the original width (in pixels) of image.
  src_hig       =     src->H(); // Get the original hight (in pixels) of image.
  src_map       =   src->Map(); // Get the source (src) image pi=xel map.

  if (ww > src_wid) ww = src_wid;
  if (xx < 0) xx = 0;
  else if (xx + ww > src_wid) xx = src_wid - ww;

  if (hh > src_hig) hh = src_hig;
  if (yy < 0) yy = 0;
  else if (yy + hh > src_hig) yy = src_hig - hh;

  src_rsz       =   pp*src_wid; // Get the original size (in byte) of image raws.
  dst_rsz       =        pp*ww; // Get the size (in byte) of final pixel map raws.
  dst_siz       =   dst_rsz*hh; // Get the final pixel map image size.

  dst_map = new GLubyte[dst_siz];       // Allocate the print map and ...

  src_cra = src_map + yy*src_rsz+xx*pp; // Set the src current raw -> first pixel of the src image (first dst pixel) (at image bottom).
  dst_cra = dst_map + dst_siz;          // dst_raw -> first not existing dst pixel map raw (below the bottom image).
  for(ira = 0; ira < hh; ira++) {
    dst_cra -= dst_rsz;                 // dst_cra -> first pixel of src current raw (starting from bottom raw).
    dst_cco  = dst_cra;                 // dst_cco = dst_cra to init the dst raw filling.
    src_cco  = src_cra;                 // src_cco -> first byte to copy in the destination.
    for(ipc = 0; ipc < dst_rsz; ipc++)  // Loop to fill all pixels (dst_rsz bytes) of the raw.
      *(dst_cco++) = *(src_cco++);
    src_cra += src_rsz;                 // src_cra -> first pixel of dst for next raw (starting from the top raw).
  }

  flimg = new Fl_RGB_Image( dst_map, ww, hh, pp, dst_rsz );
  flimg->alloc_array = 1;

  return flimg;
} // static Fl_Image * View_Win::BuildImage( Image_REF * src, GLint xx, GLint yy, GLint ww, GLint hh ).



void View_Win::Viewer_Init()
{

} // View_Win::Viewer_Init().


/*
void View_Win::Image( Image_REF * img, GLint x, GLint y, GLint w, GLint h )
// x and y are the positio of zoom selected image part in the total image map
// w and are the sizes of this section. Without zoom, x = y = 0 and
// w = img->W() and h = img->H().
//
{
    float      ydivx = 1.0;

    // Get the Image map (a map rectangular part when zoom was used).
    rgb_img_ = BuildImage( img, x, y, w, h );

    switch (format_) {
      case 1: // Any square formats.
        ydivx = 1;
        break;
      case 2: // A1 to A5 Landscape :
        ydivx = sqrt( 2.0 );
        break;
      case 3: // A1 to A5 Portrait :
        ydivx = 1.0/sqrt( 2.0 );
        break;
      default: ; // user defined format (ydivx is already set).
    }

} // View_Win::Image( Image_REF * img, GLint x, GLint y, GLint w, GLint h ).
*/




void View_Win::Show( int sargc, char ** sargv )
{
    View_UI->show( sargc, sargv );

} // void View_Win::Show().



void View_Win::Font( const char * fn, int sz )
{
  if (!(fn && sz)) return;
  vfname_ = strdup( fn );
  vfsize_ = sz;
} // void View_Win::Font( const char * fn, int sz ).



void View_Win::ChangeFont()
{

} // void View_Win::ChangeFont().



void View_Win::ToPrint()
{


  evfunc_( 0 );
} // void View_Win::ToPrint().



void View_Win::Quit()
{
  evfunc_( 0 );
} // View_Win::Quit().



//
// Private methods.
//


void View_Win::MouseDown( int x, int y, int button )
{
  if (!MouseStat) {     // When the mouse is active without button already pushed.
    zre_x1 = x, zre_y1 = y;
    zre_x2 = x, zre_y2 = y;
    fl_cursor( FL_CURSOR_CROSS );
    UsedButton = button;
    MouseStat = 1;
  }
} // void View_Win::MouseDown( int x, int y, int button ).



void View_Win::MouseDrag( int x, int y, int button )
{
  if (UsedButton!=button) {
    MouseStat = 0; return;
  }
  if ((x!=zre_x2)||(y!=zre_y2)) {
    zre_x2 = x; zre_y2 = y;
    redraw();
  }
} // void View_Win::MouseDrag( int x, int y, int button ).



void View_Win::MouseUp( int x, int y, int button )
{
  GLfloat zw, zh;

  if (UsedButton!=button) {
    MouseStat = 0; return;
  }
  zre_x2 = x; zre_y2 = y;
  fl_cursor( FL_CURSOR_DEFAULT );
  MouseStat = 0;

  zw = 0.5*abs( zre_x2 - zre_x1 ); zh = 0.5*abs( zre_y2 - zre_y1 );
  if ((zw > 50.0)&&(zh > 50.0)) {
    // Increase one rectangle size to fit with window proportions.
    if (zh*w_hwid > w_hhig*zw) zw = (zh*w_hwid)/w_hhig;
                          else zh = (zw*w_hhig)/w_hwid;
    // Get the showed view center translation vector (or new center coord.) ...
    // ... in the image coordinates.
    i_zcex = round( 0.5*(zre_x1 + zre_x2) ) /* + i_cenx */;
    i_zcey = round( 0.5*(zre_y1 + zre_y2) ) /* + i_ceny */;
    i_zshw = round( zw ); i_zshh = round( zh );

#ifdef GL_DEBUG
    printf( " SCALE = %f\n", r_scale );
    printf( " Z rect : x1=%d, y1=%d, x2=%d, y2=%d\n", zre_x1, zre_y1, zre_x2, zre_y2 );
    printf( " Center at (%d, %d)\n", i_zcex, i_zcey );
#endif

    ZoomStatus = 1;
  }
  redraw();
} // void View_Win::MouseUp( int x, int y, int button ).



void View_Win::XYinImage( int &x, int &y )
// Get the pointed coordinate in the image pixels space.
{
  x = round( (Fl::event_x() - w_hwid)/r_scale ) + i_cenx;
  y = round( (w_hhig - Fl::event_y())/r_scale ) + i_ceny;
} // void View_Win::XYinImage( int &x, int &y ).



int  View_Win::handle( int evn )
{
    int       mx,   my;
    int       ky,   bt;

      bt = Fl::event_button();
  switch (evn) {
    case FL_LEAVE: // The mouse has moved out of the DiaVIewer_GL widget.
//    printf( " Go out of GL Widget\n" );
      clear_visible_focus();

      return 1;
    break;

    case FL_ENTER:
//    printf( " Enter in the GL Widget\n" );
      return 1;
    break;

    case FL_FOCUS:
    case FL_UNFOCUS:
      return 1;
    break;

    case FL_PUSH:  //
      if (Fl::event_inside(this)) set_visible_focus();
                             else clear_visible_focus();
//    printf( " Focus is %d\n", Fl::visible_focus() );
      if (Fl::visible_focus())take_focus();
      XYinImage( mx, my );
      MouseDown( mx, my, bt );
      return 1;
    break;

    case FL_DRAG:
      XYinImage( mx, my );
      MouseDrag( mx, my, bt );
      return 1; redraw();
    break;

    case FL_RELEASE:
      XYinImage( mx, my );
      MouseUp( mx, my, bt );
      return 1;
    break;

//  case FL_MOUSEWHEEL:
//
//  break;
/*
    case FL_KEYBOARD:
      switch (ky = Fl::event_key()) {
        case FL_Left:
          if (Fl::event_state( FL_SHIFT )) DirScan( -1 );
                                      else SliScan( -1 );
          return 1;
        break;

        case FL_Right:
          if (Fl::event_state( FL_SHIFT )) DirScan(  1 );
                                      else SliScan(  0 );
          return 1;
        break;

        case FL_Up:

        break;

        case FL_Down:

        break;

        default: ;
      }
*/
    default: ;
  }
  return Fl_Gl_Window::handle( evn );


} // int  View_Win::handle( int ev ).




void View_Win::draw()
// called to re-draw the GL window.
//
{
  GLint    whwid,        whhig, // Half display size in image pixels.
           map_x,        map_y; // PixelMap origine on Display.
  GLenum                maptyp;
  GLfloat   rx_scale, ry_scale;

#ifdef  GL_DEBUG
  static GLdouble ProMat[16], ModMat[16];
  static GLdouble xxo, yyo, zzo, xlm, ylm, zlm;
  static GLint ierr, VWP[4];
#endif

  if (Win_Init) Viewer_Init();

#ifndef MESA
  glDrawBuffer(GL_FRONT_AND_BACK);
#endif // !MESA

  if (!valid()) {               // GL Init is done.
    w_widt  =          w(); w_high  =          h();
    w_hwid  =     w_widt/2; w_hhig  =     w_high/2;
    // Set the display pixel origine on the GL Window center in a 3D space.
    // glOrtho( (GLfloat)-w_hwid, (GLfloat)w_hwid, (GLfloat)-whhig, (GLfloat)w_hhig, -20.0, 20.0 );
    valid( 1 );
  }
//printf( " For w # %d, VR %d\n", Win_UInb, ViewReady ); fflush( stdout );

//printf( " For w # %d, VR %d\n", Win_UInb, ViewReady ); fflush( stdout );

  if (!ViewReady) { // This sequence is executed only during a window_GL creation.
    ViewReady  = 1;
//  if (Curr_Vol) InitStdScan( Curr_Vol );
//  if (Curr_Sli&&Curr_Dir) ShowSlide( 1 );
/*
    if (Win_UInb == 0) {
      for(int iw = 1; iw < ViewerNbWin; iw++) {
//      printf( " For win %d\n", iw );
        IniSelVolum = (VolEntry*)OpenVolTable.GetObj( WinTable.tab.i[4*iw] );
        SliEntry::CacheSplit( iw );
        Init( iw, 1 );
      }
    }
*/
  }


//printf( " Draw Process\n" ); fflush( stdout );

  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
//printf( "Clear: map %d, mouseSt %d\n", Curr_Map!=0, MouseStat ); fflush( stdout );
  if (Curr_Map) {

//  Already done by ShowSlide().
//  i_shww = i_hwid = (i_widt = Curr_Sli->W())/2;
//  i_shhh = i_hhig = (i_high = Curr_Sli->H())/2;
//  ii_pxs = Curr_Sli->P();

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( "\n ****\n DR Window sizes (screen pixels) : %d, %d\n", w_widt, w_high );
      printf( " DR Half image sizes  (image  pixels) : %d, %d\n", i_hwid, i_hhig );
      printf( " DR Image Limits ; x [%d..%d], y [%d..%d]\n", img_x1, img_x2, img_y1, img_y2 );
      fflush( stdout );
    }
#endif

    if (ZoomStatus) {
      // Executed after a Zoom mouse command.
      // Test validity of the zoom.
      if (i_zcex-i_zshw < i_hwid && i_zcex+i_zshw > -i_hwid &&
          i_zcey-i_zshh < i_hhig && i_zcey+i_zshh > -i_hhig) {
        // Update the center of showed rectangle in image coordinates.

#ifdef GL_DEBUG
        printf( " DR Zoom Half showed sizes (image  pixels) : %d, %d\n", i_zshw, i_zshh );
        printf( " DR Zoom Center of showed zoom (image  pixels) : %d, %d\n", i_zcex, i_zcey );
        fflush( stdout );
#endif

        FirstView = 0;
        if ((GLfloat)w_hwid/i_zshw <= 5.0 || (GLfloat)w_hhig/i_zshh <= 5.0)
        { // Limit the scale at 5.0 (5 Screen_Pixel/Image_Pixel)
          i_cenx = i_zcex; i_ceny = i_zcey;
          i_shww = i_zshw; i_shhh = i_zshh;
        }
      }
      ZoomStatus = 0;
    }

    if (X_shift) {
      i_cenx += X_shift;
      X_shift = 0;
    }

    if (Y_shift) {
      i_ceny +=  Y_shift;
      Y_shift = 0;
    }

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR Half showed sizes (image  pixels) : %d, %d\n", i_shww, i_shhh );
      fflush( stdout );
    }
#endif

    // Compute the display scale (in Display_Pixels/Image_Pixels).
    if (!SetScaVal) {
      rx_scale = (GLfloat)w_hwid/i_shww; ry_scale = (GLfloat)w_hhig/i_shhh;
      r_scale = (rx_scale < ry_scale)? rx_scale : ry_scale;
      if (FirstView&&(r_scale > 1.0)) r_scale = 1.0;
    } else SetScaVal = 0;

//  W_zoom->value( r_scale );

    // Get the window size in image size.
    whwid = w_hwid/r_scale; whhig = w_hhig/r_scale;

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR scale = %10.6f\n", r_scale );
      printf( " DR Half Display sizes (Image pixels) : %d, %d\n", whwid, whhig );
      printf( " DR Part of image (%d, %d), Half display Size (%d, %d)\n", i_cenx, i_ceny, whwid, whhig );
      fflush( stdout );
    }
#endif

    // Get the future visible image part rectangle limits.
    cur_x1 = i_cenx -  whwid; cur_y1 = i_ceny -  whhig;
    cur_x2 = i_cenx +  whwid; cur_y2 = i_ceny +  whhig;

    // Compute the pixel and row to skip when required.
    if (img_x1 < cur_x1) { i_spix = cur_x1 - img_x1; map_x = cur_x1; }
                    else { i_spix = 0; map_x = img_x1;}
    i_npix = ((img_x2 > cur_x2)? cur_x2 : img_x2) - map_x;

    if (img_y1 < cur_y1) { i_srow = cur_y1 - img_y1; map_y = cur_y1; }
                    else { i_srow = 0; map_y = img_y1; }
    i_nrow = ((img_y2 > cur_y2)? cur_y2 : img_y2) - map_y;

//  W_xscroll->value( i_spix, i_npix, 0, i_widt );
//  W_yscroll->value( i_high -i_srow - i_nrow, i_nrow, 0, i_high );

#ifdef GL_DEBUG
    if (!MouseStat) {
      printf( " DR *** GL ViewPort : (%d, %d)\n", w_widt, w_high );
      printf( " DR *** Image space Rectangle : %d, %d, %d, %d\n", cur_x1, cur_y1, cur_x2, cur_y2 );
      printf( " DR *** Scale = %8.5f, MapSizes = (%d, %d)\n", r_scale, i_npix, i_nrow );
      printf( " DR *** Skip Pixels,Rows (%d, %d), MapOrg. = (%d, %d)\n", i_spix, i_srow, map_x, map_y );
      fflush( stdout );
    }
#endif

    // Define the showed image space.
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glViewport( 0, 0, w_widt, w_high);  // Set the GL ViewPort.
    glOrtho( (GLdouble)cur_x1 - 0.5, (GLdouble)cur_x2 + 0.5,
             (GLdouble)cur_y1 - 0.5, (GLdouble)cur_y2 + 0.5,
                        -1.0,             1.0
           );

#ifdef GL_DEBUG
    glGetDoublev( GL_PROJECTION_MATRIX, ProMat );
    glGetDoublev( GL_MODELVIEW_MATRIX, ModMat );
    glGetIntegerv( GL_VIEWPORT, VWP );
    ierr = gluProject( (GLdouble)img_x1, (GLdouble)img_y1, 0.0, ModMat, ProMat, VWP,  &xxo, &yyo, &zzo );
    printf( " DRC err = %d, Win Coord img l,d in window: %fl, %fl\n", ierr, xxo, yyo );
    ierr = gluProject( (GLdouble)img_x2, (GLdouble)img_y2, 0.0, ModMat, ProMat, VWP, &xlm, &ylm, &zlm );
    printf( " DRC err = %d, Win Coord img r,u in window: %fl, %fl\n", ierr, xlm, ylm );
#endif

    glEnable( GL_DEPTH_TEST );
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

//  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

#ifdef GL_DEBUG
  printf( " DR draw() U %d\n", i_pixs ); fflush( stdout );
#endif

    switch (i_pixs) {
      case 1: maptyp = GL_LUMINANCE; break;
      case 3: maptyp =       GL_RGB; break;
      case 4: maptyp =      GL_RGBA; break;

    default:
      fl_alert( "DiaViewer: Bad type of imag: %d byte/pixel.", i_pixs );
      maptyp = -1;
      printf( " Bad type of image\n" ); fflush( stdout );
//    exit( 2 );
    }

#ifdef GL_DEBUG
  printf( " draw() V %d\n", maptyp ); fflush( stdout );
#endif

    if (maptyp>0) {

#ifdef GL_DEBUG
    printf( "-----> i_widt=%d, i_spix=%d, i_srow=%d, at (%d,%d)\n", i_widt,i_spix,i_srow, map_x, map_y);
//  fflush( stdout );
#endif
      glPixelStorei( GL_UNPACK_ROW_LENGTH,    i_widt );
      glPixelStorei( GL_UNPACK_SKIP_PIXELS,   i_spix );
      glPixelStorei( GL_UNPACK_SKIP_ROWS,     i_srow );
      glPixelStorei( GL_UNPACK_ALIGNMENT,        1 );
      glRasterPos3f( map_x+0.0001, map_y+0.0001, 0.0 );
//    GLboolean valid; glGetBooleanv( GL_CURRENT_RASTER_POSITION_VALID, &valid );
//    printf( " PIxmap Position valid = %d\n", valid );
      glPixelZoom( r_scale, r_scale );
      glDrawPixels(  i_npix, i_nrow, maptyp, GL_UNSIGNED_BYTE, (GLvoid*)Curr_Map );
    }

#ifdef GL_DEBUG
  printf( " DR draw() W\n" ); fflush( stdout );
#endif
    if (MouseStat) {
      glLineWidth( 2.0 );
      glColor3f( 0.7, 0.7, 0.7 );
      glBegin( GL_LINE_LOOP );
      glVertex3f( zre_x1, zre_y1,  0.5 );
      glVertex3f( zre_x2, zre_y1,  0.5 );
      glVertex3f( zre_x2, zre_y2,  0.5 );
      glVertex3f( zre_x1, zre_y2,  0.5 );
      glEnd();
    }
  }

#ifdef GL_DEBUG
  printf( " DR draw() X\n" ); fflush( stdout );
#endif

#ifndef MESA
  glDrawBuffer(GL_BACK);
#endif // !MESA

  if (Fl::visible_focus())take_focus();

//printf( " Draw Process End\n" ); fflush( stdout );

} // void View_Win::draw().



//
// end of <PW-Id>.
//
