//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Module for a View (Image and or text) environment for class View_GL.
//


#ifndef VIEW_GL_H_
#define VIEW_GL_H_


#include <FL/Fl.H>
#include <FL/gl.h>
#include <GL/glu.h>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Round_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Gl_Window.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Scrollbar.H>

#include <FTGL/ftgl.h>

#include "ImageMan_REF.h"


class View_GL_UI;
class View_SetUp;

class View_GL : public Fl_Gl_Window {
friend View_GL_UI;
friend View_SetUp;

public:

    typedef struct {
        const char      * name; // Name
        float            ratio; // Ratio H/W.
    } Formats;

    typedef enum {
        Img_Undef       =    0,
        Img_Valid       =    1,
        Img_Center      =    2,
        Img_Top         =    4,
        Img_Bottom      =    8,
        Img_Left        =   16,
        Img_Right       =   32,

        Img_Vertical    = Img_Top|Img_Bottom,
        Img_Horizontal  = Img_Left|Img_Right
    } ImgGeo;

    typedef void (View_Cb)( int, void * );  // Define the View callback function type.


private:

    View_SetUp         * vfrm_;         // View_SetFrm Pointer.

    // Private Definitions for View_GL
    int largc_; char ** largv_;

    View_GL_UI        * Vgl_ui;

    Fl_Double_Window   * W_win;
    Fl_Group           * W_ggl;
    View_GL           * W_view;
    Fl_Menu_Item     * W_frame;
    Fl_Button       * W_ftname,
                    * W_ftsize;
    Fl_Scrollbar   * W_xscroll,
                   * W_yscroll;

    Fl_Double_Window  * Fw_win;

    char          wlabel_[128]; // To keep the label of View_GL window.

    View_Cb          * evfunc_;
    void             * evdata_;

    const Formats    * formtb_;
    double             ratiof_; // Y/X (or H/W) ratio for output format.
    int                geomet_, // The prefered Geometry and ...
                         geom_, // ... the selected one.
                       margin_, // margin to save between text and image.
                       frmidx_, // Format index.
                       vfsize_; // Used font size.
    char             * vfname_, // Used font name.
                     * vtitle_; // Used image title.
    const char       * i_text_; // The slide text to display (without ref. mark *[ ... ].

    FTFont           * usdfnt_; // Used font to use for text.

//  GLdouble           txtprp_; // Surface ratio for text.
    GLdouble           txtsrf_; // Surface for the text.

    int         Win_Init  =  1; // Flag to init at the first call of draw().

    GLint       w_glx_, w_gly_, // x, y and w, h ...
                w_glw_, w_glh_, // ... for View_GL window (in screen pixels).
                w_ghw_, w_ghh_, // The half of View sizes in screen pixels.
                w_zx1_, w_zy1_, // Zoom rectangle center coordinates (Screen pixels).
                w_zx2_, w_zy2_, // ... the second one (notused on Centred mode).
                w_zcx_, w_zcy_, // Zoom rectangle center coordinates (Screen pixels).
                w_zsw_, w_zsh_, // New zoom rectangle (Screen pixels).
                  eix_,   eiy_, // The effective position and sizes of image on output device.
                  eiw_,   eih_;

    GLdouble    d_tx1_, d_ty1_, // The first zone of text and ...
                d_tw1_, d_th1_,
                d_tx2_, d_ty2_, // ... second ones.
                d_tw2_, d_th2_,
                d_tlh_, d_tla_, // Text Line Height and text Line Ascender(as given for our font.).
                d_tss_, d_tsc_, // The selected character size and their relative scale.
                d_lmi_, d_txw_, // Minimum width of a layout, width for in one line, ...
                        d_mxw_; // ... length of the longest word.

    GLubyte           * i_map_; // Slide(the image/photo) map.

    GLint       i_pcs_,         // Size of pixels (1=luminance, 3=RGB, 4=RGBA)..
                i_wid_, i_hei_, // Width and high of the image in image pixels, ...
                i_hwi_, i_hhe_, // ... their halves and ...
                i_shw_, i_shh_, // ... their saved value (for zoom).
                i_cex_, i_cey_, // Coordinates of Zoom center in image space (relative to center of image).
                i_mx1_, i_my1_, // Limits of image view (with zoom or not).
                i_mx2_, i_my2_,
                i_zcx_, i_zcy_, // New Zoom rectangle center coordinates (Image pixels).
                i_zsw_, i_zsh_; // New zoom rectangle half sizes (Image pixels).

    GLdouble   d_hwi_,  d_hhe_, // Document space limit (as the paper space for print).
               d_zhw_,  d_zhh_, // Half Sizes of Zomm rectangle.
               d_zcx_,  d_zcy_, // Cord. of Zoom rectangle center.
              di_mix_, di_max_, // Mini maxi for x and y to set limit ...
              di_miy_, di_may_, // ... image rectangle in glOrtho space..
              di_cex_, di_cey_, // Define the center and outline rectangle for the image.
              di_hwi_, di_hhe_,
              di_mpx_, di_mpy_, // Coordinates of image map origine in document unit space,
              di_wid_, di_hei_; // Sizes of image map in the document space.

    GLint       i_npix, i_nrow, // Visible Part of image.
                i_spix, i_srow; // Skipped(left/low) part of the image.

    GLint       ViewReady  = 0, // OpenGL window Init Flag.
                UsedButton,     // memory for mouse button use.
                MouseStat  = 0, // Used button for Zoom ans Mouse status.
                ZoomStatus = 0, // Status to flag a zoom/sceolling request.
                SetScaVal  = 0, // Flag to force a specified scale.
                X_shift    = 0, // Shift (for scrollbar along x or y.
                Y_shift    = 0;

    GLdouble    r_scale_ = 1.0; // Internal Scale in Screen-Pixel/Slide-Pixel.

//              p_scale_ = 1.0, // Relative user scale.
//              d_scale_ = 5.0, // Scale factor document_space/screen_space.
//              i_scale_ = 1.0; // Scale factor Image_space/document_space

//  void Analyse();  ///////////////

    char * Text_Parsing(const char * ); // Analyse the text : Find the longest word and set ...
                                        // ... its length in d_mxw_. Suppress any ref. mark as "*[...]".
    void Init();                        // Called by View_GL::Create().

    void Set_Format();                  // To compute the GL x, y, w, h of target space.
//  void Text_Parsing( GLdouble );      // To parse, clean and cut in words, the slide text.

    static float BLine( float, void * );
    float  BLine_i( float );
    static float ELine( float, void * );
    float ELine_i( float );

    GLdouble TextSurface();             // To evaluate the surface to use for a text.
    GLdouble HMeasure();                // To evaluate the text height in Layout.

    void Set_Geometry();                // To compute text and image surface limits.
    void Write_Text();                  // Write the related text.

    void Quit_CB();                     // All the intern callback routines.
    void FrmGeo_CB();                   // To enter in format setting.
    void SetFrmGeo();                   // To save a new Format/Geometry setting in View_GL.

//  static void ChangeFormat_CB( int, int, View_GL * ); // To set the Format.
//  void Geometry_CB();

    void Print_CB();
    void SaveAs_CB();

    void UnZoom_CB( int );
    void Frame_CB();

    void About_CB();
    void Help_CB();

    void YScroll_CB();
    void XScroll_CB();

    void ChangeFont_CB();
    void ChangeFtsize_CB();

    void SetFormat_CB( int, int );

    GLdouble Surface( const char * );


public:
    // Public definitions for Format specifications.
//  void CallBack( View_Cb * f ) { rcb = f; }
//  void SetFormat( View_GL::Formats * flst );

    // Public Definitions for View_GL.
    View_GL(int, int, int, int, const char * = 0 );             // Must be called by View_GL_UI.
    static View_GL * Create( int, int, const char * = 0 );      // To Start the Vien_GL system.
    void Set_Conf( float f, int g, int m, int fs, char * fn );
    void Get_Conf( float &f, int &g, int &m, int &fs, char * &fn )
        { f = ratiof_; g = (int)geomet_; m = margin_; fs = vfsize_; fn = vfname_; }
    void Callback( View_Cb * cb, void * d ) { evfunc_ = cb; evdata_ = d; } // To set the main callback.
    void SetFormTable( Formats  * ft ) { formtb_ = ft; }        // Install a user spec. formats table.

    // Specify the text and image, volume, film and number of slide.
    void Slide( const char *, Image_REF *, const char * = 0, int = 0, int = 0 );

    void Show( int argc, char ** argv ) {
//      printf( " We call Analyse()\n" ); fflush( stdout );
//      Analyse();
//      printf( " Argc = %d\n", argc ); fflush( stdout );
//      for (int i=0; i<argc; i++) printf( "     %d\n", argv[i]); fflush( stdout );
        W_win->show( largc_ = argc, largv_ = argv );
    }
    void WinSizes( int &w, int &h ) { w = W_win->w(); h =  W_win->h(); }

private:

    void XYinImage( int &x, int &y );
    void MouseDown( int, int, int );
    void MouseDrag( int, int, int );
    void MouseUp( int, int, int );

protected:

    int handle( int );
    void draw();

};


class View_SetUp {
friend View_GL;

public:
    typedef void (FrmGeo_Cb) ();

private:
//protected:
    Fl_Double_Window  * vfw;
    Fl_Choice         * vfc;
    Fl_Round_Button   * vfl,
                      * vfp,
                      * glf,
                      * gri,
                      * gto,
                      * gbo;
    Fl_Value_Input    * gma;
    Fl_Return_Button  * vfr;

    int                 idx;

    FrmGeo_Cb         * rcb;
    View_GL           * vgl;


    void SaveConf();

    static void vfw_cb( Fl_Double_Window * w, void * v ) { delete ((View_SetUp*)v)->vfw; }
    static void vfc_cb( Fl_Choice *c, void *v ) {
        ((View_SetUp*)(c->parent()->parent()->user_data()))->idx = (int)(fl_intptr_t)v -1;
        //printf( " VFC_CB selected v = %d\n",(int)(fl_intptr_t)v -1 );
    }
    static void vfl_cb( Fl_Round_Button *l, Fl_Round_Button *p ) { p->value( 1 - l->value() ); }
    static void vfp_cb( Fl_Round_Button *p, Fl_Round_Button *l ) { l->value( 1 - p->value() ); }

    static void vfr_cb( Fl_Return_Button *o, View_GL *v )
                    { v->SetFrmGeo(); delete o->parent(); }
//                   {   //printf( " User select format # %d\n", f->idx );
//                            f->rcb( f->idx, f->vfl->value(), f->vgl ); delete f->vfw; }

    static void glf_cb( Fl_Round_Button *l, Fl_Round_Button *r ) { r->value( 1 - l->value() ); }
    static void gri_cb( Fl_Round_Button *r, Fl_Round_Button *l ) {
        l->value( 1 - r->value() ); }
    static void gto_cb( Fl_Round_Button *t, Fl_Round_Button *b ) {
        b->value( 1 - t->value() ); }
    static void gbo_cb( Fl_Round_Button *b, Fl_Round_Button *t ) { t->value( 1 - b->value() ); }


public:
    View_SetUp( View_GL * v ) { idx = 1; rcb = 0; vgl = v; }
    void CallBack( FrmGeo_Cb * cb ) { rcb = cb; }
    void Set( int );
};



#endif



//
// end of <PW-Id>.
//



