//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage the font flies in one directory.
//
//


#ifndef SERVICE_FONT_H
#define SERVICE_FONT_H


class FontSrv {
private:

    typedef struct FNTREC * FontPtr;

    typedef struct FNTREC {
        FontPtr   perv, // Link to previous font record or 0.
                  next; // Link to next font record or 0.
        short      lnk, // Flag font logical link (of one).
                   num; // Font number.
        char    * path, // Font file path.
                * name; // Font file name to diplay.
    } FontRec;

    FontPtr     first_, // The font list.
                 last_;

    char             * fntdir_; // Path of font directory.
    int                  incr_; // Count for font number.

public:

    FontSrv( const char * p );
    int  Install( const char *, const char * = 0, int = 0 );
    int  Remove( const char * );

    const char * GetFont( const char * );
    const char * GetFont( int );

    const char * SelectFont();  // Interactive font selection (with FLTK).

};













#endif



//
// end of <PW-Id>.
//
