//
// <PW-Id>
//


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//


#ifdef WIN32
#else
#  define JPEG_GEN_USE
#  define PNG_GEN_USE
#endif


#include <stdio.h>

#ifdef JPEG_GEN_USE
extern "C" {
# include <jpeglib.h>           /* Load the JPEG File Library Definitions */
}
#endif

#ifdef PNG_GEN_USE
# include <png.h>               /* Load the PNG File Library Definitions */
#endif




#include "Server_UI.h"
#include "Server_DrawGL.h"
#include "Server_UsrInput.h"



extern Draw_GL_UI* srvw0;


static char*           filespc;
static int          pflg, fidx;
static const char filter[] = "*.jpg\t*.png\t*.bmp";

static FILE*              fimg;

static GLubyte* Img_Map = NULL;

static int     Img_BufSz  =  0;         /* Size of allocated Image Buffer */
static int     Img_LineSz =  0;         /* BitMap line size in bytes (Round Up to *4) */

static int     Img_Size   =  0;         /* Current size of the image */
static int     Img_Width  =  0;         /* Current Width of the image */
static int     Img_Height =  0;         /* Current high of the image */






//=============================>>> wrInt16 <<<=============================
  static void wrInt16( int iv )
  {
    union { char  ct[2];
            short iv;
          } equ;

//    int c0, c1;

//  c0 = iv & 255; c1 = (iv >> 8) & 255;
//  putc( c0, fimg );  putc( c1, fimg );

    equ.iv = iv;
    putc( equ.ct[0], fimg ); putc( equ.ct[1], fimg );
  }

//=============================>>> wrInt32 <<<=============================
  static void wrInt32( int iv )
  {
    union { char  ct[4];
            int   iv;
          } equ;

    equ.iv = iv;
    putc( equ.ct[0], fimg ); putc( equ.ct[1], fimg );
    putc( equ.ct[2], fimg ); putc( equ.ct[3], fimg );
  }


//=============================>>> wrInt32 <<<=============================
  
#if 0
  static void wrFlt32( float v )
  {
    union { float    v;
            char ch[4];
          } equ;

    equ.v = v;
    putc( equ.ch[0], fimg ); putc( equ.ch[1], fimg );
    putc( equ.ch[2], fimg ); putc( equ.ch[3], fimg );
  }
#endif



int Write_bmp_image( char * name, int prtflag )
{ /* Routine to Create a BMP File from the Pixel_buffer Image */

//static int       Image_Size;  /* Current size of the image */
//static int       Image_Width; /* Current Width of the image */
//static int       Image_High;  /* Current high of the image */

  int bmsz, Hres, npad, Vres, nCol, i, j;
  Char   * p;
  char com[255];

  fprintf( fmsg, " BMP_Image Start.\n" );
  fflush( fmsg );

  if (fimg = fopen( name, "wb" )) { /* Open is a success */

    bmsz = Img_BufSz;     /* Bit Map Size (with Round up to a multiple of 4) */
    npad = (Img_Width*3)&3; if (npad) npad = 4 - npad; /* Compute BMP Round UP */

    Hres = (int) (d_xscale*100.0 + 0.5);
    Vres = (int) (d_yscale*100.0 + 0.5);

    nCol = 0x1000000;       /* Set to 2**24 Colors. */

    /* The 14 First Bytes Are Write Now */
    putc( 'B', fimg );      /* Generate the BM BitMap type */
    putc( 'M', fimg );
    wrInt32( bmsz + 54 );   /* Bit Map file Size */
    wrInt16( 0 );           /* Reserved Dword */
    wrInt16( 0 );           /* Reserved Dword */
    wrInt32( 54 );          /* Offset of Beginning of data (no Color Map) */

    /* The 40 Bytes of Image are Write Now */
    wrInt32( 0x28 );        /* Write bitmap Info Header Size */
    wrInt32( Img_Width );   /* Write Image Width */
    wrInt32( Img_Height );  /* Write Image High */
    wrInt16( 1 );           /* Write the Number of planes */
    wrInt16( 24 );          /* Write the number of bits by Pixels (always 24 Here) */
    wrInt32( 0 );           /* Specify NO Compression */
    wrInt32( bmsz );        /* Specify the total size of the bitmap data */
    wrInt32( Hres );        /* Specify the Horizontal resolution (pixels/meter) */
    wrInt32( Vres );        /* Specify the Vertical resolution (pixels/meter) */
    wrInt32( nCol );        /* Specify the total number of used Color */
    wrInt32( 0 );           /* Specify the total number of Important Color */

//  fprintf( fmsg, " bmsz = %d.\n", bmsz );
//  fprintf( fmsg, " W = %d, H = %d.\n", Image_Width, Image_High );
//  fprintf( fmsg, " WR = %d, HR = %d.\n", Hres, Vres );
//  fprintf( fmsg, " ncol = %d.\n", ncol );
//  fflush( fmsg );


    /* We do not generate a Color map */

    /* Now Write the RGB BitMap */
    p = Img_Map;
    for (j = 0; j < Img_Height; j++) {
      p = Img_Map + j*Img_LineSz;
      for (i = 0; i < Img_Width; i++) {
        putc( p[2], fimg );
        putc( p[1], fimg );
        putc( p[0], fimg );
        p += 3;
      }
      /* Write pad byte */
      for (i = 0; i < npad; i++) putc( 0, fimg );
    }

    /* Close the BMP File */
    fclose( fimg );


//  status = fork();           /* Create the Draw Client process */
//
//  if (status == 0)           /* Select the process */
//    if ((status = execl( "mspaint", "mspaint", "Draw_Image.bmp" )) == -1) /* ... to start it. */
//    ; //  exit( 3 );         /* Stop with message on Exec ERROR. */

    if (prtflag) { /* When a BitMap print is required */
      sprintf( com, "mspaint /P %s\n", name );
      fprintf( fmsg, " Execute Command com %s\n", com );
      system( com );
    }

//  fprintf( fmsg, " BMP_Image End on Success.\n" );
//  fflush( fmsg );

    return 0;
  }

  fltk::alert( " BMP_Image End on Open Error.\n" );
  fflush( fmsg );

  return -1; /* Error on Open */

}




#ifdef JPEG_GEN_USE

int Write_jpeg_image( char * name )
{ /* Routine to Create a JPEG File from the Pixel_buffer Image */
  struct jpeg_compress_struct cinfo;            /* Structure of JPEG Compression parameters */
  struct jpeg_error_mgr        jerr;            /* Structure of JPEG Handler Error */
  JSAMPROW                     p[1];            /* Pointer to JSAMPLE row[s] */
  int               top, row_stride;            /* Physical row width in image buffer */

  if (fimg = fopen( name, "wb" )) {             /* Open the Destination file ("wb" for not Unix system) */
    cinfo.err = jpeg_std_error( &jerr );        /* Set the JPEG Error Handler */
    jpeg_create_compress( &cinfo );             /* Initialize the JPEG compression object */
    jpeg_stdio_dest( &cinfo, fimg );            /* Specify the file destination */

    cinfo.image_width      =  Img_Width;        /* Set image width and height in pixel */
    cinfo.image_height     = Img_Height;
    cinfo.input_components =          3;        /* Set for true Color (24 bits) image */
    cinfo.in_color_space   =    JCS_RGB;        /* Specify the color representation mode */

    /* Setting of Particular compression parameters */
    jpeg_set_defaults( &cinfo );                /* We set the default compression parameters */
//  jpeg_set_quality( &cinfo, quality, TRUE );  /* Set non Default parameters */
    jpeg_start_compress( &cinfo, TRUE );        /* Start compression */
//  row_stride = Img_LineSz;                    /* JSAMPLEs per row in image buffer */

    top = (cinfo.image_height - 1)*Img_LineSz;
    while (cinfo.next_scanline < cinfo.image_height) {  /* Loop on all image row(s) */
      p[0] = &Img_Map[top - cinfo.next_scanline*Img_LineSz];
      jpeg_write_scanlines( &cinfo, p, 1 );
    }

    jpeg_finish_compress( &cinfo );             /* Finish the compression */
    jpeg_destroy_compress( &cinfo );            /* Release  memory amount */

    return 0;
  }
  else return -1;
}

#endif /* JPEG_GEN_USE */




#ifdef PNG_GEN_USE



/* local prototype */

static png_structp             png_ptr;
static png_infop              info_ptr;
static int   color_type, interlace_type, sample_depth;
static jmp_buf                  jmpbuf;
static char             **row_pointers;


static void writepng_error_handler( png_structp png_ptr, png_const_charp msg );



/* returns 0 for success, 2 for libpng problem, 4 for out of memory, 11 for
 *  unexpected pnmtype; note that outfile might be stdout */

int writepng_init( int width, int height )
{
  /* could also replace libpng warning-handler (final NULL), but no need: */

  png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING,
                                     NULL,
                                     writepng_error_handler,
                                     NULL );
  if (!png_ptr) return 1;                       /* out of memory */

  info_ptr = png_create_info_struct( png_ptr );
  if (!info_ptr) {
    png_destroy_write_struct( &png_ptr, NULL );
    return 1;                                   /* out of memory */
  }


  /* setjmp() must be called in every function that calls a PNG-writing
   * libpng function, unless an alternate error handler was installed--
   * but compatible error handlers must either use longjmp() themselves
   * (as in this program) or exit immediately, so here we go: */

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    return 2;
  }


  /* Make sure outfile is (re)opened in BINARY mode */

  png_init_io( png_ptr, fimg );


  /* set the compression levels--in general, always want to leave filtering
   * turned on (except for palette images) and allow all of the filters,
   * which is the default; want 32K zlib window, unless entire image buffer
   * is 16K or smaller (unknown here)--also the default; usually want max
   * compression (NOT the default); and remaining compression flags should
   * be left alone */

  png_set_compression_level( png_ptr, Z_BEST_COMPRESSION );
/*
    >> this is default for no filtering; Z_FILTERED is default otherwise:
    png_set_compression_strategy(png_ptr, Z_DEFAULT_STRATEGY);
    >> these are all defaults:
    png_set_compression_mem_level(png_ptr, 8);
    png_set_compression_window_bits(png_ptr, 15);
    png_set_compression_method(png_ptr, 8);
 */


  /* set the image parameters appropriately */

  color_type = PNG_COLOR_TYPE_RGB;

//interlace_type = PNG_INTERLACE_ADAM7;
  interlace_type = PNG_INTERLACE_NONE;
  sample_depth   =                  8;

  png_set_IHDR( png_ptr, info_ptr, width, height,
                sample_depth, color_type, interlace_type,
                PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT );
/*
    if (mainprog_ptr->have_text) {
        png_text  text[6];
        int  num_text = 0;

        if (mainprog_ptr->have_text & TEXT_TITLE) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Title";
            text[num_text].text = mainprog_ptr->title;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_AUTHOR) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Author";
            text[num_text].text = mainprog_ptr->author;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_DESC) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Description";
            text[num_text].text = mainprog_ptr->desc;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_COPY) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "Copyright";
            text[num_text].text = mainprog_ptr->copyright;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_EMAIL) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "E-mail";
            text[num_text].text = mainprog_ptr->email;
            ++num_text;
        }
        if (mainprog_ptr->have_text & TEXT_URL) {
            text[num_text].compression = PNG_TEXT_COMPRESSION_NONE;
            text[num_text].key = "URL";
            text[num_text].text = mainprog_ptr->url;
            ++num_text;
        }
        png_set_text(png_ptr, info_ptr, text, num_text);
    }
*/

  /* write all chunks up to (but not including) first IDAT */

  png_write_info( png_ptr, info_ptr );


  /* if we wanted to write any more text info *after* the image data, we
   * would set up text struct(s) here and call png_set_text() again, with
   * just the new data; png_set_tIME() could also go here, but it would
   * have no effect since we already called it above (only one tIME chunk
   * allowed) */


  /* set up the transformations:  for now, just pack low-bit-depth pixels
   * into bytes (one, two or four pixels per byte) */

  png_set_packing( png_ptr );
  /*  png_set_shift(png_ptr, &sig_bit);  to scale low-bit-depth values */

  /* OK, that's all we need to do for now; return happy */
  return 0;
}



/* returns 0 for success, 2 for libpng (longjmp) problem */

int writepng_encode_image( void )
{
  /* as always, setjmp() must be called in every function that calls a
   * PNG-writing libpng function */
  png_byte **Map_Vect;
  png_byte       *row;
  int               i;

  if (setjmp( jmpbuf )) {
    png_destroy_write_struct( &png_ptr, &info_ptr );
    png_ptr  = NULL;
    info_ptr = NULL;
    return 2;
  }

  if (Map_Vect = (png_byte **)malloc( Img_Height*sizeof( png_byte* ) )) {
    row = (png_byte*)Img_Map;
    for (i = Img_Height - 1; i >= 0; i--) { Map_Vect[i] = row; row += Img_LineSz; }

    /* and now we just write the whole image; libpng takes care of interlacing
     * for us */
    png_write_image( png_ptr, (png_byte**) Map_Vect );

    /* since that's it, we also close out the end of the PNG file now--if we
     * had any text or time info to write after the IDATs, second argument
     * would be info_ptr, but we optimize slightly by sending NULL pointer: */
    png_write_end( png_ptr, NULL );
    free( (void*)Map_Vect );
  } else return 1;

  return 0;
}



void writepng_cleanup( void )
{
  if (png_ptr && info_ptr) png_destroy_write_struct( &png_ptr, &info_ptr );
}



static void writepng_error_handler( png_structp png_ptr, png_const_charp msg )
{
    /* This function, aside from the extra step of retrieving the "error
     * pointer" (below) and the fact that it exists within the application
     * rather than within libpng, is essentially identical to libpng's
     * default error handler.  The second point is critical:  since both
     * setjmp() and longjmp() are called from the same code, they are
     * guaranteed to have compatible notions of how big a jmp_buf is,
     * regardless of whether _BSD_SOURCE or anything else has (or has not)
     * been defined. */

    fprintf( fmsg, "Write PNG Error: writepng libpng error: %s\n", msg );
    fflush( fmsg );

    longjmp( jmpbuf, 1 );
}






int Write_png_image( char * name )
{
  int rc;

  if (fimg = fopen( name, "wb" )) {             /* Open the Destination file ("wb" for not Unix system) */

    if ((rc = writepng_init( Img_Width, Img_Height )) != 0) {
      switch (rc) {
        case 1:
          fprintf( fmsg, " Write PNG Error: insufficient memory\n");
          break;
        case 2:
          fprintf( fmsg, " Write PNG Error: jmpbuf memory\n");
          break;
        default:
          fprintf( fmsg, " Write PNG Error: unknown writepng_init() error\n");
          break;
        }
      fflush( fmsg );
    }

    if (writepng_encode_image() != 0) {
      fprintf( fmsg, " Write PNG Error: libpng problem (longjmp) while writing image data\n");
      fflush( fmsg );
    }

    writepng_cleanup();

    return 0;
  }
  else return -1;
}

#endif



void DrwGL_GLBuild_Image()
/*
 *
 * Routine to build the image map - always called across srvw0->w_draw->redraw().
 *
 */

/*

 The new version must be use the value of integer d_hc_resolution theta is a screen resolution multilier
for X and Y coordinates.


*/
{
# define HIGH_DEF

  GLint ix, iy, px, py, re, np;
  GLint             naux, cbuf;
  GLdouble epx,  epy, lnx, lny,
                     szx,  szy;

  glGetIntegerv( GL_AUX_BUFFERS, &naux );       /* Try to fins an auxillary buffer */

#ifdef HIGH_DEF

  if ((d_hc_resolution>1)&&(naux>=1)) {
    Img_Width   =   d_hc_resolution*dt_rx;      /* Compute the buffer size and allocate for */
    Img_Height  =   d_hc_resolution*dt_ry;
    Img_Size    =    Img_Width*Img_Height;
    Img_LineSz  =  (Img_Width*3 + 3)&(~3);      /* Compute the row size in bytes (roundup to get a multipl of 4) */
    np          =   Img_LineSz*Img_Height;      /* Get the total size of buffer in bytes */
    if (np != Img_BufSz) {
      if (!Img_Map) free( Img_Map );
      Img_Map = (Char *) malloc( np /* For RGB */ );
      Img_BufSz = np;
    }

    epx = 2.0/dt_rx;                            /* Evaluate the Epsilone to don't repeat the border between to ties */
    epy = 2.0/dt_ry;

    szx = 2.0/d_hc_resolution;                  /* Get the step between two tiles (in normalized coordinates) */
    szy = szx;

    lnx = szx - epx;                            /* Get the width of tile (in normalized coordinates) */
    lny = szy - epy;                            /* Get the hright of tile (in normalized coordinates) */

/*
    printf( " Allocated Image of %d pixels => %d bytes\n", Img_Size, np );
    printf( " Make image of %d * %d pixels (multf = %d)\n", Img_Width, Img_Height, d_hc_resolution );
*/

    glGetIntegerv( GL_DRAW_BUFFER, &cbuf );     /* Select the Auxillary Buffer to don't change the view of screen. */
    glDrawBuffer( GL_AUX0 );
    glReadBuffer( GL_AUX0 );
    glPixelStorei( GL_PACK_ROW_LENGTH, Img_Width );
    glPixelStorei( GL_PACK_ALIGNMENT, 4 );

    Drwgl_tile  =    1;                         /* Enable the image tile partitionning */
    iy = 0;
    Drwgl_gymin = -1.0;                         /* Start Y window at lower side */
    Drwgl_gymax = -1.0 + szy - epy;
    for (py=0; py<d_hc_resolution; py++) {
      Drwgl_gymin = py*szy - 1.0;
      Drwgl_gymax = py*szy + lny - 1.0;
      glPixelStorei( GL_PACK_SKIP_ROWS, iy );
      ix = 0;
      for (px=0; px<d_hc_resolution; px++) {
        Drwgl_gxmin = px*szx - 1.0;
        Drwgl_gxmax = px*szx + lnx - 1.0;

        DrwGL_Display();

        glPixelStorei( GL_PACK_SKIP_PIXELS, ix );
        glReadPixels( 0, 0, dt_rx, dt_ry, GL_RGB, GL_UNSIGNED_BYTE, (void*) Img_Map );
        ix += dt_rx;
      }
      iy += dt_ry;
    }

    Drwgl_tile    =    0;                       /* Disable the image tile partitionning */
    glDrawBuffer( cbuf );                       /* Restore the Normal Screen Color Buffer */
    glReadBuffer( cbuf );

  } else {

#endif

    fprintf( fmsg, " HC resolution multiplier = %d\n", d_hc_resolution );
    fflush( fmsg );

    DrwGL_Display();

    glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );

    Img_LineSz = (dt_rx*3 + 3)&(~3);            /* Compute the Round Up BitMap Line size of *4 */
    np = Img_LineSz*dt_ry;                      /* Total BitMap Size in bytes (with Round up) */
    if (np != Img_BufSz) {
      if (!Img_Map) free( Img_Map );
      Img_Map = (Char *) malloc( np /* For RGB */ );
      Img_BufSz  = np;
    }
    Img_Width    =         dt_rx;
    Img_Height   =         dt_ry;
    Img_Size     =   dt_rx*dt_ry;

    glReadPixels( 0, 0, dt_rx, dt_ry, GL_RGB, GL_UNSIGNED_BYTE, (void*) Img_Map );

#ifdef HIGH_DEF

  }

#endif


  switch (fidx) {
    case 1: /* PNG File Format. */
#ifdef PNG_GEN_USE
      Write_png_image( filespc );
#endif
      break;

    case 2: /* BMP (24 bits/Pixel) File Format. */
      re = Write_bmp_image( filespc, pflg );
      break;

    default:
//  case 0: /* JPEG: JPG File Format. */
#ifdef JPEG_GEN_USE
      Write_jpeg_image( filespc );
#else
      ;
#endif
  }
  Drwgl_ImgFlg = 0;                             /* Clear the Make Image Flag */
}



void DrwGL_Save_Image( int printflg )
/*
 *
 *    Save Pixel Map from the GL Screen Buffer (dialog common part).
 *
 */
{
  int i, n;
  char*  ext;
  char         ch;

  if (!printflg) {                      // We request the user to get a user information.chmodDraw
    filespc = Draw_GetFile( "Image file to Create",     // Title Request,
                            filter,                     // File Filter,
                            "Draw_Image",               // Default File Name,
                            1,                          // Mode New file.
                            fidx );                     // Filter index.

  } else {
    filespc = (char*) "Draw_Image_tmp.jpg";
  }
  // *** Temporary with the first version of Draw_GetFile ***
  if (filespc) {
    i = n = strlen( filespc ); ch = 0;
    while (i&&ch!='.') ch = filespc[--i];
    ext = &(filespc[i]);
    if (strcmp( ext, ".jpg" ) == 0) fidx = 0;
    else
    if (strcmp( ext, ".png" ) == 0) fidx = 1;
    else
    if (strcmp( ext, ".bmp" ) == 0) fidx = 2;
    else fidx = 0;
  } else return;

  fprintf( fmsg, " The image File Spc is \"%s\" with the type %d\n", filespc, fidx );
  fflush( fmsg );

//if (!(fimg = fopen( filespc, "wb" ))) {
//  fltk::alert(" FLTK DRAW Server : We cannot create the specified file \"%s\".\n", filespc );
//  return;
//}

  pflg = printflg;
  Drwgl_ImgFlg = 1;                     // Force a Redraw event in PixelMap Build mode.
  srvw0->w_draw->redraw();
}
