#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <math.h>


// Define the default name for the Draw_Server setting File.
#define   DEF_SETFILE       "draw_server.draw_setting"

// Define the maximum string size.
#define   MAX_STR           256


// Define the directory separator.
#if (!defined( _WIN32)) || defined(__CYGWIN__)
//   Unix/Linux/Cygwin Directory separator.
# define DIR_SEPAR         '/'
#else
//   Windows Directory separator.
# define DIR_SEPAR         '\\'
#endif
#define  DEV_SEPAR         ':'


static void LookForLogical( const char * spath, char * buf, int &isz )
{
    int            lsz;
    char    *trn, *log;
    char            ch;

    if (!((spath&&spath[0]))||(isz<0)) return;

    trn = NULL;
    lsz =    0;
    while (spath[lsz]&&
           (spath[lsz]!=DEV_SEPAR)&&
           (spath[lsz]!=DIR_SEPAR)) lsz++;
    if (lsz&&(spath[lsz]==DEV_SEPAR)) {
        log = (char*)malloc( lsz + 1 );
        for(int i=0;i<lsz;i++) {
            ch = (spath[i]);
            if ((ch>='a')&&(ch<='z')) ch -= 'a'-'A';
            log[i] = ch;
        }
        log[lsz] = 0;
        trn = getenv( log );
        free( log );
        if (trn) {
            if (trn[0]) {
                if (spath[++lsz]) {
                    while (spath[lsz]==DIR_SEPAR) lsz++;
                }
                LookForLogical( trn, buf, isz );
                if (isz<0) return; 
            } else lsz = 0;
        } else lsz = 0;
    } else lsz = 0;
    
    if (isz<MAX_STR) {
        if ((isz>0)&&(buf[isz-1]!=DIR_SEPAR)) buf[isz++] = DIR_SEPAR;
    }
    else { isz = -1; return; }

    while ((isz<MAX_STR-1)&&spath[lsz]) buf[isz++] = spath[lsz++];
    buf[isz] = 0;
    if (isz==MAX_STR-1) isz = -1;
}


// static void LookForLogical( const char * spath, char * &buf, int &isz )

static void SolveLogicalPath( const char * spath, char * &path, int &isz )
{
    char buff[MAX_STR];

    isz = 0; buff[0] = 0;
    LookForLogical( spath, buff, isz );
    path = (char*)malloc( isz + 1 );
    for(int i=0; i<=isz; i++) path[i] = buff[i];
}



char inps[MAX_STR];
char *outs;

int main()
{
    outs = (char*)malloc( MAX_STR );
   
    gets( inps );
    while(inps[0])
    {
        int ires;

        SolveLogicalPath( inps, outs, ires );
        printf( " inps = \"%s\"\n -> (%d):\"%s\"\n\n", inps, ires, outs );
        gets( inps );
    }
    return 0;
}
