//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module environement to manage the Slide Context Input/output Files
//
//


#ifndef SERVICE_IO_H
#define SERVICE_IO_H

#include <stdio.h>
#include <stdlib.h>

#include "Service_Util.h"

#define RMAXLEN 2048


#if (defined(WIN32) && !defined(__CYGWIN__)) || defined(__EMX__)
# define sigjmp_buf jmp_buf
# define sigsetjmp( a, b ) setjmp( a )
# define siglongjmp longjmp
#endif


//
// Global function to get the complete path of file or directory ...
// ... with the choice between FLTK and Native system dialog.
//


class FSelect {
private:
    int  sfl_, * sys_;

    int SysFlg() { return *sys_; };

public:
    FSelect( int *fl = NULL ) { sys_ = (fl) ? fl : &sfl_; }
    void Native( int fl ) { *sys_ = (fl) ? 1 : 0; }
    void Native( int * fl ) { sys_ = (fl) ? fl : &sfl_; }

    const char * Dir( const char *, const char * );
    const char * File( const char *, const char *, const char * = NULL, int = 0 );
};



// Create a Global FSelect object to be used by the application.
// The main of application just must include :
//  #include "Service_IO.h"
//
// and in the main function the statement: FSvSel.Native( &flag );
// Then depending of flag :
// flag != 0 => FSvSel.FSdir() and FSvSel.FSFile() use the Native open file/dir dialog
//                                      else       use the FLTK open file/dir dialog.

extern FSelect FSvSel;


//
// Class LogFile to Manage Application execution logging messages.
//
class LogFile {
private:
    char * logn_,
         * path_;
    int    mskf_;
    FILE *   fp_;

    void ErrorMsg();

    void IniWrite( const char * = NULL );

public:
    LogFile( const char * = NULL, int = 0 );
    ~LogFile();

    void SetUp( const char *, int fl = 0, const char * msg = NULL, const char * lgn = NULL  );
    void Write( const char *, ... );


};


// -----------------------------------------------------------------------


//
// Class SrvFile to manage internal service file (with version format control)
// open for read or write mode, and some routine to and write string, integer and float numbers.
//
class SrvFile {
public:
    typedef void (*ErrCatch_t) ( int ); // Define the Function trap error type.
    typedef char            Header[16]; // Define the version type context header string.

private:
    char     err_[512]; // To store any error message.
    int           erl_; // Size of error message.
    int           smg_; // If 0, edit message.
    int            wr_; // 0/1 for Read/Write.
    FILE         * fp_; // File pointer.
    const Header * hl_; // File header models list (the first is used for creation).
    ErrCatch_t   ehdl_; // User Error handler.
    const char * mnam_, // Module name for error messages.
               * path_; // Path of the current opened file.

    void BugError( int );
    void IOError( int, const char * );

public:
    void Mode_Msg( int v ) { smg_ = v; }
    int  Mode_Msg() { return smg_; }
    int  Msg_Lenth() { return erl_; }
    char * Get_Msg() { return err_; }

    SrvFile( const Header * fhl = NULL, const char * mdl = NULL )
        { err_[0] = 0; erl_ = 0;  smg_ = 1; wr_ = 0; hl_ = fhl; path_ = NULL; mnam_ = mdl; }

    // Destroy the file context (after a close if not already done.
    ~ SrvFile() { hl_ = NULL; if (fp_ && wr_) fclose( fp_ ); fp_ = NULL; ehdl_ = NULL; mnam_ = NULL; }

    // Install an File read/write User error Handler.
    void   InsErrCatcher( ErrCatch_t hdl = NULL ) { ehdl_ = hdl; }
    int    CheckErrCatcher() { return ehdl_ ? 1 : 0; }

    void   SetModName( const char * md ) { mnam_ = md; }

    // Open the file (return < 0 on error, 0 no file, 1.
    int    Open( const char *, int, const Header * = NULL, const char * = NULL );

    void   Close();                     // Close the file.

    char * GetText( VarString &vs );    // Get a string from an opened context file.
    int    GetInt();                    // Get an integer value from an opened context file.
    float  GetFlt();                    // Get a float number value from an opened context file.

    void   PutEoln();                   // Put a line feed.
    void   PutText(const char * str );  // Put a string to an opened context file.
    void   PutInt( int val, int fld );  // Put an integer value to an opened context file.
    void   PutFlt( float val, int f, int d );   // Put an integer value to an opened context file.

};


#endif

//
// end of <PW-Id>.
//
