#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>

int  main(int argc, char *argv[])
{
    int fd;
    struct flock fl;

    fd = open("testfile", O_RDWR);
    if (fd == -1)
        /* Handle error */
        ;

    /* Make a non-blocking request to place a write lock
       on bytes 100-109 of testfile */

    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 100;
    fl.l_len = 10;

    if (fcntl(fd, F_SETLK, &fl) == -1) {
        if (errno == EACCES || errno == EAGAIN) {
            printf("Already locked by another process\n");

            /* We cannot get the lock at the moment */

        } else
            /* Handle unexpected error */
            ;
             }
    } else { /* Lock was granted... */

        /* Perform I/O on bytes 100 to 109 of file */

        /* Unlock the locked bytes */

        fl.l_type = F_UNLCK;
        fl.l_whence = SEEK_SET;
        fl.l_start = 100;
        fl.l_len = 10;
        if (fcntl(fd, F_SETLK, &fl) == -1)
//          /* Handle error
        ;
    }
    exit(EXIT_SUCCESS);
} /* main */

*/*
// Setting the Close-on-Exec Flag
//      The following example demonstrates how to set the close-on-exec flag for the file descriptor fd.

#include <unistd.h>
#include <fcntl.h>
           ...
int flags;

    flags = fcntl(fd, F_GETFD);
    if (flags == -1)
//       Handle error
    flags |= FD_CLOEXEC;
    if (fcntl(fd, F_SETFD, flags) == -1)
//    Handle error
*/
