//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//#define TD_DEBUG


//
// P.Wolfers Software
//


//
// Text Display module.
//


#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <string.h>

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Printer.H>


#include "Service_IO.h"

#include "Text_Display.h"
#include "Text_Display_UI.h"



Text_Display * Text_Display::Init( int w, int h,
                                   const char * nam, const char * fsv, void * own )
{
    Text_Display * myt;

    Text_DisplayUI * tui = new Text_DisplayUI( w, h, nam );
    
    myt  =  tui->w_txt; // The Text_Display is created by the generator Text_DisplayUI.
    myt->win_   = tui->w_win;
    myt->tui_   =  tui;
    myt->fsv_   =  fsv;
    myt->owner_ =  own;
    return myt;
} // Text_Display * Text_Display::Init( int w, int h, const char * name ).



void Text_Display::SetValidMode( const char * slb, const char * vlb, TxtDsp_cb_t cbv )
{
    if (slb && slb[0]) {
        tui_->w_stp->label( slb );
        tui_->w_stp->set_visible(); tui_->w_stp->activate();
        tui_->w_sel->set_visible(); tui_->w_sel->activate();
    } else {
        tui_->w_stp->hide(); tui_->w_stp->deactivate();
        tui_->w_sel->hide(); tui_->w_sel->deactivate();
    }
    if (slb && slb[0]) tui_->w_stp->label( slb );
    if (vlb && vlb[0]) tui_->w_val->label( vlb );
    cbv_ = cbv;
    if (cbv) {
        tui_->w_stp->set_visible(); tui_->w_stp->activate();
    } else {
        tui_->w_stp->hide(); tui_->w_stp->deactivate();
    }
} // void Text_Display::SetValidMode( const char * slb, const char * vlb, TxtDsp_cb_t cbv ).




void Text_Display::Exit() { tui_->Close( 0 ); }



void Text_Display::resize( int x, int y, int w, int h )
{
    Fl_Text_Display::resize( x, y, w, h );
    sc_ = scrollbar_width();
    ww_ = w - sc_; hh_ = h - sc_;
} // void Text_Display::resize( int x, int y, int w, int h ).



int Text_Display::handle( int event )
{
    int      x1, y1, ie = 0;

    x1 = Fl::event_x();
    y1 = Fl::event_y();

    if ((x1 < w())&&(y1 < h())) {
        switch (event ) {
            case FL_PUSH:
                cx_ = x1; cy_ = y1;
                bt_ = Fl::event_button();
                return 1;

            case FL_RELEASE:
                ipos_ = GetPosition( cx_, cy_, row_, col_ );
                if (cbl_ && org_pos_ <= ipos_) cbl_( bt_, row_, col_, owner_ );
                return 1;

            default: return 1;
        }
    } else return Fl_Text_Display::handle( event );
} // int Text_Display::handle( int event );



Text_Display::Text_Display( int x, int y, int w, int h, const char * l ) : Fl_Text_Display( x, y, w, h, l )
{
    cbl_ = NULL;
    cbx_ = NULL;
    cbv_ = NULL;
    fsv_ = NULL;
    cx_ = cy_ = -1;
    ipos_ = row_ = col_ = 0;
    org_pos_ = org_lin_ = 0;
    owner_  =         NULL;
    buf_ = new Fl_Text_Buffer();
    buffer( buf_ );
    textfont( FL_COURIER );
    textsize( 12 );
} // Text_Display::MyText_Display( int x, int y, int w, int h, const char * l ) : Fl_Text_Display( x, y, w, h, l ).



Text_Display::~Text_Display()
{
    if (cbx_) cbx_( owner_ );
} // Text_Display::~Text_Display().



void Text_Display::SetValidLabel( const char * l ) { tui_->Set_Valid_Label( l ); }
void Text_Display::SetExitLabel( const char * l ) { tui_->Set_Exit_Label( l ); }



void Text_Display::ViewSelect( const char * sname ) { tui_->w_sel->value( sname ); }



void Text_Display::TxtSave()
{
    const char *  Text,
               * fpath;

    fpath = FSvSel.File( "Save File as", fsv_, "*.txt", 1 );
//  fpath = fl_file_chooser( "Save File as", "*.txt", fsv_, 0 );

    if (fpath&&fpath[0]) {
        switch (buf_->savefile( fpath )) {
            case 1: // Open Error.
                fl_alert( "Error : Cannot create the file %s\n\t error message %s\n", fpath, strerror( errno ) );
                break;
            case 2: // Write Error.
                fl_alert( "Error :Write error to file %s\n\t error message %s\n", fpath, strerror( errno ) );
                break;
            default: ;
        }
    }
} // Text_Display::TxtSave().



int  Text_Display::SetOrigine()
// Set the text origine position (default is the begin of text).
{
    org_pos_ = buf_->line_start( buf_->length() );
    return org_pos_;
} // int  Text_Display::SetOrigine().



int  Text_Display::GetPosition( int X, int Y, int &r, int &c )
// Get the (text ASCII character limited) character position from X, Y in pixel.
{
    int ipos;
    
    ipos = xy_to_position( X, Y, CHARACTER_POS );
    r = buf_->count_lines( org_pos_, ipos );
    c = ipos - (org_lin_ = buf_->line_start( ipos ));
    return ipos;
} // int  Text_Display::GetPosition( int X, int Y ).



int  Text_Display::Append( const char * fmt, ... )
{
    va_list ap;
    char buffer[1024];

    va_start( ap, fmt );
    ::vsnprintf( buffer, 1024, fmt, ap );
    va_end( ap );
    buf_->append( buffer );
    return buf_->length();
} // int  Text_Display::Append( const char * fmt, ... ).



#ifdef WITH_DEBUG


void MouseCallBack( int bt, int row, int col, void * own )
{
    printf( " Clic with Button %d, at (raw,col) [%d,%d]\n", bt, row, col );
    fflush( stdout );
} // void MouseCallBack( int bt, int row, int col ).



void  ExitCallBack( void * own )
{
    printf( " Exit call back called.\n" );
} // void  ExitCallBack( void * own ).



int faux_main( int argc, char ** argv )
{
    FILE      * fp;
    char line[256];
    char *     str;

    Text_Display * DspTxt;

    if ((argc<=1)&&!argv[1]) {
        fl_alert( " No file was specified => stop" );
        return 1;
    }


    DspTxt = Text_Display::Init( 800, 500, argv[1] );

    DspTxt->SetCallBackMouse( (TxtDsp_Mouse_cb_t)MouseCallBack );
    DspTxt->SetCallBackExit( (TxtDsp_cb_t)ExitCallBack );

    if (fp = fl_fopen( argv[1], "r" )) {
        while (str = fgets( line, 255, fp )) {
            printf( " line = %s", line );
            // if (DspTxt->txt_buffer->text()) DspTxt->txt_buffer->text( str );
//          DspTxt->Append( "%s", str );
            DspTxt->append( str );
        }
        fclose( fp );

        Fl::run();

        printf( " Normal End of faux_main.\n" );
    } else  {
        fl_alert( "The File %s cannot be opened", argv[1] );
        return 1;
    }
    return 0;
} // int faux_main( int argc, char ** argv ).



int main( int argc, char ** argv )
{
    int iret = faux_main( argc, argv );

    printf( " Program Normal end with status %d.\n", iret );
    return iret;
}


#endif

//
// end of <PW-Id>.
//
