//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//


//
// DiaViewer GL multiview display services.
//
//

#include "DiaViewer_GBL.h"
#include "DiaViewer_GL.h"
#include "DiaViewer_MVI.h"


extern DiaViewer_GL  **     Viewer_GLT; // Table o

static int             MaxView  =    4; // Define the number of concurrent view.

static SliRefer      * FreeList = NULL; // List of Free slide reference.

static SliRefer      **       ReferTab; // Table of Views.



SliRefer::SliRefer()
// Creator of the class. for internal use only.
{
    vnext_ =  NULL;
    vslid_ =  NULL;
    vmapp_ =  NULL;
    vtxbf_ = new Fl_Text_Buffer( 2048, 2048 );
    vslii_ = vflmi_ = vpari_ = vchpi_ = vflag_ = vcoun_ = 0;
    vwidx_ =    -1;
} // SliRefer::SliRefer().



void SliRefer::CheckTextEdit()
// Small routine to examine when the current slide anotation
// text changed and set its related flags. 
{
    char * txt = vtxbf_->text(),        // Get the new text copy from the Window text buffer.
         * old = vslid_->Text();        // Get the original text copy from the slide descriptor.

   if (txt&&txt[0]) {                           // When we have a new text (not empty).
        vslid_->FlgSet( Context_SText );        // Flag it in slide decsriptor.
        if (old&&old[0]) {                      // New and Old text are ...
            if (strcmp( old, txt )) {           // ... are different ...
                vslid_->Text( txt );            // ... set the new one.
                vslid_->FlgSet( Context_Update );
            } else if (txt!=old) delete[] txt;  // If the two texts are same, delete the new one.
        } else {                                // The old text does not exist, then ...
            vslid_->Text( txt );                // ... install the new text.
            vslid_->FlgSet( Context_Update );
        }
    } else {                                    // The new text is empty.
        if (txt) delete[] txt;                  // Free a location for an empty text if location exist.
        if (old) {                              // When an old text is existing ...
            delete[] old;                       // ... we free it and flag the text change.
            vslid_->Text( NULL );
            vslid_->FlgSet( Context_Update );   // Flag for Text update.
            vslid_->FlgClr( Context_SText );    // Flag for no slide text comment.
        } else vslid_->FlgClr( Context_SText ); // Flag for no text.
    }   
    txt = old = NULL;
} // void SliRefer::CheckTextEdit().


void OutMemsta( const char * s );       // Routine Reference of GL module to check test for debug.

void SliRefer::CheckNumbersEdit()
// Small routine to examine when the current slide parameters
// are modified and set its related flags.
//
{
//OutMemsta( "CheckNumbersEdit  0" );
    if ((vslii_ != vslid_->Numb()) ||
        (vflmi_ != vslid_->Film()) ||
        (vpari_ != vslid_->Para()) ||
        (vchpi_ != vslid_->Chap()) ||
        (vflag_ != vslid_->FlgTst( Context_Protect ))) {
//OutMemsta( "CheckNumbersEdit  1" );
        // When some indexies are changed, we set the ...
        // ... Update flag and set the new values.
        RefRkgSet( vslid_ );
//OutMemsta( "CheckNumbersEdit  2" );
        vslid_->FlgSet( Context_Update );
        if (vslii_||vflmi_||vpari_||vchpi_||vflag_) vslid_->FlgSet( Context_Slinbr );
                                               else vslid_->FlgClr( Context_Slinbr );
//OutMemsta( "CheckNumbersEdit  3" );
    }
} // void SliRefer::CheckNumbersEdit().






void SliRefer::Init( int nview )
//
// Call to initialize the Slide Reference module.
// This routine create all slide reference block as free of use.
//
{
    SliRefer * p, *q;

    MaxView = nview;
    ReferTab = new SliRefer *[MaxView];

    q = NULL;
    for(int i=0; i<MaxView; i++) {
        p = new SliRefer();
        if (q) {
            q->vnext_ = p;
        } else FreeList = p;
        q = p;
        ReferTab[i] = NULL;
    }
} //void SliRefer_Init( nview ).



void SliRefer::RefFree( int wid )
// Put the reference block in the free reference block list.
//
{
    if (--vcoun_ == 0) {
        // When it is the last use of this reference => Free Slirefer.
        vnext_      =     FreeList;
        vslid_      =         NULL;
        vwidx_      =           -1;
        FreeList    =         this;
    } else {
        // Some other Window(s) use this slide reference.
        if ( vwidx_ == wid) {
            // If the lost reference is the first reference owner (creator), ...
            ReferTab[wid] = NULL;
            // ... we must define a new reference owner.
            for(int i = 0; i < MaxView; i++ ) {
                if (ReferTab[i] == this) { vwidx_ = i; break; }
            }
        }
    }
    ReferTab[wid] = NULL;
} // void SliRefer::RefFree( int no ).



SliRefer * SliRefer::RefLink( SliEntry * sli, int wid )
//
// Note : static to be call without object.
//
{
    SliRefer * p = ReferTab[wid];

    if (p&&p->vcoun_ > 1) {
        p->vcoun_--;
        p = NULL;
    }
    if (!p) {
        p = FreeList;
        FreeList = p->vnext_;
        ReferTab[wid] = p;
        p->vnext_ = NULL;
        Viewer_GLT[wid]->W_text->buffer( p->vtxbf_ );
    }
    p->vcoun_ =   1;
    p->vslid_ = sli;
    p->vtxbf_->text( sli->Text() );
    p->vwidx_ = wid;
    return p;
    
} // SliRefer * SliRefer::RefLink( int no ).



void SliRefer::RefRkgGet( SliEntry * sli )
{
    vslii_ = sli->slid_n_; vflmi_ = sli->film_n_;
    vpari_ = sli->para_n_; vchpi_ = sli->chap_n_;
    vflag_ = sli->FlgTst(  Context_Protect );
} // SliRefer::RefRkgGet(SliEntry * sli ).



void SliRefer::RefRkgSet( SliEntry * sli )
{
    sli->slid_n_ = vslii_; sli->film_n_ = vflmi_;
    sli->para_n_ = vpari_; sli->chap_n_ = vchpi_;
    sli->FlgVal( vflag_ | sli->FlgTst( Context_MemImg ) );
} // SliRefer::RefRkgSet(SliEntry * sli ).



SliRefer * SliRefer::LookMultipl( SliEntry * sli, int wid )
{
    SliRefer    *p, *q;
    int              i;

    for(i = 0; i < MaxView; i++) {      // Loop for all reference(s) of the specified slide ....
        if (p = ReferTab[i]) {          // We must skip any null reference.
            if (sli == p->vslid_) {     // When this slide is already shown, ...
                if (i != wid) {         // ... if it is shown in other window, ...
                    p->vcoun_++;        // ... we update the reference count, ...
                    // ... and free the actual reference use (when it is existing)...
                    if (q = ReferTab[wid]) q->RefFree( wid ); 
                    ReferTab[wid] = p;  // ... and set the existing reference use.
                    Viewer_GLT[wid]->W_text->buffer( p->vtxbf_ );
                }
                
                return p;               // The reference is already linked with window # wid.
            }
        }
    }
    // Here the slide is not referenced (except in the same window).
    p = SliRefer::RefLink( sli, wid );  // Create a new reference block for our window (if not existing).
    p->RefRkgGet( sli );                // Load the context in the reference block.
    
    

    return p;
} // void SliRefer::LookMultipl().



void SliRefer::CheckSliCntx()
// Look at the current slide text and its numbers/flags values
// to determine when some change was occured.
// If yes set the required slide flags before to call
// the SaveSliCntxFlags() slide function to propagate
// it to the volume tree.
//
{
//OutMemsta( "CheckSliCntx A" );
    if (vslid_) {
        CheckTextEdit();        // Check for anotation text modification.
//OutMemsta( "CheckSliCntx B" );
        CheckNumbersEdit();     // Check for parameters modifications.
//OutMemsta( "CheckSliCntx C" );
        // Propagate the possible modification across the volume tree.
        vslid_->SliCntxFlags();
//OutMemsta( "CheckSliCntx D" );
    }
} // SliRefer::CheckSliCntx().



void SliRefer::RefRkgUpdDisp( int s, int f, int p, int c )
// To update Display of Ranking numbers.
{
    DiaViewer_GL   * w;

    for (int i = 0; i < MaxView; i++) {
        if (ReferTab[i] == this) {
            w = Viewer_GLT[i];
            w->W_sliid->value( s );
            w->W_flmid->value( f );
            w->W_parid->value( p );
            w->W_chpid->value( c );
        }
    }
} // void SliRefer::RefRkgUpdDisp().







/**************************************************************************/

#ifdef CODECHECK

void TestUse( SliEntry *sli, int wid )
{
    SliRefer * p = SliRefer::LookMultipl( sli, wid );
}



void Init()
{
    SliRefer::Init( 8 );
}


#endif



//
// end of <PW-Id>.
//
