#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

//
#define LOCK_SH 1   // shared lock
#define LOCK_EX 2   // exclusive lock
#define LOCK_NB 4   // don't block when locking
#define LOCK_UN 8   // unlock
extern int errno;   // this is located elsewhere
//
void debug(int rc){
    if ((rc>0)||(errno>0)){
    printf("rc: %d err: %d\n", rc, errno);
        errno = 0;  // clear for next time
    }
}
//
void main(){
    FILE *fp;
    int   rc;
    struct flock fl = {
        F_WRLCK,  // l_type
        SEEK_SET, // l_whence
        0,        // l_start
        0         // l_len (0 = until eof)
    };

    //
    printf("fopen\n");
    fp = fopen("lock_demo.dat","wr");
    if (fp == NULL){
        printf("err: %d\n", errno);
    perror("-e-cannot open file");
    exit(2);
    }
    printf("lock with fcntl\n");
    fprintf( fp, " Coucou je suis là.\n" ); fflush( fp );
    rc = fcntl( fileno(fp), F_SETLK, &fl );
    if (rc) {
        if (errno == EACCES || errno == EAGAIN)
            printf( " The file is locked\n" );
        else {
            printf("err: %d\n", errno); perror( "-e-Lock err" );
        }
        exit( 2 );
    }
    debug(rc);
    printf("now run this program on another session\n");
    printf("then hit <enter> to continue");
    getchar();
    printf("\n");
    printf("fcntl Unlock\n");
    fseek( fp, 0, SEEK_SET );
    rc = fcntl( fileno(fp), F_UNLCK, &fl );
    debug(rc);
    printf("fclose\n");
    rc = fclose(fp);
    debug(rc);
}
