//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers DiaViewer Software
//

//
// Module to manage a slide collection
// DCM = DiaViewer Collection Management.
//

#ifndef DIAVIEWER_DCM_H
#define DIAVIEWER_DCM_H

#include "DiaViewer_DIA.h"

#include "Service_DIR.h"


//
// Define the Global (Public) function.
//




#define MAX_NESTING  32







class SliScan : SrvDir {
public:
private:
    typedef struct {
        char    * dnm_;
        int       nsl_;
    } DirElm_t;

    DirElm_t  * tpstk_;
    int         bldsc_;
    int         dissp_;
    int         totdi_;
    int         totsl_;

    DirElm_t distk_[MAX_NESTING];

    void PushDir()
    { if (dissp_ < MAX_NESTING-1) tpstk_ = distk_ + (++dissp_); else tpstk_ = 0; }

    void PopDir() { if (dissp_ >= 0) tpstk_ = distk_ + (dissp_--);  else tpstk_ = 0; }

    void Zero() { bldsc_ = totdi_ = totsl_ = 0; dissp_ = -1; }

public:
    SliScan();
    ~SliScan();

protected:
    // We use our specific functions :
    int ErrMan( int, const char * );

    int StartDir( const char * msg );
    int EndDir( int, int );
    int SelFile( int, const char * );

public:
    int AnalyseTree( const char * );
    VolEntry * BuildVolume( const char * );

};





// To check the file/directory access.
int CheckFilePath( char **, int );

// To Open all SetUp file specified Volume.
void OpenVolumeQuList();

// To create a Volume slides and set the slide to display.
int CreateVolumeTree( VolRef * vref );

// To close and free all volume allocations.
///void CloseSlideVolume( VolEntry * vol );


#endif

//
// end of <PW-Id>.
//
