//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


//#define TD_DEBUG


//
// P.Wolfers Software
//

//
// Environment for Text Display module.
//


#ifndef TEXT_DISPLAY_H
#define TEXT_DISPLAY_H

#include <FL/Fl.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Double_Window.H>


typedef void (*TxtDsp_Mouse_cb_t) ( int, int, int, void * );
typedef void (*TxtDsp_cb_t) ( void * );

class Text_DisplayUI;

class Text_Display : public Fl_Text_Display {
friend Text_DisplayUI;

private:
    Text_DisplayUI   *    tui_; // Use to keep the address of Text_Display interface.
    Fl_Double_Window *    win_; // To get access to global text display window.
    const char       *    fsv_; // Default filename for save.
    TxtDsp_Mouse_cb_t     cbl_; // Call_Back routine for customer mouse action.
    TxtDsp_cb_t           cbv_, // Call_Back routine for customer Valid action.
                          cbx_; // Call_Back routine for customer exit action.
    Fl_Text_Buffer   *    buf_;
    int      ww_,   hh_,   sc_,
             bt_,   cx_,   cy_,
            ipos_,  row_, col_,
            org_pos_, org_lin_;
    void              * owner_;

    void resize( int x, int y, int w, int h );
    int handle( int );

protected:

    // The generator is called by the generator of Text_DisplayUI.
    Text_Display( int, int, int, int, const char * = 0 );

    ~Text_Display();

public:

    static Text_Display * Init( int, int,       // Sizes of the window;
                                const char *,   // Window Label,
                                const char *,   // Default filename to save,
                                void * = 0 );   // Owner object.

    void Show() { win_->show(); }
    int  DspW() { return win_->w(); }
    int  DspH() { return win_->h(); }

    void SetCallBackMouse( TxtDsp_Mouse_cb_t cbl ) { cbl_ = cbl; }
    void SetCallBackExit( TxtDsp_cb_t cbl ) { cbx_ = cbl; }
    void SetValidMode( const char * = 0, const char * = 0, TxtDsp_cb_t = NULL );

    void SetValidLabel( const char * );
    void SetExitLabel( const char * );

    void SetSaveFName( const char * fnm ) { fsv_ = fnm; }
    void SetTitleFont( int fnt, int siz ) { labelfont( fnt ); labelsize( siz ); }
    void SetTitle( const char * title ) { label( title ); }

    void SetFont( int fnt, int siz ) { textfont( fnt ); textsize( siz ); }
    void Text( char * txt ) { buf_->text( txt ); }
    int  append( const char * txt ) { buf_->append( txt ); return buf_->length(); }
    int  Append( const char *, ... );
    int  TextPosition() { return buf_->length(); }
    int  CountLines( int sp = 0, int ep = 0 ) { return buf_->count_lines( sp, (ep)? ep : buf_->length() ); }

    int  SetOrigine();
    int  GetPosition( int, int, int &, int & );

    void ViewSelect( const char * );

    void TxtSave();

    void Exit();

};

#endif




//
// end of <PW-Id>.
//
