//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// Environnement fto generatea specific FLTK Spinner Widget.
// P.Wolfers
//




#ifndef FlW_Spinner_H
#define FlW_Spinner_H


#include <FL/Fl.H>
#include <FL/Enumerations.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Repeat_Button.H>


class FlW_Spinner : public Fl_Group {
    
private:
    
    double              value_, // Current value.
                      minimum_, // Minimum value.
                      maximum_, // maximum value.
                         step_; // Amount to add/substract for up/down.
    const char       * format_; // Format string.
    int                  wrap_; // wrap around at bounds (1/0) 

    Fl_Color         outcolor_,
                     actcolor_;

    static void    sb_cb( Fl_Widget *w, FlW_Spinner *sb );
    void              update();

protected:

    class FlW_Spinner_Input : public Fl_Input {
    public:
        FlW_Spinner_Input( int X, int Y, int W, int H )
        : Fl_Input( X, Y, W, H ) {}
        int handle( int event );        // implemented in src/Fl_Spinner.cxx.
    };

    FlW_Spinner_Input         input_;   // Input field for the value
    Fl_Repeat_Button      up_button_,   // Up and Down buttons.
                        down_button_;   //

public:

    // Constructor
    FlW_Spinner( int X, int Y, int W, int H, const char * L = NULL );

    // Event handling
    int     handle( int event );

    // Resize group and subwidgets.
    void    resize( int X, int Y, int W, int H );

    // Sets or Gets FlW_Spinner parameters.
    const char * format() { return format_; }
    void    format( const char *f ) { format_ = f; update(); }

    double  maximum() const { return maximum_; }
    double  minimum() const { return minimum_; }
    void    maximum( double m ) { maximum_ = m; }
    void    minimum( double m ) { minimum_ = m; }
    void    range( double a, double b ) { minimum_ = a; maximum_ = b; }
    /**
        Sets or returns the amount to change the value when the user clicks a button.
        Before setting step to a non-integer value, the spinner
        type() should be changed to floating point.
    */
    double      step() const { return step_; }
    void        step( double s );
    Fl_Color    textcolor() { return input_.textcolor(); }
    void        textcolor( Fl_Color c ) { input_.textcolor( c ); }
    void        textfont( Fl_Font f ) { input_.textfont( f ); }
    Fl_Fontsize textsize() const { return (input_.textsize()); }
    void	textsize( Fl_Fontsize s ) { input_.textsize( s ); }
    /** Gets the numeric representation in the input field.
        \see Fl_Spinner::type(uchar)
    */
    uchar	type() const { return (input_.type()); }
    void        type( uchar );

    // Sets or returns the current value.
    double	value() const { return (value_); }
    void        value( double v ) { value_ = v; update(); }
    void	color(Fl_Color v) { input_.color(v); }
    Fl_Color	color() const { return input_.color(); }
    void	selection_color( Fl_Color val ) { input_.selection_color( val ); }
    Fl_Color	selection_color() const { return input_.selection_color(); }

    void wrap(int set) { wrap_ = set ? 1 : 0; }
    int wrap() const { return wrap_; }

    // Our specific functions

    void set_output();
    void clear_output();

    void     outcolor( Fl_Color c ) { outcolor_ = c; }
    Fl_Color outcolor() { return outcolor_; }

    void     actcolor( Fl_Color c ) { actcolor_ = c; }
    Fl_Color actcolor() { return actcolor_; }

};


#endif


//
// end of <PW-Id>.
//
