//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//


//
// DiaViewer View Manager environment.
//


#ifndef DIAVIEWER8VIEW_H
#define DIAVIEWER8VIEW_H 1


#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <FL/Fl.H>


#include "DiaViewer_SUP.h"
#include "DiaViewer_DIA.h"
#include "DiaViewer_PRG.h"
#include "DiaViewer_MVI.h"
#include "DiaViewer_SUI.h"
#include "DiaViewer_RKGCN.h"



#ifndef  SCREEN_ID
# define SCREEN_ID 0
#endif

class DiaViewer_GL;
class RkgTabCnt;


class DiaView {

private:
    int         Win_Init  =  1, // Flag to init at the first call of draw().
                Win_UInb  =  0, // Index of UI in the Viewer_UI table.
                Win_UFnb  =  0, // Index of UI/GL of the father Viewer during new Viewer creation.
                Win_Start =  0; // Flag for windows creation at DiaViewer start time.

    UInt32      Win_SwFlg =  0; // FLags word for linked sub-Windows.

    //User Interface ace ss definitions:

    Fl_Double_Window *  W_main; // Access pointers to FLTK related window, ...

    Fl_Button       *   W_fdir, // ... to first directory, ...
                    *   W_pdir, // ... to previous directory, ...
                    *   W_fsli, // ... to first slide in the directory, ...
                    *   W_psli; // ... to previous slide, ...
    Fl_Slider       *   W_zoom; // ... to previous slide, ...
    Fl_Button       *   W_nsli, // ... to next slide, ...
                    *   W_lsli, // ... to last slide, ...
                    *   W_ndir, // ... to next directory, ...
                    *   W_ldir; // ... and to last directory.

    Fl_Scrollbar    *W_xscroll, // Pointer to the slider of width ...
                    *W_yscroll; // ... and hight.

    Fl_Button       *  W_class; // Pointer to classement button, ...
    Fl_Output       *   W_path; // ... the slide path output, and the ...
    Fl_Text_Editor  *   W_text; // ... comment text editor/multilign output.

    Fl_Button       *   W_iden, // Return to original orientation, ...
                    *   W_rp90, // ... rotation +90°, ...
                    *   W_rm90, // ... -90°, (clock wise) ...
                    *   W_r180, // ... 180°, ...
                    *   W_invx, // ... x <-> -x, and ...
                    *   W_invy, // ... y <-> -y.
                    *   W_invu, // ... x <-> -y.
                    *   W_invv; // ... x <-> -y.
    Fl_Output       *  W_title; // Title Of Volume Name of path.

//  Fl_Group        * W_slinbr; // The group of slide numbers spinners.
    FlW_Spinner     *  W_sliid, // Display/Edit slide #,
//  Fl_Spinner      *  W_sliid, // Display/Edit slide #,
                    *  W_flmid, // Display/Edit film #,
                    *  W_parid, // Display/Edit paragraph #,
                    *  W_chpid; // Display/Edit Chapter #.
    Fl_Check_Button *   W_lock; // To can change the lock botton flag.
    Fl_Button       *  W_ignor; // To clear and lock ranking data.
    Fl_Light_Button *  W_autom, // Enable/Disable the Auto Mode botton flag.
                    *  W_enrkg; // Enable/Disable ranking data edition.

    SliSearch       * W_seawin; // Pointer to the search interface pointer.
    RkgTabCnt       * W_RkgMap; // Pointer to window related Charp Map.

    Fl_Group        * W_orient, // Pointer to the orientation button group.
                    * W_slcntx, // Pointer to context data group.
                    *  W_brank; // Pointer to ranking buttons group.

    char          SliPath[256]; // The current slide path.

    // This variable Give access to the slide context temporary fields.

    SliRefer         * W_Refer; // Reference to Reference block to manage Ranking ...
                                // ... Numbers, Text Comments and Slides oientations.



public:


    SliEntry        * Curr_Sli; // Pointer to the Current Slide.
    DirEntry        * Curr_Dir; // Pointer to the Current Directory.
    VolEntry        * Curr_Vol; // Pointer to the current Volume.

    SlidePrg        *  Program; // Slide Program to execute.
    SlideExec       *  Process; // Slide processor pointer.


    DiaView::DiaView();
    DiaView::~DiaView();

    int  SwFTst( int flg ) { return Win_SwFlg & flg; }
    void SwFSet( int flg ) { Win_SwFlg |= flg; }
    void SwFClr( int flg ) { Win_SwFlg &= ~flg; }

//    void SetRkgMap( RkgTabCnt * map ) { W_RkgMap = map; }
//    RkgTabCnt * GetRkgMap() { return W_RkgMap; }

    int  FlgVal() { return ViewRkgFlgs; }
    void FlgVal( int val ) { ViewRkgFlgs = val; }
    int  FlgTst( int flg ) { return ViewRkgFlgs&flg; }
    void FlgSet( int flg ) { ViewRkgFlgs |= flg; }
    void FlgClr( int flg ) { ViewRkgFlgs &= ~flg; }
    int  FlgChg( int flg ) { return (ViewRkgFlgs ^= flg)&flg; }

//  int  RkgMap() { return ChartMap; }
//  void RkgMap( int flg ) { ChartMap = flg; }

    void Tranf( int it );       // To manage the slide transformations.
    void ShowSlide( int );      // To display a slide.
    void NormalEnd( int );      // To end a DiaViewer session.
    void SetSize( int, int );   // Force the size (arguments in Gl space).

    void DiaSetup();            // Open and close the setup Window.
    void DiaVersion();          // Open and close the "Window Software informations"..

    void VolClose();            // Close a SlideVolume.
    void VolOpen();             // To Open a new slide volume.
    void VolSelect();           // To change of slide volume.

    void InitStdScan( VolEntry* ); // To initialize and start a manual volume scan.

    void SliScan( int );        // To scan a slide directory.
    void DirRestart( int );     // To restart the slide scan from the begin or end of volume.
    void DirScan( int );        // To scan between of directories.
    void SliTransf( Image_REF::Image_Trf );     // Rotation and mirrors transformation of the current slide.
    void SliPrint();            // To print the current slide.


    void ProtectCntx();         // Save the current slide context.

    void DefSetRkgNbr( int );   // Manage the automatic Ranking default.
    void DefSetSliNbr();        // Back Call on init change of slide number.

    int  RkgEditEnDi( int );    // Return 1/0 when unlocked/locked the CLM/RKG modifications.
    void RkgAutoMode( int );    // To change the flag Auto mode.
    void VNameEditMode( int );  // To change the Volume Name Edit flag.

    void RkgClearCntx();        // Clear context data.
    void RkgCntxClear( int );   // To Clear RKG slide context (0) or Directory context (1).
    void RkgCntxZero();         // Clear all Ranking numbers and set it as write protected.
    void RkgCntxProtect( int, int, int = 0 ); // Modify Context protections.
    void SaveContext();         // Save the data context for the selected volume.

    void SaveVolStatus();       // Save the current Window status in the volume.

    void Search_Init( int = 0, int = 0 );       // Init the Search sub-system.
    void Search_Exit( int );            // Exit from Search sub-system.
    void Search_Process( int );         // Perform a search.

    void Close_SubWindows();     // Close all sub-windows linked wif the vurrent window View.

};



#endif

//
// end of <PW-Id>.
//
