//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Ranking environment.
//
//

#ifndef DIAVIEWER_RKG
#define DIAVIEWER_RKG

#include "DiaViewer_GL.h"
#include "DiaViewer_DIA.h"


void Rkg_Setup( DiaViewer_GL * );       // Call to open the Ranking sub-system.
void Rkg_Quit();                        // Call when quit the Ranking sub-system.
void Rkg_Maximas( int, int );           // Call to transmit changes of maximas.

int  Rkg_NewSliChart( DiaViewer_GL * ); // Entry to create a table of films and slides numbers.
void Rkg_FreeSliChart( DiaViewer_GL * );// Entry to free an existinf table of films and slides numbers.

void Rkg_CreateVolume();                // Call to define the new ranked volume path.

void Rkg_NVolSelect();                  // Call to select a directory for the new Ranked volume.

void Rkg_EnterSliHead();                // Calls to define the slide filename format.
void Rkg_EnterSliSepa();
void Rkg_ChangFlmNbLg();
void Rkg_ChangSliNbLg();

void Rkg_EnterDirHead();                // Calls to define the directory/folder filename format.
void Rkg_ChangDirNbLg();
void Rkg_EnterDirTrai();

void Rkg_Verify();                      // Calls to verify the classement data coherence.

void Rkg_ProtFlg( SliEntry *, int, int );   // Call to modify film protections.
void Rkg_SliLock( SliEntry *, int, int );   // Call to modify any protection of slide.
void Rkg_ProtectMan( SliEntry * );          // Protection manager (with its window).
void Rkg_ChangeTrgPath();                   // When the target path is changed.
void Rkg_ChangeTrgName();                   // When the target volume name is changed.

#endif

//
// end of <PW-Id>.
//
