///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Diaporama Module Environment.
//
//



#ifndef DIAVIEWER_DRMA_H
#define DIAVIEWER_DRMA_H

#include "DiaViewer_DIA.h"



class SliDiaRef {
public:
    SliDiaRef   * nxt_,
                * prv_;
    SliEntry    * sli_;
    char        * txt_;

    SliDiaRef( SliEntry * sli, const char * = NULL );
    ~SliDiaRef() { if (txt_) delete[] txt_; }
};


class SliDlist {

private:
    SliDiaRef  * frst_,
               * last_,
               * curr_;
    char       * name_,
               * path_;
    VolEntry  ** vols_;
    int          scnt_,
                 indx_;

public:
    SliDlist( const char *, const char * = NULL );
    ~SliDlist();

    static SliDlist * Create( const char * path );
    static SliDlist * Open( const char * path );
    void Close();

    SliDiaRef * Append( SliEntry * );
    SliDiaRef * Insert( SliEntry *, SliEntry * );
    SliDiaRef * Locate( SliEntry * );

    void Remove( SliDiaRef * );
    void Remove( SliEntry * );

    int  Save( const char * = NULL );
    int  Load( const char * );

    SliEntry * ScanElem( int = 0 );
    int  WebList( const char * );

};





#endif

//
// end of <PW-Id>.
//
