///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer Diaporama Module Environment.
//
//

#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include <FL/fl_utf8.h>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Native_File_Chooser.H>

#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <math.h>

#include "DiaViewer_DRMA.h"



SliDiaRef::SliDiaRef( SliEntry * sli, const char * txt )
{
    if (sli) {
        nxt_ = prv_ = NULL;
        sli_ = sli;
        if (txt&&txt[0]) txt_ = strdup( txt );
        else
            if (sli->stext_&&sli->stext_[0])
                txt_ = strdup( sli->stext_ );
            else txt_ = NULL;
    }
} // SliDiaRef::SliDiaRef( SliEntry * sli, const char * txt ).



SliDlist::SliDlist( const char * path, const char * name )
{
    frst_ = last_ = curr_ = NULL;
    scnt_ = indx_ =      0;
    name_ = strdup( name );
    path_ = strdup( path );
    vols_ = NULL;
} // SliDlist::SliDlist( const char * name = NULL ).



SliDlist::~SliDlist()
{
    SliDiaRef * cur, * tmp;
    cur = frst_;
    while (cur) {
        tmp = cur;
        cur = cur->nxt_;
        delete tmp;
    }
    frst_ = last_ = curr_ = NULL;
    delete[] name_;
    delete[] path_;
    delete[] vols_;
} // SliDlist::~SliDlist().


SliDlist * SliDlist::Create( const char * path )
{
    SliDlist * lst = new SliDlist( NULL, path );



    return lst;
} // SliDlist * SliDlist::Create( const char * path ).



SliDlist * SliDlist::Open( const char * path )
{
    SliDlist * lst = new SliDlist( NULL, path );



    return lst;
} // SliDlist * SliDlist::Open( const char * path ).



void SliDlist::Close()
{



} // SliDlist * SliDlist::Close().




SliDiaRef * SliDlist::Append( SliEntry * sli )
{
    SliDiaRef * nw = new SliDiaRef( sli );
    if (last_) {
        last_->nxt_ = nw;
        nw->prv_ = last_;
    } else frst_ = nw;
    last_ = nw;
    scnt_++;
    return nw;
} // SliDiaRef * SliDlist::Append( SliEntry * sli ).



SliDiaRef * SliDlist::Insert( SliEntry * snx,  SliEntry * sli )
{
    SliDiaRef * nw = new SliDiaRef( sli ),
              * tm = frst_, * pr = NULL;

    while (tm&&tm->sli_!=snx) { pr = tm; tm = tm->nxt_; }
    if (tm) {
        if (pr) {
            pr->nxt_ = nw;
            nw->prv_ = pr;
        } else frst_ = nw;
        nw->nxt_ = tm;
        tm->prv_ = nw;
    } else {
        if (last_) {
            last_->nxt_ = nw;
            nw->prv_ = last_;
        } else frst_ = nw;
        last_ = nw;
    }
    scnt_++;
    return tm;
} // SliDiaRef * SliDlist::Insert( SliEntry * sli ).



void SliDlist::Remove( SliDiaRef * sdr )
{
    if (!sdr) return;
    if (sdr->prv_) sdr->prv_->nxt_ = sdr->nxt_;
    if (sdr->nxt_) sdr->nxt_->prv_ = sdr->prv_;
    scnt_--;
    delete sdr;
} // void SliDlist::Remove( SliDiaRef * sdr ).



void SliDlist::Remove( SliEntry * sli )
{
    SliDiaRef * tm = frst_;

    while (tm&&tm->sli_!=sli) tm = tm->nxt_;
    if (tm) Remove( tm );
} // void SliDlist::Remove( SliEntry * sli ).



int  SliDlist::Save( const char * fname )
{

    return 0;
} // int  SliDlist::Save( const char * fname ).



int  SliDlist::Load( const char * fname )
{

    return 0;
} // int  SliDlist::Load( const char * fname ).



SliEntry * SliDlist::ScanElem( int id )
// Diaporama Scan :
//  id = n > 0 => Select the n'th slide.
//  id =  0    => go to the next slide.
//  id = -1    => go to the previous slide.
//  id < -1    => go to the last slide.
//
{
    if (!frst_) return NULL;
    if (!id) {
        if (curr_) {
            if (curr_->nxt_) { curr_ = curr_->nxt_; indx_++; }
        } else { curr_ = frst_; indx_ = 1; }
    } else if (id == -1) {
        if (curr_) {
            if (curr_->prv_) { curr_ = curr_->prv_; indx_--; }
        } else { curr_ = last_; indx_ = scnt_; }
    } else {
        if (id == 1) { curr_ = frst_; indx_ = 1; }
        else if (id < -1) { curr_ = last_; indx_ = scnt_; }
        else {
            curr_ = frst_; indx_ = 1;
            while (--id&&curr_&&(curr_->nxt_)) {
                curr_ = curr_->nxt_;
                indx_++;
            }
        }
    }
    return curr_->sli_;;
} // SliEntry * SliDlist::ScanElem( int id ).



int  SliDlist::WebList( const char * )
{

    return 0;
} // int  SliDlist::WebList( const char * ).





//
// end of <PW-Id>.
//
