//
// <PW-Id>
//

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright 2018-2020 by Pierre Wolfers Meylan France                       //
//                                                                           //
// This library is free software. Distribution and use rights are outlined   //
// in the file "COPYING" which should have been included with this file.     //
// If this file is missing or damaged, see the license at:                   //
//                                                                           //
//    <To be define when ready>                                              //
//                                                                           //
//   This license described in this file overrides all other licenses that   //
//   might be specified in other files for this library.                     //
//                                                                           //
//   This library is free software; you can redistribute it  and/or modify   //
//   it under the terms of the GNU Lesser General Public License as publi-   //
//   shed by  the  Free Software  Foundation;  either  version 2.1  of the   //
//   License, or (at your option) any later version.                         //
//                                                                           //
//   This library  is  distributed in  the  hope that  it will  be useful,   //
//   but   WITHOUT  ANY  WARRANTY;  without even  the  implied warranty of   //
//   MERCHANTABILITY  or  FITNESS  FOR A  PARTICULAR PURPOSE.  See the GNU   //
//   Library General Public License for more details.                        //
//                                                                           //
//   You should have  received  a copy of  the  GNU Lesser General  Public   //
//   License  along with this library  (see COPYING.LIB); if not, write to   //
//   the Free Software Foundation :                                          //
//                        Inc., 675 Mass Ave, Cambridge, MA 02139, USA.      //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



//
// P.Wolfers Software
//

//
// DiaViewer GL picture Dialog functions.
//
//


#include <stdio.h>
#include <string.h>

#include <FL/Fl.H>
#include <FL/Fl_Browser.H>
#include <FL/Fl_Hold_Browser.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Native_File_Chooser.H>
#include <FL/Fl_Wizard.H>
#include <FL/Fl_Input.H>


#include "DiaViewer_GBL.h"
#include "DiaViewer_DCM.h"
#include "DiaViewer_GL.h"


#include "DiaViewer_VRFL.h"


#ifdef DEBUG

static VolRefList VolList( "Test" );

#else

extern VolRefList      VolList;  // The list of all known slide volume.

#endif



const char * DLG_DirChooser( const char * msg, const char * fnm )
{
  static      char   path[512];
  char                 * npath;   
  int                       ie;

  if (NativeOFil) {     // Native directory chooser.
    Fl_Native_File_Chooser fnfc;
    fnfc.title( msg );
    fnfc.directory( fnm );
    fnfc.type( Fl_Native_File_Chooser::BROWSE_DIRECTORY );
    switch (ie = fnfc.show() ) {
      case -1: 
        fl_alert( "Error: %s", fnfc.errmsg() );
      case  1:
        return NULL;
    default:
      strncpy( path, fnfc.filename(), 511 );
    }
  } else {              // FLTK Directory file chooser.
    npath = fl_dir_chooser( msg, fnm, 0 /*Absolu path*/ );
    if (npath&&npath[0]) {
      strncpy( path, npath, 511 );
      return path;
    } else return NULL;
  }
  return path;
} // char * DLG_DirChooser( const char * msg, const char * fnm ).




static int     brw_idx;
static void  * brw_dat;
static int     win_sta;
static int     ret_sta;


static void win_cb( Fl_Widget* o, void *dat )
// The Call back function called when the user clic ...
// on a brower line.
//
{
    brw_idx =    0;
    brw_dat = NULL;
    win_sta =    1;
} // static void brwk_cb( Fl_Widget* o, void *dat ).



static void brw_cb( Fl_Widget* o, void *dat )
// The Call back function called when the user clic ...
// on a brower line.
//
{
    brw_idx = ((Fl_Hold_Browser*)o)->value();
    if (brw_idx > 1) {
        brw_dat = ((Fl_Hold_Browser*)o)->data( brw_idx );
        ret_sta =   1;
    }
}


VolRef * DLG_KnownVolume( int flg, const char * lb )
{
    Fl_Browser                   * brw;
    Fl_Wizard                    * wiz;
    Fl_Button                    * but;
    int       sz  =  VolList.GetSize();
    VolRef ** VL  =  VolList.GetRefs(),
           ** lnsort    =         NULL,
                                 * ref;
    const char  * path,  *vnam,  * str;
    char                   buffer[256];
    int       colwidth[] = { 0, 7, 0, 0 };
    int      ii,    jj,   szna,   szpa;


//
    lnsort      =   new  VolRef * [sz]; // Allocate the sort table.
    ret_sta     =   win_sta     =    0; //
    brw_idx     =                    0; // Assume no selected volume.
    brw_dat     =                 NULL;

    Fl_Double_Window win( 500, 220, lb );               // Create the window.
    win.callback( win_cb );
    brw = new Fl_Hold_Browser(10, 10,480,150, NULL  );  // Create the Volume list browser.
    wiz = new Fl_Wizard(  10, 170, 210,  30,  NULL  );
    but = new Fl_Button( 390, 170,  70,  30, "Quit" );  // Create the "Quit" button.
    but->callback( win_cb );

    szna = szpa = 0;
    for(ii = 0; ii < sz; ii++) {        // Loop on all known volume.
        // Evaluate the minimum length of each column.
        lnsort[ii] = ref = VL[ii];
        jj = strlen( ref->name ); if (szna < jj) szna = jj;
        jj = strlen( ref->path ); if (szpa < jj) szpa = jj;
    }

    // Now we sort the lines :
    for (ii = 1; ii < sz; ii++) {
        ref = lnsort[ii];
        jj = ii - 1;
        while (jj >= 0 && fl_utf_strcasecmp( lnsort[jj]->name, ref->name ) >= 0) {
            lnsort[jj+1] = lnsort[jj];
            jj--;
        }
        lnsort[jj+1] = ref;
    }

    // Now we create each browser line.
    // Set the column widths.
    colwidth[0] = szna + 6; // +2
    colwidth[1] =        9; // 7
    colwidth[2] = szpa + 10; // + 2
    colwidth[3] =        0;
    brw->column_widths( colwidth );
    brw->column_char('\t');              // Use tab as the column character.
    snprintf( buffer, 255, " Name\tID\tPath" );    // Create the title line.
//  snprintf( buffer, 255, "@f@bName\tID\tPath" );    // Create the title line.
printf( " line 00 : \"%s\"\n", buffer );
    brw->add( buffer, NULL );
    for( ii = 0; ii < sz; ii++) {
        ref = lnsort[ii];
        snprintf( buffer, 255, " %s :\t%02d\t%s", ref->name, ref->iide, ref->path );
//  snprintf( buffer, 255, "@f@b %s :\t%02d\t%s", ref->name, ref->iide, ref->path );
printf( " line %02d : \"%s\"\n", ii+1, buffer );
        brw->add( buffer, flg ? (void*)ref : NULL );
    }
    delete[] lnsort;
    win.end();
    win.resizable( brw );
    //brw->make_visible();
    //brw->position( 0 );
    win.show();
    while(!(ret_sta || win_sta)) Fl::wait();

    //printf( " -> Select %d\n", brw_idx );

    ref = (VolRef*)brw_dat;

    //if (vol) printf( " Vol path = %s\n", vol->VRoot()->FName() );
    delete but;
    delete wiz;
    delete brw;
    return ref;
} // VolRef * DLG_KnownVolume( int flg, const char * lb ).



VolRef *  DefineVolume()
{
    int       sz = VolList.GetSize();
    VolRef ** VL = VolList.GetRefs();


    return 0;
} // int  DefineVolume().





/*
char * DLG_FileChoice( const char * msg, const char * pat, const char *fnm )
{
  // SetUp Parameter : NativeOFil = 1/0 for use Native_File_Chooser/FLTK_File_Chooser.
  if (NativeOFil) {
    Fl_Native_File_Chooser fnfc;
    fnfc.title( msg );
    fnfc.type(Fl_Native_File_Chooser::BROWSE_FILE);
    fnfc.filter( pat );
    fnfc.directory( fnm );           // default directory to use
    // Show native chooser
    switch ( fnfc.show() ) {
      case -1: // Error
        fl_message( "ERROR: %s\n", fnfc.errmsg());
        Return NULL;
      case  1: // Cancel
        return NULL;
    default: /File selected.
      return fnfc.filename());
    }
  } else {
    // We use the FLTK File Chooser.
    return fl_file_chooser ( msg, pat, fnm, 0  );
  }
} //  DLG_FileChoice( const char * msg, const char * pat, const char *fnm ).
*/

#define MAX_LINE 256


int SlideVolSelect( const char * title, VolEntry * &vol, int flg )
// Routine to select a slide volume from the actual opened slides volumes.
// if flg = 0 the any opened volume (user or memory volume, ...
// ... else only the user volume can be selected.
// On success, vol is set as the pointer of the  selected volume descriptor, and ...
// ... the line number is returned. Else (on rejected action) 0 is returned.
//
// Note : When flg is set (flg != 0), the returned value is always the number of the line,
//        but, as the memory(ies) slides volume are no displayed, this value is not the
//        slide volume index because the memory volume are not displayed.
//        
{
  VolEntry        ** VolList;
  VolEntry         *  Volume;
  const char  * path, * vnam;
  int              len, nvol;

  char        line[MAX_LINE];
  static const
    char dnam[] = "<noname>";

  nvol = OpenVolTable.TabUse(); // Get number of opened volume.
  if (nvol <= 0) return -1;     // No opened volume : error!
  VolList = (VolEntry**) OpenVolTable.GetObjs();        // Get the list of opened volumes.

  ret_sta =    0;               //
  brw_idx =    0;               // Assume no selected volume.
  brw_dat = NULL;

  Fl_Double_Window win( 500, 200, title );
  Fl_Hold_Browser *brw = new Fl_Hold_Browser( 5, 5, 490, 190, NULL );
  brw->callback( brw_cb );
  for(int i = 0; i < nvol; i++) {
    Volume = VolList[i];
    if (!(flg&&(Volume->FlgTst( Context_MemImg )))) {
      path = Volume->VRoot()->FName();
      vnam = Volume->VName();
      if (!(vnam&&vnam[0])) vnam = dnam;
      len  = strlen( path );
      len += strlen( vnam ) + 12;
      if (len>=MAX_LINE) {
        line[MAX_LINE-1] =   0;
        line[MAX_LINE-2] =   '.'; line[MAX_LINE-3] =   '.';
        line[MAX_LINE-4] =   '.'; line[MAX_LINE-5] =   ' ';
      }
      snprintf( line, MAX_LINE-1, " %3d / %s : %s", i+1, vnam, path );
      brw->add( line, (void*)Volume );
    }
  }


  win.resizable( brw );
//brw->make_visible();
//brw->position( 0 );
  win.end();
  win.show();
  while(!ret_sta) Fl::wait();

//printf( " -> Select %d\n", brw_idx );

  vol = (VolEntry*)brw_dat;
    
//if (vol) printf( " Vol path = %s\n", vol->VRoot()->FName() );
  return brw_idx;
}



#ifdef  DEBUG

int main( int argc, char ** argv )
{
    char buf[32];
    VolRef * ref;

    for(int ii = 1; ii < argc; ii++) {
        sprintf( buf, "N_%2d", ii+1 );
        VolList.Append( buf, argv[ii] );
    }

    ref = DLG_KnownVolume( 0, "Know Vol Essai" )

    if (ref) {
        printf( " %2d : %s :: %s\n", ref->iide, ref->name, ref->path );
    }
    return 0;
}


#endif

//
// end of <PW-Id>.
//

