#!/bin/sh
#
# Application File to generate a binary kit
#
#
echo " Install for DiaViewer V 1.0A -  05-Sep-2020"
#
flg_static=1
flg_sstatic=
flg_clean=1
opt_debug=
opt_help=
opt_wall=
opt_ccoth=
opt_lnoth=
opt_cc=
opt_cxx=
while test $# -gt 0
do
  case "$1" in
   -ncl | -noclean | -NCL | -NOCLEAN)
      flg_clean=
      ;;
   -nosta | -NOSTA)
      flg_static=
      ;;
   -ssta | -SSTA)
      flg_sstatic=1
      ;;
   -cc |  -CC)
      opt_cc=" -cc $2"
      shift
      ;;
   -cxx |  -CXX | -c++ | -C++)
      opt_cxx=" -cxx $2"
      shift
      ;;
   -g | -G)
      opt_debug=" -g"
      ;;
   -Wall | -WALL | -wall)
      opt_wall=" -Wall"
      ;;
   -ccso | -CCSO | -ccsoth | -CCSOTH)
      opt_ccoth=" -ccsopt $2"
      shift
      ;;
   -lnso | -LNSO | -lnsoth | -LNSOTH)
      opt_lnoth=" -lnsopt $2"
      shift
      ;;
   -h | -H | -help | -HELP)
      opt_help=1
      ;;
   *)
      echo " generator.sh : Unknown option \"$1\""
      opt_help=1
      ;;
  esac
# Skip to next option/arg. in the command line.
  shift
done
#
if test $opt_help
# Output the Help message on unknown option.
then
  echo "Usage: Generator of DiaViewer.sh [OPTIONS]
Options:                                                               synonyms

    [-ncl]    Don't clean old object/exec files before compilation.     -NCL -noclean -NOCLEAN

    [-nosta]  Specify to use sharable libraries (none static),          -NOSTA
              the default is to use static libraries.

    [-ssta]   Specify to use all static library to get maximum          -SSTA
              portable executable file.

    [-g]      Set debugging mode,                                       -G
    
    [-Wall]   Set -Wall warning option of compiler.                     -WALL -wall

    [-ccso]   Other compiler option                                     -CCSO -ccsoth -CCSOTH

    [-help]   To output this text.                                      -HELP, -h, -H
"
  exit 1
fi
#
#
kernel=$(uname)
processor=$(arch)
exetyp=
addrwidth="64"
#
case $processor in
  x86_64)
    proctype="x86_64"
    ;;
  aarch64)
    proctype="arm64"
    ;;
  aarch32)
    proctype="arm32"
    addrwidth="32"
    ;;
  *)
    addrwidth="32"
    proctype="i686"
    ;;
esac
#
case $kernel in
  CYGWIN*)
    dir_bld="Cygwin"
    exetyp=".exe"
    ;;
  MINGW*)
    dir_bld="Mingw32"
    exetyp=".exe"
    ;;
  Linux)
    dir_bld="Linux"
    ;;
  *)
    dir_bld="Unix"
    echo " *** -> Not identified Operating system \"${kernel}\" ==> Assume unknown Unix."
    ;;
esac
dir_bld="${dir_bld}_${proctype}_${addrwidth}_bin_kit"
#
echo "
    We run on the OS $kernel on the processor $proctype (mode $addrwidth bits).

"
#
# Create the FLTK Configuration file.
#
if test $flg_static
then
  flg_static=" -sta"
else
  flg_static=
fi
if test $flg_sstatic
then
  flg_static=" -ssta"
fi
#
cmd="./make_fltk_config.sh${opt_cc}${opt_cxx}${flg_static}${opt_debug}${opt_wall}${opt_ccoth}${opt_lnoth} -gl -png -jpg"
echo
echo " exec *** \"$cmd\" ***"
echo
$cmd
#
#
# Program Compilation.
#
cd src
#
if test $flg_clean
then
  make clean
fi
make
if test "$?" != "0"
then
  exit $?
fi
#
cd ..
#
# ## Copy the version file
#
# ## Copy the install.sh File
#
#
echo
echo " Copy the file in the ${dir_bld}  target directory."
echo
#
if ! test -d $dir_bld
then
  mkdir $dir_bld
fi
#
cp bin/DiaViewer${exetyp} $dir_bld/
#
#
echo
echo " *** End of DiaViewer Build Process ***"
echo
#
