program TEST_SCHEME;

type
    matrix( m, n: integer ) = array[1..m,1..n] of integer;

    mat22 = matrix( 2, 2 );

const

%ifdef MCTE %then
    m0  = matrix[ 2, 2, [0, 1], [1, 0]];
    mxy = mat22[[3, 4], [5, 6]];
%endif


type
    mat_ptr = ^matrix;

var
    m1: matrix(3,2) := [[ 1, 2], [3, 5], [8, 13]];

%ifundef MCTE %then
    m0:  matrix( 2, 2 ) := [[0, 1], [1, 0]];
    mxy: mat22          := [[3, 4], [5, 6]];
%endif



procedure := ( out_var tg: mat22; in_var sr: mat22 );
begin
    for i := 1 to 2 do
        for j := 1 to 2 do
            tg[i,j] := sr[i,j]
end := ;


%ifdef MATMULG %then

function * (m1, m2: matrix): mat_ptr;
var
    pm: mat_ptr;
    s: real;

begin
    if m1.n = m2.m then
    begin
        NEW( pm, m1.n, m2.m );
        for i := 1 to m1.n do
        for j := 1 to m2.m do
        begin
            s := 0;
            for k := 1 to m1.n do
                s := s + m1[i,k]*m2[k,j];
            pm^[i,j] := s
        end
    end else pm := nil;
    return pm;
end;

%endif



%ifdef MATMUL2 %then

function * ( mb, mc: mat22 ): mat22;
var
    s:  real;
    m: mat22;

begin
    for i := 1 to 2 do
    for j := 1 to 2 do
    begin
        s := 0;
        for k := 1 to 2 do
        begin
            s := s + mb[i,k]*mc[k,j];

  %ifdef FNCRET %then

            function[i,j] := s

  %else

            m[i,j] := s

  %endif
        end
    end;

  %ifundef FNCRET %then

    return m

  %endif

end;

%endif


procedure := ( out_var tg: matrix; in_var sr: matrix );
var
    mi, ni: integer;

begin
    WRITELN( ' Source  [', sr.m:4, ',', sr.n:4, ']' );
    WRITELN( ' Cible   [', tg.m:4, ',', sr.n:4, ']' );
    WRITELN;

    if tg.m < sr.m then mi := tg.m else mi := sr.m;
    if tg.n < sr.n then ni := tg.n else ni := sr.n;
    if tg.m = sr.m and tg.n = sr.n then
        for i := 1 to tg.m do
            for j := 1 to tg.n do
                tg[i,j] := sr[i,j];
(*
    for i := mi to tg.m do
        for j := ni to tg.n do
            tg[i,j] := 0
*)
end := ;



%ifdef MATMUL %then

function * ( mb, mc: mat22 ): mat22;
var
    s:  real;
    m: mat22;

begin
    for i := 1 to 2 do
    for j := 1 to 2 do
    begin
        s := 0;
        for k := 1 to 2 do
            s := s + mb[i,k]*mc[k,j];
        m[i,j] := s
    end;
    return m
end *;

%endif


procedure Som_Matrix( var ma: matrix );
var
    s: real := 0;

begin
    for i := 1 to ma.m do
    for j := 1 to ma.n do
        s := s + ma[i,j];
    WRITELN( ' SOMME = ', s:4 )
end Som_Matrix;



procedure WRITE$OBJECT( in_var ma: matrix );
var
    mm, mn: integer;

begin
    mm := ma.m; mn := ma.n;
    for i := 1 to mm do
    begin
        WRITE( ' ':8 );
        for j := 1 to ma.n do
        begin
            if j = 1 then WRITE( '| ' ) else WRITE( ', ' );
            WRITE( ma[i,j]:4 );
        end;
        WRITELN( ' |' )
    end;
    WRITELN
end WRITE$OBJECT;



procedure MATHWORK;
type
    mat33 = matrix( 3, 3 );

var
    nv: integer := 2;

    ma, mb, mc: mat22 (* matrix(2,2) *);

    mx: matrix( 3, 3 );

    pm: ^matrix := nil;

begin
    mb := matrix[ 2, 2, [  1,   0 ], [  0,   1 ]];
    mc := matrix[ 2, 2, [  0,  -1 ], [  1,   0 ]];

    mx := matrix[ 3, 3, [ 0, 0, 1 ],
                [ 0, 1, 0 ],
                [ 1, 0, 0 ]];

    WRITELN( "\t mx initial [", ma.m:0, '..', ma.n:0, "] :\n", ma, "\n" );

    NEW( pm, 2, 2 );

    writeln( ' dimensions pm^ :  [', pm^.m, ', ', pm^.n, "]\n" );

    ma := mb*mc;

    pm^ := ma;

    WRITELN( " Resultat :\n", pm^, "\n" );

    DISPOSE( pm );

    for nv := 2 to 4 do
    begin
        NEW( pm, nv, nv );
        for i := 1 to nv do
            for j := 1 to nv do
                pm^[i,j] := i*10 + j;
        WRITELN( ' Matrice [', nv:0, ',', nv:0, "]\n", pm^, "\n" );
        DISPOSE( pm )
    end;
end MATHWORK;




begin { main }

    WRITELN( "\n     m0 =\n", m0, "\n\n" );

    WRITELN( "\n     mxy =\n", mxy, "\n\n" );

    WRITELN( "\n     m1 =\n", m1, "\n\n" );

    Som_Matrix( m1 );

      MATHWORK;

end TEST_SCHEME.
