/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>
static P Lx[6];

/* Define the local data section. */
static Blk( Rd, 1376 ) = {{
 15,  15, 101, 120, 112, 114, 101, 115, 115, 105, 111, 110,  95, 116, 121, 112,
101,  62,  62,  47, 104, 111, 109, 101,  50,  47, 112, 105, 101, 114, 114, 101,
 47,  83, 111, 102, 116,  47,  78, 101, 119,  95,  75, 105, 116, 115,  47,  99,
112,  97, 115,  99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,
 53,  45,  51,  47, 112,  99, 109, 112,  95,  99, 111, 109, 112,  46, 112,  97,
115,   4,   4,  69,  88,  80,  84,  10,  10, 101, 120, 112,  95, 103, 101, 110,
110, 117, 109,   4,   4,  69,  71,  67,  84,   9,   9,  97, 116, 116, 114,  95,
116, 121, 112, 101,   4,   4,  65,  84,  84,  89,   7,   7,  36, 115, 105, 110,
103, 108, 101,   7,   7,  36, 100, 111, 117,  98, 108, 101,   6,   6,  36,  97,
116, 116, 114,  95,  14,  14,  98, 117, 105, 108, 100,  95,  97, 114, 103,  95,
108, 105, 115, 116,   4,   4,  66,  65,  82,  71,  16,  16,  99,  97, 108, 108,
 95, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,   4,   4,  70,  67,
 65,  76,  18,  18,  99,  97, 108, 108,  95, 105, 110, 100, 105, 114, 101,  99,
116,  95, 112, 114, 111,  99,  12,  12,  99,  97, 108, 108,  95, 103, 101, 110,
101, 114, 105,  99,   4,   4,  67,  65,  76,  71,   9,   9, 111, 112, 101, 110,
 95,  99,  97, 108, 108,   4,   4,  79,  80,  69,  78,  14,  14, 114, 101,  97,
100, 119, 114, 105, 116, 101,  95,  99,  97, 108, 108,   4,   4,  82,  87,  73,
 79,  18,  18, 103, 101, 116,  95, 115, 116,  97, 116, 101,  95, 101, 102, 102,
 95, 108, 105, 115, 116,  15,  15, 117, 115, 101, 114,  95, 115, 116,  97, 116,
101,  95,  99,  97, 108, 108,   4,   4,  85,  83,  84,  65,   8,   8, 110, 101,
119,  95,  99,  97, 108, 108,   4,   4,  78,  69,  87,  67,  12,  12, 100, 105,
115, 112, 111, 115, 101,  95,  99,  97, 108, 108,   4,   4,  70,  82,  69,  69,
 20,  20, 103, 101, 110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,
 97, 116,  95, 115, 101, 116,   4,   4,  83,  65,  71,  82,  20,  20, 103, 101,
110,  95, 108, 105, 115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 116,
 97,  98,   4,   4,  84,  65,  71,  82,  20,  20, 103, 101, 110,  95, 108, 105,
115, 116,  95,  97, 103, 114, 101, 103,  97, 116,  95, 114, 101,  99,   4,   4,
 82,  65,  71,  82,  12,  12, 103, 101, 116,  95,  97, 103, 114, 101, 103,  97,
116, 101,   4,   4,  65,  71,  82,  69,  13,  13, 101, 120, 112,  95,  99, 111,
110, 115, 116,  95, 115, 101, 116,   4,   4,  67,  83,  69,  84,  11,  11, 103,
101, 116,  95, 112, 114, 111,  99, 114, 101, 102,   4,   4,  71,  80,  82,  79,
 15,  15, 101, 120, 112,  95, 103, 101, 110, 101, 114, 105,  99,  95, 114, 101,
102,   4,   4,  69,  88,  71,  69,  14,  14, 101, 120, 112,  95, 105, 100, 101,
110, 116, 105, 102, 105, 101, 114,   4,   4,  82,  70,  79,  66,   9,   9, 101,
120, 112,  95, 105, 110, 100, 105, 114,   4,   4,  73,  78,  68,  73,   9,   9,
101, 120, 112,  95, 102, 105, 101, 108, 100,   4,   4,  71,  70,  76,  68,   9,
  9, 101, 120, 112,  95, 105, 110, 100, 101, 120,   4,   4,  73,  78,  68,  88,
  7,   7, 101, 120, 112,  95, 117, 110,  97,   4,   4,  69,  88,  80,  82,   7,
  7, 101, 120, 112,  95, 112, 111, 119,   7,   7, 101, 120, 112,  95, 109, 117,
108,   7,   7, 101, 120, 112,  95,  97, 100, 100,   7,   7, 101, 120, 112,  95,
114, 101, 108,   7,   7, 101, 120, 112,  95,  97, 110, 100,  10,  10, 101, 120,
112, 114, 101, 115, 115, 105, 111, 110,  14,  14,  99,  97, 115, 101,  95, 119,
111, 114, 107,  95, 108, 105, 115, 116,   4,   4,  67,  65,  83,  68,  15,  15,
 99,  97, 115, 101,  95, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110,  17,
 17, 115, 101, 116,  95,  97, 108, 105, 103, 110, 109, 101, 110, 116,  95, 115,
112,  99,   4,   4,  65,  76,  71,  78,  14,  14,  99, 111, 110, 102, 111, 114,
109,  97, 110, 116,  95, 100, 101, 102,   4,   4,  67,  78,  70,  65,   9,   9,
 97, 114, 114,  97, 121,  95, 100, 101, 102,   4,   4,  65,  82,  82,  89,   8,
  8, 116, 121, 112, 101,  95, 115, 112,  99,   4,   4,  84,  89,  80,  83,  18,
 18, 115, 101, 116,  95, 100, 101,  99, 108,  95,  97, 116, 116, 114, 105,  98,
117, 116, 101,   4,   4,  68,  65,  84,  84,  13,  13, 118,  97, 114,  98, 108,
 95, 115, 101, 116, 116, 105, 110, 103,   4,   4,  86,  65,  82,  66,  10,  10,
 99, 111, 110, 115, 116,  95, 100, 101,  99, 108,   4,   4,  67,  79,  78,  68,
  9,   9, 116, 121, 112, 101,  95, 100, 101,  99, 108,   4,   4,  84,  89,  80,
 68,  10,  10, 118,  97, 114,  98, 108,  95, 100, 101,  99, 108,  10,  10, 108,
 97,  98, 101, 108,  95, 100, 101,  99, 108,   4,   4,  76,  65,  66,  68,  14,
 14, 115, 116,  97, 116, 101, 109, 101, 110, 116,  95, 100, 101,  99, 108,   4,
  4,  83,  84,  65,  68,  13,  13,  97, 114, 103, 117, 109, 101, 110, 116,  95,
108, 105, 115, 116,   4,   4,  65,  82,  71,  76,   3,   3,  46, 114, 118,  16,
 16, 102, 111, 114, 109,  97, 108,  95, 112, 114, 111,  99,  95, 100, 101,  99,
108,   4,   4,  70,  80,  68,  69,  15,  15, 102, 111, 114, 109,  97, 108,  95,
112, 114, 111,  99,  95, 112, 116, 114,   4,   4,  70,  80,  68,  69,  18,  18,
105, 110, 115, 101, 114, 116,  95, 110, 101, 119,  95, 103, 101, 110, 101, 114,
105,  99,   4,   4,  73,  71,  69,  78,   9,   9, 112, 114, 111,  99,  95, 100,
101,  99, 108,   4,   4,  68,  80,  82,  79,   4,   4,  80,  82,  67,  95,   4,
  4,  80,  82,  67,  95,   9,   9, 112, 114, 111,  99,  95,  98, 111, 100, 121,
  4,   4,  71,  69,  78,  68,   9,   9, 103, 101, 110, 101,  95, 100, 101,  99,
108,  10,  10, 103, 101, 110,  95,  97, 115, 115, 105, 103, 110,   4,   4,  71,
 65,  83,  83,  12,  12, 114, 101, 116, 117, 114, 110,  95, 115, 116,  97, 116,
101,   4,   4,  82,  69,  84,  85,  16,  16,  97, 115, 115, 105, 103, 110, 109,
101, 110, 116,  95, 115, 116,  97, 116, 101,   4,   4,  65,  83,  83,  73,  10,
 10, 119, 105, 116, 104,  95, 115, 116,  97, 116, 101,   4,   4,  87,  73,  84,
 72,   8,   8, 105, 102,  95, 115, 116,  97, 116, 101,   4,   4,  73,  70,  83,
 84,  10,  10, 101, 120, 105, 116,  95, 115, 116,  97, 116, 101,   4,   4,  69,
 88,  83,  84,  10,  10, 108, 111, 111, 112,  95, 115, 116,  97, 116, 101,   4,
  4,  76,  79,  79,  80,   9,   9, 102, 111, 114,  95, 115, 116,  97, 116, 101,
  4,   4,  70,  79,  82,  95,  10,  10, 103, 111, 116, 111,  95, 115, 116,  97,
116, 101,   4,   4,  71,  84,  79,  76,  11,  11,  98, 101, 103, 105, 110,  95,
115, 116,  97, 116, 101,   4,   4,  66,  69,  71,  83,  12,  12, 108,  97,  98,
101, 108,  95,  97, 116, 116,  97,  99, 104,   9,   9, 115, 116,  97, 116, 101,
109, 101, 110, 116,   4,   4,  83,  84,  65,  84,   9,   9, 115, 116,  97, 116,
101, 108, 105, 115, 116,   4,   4,  83,  84,  76,  73,   9,   9,  99, 109, 112,
 95,  98, 108, 111,  99, 107,   4,   4,  66,  76,  79,  67,   5,   5,  46, 116,
101, 109, 112,   8,   8,  99, 109, 112,  95, 105, 110, 105, 116,   9,   9,  99,
109, 112,  95, 112,  97, 115, 115,  50,  11,  11,  99, 109, 112,  95,  99, 111,
109, 112, 105, 108, 101,   4,   4,  67,  77,  80,  77,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 64 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 8 );

/* Declaration of external variables. */
extern Blk(V_typ_std, 248 );
extern UB V_cmp_range;
extern V V_curr_descr;
extern UB V_enm_range;
extern Blk(V_sy_sym, 8 );
extern V V_attr_list;
extern Blk(V_sy_ident, 32 );
extern V V_ima_typ;
extern V V_int_typ;
extern Blk(V_ide_udptr, 120 );
extern V V_iof_std_open;
extern UB V_sy_label_flag;
extern SL V_dst_seti;
extern SL V_dst_seta;
extern SL V_dst_setw;
extern V V_set_entry_proc;
extern SL V_stri_stroffset;
extern UB V_lastsymb;
extern V V_sy_search;
extern Blk(V_lex_ident_tree, 4160 );
extern SL V_ident_disp;
extern SL V_sy_ival;
extern G V_sy_rval;
extern Blk(V_sy_string, 264 );
extern SL V_curr_disp;
extern UB V_sy_casedef;
extern UB V_err_prt;
extern SL V_sy_descr_size;
extern V V_sy_type_gfirst;
extern UB V_sy_init_mod;
extern UB V_sy_fix_range_ctl;
extern SL V_fptr_size;
extern SL V_stri_descrsz;
extern SL V_stri_lengthsz;
extern V V_usi_tab;
extern V V_csi_tab;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern V V_all_fglobal;
extern V V_all_lglobal;
extern V V_all_fstatic;
extern V V_all_lstatic;
extern SL V_inte_size;
extern V V_uns_typ;
extern SL V_sngl_size;
extern SL V_dble_size;
extern UB V_tcas_flag;
extern SL V_curr_lex;
extern UB V_error_result;
extern UB V_cmp_dynamic;
extern Blk(V_lex_ident_level, 128 );
extern UB V_sy_generic_qmod;
extern V V_pro_d_first;
extern V V_pro_d_last;
extern Blk(V_opname, 960 );
extern SL V_proc_seq;
extern SL V_cmp_traceopt;
extern SL V_cmp_trace;
extern UB V_cmp_objf;
extern V V_pro_last;
extern V V_pro_first;
extern V V_new_entry_proc;
extern V V_newh_entry_proc;
extern V V_dispose_entry_proc;
extern V V_iof_std_close;
extern V V_inp_std_sel;
extern V V_inp_std_gene;
extern V V_inp_std_eoln;
extern V V_inp_std_bin;
extern V V_out_std_sel;
extern V V_out_std_gene;
extern V V_out_std_eoln;
extern V V_out_std_bin;
extern V V_gen_std_string1;
extern V V_gen_std_cnfardsc;
extern Blk(V_ope_table, 240 );
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_wildtmp_stk;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_src_control;
extern UB V_emergency_stop;
extern V V_pro_current;
extern SL V_cprc_disp;
extern UB V_sy_var_init_mod;
extern V V_cntx_varbl;
extern V V_wildtmp_typ;
extern V V_wildtmp_ide;
extern SL V_wildtmp_psz;
extern Blk(V_wildtmp_pal, 8 );
extern UB V_opt_exec;
extern UB V_cmp_cmpdbg;
extern UB V_cmp_genenv;
extern SL V_cmp_listlvl;
extern UB V_cmp_macf;
extern UB V_cmp_cobj;
extern UB V_cmp_bltt;
extern UB V_cmp_opt;
extern UB V_cmp_debugopt;
extern UB V_cmp_debug;
extern SL V_cmp_tracecount;
extern SL V_cntx_procname;
extern SL V_cntx_srcfname;
extern SL V_cntx_linenbr;
extern SL V_cntx_size;
extern V V_cntx_typ;
extern V V_env_file;
extern V V_env_first;
extern V V_env_last;
extern C V_sy_ch;
extern V V_pas_main;


/* Function/procedure prototypes. */
void P_lst_page();
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_src_end_of_line();
C P_src_search_char();
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2);
void P_data_format_set(V F_ty);
V P_tab_new(SL F_sz);
void P_val_new(V *F_p, V F_ty);
void P_val_free(V *F_p);
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree);
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind);
void P_all_free(V F_p);
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm);
void P_lgt_new_copy(V F_model, V *F_copy);
void P_lgt_copy_tree(V F_src, V *F_dst);
void P_lgt_free(V *F_p);
void P_lgt_free_tree(V *F_p);
V P_lgt_new_econst(V F_ty, SL F_iv);
SL P_lgt_get_econst(V F_lgt, SL F_idf);
V P_lgt_new_code(UB F_pcd, V F_par);
V P_lgt_new_call(V F_pty, V F_pro, V F_par);
V P_lgt_link(V F_lgt);
V P_lgt_new_idref(V F_id, V F_lnk);
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2);
void P_new_disp_level(V F_ow, UB F_kind);
void P_ide_reserve_disp(SL F_prv);
SL P_match(V F_s1, V F_s2);
V P_new_int_name(V F_head, SL *F_nbs);
V P_level_search(V F_fp);
V P_lex_search(SL F_disp);
V P_ide_search(UW F_fs);
void P_ide_new(UB F_fc, V F_ty, V *F_ip);
void P_gen_cntxvar(V F_pr, V F_id);
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd);
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd);
void P_label_purge(V *F_prv_cntx);
SL P_typ_alignement(SL F_iaddr, V F_aln);
SL P_ide_typ_align(SL F_iaddr, V F_ty);
void P_cte_allocate(V F_vp, V F_id);
void P_ide_new_typ(UB F_frm, V *F_p);
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ);
void P_tmpstk_free(V F_stkp);
void P_free_typ_list(V *F_p);
void P_free_ide_list(V *F_p);
void P_ide_create_name(V F_name);
void P_ide_int_label();
V P_ide_search_from_nameid(V F_ip);
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach);
V P_new_oper(UB F_pcd, V F_rty, V F_it1, UB F_cv1, UW F_ip1, V F_it2, UB F_cv2, 
UW F_ip2);
void P_compile_set_title();
void P_compile_set_sbttl(V F_prc);
void P_insymbol();
void P_skip_symbol(UB F_tosymbol, UB F_errflg, UB F_rflg);
void P_insy_init();
void P_set_strname(V *F_nam);
void P_set_stdname(V F_pr);
UB P_comp_type(V F_eff, V F_frm, UB F_exact, UB F_sym);
UB P_comp_proc_arg(V F_epr, V F_fpr);
V P_compare_proc_argid(V F_pgc, V F_pgl, V F_ent);
void P_type_parm_cte_init(V F_ty, V *F_lghf, V *F_lghl, SL *F_count);
void P_type_parm_cte_release(V F_ty);
void P_string_in_array(V F_lgt, V F_ty);
void P_string_in_substring(V F_lgt, V F_ty);
void P_call_setting(V *F_lgt);
void P_generic_search(V F_id, SL F_npa, V *F_pg, V F_parm_lst);
V P_exp_genoper(V F_id, V F_p, V F_oblst);
V P_exp_genop(UB F_op, V F_oblst);
V P_lgt_gen_store(V F_prm, UB F_bstd, UB F_bovr);
V P_generate_call(V F_ip, V F_lgp, SL F_np, UB F_bsnsea);
void P_initialize_varbl(V F_ip);
void P_init_d_dyn(V F_ty, V F_trg, V *F_lgth, V *F_lgtl, UB F_bindir, V F_ide);
void P_init_d_varbl(V F_ip);
void P_type_check_parm(V F_lgt);
V P_type_parm_set(V F_ip, V F_lgt);
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd);
V P_lgt_type_eval(V F_troot, V F_prm_actual, V F_ty, UB F_elm_arr);
void P_lgt_gen_routine(V F_ty);
V P_lgt_type_compute(V F_expr, V F_expe, SL F_dvl, V F_obj);
void P_lgt_extract_simple_cte(V F_lgt);
void P_lgt_all_fparm(V F_pr);
void P_lgt_pass1_complet(V F_pr);
void P_lgt_dump_proc(V F_pr);
void P_lgt_dump_static(V F_pr);
void P_generation_setting();
void P_generate_code_p1(V F_proc);
void P_generate_code_p2();
void P_add_inherit_file(V F_fenv);
void P_pas_read_env_file();
void P_pas_write_env_file();
void PAS_COMILER_cmp_pass2(V F_pr);
V PAS_COMILER_PRC_00000000();
V PAS_COMILER_PRC_00000001(UB F_isfunction);
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid);
V PAS_COMILER_PRC_00000019(V F_ty);
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg);
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ);
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty);
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid);


/* Procedure/Function : " expression_type "  */
V PAS_COMILER_PRC_00000005(V F_it, UB F_exact, UB F_no_def, UB F_no_check){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  C Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=186; /* line # 186 */
  Rv0=0;
  Ra.sl[6]=187; /* line # 187 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=188; /* line # 188 */
  if (Rv1!=NULL) {
    Ra.sl[6]=189; /* line # 189 */
    Rv2=Rv1;
    Rv3=F_it;
    Ra.sl[6]=190; /* line # 190 */
    if (((V *)Rv2)[3]!=F_it) {
      Ra.sl[6]=192; /* line # 192 */
      if (((UB *)Rv2)[40]==14) {
        Ra.sl[6]=194; /* line # 194 */
        if (((V *)Rv2)[3]==V_typ_std.v[13]&&P_comp_type(((V *)Rv2)[3],F_it,0,0))
         {
          Ra.sl[6]=195; /* line # 195 */
          ((V *)Rv2)[3]=F_it;
          Rv0=1;
        }
        else {
          Ra.sl[6]=197; /* line # 197 */
          if (P_comp_type(((V *)Rv2)[3],V_typ_std.v[10],0,0)||P_comp_type(((V *)
          Rv2)[3],V_typ_std.v[0],1,0)) {
            Ra.sl[6]=200; /* line # 200 */
            if ((((UB *)Rv3)[93]==10&&((UB *)((V *)Rv2)[3])[93]==0)&&P_comp_type((
            (V *)Rv2)[3],F_it, F_exact,0)) {
              Ra.sl[6]=204; /* line # 204 */
              if (((V *)Rv2)[7]!=NULL) Rv4=(C)((SL *)((V *)Rv2)[7])[13];
              else Rv4=32;
              Ra.sl[6]=205; /* line # 205 */
              P_val_free(((V *)Rv2)+7);
              Ra.sl[6]=206; /* line # 206 */
              P_val_new(((V *)Rv2)+7,V_typ_std.v[10]);
              Ra.sl[6]=207; /* line # 207 */
              ((V *)Rv2)[3]=V_typ_std.v[10];
              Ra.sl[6]=208; /* line # 208 */
              Rv5=((V *)Rv2)[7];
              Ra.sl[6]=210; /* line # 210 */
              ((UB *)Rv5)[48]=29;
              Ra.sl[6]=211; /* line # 211 */
              ((SL *)Rv5)[6]=1;
              Ra.sl[6]=212; /* line # 212 */
              ((V *)Rv5)[7]=PAS__NEW(3);
              ((UB *)((V *)Rv5)[7])[0]=1;
              Ra.sl[6]=213; /* line # 213 */
              PAS__CHA_TO_STR(((V *)Rv5)[7],Rv4);
              Ra.sl[6]=215; /* line # 215 */
              Rv0=1;
            }
            else {
              Ra.sl[6]=218; /* line # 218 */
              if (((UB *)Rv3)[93]==8&&((V *)Rv3)[14]==V_typ_std.v[0]) {
                Ra.sl[6]=221; /* line # 221 */
                P_string_in_array(Rv1, F_it);
                Ra.sl[6]=222; /* line # 222 */
                Rv0=1;
              }
              else {
                Ra.sl[6]=225; /* line # 225 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=227; /* line # 227 */
                  P_string_in_substring(Rv1, F_it);
                  Ra.sl[6]=228; /* line # 228 */
                  Rv0=1;
                }
              }
            }
          }
          else {
            Ra.sl[6]=232; /* line # 232 */
            if (((V *)((V *)Rv2)[3])[0]==F_it) Rv0=1;
            else {
              Ra.sl[6]=234; /* line # 234 */
              switch (((UB *)Rv3)[93]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=236; /* line # 236 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=238; /* line # 238 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=239; /* line # 239 */
                    Rv6=((V *)Rv2)[7];
                    Ra.sl[6]=241; /* line # 241 */
                    if (((UB *)Rv3)[112]) {
                      Ra.sl[6]=243; /* line # 243 */
                      if (((UL *)Rv3)[29]<=((UL *)Rv6)[13]&&((UL *)Rv3)[30]>=((UL
                       *)Rv6)[13]) {
                        Ra.sl[6]=244; /* line # 244 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    else {
                      Ra.sl[6]=247; /* line # 247 */
                      if (((SL *)Rv3)[29]<=((SL *)Rv6)[13]&&((SL *)Rv3)[30]>=((SL
                       *)Rv6)[13]) {
                        Ra.sl[6]=248; /* line # 248 */
                        ((V *)Rv2)[3]=F_it;
                        ((V *)Rv6)[4]=F_it;
                        Rv0=1;
                      }
                    }
                    Ra.sl[6]=250; /* line # 250 */
                    if (!Rv0) P_src_error(Rd.s+83,154,2);
                  }
                }
                break;
                case 22:Ra.sl[6]=254; /* line # 254 */
                if (((V *)Rv3)[0]==((V *)Rv2)[3]) {
                  Ra.sl[6]=256; /* line # 256 */
                  if (((V *)Rv2)[7]!=NULL) {
                    Ra.sl[6]=257; /* line # 257 */
                    Rv7=((V *)Rv2)[7];
                    Ra.sl[6]=258; /* line # 258 */
                    if (((SL *)((V *)Rv2)[3])[11]<=((SL *)Rv3)[11]) {
                      Ra.sl[6]=260; /* line # 260 */
                      ((V *)Rv2)[3]=F_it;
                      Ra.sl[6]=261; /* line # 261 */
                      ((V *)Rv7)[4]=F_it;
                      Ra.sl[6]=262; /* line # 262 */
                      if (V_cmp_range&&!F_no_check) {
                        Ra.sl[6]=264; /* line # 264 */
                        Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
                        Ra.sl[6]=266; /* line # 266 */
                        ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,
                        NULL,0);
                        Ra.sl[6]=267; /* line # 267 */
                        ((V *)Rv1)[0]=Rv8;
                        Ra.sl[6]=268; /* line # 268 */
                        Rv1=P_lgt_new_code(2, Rv1);
                        Ra.sl[6]=269; /* line # 269 */
                        ((V *)Rv1)[3]=F_it;
                      }
                      Ra.sl[6]=271; /* line # 271 */
                      Rv0=1;
                    }
                  }
                }
                break;
                case 3:
                case 4:Ra.sl[6]=275; /* line # 275 */
                Rv9=((V *)Rv2)[7];
                Ra.sl[6]=277; /* line # 277 */
                if (((V *)Rv2)[3]!=NULL) {
                  Ra.sl[6]=278; /* line # 278 */
                  switch (((UB *)((V *)Rv2)[3])[93]) {
                    case 2:Ra.sl[6]=279; /* line # 279 */
                    ((G *)Rv9)[7]=(double)((SL *)Rv9)[13];
                    Rv0=1;
                    break;
                    case 3:
                    case 4:Ra.sl[6]=280; /* line # 280 */
                    Rv0=1;
                    break;
                    default:break;
                  }
                }
                Ra.sl[6]=283; /* line # 283 */
                if (Rv0) {
                  Ra.sl[6]=285; /* line # 285 */
                  ((UB *)Rv9)[48]=((UB *)Rv3)[93];
                  Ra.sl[6]=286; /* line # 286 */
                  ((V *)Rv9)[4]=F_it;
                  Ra.sl[6]=287; /* line # 287 */
                  ((V *)Rv2)[3]=F_it;
                }
                break;
                default:break;
              }
            }
          }
        }
      }
      Ra.sl[6]=300; /* line # 300 */
      if (!Rv0) {
        Ra.sl[6]=301; /* line # 301 */
        if (!P_comp_type(((V *)Rv2)[3],F_it, F_exact,0)) {
          Ra.sl[6]=303; /* line # 303 */
          P_src_error(Rd.s+83,109,3);
          Ra.sl[6]=304; /* line # 304 */
          ((V *)Rv1)[3]=F_it;
        }
        else {
          Ra.sl[6]=307; /* line # 307 */
          if (V_cmp_range&&!F_no_check) {
            Ra.sl[6]=308; /* line # 308 */
            switch (((UB *)Rv3)[93]) {
              case 0:
              case 1:
              case 2:Ra.sl[6]=310; /* line # 310 */
              if (V_enm_range) {
                Ra.sl[6]=312; /* line # 312 */
                Rv8=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[29]);
                Ra.sl[6]=313; /* line # 313 */
                ((V *)Rv8)[0]=P_lgt_new_econst(((V *)Rv2)[3],((SL *)Rv3)[30]);
                Ra.sl[6]=314; /* line # 314 */
                ((V *)Rv1)[0]=Rv8;
                Ra.sl[6]=315; /* line # 315 */
                Rv1=P_lgt_new_code(2, Rv1);
                Ra.sl[6]=316; /* line # 316 */
                ((V *)Rv1)[3]=F_it;
              }
              break;
              case 22:Ra.sl[6]=321; /* line # 321 */
              Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
              Ra.sl[6]=322; /* line # 322 */
              ((V *)Rv8)[0]=P_lgt_type_eval(((V *)Rv3)[14],V_curr_descr,NULL,0);
              Ra.sl[6]=323; /* line # 323 */
              ((V *)Rv1)[0]=Rv8;
              Ra.sl[6]=324; /* line # 324 */
              Rv1=P_lgt_new_code(2, Rv1);
              Ra.sl[6]=325; /* line # 325 */
              ((V *)Rv1)[3]=F_it;
              break;
              default:break;
            }
          }
        }
      }
    }
  }
  Ra.sl[6]=331; /* line # 331 */
  if (F_no_def) {
    Ra.sl[6]=332; /* line # 332 */
    if (((UB *)Rv1)[40]==17) P_src_error(Rd.s+83,181,2);
  }
  Ra.sl[6]=333; /* line # 333 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_gennum "  */
SL PAS_COMILER_PRC_00000006(V *F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+87;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=348; /* line # 348 */
  Rv0=PAS_COMILER_PRC_00000005((*F_ty),0,0,0);
  Ra.sl[6]=349; /* line # 349 */
  Rv1=Rv0;
  Ra.sl[6]=351; /* line # 351 */
  (*F_ty)=((V *)Rv1)[3];
  Ra.sl[6]=352; /* line # 352 */
  if (((UB *)Rv1)[40]==14) {
    Ra.sl[6]=353; /* line # 353 */
    Ret=((SL *)((V *)Rv1)[7])[13];
  }
  else {
    Ra.sl[6]=356; /* line # 356 */
    P_src_error(Rd.s+101,853,2);
    Ra.sl[6]=357; /* line # 357 */
    Ret=((SL *)(*F_ty))[29];
  }
  Ra.sl[6]=360; /* line # 360 */
  P_lgt_free_tree(&Rv0);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " attr_type "  */
V PAS_COMILER_PRC_00000007(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.ub[0]=31;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+105;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=385; /* line # 385 */
  Rv0=NULL;
  Ra.sl[16]=386; /* line # 386 */
  Rv1=F_ty;
  Ra.sl[16]=388; /* line # 388 */
  P_insymbol();
  Ra.sl[16]=389; /* line # 389 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[16]=391; /* line # 391 */
    Rv2=P_level_search(V_attr_list);
    Ra.sl[16]=392; /* line # 392 */
    if (Rv2==NULL) P_src_error_s(Rd.s+118,105,3, V_sy_ident.s,NULL);
    else {
      Ra.sl[16]=394; /* line # 394 */
      switch (((UB *)Rv2)[54]) {
        case 0:Ra.sl[16]=402; /* line # 402 */
        if (F_lgt==NULL) P_src_error_s(Rd.s+118,161,3, V_sy_ident.s,NULL);
        Ra.sl[16]=403; /* line # 403 */
        P_lgt_new(&Rv0, V_typ_std.v[13],4, F_lgt);
        Ra.sl[16]=404; /* line # 404 */
        F_lgt=NULL;
        break;
        case 1:Ra.sl[16]=408; /* line # 408 */
        if (((SL *)Rv1)[11]>=0) {
          Ra.sl[16]=409; /* line # 409 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv1)[11]);
        }
        else {
          Ra.sl[16]=412; /* line # 412 */
          Rv0=P_lgt_type_compute(((V *)Rv1)[8],((V *)Rv1)[9],((SL *)Rv1)[11],F_lgt);
          Ra.sl[16]=413; /* line # 413 */
          if (F_lgt!=NULL) {
            Ra.sl[16]=415; /* line # 415 */
            if (((UB *)F_lgt)[40]!=14) F_lgt=NULL;
          }
        }
        break;
        case 8:
        case 9:Ra.sl[16]=421; /* line # 421 */
        if (P_comp_type(F_ty, V_typ_std.v[10],1,0)) F_ty=((V *)((V *)F_ty)[13])[
5];
        Ra.sl[16]=422; /* line # 422 */
        switch (((UB *)F_ty)[93]) {
          case 8:
          case 9:Ra.sl[16]=425; /* line # 425 */
          Rv3=((V *)F_ty)[15];
          Ra.sl[16]=426; /* line # 426 */
          if (((UB *)Rv3)[93]==22) {
            Ra.sl[16]=428; /* line # 428 */
            if (((UB *)Rv2)[54]==8) Rv0=((V *)Rv3)[13];
            else {
              Ra.sl[16]=429; /* line # 429 */
              Rv0=((V *)Rv3)[14];
            }
            Ra.sl[16]=435; /* line # 435 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
            Ra.sl[16]=436; /* line # 436 */
            ((V *)Rv0)[3]=((V *)Rv3)[0];
          }
          else {
            Ra.sl[16]=440; /* line # 440 */
            if (((UB *)Rv2)[54]==8) Rv4=((SL *)Rv3)[29];
            else {
              Ra.sl[16]=441; /* line # 441 */
              Rv4=((SL *)Rv3)[30];
            }
            Ra.sl[16]=442; /* line # 442 */
            Rv0=P_lgt_new_econst(((V *)F_ty)[15],Rv4);
          }
          break;
          default:Ra.sl[16]=445; /* line # 445 */
          P_src_error(Rd.s+118,158,3);
          Ra.sl[16]=446; /* line # 446 */
          Rv0=P_lgt_new_econst(V_typ_std.v[15],1);
          break;
        }
        break;
        case 2:
        case 3:Ra.sl[16]=452; /* line # 452 */
        if (((UB *)Rv1)[93]<=2) {
          Ra.sl[16]=453; /* line # 453 */
          if (((UB *)Rv2)[54]==2) Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[29]);
          else {
            Ra.sl[16]=454; /* line # 454 */
            Rv0=P_lgt_new_econst(F_ty,((SL *)Rv1)[30]);
          }
        }
        else {
          Ra.sl[16]=456; /* line # 456 */
          if (((UB *)Rv1)[93]==22) {
            Ra.sl[16]=458; /* line # 458 */
            if (((UB *)Rv2)[54]==2) Rv0=((V *)Rv1)[13];
            else {
              Ra.sl[16]=459; /* line # 459 */
              Rv0=((V *)Rv1)[14];
            }
            Ra.sl[16]=460; /* line # 460 */
            Rv0=P_lgt_type_compute(NULL,Rv0,1, V_curr_descr);
          }
        }
        break;
        case 4:Ra.sl[16]=464; /* line # 464 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=466; /* line # 466 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=467; /* line # 467 */
          Rv0=P_exp_genop(11, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 5:Ra.sl[16]=471; /* line # 471 */
        if (F_lgt!=NULL) {
          Ra.sl[16]=473; /* line # 473 */
          ((V *)F_lgt)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
          Ra.sl[16]=474; /* line # 474 */
          Rv0=P_exp_genop(12, F_lgt);
          F_lgt=NULL;
        }
        break;
        case 6:Ra.sl[16]=478; /* line # 478 */
        switch (((UB *)Rv1)[93]) {
          case 1:Ra.sl[16]=480; /* line # 480 */
          if (F_lgt==NULL) {
            Ra.sl[16]=482; /* line # 482 */
            Rv0=P_lgt_link(((V *)Rv1)[13]);
          }
          else {
            Ra.sl[16]=485; /* line # 485 */
            P_lgt_new(&Rv0,((V *)V_ima_typ)[14],1, P_lgt_link(((V *)Rv1)[13]));
            Ra.sl[16]=487; /* line # 487 */
            ((V *)((V *)Rv0)[1])[0]=F_lgt;
            Ra.sl[16]=488; /* line # 488 */
            ((V *)F_lgt)[0]=P_lgt_new_econst(V_int_typ,((SL *)((V *)((V *)Rv1)[13]
            )[3])[25]);
          }
          break;
          case 11:
          case 12:Ra.sl[16]=492; /* line # 492 */
          if (((V *)Rv1)[13]!=NULL) {
            Ra.sl[16]=493; /* line # 493 */
            Rv5=((V *)Rv1)[13];
            Ra.sl[16]=494; /* line # 494 */
            if (F_lgt==NULL) {
              Ra.sl[16]=497; /* line # 497 */
              if (((V *)Rv5)[13]==NULL) {
                Ra.sl[16]=498; /* line # 498 */
                Rv0=P_lgt_link(((V *)Rv5)[13]);
              }
            }
          }
          break;
          default:break;
        }
        break;
        case 7:Ra.sl[16]=506; /* line # 506 */
        if (F_ty==V_typ_std.v[7]) Rv4=0;
        else {
          Ra.sl[16]=508; /* line # 508 */
          if (((UB *)Rv1)[93]==7&&((V *)Rv1)[12]!=NULL) Rv4=((SL *)((V *)Rv1)[12]
          )[11];
          else {
            Ra.sl[16]=509; /* line # 509 */
            Rv4=2147483647;
          }
        }
        Ra.sl[16]=510; /* line # 510 */
        Rv0=P_lgt_new_econst(V_typ_std.v[2],Rv4);
        break;
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:Ra.sl[16]=519; /* line # 519 */
        Ra.sl[16]=522; /* line # 522 */
        Ra.ub[1]=0;
        Ra.sl[16]=523; /* line # 523 */
        switch (((UB *)Rv1)[93]) {
          case 3:Ra.sl[16]=524; /* line # 524 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+122,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          case 4:Ra.sl[16]=525; /* line # 525 */
          PAS__VWRITE_INIT(Ra.s,1);
          PAS__WRITE_STR(Rd.s+131,-1,-1,32);
          PAS__WRITE_EOLN();
          break;
          default:break;
        }
        Ra.sl[16]=528; /* line # 528 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_STR(Rd.s+140,-1,-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=529; /* line # 529 */
        Rv6=((V *)Rv2)[0];
        Ra.sl[16]=530; /* line # 530 */
        PAS__VWRITE_INIT(Ra.s,0);
        PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
        PAS__WRITE_EOLN();
        Ra.sl[16]=532; /* line # 532 */
        P_ide_create_name(Ra.s);
        Ra.sl[16]=533; /* line # 533 */
        Rv7=P_lex_search(0);
        Ra.sl[16]=534; /* line # 534 */
        if (Rv7!=NULL) {
          Ra.sl[16]=535; /* line # 535 */
          Rv8=Rv7;
          Ra.sl[16]=536; /* line # 536 */
          if (((UB *)Rv8)[53]==4) {
            Ra.sl[16]=538; /* line # 538 */
            P_lgt_new(&Rv0,((V *)Rv8)[5],14,NULL);
            Ra.sl[16]=539; /* line # 539 */
            Rv9=Rv0;
            Ra.sl[16]=541; /* line # 541 */
            ((V *)Rv9)[7]=((V *)Rv8)[7];
            Ra.sl[16]=542; /* line # 542 */
            P_val_new(((V *)Rv9)+7,((V *)Rv8)[5]);
          }
        }
        Ra.sl[16]=545; /* line # 545 */
        if (Rv0==NULL) {
          Ra.sl[16]=547; /* line # 547 */
          Rv0=P_lgt_new_econst(V_typ_std.v[2],0);
          Ra.sl[16]=548; /* line # 548 */
          P_src_error_s(Rd.s+118,164,2,((V *)Rv2)[0],NULL);
        }
        break;
        case 16:Ra.sl[16]=553; /* line # 553 */
        if (((UB *)Rv1)[93]==11||((UB *)Rv1)[93]==12) {
          Ra.sl[16]=554; /* line # 554 */
          Rv0=P_lgt_new_econst(V_int_typ,((SL *)Rv1)[24]);
        }
        break;
        default:break;
      }
    }
    Ra.sl[16]=558; /* line # 558 */
    P_insymbol();
  }
  else {
    Ra.sl[16]=562; /* line # 562 */
    P_src_error(Rd.s+118,162,2);
  }
  Ra.sl[16]=564; /* line # 564 */
  if (F_lgt!=NULL) P_lgt_free(&F_lgt);
  Ra.sl[16]=565; /* line # 565 */
  if (Rv0!=NULL) Ret=Rv0;
  else {
    Ra.sl[16]=568; /* line # 568 */
    P_src_error(Rd.s+118,169,2);
    Ra.sl[16]=569; /* line # 569 */
    Ret=P_lgt_new_econst(V_typ_std.v[2],1);
  }
  PAS__curr_cntx=Ra.v[5];
  return(Ret);
}


/* Procedure/Function : " build_arg_list "  */
V PAS_COMILER_PRC_00000008(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+148;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=589; /* line # 589 */
  Rv0=F_pr;
  Ra.sl[6]=591; /* line # 591 */
  Rv1=NULL;
  Ra.sl[6]=592; /* line # 592 */
  Rv2=((V *)Rv0)[8];
  Ra.sl[6]=593; /* line # 593 */
  if (((V *)Rv0)[11]!=NULL) {
    Ra.sl[6]=594; /* line # 594 */
    if (!((UB *)((V *)Rv0)[11])[92]) Rv2=((V *)Rv2)[3];
  }
  Ra.sl[6]=595; /* line # 595 */
  if (Rv2!=NULL) {
    Ra.sl[6]=597; /* line # 597 */
    if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+166,22,2);
    else {
      Ra.sl[6]=598; /* line # 598 */
      P_insymbol();
    }
    Ra.sl[6]=599; /* line # 599 */
    while (Rv2!=NULL){
      Ra.sl[6]=601; /* line # 601 */
      if (((UB *)Rv2)[53]==7) {
        Ra.sl[6]=603; /* line # 603 */
        Rv3=0;
        Ra.sl[6]=604; /* line # 604 */
        Rv4=((V *)Rv2)[8];
        Ra.sl[6]=605; /* line # 605 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=607; /* line # 607 */
          Rv5=P_ide_search(928);
          Ra.sl[6]=608; /* line # 608 */
          if (Rv5!=V_ide_udptr.v[5]) {
            Ra.sl[6]=611; /* line # 611 */
            Rv6=Rv5;
            Ra.sl[6]=613; /* line # 613 */
            if (((UB *)Rv6)[53]==5) {
              Ra.sl[6]=615; /* line # 615 */
              Rv7=NULL;
              Ra.sl[6]=616; /* line # 616 */
              if (((V *)Rv6)[5]!=NULL) {
                Ra.sl[6]=617; /* line # 617 */
                Rv8=((V *)Rv6)[5];
                Ra.sl[6]=618; /* line # 618 */
                if (((UB *)Rv8)[93]==6) Rv7=((V *)Rv8)[13];
              }
              Ra.sl[6]=619; /* line # 619 */
              if (Rv7!=NULL) {
                Ra.sl[6]=621; /* line # 621 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=622; /* line # 622 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=624; /* line # 624 */
                    P_src_error_s(Rd.s+166,120,3, V_sy_ident.s,NULL);
                  }
                }
              }
            }
            else {
              Ra.sl[6]=627; /* line # 627 */
              if (((UB *)Rv6)[53]==7) {
                Ra.sl[6]=629; /* line # 629 */
                Rv7=((V *)Rv6)[8];
                Ra.sl[6]=631; /* line # 631 */
                if (((V *)Rv7)[8]!=((V *)Rv4)[8]) {
                  Ra.sl[6]=632; /* line # 632 */
                  if (P_comp_proc_arg(Rv7, Rv4)) Rv3=1;
                  else {
                    Ra.sl[6]=634; /* line # 634 */
                    P_src_error_s(Rd.s+166,121,3, V_sy_ident.s,NULL);
                  }
                }
              }
              else {
                Ra.sl[6]=638; /* line # 638 */
                Rv9=P_compare_proc_argid(((V *)Rv5)[10],((V *)Rv5)[11],Rv4);
                Ra.sl[6]=643; /* line # 643 */
                Rv9=((V *)Rv5)[10];
                Ra.sl[6]=645; /* line # 645 */
                while (Rv9!=NULL&&!Rv3){
                  Ra.sl[6]=646; /* line # 646 */
                  Rv10=Rv9;
                  Ra.sl[6]=648; /* line # 648 */
                  if (!((UB *)Rv10)[8]) {
                    Ra.sl[6]=650; /* line # 650 */
                    Rv7=((V *)Rv10)[2];
                    Ra.sl[6]=651; /* line # 651 */
                    Rv3=P_comp_proc_arg(Rv7, Rv4);
                  }
                  Ra.sl[6]=653; /* line # 653 */
                  Rv9=((V *)Rv10)[0];
                }
                Ra.sl[6]=655; /* line # 655 */
                if (!Rv3) P_src_error_s(Rd.s+166,122,3, V_sy_ident.s,((V *)Rv2)[
0]);
              }
            }
          }
          Ra.sl[6]=658; /* line # 658 */
          P_insymbol();
        }
        else {
          Ra.sl[6]=662; /* line # 662 */
          Rv7=((V *)Rv2)[7];
          Ra.sl[6]=663; /* line # 663 */
          if (Rv7==NULL) P_src_error_s(Rd.s+166,148,3,((V *)Rv2)[0],NULL);
          else {
            Ra.sl[6]=665; /* line # 665 */
            if (Rv4!=NULL) Rv3=P_comp_proc_arg(Rv7, Rv4);
            else {
              Ra.sl[6]=666; /* line # 666 */
              P_src_error_s(Rd.s+166,123,3,((V *)Rv2)[0],NULL);
            }
          }
        }
        Ra.sl[6]=669; /* line # 669 */
        if (Rv3) {
          Ra.sl[6]=671; /* line # 671 */
          P_lgt_new(&Rv11,((V *)Rv7)[11],11,NULL);
          Ra.sl[6]=672; /* line # 672 */
          ((V *)Rv11)[6]=Rv7;
          Ra.sl[6]=673; /* line # 673 */
          if (((V *)Rv7)[11]!=((V *)Rv4)[11]&&((V *)Rv4)[11]!=NULL) {
            Ra.sl[6]=674; /* line # 674 */
            if (!P_comp_type(((V *)Rv7)[11],((V *)Rv4)[11],1,0)) {
              Ra.sl[6]=675; /* line # 675 */
              P_src_error_s(Rd.s+166,124,3,((V *)Rv5)[0],((V *)Rv2)[0]);
            }
          }
        }
      }
      else {
        Ra.sl[6]=680; /* line # 680 */
        Rv11=PAS_COMILER_PRC_00000005(((V *)Rv2)[5],((UB *)Rv2)[86]!=9,0,0);
        Ra.sl[6]=681; /* line # 681 */
        Rv12=Rv11;
        Ra.sl[6]=682; /* line # 682 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=683; /* line # 683 */
          if (((V *)Rv2)[7]==NULL) {
            Ra.sl[6]=685; /* line # 685 */
            P_src_error_s(Rd.s+166,854,3,((V *)Rv2)[0],NULL);
          }
          else {
            Ra.sl[6]=688; /* line # 688 */
            ((UB *)Rv12)[40]=14;
            Ra.sl[6]=689; /* line # 689 */
            ((V *)Rv12)[3]=((V *)Rv2)[5];
            Ra.sl[6]=690; /* line # 690 */
            ((V *)Rv12)[7]=((V *)Rv2)[7];
            Ra.sl[6]=691; /* line # 691 */
            P_val_new(((V *)Rv12)+7,NULL);
            Ra.sl[6]=692; /* line # 692 */
            ((V *)Rv12)[4]=NULL;
          }
        }
      }
      Ra.sl[6]=697; /* line # 697 */
      if (Rv1!=NULL) ((V *)Rv13)[0]=Rv11;
      else {
        Ra.sl[6]=698; /* line # 698 */
        Rv1=Rv11;
      }
      Ra.sl[6]=699; /* line # 699 */
      Rv13=Rv11;
      Ra.sl[6]=701; /* line # 701 */
      Rv2=((V *)Rv2)[3];
      Ra.sl[6]=702; /* line # 702 */
      if (V_sy_sym.ub[0]==17) P_insymbol();
    }
    Ra.sl[6]=704; /* line # 704 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=705; /* line # 705 */
      P_src_error(Rd.s+166,23,3);
    }
  }
  Ra.sl[6]=708; /* line # 708 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_formal_proc "  */
V PAS_COMILER_PRC_00000009(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+170;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=724; /* line # 724 */
  Rv0=F_ip;
  Ra.sl[6]=726; /* line # 726 */
  switch (((UB *)Rv0)[53]) {
    case 7:Ra.sl[6]=728; /* line # 728 */
    Rv1=((V *)F_ip)[8];
    break;
    case 8:Ra.sl[6]=731; /* line # 731 */
    Rv1=((V *)((V *)Rv0)[10])[2];
    break;
    default:Ra.sl[6]=734; /* line # 734 */
    Rv1=NULL;
    break;
  }
  Ra.sl[6]=737; /* line # 737 */
  if (Rv1!=NULL) {
    Ra.sl[6]=738; /* line # 738 */
    Ra.sl[6]=740; /* line # 740 */
    Rv2=PAS_COMILER_PRC_00000008(Rv1);
    Ra.sl[6]=741; /* line # 741 */
    Rv2=P_lgt_new_call(((V *)Rv1)[11],Rv1, Rv2);
    Ra.sl[6]=742; /* line # 742 */
    P_call_setting(&Rv2);
  }
  else {
    Ra.sl[6]=746; /* line # 746 */
    P_src_error(Rd.s+190,998,3);
    Ra.sl[6]=747; /* line # 747 */
    Rv2=NULL;
  }
  Ra.sl[6]=749; /* line # 749 */
  if (Rv2==NULL) {
    Ra.sl[6]=751; /* line # 751 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=753; /* line # 753 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=755; /* line # 755 */
      P_src_error(Rd.s+190,73,3);
      Ra.sl[6]=756; /* line # 756 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=758; /* line # 758 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_indirect_proc "  */
V PAS_COMILER_PRC_00000010(V F_lge){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+194;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=772; /* line # 772 */
  Rv0=NULL;
  Ra.sl[6]=773; /* line # 773 */
  if (F_lge!=NULL) {
    Ra.sl[6]=774; /* line # 774 */
    Rv1=F_lge;
    Rv2=((V *)Rv1)[3];
    Ra.sl[6]=776; /* line # 776 */
    Rv3=((V *)Rv2)[13];
    Ra.sl[6]=777; /* line # 777 */
    if (Rv3!=NULL) {
      Ra.sl[6]=778; /* line # 778 */
      Rv4=Rv3;
      Ra.sl[6]=780; /* line # 780 */
      ((V *)F_lge)[0]=PAS_COMILER_PRC_00000008(Rv3);
      Ra.sl[6]=781; /* line # 781 */
      P_lgt_new(&Rv0,((V *)Rv4)[11],7, F_lge);
      Ra.sl[6]=782; /* line # 782 */
      Rv5=Rv0;
      Ra.sl[6]=784; /* line # 784 */
      if (((V *)Rv4)[11]!=NULL) {
        Ra.sl[6]=786; /* line # 786 */
        if (!((UB *)((V *)Rv4)[11])[92]) {
          Ra.sl[6]=787; /* line # 787 */
          ((UW *)Rv5)[10]=((UW *)Rv5)[10]|4;
        }
      }
      else {
        Ra.sl[6]=789; /* line # 789 */
        ((V *)Rv0)[3]=V_typ_std.v[28];
      }
      Ra.sl[6]=790; /* line # 790 */
      ((V *)Rv5)[6]=Rv3;
    }
  }
  Ra.sl[6]=794; /* line # 794 */
  if (Rv0==NULL) {
    Ra.sl[6]=795; /* line # 795 */
    Rv0=P_lgt_new_econst(V_typ_std.v[21],0);
  }
  Ra.sl[6]=796; /* line # 796 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " call_generic "  */
V PAS_COMILER_PRC_00000011(V F_ip, UB F_bfnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  SL Rv1;
  V Rv2;
  V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+214;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=812; /* line # 812 */
  Rv0=NULL;
  Ra.sl[6]=813; /* line # 813 */
  Rv1=0;
  Ra.sl[6]=814; /* line # 814 */
  Ra.sl[6]=817; /* line # 817 */
  if (V_sy_sym.ub[0]==13) {
    while (1){
      Ra.sl[6]=820; /* line # 820 */
      P_insymbol();
      Ra.sl[6]=821; /* line # 821 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=823; /* line # 823 */
      if (Rv0==NULL) Rv0=Rv2;
      else((V *)Rv3)[0]=Rv2;
      Ra.sl[6]=824; /* line # 824 */
      Rv3=Rv2;
      Ra.sl[6]=825; /* line # 825 */
      Rv1=Rv1+1;
      Ra.sl[6]=826; /* line # 826 */
      if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
        Ra.sl[6]=827; /* line # 827 */
        P_src_error(Rd.s+230,24,2);
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=829; /* line # 829 */
    P_insymbol();
  }
  Ra.sl[6]=831; /* line # 831 */
  Rv2=P_generate_call(F_ip, Rv0, Rv1,0);
  Ra.sl[6]=833; /* line # 833 */
  if (Rv2==NULL) {
    Ra.sl[6]=835; /* line # 835 */
    Rv2=P_lgt_new_idref(V_ide_udptr.v[5],NULL);
  }
  else {
    Ra.sl[6]=837; /* line # 837 */
    if (((V *)Rv2)[3]==NULL&&F_bfnc) {
      Ra.sl[6]=839; /* line # 839 */
      P_src_error(Rd.s+230,73,3);
      Ra.sl[6]=840; /* line # 840 */
      ((V *)Rv2)[3]=V_typ_std.v[21];
    }
  }
  Ra.sl[6]=842; /* line # 842 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " open_call "  */
V PAS_COMILER_PRC_00000012(SL F_ifnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  SL Rv4;
  V Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+234;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=863; /* line # 863 */
  Rv0=NULL;
  Ra.sl[6]=864; /* line # 864 */
  Rv1=P_ide_search_from_nameid(V_iof_std_open);
  Ra.sl[6]=865; /* line # 865 */
  if (Rv1!=NULL) {
    Ra.sl[6]=866; /* line # 866 */
    Ra.sl[6]=868; /* line # 868 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=869; /* line # 869 */
      P_src_error(Rd.s+247,22,2);
    }
    Ra.sl[6]=871; /* line # 871 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[16],0,0,0);
    Ra.sl[6]=873; /* line # 873 */
    Rv3=((V *)((V *)Rv2)[3])[12];
    Ra.sl[6]=874; /* line # 874 */
    if (((V *)Rv2)[3]==V_typ_std.v[7]) {
      Ra.sl[6]=875; /* line # 875 */
      Rv4=0;
    }
    else {
      Ra.sl[6]=878; /* line # 878 */
      if (Rv3!=NULL) Rv4=abs(((SL *)Rv3)[11]);
      Ra.sl[6]=879; /* line # 879 */
      if (Rv4==0) Rv4=1;
    }
    Ra.sl[6]=881; /* line # 881 */
    Rv5=P_lgt_new_econst(V_typ_std.v[2],Rv4);
    Ra.sl[6]=882; /* line # 882 */
    ((V *)Rv2)[0]=Rv5;
    Ra.sl[6]=883; /* line # 883 */
    Rv6=2;
    Ra.sl[6]=885; /* line # 885 */
    switch (F_ifnc) {
      case 1:Ra.sl[6]=886; /* line # 886 */
      Rv7=1;
      break;
      case 2:Ra.sl[6]=887; /* line # 887 */
      Rv7=2;
      break;
      case 3:Ra.sl[6]=888; /* line # 888 */
      Rv7=6;
      break;
      default:Ra.sl[6]=890; /* line # 890 */
      Rv7=0;
      break;
    }
    Ra.sl[6]=892; /* line # 892 */
    if (Rv7!=0) {
      Ra.sl[6]=894; /* line # 894 */
      if (V_sy_sym.ub[0]==17) {
        Ra.sl[6]=896; /* line # 896 */
        P_insymbol();
        Ra.sl[6]=898; /* line # 898 */
        Rv8=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=899; /* line # 899 */
        ((V *)Rv5)[0]=Rv8;
        Ra.sl[6]=900; /* line # 900 */
        Rv5=Rv8;
        Ra.sl[6]=901; /* line # 901 */
        Rv6=Rv6+1;
      }
      Ra.sl[6]=903; /* line # 903 */
      Rv8=P_lgt_new_econst(V_typ_std.v[2],Rv7);
      Ra.sl[6]=904; /* line # 904 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=905; /* line # 905 */
      Rv5=Rv8;
      Ra.sl[6]=906; /* line # 906 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=909; /* line # 909 */
    while (V_sy_sym.ub[0]==17){
      Ra.sl[6]=911; /* line # 911 */
      P_insymbol();
      Ra.sl[6]=912; /* line # 912 */
      Rv8=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=913; /* line # 913 */
      ((V *)Rv5)[0]=Rv8;
      Ra.sl[6]=914; /* line # 914 */
      Rv5=Rv8;
      Ra.sl[6]=915; /* line # 915 */
      Rv6=Rv6+1;
    }
    Ra.sl[6]=917; /* line # 917 */
    Rv9=((V *)Rv1)[10];
    Ra.sl[6]=919; /* line # 919 */
    P_generic_search(((V *)Rv1)[0],Rv6, &Rv9, Rv2);
    Ra.sl[6]=920; /* line # 920 */
    if (Rv9!=NULL) {
      Rv10=Rv9;
      Ra.sl[6]=921; /* line # 921 */
      if (((V *)Rv10)[2]!=NULL) {
        Ra.sl[6]=923; /* line # 923 */
        Rv0=P_lgt_new_call(((V *)((V *)Rv10)[2])[11],((V *)Rv10)[2],Rv2);
        Ra.sl[6]=924; /* line # 924 */
        P_call_setting(&Rv0);
      }
    }
    Ra.sl[6]=927; /* line # 927 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=928; /* line # 928 */
      P_src_error(Rd.s+247,23,2);
    }
  }
  Ra.sl[6]=930; /* line # 930 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " readwrite_call "  */
V PAS_COMILER_PRC_00000013(V F_dfi, V F_psel, V F_pio1, V F_pio2, V F_peoln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+251;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=948; /* line # 948 */
  Rv0=NULL;
  Ra.sl[6]=949; /* line # 949 */
  Rv1=NULL;
  Ra.sl[6]=950; /* line # 950 */
  Rv2=0;
  Ra.sl[6]=951; /* line # 951 */
  V_sy_label_flag=0;
  Ra.sl[6]=953; /* line # 953 */
  Ra.sl[6]=955; /* line # 955 */
  Rv3=F_pio1;
  Ra.sl[6]=956; /* line # 956 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=958; /* line # 958 */
    Rv4=0;
    Ra.sl[6]=959; /* line # 959 */
    Rv5=1;
    Ra.sl[6]=960; /* line # 960 */
    Rv2=1;
    Ra.sl[6]=961; /* line # 961 */
    P_insymbol();
    Ra.sl[6]=962; /* line # 962 */
    Rv6=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=963; /* line # 963 */
    if (F_dfi==NULL) {
      Ra.sl[6]=965; /* line # 965 */
      Rv1=Rv6;
      Ra.sl[6]=966; /* line # 966 */
      Rv7=1;
      Ra.sl[6]=967; /* line # 967 */
      if (V_sy_sym.ub[0]==21) {
        Ra.sl[6]=969; /* line # 969 */
        Rv8=Rv1;
        Ra.sl[6]=970; /* line # 970 */
        while (V_sy_sym.ub[0]==21){
          Ra.sl[6]=972; /* line # 972 */
          P_insymbol();
          Ra.sl[6]=973; /* line # 973 */
          Rv9=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=974; /* line # 974 */
          ((V *)Rv8)[0]=Rv9;
          Ra.sl[6]=975; /* line # 975 */
          Rv8=Rv9;
          Ra.sl[6]=976; /* line # 976 */
          Rv7=Rv7+1;
        }
      }
      Ra.sl[6]=979; /* line # 979 */
      if (V_sy_sym.ub[0]==14) {
        Ra.sl[6]=981; /* line # 981 */
        Rv2=0;
        P_insymbol();
      }
      else {
        Ra.sl[6]=983; /* line # 983 */
        if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
      }
      Ra.sl[6]=984; /* line # 984 */
      Rv5=0;
    }
    else {
      Ra.sl[6]=988; /* line # 988 */
      if (P_comp_type(((V *)Rv6)[3],V_typ_std.v[16],0,0)) {
        Ra.sl[6]=990; /* line # 990 */
        Rv1=Rv6;
        Ra.sl[6]=992; /* line # 992 */
        if (((V *)Rv1)[3]!=V_typ_std.v[7]) Rv3=F_pio2;
        Ra.sl[6]=994; /* line # 994 */
        if (V_sy_sym.ub[0]==14) {
          Ra.sl[6]=995; /* line # 995 */
          Rv2=0;
          P_insymbol();
        }
        else {
          Ra.sl[6]=997; /* line # 997 */
          if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+269,29,2);
        }
        Ra.sl[6]=999; /* line # 999 */
        Rv5=0;
      }
    }
  }
  else {
    Ra.sl[6]=1004; /* line # 1004 */
    if (F_dfi==NULL) P_src_error(Rd.s+269,22,2);
  }
  Ra.sl[6]=1006; /* line # 1006 */
  if (F_psel!=NULL) F_psel=P_ide_search_from_nameid(F_psel);
  Ra.sl[6]=1007; /* line # 1007 */
  if (Rv3!=NULL) Rv3=P_ide_search_from_nameid(Rv3);
  Ra.sl[6]=1008; /* line # 1008 */
  if (F_peoln!=NULL) F_peoln=P_ide_search_from_nameid(F_peoln);
  Ra.sl[6]=1010; /* line # 1010 */
  if (Rv1==NULL) Rv1=P_lgt_new_idref(F_dfi,NULL);
  Ra.sl[6]=1013; /* line # 1013 */
  Rv0=P_exp_genoper(((V *)F_psel)[0],((V *)F_psel)[10],Rv1);
  Ra.sl[6]=1014; /* line # 1014 */
  Rv8=Rv0;
  Ra.sl[6]=1016; /* line # 1016 */
  if (Rv2) {
    Ra.sl[6]=1018; /* line # 1018 */
    while (Rv5||V_sy_sym.ub[0]==17){
      Ra.sl[6]=1020; /* line # 1020 */
      if (!Rv5) {
        Ra.sl[6]=1022; /* line # 1022 */
        P_insymbol();
        Ra.sl[6]=1023; /* line # 1023 */
        Rv6=PAS_COMILER_PRC_00000000();
      }
      else {
        Ra.sl[6]=1025; /* line # 1025 */
        Rv5=0;
      }
      Ra.sl[6]=1026; /* line # 1026 */
      Rv10=NULL;
      Ra.sl[6]=1027; /* line # 1027 */
      Rv7=1;
      Ra.sl[6]=1028; /* line # 1028 */
      while (V_sy_sym.ub[0]==21){
        Ra.sl[6]=1030; /* line # 1030 */
        P_insymbol();
        Ra.sl[6]=1031; /* line # 1031 */
        Rv9=PAS_COMILER_PRC_00000000();
        Ra.sl[6]=1032; /* line # 1032 */
        if (Rv10==NULL) Rv10=Rv9;
        else {
          Ra.sl[6]=1033; /* line # 1033 */
          ((V *)Rv11)[0]=Rv9;
        }
        Ra.sl[6]=1034; /* line # 1034 */
        Rv11=Rv9;
        Ra.sl[6]=1035; /* line # 1035 */
        Rv7=Rv7+1;
      }
      Ra.sl[6]=1037; /* line # 1037 */
      ((V *)Rv6)[0]=Rv10;
      Ra.sl[6]=1038; /* line # 1038 */
      Rv12=((V *)Rv3)[10];
      Ra.sl[6]=1040; /* line # 1040 */
      P_generic_search(((V *)Rv3)[0],Rv7, &Rv12, Rv6);
      Ra.sl[6]=1041; /* line # 1041 */
      if (Rv12!=NULL) {
        Rv13=Rv12;
        Ra.sl[6]=1043; /* line # 1043 */
        if (((V *)Rv13)[2]!=NULL) {
          Ra.sl[6]=1045; /* line # 1045 */
          Rv10=P_lgt_new_call(((V *)((V *)Rv13)[2])[11],((V *)Rv13)[2],Rv6);
          Ra.sl[6]=1046; /* line # 1046 */
          P_call_setting(&Rv10);
        }
        Ra.sl[6]=1048; /* line # 1048 */
        ((V *)Rv8)[0]=Rv10;
        Ra.sl[6]=1049; /* line # 1049 */
        Rv8=Rv10;
      }
    }
    Ra.sl[6]=1052; /* line # 1052 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=1053; /* line # 1053 */
      P_src_error(Rd.s+269,23,2);
    }
  }
  Ra.sl[6]=1057; /* line # 1057 */
  if (F_peoln!=NULL) {
    Ra.sl[6]=1059; /* line # 1059 */
    Rv12=((V *)F_peoln)[10];
    Ra.sl[6]=1061; /* line # 1061 */
    P_generic_search(((V *)F_peoln)[0],0, &Rv12,NULL);
    Ra.sl[6]=1062; /* line # 1062 */
    if (Rv12!=NULL) {
      Rv14=Rv12;
      Ra.sl[6]=1064; /* line # 1064 */
      if (((V *)Rv14)[2]!=NULL) {
        Ra.sl[6]=1066; /* line # 1066 */
        Rv10=P_lgt_new_call(((V *)((V *)Rv14)[2])[11],((V *)Rv14)[2],NULL);
        Ra.sl[6]=1067; /* line # 1067 */
        P_call_setting(&Rv10);
      }
      Ra.sl[6]=1069; /* line # 1069 */
      ((V *)Rv8)[0]=Rv10;
      Ra.sl[6]=1070; /* line # 1070 */
      Rv8=Rv10;
    }
  }
  Ra.sl[6]=1074; /* line # 1074 */
  if (Rv8!=Rv0) {
    Ra.sl[6]=1076; /* line # 1076 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[6]=1077; /* line # 1077 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[6]=1079; /* line # 1079 */
  V_sy_label_flag=1;
  Ra.sl[6]=1080; /* line # 1080 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_state_eff_list "  */
V PAS_COMILER_PRC_00000015(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+273;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1104; /* line # 1104 */
  Rv0=NULL;
  Ra.sl[6]=1105; /* line # 1105 */
  Rv1=NULL;
  Ra.sl[6]=1106; /* line # 1106 */
  Lx[0].sl[0]=0;
  Ra.sl[6]=1107; /* line # 1107 */
  Ra.sl[6]=1109; /* line # 1109 */
  V_sy_sym.ub[0]=21;
  Ra.sl[6]=1110; /* line # 1110 */
  while (V_sy_sym.ub[0]==21){
    Ra.sl[6]=1112; /* line # 1112 */
    P_insymbol();
    Ra.sl[6]=1113; /* line # 1113 */
    Rv2=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=1114; /* line # 1114 */
    if (Rv1==NULL) Rv0=Rv2;
    else {
      Ra.sl[6]=1115; /* line # 1115 */
      ((V *)Rv1)[0]=Rv2;
    }
    Ra.sl[6]=1116; /* line # 1116 */
    Rv1=Rv2;
    Ra.sl[6]=1117; /* line # 1117 */
    Lx[0].sl[0]=Lx[0].sl[0]+1;
  }
  Ra.sl[6]=1120; /* line # 1120 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " user_state_call "  */
V PAS_COMILER_PRC_00000014(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  UB Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  V Rv10;
  V Rv11;
  V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[0];
  Lx[0].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+293;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=1125; /* line # 1125 */
  Rv0=NULL;
  Ra.sl[8]=1126; /* line # 1126 */
  Rv1=NULL;
  Ra.sl[8]=1127; /* line # 1127 */
  Rv2=NULL;
  Ra.sl[8]=1128; /* line # 1128 */
  Rv3=NULL;
  Ra.sl[8]=1129; /* line # 1129 */
  Rv4=0;
  Ra.sl[8]=1130; /* line # 1130 */
  Rv5=0;
  Ra.sl[8]=1131; /* line # 1131 */
  Rv6=0;
  Ra.sl[8]=1132; /* line # 1132 */
  V_sy_label_flag=0;
  Ra.sl[8]=1133; /* line # 1133 */
  Rv7=((V *)F_ip)[7];
  Ra.sl[8]=1134; /* line # 1134 */
  Ra.sl[8]=1136; /* line # 1136 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[8]=1138; /* line # 1138 */
    Rv4=1;
    Ra.sl[8]=1139; /* line # 1139 */
    Rv3=PAS_COMILER_PRC_00000015();
  }
  Ra.sl[8]=1142; /* line # 1142 */
  while (Rv7!=NULL){
    Ra.sl[8]=1143; /* line # 1143 */
    Rv8=Rv7;
    Ra.sl[8]=1146; /* line # 1146 */
    if (((V *)Rv8)[2]==NULL||Rv3==NULL)  break;
    Ra.sl[8]=1148; /* line # 1148 */
    Rv5=P_comp_type(((V *)Rv3)[3],((V *)Rv8)[2],0,0);
    Ra.sl[8]=1149; /* line # 1149 */
    if (Rv5)  break;
    Ra.sl[8]=1151; /* line # 1151 */
    if (((V *)Rv8)[3]!=NULL)  break;
    Ra.sl[8]=1152; /* line # 1152 */
    Rv7=((V *)Rv8)[0];
  }
  Ra.sl[8]=1155; /* line # 1155 */
  if (Rv7==NULL) {
    Ra.sl[8]=1157; /* line # 1157 */
    P_src_error_s(Rd.s+312,41,3,((V *)F_ip)[0],NULL);
    Ra.sl[8]=1158; /* line # 1158 */
    P_skip_symbol(14,0,0);
    Ra.sl[8]=1159; /* line # 1159 */
    Ret=NULL;
  }
  else {
    Ra.sl[8]=1162; /* line # 1162 */
    Rv9=Rv7;
    Ra.sl[8]=1165; /* line # 1165 */
    if (((V *)Rv9)[4]!=NULL) Rv10=P_ide_search_from_nameid(((V *)Rv9)[4]);
    else {
      Ra.sl[8]=1166; /* line # 1166 */
      Rv10=NULL;
    }
    Ra.sl[8]=1167; /* line # 1167 */
    if (((V *)Rv9)[5]!=NULL) Rv11=P_ide_search_from_nameid(((V *)Rv9)[5]);
    else {
      Ra.sl[8]=1168; /* line # 1168 */
      Rv11=NULL;
    }
    Ra.sl[8]=1169; /* line # 1169 */
    if (((V *)Rv9)[6]!=NULL) Rv12=P_ide_search_from_nameid(((V *)Rv9)[6]);
    else {
      Ra.sl[8]=1170; /* line # 1170 */
      Rv12=NULL;
    }
    Ra.sl[8]=1173; /* line # 1173 */
    if (Rv4&&V_sy_sym.ub[0]==14) {
      Ra.sl[8]=1174; /* line # 1174 */
      P_insymbol();
      Rv4=0;
    }
    Ra.sl[8]=1176; /* line # 1176 */
    if (Rv5) {
      Ra.sl[8]=1178; /* line # 1178 */
      Rv2=Rv3;
      Ra.sl[8]=1179; /* line # 1179 */
      Rv13=Rv2;
      Ra.sl[8]=1180; /* line # 1180 */
      Rv3=NULL;
      Ra.sl[8]=1181; /* line # 1181 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+312,29,2);
    }
    else {
      Ra.sl[8]=1184; /* line # 1184 */
      if (((V *)Rv9)[3]!=NULL) {
        Ra.sl[8]=1186; /* line # 1186 */
        Ra.sl[0]=1;
        Ra.sl[8]=1187; /* line # 1187 */
        if (((UB *)Rv9)[8]) {
          ((UB *)Rv9)[8]=0;
          Rv13=((V *)Rv9)[3];
        }
        else {
          Ra.sl[8]=1188; /* line # 1188 */
          Rv13=P_lgt_link(((V *)Rv9)[3]);
        }
      }
      else {
        Ra.sl[8]=1191; /* line # 1191 */
        Ra.sl[0]=0;
        Rv13=NULL;
      }
    }
    Ra.sl[8]=1193; /* line # 1193 */
    if (Rv10!=NULL) {
      Ra.sl[8]=1195; /* line # 1195 */
      Rv0=P_generate_call(Rv10, Rv13, Ra.sl[0],0);
      Ra.sl[8]=1196; /* line # 1196 */
      Rv1=Rv0;
      Ra.sl[8]=1197; /* line # 1197 */
      if (Rv5) Rv6=1;
    }
    Ra.sl[8]=1201; /* line # 1201 */
    if (Rv4) {
      while (1){
        Ra.sl[8]=1205; /* line # 1205 */
        if (Rv3==NULL) Rv3=PAS_COMILER_PRC_00000015();
        Ra.sl[8]=1206; /* line # 1206 */
        if (((UB *)Rv9)[9]) {
          Ra.sl[8]=1208; /* line # 1208 */
          if (Rv5) {
            Ra.sl[8]=1209; /* line # 1209 */
            if (Rv6) Rv13=P_lgt_link(Rv2);
            else {
              Ra.sl[8]=1210; /* line # 1210 */
              Rv6=1;
              Rv13=Rv2;
            }
          }
          else {
            Ra.sl[8]=1212; /* line # 1212 */
            if (((UB *)Rv9)[8]) {
              ((UB *)Rv9)[8]=0;
              Rv13=((V *)Rv9)[3];
            }
            else {
              Ra.sl[8]=1213; /* line # 1213 */
              Rv13=P_lgt_link(((V *)Rv9)[3]);
            }
          }
          Ra.sl[8]=1214; /* line # 1214 */
          ((V *)Rv13)[0]=Rv3;
          Ra.sl[8]=1215; /* line # 1215 */
          Rv3=Rv13;
        }
        Ra.sl[8]=1218; /* line # 1218 */
        Rv13=P_generate_call(Rv11, Rv3, Ra.sl[0],0);
        Ra.sl[8]=1220; /* line # 1220 */
        if (Rv13!=NULL) {
          Ra.sl[8]=1222; /* line # 1222 */
          if (Rv1==NULL) Rv0=Rv13;
          else {
            Ra.sl[8]=1223; /* line # 1223 */
            ((V *)Rv1)[0]=Rv13;
          }
          Ra.sl[8]=1224; /* line # 1224 */
          Rv1=Rv13;
        }
        Ra.sl[8]=1226; /* line # 1226 */
        Rv3=NULL;
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[8]=1229; /* line # 1229 */
      if (V_sy_sym.ub[0]!=14) {
        Ra.sl[8]=1231; /* line # 1231 */
        P_src_error(Rd.s+312,34,3);
        Ra.sl[8]=1232; /* line # 1232 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[8]=1233; /* line # 1233 */
        P_insymbol();
      }
    }
    Ra.sl[8]=1236; /* line # 1236 */
    if (Rv12!=NULL) {
      Ra.sl[8]=1238; /* line # 1238 */
      if (((UB *)Rv9)[9]) {
        Ra.sl[8]=1240; /* line # 1240 */
        Ra.sl[0]=1;
        Ra.sl[8]=1241; /* line # 1241 */
        if (Rv5) {
          Ra.sl[8]=1242; /* line # 1242 */
          if (Rv6) Rv3=P_lgt_link(Rv2);
          else {
            Ra.sl[8]=1243; /* line # 1243 */
            Rv6=1;
            Rv3=Rv2;
          }
        }
        else {
          Ra.sl[8]=1245; /* line # 1245 */
          if (((UB *)Rv9)[8]) {
            ((UB *)Rv9)[8]=0;
            Rv3=((V *)Rv9)[3];
          }
          else {
            Ra.sl[8]=1246; /* line # 1246 */
            Rv3=P_lgt_link(((V *)Rv9)[3]);
          }
        }
      }
      else {
        Ra.sl[8]=1249; /* line # 1249 */
        Ra.sl[0]=0;
        Rv3=NULL;
      }
      Ra.sl[8]=1250; /* line # 1250 */
      Rv13=P_generate_call(Rv12, Rv3, Ra.sl[0],0);
      Ra.sl[8]=1251; /* line # 1251 */
      if (Rv1==NULL) Rv0=Rv13;
      else {
        Ra.sl[8]=1252; /* line # 1252 */
        ((V *)Rv1)[0]=Rv13;
      }
      Ra.sl[8]=1253; /* line # 1253 */
      Rv1=Rv13;
    }
  }
  Ra.sl[8]=1257; /* line # 1257 */
  if (Rv1!=Rv0) {
    Ra.sl[8]=1259; /* line # 1259 */
    P_lgt_new(&Rv0,NULL,0, Rv0);
    Ra.sl[8]=1260; /* line # 1260 */
    ((UB *)Rv0)[41]=2;
  }
  Ra.sl[8]=1263; /* line # 1263 */
  V_sy_label_flag=1;
  Ra.sl[8]=1264; /* line # 1264 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[0]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " new_call "  */
V PAS_COMILER_PRC_00000016(V F_new_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register V Rv8;
  SL Rv9;
  V Rv10;
  V Rv11;
  register V Rv12;
  V Rv13;
  V Rv14;
  register V Rv15;
  V Rv16;
  V Rv17;
  SL Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+316;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1283; /* line # 1283 */
  Rv0=NULL;
  Ra.sl[6]=1284; /* line # 1284 */
  Rv1=NULL;
  Ra.sl[6]=1285; /* line # 1285 */
  Rv2=NULL;
  Ra.sl[6]=1286; /* line # 1286 */
  Rv3=NULL;
  Ra.sl[6]=1287; /* line # 1287 */
  Ra.sl[6]=1289; /* line # 1289 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1290; /* line # 1290 */
    P_src_error(Rd.s+328,22,2);
  }
  Ra.sl[6]=1292; /* line # 1292 */
  Rv4=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1293; /* line # 1293 */
  if (Rv4!=NULL) {
    Ra.sl[6]=1294; /* line # 1294 */
    Rv5=Rv4;
    Ra.sl[6]=1295; /* line # 1295 */
    if (2&((UW *)Rv5)[10]) {
      Ra.sl[6]=1296; /* line # 1296 */
      Rv6=((V *)Rv5)[3];
    }
  }
  Ra.sl[6]=1297; /* line # 1297 */
  if (Rv6!=NULL) {
    Ra.sl[6]=1298; /* line # 1298 */
    Rv7=Rv6;
    Ra.sl[6]=1299; /* line # 1299 */
    if (((UB *)Rv7)[93]==5) Rv3=((V *)Rv7)[12];
    else {
      Ra.sl[6]=1300; /* line # 1300 */
      Rv3=NULL;
    }
  }
  Ra.sl[6]=1302; /* line # 1302 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1303; /* line # 1303 */
    Rv8=Rv3;
    Ra.sl[6]=1305; /* line # 1305 */
    Rv9=((SL *)Rv8)[11];
    Ra.sl[6]=1306; /* line # 1306 */
    if (((V *)Rv8)[4]!=NULL||((UB *)Rv8)[91]) {
      Ra.sl[6]=1312; /* line # 1312 */
      if (((V *)Rv8)[4]!=NULL) {
        Ra.sl[6]=1314; /* line # 1314 */
        Rv10=((V *)Rv8)[4];
        Ra.sl[6]=1315; /* line # 1315 */
        while (Rv10!=NULL){
          Ra.sl[6]=1317; /* line # 1317 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          Ra.sl[6]=1318; /* line # 1318 */
          Rv11=PAS_COMILER_PRC_00000005(((V *)Rv10)[5],0,0,0);
          Ra.sl[6]=1319; /* line # 1319 */
          if (((UB *)Rv11)[40]==17) {
            Ra.sl[6]=1320; /* line # 1320 */
            Rv12=Rv11;
            Ra.sl[6]=1322; /* line # 1322 */
            ((UB *)Rv12)[40]=14;
            Ra.sl[6]=1323; /* line # 1323 */
            ((V *)Rv12)[7]=((V *)Rv10)[10];
            Ra.sl[6]=1324; /* line # 1324 */
            if (((V *)Rv12)[7]==NULL) {
              Ra.sl[6]=1326; /* line # 1326 */
              P_src_error(Rd.s+328,126,3);
            }
            Ra.sl[6]=1327; /* line # 1327 */
            P_val_new(((V *)Rv12)+7,NULL);
            Ra.sl[6]=1328; /* line # 1328 */
            ((V *)Rv12)[4]=NULL;
            Ra.sl[6]=1329; /* line # 1329 */
            ((V *)Rv12)[3]=((V *)Rv10)[5];
          }
          Ra.sl[6]=1332; /* line # 1332 */
          if (((UB *)Rv11)[40]!=14) {
            Ra.sl[6]=1334; /* line # 1334 */
            P_lgt_new(&Rv13,((V *)Rv10)[5],13,NULL);
            Ra.sl[6]=1335; /* line # 1335 */
            ((V *)Rv13)[0]=Rv11;
            Ra.sl[6]=1336; /* line # 1336 */
            P_all_new(((V *)Rv13)+7,((V *)Rv10)[5],NULL,0);
            Ra.sl[6]=1337; /* line # 1337 */
            P_lgt_new(&Rv11,((V *)Rv10)[5],6, Rv13);
            Ra.sl[6]=1338; /* line # 1338 */
            ((UB *)Rv11)[41]=3;
            Ra.sl[6]=1340; /* line # 1340 */
            if (Rv0==NULL) Rv0=Rv11;
            else {
              Ra.sl[6]=1341; /* line # 1341 */
              ((V *)Rv14)[0]=Rv11;
            }
            Ra.sl[6]=1342; /* line # 1342 */
            Rv14=Rv11;
          }
          else {
            Ra.sl[6]=1344; /* line # 1344 */
            Rv13=Rv11;
          }
          Ra.sl[6]=1346; /* line # 1346 */
          Rv15=Rv10;
          Ra.sl[6]=1349; /* line # 1349 */
          ((V *)Rv15)[9]=Rv13;
          Ra.sl[6]=1350; /* line # 1350 */
          ((UB *)Rv15)[60]=2;
          Ra.sl[6]=1352; /* line # 1352 */
          P_lgt_new(&Rv16,((V *)Rv15)[5],2, P_lgt_link(Rv4));
          Ra.sl[6]=1353; /* line # 1353 */
          ((SL *)Rv16)[4]=((SL *)Rv15)[14];
          Ra.sl[6]=1354; /* line # 1354 */
          if (((UB *)Rv13)[40]==14) ((V *)Rv16)[0]=Rv13;
          else {
            Ra.sl[6]=1355; /* line # 1355 */
            ((V *)Rv16)[0]=P_lgt_link(Rv13);
          }
          Ra.sl[6]=1356; /* line # 1356 */
          P_lgt_new(&Rv13,((V *)Rv15)[5],6, Rv16);
          Ra.sl[6]=1357; /* line # 1357 */
          ((UB *)Rv13)[41]=3;
          Ra.sl[6]=1358; /* line # 1358 */
          if (Rv1==NULL) Rv1=Rv13;
          else {
            Ra.sl[6]=1359; /* line # 1359 */
            ((V *)Rv17)[0]=Rv13;
          }
          Ra.sl[6]=1360; /* line # 1360 */
          Rv17=Rv13;
          Ra.sl[6]=1364; /* line # 1364 */
          if (V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=14) {
            Ra.sl[6]=1365; /* line # 1365 */
            P_src_error(Rd.s+328,34,2);
          }
          Ra.sl[6]=1366; /* line # 1366 */
          Rv10=((V *)Rv10)[3];
        }
      }
      Ra.sl[6]=1369; /* line # 1369 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=1370; /* line # 1370 */
        P_src_error(Rd.s+328,24,2);
      }
      Ra.sl[6]=1377; /* line # 1377 */
      Rv11=P_lgt_type_compute(((V *)Rv8)[8],((V *)Rv8)[9],((SL *)Rv8)[11],NULL);
      Ra.sl[6]=1390; /* line # 1390 */
      if (((UB *)Rv8)[91]) P_init_d_dyn(Rv3, Rv4, &Rv1, &Rv17,1,NULL);
      Ra.sl[6]=1392; /* line # 1392 */
      Rv10=((V *)Rv8)[4];
      Ra.sl[6]=1394; /* line # 1394 */
      while (Rv10!=NULL){
        Ra.sl[6]=1396; /* line # 1396 */
        ((UB *)Rv10)[60]=0;
        Ra.sl[6]=1397; /* line # 1397 */
        ((V *)Rv10)[9]=NULL;
        Ra.sl[6]=1398; /* line # 1398 */
        Rv10=((V *)Rv10)[3];
      }
      Ra.sl[6]=1402; /* line # 1402 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1405; /* line # 1405 */
      ((V *)Rv4)[0]=Rv2;
      Ra.sl[6]=1407; /* line # 1407 */
      P_lgt_new(&Rv2, Rv6,6, Rv4);
      Ra.sl[6]=1408; /* line # 1408 */
      ((UB *)Rv2)[41]=3;
      Ra.sl[6]=1411; /* line # 1411 */
      if (Rv0==NULL) Rv0=Rv2;
      else {
        Ra.sl[6]=1412; /* line # 1412 */
        ((V *)Rv14)[0]=Rv2;
      }
      Ra.sl[6]=1413; /* line # 1413 */
      ((V *)Rv2)[0]=Rv1;
      Ra.sl[6]=1414; /* line # 1414 */
      P_lgt_new(&Rv1,NULL,0, Rv0);
      Ra.sl[6]=1415; /* line # 1415 */
      ((UB *)Rv1)[41]=2;
    }
    else {
      Ra.sl[6]=1419; /* line # 1419 */
      Rv9=((SL *)Rv8)[11];
      Ra.sl[6]=1420; /* line # 1420 */
      if (Rv9<=0) P_src_error(Rd.s+328,130,3);
      Ra.sl[6]=1421; /* line # 1421 */
      if (((UB *)Rv8)[93]==10) {
        Ra.sl[6]=1423; /* line # 1423 */
        Rv11=((V *)Rv8)[14];
        Ra.sl[6]=1424; /* line # 1424 */
        if (Rv11!=NULL) {
          Ra.sl[6]=1425; /* line # 1425 */
          if (((UB *)Rv11)[40]==16) Rv11=((V *)Rv11)[1];
        }
        Ra.sl[6]=1426; /* line # 1426 */
        while (V_sy_sym.ub[0]==17&&Rv11!=NULL){
          Ra.sl[6]=1428; /* line # 1428 */
          Rv2=((V *)Rv11)[1];
          Ra.sl[6]=1429; /* line # 1429 */
          Rv16=((V *)Rv2)[0];
          Ra.sl[6]=1430; /* line # 1430 */
          P_insymbol();
          Ra.sl[6]=1432; /* line # 1432 */
          Rv13=PAS_COMILER_PRC_00000005(((V *)((V *)Rv16)[0])[3],0,0,0);
          Ra.sl[6]=1433; /* line # 1433 */
          Rv18=-1;
          Ra.sl[6]=1434; /* line # 1434 */
          Rv19=Rv13;
          Ra.sl[6]=1436; /* line # 1436 */
          if (((UB *)Rv19)[40]==14) {
            Ra.sl[6]=1437; /* line # 1437 */
            Rv18=((SL *)((V *)Rv19)[7])[13];
          }
          else {
            Ra.sl[6]=1439; /* line # 1439 */
            P_src_error(Rd.s+328,181,2);
          }
          Ra.sl[6]=1440; /* line # 1440 */
          P_lgt_free_tree(&Rv13);
          Ra.sl[6]=1442; /* line # 1442 */
          Rv20=Rv2;
          Rv21=((V *)Rv20)[7];
          Ra.sl[6]=1444; /* line # 1444 */
          Rv18=Rv18-((SL *)Rv20)[4];
          Ra.sl[6]=1445; /* line # 1445 */
          if (Rv18>=0&&Rv18<((SL *)Rv21)[6]) {
            Ra.sl[6]=1447; /* line # 1447 */
            Rv18=((SL *)((V *)((V *)Rv2)[7])[7])[Rv18];
            Ra.sl[6]=1448; /* line # 1448 */
            if (Rv18>=0) {
              Ra.sl[6]=1449; /* line # 1449 */
              Rv16=((V *)((V *)Rv16)[0])[0];
            }
            Ra.sl[6]=1450; /* line # 1450 */
            while (Rv18>0&&Rv16!=NULL){
              Ra.sl[6]=1452; /* line # 1452 */
              Rv18=Rv18-1;
              Ra.sl[6]=1453; /* line # 1453 */
              Rv16=((V *)Rv16)[0];
            }
            Ra.sl[6]=1455; /* line # 1455 */
            if (Rv16==NULL) Rv16=((V *)Rv2)[0];
          }
          Ra.sl[6]=1458; /* line # 1458 */
          Rv22=((V *)Rv16)[3];
          Ra.sl[6]=1460; /* line # 1460 */
          Rv11=((V *)Rv22)[14];
          Ra.sl[6]=1461; /* line # 1461 */
          Rv9=((SL *)Rv22)[11];
        }
      }
      Ra.sl[6]=1465; /* line # 1465 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=1466; /* line # 1466 */
        P_src_error(Rd.s+328,23,2);
        Ra.sl[6]=1467; /* line # 1467 */
        P_skip_symbol(14,0,0);
      }
      Ra.sl[6]=1470; /* line # 1470 */
      P_lgt_new(&Rv1, Rv6,6, Rv4);
      Ra.sl[6]=1471; /* line # 1471 */
      ((UB *)Rv1)[41]=3;
      Ra.sl[6]=1472; /* line # 1472 */
      Rv11=P_lgt_new_econst(V_typ_std.v[2],Rv9);
      Ra.sl[6]=1474; /* line # 1474 */
      Rv2=P_lgt_new_call(Rv6, F_new_fnc, Rv11);
      Ra.sl[6]=1475; /* line # 1475 */
      ((V *)Rv4)[0]=Rv2;
    }
  }
  else {
    Ra.sl[6]=1480; /* line # 1480 */
    P_lgt_free_tree(&Rv4);
    Ra.sl[6]=1481; /* line # 1481 */
    P_src_error(Rd.s+328,180,3);
  }
  Ra.sl[6]=1484; /* line # 1484 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " dispose_call "  */
V PAS_COMILER_PRC_00000017(V F_free_fnc){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+332;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1497; /* line # 1497 */
  Ra.sl[6]=1499; /* line # 1499 */
  if (V_sy_sym.ub[0]==13) P_insymbol();
  else {
    Ra.sl[6]=1500; /* line # 1500 */
    P_src_error(Rd.s+348,22,2);
  }
  Ra.sl[6]=1502; /* line # 1502 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[5],0,0,0);
  Ra.sl[6]=1503; /* line # 1503 */
  Rv1=P_lgt_new_call(NULL,F_free_fnc, Rv0);
  Ra.sl[6]=1504; /* line # 1504 */
  if (V_sy_sym.ub[0]==17) P_skip_symbol(14,0,0);
  Ra.sl[6]=1505; /* line # 1505 */
  if (V_sy_sym.ub[0]==14) P_insymbol();
  else {
    Ra.sl[6]=1506; /* line # 1506 */
    P_src_error(Rd.s+348,23,2);
    Ra.sl[6]=1507; /* line # 1507 */
    P_skip_symbol(14,0,0);
  }
  Ra.sl[6]=1510; /* line # 1510 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_set "  */
V PAS_COMILER_PRC_00000018(V F_ty, UB F_bcte){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  SL Rv16;
  SL Rv17;
  UL Rv18;
  register V Rv19;
  register V Rv20;
  SL Rv21;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1530; /* line # 1530 */
  Rv0=1;
  Ra.sl[6]=1531; /* line # 1531 */
  P_insymbol();
  Ra.sl[6]=1532; /* line # 1532 */
  Ra.sl[6]=1533; /* line # 1533 */
  if (V_sy_sym.ub[0]==16) {
    Ra.sl[6]=1535; /* line # 1535 */
    P_lgt_new(&Rv1, V_typ_std.v[19],14,NULL);
    Ra.sl[6]=1536; /* line # 1536 */
    if (F_ty!=NULL) ((V *)Rv1)[3]=F_ty;
    Ra.sl[6]=1537; /* line # 1537 */
    P_val_new(((V *)Rv1)+7,((V *)Rv1)[3]);
    Ra.sl[6]=1538; /* line # 1538 */
    Rv2=((V *)Rv1)[7];
    Ra.sl[6]=1540; /* line # 1540 */
    ((SL *)Rv2)[6]=0;
    Ra.sl[6]=1541; /* line # 1541 */
    ((UL *)Rv2)[13]=0;
  }
  else {
    Ra.sl[6]=1546; /* line # 1546 */
    Rv1=NULL;
    Ra.sl[6]=1547; /* line # 1547 */
    Rv3=NULL;
    Ra.sl[6]=1548; /* line # 1548 */
    Rv4=NULL;
    Ra.sl[6]=1549; /* line # 1549 */
    Rv5=0;
    Ra.sl[6]=1550; /* line # 1550 */
    Rv6=-1;
    Ra.sl[6]=1551; /* line # 1551 */
    Rv7=0;
    for( Rf0=(V_dst_seti-1)+1;Rf0>0;Rf0-- ) {
      Ra.ul[Rv7+7]=0;
      Rv7++;
    }
    Ra.sl[6]=1552; /* line # 1552 */
    Rv8=F_ty;
    Ra.sl[6]=1553; /* line # 1553 */
    Rv9=NULL;
    Ra.sl[6]=1554; /* line # 1554 */
    if (F_ty!=NULL) {
      Ra.sl[6]=1555; /* line # 1555 */
      Rv10=F_ty;
      Ra.sl[6]=1557; /* line # 1557 */
      Rv9=((V *)Rv10)[13];
      Ra.sl[6]=1558; /* line # 1558 */
      Rv11=((SL *)Rv10)[24];
    }
    while (1){
      Ra.sl[6]=1563; /* line # 1563 */
      if (Rv0) Rv0=0;
      else {
        Ra.sl[6]=1564; /* line # 1564 */
        P_insymbol();
      }
      Ra.sl[6]=1566; /* line # 1566 */
      if (Rv9==NULL) {
        Ra.sl[6]=1569; /* line # 1569 */
        Rv12=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
        Ra.sl[6]=1570; /* line # 1570 */
        if (((UB *)Rv12)[40]==17) {
          Ra.sl[6]=1572; /* line # 1572 */
          P_src_error(Rd.s+376,137,2);
          Ra.sl[6]=1573; /* line # 1573 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1577; /* line # 1577 */
          Rv9=((V *)Rv12)[3];
          Ra.sl[6]=1578; /* line # 1578 */
          if (Rv9!=NULL) {
            Ra.sl[6]=1580; /* line # 1580 */
            Rv11=-1;
            Ra.sl[6]=1581; /* line # 1581 */
            while (Rv9!=NULL&&Rv11<0){
              Ra.sl[6]=1582; /* line # 1582 */
              switch (((UB *)Rv9)[93]) {
                case 0:
                case 1:
                case 2:Ra.sl[6]=1583; /* line # 1583 */
                Rv11=((SL *)Rv9)[30];
                break;
                case 22:Ra.sl[6]=1584; /* line # 1584 */
                Rv9=((V *)Rv9)[0];
                break;
                default:Ra.sl[6]=1586; /* line # 1586 */
                P_src_error(Rd.s+376,110,2);
                Ra.sl[6]=1587; /* line # 1587 */
                Rv9=V_typ_std.v[2];
                Ra.sl[6]=1588; /* line # 1588 */
                Rv11=0;
                break;
              }
            }
            Ra.sl[6]=1590; /* line # 1590 */
            if (Rv11<0) P_src_error(Rd.s+376,110,2);
            else {
              Ra.sl[6]=1593; /* line # 1593 */
              if (Rv11>=V_dst_seta) Rv11=V_dst_seta-1;
            }
          }
          Ra.sl[6]=1595; /* line # 1595 */
          if (Rv11<0) Rv9=NULL;
          Ra.sl[6]=1598; /* line # 1598 */
          if (F_ty==NULL&&Rv9!=NULL) {
            Ra.sl[6]=1600; /* line # 1600 */
            if (Rv11<V_dst_setw) P_ide_new_typ(11, &Rv8);
            else {
              Ra.sl[6]=1601; /* line # 1601 */
              P_ide_new_typ(12, &Rv8);
            }
            Ra.sl[6]=1602; /* line # 1602 */
            Rv13=Rv8;
            Ra.sl[6]=1604; /* line # 1604 */
            ((V *)Rv13)[13]=Rv9;
            Ra.sl[6]=1605; /* line # 1605 */
            ((SL *)Rv13)[24]=Rv11+1;
            Ra.sl[6]=1606; /* line # 1606 */
            if (Rv11<V_dst_setw) {
              Ra.sl[6]=1607; /* line # 1607 */
              memcpy(Rv13+48,V_typ_std.v[17]+48,1);
            }
            else {
              Ra.sl[6]=1609; /* line # 1609 */
              memcpy(Rv13+48,V_typ_std.v[18]+48,1);
            }
            Ra.sl[6]=1611; /* line # 1611 */
            Rv14=((((SL *)Rv13)[24]+V_dst_setw)-1)/V_dst_setw;
            Ra.sl[6]=1613; /* line # 1613 */
            ((SL *)Rv13)[11]=(Rv14*V_dst_setw+7)/8;
          }
        }
      }
      else {
        Ra.sl[6]=1619; /* line # 1619 */
        Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
      }
      Ra.sl[6]=1621; /* line # 1621 */
      if (((UB *)Rv12)[40]==14) {
        Ra.sl[6]=1623; /* line # 1623 */
        Rv5=1;
        Ra.sl[6]=1624; /* line # 1624 */
        Rv14=P_lgt_get_econst(Rv12,-1);
        Ra.sl[6]=1625; /* line # 1625 */
        P_lgt_free(&Rv12);
        Ra.sl[6]=1626; /* line # 1626 */
        if (V_sy_sym.ub[0]==20) {
          Ra.sl[6]=1628; /* line # 1628 */
          P_insymbol();
          Ra.sl[6]=1629; /* line # 1629 */
          Rv12=PAS_COMILER_PRC_00000005(Rv9,0,0,0);
          Ra.sl[6]=1630; /* line # 1630 */
          if (((UB *)Rv12)[40]!=14) {
            Ra.sl[6]=1632; /* line # 1632 */
            P_src_error(Rd.s+376,53,2);
            Ra.sl[6]=1633; /* line # 1633 */
            Rv15=Rv14;
          }
          else {
            Ra.sl[6]=1635; /* line # 1635 */
            Rv15=P_lgt_get_econst(Rv12, Rv14);
          }
          Ra.sl[6]=1636; /* line # 1636 */
          P_lgt_free(&Rv12);
        }
        else {
          Ra.sl[6]=1637; /* line # 1637 */
          Rv15=Rv14;
        }
        Ra.sl[6]=1638; /* line # 1638 */
        if (((Rv14<0||Rv14>Rv11)||Rv15<Rv14)||Rv15>Rv11) {
          Ra.sl[6]=1640; /* line # 1640 */
          P_src_error(Rd.s+376,138,2);
          Ra.sl[6]=1641; /* line # 1641 */
          Rv15=Rv14-1;
        }
        Ra.sl[6]=1643; /* line # 1643 */
        Rv16=Rv14;
        for( Rf0=(Rv15+1)-Rv14;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1645; /* line # 1645 */
          if (Rv16>Rv6) Rv6=Rv16;
          Ra.sl[6]=1646; /* line # 1646 */
          Rv17=Rv16/V_dst_setw;
          Ra.sl[6]=1647; /* line # 1647 */
          Rv18=Rv16%V_dst_setw;
          Ra.sl[6]=1648; /* line # 1648 */
          if (1<<Rv18&Ra.ul[Rv17+7]) P_src_error(Rd.s+376,139,2);
          else {
            Ra.sl[6]=1649; /* line # 1649 */
            Ra.ul[Rv17+7]=Ra.ul[Rv17+7]|1<<Rv18;
          }
          Rv16++;
        }
      }
      else {
        Ra.sl[6]=1652; /* line # 1652 */
        if (((UB *)Rv12)[40]!=17) {
          Ra.sl[6]=1654; /* line # 1654 */
          if (F_bcte) P_src_error(Rd.s+376,140,3);
          Ra.sl[6]=1655; /* line # 1655 */
          if (((UB *)Rv8)[92]) {
            Ra.sl[6]=1657; /* line # 1657 */
            Rv12=P_lgt_new_code(16, Rv12);
            Ra.sl[6]=1658; /* line # 1658 */
            ((V *)Rv12)[3]=Rv8;
            Ra.sl[6]=1659; /* line # 1659 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1661; /* line # 1661 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1662; /* line # 1662 */
              Rv1=P_lgt_new_code(14, Rv1);
              Ra.sl[6]=1663; /* line # 1663 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1665; /* line # 1665 */
              Rv1=Rv12;
            }
          }
          else {
            Ra.sl[6]=1669; /* line # 1669 */
            Rv12=P_lgt_new_call(Rv8, V_set_entry_proc, Rv12);
            Ra.sl[6]=1670; /* line # 1670 */
            P_call_setting(&Rv12);
            Ra.sl[6]=1671; /* line # 1671 */
            if (Rv1!=NULL) {
              Ra.sl[6]=1673; /* line # 1673 */
              ((V *)Rv1)[0]=Rv12;
              Ra.sl[6]=1674; /* line # 1674 */
              Rv1=P_exp_genop(11, Rv1);
              Ra.sl[6]=1675; /* line # 1675 */
              ((V *)Rv1)[3]=Rv8;
            }
            else {
              Ra.sl[6]=1677; /* line # 1677 */
              Rv1=Rv12;
            }
          }
        }
        else {
          Ra.sl[6]=1682; /* line # 1682 */
          P_src_error(Rd.s+376,141,2);
          Ra.sl[6]=1683; /* line # 1683 */
          P_lgt_free(&Rv12);
        }
      }
      if (V_sy_sym.ub[0]!=17)  break;
    }
    Ra.sl[6]=1687; /* line # 1687 */
    if (Rv5) {
      Ra.sl[6]=1689; /* line # 1689 */
      if ((Rv1==NULL&&Rv8!=NULL)&&F_ty==NULL) {
        Ra.sl[6]=1690; /* line # 1690 */
        Rv19=Rv8;
        Ra.sl[6]=1692; /* line # 1692 */
        ((SL *)Rv19)[24]=Rv6+1;
        Ra.sl[6]=1693; /* line # 1693 */
        Rv11=Rv6;
        Ra.sl[6]=1694; /* line # 1694 */
        if (Rv6>=V_dst_setw) {
          Ra.sl[6]=1696; /* line # 1696 */
          ((UB *)Rv19)[92]=0;
          Ra.sl[6]=1697; /* line # 1697 */
          ((UB *)Rv19)[93]=12;
          Ra.sl[6]=1698; /* line # 1698 */
          ((SL *)Rv19)[11]=(((((SL *)Rv19)[24]+V_dst_setw)-1)/V_dst_setw)*((SL *)
          V_typ_std.v[17])[11];
          Ra.sl[6]=1700; /* line # 1700 */
          ((UB *)Rv19)[48]=((UB *)V_typ_std.v[18])[48];
        }
        else {
          Ra.sl[6]=1704; /* line # 1704 */
          ((UB *)Rv19)[92]=1;
          Ra.sl[6]=1705; /* line # 1705 */
          ((UB *)Rv19)[93]=11;
          Ra.sl[6]=1706; /* line # 1706 */
          ((SL *)Rv19)[11]=(((SL *)Rv19)[24]+7)/8;
          Ra.sl[6]=1707; /* line # 1707 */
          switch (((SL *)Rv19)[11]) {
            case 1:Ra.sl[6]=1708; /* line # 1708 */
            ((UB *)Rv19)[48]=0;
            break;
            case 2:Ra.sl[6]=1709; /* line # 1709 */
            ((UB *)Rv19)[48]=1;
            break;
            default:Ra.sl[6]=1711; /* line # 1711 */
            ((SL *)Rv19)[11]=4;
            Ra.sl[6]=1712; /* line # 1712 */
            ((UB *)Rv19)[48]=((UB *)V_typ_std.v[17])[48];
            break;
          }
        }
      }
      Ra.sl[6]=1717; /* line # 1717 */
      if (Rv11<V_dst_setw) {
        Ra.sl[6]=1719; /* line # 1719 */
        Rv12=P_lgt_new_econst(Rv8, Ra.sl[7]);
      }
      else {
        Ra.sl[6]=1723; /* line # 1723 */
        P_lgt_new(&Rv12, Rv8,14,NULL);
        Ra.sl[6]=1724; /* line # 1724 */
        P_val_new(((V *)Rv12)+7,Rv8);
        Ra.sl[6]=1725; /* line # 1725 */
        Rv20=((V *)Rv12)[7];
        Ra.sl[6]=1727; /* line # 1727 */
        ((V *)Rv20)[7]=PAS__NEW(32);
        Ra.sl[6]=1728; /* line # 1728 */
        ((SL *)Rv20)[6]=(Rv6+V_dst_setw)/V_dst_setw;
        Ra.sl[6]=1729; /* line # 1729 */
        Rv21=0;
        for( Rf0=(((SL *)Rv20)[6]-1)+1;Rf0>0;Rf0-- ) {
          Ra.sl[6]=1730; /* line # 1730 */
          ((SL *)((V *)Rv20)[7])[Rv21]=Ra.sl[Rv21+7];
          Rv21++;
        }
      }
    }
    Ra.sl[6]=1735; /* line # 1735 */
    if (Rv6>=0) {
      Ra.sl[6]=1736; /* line # 1736 */
      if (Rv1==NULL) {
        Ra.sl[6]=1737; /* line # 1737 */
        Rv1=Rv12;
      }
      else {
        Ra.sl[6]=1740; /* line # 1740 */
        ((V *)Rv12)[0]=Rv1;
        Ra.sl[6]=1741; /* line # 1741 */
        Rv1=P_exp_genop(11, Rv12);
        Ra.sl[6]=1742; /* line # 1742 */
        ((V *)Rv1)[3]=Rv8;
      }
    }
  }
  Ra.sl[6]=1745; /* line # 1745 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_list_agregat_tab "  */
void PAS_COMILER_PRC_00000020(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  SL Rv6;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+380;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1777; /* line # 1777 */
  Ra.sl[6]=1779; /* line # 1779 */
  Rv0=F_ty;
  Ra.sl[6]=1781; /* line # 1781 */
  Rv1=((V *)Rv0)[15];
  Ra.sl[6]=1782; /* line # 1782 */
  Rv2=((V *)Rv0)[14];
  Ra.sl[6]=1785; /* line # 1785 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1786; /* line # 1786 */
    Rv3=Rv1;
    Ra.sl[6]=1787; /* line # 1787 */
    if (((UB *)Rv3)[93]!=22) {
      Ra.sl[6]=1788; /* line # 1788 */
      if (((UB *)Rv3)[112]) {
        Ra.sl[6]=1789; /* line # 1789 */
        Lx[1].sl[0]=(((UL *)Rv3)[30]+1)-((UL *)Rv3)[29];
      }
      else {
        Ra.sl[6]=1791; /* line # 1791 */
        Lx[1].sl[0]=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
    }
    else {
      Ra.sl[6]=1794; /* line # 1794 */
      Rv4=P_lgt_type_eval(((V *)Rv3)[12],NULL,NULL,0);
      Ra.sl[6]=1795; /* line # 1795 */
      if (((UB *)Rv4)[40]==14) {
        Ra.sl[6]=1797; /* line # 1797 */
        Lx[1].sl[0]=((SL *)((V *)Rv4)[7])[13];
        Ra.sl[6]=1798; /* line # 1798 */
        P_lgt_free(&Rv4);
      }
      else {
        Ra.sl[6]=1800; /* line # 1800 */
        P_src_error(Rd.s+404,142,4);
      }
    }
  }
  else {
    Ra.sl[6]=1802; /* line # 1802 */
    Lx[1].sl[0]=0;
  }
  Ra.sl[6]=1803; /* line # 1803 */
  Rv5=F_ty;
  Ra.sl[6]=1804; /* line # 1804 */
  if (((V *)Rv5)[13]!=NULL) {
    Ra.sl[6]=1806; /* line # 1806 */
    Rv4=P_lgt_type_eval(((V *)Rv5)[13],NULL,NULL,0);
    Ra.sl[6]=1807; /* line # 1807 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=1809; /* line # 1809 */
      Lx[1].sl[1]=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=1810; /* line # 1810 */
      P_lgt_free(&Rv4);
    }
    else {
      Ra.sl[6]=1812; /* line # 1812 */
      P_src_error(Rd.s+404,142,4);
    }
  }
  else {
    Ra.sl[6]=1814; /* line # 1814 */
    Lx[1].sl[1]=((SL *)Rv5)[25];
  }
  Ra.sl[6]=1816; /* line # 1816 */
  if (Rv2==NULL) Lx[1].sl[0]=0;
  Ra.sl[6]=1818; /* line # 1818 */
  Rv6=0;
  Ra.sl[6]=1819; /* line # 1819 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1820; /* line # 1820 */
  while (Rv6<Lx[1].sl[0]&&V_sy_sym.ub[0]==17){
    Ra.sl[6]=1822; /* line # 1822 */
    P_insymbol();
    Ra.sl[6]=1823; /* line # 1823 */
    Rv6=Rv6+1;
    Ra.sl[6]=1824; /* line # 1824 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1826; /* line # 1826 */
      Rv4=PAS_COMILER_PRC_00000019(((V *)F_ty)[14]);
    }
    else {
      Ra.sl[6]=1828; /* line # 1828 */
      Rv4=PAS_COMILER_PRC_00000005(((V *)F_ty)[14],0,0,0);
    }
    Ra.sl[6]=1829; /* line # 1829 */
    if (((UB *)Rv4)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1831; /* line # 1831 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv4;
    else {
      Ra.sl[6]=1832; /* line # 1832 */
      ((V *)Lx[1].v[3])[0]=Rv4;
    }
    Ra.sl[6]=1833; /* line # 1833 */
    Lx[1].v[3]=Rv4;
  }
  Ra.sl[6]=1835; /* line # 1835 */
  if (Rv6<Lx[1].sl[0]) {
    Ra.sl[6]=1836; /* line # 1836 */
    P_src_error(Rd.s+404,144,3);
  }
  else {
    Ra.sl[6]=1838; /* line # 1838 */
    if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
      Ra.sl[6]=1840; /* line # 1840 */
      P_src_error(Rd.s+404,146,2);
      Ra.sl[6]=1841; /* line # 1841 */
      P_skip_symbol(Lx[1].ub[32],0,0);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gen_list_agregat_rec "  */
void PAS_COMILER_PRC_00000021(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  SL Rv9;
  register V Rv10;
  SL Rv11;
  V Rv12;
  register V Rv13;
  SL Rv14;
  SL Rv15;
  V Rv16;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+408;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=1860; /* line # 1860 */
  Rv0=F_ty;
  Ra.sl[6]=1862; /* line # 1862 */
  V_sy_sym.ub[0]=17;
  Ra.sl[6]=1863; /* line # 1863 */
  Rv1=((V *)Rv0)[12];
  Ra.sl[6]=1865; /* line # 1865 */
  while (V_sy_sym.ub[0]==17&&Rv1!=NULL){
    Ra.sl[6]=1867; /* line # 1867 */
    P_insymbol();
    Ra.sl[6]=1868; /* line # 1868 */
    if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) {
      Ra.sl[6]=1870; /* line # 1870 */
      Rv2=PAS_COMILER_PRC_00000019(((V *)Rv1)[5]);
    }
    else {
      Ra.sl[6]=1873; /* line # 1873 */
      Rv2=PAS_COMILER_PRC_00000005(((V *)Rv1)[5],0,0,0);
    }
    Ra.sl[6]=1875; /* line # 1875 */
    if (((UB *)Rv2)[40]!=14) Lx[1].ub[8]=0;
    Ra.sl[6]=1877; /* line # 1877 */
    if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
    else {
      Ra.sl[6]=1878; /* line # 1878 */
      ((V *)Lx[1].v[3])[0]=Rv2;
    }
    Ra.sl[6]=1879; /* line # 1879 */
    Lx[1].v[3]=Rv2;
    Ra.sl[6]=1880; /* line # 1880 */
    if (Rv1==((V *)Rv0)[13]) Rv1=NULL;
    else {
      Ra.sl[6]=1881; /* line # 1881 */
      Rv1=((V *)Rv1)[3];
    }
  }
  Ra.sl[6]=1885; /* line # 1885 */
  Rv3=((V *)Rv0)[14];
  Ra.sl[6]=1886; /* line # 1886 */
  if (Rv3!=NULL) {
    Ra.sl[6]=1887; /* line # 1887 */
    if (((UB *)Rv3)[40]==16) Rv3=((V *)Rv3)[1];
  }
  Ra.sl[6]=1889; /* line # 1889 */
  if (Rv3==NULL) {
    Ra.sl[6]=1891; /* line # 1891 */
    if (Rv1!=NULL) {
      Ra.sl[6]=1892; /* line # 1892 */
      P_src_error(Rd.s+432,144,3);
    }
    else {
      Ra.sl[6]=1894; /* line # 1894 */
      if (V_sy_sym.ub[0]!=Lx[1].ub[32]) {
        Ra.sl[6]=1896; /* line # 1896 */
        P_src_error(Rd.s+432,146,2);
        Ra.sl[6]=1897; /* line # 1897 */
        P_skip_symbol(Lx[1].ub[32],0,0);
      }
    }
    Ra.sl[6]=1899; /* line # 1899 */
    goto Ret_Label;
  }
  Ra.sl[6]=1902; /* line # 1902 */
  Rv4=Rv3;
  Ra.sl[6]=1904; /* line # 1904 */
  Rv5=((V *)Rv4)[1];
  Ra.sl[6]=1905; /* line # 1905 */
  Rv6=((V *)Rv5)[0];
  Ra.sl[6]=1906; /* line # 1906 */
  Rv7=((V *)Rv6)[0];
  Ra.sl[6]=1907; /* line # 1907 */
  Rv8=Rv5;
  Ra.sl[6]=1909; /* line # 1909 */
  Rv9=((SL *)Rv8)[4];
  Ra.sl[6]=1910; /* line # 1910 */
  if (((V *)Rv8)[7]!=NULL) {
    Ra.sl[6]=1911; /* line # 1911 */
    Rv10=((V *)Rv8)[7];
    Ra.sl[6]=1913; /* line # 1913 */
    Rv11=(((SL *)Rv10)[6]+Rv9)-1;
    Ra.sl[6]=1914; /* line # 1914 */
    Rv12=((V *)Rv10)[7];
  }
  else {
    Ra.sl[6]=1916; /* line # 1916 */
    Rv12=NULL;
  }
  Ra.sl[6]=1918; /* line # 1918 */
  if (((V *)Rv0)[4]!=NULL) {
    Ra.sl[6]=1920; /* line # 1920 */
    Rv2=P_lgt_type_eval(Rv7,NULL,NULL,0);
    Ra.sl[6]=1921; /* line # 1921 */
    Rv13=Rv2;
    Ra.sl[6]=1922; /* line # 1922 */
    if (((UB *)Rv13)[40]!=14) P_src_error(Rd.s+432,142,3);
    else {
      Ra.sl[6]=1924; /* line # 1924 */
      if (((V *)Rv13)[7]!=NULL) Rv14=((SL *)((V *)Rv13)[7])[13];
      else {
        Ra.sl[6]=1925; /* line # 1925 */
        Rv14=Rv9-1;
      }
    }
    Ra.sl[6]=1926; /* line # 1926 */
    P_lgt_free(&Rv2);
  }
  else {
    Ra.sl[6]=1930; /* line # 1930 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=1931; /* line # 1931 */
      P_src_error(Rd.s+432,29,3);
    }
    Ra.sl[6]=1933; /* line # 1933 */
    Rv14=PAS_COMILER_PRC_00000006(((V *)Rv7)+3);
    Ra.sl[6]=1934; /* line # 1934 */
    if (((V *)Rv7)[4]!=NULL) {
      Ra.sl[6]=1936; /* line # 1936 */
      Rv15=((SL *)((V *)Rv7)[4])[14];
      Ra.sl[6]=1937; /* line # 1937 */
      Rv2=P_lgt_new_econst(((V *)Rv7)[3],Rv14);
      Ra.sl[6]=1939; /* line # 1939 */
      ((SL *)Rv2)[4]=Rv15;
      Ra.sl[6]=1941; /* line # 1941 */
      if (Lx[1].v[2]==NULL) Lx[1].v[2]=Rv2;
      else {
        Ra.sl[6]=1942; /* line # 1942 */
        ((V *)Lx[1].v[3])[0]=Rv2;
      }
      Ra.sl[6]=1943; /* line # 1943 */
      Lx[1].v[3]=Rv2;
    }
  }
  Ra.sl[6]=1947; /* line # 1947 */
  Rv16=((V *)Rv7)[0];
  Ra.sl[6]=1948; /* line # 1948 */
  if (Rv14<Rv9||Rv14>Rv11) {
    Ra.sl[6]=1949; /* line # 1949 */
    Rv16=Rv6;
  }
  else {
    Ra.sl[6]=1952; /* line # 1952 */
    Rv14=((SL *)Rv12)[(Rv14-Rv9)];
    Ra.sl[6]=1953; /* line # 1953 */
    if (Rv14<0) Rv16=Rv6;
    else {
      Ra.sl[6]=1956; /* line # 1956 */
      while (Rv14>0&&Rv16!=NULL){
        Ra.sl[6]=1958; /* line # 1958 */
        Rv16=((V *)Rv16)[0];
        Rv14=Rv14-1;
      }
      Ra.sl[6]=1960; /* line # 1960 */
      if (Rv16==NULL) Rv16=Rv6;
    }
  }
  Ra.sl[6]=1963; /* line # 1963 */
  if (Rv16!=NULL) {
    Ra.sl[6]=1964; /* line # 1964 */
    if (((V *)Rv16)[3]!=NULL) PAS_COMILER_PRC_00000021(((V *)Rv16)[3]);
  }
  Ret_Label: ;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " get_agregate "  */
V PAS_COMILER_PRC_00000019(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  register V Rv12;
  V Rv13;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[1];
  Lx[1].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+436;
  Ra.v[7]=Rd.s+17;
  Ra.sl[16]=1972; /* line # 1972 */
  Rv0=F_ty;
  Ra.sl[16]=1973; /* line # 1973 */
  if (((UB *)Rv0)[93]==11||((UB *)Rv0)[93]==12) {
    Ra.sl[16]=1975; /* line # 1975 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+452,25,2);
    Ra.sl[16]=1976; /* line # 1976 */
    Rv1=PAS_COMILER_PRC_00000018(F_ty,0);
    Ra.sl[16]=1977; /* line # 1977 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[16]=1978; /* line # 1978 */
      P_src_error(Rd.s+452,26,2);
    }
  }
  else {
    Ra.sl[16]=1981; /* line # 1981 */
    if (((UB *)Rv0)[92]) {
      Ra.sl[16]=1982; /* line # 1982 */
      P_src_error(Rd.s+452,131,3);
    }
    else {
      Ra.sl[16]=1985; /* line # 1985 */
      Ra.ub[8]=1;
      Ra.sl[16]=1986; /* line # 1986 */
      Rv1=NULL;
      Ra.sl[16]=1987; /* line # 1987 */
      Ra.v[2]=NULL;
      Ra.sl[16]=1988; /* line # 1988 */
      Ra.v[3]=NULL;
      Ra.sl[16]=1989; /* line # 1989 */
      if (V_sy_sym.ub[0]==13) Ra.ub[32]=14;
      else {
        Ra.sl[16]=1990; /* line # 1990 */
        Ra.ub[32]=16;
      }
      Ra.sl[16]=1991; /* line # 1991 */
      Rv2=((SL *)Rv0)[11];
      Ra.sl[16]=1992; /* line # 1992 */
      Rv3=0;
      Ra.sl[16]=1993; /* line # 1993 */
      V_sy_sym.ub[0]=17;
      Ra.sl[16]=1995; /* line # 1995 */
      if (((V *)Rv0)[4]!=NULL) {
        Ra.sl[16]=1997; /* line # 1997 */
        Rv4=((V *)Rv0)[4];
        Ra.sl[16]=1998; /* line # 1998 */
        if (((UB *)Rv0)[90]) {
          Ra.sl[16]=2001; /* line # 2001 */
          P_type_parm_cte_init(F_ty, Ra.v+2,Ra.v+3,&Rv3);
        }
        else while (1){
          Ra.sl[16]=2031; /* line # 2031 */
          P_insymbol();
          Ra.sl[16]=2032; /* line # 2032 */
          Rv5=Rv4;
          Ra.sl[16]=2034; /* line # 2034 */
          Rv6=((V *)Rv5)[5];
          Ra.sl[16]=2036; /* line # 2036 */
          Rv7=PAS_COMILER_PRC_00000005(Rv6,0,0,0);
          Ra.sl[16]=2037; /* line # 2037 */
          Rv8=Rv7;
          Ra.sl[16]=2039; /* line # 2039 */
          if (((UB *)Rv8)[40]==17) {
            Ra.sl[16]=2041; /* line # 2041 */
            ((UB *)Rv8)[40]=14;
            Ra.sl[16]=2042; /* line # 2042 */
            ((V *)Rv8)[7]=((V *)Rv5)[10];
            Ra.sl[16]=2044; /* line # 2044 */
            if (((V *)Rv8)[7]==NULL) P_src_error_s(Rd.s+452,157,3,((V *)Rv4)[0],
            NULL);
            Ra.sl[16]=2045; /* line # 2045 */
            P_val_new(((V *)Rv8)+7,Rv6);
            Ra.sl[16]=2046; /* line # 2046 */
            ((V *)Rv8)[4]=NULL;
            Ra.sl[16]=2047; /* line # 2047 */
            ((V *)Rv8)[3]=Rv6;
          }
          else {
            Ra.sl[16]=2050; /* line # 2050 */
            if (((UB *)Rv8)[40]!=14) P_src_error(Rd.s+452,132,3);
          }
          Ra.sl[16]=2051; /* line # 2051 */
          ((SL *)Rv8)[4]=((SL *)Rv5)[14];
          Ra.sl[16]=2055; /* line # 2055 */
          ((V *)Rv5)[9]=Rv7;
          Ra.sl[16]=2056; /* line # 2056 */
          ((UB *)Rv5)[60]=1;
          Ra.sl[16]=2058; /* line # 2058 */
          if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
          else {
            Ra.sl[16]=2059; /* line # 2059 */
            ((V *)Ra.v[3])[0]=Rv7;
          }
          Ra.sl[16]=2060; /* line # 2060 */
          Ra.v[3]=Rv7;
          Ra.sl[16]=2062; /* line # 2062 */
          Rv4=((V *)Rv4)[3];
          Ra.sl[16]=2063; /* line # 2063 */
          Rv3=Rv3+1;
          if (Rv4==NULL||V_sy_sym.ub[0]!=17)  break;
        }
      }
      Ra.sl[16]=2069; /* line # 2069 */
      if (((V *)Rv0)[4]!=NULL&&((V *)Rv0)[9]!=NULL) {
        Ra.sl[16]=2071; /* line # 2071 */
        Rv9=P_lgt_type_eval(((V *)Rv0)[9],NULL,NULL,0);
        Ra.sl[16]=2072; /* line # 2072 */
        if (((UB *)Rv9)[40]==14) {
          Ra.sl[16]=2074; /* line # 2074 */
          Rv2=((SL *)((V *)Rv9)[7])[13];
          Ra.sl[16]=2075; /* line # 2075 */
          P_lgt_free(&Rv9);
        }
        else {
          Ra.sl[16]=2076; /* line # 2076 */
          P_src_error(Rd.s+452,142,3);
        }
      }
      Ra.sl[16]=2080; /* line # 2080 */
      if (V_sy_sym.ub[0]!=17) P_src_error(Rd.s+452,29,2);
      Ra.sl[16]=2082; /* line # 2082 */
      switch (((UB *)Rv0)[93]) {
        case 11:
        case 12:Ra.sl[16]=2085; /* line # 2085 */
        if (V_sy_sym.ub[0]==13) P_src_error(Rd.s+452,133,2);
        Ra.sl[16]=2086; /* line # 2086 */
        Rv7=PAS_COMILER_PRC_00000018(F_ty,0);
        Ra.sl[16]=2087; /* line # 2087 */
        if (((UB *)Rv7)[40]!=14) Ra.ub[8]=0;
        Ra.sl[16]=2089; /* line # 2089 */
        if (Ra.v[2]==NULL) Ra.v[2]=Rv7;
        else {
          Ra.sl[16]=2090; /* line # 2090 */
          ((V *)Ra.v[3])[0]=Rv7;
        }
        Ra.sl[16]=2091; /* line # 2091 */
        Ra.v[3]=Rv7;
        break;
        case 10:
        case 23:Ra.sl[16]=2095; /* line # 2095 */
        PAS_COMILER_PRC_00000021(F_ty);
        break;
        case 8:Ra.sl[16]=2098; /* line # 2098 */
        PAS_COMILER_PRC_00000020(F_ty);
        break;
        default:Ra.sl[16]=2101; /* line # 2101 */
        P_src_error(Rd.s+452,131,3);
        Ra.sl[16]=2102; /* line # 2102 */
        P_skip_symbol(Ra.ub[32],0,0);
        break;
      }
      Ra.sl[16]=2105; /* line # 2105 */
      if (V_sy_sym.ub[0]==Ra.ub[32]) P_insymbol();
      else {
        Ra.sl[16]=2106; /* line # 2106 */
        P_src_error(Rd.s+452,26,2);
      }
      Ra.sl[16]=2108; /* line # 2108 */
      if (((V *)Rv0)[4]!=NULL) P_type_parm_cte_release(F_ty);
      Ra.sl[16]=2124; /* line # 2124 */
      if (Ra.ub[8]) {
        Ra.sl[16]=2126; /* line # 2126 */
        P_lgt_new(&Rv1, F_ty,14,NULL);
        Ra.sl[16]=2127; /* line # 2127 */
        switch (((UB *)F_ty)[93]) {
          case 8:
          case 9:
          case 10:Ra.sl[16]=2130; /* line # 2130 */
          P_val_new(((V *)Rv1)+7,F_ty);
          Ra.sl[16]=2131; /* line # 2131 */
          ((V *)((V *)Rv1)[7])[7]=NULL;
          Ra.sl[16]=2132; /* line # 2132 */
          Rv10=NULL;
          Ra.sl[16]=2133; /* line # 2133 */
          Rv11=Rv1;
          Rv12=((V *)Rv11)[7];
          Ra.sl[16]=2135; /* line # 2135 */
          ((SL *)Rv12)[2]=Rv3;
          Ra.sl[16]=2136; /* line # 2136 */
          ((SL *)Rv12)[6]=Rv2;
          Ra.sl[16]=2137; /* line # 2137 */
          while (Ra.v[2]!=NULL){
            Ra.sl[16]=2138; /* line # 2138 */
            Ra.sl[16]=2140; /* line # 2140 */
            Rv7=Ra.v[2];
            Ra.sl[16]=2141; /* line # 2141 */
            Rv13=NULL;
            Ra.sl[16]=2142; /* line # 2142 */
            P_val_copy(((V *)Rv7)+7,&Rv13,1);
            Ra.sl[16]=2143; /* line # 2143 */
            if (Rv10==NULL) ((V *)((V *)Rv1)[7])[7]=Rv13;
            else {
              Ra.sl[16]=2144; /* line # 2144 */
              ((V *)Rv10)[0]=Rv13;
            }
            Ra.sl[16]=2145; /* line # 2145 */
            if (((UB *)F_ty)[93]!=10) {
              Ra.sl[16]=2147; /* line # 2147 */
              if (Rv3>0) Rv3=Rv3-1;
              else {
                Ra.sl[16]=2148; /* line # 2148 */
                if (((UB *)Rv13)[48]==29) ((SL *)Rv13)[6]=Ra.sl[1]-V_stri_stroffset;
                else {
                  Ra.sl[16]=2149; /* line # 2149 */
                  ((SL *)Rv13)[6]=Ra.sl[1];
                }
              }
            }
            Ra.sl[16]=2150; /* line # 2150 */
            Rv10=Rv13;
            Ra.sl[16]=2151; /* line # 2151 */
            Ra.v[2]=((V *)Ra.v[2])[0];
            Ra.sl[16]=2152; /* line # 2152 */
            ((V *)Rv7)[7]=NULL;
            Ra.sl[16]=2153; /* line # 2153 */
            P_lgt_free(&Rv7);
          }
          break;
          default:Ra.sl[16]=2159; /* line # 2159 */
          P_val_copy(((V *)Ra.v[2])+7,((V *)Rv1)+7,1);
          Ra.sl[16]=2160; /* line # 2160 */
          ((SL *)((V *)Rv1)[7])[2]=Rv3;
          break;
        }
      }
      else {
        Ra.sl[16]=2166; /* line # 2166 */
        P_src_error(Rd.s+452,143,3);
        Ra.sl[16]=2167; /* line # 2167 */
        P_lgt_free_tree(Ra.v+2);
        Ra.sl[16]=2168; /* line # 2168 */
        Rv1=P_lgt_new_econst(V_typ_std.v[21],0);
      }
    }
  }
  Ra.sl[16]=2171; /* line # 2171 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[5];
  Lx[1]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " exp_const_set "  */
V PAS_COMILER_PRC_00000022(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+456;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2184; /* line # 2184 */
  Rv0=PAS_COMILER_PRC_00000018(NULL,0);
  Ra.sl[6]=2185; /* line # 2185 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=2186; /* line # 2186 */
    P_src_error(Rd.s+473,26,2);
  }
  Ra.sl[6]=2187; /* line # 2187 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " get_procref "  */
V PAS_COMILER_PRC_00000023(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+477;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2200; /* line # 2200 */
  Rv0=NULL;
  Ra.sl[6]=2201; /* line # 2201 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=2202; /* line # 2202 */
  while (Rv1!=NULL&&Rv0==NULL){
    Ra.sl[6]=2203; /* line # 2203 */
    switch (((UB *)Rv1)[104]) {
      case 6:
      case 9:
      case 10:
      case 11:Ra.sl[6]=2205; /* line # 2205 */
      Rv0=Rv1;
      break;
      case 5:Ra.sl[6]=2207; /* line # 2207 */
      Rv1=((V *)Rv1)[14];
      break;
      default:Ra.sl[6]=2210; /* line # 2210 */
      P_src_error(Rd.s+492,171,3);
      Ra.sl[6]=2211; /* line # 2211 */
      Rv1=NULL;
      break;
    }
  }
  Ra.sl[6]=2213; /* line # 2213 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_generic_ref "  */
V PAS_COMILER_PRC_00000024(V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+496;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2233; /* line # 2233 */
  Rv0=NULL;
  Ra.sl[6]=2234; /* line # 2234 */
  P_insymbol();
  Ra.sl[6]=2235; /* line # 2235 */
  Ra.sl[6]=2236; /* line # 2236 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2238; /* line # 2238 */
    Rv1=P_ide_search(898);
    Ra.sl[6]=2239; /* line # 2239 */
    if (Rv1!=V_ide_udptr.v[1]) {
      Ra.sl[6]=2240; /* line # 2240 */
      Rv2=Rv1;
      Ra.sl[6]=2242; /* line # 2242 */
      P_insymbol();
      Ra.sl[6]=2243; /* line # 2243 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=2244; /* line # 2244 */
        P_src_error(Rd.s+515,26,2);
      }
      Ra.sl[6]=2245; /* line # 2245 */
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[6]=2248; /* line # 2248 */
        Rv3=((V *)Rv2)[10];
        Ra.sl[6]=2249; /* line # 2249 */
        while (Rv3!=NULL&&!P_comp_proc_arg(((V *)Rv3)[2],((V *)F_ty)[13]))
        Rv3=((V *)Rv3)[0];
        Ra.sl[6]=2250; /* line # 2250 */
        if (Rv3==NULL) Rv0=NULL;
        else {
          Ra.sl[6]=2251; /* line # 2251 */
          Rv0=((V *)Rv3)[2];
        }
        Ra.sl[6]=2252; /* line # 2252 */
        if (((SL *)Rv0)[18]>1) P_src_error_s(Rd.s+515,401,2,((V *)Rv2)[0],NULL);
        break;
        case 7:Ra.sl[6]=2256; /* line # 2256 */
        if (P_comp_proc_arg(((V *)Rv2)[8],((V *)F_ty)[13])) Rv0=((V *)Rv2)[8];
        else {
          Ra.sl[6]=2257; /* line # 2257 */
          Rv0=NULL;
        }
        break;
        default:break;
      }
      Ra.sl[6]=2261; /* line # 2261 */
      if (Rv0!=NULL) {
        Ra.sl[6]=2263; /* line # 2263 */
        P_lgt_new(&Rv4, F_ty,10,NULL);
        Ra.sl[6]=2264; /* line # 2264 */
        ((V *)Rv4)[6]=Rv0;
      }
    }
  }
  Ra.sl[6]=2268; /* line # 2268 */
  if (Rv0==NULL) {
    Ra.sl[6]=2270; /* line # 2270 */
    P_src_error(Rd.s+515,402,3);
    Ra.sl[6]=2271; /* line # 2271 */
    Rv4=P_lgt_new_econst(V_typ_std.v[13],0);
  }
  Ra.sl[6]=2273; /* line # 2273 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_identifier "  */
V PAS_COMILER_PRC_00000025(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register UB Rv17;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+519;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2290; /* line # 2290 */
  Ra.sl[6]=2292; /* line # 2292 */
  if (V_sy_sym.ub[0]==77) {
    Ra.sl[6]=2294; /* line # 2294 */
    Rv0=PAS_COMILER_PRC_00000023();
    Ra.sl[6]=2295; /* line # 2295 */
    if (Rv0!=NULL) {
      Ra.sl[6]=2296; /* line # 2296 */
      if (((V *)Rv0)[11]!=NULL) {
        Ra.sl[6]=2297; /* line # 2297 */
        if (!((UB *)((V *)Rv0)[11])[92]) {
          Ra.sl[6]=2299; /* line # 2299 */
          P_insymbol();
          Ra.sl[6]=2300; /* line # 2300 */
          V_lastsymb=V_sy_sym.ub[0];
          Ra.sl[6]=2301; /* line # 2301 */
          V_sy_search=((V *)Rv0)[8];
          Ra.sl[6]=2302; /* line # 2302 */
          V_sy_sym.ub[0]=0;
        }
      }
    }
    Ra.sl[6]=2304; /* line # 2304 */
    if (V_sy_sym.ub[0]==77) {
      Ra.sl[6]=2306; /* line # 2306 */
      P_src_error(Rd.s+537,190,3);
      Ra.sl[6]=2307; /* line # 2307 */
      P_insymbol();
    }
  }
  Ra.sl[6]=2311; /* line # 2311 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2313; /* line # 2313 */
    if (V_sy_search==NULL) {
      Ra.sl[6]=2315; /* line # 2315 */
      Rv1=P_ide_search(1014);
      Ra.sl[6]=2317; /* line # 2317 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=2321; /* line # 2321 */
      Rv1=V_sy_search;
      Ra.sl[6]=2322; /* line # 2322 */
      V_sy_sym.ub[0]=V_lastsymb;
      Ra.sl[6]=2323; /* line # 2323 */
      V_sy_search=NULL;
    }
    Ra.sl[6]=2326; /* line # 2326 */
    if (Rv1!=NULL) {
      Ra.sl[6]=2328; /* line # 2328 */
      Rv2=Rv1;
      Ra.sl[6]=2329; /* line # 2329 */
      switch (((UB *)Rv2)[53]) {
        case 1:Ra.sl[6]=2332; /* line # 2332 */
        if (Rv1==V_ide_udptr.v[1]) {
          Ra.sl[6]=2334; /* line # 2334 */
          Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
        }
        else {
          Ra.sl[6]=2336; /* line # 2336 */
          switch (V_sy_sym.ub[0]) {
            case 24:Ra.sl[6]=2337; /* line # 2337 */
            Rv3=PAS_COMILER_PRC_00000007(NULL,((V *)Rv2)[5]);
            break;
            case 13:Ra.sl[6]=2339; /* line # 2339 */
            if (((V *)Rv2)[10]!=NULL) Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
            else {
              Ra.sl[6]=2340; /* line # 2340 */
              Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[5]);
            }
            break;
            case 15:Ra.sl[6]=2342; /* line # 2342 */
            if (((V *)Rv2)[5]!=NULL) {
              Ra.sl[6]=2343; /* line # 2343 */
              if (((UB *)((V *)Rv2)[5])[93]==6) Rv3=PAS_COMILER_PRC_00000024(((V
               *)Rv2)[5]);
              else {
                Ra.sl[6]=2344; /* line # 2344 */
                Rv3=PAS_COMILER_PRC_00000019(((V *)Rv2)[5]);
              }
            }
            break;
            default:Ra.sl[6]=2346; /* line # 2346 */
            P_src_error(Rd.s+537,36,3);
            break;
          }
        }
        break;
        case 7:
        case 8:Ra.sl[6]=2351; /* line # 2351 */
        Rv3=PAS_COMILER_PRC_00000009(Rv1,1);
        break;
        case 9:Ra.sl[6]=2354; /* line # 2354 */
        Rv3=PAS_COMILER_PRC_00000011(Rv1,1);
        break;
        case 2:Ra.sl[6]=2358; /* line # 2358 */
        switch (((UB *)Rv2)[60]) {
          case 2:Ra.sl[6]=2360; /* line # 2360 */
          if (((V *)Rv2)[10]!=NULL) {
            Ra.sl[6]=2362; /* line # 2362 */
            P_lgt_new(&Rv3,((V *)Rv2)[5],14,NULL);
            Ra.sl[6]=2363; /* line # 2363 */
            Rv4=Rv3;
            Ra.sl[6]=2365; /* line # 2365 */
            ((V *)Rv4)[7]=((V *)Rv2)[10];
            Ra.sl[6]=2366; /* line # 2366 */
            P_val_new(((V *)Rv4)+7,((V *)Rv2)[5]);
          }
          else {
            Ra.sl[6]=2371; /* line # 2371 */
            Rv3=PAS_COMILER_PRC_00000005(((V *)Rv2)[5],0,0,0);
          }
          break;
          case 0:Ra.sl[6]=2375; /* line # 2375 */
          P_lgt_new(&Rv3,((V *)Rv2)[5],13,NULL);
          Ra.sl[6]=2376; /* line # 2376 */
          if (((V *)Rv2)[8]==NULL) ((V *)Rv2)[8]=Rv3;
          Ra.sl[6]=2380; /* line # 2380 */
          ((V *)Rv2)[9]=NULL;
          Ra.sl[6]=2381; /* line # 2381 */
          Rv5=Rv3;
          Ra.sl[6]=2383; /* line # 2383 */
          ((V *)Rv5)[6]=Rv1;
          Ra.sl[6]=2384; /* line # 2384 */
          ((UW *)Rv5)[10]=1;
          break;
          case 3:Ra.sl[6]=2389; /* line # 2389 */
          Rv6=(V_lex_ident_tree.s+V_ident_disp*64);
          Ra.sl[6]=2390; /* line # 2390 */
          if (((UB *)Rv6)[24]==1) {
            Ra.sl[6]=2392; /* line # 2392 */
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            Ra.sl[6]=2393; /* line # 2393 */
            Rv7=Rv3;
            Ra.sl[6]=2395; /* line # 2395 */
            ((V *)Rv7)[3]=((V *)Rv2)[5];
            Ra.sl[6]=2396; /* line # 2396 */
            ((SL *)Rv7)[4]=((SL *)Rv7)[4]+((SL *)Rv2)[14];
          }
          else {
            Ra.sl[6]=2401; /* line # 2401 */
            P_lgt_new_copy(((V *)Rv6)[2],&Rv3);
            Ra.sl[6]=2402; /* line # 2402 */
            P_lgt_new(&Rv3,((V *)Rv2)[5],2, Rv3);
            Ra.sl[6]=2403; /* line # 2403 */
            ((SL *)Rv3)[4]=((SL *)Rv2)[14];
            Ra.sl[6]=2404; /* line # 2404 */
            if (((SL *)Rv6)[13]>=0) {
              Ra.sl[6]=2405; /* line # 2405 */
              ((SL *)Rv6)[13]=((SL *)Rv6)[13]+1;
            }
            else {
              Ra.sl[6]=2407; /* line # 2407 */
              Rv8=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
              Ra.sl[6]=2408; /* line # 2408 */
              ((SL *)Rv8)[13]=((SL *)Rv8)[13]+1;
            }
          }
          break;
          default:break;
        }
        Ra.sl[6]=2413; /* line # 2413 */
        ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2414; /* line # 2414 */
        ((UW *)Rv3)[10]=1;
        break;
        case 5:Ra.sl[6]=2420; /* line # 2420 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=2421; /* line # 2421 */
        Rv9=Rv3;
        Ra.sl[6]=2423; /* line # 2423 */
        if (((SL *)Lx[5].v[13])[18]>=((SL *)Rv2)[12]) {
          Ra.sl[6]=2424; /* line # 2424 */
          ((UW *)Rv2)[42]=((UW *)Rv2)[42]|4;
        }
        Ra.sl[6]=2426; /* line # 2426 */
        switch (((UB *)Rv2)[86]) {
          case 1:
          case 2:
          case 4:
          case 7:Ra.sl[6]=2433; /* line # 2433 */
          if ((((UB *)((V *)Rv2)[5])[90]||((UB *)((V *)Rv2)[5])[91])&&!(16&((UW *)
          Rv2)[42])) {
            Ra.sl[6]=2435; /* line # 2435 */
            P_init_d_varbl(Rv1);
          }
          Ra.sl[6]=2439; /* line # 2439 */
          if (((((UB *)Rv2)[86]==1&&((SL *)Rv2)[12]>1)&&((V *)Rv2)[7]!=NULL)&&!(
8&((UW *)Rv2)[42])) {
            Ra.sl[6]=2443; /* line # 2443 */
            P_initialize_varbl(Rv1);
          }
          break;
          case 11:Ra.sl[6]=2449; /* line # 2449 */
          ((V *)Rv9)[3]=V_typ_std.v[13];
          Ra.sl[6]=2450; /* line # 2450 */
          ((UW *)Rv9)[10]=1;
          break;
          default:break;
        }
        Ra.sl[6]=2457; /* line # 2457 */
        ((V *)Rv3)[4]=Rv1;
        break;
        case 4:Ra.sl[6]=2462; /* line # 2462 */
        Rv3=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=2463; /* line # 2463 */
        ((V *)Rv3)[4]=Rv1;
        break;
        case 6:Ra.sl[6]=2467; /* line # 2467 */
        Rv10=(V_lex_ident_tree.s+V_ident_disp*64);
        Ra.sl[6]=2469; /* line # 2469 */
        P_lgt_new_copy(((V *)Rv10)[2],&Rv3);
        Ra.sl[6]=2470; /* line # 2470 */
        if (((UB *)Rv10)[24]==1) {
          Ra.sl[6]=2472; /* line # 2472 */
          if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
          Ra.sl[6]=2473; /* line # 2473 */
          P_lgt_new(&Rv3,((V *)Rv2)[5],3, Rv3);
          Ra.sl[6]=2474; /* line # 2474 */
          ((SL *)Rv3)[4]=((SL *)Rv2)[14];
        }
        else {
          Ra.sl[6]=2478; /* line # 2478 */
          Rv11=Rv3;
          Ra.sl[6]=2479; /* line # 2479 */
          if (((UB *)((V *)Rv11)[3])[93]==24) {
            Ra.sl[6]=2481; /* line # 2481 */
            Rv12=((V *)((V *)((V *)Rv11)[3])[0])[3];
            Ra.sl[6]=2482; /* line # 2482 */
            ((V *)Rv11)[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv2)[14]);
            Ra.sl[6]=2483; /* line # 2483 */
            if (Rv12!=NULL) {
              Ra.sl[6]=2484; /* line # 2484 */
              Rv3=P_exp_genoper(((V *)Rv12)[0],((V *)Rv12)[10],Rv3);
            }
            else {
              Ra.sl[6]=2486; /* line # 2486 */
              P_src_error(Rd.s+537,998,3);
            }
            Ra.sl[6]=2487; /* line # 2487 */
            ((V *)Rv3)[3]=((V *)Rv2)[5];
          }
          else {
            Ra.sl[6]=2491; /* line # 2491 */
            P_lgt_new(&Rv3,((V *)((V *)Rv3)[3])[12],2, Rv3);
            Ra.sl[6]=2492; /* line # 2492 */
            if (((SL *)((V *)Rv3)[3])[10]>0) V_curr_descr=Rv3;
            Ra.sl[6]=2493; /* line # 2493 */
            Ra.sl[6]=2494; /* line # 2494 */
            P_lgt_new(&Rv3,((V *)Rv2)[5],3, Rv3);
            Ra.sl[6]=2495; /* line # 2495 */
            ((SL *)Rv3)[4]=((SL *)Rv2)[14];
          }
          Ra.sl[6]=2497; /* line # 2497 */
          if (((SL *)Rv10)[13]>=0) {
            Ra.sl[6]=2498; /* line # 2498 */
            ((SL *)Rv10)[13]=((SL *)Rv10)[13]+1;
          }
          else {
            Ra.sl[6]=2500; /* line # 2500 */
            Rv13=(V_lex_ident_tree.s+(V_ident_disp-1)*64);
            Ra.sl[6]=2501; /* line # 2501 */
            ((SL *)Rv13)[13]=((SL *)Rv13)[13]+1;
          }
        }
        Ra.sl[6]=2503; /* line # 2503 */
        Rv14=Rv3;
        Ra.sl[6]=2505; /* line # 2505 */
        ((UW *)Rv14)[10]=((UW *)((V *)Rv10)[2])[10]|4;
        Ra.sl[6]=2506; /* line # 2506 */
        ((V *)Rv14)[4]=Rv1;
        break;
      }
    }
    else {
      Ra.sl[6]=2513; /* line # 2513 */
      P_src_error(Rd.s+537,107,3);
      Ra.sl[6]=2514; /* line # 2514 */
      Rv3=P_lgt_new_econst(V_typ_std.v[21],0);
    }
  }
  else {
    Ra.sl[6]=2519; /* line # 2519 */
    switch (V_sy_sym.ub[0]) {
      case 27:Ra.sl[6]=2520; /* line # 2520 */
      Rv3=P_lgt_new_econst(V_typ_std.v[13],0);
      break;
      case 2:Ra.sl[6]=2521; /* line # 2521 */
      Rv3=P_lgt_new_econst(V_typ_std.v[2],V_sy_ival);
      break;
      case 3:Ra.sl[6]=2524; /* line # 2524 */
      Rv3=P_lgt_new_econst(V_typ_std.v[3],0);
      Ra.sl[6]=2525; /* line # 2525 */
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 4:Ra.sl[6]=2529; /* line # 2529 */
      Rv3=P_lgt_new_econst(V_typ_std.v[4],0);
      Ra.sl[6]=2530; /* line # 2530 */
      ((G *)((V *)Rv3)[7])[7]=V_sy_rval;
      break;
      case 5:Ra.sl[6]=2534; /* line # 2534 */
      Rv3=P_lgt_new_econst(V_typ_std.v[0],(SL)V_sy_string.c[2]);
      Ra.sl[6]=2536; /* line # 2536 */
      if (V_sy_string.ub[1]!=1) {
        Ra.sl[6]=2537; /* line # 2537 */
        Rv15=Rv3;
        Rv16=((V *)Rv15)[7];
        Ra.sl[6]=2540; /* line # 2540 */
        ((V *)Rv15)[3]=V_typ_std.v[10];
        Ra.sl[6]=2541; /* line # 2541 */
        ((UB *)Rv16)[48]=29;
        Ra.sl[6]=2542; /* line # 2542 */
        ((SL *)Rv16)[6]=V_sy_string.ub[1];
        Ra.sl[6]=2543; /* line # 2543 */
        ((V *)Rv16)[4]=((V *)Rv15)[3];
        Ra.sl[6]=2544; /* line # 2544 */
        if (V_sy_string.ub[1]>0) {
          Ra.sl[6]=2546; /* line # 2546 */
          Rv17=V_sy_string.ub[1];
          ((V *)Rv16)[7]=PAS__NEW((SL)Rv17+2);
          ((UB *)((V *)Rv16)[7])[0]=Rv17;
          Ra.sl[6]=2547; /* line # 2547 */
          PAS__STR_TO_STR(((V *)Rv16)[7],V_sy_string.s);
        }
        else {
          Ra.sl[6]=2549; /* line # 2549 */
          ((V *)Rv16)[7]=NULL;
        }
      }
      break;
      default:Ra.sl[6]=2554; /* line # 2554 */
      if (Ri.ub[0]) P_src_error(Rd.s+537,44,2);
      Ra.sl[6]=2555; /* line # 2555 */
      P_lgt_new(&Rv3, V_typ_std.v[21],17,NULL);
      break;
    }
    Ra.sl[6]=2559; /* line # 2559 */
    if (((UB *)Rv3)[40]!=17) P_insymbol();
  }
  Ra.sl[6]=2562; /* line # 2562 */
  Ret=Rv3;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_indir "  */
V PAS_COMILER_PRC_00000026(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+541;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2575; /* line # 2575 */
  Rv0=F_pobj;
  Ra.sl[6]=2576; /* line # 2576 */
  Rv1=((V *)F_pobj)[3];
  Ra.sl[6]=2578; /* line # 2578 */
  switch (((UB *)Rv1)[93]) {
    case 7:Ra.sl[6]=2581; /* line # 2581 */
    ((V *)F_pobj)[3]=V_typ_std.v[13];
    Ra.sl[6]=2582; /* line # 2582 */
    P_lgt_new(&Rv0, V_typ_std.v[13],2, F_pobj);
    Ra.sl[6]=2583; /* line # 2583 */
    Rv2=Rv0;
    ((UW *)Rv2)[10]=((UW *)Rv2)[10]|4;
    Ra.sl[6]=2584; /* line # 2584 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, Rv0);
    break;
    case 5:Ra.sl[6]=2589; /* line # 2589 */
    P_lgt_new(&Rv0,((V *)Rv1)[12],2, F_pobj);
    break;
    case 6:Ra.sl[6]=2595; /* line # 2595 */
    Rv0=PAS_COMILER_PRC_00000010(F_pobj);
    break;
    default:Ra.sl[6]=2599; /* line # 2599 */
    P_src_error(Rd.s+554,151,3);
    break;
  }
  Ra.sl[6]=2601; /* line # 2601 */
  if (((UB *)Rv1)[93]!=6) {
    Ra.sl[6]=2602; /* line # 2602 */
    Rv3=Rv0;
    ((UW *)Rv3)[10]=((UW *)Rv3)[10]|4;
  }
  Ra.sl[6]=2604; /* line # 2604 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_field "  */
V PAS_COMILER_PRC_00000027(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+558;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2620; /* line # 2620 */
  Rv0=0;
  Ra.sl[6]=2621; /* line # 2621 */
  Rv1=NULL;
  Ra.sl[6]=2622; /* line # 2622 */
  Rv2=0;
  Ra.sl[6]=2623; /* line # 2623 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=2625; /* line # 2625 */
    Rv3=F_pobj;
    Rv4=((V *)Rv3)[3];
    Ra.sl[6]=2627; /* line # 2627 */
    if (((V *)Rv4)[4]!=NULL) {
      Ra.sl[6]=2629; /* line # 2629 */
      Rv1=P_level_search(((V *)Rv4)[4]);
      Ra.sl[6]=2630; /* line # 2630 */
      if (Rv1!=NULL) {
        Ra.sl[6]=2631; /* line # 2631 */
        Rv5=Rv1;
        Ra.sl[6]=2633; /* line # 2633 */
        if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
        Ra.sl[6]=2635; /* line # 2635 */
        ((UW *)Rv3)[10]=(((UW *)Rv3)[10]|1)&~2;
        Ra.sl[6]=2636; /* line # 2636 */
        Rv2=((SL *)Rv5)[14];
      }
    }
    Ra.sl[6]=2640; /* line # 2640 */
    if (Rv1==NULL) {
      Ra.sl[6]=2641; /* line # 2641 */
      if (((UB *)Rv4)[93]!=10) {
        Ra.sl[6]=2643; /* line # 2643 */
        F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
        Ra.sl[6]=2644; /* line # 2644 */
        P_src_error(Rd.s+571,152,3);
        Ra.sl[6]=2645; /* line # 2645 */
        Rv0=1;
      }
      else {
        Ra.sl[6]=2649; /* line # 2649 */
        Rv1=P_level_search(((V *)Rv4)[12]);
        Ra.sl[6]=2650; /* line # 2650 */
        if (Rv1!=NULL) {
          Ra.sl[6]=2651; /* line # 2651 */
          Rv6=Rv1;
          Ra.sl[6]=2653; /* line # 2653 */
          if (((UB *)Rv3)[40]!=14) ((V *)Rv3)[4]=Rv1;
          Ra.sl[6]=2654; /* line # 2654 */
          Rv2=((SL *)Rv6)[14];
        }
        else Ra.sl[6]=2657; /* line # 2657 */
      }
    }
    Ra.sl[6]=2659; /* line # 2659 */
    if (Rv1!=NULL) {
      Ra.sl[6]=2660; /* line # 2660 */
      Rv7=Rv1;
      Ra.sl[6]=2662; /* line # 2662 */
      if (Rv2!=0&&V_curr_descr==F_pobj) {
        Ra.sl[6]=2663; /* line # 2663 */
        if (((UB *)Rv3)[40]==14) {
          P_lgt_new_copy(F_pobj, &F_pobj);
          ((V *)F_pobj)[3]=((V *)Rv7)[5];
        }
        else {
          Ra.sl[6]=2665; /* line # 2665 */
          P_lgt_new(&F_pobj,((V *)Rv7)[5],3, F_pobj);
          Ra.sl[6]=2666; /* line # 2666 */
          ((UW *)F_pobj)[10]=((UW *)((V *)F_pobj)[1])[10];
        }
      }
      else {
        Ra.sl[6]=2669; /* line # 2669 */
        Rv2=((SL *)Rv3)[4]+Rv2;
        ((V *)Rv3)[3]=((V *)Rv7)[5];
      }
      Ra.sl[6]=2670; /* line # 2670 */
      ((SL *)F_pobj)[4]=((SL *)Rv3)[4]+Rv2;
    }
    else {
      Ra.sl[6]=2674; /* line # 2674 */
      F_pobj=P_lgt_new_econst(V_typ_std.v[21],0);
      Ra.sl[6]=2675; /* line # 2675 */
      P_src_error_s(Rd.s+571,153,2, V_sy_ident.s,NULL);
      Ra.sl[6]=2676; /* line # 2676 */
      Rv0=1;
    }
    Ra.sl[6]=2679; /* line # 2679 */
    P_insymbol();
  }
  else {
    Ra.sl[6]=2683; /* line # 2683 */
    P_src_error(Rd.s+571,156,3);
    Ra.sl[6]=2684; /* line # 2684 */
    Rv0=1;
  }
  Ra.sl[6]=2687; /* line # 2687 */
  Rv8=F_pobj;
  Ra.sl[6]=2688; /* line # 2688 */
  if (Rv0) ((V *)Rv8)[3]=V_typ_std.v[21];
  else {
    Ra.sl[6]=2691; /* line # 2691 */
    ((SL *)Rv8)[4]=Rv2;
    Ra.sl[6]=2692; /* line # 2692 */
    ((UW *)Rv8)[10]=((UW *)Rv8)[10]|4;
    Ra.sl[6]=2693; /* line # 2693 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=2694; /* line # 2694 */
      if (((V *)Rv8)[3]!=NULL) {
        Ra.sl[6]=2695; /* line # 2695 */
        if (((UB *)((V *)Rv8)[3])[92]) P_lgt_extract_simple_cte(F_pobj);
      }
    }
  }
  Ra.sl[6]=2698; /* line # 2698 */
  Ret=F_pobj;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_index "  */
V PAS_COMILER_PRC_00000028(V F_pobj){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  SL Rv5;
  V Rv6;
  V Rv7;
  V Rv8;
  register V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+575;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2712; /* line # 2712 */
  Rv0=F_pobj;
  Ra.sl[6]=2715; /* line # 2715 */
  if (P_comp_type(((V *)F_pobj)[3],V_typ_std.v[10],1,0)) {
    Ra.sl[6]=2717; /* line # 2717 */
    V_curr_descr=F_pobj;
    Ra.sl[6]=2718; /* line # 2718 */
    P_lgt_new(&Rv0,((V *)((V *)V_typ_std.v[10])[13])[5],3, F_pobj);
    Ra.sl[6]=2719; /* line # 2719 */
    ((SL *)Rv0)[4]=((SL *)((V *)V_typ_std.v[10])[13])[14];
  }
  else {
    Ra.sl[6]=2722; /* line # 2722 */
    Rv1=F_pobj;
    Ra.sl[6]=2723; /* line # 2723 */
    if (((SL *)((V *)F_pobj)[3])[10]>0) {
      Ra.sl[6]=2725; /* line # 2725 */
      V_curr_descr=F_pobj;
      Ra.sl[6]=2726; /* line # 2726 */
      P_lgt_new(&Rv0,((V *)F_pobj)[3],3, F_pobj);
      Ra.sl[6]=2727; /* line # 2727 */
      ((SL *)Rv0)[4]=((SL *)F_pobj)[4]+((SL *)((V *)F_pobj)[3])[10];
    }
    else {
      Ra.sl[6]=2729; /* line # 2729 */
      Rv0=F_pobj;
    }
  }
  Ra.sl[6]=2731; /* line # 2731 */
  Rv2=Rv0;
  Ra.sl[6]=2733; /* line # 2733 */
  Rv3=((V *)Rv2)[3];
  Ra.sl[6]=2734; /* line # 2734 */
  if (((UB *)Rv3)[93]==8||((UB *)Rv3)[93]==9) {
    Ra.sl[6]=2737; /* line # 2737 */
    Rv4=PAS_COMILER_PRC_00000005(((V *)Rv3)[15],0,0,0);
    Ra.sl[6]=2738; /* line # 2738 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=2740; /* line # 2740 */
      Rv5=((SL *)((V *)Rv4)[7])[13];
      Ra.sl[6]=2741; /* line # 2741 */
      P_lgt_free(&Rv4);
    }
    Ra.sl[6]=2743; /* line # 2743 */
    Rv6=NULL;
    Ra.sl[6]=2744; /* line # 2744 */
    Rv7=NULL;
    Ra.sl[6]=2745; /* line # 2745 */
    Rv8=NULL;
    Ra.sl[6]=2747; /* line # 2747 */
    Rv9=((V *)Rv3)[15];
    Ra.sl[6]=2748; /* line # 2748 */
    if (((UB *)Rv9)[93]==22) {
      Ra.sl[6]=2749; /* line # 2749 */
      if (((UB *)((V *)Rv9)[13])[40]==14) {
        Ra.sl[6]=2751; /* line # 2751 */
        Rv10=((SL *)((V *)((V *)Rv9)[13])[7])[13];
        Ra.sl[6]=2752; /* line # 2752 */
        Rv7=((V *)Rv9)[14];
      }
      else {
        Ra.sl[6]=2756; /* line # 2756 */
        Rv6=P_lgt_type_eval(((V *)Rv9)[13],V_curr_descr,NULL,0);
        Ra.sl[6]=2763; /* line # 2763 */
        if (((UB *)((V *)Rv9)[14])[40]==14) {
          Ra.sl[6]=2765; /* line # 2765 */
          Rv11=((SL *)((V *)((V *)Rv9)[14])[7])[13];
          Ra.sl[6]=2766; /* line # 2766 */
          Rv7=((V *)Rv9)[14];
        }
      }
    }
    else {
      Ra.sl[6]=2771; /* line # 2771 */
      Rv10=((SL *)Rv9)[29];
      Ra.sl[6]=2772; /* line # 2772 */
      Rv11=((SL *)Rv9)[30];
    }
    Ra.sl[6]=2775; /* line # 2775 */
    if (((SL *)Rv3)[25]>0) Rv12=((SL *)Rv3)[25];
    else {
      Ra.sl[6]=2778; /* line # 2778 */
      Rv8=P_lgt_type_eval(((V *)Rv3)[13],V_curr_descr,NULL,0);
      Ra.sl[6]=2779; /* line # 2779 */
      if (Rv8!=NULL) {
        Ra.sl[6]=2780; /* line # 2780 */
        Rv13=Rv8;
        Ra.sl[6]=2781; /* line # 2781 */
        if (((UB *)Rv13)[40]==14) {
          Ra.sl[6]=2783; /* line # 2783 */
          Rv12=((SL *)((V *)Rv13)[7])[13];
          Ra.sl[6]=2784; /* line # 2784 */
          P_lgt_free(&Rv8);
        }
      }
    }
    Ra.sl[6]=2788; /* line # 2788 */
    if (Rv4==NULL&&Rv6==NULL) {
      Ra.sl[6]=2790; /* line # 2790 */
      if (Rv5<Rv10||Rv7==NULL&&Rv5>Rv11) {
        Ra.sl[6]=2791; /* line # 2791 */
        P_src_error(Rd.s+588,154,2);
      }
      Ra.sl[6]=2792; /* line # 2792 */
      Rv5=Rv5-Rv10;
      Ra.sl[6]=2793; /* line # 2793 */
      if (Rv8==NULL) {
        Ra.sl[6]=2795; /* line # 2795 */
        Rv14=Rv0;
        Ra.sl[6]=2796; /* line # 2796 */
        ((SL *)Rv14)[4]=((SL *)Rv2)[4]+Rv5*Rv12;
        Ra.sl[6]=2797; /* line # 2797 */
        ((V *)Rv14)[3]=((V *)Rv3)[14];
      }
      else {
        Ra.sl[6]=2801; /* line # 2801 */
        Rv4=P_lgt_new_econst(V_int_typ, Rv5);
        Ra.sl[6]=2802; /* line # 2802 */
        ((V *)Rv0)[0]=Rv4;
        Ra.sl[6]=2803; /* line # 2803 */
        ((V *)Rv4)[0]=Rv8;
        Ra.sl[6]=2804; /* line # 2804 */
        P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
        Ra.sl[6]=2805; /* line # 2805 */
        ((UW *)Rv14)[10]=((UW *)Rv0)[10];
        Ra.sl[6]=2806; /* line # 2806 */
        ((V *)Rv14)[6]=((V *)Rv2)[3];
      }
    }
    else {
      Ra.sl[6]=2811; /* line # 2811 */
      P_lgt_new(&Rv14,((V *)Rv3)[14],1, Rv0);
      Ra.sl[6]=2812; /* line # 2812 */
      ((V *)Rv14)[6]=((V *)Rv2)[3];
      Ra.sl[6]=2813; /* line # 2813 */
      if (Rv8==NULL) {
        Ra.sl[6]=2815; /* line # 2815 */
        if (Rv4==NULL) {
          Ra.sl[6]=2817; /* line # 2817 */
          Rv4=P_lgt_new_code(46, Rv6);
          Ra.sl[6]=2818; /* line # 2818 */
          ((SL *)Rv14)[4]=Rv5*Rv12;
        }
        else {
          Ra.sl[6]=2822; /* line # 2822 */
          if (Rv6==NULL) {
            Ra.sl[6]=2823; /* line # 2823 */
            ((SL *)Rv14)[4]= -Rv10*Rv12;
          }
          else {
            Ra.sl[6]=2827; /* line # 2827 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2828; /* line # 2828 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2831; /* line # 2831 */
        ((V *)Rv4)[0]=P_lgt_new_econst(V_int_typ, Rv12);
      }
      else {
        Ra.sl[6]=2835; /* line # 2835 */
        if (Rv4==NULL) {
          Ra.sl[6]=2837; /* line # 2837 */
          if (Rv5!=0) {
            Ra.sl[6]=2838; /* line # 2838 */
            Rv4=P_lgt_new_econst(V_int_typ, Rv5);
          }
        }
        else {
          Ra.sl[6]=2841; /* line # 2841 */
          if (Rv6==NULL) {
            Ra.sl[6]=2842; /* line # 2842 */
            if (Rv10!=0) {
              Ra.sl[6]=2843; /* line # 2843 */
              Rv6=P_lgt_new_econst(V_int_typ, Rv10);
            }
          }
        }
        Ra.sl[6]=2845; /* line # 2845 */
        if (Rv4==NULL) {
          Ra.sl[6]=2846; /* line # 2846 */
          Rv4=P_lgt_new_code(46, Rv4);
        }
        else {
          Ra.sl[6]=2848; /* line # 2848 */
          if (Rv6!=NULL) {
            Ra.sl[6]=2850; /* line # 2850 */
            ((V *)Rv4)[0]=Rv6;
            Ra.sl[6]=2851; /* line # 2851 */
            Rv4=P_lgt_new_code(50, Rv4);
          }
        }
        Ra.sl[6]=2853; /* line # 2853 */
        ((V *)Rv4)[0]=Rv8;
      }
      Ra.sl[6]=2855; /* line # 2855 */
      ((V *)Rv0)[0]=Rv4;
    }
  }
  else {
    Ra.sl[6]=2860; /* line # 2860 */
    P_src_error(Rd.s+588,155,3);
    Ra.sl[6]=2861; /* line # 2861 */
    ((V *)Rv2)[3]=V_typ_std.v[21];
    Ra.sl[6]=2862; /* line # 2862 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=2863; /* line # 2863 */
    Rv14=F_pobj;
    Ra.sl[6]=2864; /* line # 2864 */
    P_skip_symbol(16,0,0);
  }
  Ra.sl[6]=2867; /* line # 2867 */
  Rv15=Rv14;
  Ra.sl[6]=2878; /* line # 2878 */
  ((UW *)Rv15)[10]=((UW *)Rv15)[10]|4;
  Ra.sl[6]=2879; /* line # 2879 */
  if (((UB *)Rv15)[40]==14) {
    Ra.sl[6]=2880; /* line # 2880 */
    if (((V *)Rv15)[3]!=NULL) {
      Ra.sl[6]=2881; /* line # 2881 */
      if (((UB *)((V *)Rv15)[3])[92]) P_lgt_extract_simple_cte(Rv14);
    }
  }
  Ra.sl[6]=2884; /* line # 2884 */
  Ret=Rv14;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_una "  */
V PAS_COMILER_PRC_00000034(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  UB Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+592;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=2935; /* line # 2935 */
  Ra.sl[6]=2937; /* line # 2937 */
  if (V_sy_sym.ub[0]==9&&(V_sy_sym.ub[1]==12||V_sy_sym.ub[1]==11)) {
    Ra.sl[6]=2938; /* line # 2938 */
    V_sy_sym.ub[0]=6;
  }
  Ra.sl[6]=2939; /* line # 2939 */
  if (V_sy_sym.ub[0]==6) {
    Ra.sl[6]=2941; /* line # 2941 */
    if (V_sy_sym.ub[1]!=11) Rv0=V_sy_sym.ub[1];
    else {
      Ra.sl[6]=2942; /* line # 2942 */
      Rv0=29;
    }
    Ra.sl[6]=2943; /* line # 2943 */
    P_insymbol();
    Ra.sl[6]=2944; /* line # 2944 */
    Rv1=PAS_COMILER_PRC_00000034();
    Ra.sl[6]=2945; /* line # 2945 */
    if (Rv0!=29) {
      Ra.sl[6]=2946; /* line # 2946 */
      if (((UB *)Rv1)[40]!=17) {
        Ra.sl[6]=2947; /* line # 2947 */
        Rv1=P_exp_genop(Rv0, Rv1);
      }
    }
  }
  else {
    Ra.sl[6]=2950; /* line # 2950 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=2952; /* line # 2952 */
      P_insymbol();
      Ra.sl[6]=2953; /* line # 2953 */
      Rv1=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=2954; /* line # 2954 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=2955; /* line # 2955 */
        P_src_error(Rd.s+603,23,3);
      }
    }
    else {
      Ra.sl[6]=2958; /* line # 2958 */
      if (V_sy_sym.ub[0]==15) {
        Ra.sl[6]=2959; /* line # 2959 */
        Rv1=PAS_COMILER_PRC_00000022();
      }
      else {
        Ra.sl[6]=2963; /* line # 2963 */
        Rv1=PAS_COMILER_PRC_00000025();
        Ra.sl[6]=2964; /* line # 2964 */
        Rv2=((UB *)Rv1)[40]!=17;
        Ra.sl[6]=2965; /* line # 2965 */
        if (((SL *)((V *)Rv1)[3])[10]>0) V_curr_descr=Rv1;
        Ra.sl[6]=2966; /* line # 2966 */
        while (Rv2){
          Ra.sl[6]=2967; /* line # 2967 */
          switch (V_sy_sym.ub[0]) {
            case 23:Ra.sl[6]=2970; /* line # 2970 */
            P_insymbol();
            Ra.sl[6]=2971; /* line # 2971 */
            Rv1=PAS_COMILER_PRC_00000026(Rv1);
            Ra.sl[6]=2972; /* line # 2972 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 15:Ra.sl[6]=2977; /* line # 2977 */
            V_sy_sym.ub[0]=17;
            Ra.sl[6]=2978; /* line # 2978 */
            while (V_sy_sym.ub[0]==17){
              Ra.sl[6]=2980; /* line # 2980 */
              P_insymbol();
              Ra.sl[6]=2981; /* line # 2981 */
              Rv1=PAS_COMILER_PRC_00000028(Rv1);
              Ra.sl[6]=2982; /* line # 2982 */
              if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            }
            Ra.sl[6]=2984; /* line # 2984 */
            if (V_sy_sym.ub[0]==16) P_insymbol();
            else {
              Ra.sl[6]=2985; /* line # 2985 */
              P_src_error(Rd.s+603,26,2);
            }
            break;
            case 19:Ra.sl[6]=2990; /* line # 2990 */
            P_insymbol();
            Ra.sl[6]=2991; /* line # 2991 */
            Rv1=PAS_COMILER_PRC_00000027(Rv1);
            Ra.sl[6]=2992; /* line # 2992 */
            if (((SL *)((V *)Rv1)[3])[10]!=0) V_curr_descr=Rv1;
            break;
            case 24:Ra.sl[6]=2996; /* line # 2996 */
            Rv1=PAS_COMILER_PRC_00000007(Rv1,((V *)Rv1)[3]);
            break;
            default:Ra.sl[6]=2999; /* line # 2999 */
            Rv2=0;
            break;
          }
        }
      }
    }
  }
  Ra.sl[6]=3004; /* line # 3004 */
  Ri.ub[0]=0;
  Ra.sl[6]=3005; /* line # 3005 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_pow "  */
V PAS_COMILER_PRC_00000033(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+607;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3009; /* line # 3009 */
  Rv0=PAS_COMILER_PRC_00000034();
  Ra.sl[6]=3010; /* line # 3010 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3011; /* line # 3011 */
    Ra.sl[6]=3012; /* line # 3012 */
    if (V_sy_sym.ub[0]==7) {
      Ra.sl[6]=3014; /* line # 3014 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3015; /* line # 3015 */
      P_insymbol();
      Ra.sl[6]=3016; /* line # 3016 */
      Ri.ub[0]=1;
      Ra.sl[6]=3017; /* line # 3017 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000034();
      Ra.sl[6]=3018; /* line # 3018 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3020; /* line # 3020 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_mul "  */
V PAS_COMILER_PRC_00000032(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+616;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3024; /* line # 3024 */
  Rv0=PAS_COMILER_PRC_00000033();
  Ra.sl[6]=3025; /* line # 3025 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3026; /* line # 3026 */
    Ra.sl[6]=3027; /* line # 3027 */
    while (V_sy_sym.ub[0]==8){
      Ra.sl[6]=3029; /* line # 3029 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3030; /* line # 3030 */
      P_insymbol();
      Ra.sl[6]=3031; /* line # 3031 */
      Ri.ub[0]=1;
      Ra.sl[6]=3032; /* line # 3032 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000033();
      Ra.sl[6]=3033; /* line # 3033 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3035; /* line # 3035 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_add "  */
V PAS_COMILER_PRC_00000031(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+625;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3039; /* line # 3039 */
  Rv0=PAS_COMILER_PRC_00000032();
  Ra.sl[6]=3040; /* line # 3040 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3041; /* line # 3041 */
    Ra.sl[6]=3042; /* line # 3042 */
    while (V_sy_sym.ub[0]==9){
      Ra.sl[6]=3044; /* line # 3044 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3045; /* line # 3045 */
      P_insymbol();
      Ra.sl[6]=3046; /* line # 3046 */
      Ri.ub[0]=1;
      Ra.sl[6]=3047; /* line # 3047 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000032();
      Ra.sl[6]=3048; /* line # 3048 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3050; /* line # 3050 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_rel "  */
V PAS_COMILER_PRC_00000030(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3054; /* line # 3054 */
  Rv0=PAS_COMILER_PRC_00000031();
  Ra.sl[6]=3055; /* line # 3055 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3056; /* line # 3056 */
    Ra.sl[6]=3057; /* line # 3057 */
    while (V_sy_sym.ub[0]==10){
      Ra.sl[6]=3059; /* line # 3059 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3060; /* line # 3060 */
      P_insymbol();
      Ra.sl[6]=3061; /* line # 3061 */
      Ri.ub[0]=1;
      Ra.sl[6]=3062; /* line # 3062 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000031();
      Ra.sl[6]=3063; /* line # 3063 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3065; /* line # 3065 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exp_and "  */
V PAS_COMILER_PRC_00000029(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+643;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3092; /* line # 3092 */
  Rv0=PAS_COMILER_PRC_00000030();
  Ra.sl[6]=3094; /* line # 3094 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3095; /* line # 3095 */
    Ra.sl[6]=3096; /* line # 3096 */
    while (V_sy_sym.ub[0]==11){
      Ra.sl[6]=3098; /* line # 3098 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3099; /* line # 3099 */
      P_insymbol();
      Ra.sl[6]=3100; /* line # 3100 */
      Ri.ub[0]=1;
      Ra.sl[6]=3104; /* line # 3104 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000030();
      Ra.sl[6]=3106; /* line # 3106 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3108; /* line # 3108 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " expression "  */
V PAS_COMILER_PRC_00000000(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+652;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3112; /* line # 3112 */
  Rv0=PAS_COMILER_PRC_00000029();
  Ra.sl[6]=3113; /* line # 3113 */
  if (((UB *)Rv0)[40]!=17) {
    Ra.sl[6]=3114; /* line # 3114 */
    Ra.sl[6]=3115; /* line # 3115 */
    while (V_sy_sym.ub[0]==12){
      Ra.sl[6]=3117; /* line # 3117 */
      Rv1=V_sy_sym.ub[1];
      Ra.sl[6]=3118; /* line # 3118 */
      P_insymbol();
      Ra.sl[6]=3119; /* line # 3119 */
      Ri.ub[0]=1;
      Ra.sl[6]=3120; /* line # 3120 */
      ((V *)Rv0)[0]=PAS_COMILER_PRC_00000029();
      Ra.sl[6]=3121; /* line # 3121 */
      Rv0=P_exp_genop(Rv1, Rv0);
    }
  }
  Ra.sl[6]=3123; /* line # 3123 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_work_list "  */
V PAS_COMILER_PRC_00000039(UB F_mode, V F_ty, UB F_blist){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  SL Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+664;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3215; /* line # 3215 */
  Rv0=NULL;
  Ra.sl[6]=3216; /* line # 3216 */
  Ra.sl[6]=3217; /* line # 3217 */
  switch (F_mode) {
    case 2:
    case 29:Ra.sl[6]=3220; /* line # 3220 */
    P_lgt_new(&Rv0,NULL,16,NULL);
    Ra.sl[6]=3221; /* line # 3221 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+3,0,NULL,0,0,NULL);
    Ra.sl[6]=3222; /* line # 3222 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3223; /* line # 3223 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
    case 41:Ra.sl[6]=3227; /* line # 3227 */
    Rv2=F_ty;
    Ra.sl[6]=3229; /* line # 3229 */
    if (V_sy_sym.ub[0]==13) P_insymbol();
    else {
      Ra.sl[6]=3230; /* line # 3230 */
      P_src_error(Rd.s+682,22,2);
    }
    Ra.sl[6]=3231; /* line # 3231 */
    P_ide_new_typ(23, &Rv3);
    Ra.sl[6]=3232; /* line # 3232 */
    P_lgt_new(&Rv0, Rv3,16,NULL);
    Ra.sl[6]=3233; /* line # 3233 */
    Rv4=Rv3;
    Ra.sl[6]=3235; /* line # 3235 */
    ((SL *)Rv4)[11]=Lx[2].sl[0];
    Ra.sl[6]=3236; /* line # 3236 */
    ((V *)Rv4)[12]=NULL;
    Ra.sl[6]=3237; /* line # 3237 */
    ((V *)Rv4)[13]=NULL;
    Ra.sl[6]=3238; /* line # 3238 */
    ((V *)Rv4)[14]=NULL;
    Ra.sl[6]=3239; /* line # 3239 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv4)+11,&Rv5, Rv3);
    Ra.sl[6]=3240; /* line # 3240 */
    if (Lx[2].v[1]==NULL) {
      Ra.sl[6]=3241; /* line # 3241 */
      ((V *)Rv4)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    }
    else {
      Ra.sl[6]=3243; /* line # 3243 */
      ((V *)Rv4)[12]=((V *)Lx[2].v[1])[3];
    }
    Ra.sl[6]=3244; /* line # 3244 */
    if (((V *)Rv4)[13]==NULL) {
      Ra.sl[6]=3245; /* line # 3245 */
      ((V *)Rv4)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3246; /* line # 3246 */
    Lx[2].v[1]=((V *)Rv4)[13];
    Ra.sl[6]=3249; /* line # 3249 */
    if (((SL *)Rv3)[11]>((SL *)Rv2)[11]) ((SL *)Rv2)[11]=((SL *)Rv3)[11];
    else {
      Ra.sl[6]=3250; /* line # 3250 */
      if (((SL *)Rv3)[11]<0) ((SL *)Rv2)[11]=-1;
    }
    Ra.sl[6]=3252; /* line # 3252 */
    if (Rv5>((UB *)Rv2)[48]) ((UB *)Rv2)[48]=Rv5;
    Ra.sl[6]=3253; /* line # 3253 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=3254; /* line # 3254 */
      P_src_error(Rd.s+682,23,2);
    }
    break;
    case 22:Ra.sl[6]=3259; /* line # 3259 */
    Rv0=PAS_COMILER_PRC_00000005(F_ty,0,0,0);
    Ra.sl[6]=3260; /* line # 3260 */
    if ((V_sy_sym.ub[0]!=17&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3261; /* line # 3261 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
    default:Ra.sl[6]=3265; /* line # 3265 */
    if (F_blist) Rv0=PAS_COMILER_PRC_00000035(72,1);
    else {
      Ra.sl[6]=3266; /* line # 3266 */
      Rv0=PAS_COMILER_PRC_00000036(NULL,1);
    }
    Ra.sl[6]=3267; /* line # 3267 */
    if (Rv0==NULL) {
      Ra.sl[6]=3269; /* line # 3269 */
      P_lgt_new(&Rv0,NULL,16,NULL);
      Ra.sl[6]=3270; /* line # 3270 */
      if (F_blist) {
        Ra.sl[6]=3271; /* line # 3271 */
        Rv1=Rv0;
        Ra.sl[6]=3272; /* line # 3272 */
        ((UW *)Rv1)[10]=((UW *)Rv1)[10]|2048;
      }
    }
    Ra.sl[6]=3274; /* line # 3274 */
    if ((V_sy_sym.ub[0]!=18&&V_sy_sym.ub[0]!=72)&&V_sy_sym.ub[0]!=88) {
      Ra.sl[6]=3275; /* line # 3275 */
      P_src_error(Rd.s+682,35,2);
    }
    break;
  }
  Ra.sl[6]=3277; /* line # 3277 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " case_definition "  */
V PAS_COMILER_PRC_00000004(UB F_mode, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 2096 );

  /* Local variable stored in C variable */
  V Rv0;
  C Rv1;
  V Rv2;
  UB Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  SL Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  UB Rv14;
  UB Rv15;
  UB Rv16;
  SL Rv17;
  SL Rv18;
  SL Rv19;
  SL Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  SL Rv25;
  register int Rf0;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[2];
  Lx[2].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+16;
  Ra.v[3]=Rd.s+686;
  Ra.v[4]=Rd.s+17;
  Ra.sl[10]=3282; /* line # 3282 */
  Ra.sl[10]=3284; /* line # 3284 */
  if (F_mode==41) {
    Ra.sl[10]=3285; /* line # 3285 */
    Ra.sl[0]=abs(((SL *)F_ty)[11]);
  }
  else {
    Ra.sl[10]=3287; /* line # 3287 */
    Ra.sl[0]=0;
  }
  Ra.sl[10]=3288; /* line # 3288 */
  Rv0=NULL;
  Ra.sl[10]=3289; /* line # 3289 */
  if (F_mode==41) {
    Ra.sl[10]=3292; /* line # 3292 */
    if (F_ty!=NULL) {
      Ra.sl[10]=3293; /* line # 3293 */
      Ra.v[1]=((V *)F_ty)[13];
    }
    Ra.sl[10]=3294; /* line # 3294 */
    V_sy_casedef=1;
    Ra.sl[10]=3295; /* line # 3295 */
    Rv1=P_src_search_char();
    Ra.sl[10]=3296; /* line # 3296 */
    if (Rv1==58) {
      Ra.sl[10]=3298; /* line # 3298 */
      P_ide_new(6,NULL,&Rv2);
      Ra.sl[10]=3299; /* line # 3299 */
      Ra.v[1]=Rv2;
      Ra.sl[10]=3300; /* line # 3300 */
      P_insymbol();
      Ra.sl[10]=3301; /* line # 3301 */
      if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+682,29,2);
      else {
        Ra.sl[10]=3302; /* line # 3302 */
        P_insymbol();
      }
      Ra.sl[10]=3304; /* line # 3304 */
      Rv3=1;
    }
    else {
      Ra.sl[10]=3306; /* line # 3306 */
      Rv3=0;
    }
    Ra.sl[10]=3309; /* line # 3309 */
    V_err_prt=0;
    Ra.sl[10]=3310; /* line # 3310 */
    Rv4=P_ide_search(2);
    Ra.sl[10]=3311; /* line # 3311 */
    V_err_prt=1;
    Ra.sl[10]=3312; /* line # 3312 */
    if (!Rv3&&Rv4!=NULL) {
      Ra.sl[10]=3314; /* line # 3314 */
      Rv1=P_src_search_char();
      Ra.sl[10]=3315; /* line # 3315 */
      if (Rv1==34||Rv1==40) Rv4=NULL;
    }
    Ra.sl[10]=3317; /* line # 3317 */
    if (Rv4!=NULL) {
      Ra.sl[10]=3319; /* line # 3319 */
      Rv0=((V *)Rv4)[5];
      Ra.sl[10]=3320; /* line # 3320 */
      if (!P_comp_type(Rv0, V_typ_std.v[15],0,0)) {
        Ra.sl[10]=3323; /* line # 3323 */
        P_src_error(Rd.s+682,60,2);
        Ra.sl[10]=3324; /* line # 3324 */
        Rv0=V_typ_std.v[2];
      }
      Ra.sl[10]=3326; /* line # 3326 */
      if (Rv3) {
        Ra.sl[10]=3327; /* line # 3327 */
        Rv5=Rv2;
        Ra.sl[10]=3329; /* line # 3329 */
        ((V *)Rv5)[5]=Rv0;
        Ra.sl[10]=3330; /* line # 3330 */
        ((SL *)Rv5)[14]=P_ide_typ_align(Ra.sl[0],Rv0);
        Ra.sl[10]=3331; /* line # 3331 */
        Ra.sl[0]=((SL *)Rv5)[14]+((SL *)Rv0)[11];
        Ra.sl[10]=3333; /* line # 3333 */
        if (((UB *)Rv0)[48]>((UB *)F_ty)[48]) {
          Ra.sl[10]=3334; /* line # 3334 */
          ((UB *)F_ty)[48]=((UB *)Rv0)[48];
        }
      }
      Ra.sl[10]=3337; /* line # 3337 */
      P_lgt_new(&Rv6, Rv0,16,NULL);
      Ra.sl[10]=3338; /* line # 3338 */
      if (Rv3) ((V *)Rv6)[4]=Rv2;
      Ra.sl[10]=3339; /* line # 3339 */
      P_insymbol();
    }
  }
  Ra.sl[10]=3343; /* line # 3343 */
  if (Rv0==NULL) {
    Ra.sl[10]=3346; /* line # 3346 */
    Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,0);
    Ra.sl[10]=3347; /* line # 3347 */
    if (F_mode==29||F_mode==41) {
      Ra.sl[10]=3348; /* line # 3348 */
      P_type_check_parm(Rv6);
    }
    else {
      Ra.sl[10]=3349; /* line # 3349 */
      if (F_mode==2) {
        Ra.sl[10]=3350; /* line # 3350 */
        if (((UB *)Rv6)[40]!=14) {
          Ra.sl[10]=3352; /* line # 3352 */
          P_src_error(Rd.s+682,61,3);
        }
      }
    }
    Ra.sl[10]=3353; /* line # 3353 */
    Rv0=((V *)Rv6)[3];
  }
  Ra.sl[10]=3356; /* line # 3356 */
  if (V_sy_sym.ub[0]!=87) P_src_error(Rd.s+682,51,2);
  Ra.sl[10]=3358; /* line # 3358 */
  P_lgt_new(&Rv7,((V *)Rv6)[3],14,NULL);
  Ra.sl[10]=3359; /* line # 3359 */
  Rv8=Rv7;
  Ra.sl[10]=3361; /* line # 3361 */
  ((V *)Rv8)[0]=Rv6;
  Ra.sl[10]=3362; /* line # 3362 */
  P_val_new(((V *)Rv8)+7,NULL);
  Ra.sl[10]=3363; /* line # 3363 */
  ((UB *)((V *)Rv8)[7])[48]=21;
  Ra.sl[10]=3365; /* line # 3365 */
  P_lgt_new(&Rv9,((V *)Rv6)[3],0, Rv7);
  Ra.sl[10]=3366; /* line # 3366 */
  ((UB *)Rv9)[41]=3;
  Ra.sl[10]=3367; /* line # 3367 */
  Rv10=0;
  for( Rf0=512;Rf0>0;Rf0-- ) {
    Ra.sl[Rv10+11]=-1;
    Rv10++;
  }
  Ra.sl[10]=3368; /* line # 3368 */
  Rv11=0;
  Rv12=1;
  Rv13=0;
  Ra.sl[10]=3369; /* line # 3369 */
  Rv14=0;
  Ra.sl[10]=3370; /* line # 3370 */
  Rv15=1;
  Ra.sl[10]=3371; /* line # 3371 */
  Rv16=V_sy_label_flag;
  while (1){
    Ra.sl[10]=3373; /* line # 3373 */
    if (Rv15) V_sy_sym.ub[0]=17;
    Ra.sl[10]=3374; /* line # 3374 */
    V_sy_label_flag=0;
    Ra.sl[10]=3375; /* line # 3375 */
    while (V_sy_sym.ub[0]==17||!Rv15){
      Ra.sl[10]=3377; /* line # 3377 */
      if (Rv15) P_insymbol();
      else {
        Ra.sl[10]=3378; /* line # 3378 */
        Rv15=1;
      }
      Ra.sl[10]=3380; /* line # 3380 */
      Rv17=PAS_COMILER_PRC_00000006(&Rv0);
      Ra.sl[10]=3381; /* line # 3381 */
      if (V_sy_sym.ub[0]==20) {
        Ra.sl[10]=3383; /* line # 3383 */
        P_insymbol();
        Rv18=PAS_COMILER_PRC_00000006(&Rv0);
        Ra.sl[10]=3384; /* line # 3384 */
        if (Rv18<Rv17) {
          Ra.sl[10]=3386; /* line # 3386 */
          Rv18=Rv17;
          P_src_error(Rd.s+682,62,2);
        }
      }
      else {
        Ra.sl[10]=3388; /* line # 3388 */
        Rv18=Rv17;
      }
      while (1){
        Ra.sl[10]=3390; /* line # 3390 */
        if (Rv12>Rv13) {
          Ra.sl[10]=3392; /* line # 3392 */
          Rv12=Rv17;
          Rv13=Rv17;
          Rv19=Rv17;
          Ra.sl[10]=3393; /* line # 3393 */
          Ra.sl[11]=Rv11;
        }
        else {
          Ra.sl[10]=3397; /* line # 3397 */
          if (Rv17>Rv13) Rv13=Rv17;
          else {
            Ra.sl[10]=3398; /* line # 3398 */
            if (Rv17<Rv12) Rv12=Rv17;
          }
          Ra.sl[10]=3399; /* line # 3399 */
          Rv20=Rv17-Rv19;
          Ra.sl[10]=3400; /* line # 3400 */
          if (Rv20<0) Rv20=(Rv20+511)+1;
          Ra.sl[10]=3401; /* line # 3401 */
          if (Rv20<0||Rv20>511) {
            Ra.sl[10]=3403; /* line # 3403 */
            P_src_error(Rd.s+682,63,3);
          }
          else {
            Ra.sl[10]=3407; /* line # 3407 */
            if (Ra.sl[Rv20+11]!=-1) {
              Ra.sl[10]=3408; /* line # 3408 */
              P_src_error(Rd.s+682,64,2);
            }
            else {
              Ra.sl[10]=3410; /* line # 3410 */
              Ra.sl[Rv20+11]=Rv11;
            }
          }
        }
        Ra.sl[10]=3413; /* line # 3413 */
        Rv17=Rv17+1;
        if (Rv17>Rv18)  break;
      }
    }
    Ra.sl[10]=3416; /* line # 3416 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+682,31,2);
    Ra.sl[10]=3417; /* line # 3417 */
    V_sy_label_flag=Rv16;
    Ra.sl[10]=3419; /* line # 3419 */
    Rv21=PAS_COMILER_PRC_00000039(F_mode, F_ty,0);
    Ra.sl[10]=3420; /* line # 3420 */
    if (V_sy_sym.ub[0]==18) {
      Ra.sl[10]=3422; /* line # 3422 */
      V_sy_label_flag=0;
      Ra.sl[10]=3423; /* line # 3423 */
      P_insymbol();
      Ra.sl[10]=3424; /* line # 3424 */
      Rv15=0;
    }
    Ra.sl[10]=3427; /* line # 3427 */
    if (Rv21==NULL) P_lgt_new(&Rv21,NULL,16,NULL);
    Ra.sl[10]=3428; /* line # 3428 */
    ((V *)Rv6)[0]=Rv21;
    Rv6=Rv21;
    Ra.sl[10]=3429; /* line # 3429 */
    Rv11=Rv11+1;
    if (((V_sy_sym.ub[0]==88||V_sy_sym.ub[0]==72)||V_sy_sym.ub[0]==14)||V_sy_sym
    .ub[0]==90)  break;
  }
  Ra.sl[10]=3431; /* line # 3431 */
  V_sy_label_flag=Rv16;
  Ra.sl[10]=3432; /* line # 3432 */
  if (V_sy_sym.ub[0]==88) {
    Ra.sl[10]=3434; /* line # 3434 */
    P_insymbol();
    Ra.sl[10]=3435; /* line # 3435 */
    Rv6=PAS_COMILER_PRC_00000039(F_mode, F_ty,1);
  }
  else {
    Ra.sl[10]=3439; /* line # 3439 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[10]=3440; /* line # 3440 */
    if (F_mode==41) {
      Ra.sl[10]=3442; /* line # 3442 */
      P_ide_new_typ(23,((V *)Rv6)+3);
      Ra.sl[10]=3443; /* line # 3443 */
      Rv22=((V *)Rv6)[3];
      Ra.sl[10]=3445; /* line # 3445 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[10]=3446; /* line # 3446 */
      ((V *)Rv22)[13]=NULL;
      Ra.sl[10]=3447; /* line # 3447 */
      ((V *)Rv22)[14]=NULL;
      Ra.sl[10]=3448; /* line # 3448 */
      ((SL *)Rv22)[11]=Ra.sl[0];
    }
  }
  Ra.sl[10]=3452; /* line # 3452 */
  Rv21=((V *)Rv7)[0];
  Ra.sl[10]=3453; /* line # 3453 */
  ((V *)Rv6)[0]=Rv21;
  Ra.sl[10]=3454; /* line # 3454 */
  ((V *)Rv7)[0]=Rv6;
  Ra.sl[10]=3455; /* line # 3455 */
  if (F_mode!=41) P_insymbol();
  Ra.sl[10]=3457; /* line # 3457 */
  ((SL *)Rv9)[4]=Rv11;
  Ra.sl[10]=3458; /* line # 3458 */
  Rv23=Rv7;
  Rv24=((V *)Rv23)[7];
  Ra.sl[10]=3460; /* line # 3460 */
  ((SL *)Rv23)[4]=Rv12;
  Ra.sl[10]=3461; /* line # 3461 */
  ((SL *)Rv24)[6]=(Rv13-Rv12)+1;
  Ra.sl[10]=3462; /* line # 3462 */
  ((V *)Rv24)[7]=P_tab_new(((SL *)Rv24)[6]);
  Ra.sl[10]=3463; /* line # 3463 */
  Rv17=Rv12-Rv19;
  Ra.sl[10]=3464; /* line # 3464 */
  if (Rv17<0) Rv17=(Rv17+511)+1;
  Ra.sl[10]=3465; /* line # 3465 */
  Rv25=0;
  for( Rf0=(Rv13-Rv12)+1;Rf0>0;Rf0-- ) {
    Ra.sl[10]=3467; /* line # 3467 */
    ((SL *)((V *)Rv24)[7])[Rv25]=Ra.sl[Rv17+11];
    Ra.sl[10]=3468; /* line # 3468 */
    Rv17=Rv17+1;
    Ra.sl[10]=3469; /* line # 3469 */
    if (Rv17>511) Rv17=0;
    Rv25++;
  }
  Ra.sl[10]=3473; /* line # 3473 */
  V_sy_casedef=0;
  Ra.sl[10]=3474; /* line # 3474 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[2];
  Lx[2]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " set_alignment_spc "  */
void PAS_COMILER_PRC_00000040(SL *F_sz, SL *F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+703;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3488; /* line # 3488 */
  Ra.sl[6]=3491; /* line # 3491 */
  if (Rs.sl[0]>0) {
    Ra.sl[6]=3493; /* line # 3493 */
    (*F_sz)=Rs.sl[0];
    Rv0=(*F_sz);
    Rs.sl[0]=-1;
    Ra.sl[6]=3494; /* line # 3494 */
    if (Rs.sl[1]<0) {
      Ra.sl[6]=3496; /* line # 3496 */
      (*F_aln)=1;
      Ra.sl[6]=3497; /* line # 3497 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3498; /* line # 3498 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  Ra.sl[6]=3501; /* line # 3501 */
  if (Rs.sl[1]>=0) {
    Ra.sl[6]=3502; /* line # 3502 */
    (*F_aln)=Rs.sl[1];
    Rs.sl[1]=-1;
  }
  Ra.sl[6]=3503; /* line # 3503 */
  if (V_sy_sym.ub[0]==73) {
    Ra.sl[6]=3505; /* line # 3505 */
    P_insymbol();
    Ra.sl[6]=3507; /* line # 3507 */
    (*F_sz)=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
    Ra.sl[6]=3508; /* line # 3508 */
    if ((*F_sz)<1) (*F_sz)=1;
    Ra.sl[6]=3509; /* line # 3509 */
    Rv0=(*F_sz);
    Ra.sl[6]=3510; /* line # 3510 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=3512; /* line # 3512 */
      P_insymbol();
      Ra.sl[6]=3513; /* line # 3513 */
      Rv0=(PAS_COMILER_PRC_00000006(V_typ_std.v+2)+7)/8;
      Ra.sl[6]=3514; /* line # 3514 */
      if (Rv0>256) P_src_error(Rd.s+724,231,2);
    }
    Ra.sl[6]=3516; /* line # 3516 */
    if (Rv0<0||Rv0>256) Rv0=((SL *)V_typ_std.v[4])[11];
    Ra.sl[6]=3517; /* line # 3517 */
    if (Rv0<=1) (*F_aln)=0;
    else {
      Ra.sl[6]=3519; /* line # 3519 */
      (*F_aln)=1;
      Ra.sl[6]=3520; /* line # 3520 */
      while ((*F_aln)<Rv0)
      (*F_aln)=2*(*F_aln);
      Ra.sl[6]=3521; /* line # 3521 */
      (*F_aln)=(*F_aln)-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " conformant_def "  */
void PAS_COMILER_PRC_00000041(V *F_tr, SL *F_ndim){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+728;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3540; /* line # 3540 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[6]=3541; /* line # 3541 */
  P_ide_new_typ(22, F_tr);
  Ra.sl[6]=3542; /* line # 3542 */
  Rv2=(*F_tr);
  Ra.sl[6]=3544; /* line # 3544 */
  if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv0);
  else {
    Ra.sl[6]=3545; /* line # 3545 */
    P_src_error(Rd.s+746,232,3);
  }
  Ra.sl[6]=3546; /* line # 3546 */
  P_insymbol();
  Ra.sl[6]=3547; /* line # 3547 */
  if (V_sy_sym.ub[0]==20) {
    Ra.sl[6]=3549; /* line # 3549 */
    P_insymbol();
    Ra.sl[6]=3550; /* line # 3550 */
    if (V_sy_sym.ub[0]==0) P_ide_new(5,NULL,&Rv1);
    else {
      Ra.sl[6]=3551; /* line # 3551 */
      P_src_error(Rd.s+746,232,3);
    }
    Ra.sl[6]=3552; /* line # 3552 */
    P_insymbol();
  }
  Ra.sl[6]=3554; /* line # 3554 */
  if (V_sy_sym.ub[0]==21) {
    Ra.sl[6]=3556; /* line # 3556 */
    P_insymbol();
    Ra.sl[6]=3557; /* line # 3557 */
    PAS_COMILER_PRC_00000038(((V *)Rv2),0,NULL,0,0,NULL);
    Ra.sl[6]=3558; /* line # 3558 */
    ((SL *)Rv2)[11]=((SL *)((V *)Rv2)[0])[11];
    Ra.sl[6]=3559; /* line # 3559 */
    memcpy(Rv2+48,((V *)Rv2)[0]+48,1);
    Ra.sl[6]=3560; /* line # 3560 */
    if (Rv0!=NULL) {
      Ra.sl[6]=3562; /* line # 3562 */
      ((V *)Rv0)[5]=((V *)Rv2)[0];
      Ra.sl[6]=3563; /* line # 3563 */
      ((UB *)Rv0)[86]=9;
      Ra.sl[6]=3564; /* line # 3564 */
      ((UW *)Rv0)[42]=32;
      Ra.sl[6]=3565; /* line # 3565 */
      if (Rv1==NULL) {
        Ra.sl[6]=3567; /* line # 3567 */
        ((V *)Rv2)[13]=P_lgt_new_econst(((V *)Rv2)[0],1);
        Ra.sl[6]=3568; /* line # 3568 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3569; /* line # 3569 */
        ((V *)Rv2)[12]=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3570; /* line # 3570 */
        ((V *)((V *)Rv2)[12])[3]=V_int_typ;
        Ra.sl[6]=3571; /* line # 3571 */
        (*F_ndim)=(*F_ndim)+1;
      }
      else {
        Ra.sl[6]=3575; /* line # 3575 */
        ((V *)Rv1)[5]=((V *)Rv2)[0];
        Ra.sl[6]=3576; /* line # 3576 */
        ((UB *)Rv1)[86]=9;
        Ra.sl[6]=3577; /* line # 3577 */
        ((UW *)Rv1)[42]=32;
        Ra.sl[6]=3578; /* line # 3578 */
        ((V *)Rv2)[13]=P_lgt_new_idref(Rv0,NULL);
        Ra.sl[6]=3579; /* line # 3579 */
        ((V *)Rv2)[14]=P_lgt_new_idref(Rv1,NULL);
        Ra.sl[6]=3580; /* line # 3580 */
        Rv3=P_lgt_link(((V *)Rv2)[14]);
        Ra.sl[6]=3581; /* line # 3581 */
        ((V *)Rv3)[0]=P_lgt_link(((V *)Rv2)[13]);
        Ra.sl[6]=3582; /* line # 3582 */
        Rv3=P_lgt_new_code(50, Rv3);
        Ra.sl[6]=3583; /* line # 3583 */
        ((V *)Rv3)[0]=P_lgt_new_econst(V_int_typ,1);
        Ra.sl[6]=3584; /* line # 3584 */
        ((V *)Rv2)[12]=P_lgt_new_code(49, Rv3);
        Ra.sl[6]=3585; /* line # 3585 */
        (*F_ndim)=(*F_ndim)+2;
      }
    }
  }
  else {
    Ra.sl[6]=3588; /* line # 3588 */
    P_src_error(Rd.s+746,31,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " array_def "  */
void PAS_COMILER_PRC_00000042(V *F_art, UB F_bconf, SL *F_ndim, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  SL Rv2;
  register V Rv3;
  register V Rv4;
  V Rv5;
  SL Rv6;
  V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+750;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3607; /* line # 3607 */
  P_insymbol();
  Ra.sl[6]=3608; /* line # 3608 */
  if (F_bconf) P_ide_new_typ(9, F_art);
  else {
    Ra.sl[6]=3609; /* line # 3609 */
    P_ide_new_typ(8, F_art);
  }
  Ra.sl[6]=3610; /* line # 3610 */
  Rv0=(*F_art);
  Ra.sl[6]=3612; /* line # 3612 */
  ((V *)Rv0)[3]=F_owid;
  Ra.sl[6]=3613; /* line # 3613 */
  ((V *)Rv0)[15]=NULL;
  Ra.sl[6]=3614; /* line # 3614 */
  if (F_bconf) {
    Ra.sl[6]=3615; /* line # 3615 */
    PAS_COMILER_PRC_00000041(((V *)Rv0)+15,F_ndim);
  }
  else {
    Ra.sl[6]=3618; /* line # 3618 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+15,0,NULL,0,0,NULL);
    Ra.sl[6]=3619; /* line # 3619 */
    (*F_ndim)=(*F_ndim)+2;
  }
  Ra.sl[6]=3621; /* line # 3621 */
  Rv1=NULL;
  Rv2=1;
  Ra.sl[6]=3622; /* line # 3622 */
  if (((V *)Rv0)[15]!=NULL) {
    Ra.sl[6]=3623; /* line # 3623 */
    Rv3=((V *)Rv0)[15];
    Ra.sl[6]=3625; /* line # 3625 */
    switch (((UB *)Rv3)[93]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=3627; /* line # 3627 */
      if (((UB *)Rv3)[112]) Rv2=(((UL *)Rv3)[30]-((UL *)Rv3)[29])+1;
      else {
        Ra.sl[6]=3628; /* line # 3628 */
        Rv2=(((SL *)Rv3)[30]-((SL *)Rv3)[29])+1;
      }
      break;
      case 22:Ra.sl[6]=3630; /* line # 3630 */
      Rv1=P_lgt_link(((V *)Rv3)[12]);
      break;
      default:Ra.sl[6]=3633; /* line # 3633 */
      P_src_error(Rd.s+763,210,3);
      break;
    }
  }
  Ra.sl[6]=3638; /* line # 3638 */
  if (V_sy_sym.ub[0]==17) {
    Ra.sl[6]=3640; /* line # 3640 */
    PAS_COMILER_PRC_00000042(((V *)Rv0)+14,F_bconf, F_ndim,NULL);
    Ra.sl[6]=3641; /* line # 3641 */
    ((SL *)Rv0)[24]=(*F_ndim);
  }
  else {
    Ra.sl[6]=3645; /* line # 3645 */
    ((SL *)Rv0)[24]=(*F_ndim);
    Ra.sl[6]=3646; /* line # 3646 */
    if (V_sy_sym.ub[0]==16) P_insymbol();
    else {
      Ra.sl[6]=3647; /* line # 3647 */
      P_src_error(Rd.s+763,26,2);
    }
    Ra.sl[6]=3648; /* line # 3648 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else {
      Ra.sl[6]=3649; /* line # 3649 */
      P_src_error(Rd.s+763,51,2);
    }
    Ra.sl[6]=3650; /* line # 3650 */
    PAS_COMILER_PRC_00000038(((V *)Rv0)+14,0,NULL,0,0,NULL);
  }
  Ra.sl[6]=3654; /* line # 3654 */
  if (((V *)Rv0)[14]!=NULL) {
    Ra.sl[6]=3657; /* line # 3657 */
    ((UB *)Rv0)[48]=((UB *)((V *)Rv0)[14])[48];
    Ra.sl[6]=3659; /* line # 3659 */
    Rv4=((V *)Rv0)[14];
    Ra.sl[6]=3661; /* line # 3661 */
    Rv5=NULL;
    Ra.sl[6]=3662; /* line # 3662 */
    Rv6=((SL *)Rv4)[11];
    Ra.sl[6]=3663; /* line # 3663 */
    Rv7=((V *)Rv4)[9];
    Ra.sl[6]=3664; /* line # 3664 */
    memcpy(Ra.s+28,Rv4+48,1);
    Ra.sl[6]=3665; /* line # 3665 */
    if (Rv6>0) Rv6=P_typ_alignement(Rv6, Rv4+48);
    Ra.sl[6]=3666; /* line # 3666 */
    if (Rv6>=0) Rv7=NULL;
    Ra.sl[6]=3668; /* line # 3668 */
    if (Rv7!=NULL) {
      Ra.sl[6]=3669; /* line # 3669 */
      if (((UB *)Rv7)[40]==14) Rv6=((SL *)((V *)Rv7)[7])[13];
      else {
        Ra.sl[6]=3670; /* line # 3670 */
        P_lgt_copy_tree(Rv7, &Rv5);
      }
    }
    Ra.sl[6]=3671; /* line # 3671 */
    if ((Rv5!=NULL&&((UB *)Rv0)[48]>0)&&((UB *)((V *)Rv0)[14])[93]!=8) {
      Ra.sl[6]=3674; /* line # 3674 */
      Rv8=1;
      Ra.sl[6]=3675; /* line # 3675 */
      if ((((UB *)Rv5)[40]==6&&((UB *)Rv5)[41]==49)&&((V *)Rv5)[1]!=NULL) {
        Ra.sl[6]=3678; /* line # 3678 */
        if (((V *)((V *)Rv5)[1])[0]!=NULL) {
          Ra.sl[6]=3679; /* line # 3679 */
          Rv9=((V *)((V *)Rv5)[1])[0];
          Ra.sl[6]=3680; /* line # 3680 */
          if (((UB *)Rv9)[40]==14&&((V *)Rv9)[7]!=NULL) {
            Ra.sl[6]=3682; /* line # 3682 */
            Rv10=((SL *)((V *)Rv9)[7])[13]+Ra.ub[28];
            Ra.sl[6]=3683; /* line # 3683 */
            P_val_free(((V *)Rv9)+7);
            Ra.sl[6]=3684; /* line # 3684 */
            P_val_new(((V *)Rv9)+7,V_int_typ);
            Ra.sl[6]=3685; /* line # 3685 */
            ((SL *)((V *)Rv9)[7])[13]=Rv10;
            Ra.sl[6]=3686; /* line # 3686 */
            Rv8=0;
          }
        }
      }
      Ra.sl[6]=3688; /* line # 3688 */
      if (Rv8) {
        Ra.sl[6]=3690; /* line # 3690 */
        ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
        Ra.sl[6]=3691; /* line # 3691 */
        Rv5=P_lgt_new_code(49, Rv5);
      }
      Ra.sl[6]=3693; /* line # 3693 */
      ((V *)Rv5)[0]=P_lgt_new_econst(V_int_typ, Ra.ub[28]);
      Ra.sl[6]=3694; /* line # 3694 */
      Rv5=P_lgt_new_code(13, Rv5);
    }
    Ra.sl[6]=3697; /* line # 3697 */
    ((V *)Rv0)[13]=Rv5;
    Ra.sl[6]=3698; /* line # 3698 */
    ((SL *)Rv0)[25]=Rv6;
    Ra.sl[6]=3701; /* line # 3701 */
    if (((UB *)((V *)Rv0)[14])[91]||((SL *)((V *)Rv0)[14])[10]>0) {
      Ra.sl[6]=3702; /* line # 3702 */
      ((UB *)Rv0)[91]=1;
    }
    Ra.sl[6]=3705; /* line # 3705 */
    ((SL *)Rv0)[11]=((SL *)Rv0)[25]*Rv2;
    Ra.sl[6]=3706; /* line # 3706 */
    if (Rv1==NULL&&((V *)Rv0)[13]==NULL) {
      Ra.sl[6]=3707; /* line # 3707 */
      ((V *)Rv0)[9]=NULL;
    }
    else {
      Ra.sl[6]=3710; /* line # 3710 */
      if (Rv1==NULL) {
        Ra.sl[6]=3712; /* line # 3712 */
        Rv1=P_lgt_new_econst(V_int_typ, Rv2);
        Ra.sl[6]=3713; /* line # 3713 */
        ((V *)Rv1)[0]=((V *)Rv0)[13];
        Ra.sl[6]=3714; /* line # 3714 */
        ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
      }
      else {
        Ra.sl[6]=3717; /* line # 3717 */
        if (((V *)Rv0)[13]==NULL) {
          Ra.sl[6]=3718; /* line # 3718 */
          if (((SL *)Rv0)[25]==1) {
            Ra.sl[6]=3719; /* line # 3719 */
            ((V *)Rv0)[9]=Rv1;
          }
          else {
            Ra.sl[6]=3722; /* line # 3722 */
            ((V *)Rv1)[0]=P_lgt_new_econst(V_int_typ,((SL *)Rv0)[25]);
            Ra.sl[6]=3723; /* line # 3723 */
            ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
          }
        }
        else {
          Ra.sl[6]=3727; /* line # 3727 */
          ((V *)Rv1)[0]=((V *)Rv0)[13];
          Ra.sl[6]=3728; /* line # 3728 */
          ((V *)Rv0)[9]=P_lgt_new_code(51, Rv1);
        }
      }
      Ra.sl[6]=3730; /* line # 3730 */
      ((SL *)Rv0)[11]=-1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_spc "  */
void PAS_COMILER_PRC_00000038(V *F_it, SL F_descr_sz, V F_parm, UB F_bdeforg, UB
F_buseorg, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  SL Rv11;
  SL Rv12;
  SL Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  register V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register V Rv23;
  SL Rv24;
  SL Rv25;
  register V Rv26;
  SL Rv27;
  register V Rv28;
  register V Rv29;
  register V Rv30;
  register V Rv31;
  register V Rv32;
  V Rv33;
  register V Rv34;
  register V Rv35;
  V Rv36;
  V Rv37;
  register V Rv38;
  register UB Rv39;
  register V Rv40;
  SL Rv41;
  V Rv42;
  register V Rv43;
  register V Rv44;
  register V Rv45;
  register V Rv46;
  register V Rv47;
  register V Rv48;
  register V Rv49;
  register V Rv50;
  register V Rv51;
  register V Rv52;
  register V Rv53;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+767;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=3759; /* line # 3759 */
  Rv0=V_sy_descr_size;
  Ra.sl[6]=3760; /* line # 3760 */
  V_sy_descr_size=0;
  Ra.sl[6]=3761; /* line # 3761 */
  V_sy_type_gfirst=NULL;
  Ra.sl[6]=3762; /* line # 3762 */
  Ra.sl[6]=3764; /* line # 3764 */
  Rv1=NULL;
  Ra.sl[6]=3765; /* line # 3765 */
  if (V_sy_sym.ub[0]==37) P_insymbol();
  Ra.sl[6]=3766; /* line # 3766 */
  switch (V_sy_sym.ub[0]) {
    case 29:Ra.sl[6]=3769; /* line # 3769 */
    Rv0=0;
    Ra.sl[6]=3770; /* line # 3770 */
    P_insymbol();
    Ra.sl[6]=3772; /* line # 3772 */
    if (V_sy_sym.ub[0]!=56) P_src_error(Rd.s+779,182,2);
    else {
      Ra.sl[6]=3773; /* line # 3773 */
      P_insymbol();
    }
    Ra.sl[6]=3774; /* line # 3774 */
    P_ide_new_typ(27, &Rv1);
    Ra.sl[6]=3775; /* line # 3775 */
    ((V *)Rv1)[9]=PAS_COMILER_PRC_00000004(29,NULL);
    break;
    case 58:Ra.sl[6]=3780; /* line # 3780 */
    P_insymbol();
    Ra.sl[6]=3781; /* line # 3781 */
    Rv2=P_ide_search(2);
    Ra.sl[6]=3782; /* line # 3782 */
    P_insymbol();
    Ra.sl[6]=3783; /* line # 3783 */
    if (Rv2!=V_ide_udptr.v[1]) {
      Ra.sl[6]=3784; /* line # 3784 */
      Rv19=Rv2;
      Ra.sl[6]=3786; /* line # 3786 */
      P_ide_new_typ(((UB *)((V *)Rv2)[5])[93],&Rv1);
      Ra.sl[6]=3787; /* line # 3787 */
      V_sy_type_gfirst=((V *)Rv19)[10];
      Ra.sl[6]=3788; /* line # 3788 */
      Rv20=Rv1;
      Ra.sl[6]=3790; /* line # 3790 */
      ((V *)Rv20)[3]=F_owid;
      Ra.sl[6]=3791; /* line # 3791 */
      ((V *)Rv20)[0]=((V *)Rv19)[5];
      Ra.sl[6]=3792; /* line # 3792 */
      ((V *)Rv20)[4]=((V *)((V *)Rv20)[0])[4];
      Ra.sl[6]=3793; /* line # 3793 */
      ((SL *)Rv20)[11]=((SL *)((V *)Rv20)[0])[11];
      Ra.sl[6]=3794; /* line # 3794 */
      ((SL *)Rv20)[10]=((SL *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3795; /* line # 3795 */
      memcpy(Rv20+48,((V *)Rv20)[0]+48,1);
      Ra.sl[6]=3796; /* line # 3796 */
      ((V *)Rv20)[10]=((V *)((V *)Rv20)[0])[10];
      Ra.sl[6]=3797; /* line # 3797 */
      ((UB *)Rv20)[91]=((UB *)((V *)Rv20)[0])[91];
      Ra.sl[6]=3798; /* line # 3798 */
      if (((V *)Rv20)[9]!=NULL) {
        Ra.sl[6]=3799; /* line # 3799 */
        ((V *)Rv20)[9]=P_lgt_link(((V *)((V *)Rv20)[0])[9]);
      }
      Ra.sl[6]=3800; /* line # 3800 */
      switch (((UB *)Rv20)[93]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=3803; /* line # 3803 */
        ((SL *)Rv20)[29]=((SL *)((V *)Rv20)[0])[29];
        Ra.sl[6]=3804; /* line # 3804 */
        ((SL *)Rv20)[30]=((SL *)((V *)Rv20)[0])[30];
        Ra.sl[6]=3805; /* line # 3805 */
        ((UB *)Rv20)[112]=((UB *)((V *)Rv20)[0])[112];
        Ra.sl[6]=3806; /* line # 3806 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 22:Ra.sl[6]=3811; /* line # 3811 */
        ((V *)Rv20)[12]=P_lgt_link(((V *)((V *)Rv20)[0])[12]);
        Ra.sl[6]=3812; /* line # 3812 */
        ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        Ra.sl[6]=3813; /* line # 3813 */
        ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        break;
        case 3:
        case 4:break;
        case 5:
        case 7:
        case 24:
        case 26:Ra.sl[6]=3820; /* line # 3820 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        break;
        case 11:
        case 12:Ra.sl[6]=3823; /* line # 3823 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        break;
        case 8:Ra.sl[6]=3827; /* line # 3827 */
        ((SL *)Rv20)[25]=((SL *)((V *)Rv20)[0])[25];
        Ra.sl[6]=3828; /* line # 3828 */
        if (((V *)((V *)Rv20)[0])[13]!=NULL) {
          Ra.sl[6]=3829; /* line # 3829 */
          ((V *)Rv20)[13]=P_lgt_link(((V *)((V *)Rv20)[0])[13]);
        }
        else {
          Ra.sl[6]=3832; /* line # 3832 */
          ((V *)Rv20)[13]=NULL;
        }
        Ra.sl[6]=3833; /* line # 3833 */
        ((V *)Rv20)[14]=((V *)((V *)Rv20)[0])[14];
        Ra.sl[6]=3834; /* line # 3834 */
        ((V *)Rv20)[15]=((V *)((V *)Rv20)[0])[15];
        break;
        case 10:Ra.sl[6]=3839; /* line # 3839 */
        ((V *)Rv20)[12]=((V *)((V *)Rv20)[0])[12];
        Ra.sl[6]=3840; /* line # 3840 */
        ((V *)Rv20)[13]=((V *)((V *)Rv20)[0])[13];
        Ra.sl[6]=3841; /* line # 3841 */
        if (((V *)((V *)Rv20)[0])[14]!=NULL) {
          Ra.sl[6]=3842; /* line # 3842 */
          ((V *)Rv20)[14]=P_lgt_link(((V *)((V *)Rv20)[0])[14]);
        }
        else {
          Ra.sl[6]=3844; /* line # 3844 */
          ((V *)Rv20)[14]=NULL;
        }
        break;
        case 14:
        case 15:
        case 19:
        case 21:Ra.sl[6]=3852; /* line # 3852 */
        Rv11=((SL *)Rv20)[11];
        Ra.sl[6]=3853; /* line # 3853 */
        Rv12=((UB *)Rv20)[48];
        Ra.sl[6]=3854; /* line # 3854 */
        PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
        Ra.sl[6]=3855; /* line # 3855 */
        if (Rv11<((SL *)Rv20)[11]) P_src_error(Rd.s+779,214,2);
        else {
          Ra.sl[6]=3856; /* line # 3856 */
          ((SL *)Rv20)[11]=Rv11;
        }
        Ra.sl[6]=3857; /* line # 3857 */
        if (Rv12>=0) ((UB *)Rv20)[48]=Rv12;
        break;
        default:Ra.sl[6]=3862; /* line # 3862 */
        P_src_error(Rd.s+779,206,3);
        break;
      }
    }
    break;
    case 43:Ra.sl[6]=3870; /* line # 3870 */
    if (F_parm!=NULL) P_src_error(Rd.s+779,207,2);
    Ra.sl[6]=3871; /* line # 3871 */
    P_insymbol();
    Ra.sl[6]=3872; /* line # 3872 */
    if (V_sy_sym.ub[0]==38) {
      Ra.sl[6]=3873; /* line # 3873 */
      if (F_bdeforg) {
        Ra.sl[6]=3875; /* line # 3875 */
        P_insymbol();
        Ra.sl[6]=3876; /* line # 3876 */
        P_ide_new_typ(24, &Rv1);
        Ra.sl[6]=3877; /* line # 3877 */
        Rv21=Rv1;
        Ra.sl[6]=3879; /* line # 3879 */
        ((V *)Rv21)[3]=F_owid;
        Ra.sl[6]=3880; /* line # 3880 */
        ((V *)Rv21)[12]=NULL;
        Ra.sl[6]=3881; /* line # 3881 */
        ((SL *)Rv21)[11]=V_fptr_size;
        Ra.sl[6]=3882; /* line # 3882 */
        memcpy(Rv21+48,V_typ_std.v[5]+48,1);
        Ra.sl[6]=3883; /* line # 3883 */
        ((V *)Rv21)[9]=NULL;
      }
      else {
        Ra.sl[6]=3887; /* line # 3887 */
        P_src_error(Rd.s+779,208,3);
      }
    }
    else {
      Ra.sl[6]=3890; /* line # 3890 */
      P_ide_new_typ(26, &Rv1);
      Ra.sl[6]=3891; /* line # 3891 */
      Rv22=Rv1;
      Ra.sl[6]=3893; /* line # 3893 */
      ((V *)Rv22)[12]=NULL;
      Ra.sl[6]=3894; /* line # 3894 */
      ((V *)Rv22)[9]=NULL;
      Ra.sl[6]=3896; /* line # 3896 */
      memcpy(Rv22+48,V_typ_std.v[2]+48,1);
      Ra.sl[6]=3897; /* line # 3897 */
      ((SL *)Rv22)[11]=1;
    }
    Ra.sl[6]=3900; /* line # 3900 */
    Rv23=Rv1;
    Ra.sl[6]=3903; /* line # 3903 */
    Rv11=((SL *)Rv23)[11];
    Ra.sl[6]=3904; /* line # 3904 */
    Rv12=((UB *)Rv23)[48];
    Ra.sl[6]=3905; /* line # 3905 */
    PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
    Ra.sl[6]=3906; /* line # 3906 */
    if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
    Ra.sl[6]=3907; /* line # 3907 */
    if (Rv11<((SL *)Rv23)[11]) P_src_error(Rd.s+779,214,2);
    else {
      Ra.sl[6]=3908; /* line # 3908 */
      ((SL *)Rv23)[11]=Rv11;
    }
    Ra.sl[6]=3909; /* line # 3909 */
    if (Rv12>=0) ((UB *)Rv23)[48]=Rv12;
    break;
    case 40:Ra.sl[6]=3915; /* line # 3915 */
    P_insymbol();
    Ra.sl[6]=3916; /* line # 3916 */
    if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+779,25,2);
    Ra.sl[6]=3917; /* line # 3917 */
    Rv24=0;
    Ra.sl[6]=3918; /* line # 3918 */
    PAS_COMILER_PRC_00000042(&Rv1,0, &Rv24, F_owid);
    Ra.sl[6]=3920; /* line # 3920 */
    if (V_ima_typ==NULL) V_ima_typ=Rv1;
    break;
    case 41:Ra.sl[6]=3925; /* line # 3925 */
    Rv25=V_curr_disp;
    Ra.sl[6]=3926; /* line # 3926 */
    P_ide_new_typ(10, &Rv1);
    Ra.sl[6]=3927; /* line # 3927 */
    Rv26=Rv1;
    Ra.sl[6]=3929; /* line # 3929 */
    ((V *)Rv26)[3]=F_owid;
    Ra.sl[6]=3930; /* line # 3930 */
    ((SL *)Rv26)[10]=F_descr_sz;
    Ra.sl[6]=3931; /* line # 3931 */
    ((SL *)Rv26)[11]=((SL *)Rv26)[10];
    Ra.sl[6]=3932; /* line # 3932 */
    ((V *)Rv26)[12]=NULL;
    ((V *)Rv26)[13]=NULL;
    Ra.sl[6]=3933; /* line # 3933 */
    ((V *)Rv26)[14]=NULL;
    Ra.sl[6]=3934; /* line # 3934 */
    Rv2=NULL;
    Ra.sl[6]=3936; /* line # 3936 */
    P_insymbol();
    Ra.sl[6]=3937; /* line # 3937 */
    P_new_disp_level(NULL,1);
    Ra.sl[6]=3938; /* line # 3938 */
    Lx[5].ub[0]=0;
    Ra.sl[6]=3939; /* line # 3939 */
    PAS_COMILER_PRC_00000037(6,((SL *)Rv1)+11,&Rv27, Rv1);
    Ra.sl[6]=3940; /* line # 3940 */
    Rv28=Rv1;
    Ra.sl[6]=3942; /* line # 3942 */
    ((UB *)Rv28)[91]=Lx[5].ub[0];
    Ra.sl[6]=3943; /* line # 3943 */
    ((V *)Rv28)[12]=V_lex_ident_tree.v[V_curr_disp*8+1];
    Ra.sl[6]=3944; /* line # 3944 */
    if (((V *)Rv28)[14]==NULL) {
      Ra.sl[6]=3945; /* line # 3945 */
      ((V *)Rv28)[13]=V_lex_ident_tree.v[V_curr_disp*8+4];
    }
    Ra.sl[6]=3947; /* line # 3947 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=3950; /* line # 3950 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else P_src_error(Rd.s+779,54,2);
    Ra.sl[6]=3951; /* line # 3951 */
    if (V_typ_std.v[10]==NULL) {
      Ra.sl[6]=3953; /* line # 3953 */
      V_typ_std.v[10]=Rv1;
      Ra.sl[6]=3954; /* line # 3954 */
      Rv29=Rv1;
      Ra.sl[6]=3956; /* line # 3956 */
      V_stri_descrsz=((SL *)Rv29)[10];
      Ra.sl[6]=3957; /* line # 3957 */
      V_stri_lengthsz=((SL *)((V *)((V *)Rv29)[12])[5])[11];
      Ra.sl[6]=3958; /* line # 3958 */
      V_stri_stroffset=((SL *)((V *)((V *)Rv29)[12])[3])[14];
    }
    break;
    case 39:Ra.sl[6]=3965; /* line # 3965 */
    P_insymbol();
    Ra.sl[6]=3966; /* line # 3966 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    Ra.sl[6]=3967; /* line # 3967 */
    P_ide_new_typ(7, &Rv1);
    Ra.sl[6]=3968; /* line # 3968 */
    Rv30=Rv1;
    Ra.sl[6]=3970; /* line # 3970 */
    ((V *)Rv30)[3]=F_owid;
    Ra.sl[6]=3971; /* line # 3971 */
    memcpy(Rv30+48,V_typ_std.v[16]+48,1);
    Ra.sl[6]=3972; /* line # 3972 */
    ((SL *)Rv30)[11]=((SL *)V_typ_std.v[16])[11];
    Ra.sl[6]=3973; /* line # 3973 */
    ((V *)Rv30)[10]=((V *)V_typ_std.v[16])[10];
    Ra.sl[6]=3974; /* line # 3974 */
    ((V *)Rv30)[0]=V_typ_std.v[16];
    Ra.sl[6]=3976; /* line # 3976 */
    PAS_COMILER_PRC_00000038(((V *)Rv30)+12,0,NULL,0,0,NULL);
    Ra.sl[6]=3979; /* line # 3979 */
    if (((UB *)((V *)Rv30)[12])[91]||((SL *)((V *)Rv30)[12])[10]>0) ((UB *)Rv30)
    [91]=1;
    Ra.sl[6]=3981; /* line # 3981 */
    if (((SL *)((V *)Rv30)[12])[11]<=0) P_src_error(Rd.s+779,149,3);
    Ra.sl[6]=3983; /* line # 3983 */
    if (V_typ_std.v[7]==NULL) {
      Ra.sl[6]=3985; /* line # 3985 */
      V_typ_std.v[7]=Rv1;
    }
    break;
    case 23:
    case 38:Ra.sl[6]=3991; /* line # 3991 */
    P_insymbol();
    Ra.sl[6]=3992; /* line # 3992 */
    if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
      Ra.sl[6]=3993; /* line # 3993 */
      Rv1=PAS_COMILER_PRC_00000002(V_sy_sym.ub[0]==77,NULL);
    }
    else {
      Ra.sl[6]=3996; /* line # 3996 */
      P_ide_new_typ(5, &Rv1);
      Ra.sl[6]=3997; /* line # 3997 */
      Rv31=Rv1;
      Ra.sl[6]=3999; /* line # 3999 */
      ((V *)Rv31)[3]=F_owid;
      Ra.sl[6]=4000; /* line # 4000 */
      memcpy(Rv31+48,V_typ_std.v[13]+48,1);
      Ra.sl[6]=4001; /* line # 4001 */
      ((SL *)Rv31)[11]=V_fptr_size;
      Ra.sl[6]=4002; /* line # 4002 */
      ((V *)Rv31)[0]=V_typ_std.v[13];
      Ra.sl[6]=4003; /* line # 4003 */
      V_err_prt=0;
      Ra.sl[6]=4004; /* line # 4004 */
      Rv2=P_ide_search(2);
      Ra.sl[6]=4005; /* line # 4005 */
      V_err_prt=1;
      Ra.sl[6]=4006; /* line # 4006 */
      if (Rv2==NULL) {
        Ra.sl[6]=4008; /* line # 4008 */
        P_ide_new(1, Rv1, &Rv2);
        Ra.sl[6]=4009; /* line # 4009 */
        ((V *)Rv2)[7]=Lx[5].v[1];
        Ra.sl[6]=4010; /* line # 4010 */
        Lx[5].v[1]=Rv2;
      }
      else {
        Ra.sl[6]=4012; /* line # 4012 */
        ((V *)Rv31)[12]=((V *)Rv2)[5];
      }
      Ra.sl[6]=4013; /* line # 4013 */
      P_insymbol();
      Ra.sl[6]=4015; /* line # 4015 */
      V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[5],0,128,NULL,0,0);
    }
    break;
    case 13:Ra.sl[6]=4021; /* line # 4021 */
    if (V_ima_typ!=NULL) {
      Ra.sl[6]=4022; /* line # 4022 */
      if (((V *)V_ima_typ)[4]!=NULL) {
        Ra.sl[6]=4024; /* line # 4024 */
        P_insymbol();
        Ra.sl[6]=4025; /* line # 4025 */
        if (((SL *)V_typ_std.v[1])[30]==0) {
          Ra.sl[6]=4026; /* line # 4026 */
          Rv1=V_typ_std.v[1];
        }
        else {
          Ra.sl[6]=4028; /* line # 4028 */
          P_ide_new_typ(1, &Rv1);
        }
        Ra.sl[6]=4029; /* line # 4029 */
        Rv32=Rv1;
        Ra.sl[6]=4031; /* line # 4031 */
        ((V *)Rv32)[3]=F_owid;
        Ra.sl[6]=4032; /* line # 4032 */
        ((SL *)Rv32)[11]=((SL *)V_typ_std.v[0])[11];
        Ra.sl[6]=4033; /* line # 4033 */
        ((SL *)Rv32)[29]=0;
        Ra.sl[6]=4034; /* line # 4034 */
        ((SL *)Rv32)[30]=-1;
        ((V *)Rv32)[0]=NULL;
        Ra.sl[6]=4035; /* line # 4035 */
        ((UB *)Rv32)[112]=1;
        Ra.sl[6]=4036; /* line # 4036 */
        memcpy(Rv32+48,V_typ_std.v[0]+48,1);
        Ra.sl[6]=4037; /* line # 4037 */
        Rv25=0;
        Ra.sl[6]=4038; /* line # 4038 */
        Rv33=NULL;
        Ra.sl[6]=4039; /* line # 4039 */
        Rv11=0;
        Ra.sl[6]=4040; /* line # 4040 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=4042; /* line # 4042 */
          if (V_sy_ident.ub[0]>Rv25) Rv25=V_sy_ident.ub[0];
          Ra.sl[6]=4043; /* line # 4043 */
          P_ide_new(4, Rv1, &Rv2);
          Ra.sl[6]=4045; /* line # 4045 */
          if (((V *)Rv32)[12]==NULL) ((V *)Rv32)[12]=Rv2;
          Ra.sl[6]=4046; /* line # 4046 */
          ((SL *)Rv32)[30]=((SL *)Rv32)[30]+1;
          Ra.sl[6]=4047; /* line # 4047 */
          Rv34=Rv2;
          Ra.sl[6]=4050; /* line # 4050 */
          P_val_new(((V *)Rv34)+7,Rv1);
          Ra.sl[6]=4051; /* line # 4051 */
          Rv35=((V *)Rv34)[7];
          Ra.sl[6]=4053; /* line # 4053 */
          ((UB *)Rv35)[48]=1;
          Ra.sl[6]=4054; /* line # 4054 */
          ((SL *)Rv35)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=4056; /* line # 4056 */
          Rv36=NULL;
          Ra.sl[6]=4058; /* line # 4058 */
          P_val_new(&Rv36,NULL);
          Ra.sl[6]=4060; /* line # 4060 */
          if (Rv33==NULL) Rv33=Rv36;
          else {
            Ra.sl[6]=4061; /* line # 4061 */
            ((V *)Rv37)[0]=Rv36;
          }
          Ra.sl[6]=4062; /* line # 4062 */
          Rv37=Rv36;
          Ra.sl[6]=4063; /* line # 4063 */
          Rv38=Rv36;
          Ra.sl[6]=4065; /* line # 4065 */
          ((UB *)Rv38)[48]=29;
          Ra.sl[6]=4066; /* line # 4066 */
          ((SL *)Rv38)[6]=0;
          Ra.sl[6]=4067; /* line # 4067 */
          Rv39=V_sy_ident.ub[0]+1;
          ((V *)Rv38)[7]=PAS__NEW((SL)Rv39+2);
          ((UB *)((V *)Rv38)[7])[0]=Rv39;
          Ra.sl[6]=4068; /* line # 4068 */
          ((V *)Rv38)[4]=((V *)V_ima_typ)[14];
          Ra.sl[6]=4069; /* line # 4069 */
          Rv40=((V *)Rv38)[7];
          Ra.sl[6]=4071; /* line # 4071 */
          ((UB *)Rv40)[1]=V_sy_ident.ub[0]+1;
          Ra.sl[6]=4072; /* line # 4072 */
          ((C *)Rv40)[2]=V_sy_ident.c[0];
          Ra.sl[6]=4073; /* line # 4073 */
          Rv41=1;
          for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
            Ra.sl[6]=4074; /* line # 4074 */
            ((C *)Rv40)[(Rv41+1)+1]=V_sy_ident.c[Rv41];
            Rv41++;
          }
          Ra.sl[6]=4078; /* line # 4078 */
          P_insymbol();
          Ra.sl[6]=4079; /* line # 4079 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=4081; /* line # 4081 */
            if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+779,23,2);
          }
          Ra.sl[6]=4082; /* line # 4082 */
          if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+779,27,2);
        }
        Ra.sl[6]=4084; /* line # 4084 */
        P_insymbol();
        Ra.sl[6]=4086; /* line # 4086 */
        Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv25);
        Ra.sl[6]=4087; /* line # 4087 */
        Rv7=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv32)[30]);
        Ra.sl[6]=4088; /* line # 4088 */
        ((V *)Rv7)[0]=Rv6;
        Ra.sl[6]=4089; /* line # 4089 */
        Rv42=P_type_parm_set(((V *)V_ima_typ)[3],Rv7);
        Ra.sl[6]=4091; /* line # 4091 */
        Rv36=Rv33;
        Ra.sl[6]=4092; /* line # 4092 */
        while (Rv36!=NULL){
          Ra.sl[6]=4093; /* line # 4093 */
          Rv43=Rv36;
          Ra.sl[6]=4095; /* line # 4095 */
          ((SL *)Rv43)[6]=Rv25+1;
          Ra.sl[6]=4096; /* line # 4096 */
          Rv36=((V *)Rv43)[0];
        }
        Ra.sl[6]=4100; /* line # 4100 */
        Rv44=((V *)V_ima_typ)[4];
        Ra.sl[6]=4101; /* line # 4101 */
        if (((V *)Rv44)[3]!=NULL) {
          Ra.sl[6]=4103; /* line # 4103 */
          P_val_new(&Rv36,((V *)((V *)Rv44)[3])[5]);
          Ra.sl[6]=4104; /* line # 4104 */
          Rv45=Rv36;
          Rv46=((V *)Rv44)[3];
          Ra.sl[6]=4106; /* line # 4106 */
          ((SL *)Rv45)[13]=Rv25;
          Ra.sl[6]=4107; /* line # 4107 */
          if (((V *)Rv46)[5]!=NULL) ((SL *)Rv45)[6]=((SL *)((V *)Rv46)[5])[11];
          Ra.sl[6]=4108; /* line # 4108 */
          ((V *)Rv45)[0]=Rv33;
          Ra.sl[6]=4110; /* line # 4110 */
          Rv33=Rv36;
          Ra.sl[6]=4111; /* line # 4111 */
          Rv36=NULL;
          P_val_new(&Rv36,((V *)Rv44)[5]);
          Ra.sl[6]=4112; /* line # 4112 */
          Rv47=Rv36;
          Ra.sl[6]=4114; /* line # 4114 */
          ((SL *)Rv47)[13]=((SL *)Rv32)[30];
          Ra.sl[6]=4115; /* line # 4115 */
          if (((V *)Rv44)[5]!=NULL) ((SL *)Rv47)[6]=((SL *)((V *)Rv44)[5])[11];
          Ra.sl[6]=4116; /* line # 4116 */
          ((V *)Rv47)[0]=Rv33;
          Ra.sl[6]=4118; /* line # 4118 */
          Rv33=Rv36;
        }
        Ra.sl[6]=4120; /* line # 4120 */
        P_lgt_new(((V *)Rv32)+13,Rv42,14,NULL);
        Ra.sl[6]=4121; /* line # 4121 */
        P_val_new(((V *)((V *)Rv32)[13])+7,Rv42);
        Ra.sl[6]=4122; /* line # 4122 */
        Rv48=((V *)Rv32)[13];
        Rv49=((V *)Rv48)[7];
        Ra.sl[6]=4124; /* line # 4124 */
        ((SL *)Rv49)[6]=((SL *)Rv42)[11];
        Ra.sl[6]=4125; /* line # 4125 */
        ((V *)Rv49)[7]=Rv33;
        Ra.sl[6]=4127; /* line # 4127 */
        if (((SL *)Rv32)[30]>255) {
          Ra.sl[6]=4130; /* line # 4130 */
          if (((SL *)Rv32)[30]>65535) ((SL *)Rv32)[11]=4;
          else {
            Ra.sl[6]=4131; /* line # 4131 */
            ((SL *)Rv32)[11]=2;
          }
        }
        Ra.sl[6]=4134; /* line # 4134 */
        Rv11=((SL *)Rv32)[11];
        Ra.sl[6]=4135; /* line # 4135 */
        Rv12=Rv11-1;
        Ra.sl[6]=4136; /* line # 4136 */
        PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
        Ra.sl[6]=4137; /* line # 4137 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
        Ra.sl[6]=4138; /* line # 4138 */
        if (Rv11<((SL *)Rv32)[11]) P_src_error(Rd.s+779,214,2);
        else {
          Ra.sl[6]=4139; /* line # 4139 */
          ((SL *)Rv32)[11]=Rv11;
        }
        Ra.sl[6]=4140; /* line # 4140 */
        if (Rv12>=0) ((UB *)Rv32)[48]=Rv12;
        Ra.sl[6]=4143; /* line # 4143 */
        V_sy_type_gfirst=P_new_oper(0, Rv1, V_typ_std.v[15],0,0,NULL,0,0);
      }
    }
    break;
    case 42:Ra.sl[6]=4148; /* line # 4148 */
    P_insymbol();
    Ra.sl[6]=4149; /* line # 4149 */
    if (V_sy_sym.ub[0]==87) P_insymbol();
    else P_src_error(Rd.s+779,51,2);
    Ra.sl[6]=4150; /* line # 4150 */
    PAS_COMILER_PRC_00000038(&Rv42,0,NULL,0,0,NULL);
    Ra.sl[6]=4151; /* line # 4151 */
    if (((UB *)Rv42)[93]>2) {
      Ra.sl[6]=4153; /* line # 4153 */
      P_src_error(Rd.s+779,215,3);
      Ra.sl[6]=4154; /* line # 4154 */
      Rv42=V_typ_std.v[1];
    }
    Ra.sl[6]=4157; /* line # 4157 */
    Rv13=((SL *)Rv42)[30]+1;
    Ra.sl[6]=4158; /* line # 4158 */
    if (Rv13>V_dst_seta) Rv13=V_dst_seta;
    Ra.sl[6]=4160; /* line # 4160 */
    Rv25=(Rv13+7)/8;
    Ra.sl[6]=4162; /* line # 4162 */
    if (Rv25>2) Rv25=((Rv25+3)/4)*4;
    Ra.sl[6]=4165; /* line # 4165 */
    if (Rv13>V_dst_setw) {
      Ra.sl[6]=4167; /* line # 4167 */
      P_ide_new_typ(12, &Rv1);
      Ra.sl[6]=4168; /* line # 4168 */
      Rv12=((UB *)V_typ_std.v[18])[48];
    }
    else {
      Ra.sl[6]=4172; /* line # 4172 */
      P_ide_new_typ(11, &Rv1);
      Ra.sl[6]=4173; /* line # 4173 */
      Rv11=1;
      Ra.sl[6]=4174; /* line # 4174 */
      switch (Rv25) {
        case 1:Ra.sl[6]=4175; /* line # 4175 */
        Rv12=0;
        break;
        case 2:Ra.sl[6]=4176; /* line # 4176 */
        Rv12=1;
        break;
        case 3:
        case 4:Ra.sl[6]=4177; /* line # 4177 */
        Rv12=3;
        break;
        default:Ra.sl[6]=4179; /* line # 4179 */
        Rv12=((UB *)V_typ_std.v[17])[48];
        break;
      }
    }
    Ra.sl[6]=4182; /* line # 4182 */
    Rv50=Rv1;
    Ra.sl[6]=4184; /* line # 4184 */
    ((V *)Rv50)[3]=F_owid;
    Ra.sl[6]=4185; /* line # 4185 */
    ((SL *)Rv50)[24]=Rv13;
    Ra.sl[6]=4186; /* line # 4186 */
    ((V *)Rv50)[13]=Rv42;
    Ra.sl[6]=4187; /* line # 4187 */
    ((SL *)Rv50)[11]=Rv25;
    Ra.sl[6]=4188; /* line # 4188 */
    Rv11=Rv25;
    Ra.sl[6]=4189; /* line # 4189 */
    PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
    Ra.sl[6]=4191; /* line # 4191 */
    if (Rv25>Rv11) {
      Ra.sl[6]=4193; /* line # 4193 */
      P_src_error(Rd.s+779,214,1);
      Ra.sl[6]=4194; /* line # 4194 */
      Rv11=Rv25;
    }
    Ra.sl[6]=4197; /* line # 4197 */
    ((SL *)Rv50)[11]=Rv11;
    Ra.sl[6]=4198; /* line # 4198 */
    if (Rv12>=0) ((UB *)Rv50)[48]=Rv12;
    Ra.sl[6]=4200; /* line # 4200 */
    if (Rv42!=NULL) {
      Ra.sl[6]=4201; /* line # 4201 */
      Rv51=Rv42;
      Ra.sl[6]=4202; /* line # 4202 */
      if (((UB *)Rv51)[93]==2) {
        Ra.sl[6]=4203; /* line # 4203 */
        Rv52=V_usi_tab;
        Ra.sl[6]=4205; /* line # 4205 */
        P_lgt_new(((V *)Rv51)+13,((V *)Rv52)[5],14,NULL);
        Ra.sl[6]=4206; /* line # 4206 */
        P_val_copy(((V *)Rv52)+7,((V *)((V *)Rv51)[13])+7,0);
      }
      else {
        Ra.sl[6]=4208; /* line # 4208 */
        if (((UB *)Rv51)[93]==0) {
          Ra.sl[6]=4209; /* line # 4209 */
          Rv53=V_csi_tab;
          Ra.sl[6]=4211; /* line # 4211 */
          P_lgt_new(((V *)Rv51)+13,((V *)Rv53)[5],14,NULL);
          Ra.sl[6]=4212; /* line # 4212 */
          P_val_copy(((V *)Rv53)+7,((V *)((V *)Rv51)[13])+7,0);
        }
      }
    }
    break;
    case 44:Ra.sl[6]=4219; /* line # 4219 */
    P_src_error(Rd.s+779,219,2);
    Ra.sl[6]=4220; /* line # 4220 */
    Rv1=NULL;
    break;
    case 56:Ra.sl[6]=4225; /* line # 4225 */
    Rv6=PAS_COMILER_PRC_00000004(2,NULL);
    Ra.sl[6]=4226; /* line # 4226 */
    Rv1=((V *)Rv6)[3];
    P_lgt_free(&Rv6);
    break;
    default:Ra.sl[6]=4231; /* line # 4231 */
    Rv1=NULL;
    Ra.sl[6]=4232; /* line # 4232 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=4234; /* line # 4234 */
      Rv2=P_ide_search(534);
      Ra.sl[6]=4235; /* line # 4235 */
      Rv1=((V *)Rv2)[5];
      Ra.sl[6]=4236; /* line # 4236 */
      if (Rv2!=V_ide_udptr.v[1]) {
        Ra.sl[6]=4238; /* line # 4238 */
        if (((UB *)Rv2)[53]==1) {
          Ra.sl[6]=4240; /* line # 4240 */
          Rv1=((V *)Rv2)[5];
          Ra.sl[6]=4241; /* line # 4241 */
          P_insymbol();
          Ra.sl[6]=4243; /* line # 4243 */
          V_sy_type_gfirst=((V *)Rv2)[10];
          Ra.sl[6]=4244; /* line # 4244 */
          if (V_sy_sym.ub[0]==13) {
            Ra.sl[6]=4246; /* line # 4246 */
            Rv3=Rv2;
            Ra.sl[6]=4247; /* line # 4247 */
            if (((V *)((V *)Rv3)[5])[4]==NULL) {
              Ra.sl[6]=4249; /* line # 4249 */
              P_src_error(Rd.s+779,206,2);
              Ra.sl[6]=4250; /* line # 4250 */
              P_skip_symbol(14,0,0);
            }
            else {
              Ra.sl[6]=4254; /* line # 4254 */
              Rv4=NULL;
              Ra.sl[6]=4255; /* line # 4255 */
              Rv5=((V *)((V *)Rv3)[5])[4];
              Ra.sl[6]=4256; /* line # 4256 */
              V_sy_sym.ub[0]=17;
              Ra.sl[6]=4257; /* line # 4257 */
              while (Rv5!=NULL){
                Ra.sl[6]=4259; /* line # 4259 */
                if (V_sy_sym.ub[0]==17) P_insymbol();
                Ra.sl[6]=4260; /* line # 4260 */
                if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==14) {
                  Ra.sl[6]=4261; /* line # 4261 */
                  if (((V *)Rv5)[10]!=NULL) {
                    Ra.sl[6]=4263; /* line # 4263 */
                    P_lgt_new(&Rv6,((V *)Rv5)[5],14,NULL);
                    Ra.sl[6]=4264; /* line # 4264 */
                    ((V *)Rv6)[7]=((V *)Rv5)[10];
                    Ra.sl[6]=4265; /* line # 4265 */
                    P_val_new(((V *)Rv5)+10,((V *)Rv5)[5]);
                  }
                  else {
                    Ra.sl[6]=4267; /* line # 4267 */
                    P_src_error_s(Rd.s+779,228,3,((V *)Rv5)[0],NULL);
                  }
                }
                else {
                  Ra.sl[6]=4269; /* line # 4269 */
                  Rv6=PAS_COMILER_PRC_00000005(((V *)Rv5)[5],0,0,0);
                }
                Ra.sl[6]=4271; /* line # 4271 */
                if (Rv4==NULL) Rv4=Rv6;
                else {
                  Ra.sl[6]=4272; /* line # 4272 */
                  ((V *)Rv7)[0]=Rv6;
                }
                Ra.sl[6]=4273; /* line # 4273 */
                Rv7=Rv6;
                Ra.sl[6]=4274; /* line # 4274 */
                Rv5=((V *)Rv5)[3];
              }
              Ra.sl[6]=4276; /* line # 4276 */
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else {
                Ra.sl[6]=4277; /* line # 4277 */
                P_src_error(Rd.s+779,23,2);
              }
              Ra.sl[6]=4278; /* line # 4278 */
              Rv1=P_type_parm_set(Rv2, Rv4);
            }
          }
          else {
            Ra.sl[6]=4282; /* line # 4282 */
            Rv8=Rv2;
            Ra.sl[6]=4284; /* line # 4284 */
            if (((UB *)((V *)Rv8)[5])[93]==24) {
              Ra.sl[6]=4286; /* line # 4286 */
              if (V_sy_sym.ub[0]==87) {
                Ra.sl[6]=4288; /* line # 4288 */
                P_insymbol();
                Ra.sl[6]=4289; /* line # 4289 */
                Rv9=P_ide_search(2);
                Ra.sl[6]=4290; /* line # 4290 */
                P_insymbol();
                Ra.sl[6]=4291; /* line # 4291 */
                if (Rv9!=V_ide_udptr.v[1]) {
                  Ra.sl[6]=4293; /* line # 4293 */
                  P_ide_new_typ(24, &Rv1);
                  Ra.sl[6]=4294; /* line # 4294 */
                  Rv10=Rv1;
                  Ra.sl[6]=4296; /* line # 4296 */
                  ((V *)Rv10)[0]=((V *)Rv8)[5];
                  Ra.sl[6]=4297; /* line # 4297 */
                  ((V *)Rv10)[12]=((V *)Rv9)[5];
                  Ra.sl[6]=4298; /* line # 4298 */
                  ((V *)Rv10)[4]=((V *)((V *)Rv10)[12])[4];
                  Ra.sl[6]=4299; /* line # 4299 */
                  ((SL *)Rv10)[10]=0;
                  Ra.sl[6]=4301; /* line # 4301 */
                  V_sy_type_gfirst=((V *)Rv8)[10];
                  Ra.sl[6]=4302; /* line # 4302 */
                  ((V *)Rv10)[9]=NULL;
                  Ra.sl[6]=4303; /* line # 4303 */
                  ((SL *)Rv10)[11]=((SL *)((V *)Rv8)[5])[11];
                  Ra.sl[6]=4304; /* line # 4304 */
                  ((UB *)Rv10)[91]=((UB *)((V *)Rv8)[5])[91];
                }
              }
              else Ra.sl[6]=4312; /* line # 4312 */
            }
            Ra.sl[6]=4313; /* line # 4313 */
            ((UB *)Rv1)[91]=((UB *)((V *)Rv8)[5])[91]||((SL *)((V *)Rv8)[5])[10]
            >0;
          }
        }
        else {
          Ra.sl[6]=4316; /* line # 4316 */
          Rv1=NULL;
        }
      }
    }
    Ra.sl[6]=4319; /* line # 4319 */
    if (Rv1==NULL) {
      Ra.sl[6]=4322; /* line # 4322 */
      Rv6=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,0,1);
      Ra.sl[6]=4323; /* line # 4323 */
      if (V_sy_sym.ub[0]==20) P_insymbol();
      else P_src_error(Rd.s+779,28,2);
      Ra.sl[6]=4324; /* line # 4324 */
      Rv7=PAS_COMILER_PRC_00000005(((V *)Rv6)[3],0,0,1);
      Ra.sl[6]=4325; /* line # 4325 */
      Rv11=((SL *)((V *)Rv6)[3])[11];
      Ra.sl[6]=4326; /* line # 4326 */
      Rv12=((UB *)((V *)Rv6)[3])[48];
      Ra.sl[6]=4327; /* line # 4327 */
      PAS_COMILER_PRC_00000040(&Rv11, &Rv12);
      Ra.sl[6]=4328; /* line # 4328 */
      if (Rv11<4) Rv13=PAS__IIPOWER(2,8*Rv11);
      else Rv13=2147483647;
      Ra.sl[6]=4329; /* line # 4329 */
      Rv14=Rv6;
      Ra.sl[6]=4330; /* line # 4330 */
      if (((UB *)Rv14)[40]==14&&((UB *)Rv7)[40]==14) {
        Ra.sl[6]=4332; /* line # 4332 */
        P_ide_new_typ_range(((SL *)((V *)Rv14)[7])[13],((SL *)((V *)Rv7)[7])[13]
        ,((V *)Rv14)[3],&Rv1);
        Ra.sl[6]=4335; /* line # 4335 */
        if (V_sy_init_mod&&V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
        Ra.sl[6]=4336; /* line # 4336 */
        P_lgt_free(&Rv6);
        P_lgt_free(&Rv7);
        Ra.sl[6]=4337; /* line # 4337 */
        Rv15=Rv1;
        Ra.sl[6]=4339; /* line # 4339 */
        ((UB *)Rv15)[112]=((SL *)Rv15)[29]>=0;
        Ra.sl[6]=4340; /* line # 4340 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4342; /* line # 4342 */
          if (((UB *)Rv15)[112]) {
            Ra.sl[6]=4344; /* line # 4344 */
            if (((UL *)Rv15)[29]>((UL *)Rv15)[30]) {
              Ra.sl[6]=4346; /* line # 4346 */
              ((UL *)Rv15)[30]=((UL *)Rv15)[29];
              Ra.sl[6]=4347; /* line # 4347 */
              P_src_error(Rd.s+779,211,2);
            }
          }
          else {
            Ra.sl[6]=4351; /* line # 4351 */
            if (((SL *)Rv15)[29]>((SL *)Rv15)[30]) {
              Ra.sl[6]=4353; /* line # 4353 */
              ((SL *)Rv15)[30]=((SL *)Rv15)[29];
              Ra.sl[6]=4354; /* line # 4354 */
              P_src_error(Rd.s+779,211,2);
            }
          }
          Ra.sl[6]=4356; /* line # 4356 */
          if (((UB *)Rv15)[112]) {
            Ra.sl[6]=4358; /* line # 4358 */
            switch (Rv11) {
              case 1:Ra.sl[6]=4359; /* line # 4359 */
              Rv13=256;
              break;
              case 2:
              case 3:Ra.sl[6]=4360; /* line # 4360 */
              Rv13=65536;
              break;
              default:Ra.sl[6]=4362; /* line # 4362 */
              Rv13=2147483647;
              break;
            }
            Ra.sl[6]=4364; /* line # 4364 */
            if (Rv11<4) {
              Ra.sl[6]=4365; /* line # 4365 */
              if (((UL *)Rv15)[30]>=Rv13) {
                Ra.sl[6]=4367; /* line # 4367 */
                ((UL *)Rv15)[30]=Rv13-1;
                ((UL *)Rv15)[29]=0;
                Ra.sl[6]=4368; /* line # 4368 */
                P_src_error(Rd.s+779,212,2);
                Rv12=0;
              }
            }
          }
          else {
            Ra.sl[6]=4373; /* line # 4373 */
            switch (Rv11) {
              case 1:Ra.sl[6]=4374; /* line # 4374 */
              Rv13=128;
              break;
              case 2:
              case 3:Ra.sl[6]=4375; /* line # 4375 */
              Rv13=32768;
              break;
              default:Ra.sl[6]=4377; /* line # 4377 */
              Rv13=2147483647;
              break;
            }
            Ra.sl[6]=4379; /* line # 4379 */
            if (((SL *)Rv15)[30]>=Rv13||((SL *)Rv15)[29]< -Rv13) {
              Ra.sl[6]=4381; /* line # 4381 */
              Rv11=4;
              ((SL *)Rv15)[30]=Rv13-1;
              ((SL *)Rv15)[29]= -Rv13;
              Ra.sl[6]=4382; /* line # 4382 */
              P_src_error(Rd.s+779,213,2);
              Rv12=0;
            }
          }
        }
      }
      else {
        Ra.sl[6]=4390; /* line # 4390 */
        P_ide_new_typ(22, &Rv1);
        Ra.sl[6]=4391; /* line # 4391 */
        Rv16=Rv1;
        Ra.sl[6]=4393; /* line # 4393 */
        ((V *)Rv16)[0]=((V *)Rv14)[3];
        Ra.sl[6]=4394; /* line # 4394 */
        if (V_sy_fix_range_ctl) {
          Ra.sl[6]=4396; /* line # 4396 */
          P_type_check_parm(Rv6);
          Ra.sl[6]=4397; /* line # 4397 */
          P_type_check_parm(Rv7);
        }
        Ra.sl[6]=4399; /* line # 4399 */
        if (((UB *)Rv7)[40]!=14) {
          Ra.sl[6]=4401; /* line # 4401 */
          ((V *)Rv16)[14]=P_lgt_new_code(0, Rv7);
        }
        else {
          Ra.sl[6]=4404; /* line # 4404 */
          ((V *)Rv16)[14]=Rv7;
        }
        Ra.sl[6]=4406; /* line # 4406 */
        ((V *)((V *)Rv16)[14])[3]=Rv1;
        Ra.sl[6]=4407; /* line # 4407 */
        if (((UB *)Rv6)[40]==14) {
          Ra.sl[6]=4408; /* line # 4408 */
          Rv17=Rv6;
          Ra.sl[6]=4410; /* line # 4410 */
          ((V *)Rv16)[13]=Rv6;
          Ra.sl[6]=4411; /* line # 4411 */
          ((V *)Rv17)[3]=Rv1;
          Ra.sl[6]=4412; /* line # 4412 */
          if (((SL *)((V *)Rv17)[7])[13]==1) {
            Ra.sl[6]=4414; /* line # 4414 */
            ((V *)Rv16)[12]=P_lgt_new_code(0, Rv7);
          }
          else {
            Ra.sl[6]=4418; /* line # 4418 */
            ((V *)((V *)Rv16)[14])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)((V
             *)Rv17)[7])[13]-1);
            Ra.sl[6]=4421; /* line # 4421 */
            ((V *)Rv16)[12]=P_lgt_new_code(50,((V *)Rv16)[14]);
          }
        }
        else {
          Ra.sl[6]=4427; /* line # 4427 */
          ((V *)Rv16)[13]=P_lgt_new_code(0, Rv6);
          Ra.sl[6]=4428; /* line # 4428 */
          ((V *)((V *)Rv16)[13])[3]=Rv1;
          Ra.sl[6]=4429; /* line # 4429 */
          if (((UB *)Rv7)[40]==14) {
            Ra.sl[6]=4433; /* line # 4433 */
            Rv13=((SL *)((V *)Rv7)[7])[13]+1;
            Ra.sl[6]=4434; /* line # 4434 */
            if (Rv13==0) {
              Ra.sl[6]=4436; /* line # 4436 */
              ((V *)Rv16)[12]=P_lgt_new_code(46,((V *)Rv16)[14]);
            }
            else {
              Ra.sl[6]=4439; /* line # 4439 */
              Rv6=P_lgt_new_econst(V_typ_std.v[2],Rv13);
              Ra.sl[6]=4440; /* line # 4440 */
              ((V *)Rv6)[0]=((V *)Rv16)[13];
              Ra.sl[6]=4441; /* line # 4441 */
              ((V *)Rv16)[12]=P_lgt_new_code(50, Rv6);
            }
          }
          else {
            Ra.sl[6]=4446; /* line # 4446 */
            ((V *)((V *)Rv16)[14])[0]=((V *)Rv16)[13];
            Ra.sl[6]=4447; /* line # 4447 */
            Rv6=P_lgt_new_code(50,((V *)Rv16)[14]);
            Ra.sl[6]=4448; /* line # 4448 */
            ((V *)Rv16)[12]=P_lgt_new_code(43, Rv6);
          }
        }
      }
      Ra.sl[6]=4455; /* line # 4455 */
      Rv18=Rv1;
      Ra.sl[6]=4457; /* line # 4457 */
      ((V *)Rv18)[3]=F_owid;
      Ra.sl[6]=4458; /* line # 4458 */
      ((SL *)Rv18)[11]=Rv11;
      Ra.sl[6]=4459; /* line # 4459 */
      if (Rv12>=0) ((UB *)Rv18)[48]=Rv12;
    }
    break;
  }
  Ra.sl[6]=4465; /* line # 4465 */
  (*F_it)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_decl_attribute "  */
void PAS_COMILER_PRC_00000043(UB F_bvr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;

  /* Code of procedure/function */
  Rv0=0;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+783;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4541; /* line # 4541 */
  while (1){
    Ra.sl[6]=4543; /* line # 4543 */
    P_insymbol();
    Ra.sl[6]=4544; /* line # 4544 */
    if (V_sy_sym.ub[0]!=0) {
      Ra.sl[6]=4545; /* line # 4545 */
      if (F_bvr) {
        Ra.sl[6]=4547; /* line # 4547 */
        F_bvr=0;
        Ra.sl[6]=4548; /* line # 4548 */
        switch (V_sy_sym.ub[0]) {
          case 80:
          case 81:Ra.sl[6]=4550; /* line # 4550 */
          Lx[5].ub[16]=2;
          break;
          case 82:Ra.sl[6]=4551; /* line # 4551 */
          Lx[5].ub[16]=3;
          break;
          case 84:Ra.sl[6]=4552; /* line # 4552 */
          Lx[5].ub[16]=4;
          Rv0=1;
          break;
          case 83:Ra.sl[6]=4553; /* line # 4553 */
          Lx[5].ub[16]=5;
          Rv0=1;
          break;
          case 85:Ra.sl[6]=4554; /* line # 4554 */
          if (V_sy_init_mod) {
            Ra.sl[6]=4555; /* line # 4555 */
            Lx[5].ub[16]=6;
            Rv0=1;
          }
          else {
            Ra.sl[6]=4556; /* line # 4556 */
            P_src_error(Rd.s+805,992,2);
          }
          break;
          default:Ra.sl[6]=4558; /* line # 4558 */
          P_src_error(Rd.s+805,163,2);
          break;
        }
      }
      else {
        Ra.sl[6]=4561; /* line # 4561 */
        P_src_error(Rd.s+805,170,2);
      }
    }
    else {
      Ra.sl[6]=4564; /* line # 4564 */
      Rv1=P_level_search(V_attr_list);
      Ra.sl[6]=4565; /* line # 4565 */
      if (Rv1!=NULL) {
        Ra.sl[6]=4566; /* line # 4566 */
        switch (((UB *)Rv1)[54]) {
          case 23:Ra.sl[6]=4567; /* line # 4567 */
          Rs.sl[0]=1;
          break;
          case 24:Ra.sl[6]=4568; /* line # 4568 */
          Rs.sl[0]=2;
          break;
          case 25:Ra.sl[6]=4569; /* line # 4569 */
          Rs.sl[0]=4;
          break;
          case 26:Ra.sl[6]=4570; /* line # 4570 */
          Rs.sl[0]=8;
          break;
          default:Ra.sl[6]=4572; /* line # 4572 */
          P_src_error_s(Rd.s+805,165,2, V_sy_ident.s,NULL);
          break;
        }
      }
      else {
        Ra.sl[6]=4575; /* line # 4575 */
        P_src_error(Rd.s+805,162,2);
      }
    }
    Ra.sl[6]=4577; /* line # 4577 */
    P_insymbol();
    Ra.sl[6]=4578; /* line # 4578 */
    if (Rv0) {
      Ra.sl[6]=4580; /* line # 4580 */
      Lx[5].v[3]=NULL;
      Ra.sl[6]=4581; /* line # 4581 */
      P_set_strname(Lx[5].v+3);
    }
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=4585; /* line # 4585 */
  if (V_sy_sym.ub[0]==16) P_insymbol();
  else {
    Ra.sl[6]=4586; /* line # 4586 */
    P_src_error(Rd.s+805,26,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_setting "  */
void PAS_COMILER_PRC_00000037(UB F_v_class, SL *F_isz, SL *F_aln, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  UB Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  V Rv7;
  UW Rv8;
  UB Rv9;
  V Rv10;
  register V Rv11;
  UB Rv12;
  V Rv13;
  register V Rv14;
  register V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  UB Rv19;
  register V Rv20;
  V Rv21;
  register V Rv22;
  register V Rv23;
  register V Rv24;
  V Rv25;
  register V Rv26;
  register V Rv27;
  register V Rv28;
  register V Rv29;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+809;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=4615; /* line # 4615 */
  Rv0=0;
  Ra.sl[6]=4616; /* line # 4616 */
  Rv1=Lx[5].ub[16];
  Ra.sl[6]=4617; /* line # 4617 */
  Rv2=NULL;
  Ra.sl[6]=4618; /* line # 4618 */
  Lx[5].ub[16]=1;
  Ra.sl[6]=4619; /* line # 4619 */
  if (Lx[5].v[3]!=NULL) {
    Ra.sl[6]=4621; /* line # 4621 */
    P_src_error_s(Rd.s+826,166,1, Lx[5].v[3],NULL);
    Ra.sl[6]=4622; /* line # 4622 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[6]=4624; /* line # 4624 */
  Rv3=0;
  Ra.sl[6]=4625; /* line # 4625 */
  Rv4=NULL;
  Rv5=NULL;
  Ra.sl[6]=4627; /* line # 4627 */
  if (F_v_class==6) {
    Ra.sl[6]=4629; /* line # 4629 */
    ((V *)F_ty)[12]=V_lex_ident_tree.v[V_curr_disp*8+4];
  }
  Ra.sl[6]=4631; /* line # 4631 */
  Ra.sl[6]=4632; /* line # 4632 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==15){
    Ra.sl[6]=4634; /* line # 4634 */
    Rv6=NULL;
    Ra.sl[6]=4635; /* line # 4635 */
    Rv7=NULL;
    Ra.sl[6]=4636; /* line # 4636 */
    Rv8=96;
    while (1){
      Ra.sl[6]=4638; /* line # 4638 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4641; /* line # 4641 */
        if (V_sy_sym.ub[0]==15) {
          Ra.sl[6]=4649; /* line # 4649 */
          PAS_COMILER_PRC_00000043(F_v_class!=6);
          Ra.sl[6]=4653; /* line # 4653 */
          if (V_sy_sym.ub[0]==0) {
            Ra.sl[6]=4655; /* line # 4655 */
            Rv9=Lx[5].ub[16];
            Ra.sl[6]=4656; /* line # 4656 */
            Rv2=Lx[5].v[3];
            Ra.sl[6]=4657; /* line # 4657 */
            Lx[5].ub[16]=1;
            Ra.sl[6]=4658; /* line # 4658 */
            Lx[5].v[3]=NULL;
          }
          else {
            Ra.sl[6]=4660; /* line # 4660 */
            Rv0=1;
          }
        }
        else {
          Ra.sl[6]=4664; /* line # 4664 */
          Rv9=Rv1;
          Ra.sl[6]=4665; /* line # 4665 */
          Rv2=NULL;
        }
        Ra.sl[6]=4667; /* line # 4667 */
        if (!Rv0) {
          Ra.sl[6]=4669; /* line # 4669 */
          V_cmp_twicedclon=1;
          Ra.sl[6]=4670; /* line # 4670 */
          P_ide_new(5,NULL,&Rv10);
          Ra.sl[6]=4671; /* line # 4671 */
          V_cmp_twicedclon=0;
          Ra.sl[6]=4673; /* line # 4673 */
          if (Rv9!=1&&Rv2!=NULL) {
            Ra.sl[6]=4674; /* line # 4674 */
            Rv11=Rv10;
            Ra.sl[6]=4676; /* line # 4676 */
            if (((V *)Rv11)[8]!=NULL) {
              Ra.sl[6]=4677; /* line # 4677 */
              if (P_match(Rv2,((V *)Rv11)[8])!=0) {
                Ra.sl[6]=4678; /* line # 4678 */
                P_src_error_s(Rd.s+826,218,2,((V *)Rv11)[0],NULL);
              }
            }
            Ra.sl[6]=4679; /* line # 4679 */
            ((V *)Rv11)[8]=Rv2;
          }
        }
        break;
        case 2:Ra.sl[6]=4683; /* line # 4683 */
        P_ide_new(2,NULL,&Rv10);
        break;
        case 1:
        case 6:Ra.sl[6]=4685; /* line # 4685 */
        P_ide_new(6,NULL,&Rv10);
        break;
        default:break;
      }
      Ra.sl[6]=4689; /* line # 4689 */
      if (!Rv0) {
        Ra.sl[6]=4691; /* line # 4691 */
        if (!V_cmp_twicedcl) {
          Ra.sl[6]=4693; /* line # 4693 */
          if (Rv5!=NULL) ((V *)Rv5)[3]=Rv10;
          else {
            Ra.sl[6]=4695; /* line # 4695 */
            if (Rv4==NULL) Rv4=Rv10;
          }
          Ra.sl[6]=4696; /* line # 4696 */
          if (Rv6==NULL) Rv6=Rv10;
          Ra.sl[6]=4697; /* line # 4697 */
          Rv5=Rv10;
        }
        Ra.sl[6]=4699; /* line # 4699 */
        P_insymbol();
        Ra.sl[6]=4700; /* line # 4700 */
        if (V_sy_sym.ub[0]==17) P_insymbol();
        else {
          Ra.sl[6]=4701; /* line # 4701 */
          if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+826,29,2);
        }
        Ra.sl[6]=4702; /* line # 4702 */
        if (V_sy_sym.ub[0]==17) P_src_error(Rd.s+826,27,2);
      }
      if (V_sy_sym.ub[0]!=0&&V_sy_sym.ub[0]!=15)  break;
    }
    Ra.sl[6]=4706; /* line # 4706 */
    if (!Rv0) {
      Ra.sl[6]=4708; /* line # 4708 */
      P_insymbol();
      Ra.sl[6]=4710; /* line # 4710 */
      Rs.sl[1]=-1;
      Ra.sl[6]=4711; /* line # 4711 */
      Rs.sl[0]=-1;
      Ra.sl[6]=4712; /* line # 4712 */
      Rv12=0;
      Ra.sl[6]=4714; /* line # 4714 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        Ra.sl[6]=4715; /* line # 4715 */
        P_insymbol();
        Rv12=1;
      }
      Ra.sl[6]=4719; /* line # 4719 */
      if (V_sy_sym.ub[0]==15&&1<<F_v_class&112) {
        Ra.sl[6]=4721; /* line # 4721 */
        PAS_COMILER_PRC_00000043(F_v_class!=6);
        Ra.sl[6]=4722; /* line # 4722 */
        Rv9=Lx[5].ub[16];
      }
      Ra.sl[6]=4777; /* line # 4777 */
      if (V_sy_sym.ub[0]==43&&F_v_class==5) {
        Ra.sl[6]=4778; /* line # 4778 */
        P_insymbol();
        Rv12=1;
      }
      Ra.sl[6]=4783; /* line # 4783 */
      if (Rv9==1&&Rv1!=1) {
        Ra.sl[6]=4784; /* line # 4784 */
        Rv9=Rv1;
        Rv2=NULL;
      }
      Ra.sl[6]=4786; /* line # 4786 */
      PAS_COMILER_PRC_00000038(&Rv13,0,NULL,0,0,NULL);
      Ra.sl[6]=4788; /* line # 4788 */
      switch (F_v_class) {
        case 5:Ra.sl[6]=4792; /* line # 4792 */
        if (((SL *)Rv13)[11]<0&&((V *)Rv13)[1]!=NULL) {
          Ra.sl[6]=4793; /* line # 4793 */
          Rv13=((V *)Rv13)[1];
        }
        break;
        case 2:Ra.sl[6]=4795; /* line # 4795 */
        if (Rv13!=NULL) {
          Ra.sl[6]=4796; /* line # 4796 */
          Rv14=Rv13;
          Ra.sl[6]=4798; /* line # 4798 */
          switch (((UB *)Rv14)[93]) {
            case 0:
            case 1:
            case 2:break;
            default:Ra.sl[6]=4801; /* line # 4801 */
            P_src_error(Rd.s+826,207,3);
            break;
          }
        }
        break;
        case 6:Ra.sl[6]=4805; /* line # 4805 */
        Rv15=Rv13;
        Ra.sl[6]=4807; /* line # 4807 */
        if (((UB *)Rv15)[91]||((SL *)Rv15)[10]>0) Lx[5].ub[0]=1;
        break;
        default:break;
      }
      Ra.sl[6]=4813; /* line # 4813 */
      Rv16=Rv13;
      Ra.sl[6]=4815; /* line # 4815 */
      if (Rv3<((UB *)Rv16)[48]) Rv3=((UB *)Rv16)[48];
      Ra.sl[6]=4817; /* line # 4817 */
      Rv7=((V *)Rv16)[10];
      Ra.sl[6]=4820; /* line # 4820 */
      if (F_v_class==5) {
        Ra.sl[6]=4822; /* line # 4822 */
        if (Rv9==1) {
          Ra.sl[6]=4823; /* line # 4823 */
          switch (V_sy_sym.ub[0]) {
            case 80:Ra.sl[6]=4824; /* line # 4824 */
            Rv9=2;
            P_insymbol();
            break;
            case 84:Ra.sl[6]=4825; /* line # 4825 */
            Rv9=4;
            P_insymbol();
            break;
            case 83:Ra.sl[6]=4826; /* line # 4826 */
            Rv9=5;
            P_insymbol();
            break;
            default:break;
          }
        }
        Ra.sl[6]=4829; /* line # 4829 */
        if (V_sy_sym.ub[0]==26) {
          Ra.sl[6]=4831; /* line # 4831 */
          Rv8=32;
          Ra.sl[6]=4832; /* line # 4832 */
          P_insymbol();
        }
      }
      Ra.sl[6]=4836; /* line # 4836 */
      if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
        Ra.sl[6]=4837; /* line # 4837 */
        if (F_v_class==6) {
          Ra.sl[6]=4839; /* line # 4839 */
          P_src_error(Rd.s+826,220,2);
        }
        else {
          Ra.sl[6]=4843; /* line # 4843 */
          P_insymbol();
          Ra.sl[6]=4844; /* line # 4844 */
          if (V_sy_sym.ub[0]!=13&&V_sy_sym.ub[0]!=15) {
            Ra.sl[6]=4845; /* line # 4845 */
            Rv17=PAS_COMILER_PRC_00000005(Rv13,0,0,0);
          }
          else {
            Ra.sl[6]=4847; /* line # 4847 */
            Rv17=PAS_COMILER_PRC_00000019(Rv13);
          }
          Ra.sl[6]=4849; /* line # 4849 */
          if (((UB *)Rv17)[40]!=14) {
            Ra.sl[6]=4850; /* line # 4850 */
            P_src_error(Rd.s+826,216,3);
          }
          else {
            Ra.sl[6]=4852; /* line # 4852 */
            Rv18=Rv17;
            Ra.sl[6]=4854; /* line # 4854 */
            Rv7=((V *)Rv18)[7];
            Ra.sl[6]=4855; /* line # 4855 */
            ((V *)Rv18)[7]=NULL;
          }
          Ra.sl[6]=4857; /* line # 4857 */
          Rv19=1;
          Ra.sl[6]=4858; /* line # 4858 */
          P_lgt_free_tree(&Rv17);
        }
      }
      else {
        Ra.sl[6]=4860; /* line # 4860 */
        Rv19=0;
      }
      Ra.sl[6]=4863; /* line # 4863 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=4865; /* line # 4865 */
        if (V_sy_sym.ub[0]==0) P_src_error_s(Rd.s+826,52,2, V_sy_ident.s,NULL);
      }
      Ra.sl[6]=4868; /* line # 4868 */
      if (Rv6!=NULL) while (1){
        Ra.sl[6]=4870; /* line # 4870 */
        Rv20=Rv6;
        Ra.sl[6]=4872; /* line # 4872 */
        Rv21=((V *)Rv20)[5];
        Ra.sl[6]=4873; /* line # 4873 */
        ((V *)Rv20)[5]=Rv13;
        Ra.sl[6]=4874; /* line # 4874 */
        if ((*F_isz)>0) (*F_isz)=P_ide_typ_align((*F_isz),Rv13);
        Ra.sl[6]=4875; /* line # 4875 */
        switch (F_v_class) {
          case 5:Ra.sl[6]=4878; /* line # 4878 */
          ((UW *)Rv20)[42]=Rv8;
          Ra.sl[6]=4879; /* line # 4879 */
          if (Rv12) ((UW *)Rv20)[42]=((UW *)Rv20)[42]|16384;
          Ra.sl[6]=4881; /* line # 4881 */
          if (((UB *)Rv20)[86]==5||((SL *)Rv20)[20]>0) {
            Ra.sl[6]=4883; /* line # 4883 */
            if (Rv21!=NULL&&Rv21!=Rv13) {
              Ra.sl[6]=4884; /* line # 4884 */
              P_src_error_s(Rd.s+826,217,3,((V *)Rv20)[0],NULL);
            }
            Ra.sl[6]=4885; /* line # 4885 */
            ((UB *)Rv20)[86]=Rv9;
          }
          else {
            Ra.sl[6]=4889; /* line # 4889 */
            if (((UB *)Rv20)[86]==0) ((UB *)Rv20)[86]=Rv9;
            Ra.sl[6]=4890; /* line # 4890 */
            switch (((UB *)Rv20)[86]) {
              case 4:
              case 5:
              case 6:Ra.sl[6]=4893; /* line # 4893 */
              if (((V *)Rv20)[8]==NULL) {
                Ra.sl[6]=4894; /* line # 4894 */
                P_set_gbl_def_nam(((V *)Rv20)+8,((V *)Rv20)[0],86);
              }
              Ra.sl[6]=4895; /* line # 4895 */
              ((SL *)Rv20)[20]=-1;
              break;
              default:Ra.sl[6]=4899; /* line # 4899 */
              if (16384&((UW *)Rv20)[42]||V_cmp_igenv!=0) {
                Ra.sl[6]=4900; /* line # 4900 */
                ((SL *)Rv20)[20]=-1;
              }
              break;
            }
          }
          Ra.sl[6]=4904; /* line # 4904 */
          if (Rv7!=NULL) {
            Ra.sl[6]=4905; /* line # 4905 */
            if (((UB *)Rv20)[86]==5||((SL *)Rv20)[20]>0) {
              Ra.sl[6]=4907; /* line # 4907 */
              if (Rv19) P_src_error_s(Rd.s+826,209,2,((V *)Rv20)[0],NULL);
              Ra.sl[6]=4910; /* line # 4910 */
              Rv7=NULL;
            }
            else {
              Ra.sl[6]=4914; /* line # 4914 */
              ((V *)Rv20)[7]=Rv7;
              Ra.sl[6]=4915; /* line # 4915 */
              P_val_new(((V *)Rv20)+7,Rv13);
              Ra.sl[6]=4916; /* line # 4916 */
              Rv22=((V *)Rv20)[7];
              Ra.sl[6]=4918; /* line # 4918 */
              ((UW *)Rv22)[8]=((UW *)Rv10)[42];
              Ra.sl[6]=4919; /* line # 4919 */
              ((SL *)Rv22)[5]=((SL *)Rv20)[20];
            }
          }
          Ra.sl[6]=4923; /* line # 4923 */
          switch (((UB *)Rv20)[86]) {
            case 4:Ra.sl[6]=4926; /* line # 4926 */
            if (((UB *)((V *)Rv20)[5])[90]||((UB *)((V *)Rv20)[5])[91]) P_init_d_varbl(
            Rv6);
            Ra.sl[6]=4927; /* line # 4927 */
            P_all_new(((V *)Rv20)+9,Rv13, Rv6,((UB *)Rv20)[86]);
            Ra.sl[6]=4928; /* line # 4928 */
            ((V *)((V *)Rv20)[9])[13]=((V *)Rv20)[7];
            Ra.sl[6]=4929; /* line # 4929 */
            if (V_all_fglobal==NULL) V_all_fglobal=((V *)Rv20)[9];
            else {
              Ra.sl[6]=4930; /* line # 4930 */
              ((V *)V_all_lglobal)[0]=((V *)Rv20)[9];
            }
            Ra.sl[6]=4931; /* line # 4931 */
            ((V *)((V *)Rv20)[9])[1]=V_all_lglobal;
            Ra.sl[6]=4932; /* line # 4932 */
            V_all_lglobal=((V *)Rv20)[9];
            break;
            case 1:
            case 2:Ra.sl[6]=4935; /* line # 4935 */
            if (((SL *)Rv20)[20]==0) {
              Ra.sl[6]=4937; /* line # 4937 */
              if (((UB *)((V *)Rv20)[5])[90]||((UB *)((V *)Rv20)[5])[91]) P_init_d_varbl(
              Rv6);
              Ra.sl[6]=4938; /* line # 4938 */
              P_all_new(((V *)Rv20)+9,Rv13, Rv6,((UB *)Rv20)[86]);
              Ra.sl[6]=4939; /* line # 4939 */
              ((V *)((V *)Rv20)[9])[13]=((V *)Rv20)[7];
              Ra.sl[6]=4940; /* line # 4940 */
              if (V_all_fstatic==NULL) V_all_fstatic=((V *)Rv20)[9];
              else {
                Ra.sl[6]=4941; /* line # 4941 */
                ((V *)V_all_lstatic)[0]=((V *)Rv20)[9];
              }
              Ra.sl[6]=4942; /* line # 4942 */
              ((V *)((V *)Rv20)[9])[1]=V_all_lstatic;
              Ra.sl[6]=4943; /* line # 4943 */
              V_all_lstatic=((V *)Rv20)[9];
            }
            break;
            default:break;
          }
          break;
          case 1:
          case 6:Ra.sl[6]=4950; /* line # 4950 */
          Ra.sl[6]=4952; /* line # 4952 */
          ((SL *)Rv20)[14]=(*F_isz);
          Ra.sl[6]=4953; /* line # 4953 */
          if ((*F_isz)<0) {
            Ra.sl[6]=4955; /* line # 4955 */
            P_src_error(Rd.s+826,221,3);
          }
          break;
          case 2:Ra.sl[6]=4960; /* line # 4960 */
          ((UB *)Rv20)[60]=0;
          Ra.sl[6]=4961; /* line # 4961 */
          ((V *)Rv20)[10]=Rv7;
          Ra.sl[6]=4964; /* line # 4964 */
          if (((V *)Rv20)[10]==NULL) {
            Ra.sl[6]=4966; /* line # 4966 */
            P_val_new(((V *)Rv20)+10,Rv13);
            Ra.sl[6]=4967; /* line # 4967 */
            Rv23=((V *)Rv20)[10];
            Rv24=Rv13;
            Ra.sl[6]=4968; /* line # 4968 */
            switch (((UB *)Rv24)[93]) {
              case 0:Ra.sl[6]=4970; /* line # 4970 */
              ((SL *)Rv23)[13]=((SL *)Rv24)[30];
              break;
              case 1:
              case 2:Ra.sl[6]=4972; /* line # 4972 */
              if (((SL *)Rv24)[30]>32767) ((SL *)Rv23)[13]=32767;
              else {
                Ra.sl[6]=4973; /* line # 4973 */
                ((SL *)Rv23)[13]=((SL *)Rv24)[30];
              }
              break;
              default:break;
            }
          }
          else {
            Ra.sl[6]=4978; /* line # 4978 */
            P_val_new(((V *)Rv20)+10,Rv13);
          }
          Ra.sl[6]=4979; /* line # 4979 */
          ((SL *)Rv20)[14]=(*F_isz);
          break;
        }
        Ra.sl[6]=4984; /* line # 4984 */
        if ((*F_isz)>=0) {
          Ra.sl[6]=4985; /* line # 4985 */
          if (((SL *)Rv13)[11]>=0) {
            Ra.sl[6]=4986; /* line # 4986 */
            (*F_isz)=(*F_isz)+((SL *)Rv13)[11];
          }
          else {
            Ra.sl[6]=4988; /* line # 4988 */
            if ((F_v_class==6||F_v_class==1)&&((V *)Rv13)[9]!=NULL) {
              Ra.sl[6]=4991; /* line # 4991 */
              Rv25=P_lgt_link(((V *)Rv13)[9]);
              Ra.sl[6]=4992; /* line # 4992 */
              if ((*F_isz)>0) {
                Ra.sl[6]=4994; /* line # 4994 */
                ((V *)Rv25)[0]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
                Ra.sl[6]=4995; /* line # 4995 */
                ((V *)F_ty)[9]=P_lgt_new_code(49, Rv25);
              }
              else {
                Ra.sl[6]=4997; /* line # 4997 */
                ((V *)F_ty)[9]=Rv25;
              }
              Ra.sl[6]=4998; /* line # 4998 */
              (*F_isz)=-1;
            }
            else {
              Ra.sl[6]=5003; /* line # 5003 */
              P_src_error(Rd.s+826,301,3);
            }
          }
        }
        Ra.sl[6]=5005; /* line # 5005 */
        Rv6=((V *)Rv6)[3];
        if (Rv6==NULL)  break;
      }
      Ra.sl[6]=5007; /* line # 5007 */
      if (Rv19&&Rv7!=NULL) P_val_free(&Rv7);
      Ra.sl[6]=5008; /* line # 5008 */
      Rv19=0;
    }
  }
  Ra.sl[6]=5012; /* line # 5012 */
  if (!Rv0) {
    Ra.sl[6]=5013; /* line # 5013 */
    Ra.sl[6]=5014; /* line # 5014 */
    switch (F_v_class) {
      case 1:
      case 6:Ra.sl[6]=5016; /* line # 5016 */
      Rv26=F_ty;
      Ra.sl[6]=5017; /* line # 5017 */
      switch (V_sy_sym.ub[0]) {
        case 72:Ra.sl[6]=5019; /* line # 5019 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=5020; /* line # 5020 */
          ((V *)Rv26)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        break;
        case 14:Ra.sl[6]=5024; /* line # 5024 */
        if (F_v_class==6&&(*F_isz)>=0) {
          Ra.sl[6]=5025; /* line # 5025 */
          ((V *)Rv26)[9]=P_lgt_new_econst(V_typ_std.v[2],(*F_isz));
        }
        Ra.sl[6]=5026; /* line # 5026 */
        if (((UB *)F_ty)[93]!=23) {
          Ra.sl[6]=5028; /* line # 5028 */
          P_src_error(Rd.s+826,223,2);
          P_insymbol();
        }
        break;
        case 56:Ra.sl[6]=5033; /* line # 5033 */
        Rv27=F_ty;
        Rv28=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=5034; /* line # 5034 */
        if (((SL *)Rv27)[11]<0) {
          Ra.sl[6]=5036; /* line # 5036 */
          P_src_error(Rd.s+826,224,3);
          Ra.sl[6]=5037; /* line # 5037 */
          P_insymbol();
          P_skip_symbol(72,0,0);
        }
        else {
          Ra.sl[6]=5041; /* line # 5041 */
          P_insymbol();
          Ra.sl[6]=5042; /* line # 5042 */
          if (F_v_class==6) {
            Ra.sl[6]=5043; /* line # 5043 */
            if (((V *)Rv27)[13]==NULL) {
              Ra.sl[6]=5044; /* line # 5044 */
              ((V *)Rv27)[12]=((V *)Rv28)[1];
            }
            else {
              Ra.sl[6]=5046; /* line # 5046 */
              ((V *)Rv27)[12]=((V *)((V *)Rv27)[13])[3];
            }
          }
          Ra.sl[6]=5047; /* line # 5047 */
          ((V *)Rv27)[13]=((V *)Rv28)[4];
          Ra.sl[6]=5048; /* line # 5048 */
          ((V *)Rv27)[14]=PAS_COMILER_PRC_00000004(41, F_ty);
          Ra.sl[6]=5049; /* line # 5049 */
          ((V *)Rv27)[9]=P_lgt_new_code(0,((V *)Rv27)[14]);
        }
        break;
        default:Ra.sl[6]=5054; /* line # 5054 */
        P_src_error(Rd.s+826,225,2);
        break;
      }
      break;
      case 2:Ra.sl[6]=5057; /* line # 5057 */
      if (V_sy_sym.ub[0]!=14) P_src_error(Rd.s+826,23,2);
      else {
        Ra.sl[6]=5058; /* line # 5058 */
        P_insymbol();
      }
      break;
      default:break;
    }
  }
  Ra.sl[6]=5062; /* line # 5062 */
  (*F_aln)=Rv3;
  Ra.sl[6]=5063; /* line # 5063 */
  if (F_ty!=NULL) {
    Ra.sl[6]=5064; /* line # 5064 */
    Rv29=F_ty;
    Ra.sl[6]=5065; /* line # 5065 */
    if (Rv3>((UB *)Rv29)[48]) ((UB *)Rv29)[48]=Rv3;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " const_decl "  */
void PAS_COMILER_PRC_00000044(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+830;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5080; /* line # 5080 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5081; /* line # 5081 */
  Ra.sl[6]=5083; /* line # 5083 */
  while (V_sy_sym.ub[0]==0||V_sy_sym.ub[0]==43){
    Ra.sl[6]=5085; /* line # 5085 */
    if (V_sy_sym.ub[0]==43) {
      Ra.sl[6]=5087; /* line # 5087 */
      P_insymbol();
      Ra.sl[6]=5088; /* line # 5088 */
      Rv0=1;
    }
    else {
      Ra.sl[6]=5090; /* line # 5090 */
      Rv0=0;
    }
    Ra.sl[6]=5091; /* line # 5091 */
    if (V_sy_sym.ub[0]!=0) {
      Ra.sl[6]=5093; /* line # 5093 */
      P_src_error(Rd.s+844,107,3);
      Ra.sl[6]=5094; /* line # 5094 */
      P_skip_symbol(18,0,0);
    }
    else {
      Ra.sl[6]=5098; /* line # 5098 */
      P_ide_new(4,NULL,&Rv1);
      Ra.sl[6]=5099; /* line # 5099 */
      P_insymbol();
      Ra.sl[6]=5101; /* line # 5101 */
      if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) {
        Ra.sl[6]=5102; /* line # 5102 */
        P_src_error(Rd.s+844,30,2);
      }
      else {
        Ra.sl[6]=5104; /* line # 5104 */
        P_insymbol();
      }
      Ra.sl[6]=5105; /* line # 5105 */
      Rv2=PAS_COMILER_PRC_00000000();
      Ra.sl[6]=5106; /* line # 5106 */
      Rv3=Rv1;
      Rv4=Rv2;
      Ra.sl[6]=5108; /* line # 5108 */
      if (((UB *)Rv4)[40]!=14) P_src_error(Rd.s+844,53,3);
      else {
        Ra.sl[6]=5111; /* line # 5111 */
        ((V *)Rv3)[5]=((V *)Rv4)[3];
        Ra.sl[6]=5112; /* line # 5112 */
        ((V *)Rv3)[7]=((V *)Rv4)[7];
        Ra.sl[6]=5113; /* line # 5113 */
        ((UB *)Rv3)[72]=2;
        Ra.sl[6]=5114; /* line # 5114 */
        ((V *)Rv4)[7]=NULL;
        Ra.sl[6]=5115; /* line # 5115 */
        if ((((V *)Rv3)[7]!=NULL&&!Rv0)&&V_cmp_igenv==0) {
          Ra.sl[6]=5116; /* line # 5116 */
          if (((V *)Rv3)[5]!=NULL) {
            Ra.sl[6]=5117; /* line # 5117 */
            Rv5=((V *)Rv3)[7];
            Ra.sl[6]=5119; /* line # 5119 */
            ((SL *)Rv5)[5]=0;
            Ra.sl[6]=5120; /* line # 5120 */
            ((UW *)Rv5)[8]=((UW *)Rv5)[8]&~16384;
            Ra.sl[6]=5121; /* line # 5121 */
            P_cte_allocate(((V *)Rv3)[7],Rv1);
          }
        }
        Ra.sl[6]=5124; /* line # 5124 */
        if (V_sy_init_mod) {
          Ra.sl[6]=5125; /* line # 5125 */
          if (((UB *)((V *)Rv3)[5])[93]==8) {
            Ra.sl[6]=5126; /* line # 5126 */
            if (V_usi_tab==NULL) V_usi_tab=Rv1;
            else {
              Ra.sl[6]=5127; /* line # 5127 */
              if (V_csi_tab==NULL) V_csi_tab=Rv1;
            }
          }
        }
      }
      Ra.sl[6]=5130; /* line # 5130 */
      if (Rv2!=NULL) P_lgt_free_tree(&Rv2);
    }
    Ra.sl[6]=5132; /* line # 5132 */
    if (V_sy_sym.ub[0]==17||V_sy_sym.ub[0]==18) P_insymbol();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " type_decl "  */
void PAS_COMILER_PRC_00000045(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UL Rv5;
  SL Rv6;
  SL Rv7;
  V Rv8;
  register V Rv9;
  V Rv10;
  register V Rv11;
  SL Rv12;
  V Rv13;
  V Rv14;
  V Rv15;
  V Rv16;
  register V Rv17;
  V Rv18;
  UB Rv19;
  register V Rv20;
  register V Rv21;
  register V Rv22;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+848;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5154; /* line # 5154 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5155; /* line # 5155 */
  Ra.sl[6]=5157; /* line # 5157 */
  if (V_sy_init_mod) {
    Ra.sl[6]=5158; /* line # 5158 */
    while (V_sy_sym.ub[0]==57){
      Ra.sl[6]=5160; /* line # 5160 */
      P_insymbol();
      Ra.sl[6]=5161; /* line # 5161 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5163; /* line # 5163 */
        Rv0=P_ide_search(2);
        Ra.sl[6]=5164; /* line # 5164 */
        if (Rv0!=NULL) Rv1=((V *)Rv0)[5];
        else {
          Ra.sl[6]=5165; /* line # 5165 */
          Rv1=NULL;
        }
        Ra.sl[6]=5166; /* line # 5166 */
        if (Rv1!=NULL) {
          Ra.sl[6]=5168; /* line # 5168 */
          P_insymbol();
          Ra.sl[6]=5169; /* line # 5169 */
          if (V_sy_sym.ub[0]==73) {
            Ra.sl[6]=5170; /* line # 5170 */
            Rv2=Rv1;
            Ra.sl[6]=5172; /* line # 5172 */
            Rv3=((SL *)Rv2)[11];
            Ra.sl[6]=5173; /* line # 5173 */
            Rv4=0;
            Ra.sl[6]=5174; /* line # 5174 */
            PAS_COMILER_PRC_00000040(&Rv3, &Rv4);
            Ra.sl[6]=5175; /* line # 5175 */
            ((SL *)Rv2)[11]=Rv3;
            ((UB *)Rv2)[48]=Rv4;
            Ra.sl[6]=5177; /* line # 5177 */
            if ((((UB *)Rv2)[93]==2||((UB *)Rv2)[93]==1)||((UB *)Rv2)[93]==0) {
              Ra.sl[6]=5180; /* line # 5180 */
              if (Rv3<4) {
                Ra.sl[6]=5182; /* line # 5182 */
                if (((UB *)Rv2)[112]) {
                  Ra.sl[6]=5184; /* line # 5184 */
                  ((UL *)Rv2)[29]=0;
                  Ra.sl[6]=5185; /* line # 5185 */
                  Rv5=PAS__IIPOWER(2,8*Rv3);
                  Ra.sl[6]=5186; /* line # 5186 */
                  if (((UL *)Rv2)[30]>Rv5) ((UL *)Rv2)[30]=Rv5-1;
                }
                else {
                  Ra.sl[6]=5190; /* line # 5190 */
                  Rv6=PAS__IIPOWER(2,8*Rv3-1);
                  Ra.sl[6]=5191; /* line # 5191 */
                  if (((SL *)Rv2)[30]>=Rv6) ((SL *)Rv2)[30]=Rv6-1;
                  Ra.sl[6]=5192; /* line # 5192 */
                  if (((SL *)Rv2)[29]<= -Rv6) ((SL *)Rv2)[29]= -Rv6;
                }
              }
              else {
                Ra.sl[6]=5196; /* line # 5196 */
                if (((UB *)Rv2)[112]) {
                  ((SL *)Rv2)[29]=0;
                  ((SL *)Rv2)[30]=-1;
                }
                else {
                  Ra.sl[6]=5197; /* line # 5197 */
                  ((SL *)Rv2)[30]=2147483647;
                  ((SL *)Rv2)[29]= -((SL *)Rv2)[30]-1;
                }
              }
            }
            Ra.sl[6]=5199; /* line # 5199 */
            switch (((UB *)Rv2)[93]) {
              case 2:Ra.sl[6]=5202; /* line # 5202 */
              V_inte_size=((SL *)Rv2)[11];
              Ra.sl[6]=5203; /* line # 5203 */
              ((SL *)V_uns_typ)[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5204; /* line # 5204 */
              ((UB *)V_uns_typ)[48]=((UB *)Rv2)[48];
              break;
              case 5:
              case 13:Ra.sl[6]=5208; /* line # 5208 */
              V_fptr_size=((SL *)Rv2)[11];
              Ra.sl[6]=5209; /* line # 5209 */
              ((SL *)V_typ_std.v[13])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5210; /* line # 5210 */
              ((UB *)V_typ_std.v[13])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5211; /* line # 5211 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5212; /* line # 5212 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5213; /* line # 5213 */
              ((SL *)V_typ_std.v[5])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5214; /* line # 5214 */
              ((UB *)V_typ_std.v[5])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5215; /* line # 5215 */
              ((SL *)V_typ_std.v[16])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5216; /* line # 5216 */
              ((UB *)V_typ_std.v[16])[48]=((UB *)Rv2)[48];
              break;
              case 3:Ra.sl[6]=5218; /* line # 5218 */
              V_sngl_size=((SL *)Rv2)[11];
              break;
              case 4:Ra.sl[6]=5219; /* line # 5219 */
              V_dble_size=((SL *)Rv2)[11];
              break;
              case 17:
              case 19:Ra.sl[6]=5222; /* line # 5222 */
              V_dst_setw=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5223; /* line # 5223 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5224; /* line # 5224 */
              ((UB *)V_typ_std.v[18])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5225; /* line # 5225 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5226; /* line # 5226 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5227; /* line # 5227 */
              ((SL *)V_typ_std.v[19])[11]=((SL *)Rv2)[11];
              Ra.sl[6]=5228; /* line # 5228 */
              ((SL *)V_typ_std.v[17])[11]=((SL *)Rv2)[11];
              break;
              case 18:Ra.sl[6]=5232; /* line # 5232 */
              V_dst_seta=((SL *)Rv2)[11]*8;
              Ra.sl[6]=5233; /* line # 5233 */
              V_dst_seti=((V_dst_seta+V_dst_setw)-1)/V_dst_setw;
              Ra.sl[6]=5234; /* line # 5234 */
              ((UB *)V_typ_std.v[19])[48]=((UB *)Rv2)[48];
              Ra.sl[6]=5235; /* line # 5235 */
              ((UB *)V_typ_std.v[17])[48]=((UB *)Rv2)[48];
              break;
              case 16:Ra.sl[6]=5240; /* line # 5240 */
              Rv7=((UB *)V_typ_std.v[5])[48];
              Ra.sl[6]=5241; /* line # 5241 */
              if (Rv7!=Rv4) ((UB *)Rv2)[48]=Rv7;
              Ra.sl[6]=5243; /* line # 5243 */
              Rv7=((SL *)V_typ_std.v[16])[11];
              Ra.sl[6]=5244; /* line # 5244 */
              if (Rv3!=Rv7) {
                Ra.sl[6]=5246; /* line # 5246 */
                if (Rv3<Rv7) Rv3=Rv7;
                else {
                  Ra.sl[6]=5247; /* line # 5247 */
                  if (PAS__I_MOD(Rv3,Rv7)!=0) Rv3=Rv7*(Rv3/Rv7+1);
                }
                Ra.sl[6]=5248; /* line # 5248 */
                ((SL *)Rv2)[11]=Rv3;
              }
              break;
              default:break;
            }
            Ra.sl[6]=5254; /* line # 5254 */
            if (V_sy_sym.ub[0]==21) P_data_format_set(Rv1);
            Ra.sl[6]=5256; /* line # 5256 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=5257; /* line # 5257 */
              P_src_error(Rd.s+861,21,2);
            }
          }
          else {
            Ra.sl[6]=5259; /* line # 5259 */
            P_skip_symbol(18,0,0);
          }
        }
        else {
          Ra.sl[6]=5263; /* line # 5263 */
          P_src_error(Rd.s+861,8001,3);
          Ra.sl[6]=5264; /* line # 5264 */
          P_skip_symbol(18,0,0);
        }
      }
      else {
        Ra.sl[6]=5269; /* line # 5269 */
        P_src_error(Rd.s+861,8002,3);
        Ra.sl[6]=5270; /* line # 5270 */
        P_skip_symbol(18,0,0);
      }
    }
  }
  Ra.sl[6]=5276; /* line # 5276 */
  while (V_sy_sym.ub[0]==0){
    Ra.sl[6]=5278; /* line # 5278 */
    Rv0=Lx[5].v[1];
    Rv8=NULL;
    Ra.sl[6]=5279; /* line # 5279 */
    while (Rv0!=NULL&&Rv8==NULL){
      Ra.sl[6]=5281; /* line # 5281 */
      Rv9=Rv0;
      Ra.sl[6]=5282; /* line # 5282 */
      if (P_match(((V *)Rv9)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=5284; /* line # 5284 */
        Rv8=Rv0;
        Ra.sl[6]=5285; /* line # 5285 */
        if (Rv0==Lx[5].v[1]) Lx[5].v[1]=((V *)Lx[5].v[1])[7];
        else {
          Ra.sl[6]=5286; /* line # 5286 */
          ((V *)Rv10)[7]=((V *)Rv0)[7];
        }
      }
      Ra.sl[6]=5288; /* line # 5288 */
      Rv10=Rv0;
      Rv0=((V *)Rv0)[7];
    }
    Ra.sl[6]=5290; /* line # 5290 */
    if (Rv8==NULL) {
      Ra.sl[6]=5293; /* line # 5293 */
      P_ide_new(1,NULL,&Rv8);
      Ra.sl[6]=5294; /* line # 5294 */
      Rv1=NULL;
    }
    else {
      Ra.sl[6]=5296; /* line # 5296 */
      Rv1=((V *)Rv8)[5];
    }
    Ra.sl[6]=5297; /* line # 5297 */
    Rv11=Rv8;
    Ra.sl[6]=5299; /* line # 5299 */
    Rv12=V_curr_disp;
    Ra.sl[6]=5300; /* line # 5300 */
    P_insymbol();
    Ra.sl[6]=5301; /* line # 5301 */
    Rv3=0;
    Ra.sl[6]=5302; /* line # 5302 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=5304; /* line # 5304 */
      P_insymbol();
      Ra.sl[6]=5305; /* line # 5305 */
      P_new_disp_level(NULL,4);
      Ra.sl[6]=5306; /* line # 5306 */
      PAS_COMILER_PRC_00000037(2, &Rv3, &Rv7,NULL);
      Ra.sl[6]=5307; /* line # 5307 */
      Rv0=V_lex_ident_tree.v[V_curr_disp*8+1];
      Ra.sl[6]=5308; /* line # 5308 */
      Rv13=Rv0;
      Ra.sl[6]=5309; /* line # 5309 */
      Rv14=NULL;
      Ra.sl[6]=5310; /* line # 5310 */
      while (Rv13!=NULL){
        Ra.sl[6]=5312; /* line # 5312 */
        P_lgt_new(&Rv15,((V *)Rv13)[5],14,NULL);
        Ra.sl[6]=5313; /* line # 5313 */
        ((V *)Rv15)[7]=((V *)Rv13)[10];
        Ra.sl[6]=5314; /* line # 5314 */
        P_val_new(((V *)Rv15)+7,((V *)Rv13)[5]);
        Ra.sl[6]=5315; /* line # 5315 */
        if (Rv14==NULL) Rv14=Rv15;
        else {
          Ra.sl[6]=5316; /* line # 5316 */
          ((V *)Rv16)[0]=Rv15;
        }
        Ra.sl[6]=5317; /* line # 5317 */
        Rv16=Rv15;
        Ra.sl[6]=5318; /* line # 5318 */
        Rv13=((V *)Rv13)[3];
      }
    }
    else {
      Ra.sl[6]=5321; /* line # 5321 */
      Rv0=NULL;
    }
    Ra.sl[6]=5323; /* line # 5323 */
    if (V_sy_sym.ub[0]!=10||V_sy_sym.ub[1]!=19) P_src_error(Rd.s+861,30,2);
    else {
      Ra.sl[6]=5324; /* line # 5324 */
      P_insymbol();
    }
    Ra.sl[6]=5363; /* line # 5363 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(0);
    Ra.sl[6]=5367; /* line # 5367 */
    PAS_COMILER_PRC_00000038(((V *)Rv11)+5,Rv3, Rv0,1,0,NULL);
    Ra.sl[6]=5369; /* line # 5369 */
    V_curr_disp=Rv12;
    Ra.sl[6]=5370; /* line # 5370 */
    ((V *)Rv11)[10]=V_sy_type_gfirst;
    Ra.sl[6]=5371; /* line # 5371 */
    ((V *)Rv11)[11]=NULL;
    Ra.sl[6]=5372; /* line # 5372 */
    V_tcas_flag=0;
    Ra.sl[6]=5373; /* line # 5373 */
    Rv17=((V *)Rv11)[5];
    Ra.sl[6]=5374; /* line # 5374 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5378; /* line # 5378 */
      switch (((UB *)Rv17)[93]) {
        case 8:
        case 10:
        case 11:
        case 12:
        case 22:
        case 27:Ra.sl[6]=5382; /* line # 5382 */
        ((SL *)Rv17)[10]=P_ide_typ_align(Rv3,((V *)Rv11)[5]);
        Ra.sl[6]=5383; /* line # 5383 */
        ((V *)Rv17)[4]=Rv0;
        Ra.sl[6]=5384; /* line # 5384 */
        if (Rv7>((UB *)((V *)Rv11)[5])[48]) {
          Ra.sl[6]=5385; /* line # 5385 */
          ((UB *)((V *)Rv11)[5])[48]=Rv7;
        }
        Ra.sl[6]=5386; /* line # 5386 */
        if (((SL *)Rv17)[11]<0) {
          Ra.sl[6]=5388; /* line # 5388 */
          Rv18=P_lgt_type_eval(((V *)Rv17)[9],NULL,NULL,0);
          Ra.sl[6]=5389; /* line # 5389 */
          if (((UB *)Rv18)[40]==14) {
            Ra.sl[6]=5391; /* line # 5391 */
            ((SL *)Rv17)[11]= -((SL *)((V *)Rv18)[7])[13];
            Ra.sl[6]=5393; /* line # 5393 */
            if (((SL *)Rv17)[11]>=0) ((SL *)Rv17)[11]=-1;
            Ra.sl[6]=5394; /* line # 5394 */
            P_lgt_free(&Rv18);
          }
        }
        break;
        default:Ra.sl[6]=5400; /* line # 5400 */
        P_src_error(Rd.s+861,205,3);
        break;
      }
      Ra.sl[6]=5403; /* line # 5403 */
      Rv19=((UB *)Rv17)[93]!=10;
      Ra.sl[6]=5405; /* line # 5405 */
      if (Rv19) {
        Ra.sl[6]=5407; /* line # 5407 */
        if (((V *)Rv17)[9]==NULL) {
          Ra.sl[6]=5408; /* line # 5408 */
          ((SL *)Rv17)[11]=((SL *)Rv17)[11]+((SL *)Rv17)[10];
        }
        else {
          Ra.sl[6]=5411; /* line # 5411 */
          if (((UB *)((V *)Rv17)[9])[40]==14) {
            Ra.sl[6]=5413; /* line # 5413 */
            Rv20=((V *)Rv17)[9];
            Ra.sl[6]=5414; /* line # 5414 */
            if (((V *)Rv20)[7]!=NULL) {
              Ra.sl[6]=5415; /* line # 5415 */
              ((SL *)((V *)Rv20)[7])[13]=((SL *)((V *)Rv20)[7])[13]+((SL *)Rv17)
              [10];
            }
          }
          else {
            Ra.sl[6]=5419; /* line # 5419 */
            ((V *)((V *)Rv17)[9])[0]=P_lgt_new_econst(V_typ_std.v[2],((SL *)Rv17)
            [10]);
            Ra.sl[6]=5421; /* line # 5421 */
            ((V *)Rv17)[9]=P_lgt_new_code(49,((V *)Rv17)[9]);
          }
        }
      }
      Ra.sl[6]=5426; /* line # 5426 */
      if (V_tcas_flag) P_lgt_gen_routine(((V *)Rv11)[5]);
    }
    Ra.sl[6]=5430; /* line # 5430 */
    Rv21=((V *)Rv11)[5];
    Ra.sl[6]=5431; /* line # 5431 */
    if (((V *)Rv21)[3]==NULL) {
      Ra.sl[6]=5433; /* line # 5433 */
      if (((V *)Rv21)[0]!=NULL) {
        Ra.sl[6]=5434; /* line # 5434 */
        if (((V *)((V *)Rv21)[0])[3]!=NULL) {
          Ra.sl[6]=5436; /* line # 5436 */
          ((V *)Rv11)[10]=((V *)((V *)((V *)Rv21)[0])[3])[10];
        }
      }
      Ra.sl[6]=5437; /* line # 5437 */
      ((V *)Rv21)[3]=Rv8;
    }
    Ra.sl[6]=5440; /* line # 5440 */
    if (Rv1!=NULL) ((V *)Rv1)[12]=((V *)Rv11)[5];
    Ra.sl[6]=5443; /* line # 5443 */
    if (V_sy_sym.ub[0]==22||V_sy_sym.ub[0]==34) {
      Ra.sl[6]=5445; /* line # 5445 */
      P_insymbol();
      Ra.sl[6]=5446; /* line # 5446 */
      if (V_sy_sym.ub[0]==15||V_sy_sym.ub[0]==13) Rv18=PAS_COMILER_PRC_00000019((
      (V *)Rv11)[5]);
      else {
        Ra.sl[6]=5447; /* line # 5447 */
        Rv18=PAS_COMILER_PRC_00000005(((V *)Rv11)[5],0,0,0);
      }
      Ra.sl[6]=5448; /* line # 5448 */
      if (((UB *)Rv18)[40]!=14) {
        Ra.sl[6]=5449; /* line # 5449 */
        P_src_error(Rd.s+861,53,3);
      }
      else {
        Ra.sl[6]=5452; /* line # 5452 */
        Rv22=Rv18;
        Ra.sl[6]=5454; /* line # 5454 */
        ((V *)((V *)Rv11)[5])[10]=((V *)Rv22)[7];
        Ra.sl[6]=5455; /* line # 5455 */
        ((V *)Rv22)[7]=NULL;
      }
      Ra.sl[6]=5457; /* line # 5457 */
      P_lgt_free_tree(&Rv18);
    }
    Ra.sl[6]=5461; /* line # 5461 */
    if (Rv0!=NULL&&((V *)Rv11)[5]!=NULL) {
      Ra.sl[6]=5463; /* line # 5463 */
      ((V *)((V *)Rv11)[5])[1]=P_type_parm_set(Rv8, Rv14);
    }
    Ra.sl[6]=5464; /* line # 5464 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=5465; /* line # 5465 */
      P_src_error(Rd.s+861,21,2);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " varbl_decl "  */
void PAS_COMILER_PRC_00000046(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+865;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5486; /* line # 5486 */
  V_ident_disp=V_curr_disp;
  Ra.sl[6]=5487; /* line # 5487 */
  Rv0=0;
  Ra.sl[6]=5488; /* line # 5488 */
  Ra.sl[6]=5489; /* line # 5489 */
  PAS_COMILER_PRC_00000037(5, &Rv0, &Rv1,NULL);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_decl "  */
void PAS_COMILER_PRC_00000047(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+877;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5503; /* line # 5503 */
  Rv0=0;
  Ra.sl[6]=5504; /* line # 5504 */
  while (1){
    Ra.sl[6]=5507; /* line # 5507 */
    P_insymbol();
    Ra.sl[6]=5508; /* line # 5508 */
    if (V_sy_sym.ub[0]==2) P_ide_int_label();
    Ra.sl[6]=5509; /* line # 5509 */
    if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+891,69,3);
    else {
      Ra.sl[6]=5513; /* line # 5513 */
      P_ide_new(3,NULL,&Rv1);
      Ra.sl[6]=5514; /* line # 5514 */
      if (Rv1!=NULL) {
        Ra.sl[6]=5515; /* line # 5515 */
        Rv2=Rv1;
        Ra.sl[6]=5517; /* line # 5517 */
        Rv3=Lx[5].v[13];
        Ra.sl[6]=5518; /* line # 5518 */
        if (((V *)Rv3)[20]==NULL) ((V *)Rv3)[20]=Rv1;
        else {
          Ra.sl[6]=5519; /* line # 5519 */
          ((V *)Lx[5].v[4])[7]=Rv1;
        }
        Ra.sl[6]=5520; /* line # 5520 */
        Lx[5].v[4]=Rv1;
        Ra.sl[6]=5521; /* line # 5521 */
        ((UB *)Rv2)[54]=1;
      }
    }
    Ra.sl[6]=5524; /* line # 5524 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=17)  break;
  }
  Ra.sl[6]=5526; /* line # 5526 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5527; /* line # 5527 */
    P_src_error(Rd.s+891,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement_decl "  */
void PAS_COMILER_PRC_00000048(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  V Rv3;
  register V Rv4;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+895;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5547; /* line # 5547 */
  Ra.sl[6]=5549; /* line # 5549 */
  P_insymbol();
  Ra.sl[6]=5550; /* line # 5550 */
  if (V_sy_sym.ub[0]!=0) {
    Ra.sl[6]=5552; /* line # 5552 */
    P_src_error(Rd.s+913,107,3);
    Ra.sl[6]=5553; /* line # 5553 */
    P_skip_symbol(18,1,0);
  }
  else {
    Ra.sl[6]=5557; /* line # 5557 */
    V_err_prt=0;
    Ra.sl[6]=5558; /* line # 5558 */
    Rv0=P_ide_search(1024);
    Ra.sl[6]=5559; /* line # 5559 */
    V_err_prt=1;
    Ra.sl[6]=5560; /* line # 5560 */
    if (Rv0!=NULL) {
      Ra.sl[6]=5561; /* line # 5561 */
      if (((SL *)Rv0)[12]!=V_curr_lex) Rv1=NULL;
      else {
        Ra.sl[6]=5562; /* line # 5562 */
        Rv1=Rv0;
      }
    }
    else {
      Ra.sl[6]=5563; /* line # 5563 */
      Rv1=NULL;
    }
    Ra.sl[6]=5565; /* line # 5565 */
    if (Rv1==NULL) {
      Ra.sl[6]=5566; /* line # 5566 */
      P_ide_new(10,NULL,&Rv1);
    }
    Ra.sl[6]=5567; /* line # 5567 */
    P_insymbol();
    Ra.sl[6]=5569; /* line # 5569 */
    Ra.sl[6]=5571; /* line # 5571 */
    if (V_sy_sym.ub[0]==57) {
      Ra.sl[6]=5573; /* line # 5573 */
      P_insymbol();
      Ra.sl[6]=5574; /* line # 5574 */
      if (V_sy_sym.ub[0]==37) P_insymbol();
      Ra.sl[6]=5575; /* line # 5575 */
      if (V_sy_sym.ub[0]==40) {
        Ra.sl[6]=5577; /* line # 5577 */
        P_insymbol();
        Ra.sl[6]=5578; /* line # 5578 */
        if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+913,25,2);
        Ra.sl[6]=5579; /* line # 5579 */
        Rv2=0;
        Ra.sl[6]=5581; /* line # 5581 */
        PAS_COMILER_PRC_00000042(Ri.v+3,1, &Rv2,NULL);
      }
      else {
        Ra.sl[6]=5584; /* line # 5584 */
        PAS_COMILER_PRC_00000038(Ri.v+3,0,NULL,0,1,NULL);
      }
      Ra.sl[6]=5586; /* line # 5586 */
      if (V_sy_sym.ub[0]==22) {
        Ra.sl[6]=5588; /* line # 5588 */
        P_insymbol();
        Ra.sl[6]=5589; /* line # 5589 */
        Ri.v[4]=PAS_COMILER_PRC_00000005(Ri.v[3],0,0,0);
      }
      Ra.sl[6]=5591; /* line # 5591 */
      if (V_sy_sym.ub[0]==48) {
        Ra.sl[6]=5592; /* line # 5592 */
        Ri.ub[17]=1;
        P_insymbol();
      }
      Ra.sl[6]=5593; /* line # 5593 */
      if (V_sy_sym.ub[0]==53) P_insymbol();
      else {
        Ra.sl[6]=5594; /* line # 5594 */
        P_src_error(Rd.s+913,55,2);
      }
    }
    Ra.sl[6]=5596; /* line # 5596 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5598; /* line # 5598 */
      Ri.v[5]=P_ide_search(514);
      Ra.sl[6]=5599; /* line # 5599 */
      P_insymbol();
    }
    Ra.sl[6]=5601; /* line # 5601 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    else {
      Ra.sl[6]=5602; /* line # 5602 */
      P_src_error(Rd.s+913,29,2);
    }
    Ra.sl[6]=5603; /* line # 5603 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=5605; /* line # 5605 */
      Ri.v[6]=P_ide_search(514);
      Ra.sl[6]=5606; /* line # 5606 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=5607; /* line # 5607 */
      P_src_error_s(Rd.s+913,42,3,((V *)Rv1)[0],NULL);
    }
    Ra.sl[6]=5608; /* line # 5608 */
    if (V_sy_sym.ub[0]==17) {
      Ra.sl[6]=5610; /* line # 5610 */
      P_insymbol();
      Ra.sl[6]=5611; /* line # 5611 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5613; /* line # 5613 */
        Ri.v[7]=P_ide_search(514);
        Ra.sl[6]=5614; /* line # 5614 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=5616; /* line # 5616 */
        P_src_error_s(Rd.s+913,43,2,((V *)Rv1)[0],NULL);
      }
    }
    Ra.sl[6]=5620; /* line # 5620 */
    if (V_error_result<=1) {
      Ra.sl[6]=5622; /* line # 5622 */
      Rv3=PAS__NEW(56);
      Ra.sl[6]=5623; /* line # 5623 */
      memcpy(Rv3,Ri.s+8,56);
      Ra.sl[6]=5624; /* line # 5624 */
      Rv4=Rv1;
      Ra.sl[6]=5626; /* line # 5626 */
      if (((V *)Rv4)[8]==NULL) {
        Ra.sl[6]=5628; /* line # 5628 */
        if (Rv0!=NULL) {
          Ra.sl[6]=5629; /* line # 5629 */
          ((V *)Rv3)[0]=((V *)Rv0)[7];
        }
        Ra.sl[6]=5630; /* line # 5630 */
        ((V *)Rv4)[7]=Rv3;
        Ra.sl[6]=5631; /* line # 5631 */
        ((V *)Rv4)[8]=Rv3;
      }
      else {
        Ra.sl[6]=5635; /* line # 5635 */
        ((V *)Rv3)[0]=((V *)((V *)Rv4)[8])[0];
        Ra.sl[6]=5636; /* line # 5636 */
        ((V *)((V *)Rv4)[8])[0]=Rv3;
        Ra.sl[6]=5637; /* line # 5637 */
        ((V *)Rv4)[8]=Rv3;
      }
    }
  }
  Ra.sl[6]=5642; /* line # 5642 */
  if (V_sy_sym.ub[0]==18) P_insymbol();
  else {
    Ra.sl[6]=5643; /* line # 5643 */
    P_src_error(Rd.s+913,21,2);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " argument_list "  */
UB PAS_COMILER_PRC_00000003(V *F_pr, UB F_isfunct, UB F_no_entry){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  register V Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  SL Rv8;
  UW Rv9;
  UB Rv10;
  UW Rv11;
  UB Rv12;
  SL Rv13;
  V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  register V Rv18;
  register V Rv19;
  register V Rv20;
  register V Rv21;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+917;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5681; /* line # 5681 */
  Rv0=0;
  Ra.sl[6]=5682; /* line # 5682 */
  Rv1=Lx[5].v[13];
  Ra.sl[6]=5683; /* line # 5683 */
  Lx[5].v[13]=(*F_pr);
  Ra.sl[6]=5684; /* line # 5684 */
  Rv2=NULL;
  Ra.sl[6]=5685; /* line # 5685 */
  Rv3=0;
  Ra.sl[6]=5686; /* line # 5686 */
  Rv4=(*F_pr);
  Ra.sl[6]=5688; /* line # 5688 */
  if (V_sy_sym.ub[0]==13) {
    Ra.sl[6]=5690; /* line # 5690 */
    V_sy_sym.ub[0]=18;
    while (1){
      Ra.sl[6]=5692; /* line # 5692 */
      P_insymbol();
      Ra.sl[6]=5693; /* line # 5693 */
      if (V_sy_sym.ub[0]==76||V_sy_sym.ub[0]==77) {
        Ra.sl[6]=5695; /* line # 5695 */
        if (F_no_entry) P_src_error(Rd.s+934,125,3);
        Ra.sl[6]=5696; /* line # 5696 */
        Rv0=1;
        Ra.sl[6]=5697; /* line # 5697 */
        Rv5=V_sy_sym.ub[0]==77;
        Ra.sl[6]=5698; /* line # 5698 */
        P_insymbol();
        Ra.sl[6]=5699; /* line # 5699 */
        Rv6=PAS_COMILER_PRC_00000001(Rv5);
        Ra.sl[6]=5700; /* line # 5700 */
        Rv3=Rv3+1;
        Ra.sl[6]=5702; /* line # 5702 */
        if (Rv2==NULL) Rv2=Rv6;
        Ra.sl[6]=5703; /* line # 5703 */
        Rv7=Rv6;
      }
      else {
        Ra.sl[6]=5707; /* line # 5707 */
        Rv8=0;
        Ra.sl[6]=5708; /* line # 5708 */
        Rv9=96;
        Ra.sl[6]=5709; /* line # 5709 */
        Rv10=0;
        Ra.sl[6]=5710; /* line # 5710 */
        Rv11=0;
        Ra.sl[6]=5711; /* line # 5711 */
        Rv12=9;
        while (1){
          Ra.sl[6]=5713; /* line # 5713 */
          switch (V_sy_sym.ub[0]) {
            case 30:Ra.sl[6]=5714; /* line # 5714 */
            Rv12=8;
            break;
            case 35:Ra.sl[6]=5715; /* line # 5715 */
            Rv9=32;
            Rv12=8;
            break;
            case 36:Ra.sl[6]=5716; /* line # 5716 */
            Rv9=64;
            Rv12=8;
            break;
            default:Ra.sl[6]=5718; /* line # 5718 */
            Rv10=1;
            break;
          }
          Ra.sl[6]=5720; /* line # 5720 */
          if (!Rv10) P_insymbol();
          if (Rv10)  break;
        }
        Ra.sl[6]=5723; /* line # 5723 */
        Rv7=NULL;
        Ra.sl[6]=5724; /* line # 5724 */
        while (V_sy_sym.ub[0]==0){
          Ra.sl[6]=5726; /* line # 5726 */
          P_ide_new(5,NULL,&Rv6);
          Ra.sl[6]=5727; /* line # 5727 */
          Rv3=Rv3+1;
          Ra.sl[6]=5728; /* line # 5728 */
          Rv8=Rv8+1;
          Ra.sl[6]=5730; /* line # 5730 */
          if (Rv7==NULL) {
            Ra.sl[6]=5732; /* line # 5732 */
            if (Rv2==NULL) Rv2=Rv6;
            Ra.sl[6]=5733; /* line # 5733 */
            Rv7=Rv6;
          }
          Ra.sl[6]=5735; /* line # 5735 */
          P_insymbol();
          Ra.sl[6]=5736; /* line # 5736 */
          if (V_sy_sym.ub[0]==17) P_insymbol();
          else {
            Ra.sl[6]=5738; /* line # 5738 */
            if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,29,2);
          }
        }
        Ra.sl[6]=5741; /* line # 5741 */
        if (V_sy_sym.ub[0]!=21) P_src_error(Rd.s+934,31,2);
        else {
          Ra.sl[6]=5742; /* line # 5742 */
          P_insymbol();
        }
        Ra.sl[6]=5744; /* line # 5744 */
        if (V_sy_sym.ub[0]==15) {
          while (1){
            Ra.sl[6]=5747; /* line # 5747 */
            P_insymbol();
            Ra.sl[6]=5748; /* line # 5748 */
            if (V_sy_sym.ub[0]==0) {
              Ra.sl[6]=5750; /* line # 5750 */
              Rv6=P_level_search(V_attr_list);
              Ra.sl[6]=5751; /* line # 5751 */
              P_insymbol();
              Ra.sl[6]=5752; /* line # 5752 */
              if (Rv6!=NULL) {
                Ra.sl[6]=5753; /* line # 5753 */
                switch (((UB *)Rv6)[54]) {
                  case 17:Ra.sl[6]=5754; /* line # 5754 */
                  Rv9=Rv9|2048;
                  break;
                  case 16:Ra.sl[6]=5755; /* line # 5755 */
                  Rv9=Rv9|1024;
                  break;
                  case 1:Ra.sl[6]=5756; /* line # 5756 */
                  Rv9=Rv9|512;
                  break;
                  case 6:Ra.sl[6]=5757; /* line # 5757 */
                  Rv9=Rv9|256;
                  break;
                  case 21:Ra.sl[6]=5760; /* line # 5760 */
                  if (Rv12!=8) {
                    Ra.sl[6]=5761; /* line # 5761 */
                    P_src_error(Rd.s+934,242,2);
                  }
                  Ra.sl[6]=5762; /* line # 5762 */
                  Rv9=Rv9|8192;
                  break;
                  case 20:Ra.sl[6]=5764; /* line # 5764 */
                  Rv9=(Rv9|32)&~64;
                  break;
                  case 27:Ra.sl[6]=5765; /* line # 5765 */
                  Rv11=Rv11|4;
                  break;
                  case 28:Ra.sl[6]=5766; /* line # 5766 */
                  Rv11=Rv11|8;
                  break;
                  case 29:Ra.sl[6]=5767; /* line # 5767 */
                  Rv11=Rv11|16;
                  break;
                  case 30:Ra.sl[6]=5768; /* line # 5768 */
                  Rv11=Rv11|32;
                  break;
                  case 31:Ra.sl[6]=5769; /* line # 5769 */
                  Rv11=Rv11|64;
                  break;
                  default:break;
                }
              }
            }
            else {
              Ra.sl[6]=5773; /* line # 5773 */
              P_src_error(Rd.s+934,2,3);
            }
            if (V_sy_sym.ub[0]!=17)  break;
          }
          Ra.sl[6]=5775; /* line # 5775 */
          if (V_sy_sym.ub[0]==16) P_insymbol();
          else {
            Ra.sl[6]=5776; /* line # 5776 */
            P_src_error(Rd.s+934,26,2);
          }
        }
        Ra.sl[6]=5779; /* line # 5779 */
        if (V_sy_sym.ub[0]==37) P_insymbol();
        Ra.sl[6]=5780; /* line # 5780 */
        if (V_sy_sym.ub[0]==40) {
          Ra.sl[6]=5782; /* line # 5782 */
          if (Rv8>1) P_src_error(Rd.s+934,243,3);
          Ra.sl[6]=5783; /* line # 5783 */
          P_insymbol();
          Ra.sl[6]=5784; /* line # 5784 */
          if (V_sy_sym.ub[0]!=15) P_src_error(Rd.s+934,25,2);
          Ra.sl[6]=5785; /* line # 5785 */
          Rv13=0;
          Ra.sl[6]=5786; /* line # 5786 */
          if (!V_sy_init_mod) {
            Ra.sl[6]=5787; /* line # 5787 */
            if (Rv12==9&&!V_cmp_dynamic) {
              Ra.sl[6]=5789; /* line # 5789 */
              Rv12=8;
              Rv9=32;
              Ra.sl[6]=5790; /* line # 5790 */
              P_src_error(Rd.s+934,229,1);
            }
          }
          Ra.sl[6]=5793; /* line # 5793 */
          PAS_COMILER_PRC_00000042(&Rv14,1, &Rv13,NULL);
        }
        else {
          Ra.sl[6]=5797; /* line # 5797 */
          PAS_COMILER_PRC_00000038(&Rv14,0,NULL,0,1,NULL);
          Ra.sl[6]=5798; /* line # 5798 */
          if (Rv14!=NULL) {
            Ra.sl[6]=5799; /* line # 5799 */
            if (!V_sy_init_mod) {
              Ra.sl[6]=5800; /* line # 5800 */
              if ((((SL *)Rv14)[11]<0&&Rv12==9)&&!V_cmp_dynamic) {
                Ra.sl[6]=5803; /* line # 5803 */
                Rv12=8;
                Rv9=32;
                Ra.sl[6]=5804; /* line # 5804 */
                P_src_error(Rd.s+934,226,1);
              }
            }
          }
        }
        Ra.sl[6]=5807; /* line # 5807 */
        if (V_sy_sym.ub[0]==22) {
          Ra.sl[6]=5809; /* line # 5809 */
          P_insymbol();
          Ra.sl[6]=5810; /* line # 5810 */
          Rv15=PAS_COMILER_PRC_00000005(Rv14,0,0,0);
          Ra.sl[6]=5811; /* line # 5811 */
          Rv16=Rv15;
          Ra.sl[6]=5812; /* line # 5812 */
          if (((UB *)Rv16)[40]!=14) {
            Ra.sl[6]=5813; /* line # 5813 */
            P_src_error(Rd.s+934,53,3);
          }
          else {
            Ra.sl[6]=5816; /* line # 5816 */
            Rv17=((V *)Rv16)[7];
            Ra.sl[6]=5817; /* line # 5817 */
            ((V *)Rv16)[7]=NULL;
          }
          Ra.sl[6]=5819; /* line # 5819 */
          if (Rv12==8&&64&Rv9) {
            Ra.sl[6]=5820; /* line # 5820 */
            P_src_error(Rd.s+934,241,2);
          }
        }
        else {
          Ra.sl[6]=5822; /* line # 5822 */
          Rv17=NULL;
        }
        Ra.sl[6]=5823; /* line # 5823 */
        Rv6=Rv7;
        Ra.sl[6]=5824; /* line # 5824 */
        while (Rv6!=NULL){
          Ra.sl[6]=5826; /* line # 5826 */
          Rv18=Rv6;
          Ra.sl[6]=5827; /* line # 5827 */
          if (((UB *)Rv18)[86]==0) {
            Ra.sl[6]=5829; /* line # 5829 */
            ((V *)Rv18)[5]=Rv14;
            Ra.sl[6]=5830; /* line # 5830 */
            ((UW *)Rv18)[42]=Rv9;
            Ra.sl[6]=5831; /* line # 5831 */
            ((UB *)Rv18)[86]=Rv12;
            Ra.sl[6]=5832; /* line # 5832 */
            ((V *)Rv18)[7]=Rv17;
            Ra.sl[6]=5833; /* line # 5833 */
            ((UW *)Rv18)[44]=Rv11;
            Ra.sl[6]=5834; /* line # 5834 */
            if (Rv17!=NULL) P_val_new(((V *)Rv18)+7,Rv14);
          }
          Ra.sl[6]=5836; /* line # 5836 */
          Rv7=Rv6;
          Rv6=((V *)Rv6)[3];
        }
        Ra.sl[6]=5838; /* line # 5838 */
        if (Rv17!=NULL) P_val_free(&Rv17);
      }
      if (V_sy_sym.ub[0]!=18)  break;
    }
    Ra.sl[6]=5841; /* line # 5841 */
    if (V_sy_sym.ub[0]==14) P_insymbol();
    else {
      Ra.sl[6]=5842; /* line # 5842 */
      P_src_error(Rd.s+934,23,2);
    }
  }
  Ra.sl[6]=5844; /* line # 5844 */
  ((V *)Rv4)[11]=NULL;
  Ra.sl[6]=5845; /* line # 5845 */
  if (F_isfunct) {
    Ra.sl[6]=5847; /* line # 5847 */
    if (V_sy_sym.ub[0]==21) P_insymbol();
    else P_src_error(Rd.s+934,31,2);
    Ra.sl[6]=5849; /* line # 5849 */
    Rv9=97;
    Ra.sl[6]=5850; /* line # 5850 */
    if (V_sy_sym.ub[0]==15) {
      while (1){
        Ra.sl[6]=5853; /* line # 5853 */
        P_insymbol();
        Ra.sl[6]=5854; /* line # 5854 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=5856; /* line # 5856 */
          Rv6=P_level_search(V_attr_list);
          Ra.sl[6]=5857; /* line # 5857 */
          P_insymbol();
          Ra.sl[6]=5858; /* line # 5858 */
          if (Rv6!=NULL) {
            Ra.sl[6]=5859; /* line # 5859 */
            switch (((UB *)Rv6)[54]) {
              case 16:Ra.sl[6]=5860; /* line # 5860 */
              Rv9=Rv9|1024;
              break;
              case 1:Ra.sl[6]=5861; /* line # 5861 */
              Rv9=Rv9|512;
              break;
              default:break;
            }
          }
        }
        else {
          Ra.sl[6]=5865; /* line # 5865 */
          P_src_error(Rd.s+934,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=5867; /* line # 5867 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=5868; /* line # 5868 */
        P_src_error(Rd.s+934,26,2);
      }
    }
    Ra.sl[6]=5870; /* line # 5870 */
    PAS_COMILER_PRC_00000038(((V *)Rv4)+11,0,NULL,0,1,NULL);
    Ra.sl[6]=5872; /* line # 5872 */
    if (((V *)Rv4)[11]==NULL) ((V *)Rv4)[11]=V_typ_std.v[21];
  }
  Ra.sl[6]=5874; /* line # 5874 */
  if (((V *)Rv4)[11]!=NULL) {
    Ra.sl[6]=5875; /* line # 5875 */
    if (!((UB *)((V *)Rv4)[11])[92]) {
      Ra.sl[6]=5877; /* line # 5877 */
      Rv19=((V *)Rv4)[11];
      Ra.sl[6]=5878; /* line # 5878 */
      if (((SL *)Rv19)[11]<0&&((V *)Rv19)[1]!=NULL) {
        Ra.sl[6]=5879; /* line # 5879 */
        ((V *)Rv4)[11]=((V *)Rv19)[1];
      }
      Ra.sl[6]=5882; /* line # 5882 */
      P_ide_create_name(Rd.s+938);
      Ra.sl[6]=5883; /* line # 5883 */
      P_ide_new(5,((V *)Rv4)[11],&Rv6);
      Ra.sl[6]=5884; /* line # 5884 */
      if (Rv2!=NULL) {
        Ra.sl[6]=5885; /* line # 5885 */
        ((V *)Rv7)[3]=NULL;
      }
      Ra.sl[6]=5886; /* line # 5886 */
      Rv20=Rv6;
      Ra.sl[6]=5888; /* line # 5888 */
      ((V *)Rv20)[3]=Rv2;
      Rv2=Rv6;
      Ra.sl[6]=5889; /* line # 5889 */
      ((UW *)Rv20)[42]=Rv9;
      Ra.sl[6]=5890; /* line # 5890 */
      ((UB *)Rv20)[86]=7;
    }
  }
  Ra.sl[6]=5893; /* line # 5893 */
  ((SL *)Rv4)[20]=Rv3;
  Ra.sl[6]=5894; /* line # 5894 */
  ((V *)Rv4)[8]=Rv2;
  Ra.sl[6]=5895; /* line # 5895 */
  Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
  Ra.sl[6]=5897; /* line # 5897 */
  ((V *)Rv4)[6]=((V *)Rv21)[1];
  Ra.sl[6]=5898; /* line # 5898 */
  ((V *)Rv4)[7]=((V *)Rv21)[4];
  Ra.sl[6]=5899; /* line # 5899 */
  ((V *)Rv4)[12]=((V *)Rv21)[5];
  Ra.sl[6]=5902; /* line # 5902 */
  Lx[5].v[13]=Rv1;
  Ra.sl[6]=5903; /* line # 5903 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_decl "  */
V PAS_COMILER_PRC_00000001(UB F_isfunction){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  SL Rv3;
  SL Rv4;
  UB Rv5;
  V Rv6;
  register V Rv7;
  V Rv8;
  register V Rv9;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+943;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=5921; /* line # 5921 */
  Ra.sl[6]=5922; /* line # 5922 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=5924; /* line # 5924 */
    Rv0=P_level_search(V_lex_ident_tree.v[V_curr_disp*8+1]);
    Ra.sl[6]=5925; /* line # 5925 */
    if (Rv0!=NULL) P_src_error(Rd.s+963,101,3);
    Ra.sl[6]=5926; /* line # 5926 */
    P_ide_new(7,NULL,&Rv0);
    Ra.sl[6]=5927; /* line # 5927 */
    Rv1=PAS__NEW(120);
    Ra.sl[6]=5928; /* line # 5928 */
    Rv2=Rv1;
    Ra.sl[6]=5930; /* line # 5930 */
    ((V *)Rv2)[0]=NULL;
    Ra.sl[6]=5931; /* line # 5931 */
    ((V *)Rv2)[1]=NULL;
    Ra.sl[6]=5932; /* line # 5932 */
    ((UW *)Rv2)[8]=0;
    Ra.sl[6]=5933; /* line # 5933 */
    ((V *)Rv2)[3]=NULL;
    Ra.sl[6]=5934; /* line # 5934 */
    ((UB *)Rv2)[32]=29;
    Ra.sl[6]=5935; /* line # 5935 */
    ((V *)Rv2)[5]=NULL;
    Ra.sl[6]=5936; /* line # 5936 */
    ((V *)Rv2)[6]=NULL;
    Ra.sl[6]=5937; /* line # 5937 */
    ((V *)Rv2)[7]=NULL;
    Ra.sl[6]=5938; /* line # 5938 */
    ((V *)Rv2)[8]=NULL;
    Ra.sl[6]=5939; /* line # 5939 */
    ((SL *)Rv2)[18]=V_curr_lex;
    Ra.sl[6]=5940; /* line # 5940 */
    ((SL *)Rv2)[19]=0;
    Ra.sl[6]=5941; /* line # 5941 */
    ((SL *)Rv2)[20]=0;
    Ra.sl[6]=5942; /* line # 5942 */
    ((V *)Rv2)[11]=NULL;
    Ra.sl[6]=5943; /* line # 5943 */
    ((V *)Rv2)[12]=NULL;
    Ra.sl[6]=5944; /* line # 5944 */
    ((UB *)Rv2)[104]=4;
    Ra.sl[6]=5945; /* line # 5945 */
    ((V *)Rv2)[14]=NULL;
    Ra.sl[6]=5947; /* line # 5947 */
    ((V *)Rv0)[8]=Rv1;
    Ra.sl[6]=5949; /* line # 5949 */
    Rv3=V_curr_lex;
    Ra.sl[6]=5950; /* line # 5950 */
    Rv4=V_curr_disp;
    Ra.sl[6]=5951; /* line # 5951 */
    if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
    else {
      Ra.sl[6]=5952; /* line # 5952 */
      P_src_error(Rd.s+963,1002,3);
    }
    Ra.sl[6]=5953; /* line # 5953 */
    P_new_disp_level(Rv1,4);
    Ra.sl[6]=5954; /* line # 5954 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=5955; /* line # 5955 */
    P_insymbol();
    Ra.sl[6]=5956; /* line # 5956 */
    Rv5=PAS_COMILER_PRC_00000003(&Rv1, F_isfunction,0);
    Ra.sl[6]=5957; /* line # 5957 */
    V_curr_lex=Rv3;
    V_curr_disp=Rv4;
    Ra.sl[6]=5960; /* line # 5960 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[6]=5962; /* line # 5962 */
      P_insymbol();
      Ra.sl[6]=5963; /* line # 5963 */
      if (V_sy_sym.ub[0]==0) {
        Ra.sl[6]=5966; /* line # 5966 */
        Rv6=P_ide_search(898);
        Ra.sl[6]=5967; /* line # 5967 */
        if (Rv6!=V_ide_udptr.v[1]) {
          Ra.sl[6]=5968; /* line # 5968 */
          Rv7=Rv6;
          Ra.sl[6]=5970; /* line # 5970 */
          Rv8=NULL;
          Ra.sl[6]=5971; /* line # 5971 */
          if (((UB *)Rv7)[53]==7) {
            Ra.sl[6]=5973; /* line # 5973 */
            Rv8=((V *)Rv7)[8];
            Ra.sl[6]=5974; /* line # 5974 */
            if (Rv8==Rv1) P_src_error(Rd.s+963,403,3);
          }
          else {
            Ra.sl[6]=5978; /* line # 5978 */
            if (((V *)Rv7)[11]!=((V *)Rv7)[10]&&((V *)Rv7)[11]!=NULL) {
              Ra.sl[6]=5979; /* line # 5979 */
              P_src_error_s(Rd.s+963,118,2, V_sy_ident.s,NULL);
            }
            else {
              Ra.sl[6]=5981; /* line # 5981 */
              Rv9=((V *)Rv7)[10];
              Ra.sl[6]=5982; /* line # 5982 */
              if (((UB *)Rv9)[8]) P_src_error(Rd.s+963,998,4);
              else {
                Ra.sl[6]=5983; /* line # 5983 */
                Rv8=((V *)Rv9)[2];
              }
            }
          }
          Ra.sl[6]=5986; /* line # 5986 */
          if (!P_comp_proc_arg(Rv8, Rv1)) P_src_error(Rd.s+963,119,3);
          else {
            Ra.sl[6]=5987; /* line # 5987 */
            ((V *)Rv0)[7]=Rv8;
          }
          Ra.sl[6]=5988; /* line # 5988 */
          P_insymbol();
        }
      }
      else {
        Ra.sl[6]=5992; /* line # 5992 */
        P_src_error(Rd.s+963,32,3);
      }
    }
  }
  else {
    Ra.sl[6]=5997; /* line # 5997 */
    Rv0=V_ide_udptr.v[7];
    Ra.sl[6]=5998; /* line # 5998 */
    P_src_error(Rd.s+963,107,3);
  }
  Ra.sl[6]=6000; /* line # 6000 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " formal_proc_ptr "  */
V PAS_COMILER_PRC_00000002(UB F_isfunction, V F_owid){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  UB Rv4;
  V Rv5;
  register V Rv6;
  V Rv7;
  register V Rv8;
  V Rv9;
  register V Rv10;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+967;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6019; /* line # 6019 */
  Ra.sl[6]=6021; /* line # 6021 */
  Rv0=PAS__NEW(120);
  Ra.sl[6]=6022; /* line # 6022 */
  Rv1=Rv0;
  Ra.sl[6]=6024; /* line # 6024 */
  ((V *)Rv1)[0]=NULL;
  Ra.sl[6]=6025; /* line # 6025 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=6026; /* line # 6026 */
  ((UW *)Rv1)[8]=0;
  Ra.sl[6]=6027; /* line # 6027 */
  ((V *)Rv1)[3]=NULL;
  Ra.sl[6]=6028; /* line # 6028 */
  ((UB *)Rv1)[32]=29;
  Ra.sl[6]=6029; /* line # 6029 */
  ((V *)Rv1)[5]=NULL;
  Ra.sl[6]=6030; /* line # 6030 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=6031; /* line # 6031 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=6032; /* line # 6032 */
  ((V *)Rv1)[8]=NULL;
  Ra.sl[6]=6033; /* line # 6033 */
  ((SL *)Rv1)[18]=V_curr_lex;
  Ra.sl[6]=6034; /* line # 6034 */
  ((SL *)Rv1)[19]=0;
  Ra.sl[6]=6035; /* line # 6035 */
  ((SL *)Rv1)[20]=0;
  Ra.sl[6]=6036; /* line # 6036 */
  ((V *)Rv1)[11]=NULL;
  Ra.sl[6]=6037; /* line # 6037 */
  ((V *)Rv1)[12]=NULL;
  Ra.sl[6]=6038; /* line # 6038 */
  ((UB *)Rv1)[104]=4;
  Ra.sl[6]=6039; /* line # 6039 */
  ((V *)Rv1)[14]=NULL;
  Ra.sl[6]=6041; /* line # 6041 */
  Rv2=V_curr_lex;
  Ra.sl[6]=6042; /* line # 6042 */
  Rv3=V_curr_disp;
  Ra.sl[6]=6043; /* line # 6043 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6044; /* line # 6044 */
    P_src_error(Rd.s+986,1002,3);
  }
  Ra.sl[6]=6045; /* line # 6045 */
  P_new_disp_level(Rv0,4);
  Ra.sl[6]=6046; /* line # 6046 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=6047; /* line # 6047 */
  P_insymbol();
  Ra.sl[6]=6048; /* line # 6048 */
  Rv4=PAS_COMILER_PRC_00000003(&Rv0, F_isfunction,0);
  Ra.sl[6]=6049; /* line # 6049 */
  V_curr_lex=Rv2;
  V_curr_disp=Rv3;
  Ra.sl[6]=6051; /* line # 6051 */
  if (V_sy_sym.ub[0]==22) {
    Ra.sl[6]=6053; /* line # 6053 */
    P_insymbol();
    Ra.sl[6]=6054; /* line # 6054 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=6057; /* line # 6057 */
      Rv5=P_ide_search(898);
      Ra.sl[6]=6058; /* line # 6058 */
      if (Rv5!=V_ide_udptr.v[1]) {
        Ra.sl[6]=6059; /* line # 6059 */
        Rv6=Rv5;
        Ra.sl[6]=6061; /* line # 6061 */
        Rv7=NULL;
        Ra.sl[6]=6062; /* line # 6062 */
        if (((UB *)Rv6)[53]==7) {
          Ra.sl[6]=6064; /* line # 6064 */
          Rv7=((V *)Rv6)[8];
          Ra.sl[6]=6065; /* line # 6065 */
          if (Rv7==Rv0) P_src_error(Rd.s+986,403,3);
        }
        else {
          Ra.sl[6]=6069; /* line # 6069 */
          if (((V *)Rv6)[11]!=((V *)Rv6)[10]&&((V *)Rv6)[11]!=NULL) {
            Ra.sl[6]=6070; /* line # 6070 */
            P_src_error_s(Rd.s+986,118,2, V_sy_ident.s,NULL);
          }
          else {
            Ra.sl[6]=6072; /* line # 6072 */
            Rv8=((V *)Rv6)[10];
            Ra.sl[6]=6073; /* line # 6073 */
            if (((UB *)Rv8)[8]) P_src_error(Rd.s+986,998,4);
            else {
              Ra.sl[6]=6074; /* line # 6074 */
              Rv7=((V *)Rv8)[2];
            }
          }
        }
        Ra.sl[6]=6077; /* line # 6077 */
        if (!P_comp_proc_arg(Rv7, Rv0)) P_src_error(Rd.s+986,119,3);
        else {
          Ra.sl[6]=6078; /* line # 6078 */
          ((V *)Rv5)[7]=Rv7;
        }
        Ra.sl[6]=6079; /* line # 6079 */
        P_insymbol();
      }
    }
    else {
      Ra.sl[6]=6082; /* line # 6082 */
      P_src_error(Rd.s+986,32,3);
    }
  }
  else {
    Ra.sl[6]=6084; /* line # 6084 */
    Rv7=NULL;
  }
  Ra.sl[6]=6086; /* line # 6086 */
  P_ide_new_typ(6, &Rv9);
  Ra.sl[6]=6087; /* line # 6087 */
  Rv10=Rv9;
  Ra.sl[6]=6089; /* line # 6089 */
  ((V *)Rv10)[3]=F_owid;
  Ra.sl[6]=6090; /* line # 6090 */
  ((V *)Rv10)[0]=NULL;
  Ra.sl[6]=6091; /* line # 6091 */
  memcpy(Rv10+48,V_typ_std.v[13]+48,1);
  Ra.sl[6]=6092; /* line # 6092 */
  ((SL *)Rv10)[11]=V_fptr_size;
  Ra.sl[6]=6093; /* line # 6093 */
  ((V *)Rv10)[12]=((V *)Rv0)[11];
  Ra.sl[6]=6094; /* line # 6094 */
  ((V *)Rv10)[13]=Rv0;
  Ra.sl[6]=6096; /* line # 6096 */
  Ret=Rv9;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " insert_new_generic "  */
void PAS_COMILER_PRC_00000049(V *F_pgfirst, V *F_pglast, V F_pg, UB F_bwfent){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+990;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6107; /* line # 6107 */
  if (F_pg!=NULL) {
    Ra.sl[6]=6109; /* line # 6109 */
    if (F_bwfent&&(*F_pgfirst)!=NULL) {
      Ra.sl[6]=6110; /* line # 6110 */
      P_src_error(Rd.s+1012,114,3);
    }
    Ra.sl[6]=6112; /* line # 6112 */
    if (V_sy_generic_qmod) {
      Ra.sl[6]=6114; /* line # 6114 */
      if ((*F_pgfirst)==NULL) (*F_pgfirst)=F_pg;
      else {
        Ra.sl[6]=6115; /* line # 6115 */
        ((V *)(*F_pglast))[0]=F_pg;
      }
      Ra.sl[6]=6116; /* line # 6116 */
      (*F_pglast)=F_pg;
    }
    else {
      Ra.sl[6]=6120; /* line # 6120 */
      ((V *)F_pg)[0]=(*F_pgfirst);
      Ra.sl[6]=6122; /* line # 6122 */
      (*F_pgfirst)=F_pg;
      Ra.sl[6]=6123; /* line # 6123 */
      if ((*F_pglast)==NULL) (*F_pglast)=F_pg;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_decl "  */
void PAS_COMILER_PRC_00000051(V F_pgf, V F_pgl){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  UB Rv11;
  UB Rv12;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1016;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6186; /* line # 6186 */
  Lx[3].ub[0]=0;
  Ra.sl[6]=6187; /* line # 6187 */
  Lx[3].v[1]=NULL;
  Ra.sl[6]=6188; /* line # 6188 */
  Rv0=NULL;
  Ra.sl[6]=6189; /* line # 6189 */
  P_insymbol();
  Ra.sl[6]=6191; /* line # 6191 */
  if (V_sy_sym.ub[0]==13) Lx[3].ub[16]=0;
  Ra.sl[6]=6192; /* line # 6192 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=6194; /* line # 6194 */
    Lx[3].v[3]=PAS__NEW(245);
    Ra.sl[6]=6195; /* line # 6195 */
    Rv1=Lx[3].v[3];
    Ra.sl[6]=6197; /* line # 6197 */
    ((V *)Rv1)[0]=NULL;
    Ra.sl[6]=6198; /* line # 6198 */
    ((V *)Rv1)[1]=NULL;
    Ra.sl[6]=6199; /* line # 6199 */
    ((UW *)Rv1)[8]=0;
    Ra.sl[6]=6200; /* line # 6200 */
    ((V *)Rv1)[3]=NULL;
    Ra.sl[6]=6201; /* line # 6201 */
    ((UB *)Rv1)[32]=29;
    Ra.sl[6]=6202; /* line # 6202 */
    ((V *)Rv1)[5]=NULL;
    Ra.sl[6]=6203; /* line # 6203 */
    ((V *)Rv1)[6]=NULL;
    Ra.sl[6]=6204; /* line # 6204 */
    ((V *)Rv1)[7]=NULL;
    Ra.sl[6]=6205; /* line # 6205 */
    ((V *)Rv1)[8]=NULL;
    Ra.sl[6]=6206; /* line # 6206 */
    ((SL *)Rv1)[18]=V_curr_lex;
    Ra.sl[6]=6207; /* line # 6207 */
    ((SL *)Rv1)[19]=0;
    Ra.sl[6]=6208; /* line # 6208 */
    ((SL *)Rv1)[20]=0;
    Ra.sl[6]=6209; /* line # 6209 */
    ((V *)Rv1)[11]=NULL;
    Ra.sl[6]=6210; /* line # 6210 */
    ((V *)Rv1)[12]=NULL;
    Ra.sl[6]=6211; /* line # 6211 */
    ((UB *)Rv1)[104]=10;
    Ra.sl[6]=6213; /* line # 6213 */
    ((V *)Rv1)[14]=Lx[5].v[13];
    Ra.sl[6]=6214; /* line # 6214 */
    ((V *)Rv1)[15]=NULL;
    Ra.sl[6]=6215; /* line # 6215 */
    ((V *)Rv1)[16]=NULL;
    Ra.sl[6]=6216; /* line # 6216 */
    ((V *)Rv1)[17]=NULL;
    Ra.sl[6]=6217; /* line # 6217 */
    ((V *)Rv1)[18]=NULL;
    Ra.sl[6]=6218; /* line # 6218 */
    ((V *)Rv1)[19]=NULL;
    Ra.sl[6]=6219; /* line # 6219 */
    ((V *)Rv1)[20]=NULL;
    Ra.sl[6]=6220; /* line # 6220 */
    ((V *)Rv1)[21]=NULL;
    Ra.sl[6]=6221; /* line # 6221 */
    ((V *)Rv1)[22]=NULL;
    Ra.sl[6]=6222; /* line # 6222 */
    ((V *)Rv1)[23]=NULL;
    Ra.sl[6]=6223; /* line # 6223 */
    ((V *)Rv1)[24]=NULL;
    Ra.sl[6]=6224; /* line # 6224 */
    ((V *)Rv1)[25]=NULL;
    Ra.sl[6]=6225; /* line # 6225 */
    ((V *)Rv1)[26]=NULL;
    Ra.sl[6]=6226; /* line # 6226 */
    ((V *)Rv1)[27]=NULL;
    Ra.sl[6]=6227; /* line # 6227 */
    ((SL *)Rv1)[56]=-1;
    Ra.sl[6]=6228; /* line # 6228 */
    ((SL *)Rv1)[57]=0;
    Ra.sl[6]=6229; /* line # 6229 */
    ((SL *)Rv1)[58]=0;
    Ra.sl[6]=6230; /* line # 6230 */
    ((SL *)Rv1)[59]=0;
    Ra.sl[6]=6231; /* line # 6231 */
    ((SL *)Rv1)[60]=0;
    Ra.sl[6]=6232; /* line # 6232 */
    ((UB *)Rv1)[244]=0;
  }
  else {
    Ra.sl[6]=6236; /* line # 6236 */
    Rv2=Lx[3].v[3];
    Ra.sl[6]=6238; /* line # 6238 */
    Rv0=((V *)Rv2)[8];
    Ra.sl[6]=6239; /* line # 6239 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=6240; /* line # 6240 */
      if (!((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=6241; /* line # 6241 */
        Rv0=((V *)Rv0)[3];
      }
    }
  }
  Ra.sl[6]=6245; /* line # 6245 */
  if (V_curr_lex<30) V_curr_lex=V_curr_lex+1;
  else {
    Ra.sl[6]=6246; /* line # 6246 */
    P_src_error(Rd.s+1029,1002,3);
  }
  Ra.sl[6]=6247; /* line # 6247 */
  P_new_disp_level(Lx[3].v[3],4);
  Ra.sl[6]=6248; /* line # 6248 */
  V_lex_ident_tree.v[V_curr_disp*8+1]=Rv0;
  Ra.sl[6]=6249; /* line # 6249 */
  V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
  Ra.sl[6]=6250; /* line # 6250 */
  Lx[3].sl[8]=V_curr_disp;
  Lx[3].sl[9]=V_curr_lex;
  Ra.sl[6]=6252; /* line # 6252 */
  Ra.sl[6]=6254; /* line # 6254 */
  if (!Lx[3].ub[16]) {
    Ra.sl[6]=6256; /* line # 6256 */
    Lx[3].ub[40]=PAS_COMILER_PRC_00000003(Lx[3].v+3,Lx[3].ub[41],Lx[3].ub[42]);
    Ra.sl[6]=6258; /* line # 6258 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6259; /* line # 6259 */
      P_src_error(Rd.s+1029,21,2);
    }
    Ra.sl[6]=6263; /* line # 6263 */
    if (Lx[3].sl[11]!=0) {
      Ra.sl[6]=6264; /* line # 6264 */
      if (Lx[3].sl[11]>0) {
        Ra.sl[6]=6265; /* line # 6265 */
        if (((SL *)Lx[3].v[3])[20]!=Lx[3].sl[11]) P_src_error_s(Rd.s+1029,127,2,
        Lx[3].s+48,NULL);
        else {
          Ra.sl[6]=6267; /* line # 6267 */
          if (((SL *)Lx[3].v[3])[20]!=1&&((SL *)Lx[3].v[3])[20]!=2) {
            Ra.sl[6]=6268; /* line # 6268 */
            P_src_error_s(Rd.s+1029,127,2, Lx[3].s+48,NULL);
          }
        }
      }
    }
    Ra.sl[6]=6271; /* line # 6271 */
    Lx[3].v[1]=P_compare_proc_argid(F_pgf, F_pgl, Lx[3].v[3]);
    Ra.sl[6]=6272; /* line # 6272 */
    Rv3=Lx[3].v[1]==NULL;
    Ra.sl[6]=6273; /* line # 6273 */
    if (!Rv3) {
      Ra.sl[6]=6275; /* line # 6275 */
      Rv4=Lx[3].v[3];
      Ra.sl[6]=6276; /* line # 6276 */
      Lx[3].v[3]=((V *)Lx[3].v[1])[2];
      Ra.sl[6]=6277; /* line # 6277 */
      Rv0=((V *)Lx[3].v[3])[8];
      Ra.sl[6]=6278; /* line # 6278 */
      Rv5=((V *)Rv4)[8];
      Ra.sl[6]=6279; /* line # 6279 */
      while (Rv0!=NULL&&Rv5!=NULL){
        Ra.sl[6]=6281; /* line # 6281 */
        PAS__DISPOSE(((V *)Rv0));
        Ra.sl[6]=6282; /* line # 6282 */
        ((V *)Rv0)[0]=((V *)Rv5)[0];
        Ra.sl[6]=6283; /* line # 6283 */
        Rv0=((V *)Rv0)[3];
        Rv5=((V *)Rv5)[3];
      }
      Ra.sl[6]=6285; /* line # 6285 */
      Rv6=(V_lex_ident_tree.s+V_curr_disp*64);
      Rv7=Lx[3].v[3];
      Ra.sl[6]=6287; /* line # 6287 */
      P_free_ide_list(((V *)Rv4)+8);
      Ra.sl[6]=6288; /* line # 6288 */
      P_free_typ_list(((V *)Rv4)+12);
      Ra.sl[6]=6289; /* line # 6289 */
      ((V *)Rv6)[0]=Lx[3].v[3];
      Ra.sl[6]=6290; /* line # 6290 */
      ((V *)Rv6)[1]=((V *)Rv7)[6];
      Ra.sl[6]=6293; /* line # 6293 */
      ((V *)Rv6)[4]=((V *)Rv7)[7];
      Ra.sl[6]=6294; /* line # 6294 */
      ((V *)Rv6)[5]=((V *)Rv7)[12];
      Ra.sl[6]=6299; /* line # 6299 */
      Lx[3].v[1]=NULL;
      Ra.sl[6]=6301; /* line # 6301 */
      switch (((UB *)Lx[3].v[3])[104]) {
        case 3:Ra.sl[6]=6303; /* line # 6303 */
        if (Lx[3].ub[80]!=9) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        case 8:Ra.sl[6]=6305; /* line # 6305 */
        if (Lx[3].ub[80]!=10) P_src_error_s(Rd.s+1029,100,2, Lx[3].s+48,NULL);
        break;
        default:Ra.sl[6]=6307; /* line # 6307 */
        P_src_error_s(Rd.s+1029,102,2, Lx[3].s+48,NULL);
        Ra.sl[6]=6308; /* line # 6308 */
        Lx[3].ub[80]=9;
        break;
      }
      Ra.sl[6]=6310; /* line # 6310 */
      PAS__DISPOSE(&Rv4);
      Ra.sl[6]=6311; /* line # 6311 */
      ((UB *)Lx[3].v[3])[104]=10;
    }
    else {
      Ra.sl[6]=6315; /* line # 6315 */
      Lx[3].v[1]=PAS__NEW(32);
      Ra.sl[6]=6316; /* line # 6316 */
      Rv8=Lx[3].v[1];
      Ra.sl[6]=6318; /* line # 6318 */
      ((V *)Rv8)[0]=NULL;
      Ra.sl[6]=6319; /* line # 6319 */
      ((UB *)Rv8)[8]=0;
      Ra.sl[6]=6320; /* line # 6320 */
      ((V *)Rv8)[2]=Lx[3].v[3];
      Ra.sl[6]=6323; /* line # 6323 */
      if (V_pro_d_first==NULL) V_pro_d_first=Lx[3].v[3];
      else {
        Ra.sl[6]=6324; /* line # 6324 */
        ((V *)V_pro_d_last)[1]=Lx[3].v[3];
      }
      Ra.sl[6]=6325; /* line # 6325 */
      V_pro_d_last=Lx[3].v[3];
    }
  }
  else {
    Ra.sl[6]=6329; /* line # 6329 */
    Rv9=Lx[3].v[3];
    Ra.sl[6]=6331; /* line # 6331 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6332; /* line # 6332 */
      P_src_error(Rd.s+1029,21,2);
    }
    Ra.sl[6]=6333; /* line # 6333 */
    if (((UB *)Rv9)[104]==3) Lx[3].ub[80]=9;
    Ra.sl[6]=6334; /* line # 6334 */
    ((UB *)Rv9)[104]=10;
  }
  Ra.sl[6]=6338; /* line # 6338 */
  Rv10=Lx[3].v[3];
  Ra.sl[6]=6340; /* line # 6340 */
  if (V_sy_sym.ub[0]==79) {
    Ra.sl[6]=6342; /* line # 6342 */
    if (Lx[3].ub[16]||((UB *)Rv10)[104]!=10) P_src_error_s(Rd.s+1029,128,2, Lx[3]
    .s+48,NULL);
    else {
      Ra.sl[6]=6343; /* line # 6343 */
      ((UB *)Rv10)[104]=8;
    }
    Ra.sl[6]=6344; /* line # 6344 */
    P_insymbol();
    Ra.sl[6]=6345; /* line # 6345 */
    if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
    else {
      Ra.sl[6]=6347; /* line # 6347 */
      if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
        Ra.sl[6]=6349; /* line # 6349 */
        ((UB *)Rv10)[32]=Lx[3].ub[82];
        Ra.sl[6]=6350; /* line # 6350 */
        ((V *)Rv10)[3]=PAS__NEW(32);
        Ra.sl[6]=6351; /* line # 6351 */
        if (((UB *)Rv10)[32]==29) {
          Ra.sl[6]=6352; /* line # 6352 */
          memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
        }
        else {
          Ra.sl[6]=6354; /* line # 6354 */
          memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
        }
      }
      else {
        Ra.sl[6]=6357; /* line # 6357 */
        ((V *)Rv10)[3]=P_new_int_name(Rd.s+1035,&V_proc_seq);
      }
    }
    Ra.sl[6]=6359; /* line # 6359 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=6360; /* line # 6360 */
      P_src_error(Rd.s+1029,21,2);
    }
  }
  else {
    Ra.sl[6]=6363; /* line # 6363 */
    if (V_sy_sym.ub[0]==83||V_sy_sym.ub[0]==85&&V_sy_init_mod) {
      Ra.sl[6]=6365; /* line # 6365 */
      if (((UB *)Rv10)[104]!=10) {
        Ra.sl[6]=6367; /* line # 6367 */
        P_src_error_s(Rd.s+1029,108,2, Lx[3].s+48,NULL);
      }
      Ra.sl[6]=6368; /* line # 6368 */
      if (V_sy_sym.ub[0]==83) {
        Ra.sl[6]=6370; /* line # 6370 */
        ((UB *)Rv10)[104]=3;
        Ra.sl[6]=6371; /* line # 6371 */
        ((SL *)Rv10)[18]=1;
      }
      else {
        Ra.sl[6]=6376; /* line # 6376 */
        ((UB *)Rv10)[104]=1;
        Ra.sl[6]=6377; /* line # 6377 */
        ((SL *)Rv10)[18]=0;
      }
      Ra.sl[6]=6379; /* line # 6379 */
      P_insymbol();
      Ra.sl[6]=6381; /* line # 6381 */
      if (V_sy_sym.ub[0]==5) {
        Ra.sl[6]=6383; /* line # 6383 */
        P_set_stdname(Lx[3].v[3]);
      }
      else {
        Ra.sl[6]=6385; /* line # 6385 */
        if (Lx[3].ub[80]==((UB *)Rv10)[104]&&Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6386; /* line # 6386 */
          ((V *)Rv10)[3]=Lx[3].v[11];
        }
        else {
          Ra.sl[6]=6389; /* line # 6389 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6390; /* line # 6390 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6391; /* line # 6391 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6393; /* line # 6393 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
      }
      Ra.sl[6]=6396; /* line # 6396 */
      if (V_sy_sym.ub[0]==18) P_insymbol();
      else {
        Ra.sl[6]=6397; /* line # 6397 */
        P_src_error(Rd.s+1029,21,2);
      }
    }
    else {
      Ra.sl[6]=6401; /* line # 6401 */
      Lx[3].ub[0]=1;
      Ra.sl[6]=6403; /* line # 6403 */
      if (Lx[3].ub[80]!=10) {
        Ra.sl[6]=6405; /* line # 6405 */
        ((UB *)Rv10)[104]=Lx[3].ub[80];
        Ra.sl[6]=6406; /* line # 6406 */
        ((SL *)Rv10)[18]=1;
        Ra.sl[6]=6407; /* line # 6407 */
        if (Lx[3].v[11]!=NULL) {
          Ra.sl[6]=6408; /* line # 6408 */
          if (Rv3) ((V *)Rv10)[3]=Lx[3].v[11];
          else {
            Ra.sl[6]=6411; /* line # 6411 */
            if (((V *)Rv10)[3]!=NULL) {
              Ra.sl[6]=6412; /* line # 6412 */
              if (P_match(((V *)Rv10)[3],Lx[3].v[11])!=0) {
                Ra.sl[6]=6413; /* line # 6413 */
                P_src_error(Rd.s+1029,129,1);
              }
            }
          }
        }
        else {
          Ra.sl[6]=6418; /* line # 6418 */
          if (((UB *)Rv10)[32]==29) {
            Ra.sl[6]=6419; /* line # 6419 */
            P_set_gbl_def_nam(((V *)Rv10)+3,Lx[3].s+48,80);
          }
          else {
            Ra.sl[6]=6421; /* line # 6421 */
            P_set_gbl_def_nam(((V *)Rv10)+3,(V_opname.s+Lx[3].ub[82]*32),80);
          }
        }
        Ra.sl[6]=6424; /* line # 6424 */
        switch (Lx[3].ub[80]) {
          case 3:Ra.sl[6]=6425; /* line # 6425 */
          Lx[3].ub[0]=0;
          break;
          case 9:Ra.sl[6]=6427; /* line # 6427 */
          if (Lx[3].sl[24]>1) {
            Ra.sl[6]=6428; /* line # 6428 */
            P_src_error(Rd.s+1029,404,2);
          }
          break;
          default:break;
        }
      }
      Ra.sl[6]=6433; /* line # 6433 */
      Rv11=0;
      Ra.sl[6]=6434; /* line # 6434 */
      Rv12=0;
      while (1){
        Ra.sl[6]=6436; /* line # 6436 */
        switch (V_sy_sym.ub[0]) {
          case 86:Ra.sl[6]=6439; /* line # 6439 */
          P_insymbol();
          ((UW *)Rv10)[8]=1;
          Ra.sl[6]=6440; /* line # 6440 */
          Rv12=1;
          break;
          case 5:
          case 84:Ra.sl[6]=6446; /* line # 6446 */
          if (V_sy_sym.ub[0]==84) {
            Ra.sl[6]=6447; /* line # 6447 */
            ((UB *)Rv10)[104]=9;
            P_insymbol();
          }
          Ra.sl[6]=6448; /* line # 6448 */
          if (V_sy_sym.ub[0]==5) P_set_stdname(Lx[3].v[3]);
          else {
            Ra.sl[6]=6449; /* line # 6449 */
            P_src_error(Rd.s+1029,58,2);
          }
          Ra.sl[6]=6450; /* line # 6450 */
          Rv12=1;
          break;
          default:Ra.sl[6]=6454; /* line # 6454 */
          Rv11=1;
          Ra.sl[6]=6455; /* line # 6455 */
          if (Rv12) {
            Ra.sl[6]=6456; /* line # 6456 */
            if (V_sy_sym.ub[0]==18) P_insymbol();
            else {
              Ra.sl[6]=6457; /* line # 6457 */
              P_src_error(Rd.s+1029,21,2);
            }
          }
          break;
        }
        if (Rv11)  break;
      }
      Ra.sl[6]=6461; /* line # 6461 */
      if (((V *)Rv10)[3]==NULL) {
        Ra.sl[6]=6463; /* line # 6463 */
        if (Lx[3].ub[81]&&((SL *)Rv10)[18]<=1) {
          Ra.sl[6]=6465; /* line # 6465 */
          ((UB *)Rv10)[32]=Lx[3].ub[82];
          Ra.sl[6]=6466; /* line # 6466 */
          ((V *)Rv10)[3]=PAS__NEW(32);
          Ra.sl[6]=6467; /* line # 6467 */
          if (((UB *)Rv10)[32]==29) memcpy(((V *)Rv10)[3],Lx[3].s+48,32);
          else {
            Ra.sl[6]=6468; /* line # 6468 */
            memcpy(((V *)Rv10)[3],(V_opname.s+Lx[3].ub[82]*32),32);
          }
        }
        else {
          Ra.sl[6]=6471; /* line # 6471 */
          ((V *)Rv10)[3]=P_new_int_name(Rd.s+1041,&V_proc_seq);
        }
      }
    }
  }
  Ra.sl[6]=6474; /* line # 6474 */
  V_curr_lex=Lx[3].sl[24];
  Ra.sl[6]=6475; /* line # 6475 */
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6476; /* line # 6476 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " proc_body "  */
void PAS_COMILER_PRC_00000052(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1045;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6490; /* line # 6490 */
  V_curr_disp=Lx[3].sl[8];
  Ra.sl[6]=6491; /* line # 6491 */
  V_curr_lex=Lx[3].sl[9];
  Ra.sl[6]=6492; /* line # 6492 */
  Rv0=Lx[3].v[3];
  Ra.sl[6]=6494; /* line # 6494 */
  if (V_cmp_traceopt>0) {
    Ra.sl[6]=6496; /* line # 6496 */
    if (V_cmp_trace>=0) Rv1=3;
    else {
      Ra.sl[6]=6498; /* line # 6498 */
      Rv1=5;
    }
    Ra.sl[6]=6499; /* line # 6499 */
    V_cmp_trace=V_cmp_traceopt;
    Ra.sl[6]=6500; /* line # 6500 */
    P_gen_cntxvar(Lx[3].v[3],Lx[3].v[14]);
  }
  else {
    Ra.sl[6]=6503; /* line # 6503 */
    if (V_cmp_trace>0) V_cmp_trace=0;
  }
  Ra.sl[6]=6505; /* line # 6505 */
  P_lgt_all_fparm(Lx[3].v[3]);
  Ra.sl[6]=6507; /* line # 6507 */
  P_cmp_block(Lx[3].v[3],1, Rv1);
  Ra.sl[6]=6509; /* line # 6509 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=6510; /* line # 6510 */
    P_src_error(Rd.s+1058,54,3);
  }
  Ra.sl[6]=6512; /* line # 6512 */
  if (V_sy_sym.ub[0]==0&&Lx[3].ub[82]==29) {
    Ra.sl[6]=6513; /* line # 6513 */
    Ra.sl[6]=6514; /* line # 6514 */
    if (V_sy_sym.ub[0]==0&&P_match(Lx[3].s+48,V_sy_ident.s)==0) {
      Ra.sl[6]=6515; /* line # 6515 */
      P_insymbol();
    }
    else {
      Ra.sl[6]=6516; /* line # 6516 */
      P_src_error_s(Rd.s+1058,71,2, V_sy_ident.s,NULL);
    }
  }
  else {
    Ra.sl[6]=6518; /* line # 6518 */
    if (V_sy_sym.ub[0]!=18) {
      Ra.sl[6]=6519; /* line # 6519 */
      if (V_sy_sym.ub[0]==22&&Lx[3].ub[82]==28||V_sy_sym.ub[1]==Lx[3].ub[82]) P_insymbol();
      else {
        Ra.sl[6]=6520; /* line # 6520 */
        P_src_error(Rd.s+1058,72,2);
      }
    }
  }
  Ra.sl[6]=6522; /* line # 6522 */
  if (V_sy_sym.ub[0]!=18) P_src_error(Rd.s+1058,21,2);
  else {
    Ra.sl[6]=6523; /* line # 6523 */
    P_insymbol();
  }
  Ra.sl[6]=6528; /* line # 6528 */
  if (V_cmp_objf&&V_error_result<=1) {
    Ra.sl[6]=6531; /* line # 6531 */
    if (V_cmp_trace>0&&((V *)Rv0)[16]!=NULL) {
      Ra.sl[6]=6532; /* line # 6532 */
      P_gen_linetrace(Lx[3].v[3],((V *)Rv0)+16,((V *)Rv0)+17,4);
    }
    Ra.sl[6]=6534; /* line # 6534 */
    if (((V *)Rv0)[16]!=((V *)Rv0)[17]) {
      Ra.sl[6]=6536; /* line # 6536 */
      P_lgt_new(((V *)Rv0)+16,NULL,0,((V *)Rv0)[16]);
      Ra.sl[6]=6537; /* line # 6537 */
      ((UB *)((V *)Rv0)[16])[41]=2;
      Ra.sl[6]=6538; /* line # 6538 */
      ((V *)Rv0)[17]=((V *)Rv0)[16];
    }
    Ra.sl[6]=6541; /* line # 6541 */
    if (((UB *)Rv0)[104]==11) {
      Ra.sl[6]=6542; /* line # 6542 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|129;
    }
    else {
      Ra.sl[6]=6544; /* line # 6544 */
      ((UW *)Rv0)[8]=((UW *)Rv0)[8]|128;
    }
    Ra.sl[6]=6547; /* line # 6547 */
    if (V_pro_last==NULL) V_pro_first=Lx[3].v[3];
    else {
      Ra.sl[6]=6548; /* line # 6548 */
      ((V *)V_pro_last)[0]=Lx[3].v[3];
    }
    Ra.sl[6]=6549; /* line # 6549 */
    V_pro_last=Lx[3].v[3];
    Ra.sl[6]=6552; /* line # 6552 */
    PAS_COMILER_cmp_pass2(Lx[3].v[3]);
  }
  Ra.sl[6]=6557; /* line # 6557 */
  V_curr_lex=Lx[3].sl[24];
  V_curr_disp=Lx[3].sl[25];
  Ra.sl[6]=6558; /* line # 6558 */
  Lx[5].v[1]=Lx[3].v[13];
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " gene_decl "  */
void PAS_COMILER_PRC_00000050(){
  /* Define the automatic variable space. */
  Blk( Ra, 184 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  SL Rv4;
  register V Rv5;
  UB Rv6;
  register V Rv7;
  UB Rv8;
  register V Rv9;
  SL Rv10;
  V Rv11;
  UB Rv12;
  register V Rv13;
  V Rv14;
  register V Rv15;
  register int Rf0;
  register P Lx_Sv;
  Lx_Sv=Lx[3];
  Lx[3].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[15]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+120;
  Ra.v[16]=Rd.s+1062;
  Ra.v[17]=Rd.s+17;
  Ra.sl[36]=6565; /* line # 6565 */
  Ra.ub[16]=0;
  Ra.sl[36]=6566; /* line # 6566 */
  Ra.ub[42]=1;
  Ra.sl[36]=6567; /* line # 6567 */
  Ra.ub[40]=0;
  Ra.sl[36]=6568; /* line # 6568 */
  Ra.v[3]=NULL;
  Ra.sl[36]=6569; /* line # 6569 */
  Ra.ub[82]=29;
  Ra.sl[36]=6570; /* line # 6570 */
  Ra.ub[81]=0;
  Ra.sl[36]=6571; /* line # 6571 */
  Rv0=NULL;
  Rv1=NULL;
  Ra.sl[36]=6572; /* line # 6572 */
  Ra.sl[11]=0;
  Ra.sl[36]=6574; /* line # 6574 */
  Ra.v[13]=Lx[5].v[1];
  Ra.sl[36]=6575; /* line # 6575 */
  Ra.sl[24]=V_curr_lex;
  Ra.sl[36]=6576; /* line # 6576 */
  Ra.sl[25]=V_curr_disp;
  Ra.sl[36]=6578; /* line # 6578 */
  Ra.sl[36]=6580; /* line # 6580 */
  Ra.ub[80]=10;
  Ra.sl[36]=6581; /* line # 6581 */
  Ra.v[11]=NULL;
  Ra.sl[36]=6582; /* line # 6582 */
  if (Lx[5].ub[16]!=1) {
    Ra.sl[36]=6584; /* line # 6584 */
    switch (Lx[5].ub[16]) {
      case 4:
      case 5:Ra.sl[36]=6587; /* line # 6587 */
      if (Lx[5].ub[16]==4) Ra.ub[80]=9;
      else {
        Ra.sl[36]=6588; /* line # 6588 */
        Ra.ub[80]=3;
      }
      Ra.sl[36]=6589; /* line # 6589 */
      if (Lx[5].v[3]!=NULL) {
        Ra.sl[36]=6590; /* line # 6590 */
        Ra.v[11]=Lx[5].v[3];
        Lx[5].v[3]=NULL;
      }
      break;
      default:Ra.sl[36]=6593; /* line # 6593 */
      P_src_error(Rd.s+1058,81,2);
      break;
    }
    Ra.sl[36]=6595; /* line # 6595 */
    Lx[5].ub[16]=1;
    Ra.sl[36]=6596; /* line # 6596 */
    Lx[5].v[3]=NULL;
  }
  Ra.sl[36]=6599; /* line # 6599 */
  Ra.ub[41]=V_sy_sym.ub[0]==77;
  Ra.sl[36]=6600; /* line # 6600 */
  P_insymbol();
  Ra.sl[36]=6601; /* line # 6601 */
  switch (V_sy_sym.ub[0]) {
    case 0:Ra.sl[36]=6604; /* line # 6604 */
    memcpy(Ra.s+48,V_sy_ident.s,32);
    Ra.sl[36]=6605; /* line # 6605 */
    V_err_prt=0;
    Ra.sl[36]=6606; /* line # 6606 */
    Rv1=P_ide_search(770);
    Ra.sl[36]=6607; /* line # 6607 */
    V_err_prt=1;
    Ra.sl[36]=6608; /* line # 6608 */
    if (Rv1!=NULL) {
      Ra.sl[36]=6609; /* line # 6609 */
      if (((SL *)Rv1)[12]!=V_curr_lex) Rv0=NULL;
      else {
        Ra.sl[36]=6610; /* line # 6610 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[36]=6611; /* line # 6611 */
      Rv0=NULL;
    }
    Ra.sl[36]=6613; /* line # 6613 */
    if (Rv0!=NULL) {
      Ra.sl[36]=6614; /* line # 6614 */
      Rv2=Rv0;
      Ra.sl[36]=6616; /* line # 6616 */
      Ra.v[14]=((V *)Rv2)[0];
      Ra.sl[36]=6617; /* line # 6617 */
      switch (((UB *)Rv2)[53]) {
        case 1:
        case 8:
        case 9:Ra.sl[36]=6619; /* line # 6619 */
        if (((V *)Rv2)[8]!=NULL) {
          Ra.sl[36]=6621; /* line # 6621 */
          Ra.ub[16]=1;
          Ra.sl[36]=6622; /* line # 6622 */
          Ra.v[3]=((V *)Rv2)[8];
          Ra.sl[36]=6623; /* line # 6623 */
          Rv3=Ra.v[3];
          Ra.sl[36]=6624; /* line # 6624 */
          if (((UB *)Rv3)[104]==8||((UB *)Rv3)[104]==3) {
            Ra.sl[36]=6625; /* line # 6625 */
            Ra.ub[42]=0;
          }
        }
        break;
        default:Ra.sl[36]=6630; /* line # 6630 */
        P_src_error_s(Rd.s+1058,101,3,((V *)Rv2)[0],NULL);
        break;
      }
      Ra.sl[36]=6633; /* line # 6633 */
      PAS_COMILER_PRC_00000051(((V *)Rv2)[10],((V *)Rv2)[11]);
      Ra.sl[36]=6635; /* line # 6635 */
      PAS_COMILER_PRC_00000049(((V *)Rv2)+10,((V *)Rv2)+11,Ra.v[1],((UB *)Rv2)[53]
      ==8);
    }
    else {
      Ra.sl[36]=6659; /* line # 6659 */
      Ra.ub[42]=0;
      Ra.sl[36]=6660; /* line # 6660 */
      Ra.v[14]=PAS__NEW(32);
      Ra.sl[36]=6661; /* line # 6661 */
      Ra.sl[36]=6663; /* line # 6663 */
      ((UB *)Ra.v[14])[0]=V_sy_ident.ub[0];
      Ra.sl[36]=6664; /* line # 6664 */
      Rv4=1;
      for( Rf0=V_sy_ident.ub[0];Rf0>0;Rf0-- ) {
        ((C *)Ra.v[14])[Rv4]=V_sy_ident.c[Rv4];
        Rv4++;
      }
      Ra.sl[36]=6667; /* line # 6667 */
      Ra.ub[81]=Rv1==NULL;
      Ra.sl[36]=6668; /* line # 6668 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6669; /* line # 6669 */
      memcpy(Ra.s+148,V_sy_ident.s,32);
      Ra.sl[36]=6670; /* line # 6670 */
      memcpy(V_sy_ident.s,Ra.s+48,32);
      Ra.sl[36]=6671; /* line # 6671 */
      if (Ra.ub[40]) {
        Ra.sl[36]=6673; /* line # 6673 */
        P_ide_new(8,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6674; /* line # 6674 */
        Rv5=Rv0;
        Ra.sl[36]=6676; /* line # 6676 */
        ((V *)Rv5)[10]=Ra.v[1];
        Ra.sl[36]=6677; /* line # 6677 */
        ((V *)Rv5)[11]=NULL;
        Ra.sl[36]=6679; /* line # 6679 */
        if (((UB *)Ra.v[3])[104]==8||((UB *)Ra.v[3])[104]==3) {
          Ra.sl[36]=6680; /* line # 6680 */
          ((V *)Rv5)[8]=Ra.v[3];
        }
        else {
          Ra.sl[36]=6681; /* line # 6681 */
          ((V *)Rv5)[8]=NULL;
        }
      }
      else {
        Ra.sl[36]=6687; /* line # 6687 */
        if (Rv1!=NULL) {
          Ra.sl[36]=6689; /* line # 6689 */
          Rv6=((UB *)Rv1)[53];
          Ra.sl[36]=6690; /* line # 6690 */
          ((V *)Ra.v[1])[0]=((V *)Rv1)[10];
        }
        else {
          Ra.sl[36]=6694; /* line # 6694 */
          Rv6=9;
          Ra.sl[36]=6695; /* line # 6695 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        Ra.sl[36]=6698; /* line # 6698 */
        P_ide_new(Rv6,((V *)Ra.v[3])[11],&Rv0);
        Ra.sl[36]=6702; /* line # 6702 */
        Rv7=Rv0;
        Ra.sl[36]=6704; /* line # 6704 */
        ((V *)Rv7)[10]=Ra.v[1];
        ((V *)Rv7)[11]=Ra.v[1];
        Ra.sl[36]=6706; /* line # 6706 */
        if (((UB *)Ra.v[3])[104]==8) ((V *)Rv7)[8]=Ra.v[3];
        else {
          Ra.sl[36]=6707; /* line # 6707 */
          ((V *)Rv7)[8]=NULL;
        }
      }
      Ra.sl[36]=6711; /* line # 6711 */
      memcpy(V_sy_ident.s,Ra.s+148,32);
    }
    Ra.sl[36]=6714; /* line # 6714 */
    if (V_sy_init_mod) {
      Ra.sl[36]=6716; /* line # 6716 */
      Rv8=1;
      Ra.sl[36]=6717; /* line # 6717 */
      switch (V_sy_sym.ub[0]) {
        case 58:Ra.sl[36]=6718; /* line # 6718 */
        V_new_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 59:Ra.sl[36]=6719; /* line # 6719 */
        V_newh_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 60:Ra.sl[36]=6720; /* line # 6720 */
        V_dispose_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 42:Ra.sl[36]=6721; /* line # 6721 */
        V_set_entry_proc=((V *)Ra.v[1])[2];
        break;
        case 61:Ra.sl[36]=6723; /* line # 6723 */
        V_iof_std_open=Rv0;
        break;
        case 39:Ra.sl[36]=6724; /* line # 6724 */
        V_iof_std_close=Rv0;
        break;
        case 62:Ra.sl[36]=6725; /* line # 6725 */
        V_inp_std_sel=Rv0;
        break;
        case 65:Ra.sl[36]=6726; /* line # 6726 */
        V_inp_std_gene=Rv0;
        break;
        case 66:Ra.sl[36]=6727; /* line # 6727 */
        V_inp_std_eoln=Rv0;
        break;
        case 35:Ra.sl[36]=6728; /* line # 6728 */
        V_inp_std_bin=Rv0;
        break;
        case 63:Ra.sl[36]=6729; /* line # 6729 */
        V_out_std_sel=Rv0;
        break;
        case 68:Ra.sl[36]=6730; /* line # 6730 */
        V_out_std_gene=Rv0;
        break;
        case 69:Ra.sl[36]=6731; /* line # 6731 */
        V_out_std_eoln=Rv0;
        break;
        case 36:Ra.sl[36]=6732; /* line # 6732 */
        V_out_std_bin=Rv0;
        break;
        case 41:Ra.sl[36]=6734; /* line # 6734 */
        V_gen_std_string1=Rv0;
        break;
        case 40:Ra.sl[36]=6735; /* line # 6735 */
        V_gen_std_cnfardsc=Rv0;
        break;
        default:Ra.sl[36]=6738; /* line # 6738 */
        Rv8=0;
        break;
      }
      Ra.sl[36]=6740; /* line # 6740 */
      if (Rv8) {
        Ra.sl[36]=6742; /* line # 6742 */
        P_insymbol();
        Ra.sl[36]=6743; /* line # 6743 */
        if (V_sy_sym.ub[0]==18) P_insymbol();
        else {
          Ra.sl[36]=6744; /* line # 6744 */
          P_src_error(Rd.s+1058,21,2);
        }
      }
    }
    Ra.sl[36]=6748; /* line # 6748 */
    if (Ra.v[3]!=NULL) ((V *)Ra.v[3])[5]=Rv0;
    break;
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 22:Ra.sl[36]=6760; /* line # 6760 */
    if (V_sy_sym.ub[0]==6) Ra.sl[11]=1;
    else {
      Ra.sl[36]=6761; /* line # 6761 */
      Ra.sl[11]=2;
    }
    Ra.sl[36]=6762; /* line # 6762 */
    if (V_sy_sym.ub[0]==22) {
      Ra.sl[36]=6764; /* line # 6764 */
      if (Ra.ub[41]) P_src_error(Rd.s+1058,115,3);
      Ra.sl[36]=6765; /* line # 6765 */
      Ra.ub[82]=28;
    }
    else {
      Ra.sl[36]=6768; /* line # 6768 */
      Ra.ub[82]=V_sy_sym.ub[1];
      Ra.sl[36]=6769; /* line # 6769 */
      if (!Ra.ub[41]) P_src_error(Rd.s+1058,116,3);
    }
    Ra.sl[36]=6771; /* line # 6771 */
    if (Ra.ub[82]==12) Ra.sl[11]=-1;
    Ra.sl[36]=6773; /* line # 6773 */
    memcpy(Ra.s+48,(V_opname.s+Ra.ub[82]*32),32);
    Ra.sl[36]=6775; /* line # 6775 */
    Ra.v[14]=PAS__NEW(32);
    Ra.sl[36]=6776; /* line # 6776 */
    Rv9=(V_opname.s+Ra.ub[82]*32);
    Ra.sl[36]=6778; /* line # 6778 */
    ((UB *)Ra.v[14])[0]=((UB *)Rv9)[0]+2;
    Ra.sl[36]=6779; /* line # 6779 */
    ((C *)Ra.v[14])[1]=79;
    Ra.sl[36]=6780; /* line # 6780 */
    ((C *)Ra.v[14])[2]=95;
    Ra.sl[36]=6781; /* line # 6781 */
    Rv10=1;
    for( Rf0=((UB *)Rv9)[0];Rf0>0;Rf0-- ) {
      ((C *)Ra.v[14])[(2+Rv10)]=((C *)Rv9)[Rv10];
      Rv10++;
    }
    Ra.sl[36]=6784; /* line # 6784 */
    Rv11=V_ope_table.v[Ra.ub[82]];
    Ra.sl[36]=6785; /* line # 6785 */
    if (Rv11!=NULL) Rv12=((SL *)Rv11)[1]==V_curr_lex;
    else {
      Ra.sl[36]=6786; /* line # 6786 */
      Rv12=0;
    }
    Ra.sl[36]=6787; /* line # 6787 */
    if (Rv12) {
      Ra.sl[36]=6788; /* line # 6788 */
      Rv13=Rv11;
      Ra.sl[36]=6790; /* line # 6790 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6791; /* line # 6791 */
      PAS_COMILER_PRC_00000051(((V *)Rv13)[3],((V *)Rv13)[4]);
      Ra.sl[36]=6792; /* line # 6792 */
      PAS_COMILER_PRC_00000049(((V *)Rv13)+3,((V *)Rv13)+4,Ra.v[1],0);
    }
    else {
      Ra.sl[36]=6804; /* line # 6804 */
      Ra.v[3]=NULL;
      Ra.sl[36]=6805; /* line # 6805 */
      PAS_COMILER_PRC_00000051(NULL,NULL);
      Ra.sl[36]=6806; /* line # 6806 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[36]=6808; /* line # 6808 */
        Rv14=PAS__NEW(40);
        Ra.sl[36]=6809; /* line # 6809 */
        Rv15=Rv14;
        Ra.sl[36]=6811; /* line # 6811 */
        ((UB *)Rv15)[0]=Ra.ub[82];
        Ra.sl[36]=6812; /* line # 6812 */
        ((SL *)Rv15)[1]=V_curr_lex;
        Ra.sl[36]=6813; /* line # 6813 */
        ((V *)Rv15)[1]=((V *)Lx[5].v[13])[19];
        Ra.sl[36]=6814; /* line # 6814 */
        ((V *)Rv15)[2]=Rv11;
        Ra.sl[36]=6815; /* line # 6815 */
        ((V *)Rv15)[3]=Ra.v[1];
        Ra.sl[36]=6816; /* line # 6816 */
        ((V *)Rv15)[4]=Ra.v[1];
        Ra.sl[36]=6817; /* line # 6817 */
        if (Rv11==NULL) {
          Ra.sl[36]=6818; /* line # 6818 */
          ((V *)Ra.v[1])[0]=NULL;
        }
        else {
          Ra.sl[36]=6820; /* line # 6820 */
          ((V *)Ra.v[1])[0]=((V *)Rv11)[3];
        }
      }
      Ra.sl[36]=6823; /* line # 6823 */
      ((V *)Lx[5].v[13])[19]=Rv14;
      Ra.sl[36]=6824; /* line # 6824 */
      V_ope_table.v[Ra.ub[82]]=Rv14;
    }
    Ra.sl[36]=6827; /* line # 6827 */
    if (Ra.v[3]!=NULL) ((UB *)Ra.v[3])[32]=Ra.ub[82];
    break;
    default:Ra.sl[36]=6837; /* line # 6837 */
    P_src_error(Rd.s+1058,117,3);
    break;
  }
  Ra.sl[36]=6840; /* line # 6840 */
  if (Ra.ub[0]) PAS_COMILER_PRC_00000052();
  PAS__curr_cntx=Ra.v[15];
  Lx[3]=Lx_Sv;
}


/* Procedure/Function : " gen_assign "  */
V PAS_COMILER_PRC_00000053(V F_target, UB F_bovr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1073;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6867; /* line # 6867 */
  Rv0=V_sy_label_flag;
  Ra.sl[6]=6868; /* line # 6868 */
  V_sy_label_flag=0;
  Ra.sl[6]=6871; /* line # 6871 */
  Rv1=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6873; /* line # 6873 */
  V_sy_label_flag=Rv0;
  Ra.sl[6]=6875; /* line # 6875 */
  ((V *)F_target)[0]=Rv1;
  Ra.sl[6]=6876; /* line # 6876 */
  if (((UB *)F_target)[40]==8) {
    Ra.sl[6]=6877; /* line # 6877 */
    Rv2=((V *)F_target)[6];
    Ra.sl[6]=6879; /* line # 6879 */
    Rv3=1;
    Ra.sl[6]=6880; /* line # 6880 */
    if (((V *)Rv2)[11]!=NULL) {
      Ra.sl[6]=6881; /* line # 6881 */
      if (((UB *)((V *)Rv2)[11])[93]==24) Rv3=0;
    }
    Ra.sl[6]=6882; /* line # 6882 */
    if (Rv3) P_src_error(Rd.s+1087,175,3);
  }
  Ra.sl[6]=6884; /* line # 6884 */
  Rv4=P_lgt_gen_store(F_target,0, F_bovr);
  Ra.sl[6]=6885; /* line # 6885 */
  Ret=Rv4;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " return_state "  */
V PAS_COMILER_PRC_00000054(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1091;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6903; /* line # 6903 */
  Rv0=NULL;
  Ra.sl[6]=6904; /* line # 6904 */
  Rv1=PAS_COMILER_PRC_00000023();
  Ra.sl[6]=6906; /* line # 6906 */
  if (Rv1!=NULL) {
    Ra.sl[6]=6907; /* line # 6907 */
    Rv2=Rv1;
    Ra.sl[6]=6909; /* line # 6909 */
    if (((V *)Rv2)[11]==NULL) {
      Ra.sl[6]=6910; /* line # 6910 */
      if (F_ip!=NULL) {
        Ra.sl[6]=6913; /* line # 6913 */
        P_src_error_s(Rd.s+1107,172,3,((V *)F_ip)[0],NULL);
        Ra.sl[6]=6914; /* line # 6914 */
        P_skip_symbol(18,0,0);
      }
      else {
        Ra.sl[6]=6918; /* line # 6918 */
        P_lgt_new(&Rv0,NULL,0,NULL);
        Ra.sl[6]=6919; /* line # 6919 */
        ((UB *)Rv0)[41]=7;
      }
    }
    else {
      Ra.sl[6]=6923; /* line # 6923 */
      Rv3=NULL;
      Ra.sl[6]=6924; /* line # 6924 */
      Lx[5].ub[40]=1;
      Ra.sl[6]=6925; /* line # 6925 */
      if (F_ip!=NULL) {
        Ra.sl[6]=6927; /* line # 6927 */
        if (F_ip!=((V *)Rv2)[5]) {
          Ra.sl[6]=6929; /* line # 6929 */
          P_src_error_s(Rd.s+1107,405,3,((V *)F_ip)[0],NULL);
          Ra.sl[6]=6930; /* line # 6930 */
          P_skip_symbol(18,0,0);
        }
      }
      Ra.sl[6]=6934; /* line # 6934 */
      if (((UB *)((V *)Rv2)[11])[92]) {
        Ra.sl[6]=6936; /* line # 6936 */
        P_lgt_new(&Rv3,((V *)Rv2)[11],12,NULL);
        Ra.sl[6]=6937; /* line # 6937 */
        ((V *)Rv3)[6]=Rv1;
        Ra.sl[6]=6938; /* line # 6938 */
        if (F_ip!=NULL) {
          Ra.sl[6]=6939; /* line # 6939 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6940; /* line # 6940 */
            P_src_error(Rd.s+1107,32,2);
          }
        }
      }
      else {
        Ra.sl[6]=6944; /* line # 6944 */
        if (F_ip==NULL||V_sy_sym.ub[0]==22) {
          Ra.sl[6]=6946; /* line # 6946 */
          Rv3=P_lgt_new_idref(((V *)Rv2)[8],NULL);
          Ra.sl[6]=6947; /* line # 6947 */
          Rv4=((V *)Rv2)[8];
          Ra.sl[6]=6948; /* line # 6948 */
          if ((((UB *)((V *)Rv4)[5])[90]||((UB *)((V *)Rv4)[5])[91])&&!(16&((UW *)
          Rv4)[42])) {
            Ra.sl[6]=6950; /* line # 6950 */
            P_init_d_varbl(((V *)Rv2)[8]);
          }
          Ra.sl[6]=6951; /* line # 6951 */
          if (F_ip!=NULL) P_insymbol();
        }
        else {
          Ra.sl[6]=6955; /* line # 6955 */
          V_sy_search=((V *)Rv2)[8];
          Ra.sl[6]=6956; /* line # 6956 */
          V_lastsymb=V_sy_sym.ub[0];
          Ra.sl[6]=6957; /* line # 6957 */
          V_sy_sym.ub[0]=0;
          Ra.sl[6]=6958; /* line # 6958 */
          Rv3=PAS_COMILER_PRC_00000000();
          Ra.sl[6]=6959; /* line # 6959 */
          if (V_sy_sym.ub[0]==22) P_insymbol();
          else {
            Ra.sl[6]=6960; /* line # 6960 */
            P_src_error(Rd.s+1107,32,2);
          }
        }
      }
      Ra.sl[6]=6965; /* line # 6965 */
      Rv0=PAS_COMILER_PRC_00000053(Rv3,1);
      Ra.sl[6]=6967; /* line # 6967 */
      if (F_ip==NULL) {
        Ra.sl[6]=6969; /* line # 6969 */
        P_lgt_new(&Rv0,NULL,0, Rv0);
        Ra.sl[6]=6970; /* line # 6970 */
        ((UB *)Rv0)[41]=7;
      }
    }
  }
  Ra.sl[6]=6974; /* line # 6974 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " assignment_state "  */
V PAS_COMILER_PRC_00000055(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1111;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=6987; /* line # 6987 */
  V_sy_search=F_ip;
  Ra.sl[6]=6989; /* line # 6989 */
  V_lastsymb=V_sy_sym.ub[0];
  Ra.sl[6]=6990; /* line # 6990 */
  V_sy_sym.ub[0]=0;
  Ra.sl[6]=6991; /* line # 6991 */
  Rv0=PAS_COMILER_PRC_00000000();
  Ra.sl[6]=6992; /* line # 6992 */
  Rv1=Rv0;
  Ra.sl[6]=6993; /* line # 6993 */
  switch (((UB *)Rv1)[40]) {
    case 1:
    case 2:
    case 3:
    case 7:
    case 8:
    case 13:Ra.sl[6]=7004; /* line # 7004 */
    if (((V *)Rv1)[3]==V_typ_std.v[28]&&((UB *)Rv1)[40]==7) {
      Ra.sl[6]=7005; /* line # 7005 */
      Rv2=Rv0;
    }
    else {
      Ra.sl[6]=7008; /* line # 7008 */
      if (!(2&((UW *)Rv1)[10])) {
        Ra.sl[6]=7010; /* line # 7010 */
        P_src_error(Rd.s+1131,173,2);
      }
      Ra.sl[6]=7012; /* line # 7012 */
      if (V_sy_sym.ub[0]!=22) P_src_error(Rd.s+1131,32,2);
      else {
        Ra.sl[6]=7013; /* line # 7013 */
        P_insymbol();
      }
      Ra.sl[6]=7014; /* line # 7014 */
      Rv2=PAS_COMILER_PRC_00000053(Rv0,0);
    }
    break;
    default:Ra.sl[6]=7019; /* line # 7019 */
    P_src_error(Rd.s+1131,174,3);
    Ra.sl[6]=7020; /* line # 7020 */
    P_skip_symbol(18,0,0);
    Ra.sl[6]=7021; /* line # 7021 */
    P_lgt_free_tree(&Rv0);
    Ra.sl[6]=7022; /* line # 7022 */
    Rv2=NULL;
    break;
  }
  Ra.sl[6]=7024; /* line # 7024 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " with_state "  */
V PAS_COMILER_PRC_00000056(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  UB Rv2;
  V Rv3;
  UB Rv4;
  UB Rv5;
  V Rv6;
  V Rv7;
  register V Rv8;
  register V Rv9;
  UB Rv10;
  V Rv11;
  register V Rv12;
  register V Rv13;
  register V Rv14;
  V Rv15;
  register V Rv16;
  V Rv17;
  V Rv18;
  register V Rv19;
  UB Rv20;
  register V Rv21;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1135;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7042; /* line # 7042 */
  Rv0=0;
  Ra.sl[6]=7043; /* line # 7043 */
  Rv1=NULL;
  Ra.sl[6]=7044; /* line # 7044 */
  Rv2=1;
  Ra.sl[6]=7045; /* line # 7045 */
  while (1){
    Ra.sl[6]=7047; /* line # 7047 */
    Rv3=PAS_COMILER_PRC_00000000();
    Ra.sl[6]=7048; /* line # 7048 */
    Rv4=0;
    Ra.sl[6]=7049; /* line # 7049 */
    Rv5=0;
    Ra.sl[6]=7050; /* line # 7050 */
    Rv6=NULL;
    Ra.sl[6]=7051; /* line # 7051 */
    Rv7=((V *)Rv3)[3];
    Ra.sl[6]=7053; /* line # 7053 */
    Rv8=Rv7;
    Rv9=Rv3;
    Ra.sl[6]=7054; /* line # 7054 */
    if (((((UB *)Rv8)[93]==5||((UB *)Rv8)[93]==7)||((UB *)Rv8)[93]==24)&&((V *)Rv8)
    [12]!=NULL) {
      Ra.sl[6]=7060; /* line # 7060 */
      Rv10=1;
      Ra.sl[6]=7061; /* line # 7061 */
      Rv4=1;
      Ra.sl[6]=7062; /* line # 7062 */
      Rv6=Rv7;
      Ra.sl[6]=7063; /* line # 7063 */
      Rv7=((V *)Rv6)[12];
    }
    else {
      Ra.sl[6]=7067; /* line # 7067 */
      Rv10=((UB *)Rv9)[40]!=14&&((UB *)Rv9)[40]!=13;
    }
    Ra.sl[6]=7069; /* line # 7069 */
    if (((UB *)Rv7)[93]!=10) Rv7=NULL;
    Ra.sl[6]=7071; /* line # 7071 */
    Rv2=Rv7==NULL;
    Ra.sl[6]=7073; /* line # 7073 */
    if (Rv2) {
      Ra.sl[6]=7075; /* line # 7075 */
      P_src_error(Rd.s+1149,176,3);
      Ra.sl[6]=7076; /* line # 7076 */
      P_skip_symbol(72,0,0);
    }
    else {
      Ra.sl[6]=7079; /* line # 7079 */
      if (Rv10) {
        Ra.sl[6]=7081; /* line # 7081 */
        if (!Rv4) {
          Ra.sl[6]=7082; /* line # 7082 */
          if (((UB *)Rv3)[40]==2&&((SL *)Rv3)[4]==0) {
            Ra.sl[6]=7084; /* line # 7084 */
            Rv11=((V *)Rv3)[1];
            Ra.sl[6]=7085; /* line # 7085 */
            P_lgt_free(&Rv3);
            Ra.sl[6]=7086; /* line # 7086 */
            Rv6=((V *)Rv11)[3];
            Ra.sl[6]=7087; /* line # 7087 */
            Rv3=Rv11;
          }
          else {
            Ra.sl[6]=7091; /* line # 7091 */
            if (Rv6==NULL) {
              Ra.sl[6]=7092; /* line # 7092 */
              P_ide_new_typ(5, &Rv6);
            }
            Ra.sl[6]=7093; /* line # 7093 */
            Rv12=Rv6;
            Ra.sl[6]=7095; /* line # 7095 */
            memcpy(Rv12+48,V_typ_std.v[13]+48,1);
            Ra.sl[6]=7096; /* line # 7096 */
            ((SL *)Rv12)[11]=V_fptr_size;
            Ra.sl[6]=7097; /* line # 7097 */
            ((V *)Rv12)[12]=Rv7;
            Ra.sl[6]=7099; /* line # 7099 */
            P_lgt_new(&Rv3, Rv6,4, Rv3);
          }
        }
        Ra.sl[6]=7104; /* line # 7104 */
        Ra.sl[6]=7106; /* line # 7106 */
        Rv5=1;
        Ra.sl[6]=7107; /* line # 7107 */
        P_lgt_new(&Rv11, Rv6,13,NULL);
        Ra.sl[6]=7108; /* line # 7108 */
        P_all_new(((V *)Rv11)+7,Rv6,NULL,0);
        Ra.sl[6]=7109; /* line # 7109 */
        ((V *)Rv11)[0]=Rv3;
        Ra.sl[6]=7110; /* line # 7110 */
        Rv3=P_lgt_new_code(3, Rv11);
        Ra.sl[6]=7111; /* line # 7111 */
        ((SL *)Rv3)[4]=0;
        Ra.sl[6]=7112; /* line # 7112 */
        ((V *)Rv3)[0]=Rv1;
        Ra.sl[6]=7113; /* line # 7113 */
        Rv1=Rv3;
      }
      else {
        Ra.sl[6]=7117; /* line # 7117 */
        Rv11=Rv3;
      }
    }
    Ra.sl[6]=7122; /* line # 7122 */
    if (V_curr_disp<64) {
      Ra.sl[6]=7124; /* line # 7124 */
      Rv0=Rv0+1;
      Ra.sl[6]=7125; /* line # 7125 */
      P_new_disp_level(NULL,1);
      Ra.sl[6]=7126; /* line # 7126 */
      Rv13=(V_lex_ident_tree.s+V_curr_disp*64);
      Ra.sl[6]=7128; /* line # 7128 */
      ((V *)Rv13)[2]=Rv11;
      Ra.sl[6]=7129; /* line # 7129 */
      Rv14=Rv7;
      Ra.sl[6]=7130; /* line # 7130 */
      if (((V *)Rv14)[4]!=NULL) {
        Ra.sl[6]=7132; /* line # 7132 */
        Rv15=((V *)Rv14)[4];
        Ra.sl[6]=7133; /* line # 7133 */
        while (Rv15!=NULL){
          Ra.sl[6]=7135; /* line # 7135 */
          ((UB *)Rv15)[60]=3;
          Ra.sl[6]=7136; /* line # 7136 */
          Rv15=((V *)Rv15)[3];
        }
        Ra.sl[6]=7138; /* line # 7138 */
        ((V *)Rv13)[1]=((V *)Rv14)[4];
      }
      else {
        Ra.sl[6]=7141; /* line # 7141 */
        ((V *)Rv13)[1]=((V *)Rv14)[12];
      }
      Ra.sl[6]=7143; /* line # 7143 */
      ((SL *)Rv13)[13]=0;
      Ra.sl[6]=7144; /* line # 7144 */
      if (Rv10) {
        Ra.sl[6]=7145; /* line # 7145 */
        if (Rv5) ((UB *)Rv13)[24]=2;
        else {
          Ra.sl[6]=7146; /* line # 7146 */
          ((UB *)Rv13)[24]=3;
        }
      }
      else {
        Ra.sl[6]=7147; /* line # 7147 */
        ((UB *)Rv13)[24]=1;
      }
      Ra.sl[6]=7148; /* line # 7148 */
      if (((V *)Rv7)[4]!=NULL&&((UB *)Rv7)[93]==10) {
        Ra.sl[6]=7151; /* line # 7151 */
        Rv0=Rv0+1;
        Ra.sl[6]=7152; /* line # 7152 */
        P_new_disp_level(NULL,1);
        Ra.sl[6]=7153; /* line # 7153 */
        memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
        Ra.sl[6]=7154; /* line # 7154 */
        Rv16=(V_lex_ident_tree.s+V_curr_disp*64);
        Ra.sl[6]=7156; /* line # 7156 */
        ((V *)Rv16)[1]=((V *)Rv7)[12];
        Ra.sl[6]=7157; /* line # 7157 */
        ((SL *)Rv16)[13]=-1;
      }
    }
    else {
      Ra.sl[6]=7163; /* line # 7163 */
      P_src_error(Rd.s+1149,1003,4);
    }
    Ra.sl[6]=7164; /* line # 7164 */
    if (V_sy_sym.ub[0]==17) P_insymbol();
    if (V_sy_sym.ub[0]!=0)  break;
  }
  Ra.sl[6]=7166; /* line # 7166 */
  Ra.sl[6]=7168; /* line # 7168 */
  if (V_sy_sym.ub[0]==53) P_insymbol();
  else P_src_error(Rd.s+1149,55,2);
  Ra.sl[6]=7171; /* line # 7171 */
  Rv17=V_cntx_label;
  Ra.sl[6]=7172; /* line # 7172 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7173; /* line # 7173 */
  Rv18=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=7175; /* line # 7175 */
  if (Rv18!=NULL) {
    Ra.sl[6]=7176; /* line # 7176 */
    Rv19=Rv18;
    Ra.sl[6]=7177; /* line # 7177 */
    if (((UB *)Rv19)[40]==0) {
      Ra.sl[6]=7178; /* line # 7178 */
      switch (((UB *)Rv19)[41]) {
        case 0:
        case 2:Ra.sl[6]=7180; /* line # 7180 */
        Rv20=1;
        break;
        default:Ra.sl[6]=7183; /* line # 7183 */
        Rv20=0;
        break;
      }
    }
    else {
      Ra.sl[6]=7186; /* line # 7186 */
      Rv20=0;
    }
  }
  else {
    Ra.sl[6]=7187; /* line # 7187 */
    P_lgt_new(&Rv18,NULL,16,NULL);
  }
  Ra.sl[6]=7189; /* line # 7189 */
  P_label_purge(&Rv17);
  Ra.sl[6]=7192; /* line # 7192 */
  while (Rv0>0){
    Ra.sl[6]=7194; /* line # 7194 */
    Rv21=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=7196; /* line # 7196 */
    if (((SL *)Rv21)[13]>=0) {
      Ra.sl[6]=7197; /* line # 7197 */
      if (((SL *)Rv21)[13]==0) {
        Ra.sl[6]=7199; /* line # 7199 */
        switch (((UB *)Rv21)[24]) {
          case 1:
          case 3:Ra.sl[6]=7202; /* line # 7202 */
          P_lgt_free_tree(((V *)Rv21)+2);
          break;
          case 2:Ra.sl[6]=7206; /* line # 7206 */
          Rv3=Rv1;
          Ra.sl[6]=7207; /* line # 7207 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7208; /* line # 7208 */
          ((V *)Rv3)[0]=NULL;
          Ra.sl[6]=7209; /* line # 7209 */
          P_all_free(((V *)((V *)Rv21)[2])[7]);
          Ra.sl[6]=7210; /* line # 7210 */
          ((V *)Rv21)[2]=NULL;
          Ra.sl[6]=7211; /* line # 7211 */
          P_lgt_free_tree(&Rv3);
          break;
          default:break;
        }
      }
      else {
        Ra.sl[6]=7217; /* line # 7217 */
        if (((UB *)Rv21)[24]==2) {
          Ra.sl[6]=7219; /* line # 7219 */
          Rv3=Rv1;
          Ra.sl[6]=7220; /* line # 7220 */
          Rv1=((V *)Rv3)[0];
          Ra.sl[6]=7222; /* line # 7222 */
          if (Rv20) {
            Ra.sl[6]=7224; /* line # 7224 */
            ((V *)Rv3)[0]=((V *)Rv18)[1];
            Ra.sl[6]=7225; /* line # 7225 */
            ((V *)Rv18)[1]=Rv3;
          }
          else {
            Ra.sl[6]=7229; /* line # 7229 */
            Rv20=1;
            Ra.sl[6]=7230; /* line # 7230 */
            ((V *)Rv3)[0]=Rv18;
            Ra.sl[6]=7231; /* line # 7231 */
            P_lgt_new(&Rv18,NULL,0, Rv3);
            Ra.sl[6]=7232; /* line # 7232 */
            ((UB *)Rv18)[41]=2;
          }
        }
      }
    }
    Ra.sl[6]=7236; /* line # 7236 */
    Rv15=((V *)Rv21)[1];
    Ra.sl[6]=7237; /* line # 7237 */
    if (((UB *)Rv15)[53]==2) {
      Ra.sl[6]=7239; /* line # 7239 */
      while (Rv15!=NULL){
        Ra.sl[6]=7241; /* line # 7241 */
        ((UB *)Rv15)[60]=0;
        Ra.sl[6]=7242; /* line # 7242 */
        ((V *)Rv15)[9]=NULL;
        Ra.sl[6]=7243; /* line # 7243 */
        Rv15=((V *)Rv15)[3];
      }
    }
    Ra.sl[6]=7246; /* line # 7246 */
    V_curr_disp=V_curr_disp -1;
    Ra.sl[6]=7247; /* line # 7247 */
    Rv0=Rv0-1;
  }
  Ra.sl[6]=7250; /* line # 7250 */
  Ret=Rv18;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " if_state "  */
V PAS_COMILER_PRC_00000057(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  V Rv5;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1153;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7264; /* line # 7264 */
  Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,1,0);
  Ra.sl[6]=7265; /* line # 7265 */
  Rv1=NULL;
  Ra.sl[6]=7266; /* line # 7266 */
  Rv2=NULL;
  Ra.sl[6]=7267; /* line # 7267 */
  Rv3=V_cntx_label;
  Ra.sl[6]=7268; /* line # 7268 */
  Rv4=Rv0;
  Ra.sl[6]=7270; /* line # 7270 */
  if (V_sy_sym.ub[0]==45) P_insymbol();
  else P_src_error(Rd.s+1165,56,2);
  Ra.sl[6]=7272; /* line # 7272 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7273; /* line # 7273 */
  Rv1=PAS_COMILER_PRC_00000036(NULL,1);
  Ra.sl[6]=7274; /* line # 7274 */
  P_label_purge(&Rv3);
  Ra.sl[6]=7275; /* line # 7275 */
  if (V_sy_sym.ub[0]!=18) {
    Ra.sl[6]=7276; /* line # 7276 */
    if (V_sy_sym.ub[0]==46) {
      Ra.sl[6]=7278; /* line # 7278 */
      P_insymbol();
      Ra.sl[6]=7279; /* line # 7279 */
      V_cntx_lblvl=V_cntx_lblvl+1;
      Ra.sl[6]=7280; /* line # 7280 */
      Rv2=PAS_COMILER_PRC_00000036(NULL,1);
      Ra.sl[6]=7281; /* line # 7281 */
      P_label_purge(&Rv3);
    }
  }
  Ra.sl[6]=7284; /* line # 7284 */
  if (Rv1==NULL&&Rv2==NULL) {
    Ra.sl[6]=7286; /* line # 7286 */
    P_lgt_free(&Rv0);
    Ra.sl[6]=7287; /* line # 7287 */
    Rv5=NULL;
  }
  else {
    Ra.sl[6]=7290; /* line # 7290 */
    if (((UB *)Rv4)[40]==14) {
      Ra.sl[6]=7292; /* line # 7292 */
      if (((SL *)((V *)Rv4)[7])[13]>0) {
        Ra.sl[6]=7294; /* line # 7294 */
        Rv5=Rv1;
        Ra.sl[6]=7295; /* line # 7295 */
        P_lgt_free_tree(&Rv2);
      }
      else {
        Ra.sl[6]=7299; /* line # 7299 */
        Rv5=Rv2;
        Ra.sl[6]=7300; /* line # 7300 */
        P_lgt_free_tree(&Rv1);
      }
      Ra.sl[6]=7302; /* line # 7302 */
      P_lgt_free(&Rv0);
    }
    else {
      Ra.sl[6]=7307; /* line # 7307 */
      if (Rv1==NULL) {
        Ra.sl[6]=7309; /* line # 7309 */
        Rv0=P_exp_genop(0, Rv0);
        Ra.sl[6]=7310; /* line # 7310 */
        ((V *)Rv0)[0]=Rv2;
      }
      else {
        Ra.sl[6]=7314; /* line # 7314 */
        ((V *)Rv0)[0]=Rv1;
        Ra.sl[6]=7315; /* line # 7315 */
        ((V *)Rv1)[0]=Rv2;
      }
      Ra.sl[6]=7317; /* line # 7317 */
      P_lgt_new(&Rv5,NULL,0, Rv0);
      Ra.sl[6]=7318; /* line # 7318 */
      ((UB *)Rv5)[41]=8;
    }
  }
  Ra.sl[6]=7322; /* line # 7322 */
  Ret=Rv5;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " exit_state "  */
V PAS_COMILER_PRC_00000058(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;
  V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1169;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7336; /* line # 7336 */
  Ra.sl[6]=7338; /* line # 7338 */
  P_lgt_new(&Rv0,NULL,16, Lx[5].v[6]);
  Ra.sl[6]=7339; /* line # 7339 */
  if (Lx[5].v[6]==NULL) {
    Ra.sl[6]=7340; /* line # 7340 */
    P_src_error(Rd.s+1183,244,2);
  }
  Ra.sl[6]=7341; /* line # 7341 */
  P_lgt_new(&Rv1,NULL,0, Rv0);
  Ra.sl[6]=7342; /* line # 7342 */
  ((UB *)Rv1)[41]=6;
  Ra.sl[6]=7343; /* line # 7343 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7344; /* line # 7344 */
  if (V_sy_sym.ub[0]==0) {
    Ra.sl[6]=7346; /* line # 7346 */
    Rv2=P_ide_search(8);
    Ra.sl[6]=7347; /* line # 7347 */
    if (Rv2==V_ide_udptr.v[3]) Rv2=NULL;
    Ra.sl[6]=7348; /* line # 7348 */
    if (Rv2!=NULL) {
      Ra.sl[6]=7349; /* line # 7349 */
      Rv3=Rv2;
      Ra.sl[6]=7352; /* line # 7352 */
      Rv4=V_cntx_label;
      Ra.sl[6]=7353; /* line # 7353 */
      while (Rv4!=NULL&&Rv4!=Rv2)
      Rv4=((V *)Rv4)[8];
      Ra.sl[6]=7354; /* line # 7354 */
      if (Rv4==NULL) {
        Ra.sl[6]=7356; /* line # 7356 */
        P_src_error(Rd.s+1183,177,3);
      }
      Ra.sl[6]=7357; /* line # 7357 */
      ((UB *)Rv3)[54]=((UB *)Rv3)[54]|2;
      Ra.sl[6]=7358; /* line # 7358 */
      ((V *)Rv0)[1]=((V *)Rv3)[10];
    }
    Ra.sl[6]=7366; /* line # 7366 */
    P_insymbol();
  }
  Ra.sl[6]=7369; /* line # 7369 */
  if (V_sy_sym.ub[0]==44) {
    Ra.sl[6]=7371; /* line # 7371 */
    P_insymbol();
    Ra.sl[6]=7373; /* line # 7373 */
    ((V *)Rv0)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
  }
  Ra.sl[6]=7376; /* line # 7376 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " loop_state "  */
V PAS_COMILER_PRC_00000059(UB F_symb){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  V Rv5;
  V Rv6;
  register V Rv7;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1187;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7392; /* line # 7392 */
  Rv0=Lx[5].v[6];
  Ra.sl[6]=7393; /* line # 7393 */
  P_lgt_new(Lx[5].v+6,NULL,0,NULL);
  Ra.sl[6]=7394; /* line # 7394 */
  ((UB *)Lx[5].v[6])[41]=4;
  Ra.sl[6]=7395; /* line # 7395 */
  Rv1=Lx[5].v[6];
  Ra.sl[6]=7396; /* line # 7396 */
  if (F_symb==47) {
    Ra.sl[6]=7398; /* line # 7398 */
    Rv2=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7399; /* line # 7399 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7400; /* line # 7400 */
      P_src_error(Rd.s+1201,55,2);
    }
  }
  else {
    Ra.sl[6]=7403; /* line # 7403 */
    P_lgt_new(&Rv2,NULL,16,NULL);
  }
  Ra.sl[6]=7404; /* line # 7404 */
  ((V *)Rv1)[1]=Rv2;
  Ra.sl[6]=7406; /* line # 7406 */
  Ra.sl[6]=7408; /* line # 7408 */
  Rv3=Lx[4].v[0];
  Ra.sl[6]=7409; /* line # 7409 */
  if (Rv3!=NULL) ((V *)Rv3)[10]=Lx[5].v[6];
  Ra.sl[6]=7411; /* line # 7411 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7413; /* line # 7413 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7416; /* line # 7416 */
  switch (F_symb) {
    case 47:Ra.sl[6]=7417; /* line # 7417 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000036(NULL,1);
    break;
    case 48:Ra.sl[6]=7421; /* line # 7421 */
    Rv5=PAS_COMILER_PRC_00000035(49,0);
    Ra.sl[6]=7422; /* line # 7422 */
    if (V_sy_sym.ub[0]==49) P_insymbol();
    else {
      Ra.sl[6]=7423; /* line # 7423 */
      P_src_error(Rd.s+1201,57,2);
    }
    Ra.sl[6]=7426; /* line # 7426 */
    P_lgt_new(&Rv6,NULL,16,NULL);
    Ra.sl[6]=7427; /* line # 7427 */
    Rv7=Rv6;
    Ra.sl[6]=7429; /* line # 7429 */
    ((V *)Rv7)[0]=PAS_COMILER_PRC_00000005(V_typ_std.v[1],0,0,0);
    Ra.sl[6]=7430; /* line # 7430 */
    ((V *)Rv7)[1]=Lx[5].v[6];
    Ra.sl[6]=7432; /* line # 7432 */
    P_lgt_new(&Rv6,NULL,0, Rv6);
    Ra.sl[6]=7433; /* line # 7433 */
    ((UB *)Rv6)[41]=6;
    Ra.sl[6]=7434; /* line # 7434 */
    if (Rv5!=NULL) {
      Ra.sl[6]=7436; /* line # 7436 */
      ((V *)Lx[5].v[7])[0]=Rv6;
      Ra.sl[6]=7437; /* line # 7437 */
      ((V *)Rv2)[0]=Rv5;
    }
    else {
      Ra.sl[6]=7440; /* line # 7440 */
      ((V *)Rv2)[0]=Rv6;
    }
    break;
    case 54:Ra.sl[6]=7445; /* line # 7445 */
    ((V *)Rv2)[0]=PAS_COMILER_PRC_00000035(72,0);
    Ra.sl[6]=7446; /* line # 7446 */
    if (V_sy_sym.ub[0]!=72) P_src_error(Rd.s+1201,54,2);
    else {
      Ra.sl[6]=7447; /* line # 7447 */
      P_insymbol();
    }
    Ra.sl[6]=7448; /* line # 7448 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=7449; /* line # 7449 */
      if (Rv3==P_ide_search(8)) {
        Ra.sl[6]=7450; /* line # 7450 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=7452; /* line # 7452 */
        P_src_error_s(Rd.s+1201,179,2, V_sy_ident.s,NULL);
      }
    }
    break;
  }
  Ra.sl[6]=7455; /* line # 7455 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7458; /* line # 7458 */
  Lx[5].v[6]=Rv0;
  Ra.sl[6]=7459; /* line # 7459 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " for_state "  */
V PAS_COMILER_PRC_00000060(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  SL Rv3;
  V Rv4;
  V Rv5;
  UB Rv6;
  V Rv7;
  V Rv8;
  V Rv9;
  V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Ret;

  /* Code of procedure/function */
  Rv0=NULL;
  Rv1=NULL;
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1205;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7477; /* line # 7477 */
  Rv2=Lx[5].v[6];
  Ra.sl[6]=7478; /* line # 7478 */
  Rv3=V_curr_disp;
  Ra.sl[6]=7479; /* line # 7479 */
  Rv4=V_cntx_label;
  Ra.sl[6]=7480; /* line # 7480 */
  P_new_disp_level(Lx[5].v[13],0);
  Ra.sl[6]=7481; /* line # 7481 */
  Ra.sl[6]=7482; /* line # 7482 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1218,168,2);
  else {
    Ra.sl[6]=7485; /* line # 7485 */
    P_ide_new(5,NULL,&Rv5);
    Ra.sl[6]=7486; /* line # 7486 */
    P_insymbol();
    Ra.sl[6]=7487; /* line # 7487 */
    if (V_sy_sym.ub[0]==22) P_insymbol();
    else P_src_error(Rd.s+1218,32,2);
    Ra.sl[6]=7488; /* line # 7488 */
    V_sy_fix_range_ctl=0;
    Ra.sl[6]=7489; /* line # 7489 */
    Rv0=PAS_COMILER_PRC_00000005(V_typ_std.v[15],0,1,0);
    Ra.sl[6]=7492; /* line # 7492 */
    switch (V_sy_sym.ub[0]) {
      case 51:Ra.sl[6]=7495; /* line # 7495 */
      P_insymbol();
      Ra.sl[6]=7496; /* line # 7496 */
      Rv6=38;
      break;
      case 52:Ra.sl[6]=7501; /* line # 7501 */
      P_insymbol();
      Ra.sl[6]=7502; /* line # 7502 */
      Rv6=39;
      break;
      default:Ra.sl[6]=7506; /* line # 7506 */
      P_src_error(Rd.s+1218,59,2);
      Ra.sl[6]=7507; /* line # 7507 */
      Rv6=38;
      break;
    }
    Ra.sl[6]=7510; /* line # 7510 */
    Rv7=PAS_COMILER_PRC_00000005(((V *)Rv0)[3],0,1,0);
    Ra.sl[6]=7512; /* line # 7512 */
    if (V_sy_sym.ub[0]==53) P_insymbol();
    else {
      Ra.sl[6]=7513; /* line # 7513 */
      P_src_error(Rd.s+1218,55,2);
    }
    Ra.sl[6]=7515; /* line # 7515 */
    P_lgt_new(Lx[5].v+6,V_typ_std.v[2],0,NULL);
    Ra.sl[6]=7516; /* line # 7516 */
    ((UB *)Lx[5].v[6])[41]=5;
    Ra.sl[6]=7518; /* line # 7518 */
    if (Rv6==39) {
      Ra.sl[6]=7520; /* line # 7520 */
      Rv8=Rv7;
      Ra.sl[6]=7522; /* line # 7522 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv7);
      else {
        Ra.sl[6]=7523; /* line # 7523 */
        Rv7=Rv0;
      }
    }
    else {
      Ra.sl[6]=7527; /* line # 7527 */
      if (((UB *)Rv0)[40]==14) P_lgt_new_copy(Rv0, &Rv8);
      else {
        Ra.sl[6]=7528; /* line # 7528 */
        Rv8=Rv0;
      }
    }
    Ra.sl[6]=7530; /* line # 7530 */
    if (((UB *)Rv8)[40]==14) {
      Ra.sl[6]=7532; /* line # 7532 */
      Rv9=Rv7;
      Ra.sl[6]=7533; /* line # 7533 */
      Rv10=P_lgt_new_econst(((V *)Rv8)[3],((SL *)((V *)Rv8)[7])[13]-1);
    }
    else {
      Ra.sl[6]=7537; /* line # 7537 */
      Rv10=Rv8;
      Ra.sl[6]=7538; /* line # 7538 */
      if (((UB *)Rv7)[40]==14) {
        Ra.sl[6]=7539; /* line # 7539 */
        Rv9=P_lgt_new_econst(((V *)Rv7)[3],((SL *)((V *)Rv7)[7])[13]+1);
      }
      else {
        Ra.sl[6]=7542; /* line # 7542 */
        ((V *)Rv7)[0]=P_lgt_new_econst(V_typ_std.v[2],1);
        Ra.sl[6]=7543; /* line # 7543 */
        Rv9=P_lgt_new_code(49, Rv7);
      }
    }
    Ra.sl[6]=7547; /* line # 7547 */
    Rv7=P_lgt_new_addsub(1,1, Rv9, Rv10);
    Ra.sl[6]=7550; /* line # 7550 */
    ((V *)Lx[5].v[6])[1]=Rv7;
    Ra.sl[6]=7552; /* line # 7552 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=7554; /* line # 7554 */
    Rv11=Rv5;
    Ra.sl[6]=7556; /* line # 7556 */
    ((V *)Rv11)[5]=((V *)Rv8)[3];
    Ra.sl[6]=7557; /* line # 7557 */
    ((UW *)Rv11)[42]=32;
    Ra.sl[6]=7558; /* line # 7558 */
    ((UB *)Rv11)[86]=1;
    Ra.sl[6]=7561; /* line # 7561 */
    Rv12=Lx[4].v[0];
    Ra.sl[6]=7562; /* line # 7562 */
    if (Rv12!=NULL) {
      Ra.sl[6]=7563; /* line # 7563 */
      Rv13=Rv12;
      Ra.sl[6]=7565; /* line # 7565 */
      ((V *)Rv13)[8]=V_cntx_label;
      Ra.sl[6]=7566; /* line # 7566 */
      V_cntx_label=Rv12;
      Ra.sl[6]=7567; /* line # 7567 */
      ((V *)Rv13)[10]=Lx[5].v[6];
    }
    Ra.sl[6]=7570; /* line # 7570 */
    V_cntx_lblvl=V_cntx_lblvl+1;
    Ra.sl[6]=7573; /* line # 7573 */
    Rv8=PAS_COMILER_PRC_00000036(NULL,1);
    Ra.sl[6]=7574; /* line # 7574 */
    ((V *)Rv7)[0]=Rv8;
    Ra.sl[6]=7576; /* line # 7576 */
    if (1&((UW *)Rv5)[42]) {
      Ra.sl[6]=7581; /* line # 7581 */
      Rv0=P_lgt_link(Rv0);
      Ra.sl[6]=7582; /* line # 7582 */
      Rv0=P_lgt_new_idref(Rv5, Rv0);
      Ra.sl[6]=7583; /* line # 7583 */
      Rv0=P_lgt_new_code(3, Rv0);
      Ra.sl[6]=7584; /* line # 7584 */
      ((V *)Rv0)[0]=Lx[5].v[6];
      Ra.sl[6]=7586; /* line # 7586 */
      P_lgt_new(Lx[5].v+6,NULL,0, Rv0);
      Ra.sl[6]=7587; /* line # 7587 */
      ((UB *)Lx[5].v[6])[41]=2;
      Ra.sl[6]=7590; /* line # 7590 */
      Rv0=P_lgt_new_idref(Rv5,NULL);
      Ra.sl[6]=7591; /* line # 7591 */
      Rv0=P_lgt_new_code(Rv6, Rv0);
      Ra.sl[6]=7592; /* line # 7592 */
      ((V *)Rv0)[3]=Rv1;
      Ra.sl[6]=7593; /* line # 7593 */
      if (Rv8!=NULL) ((V *)Rv8)[0]=Rv0;
      else {
        Ra.sl[6]=7594; /* line # 7594 */
        ((V *)Rv7)[0]=Rv0;
      }
    }
    else {
      Ra.sl[6]=7598; /* line # 7598 */
      if (((UB *)Rv0)[40]==14) P_lgt_free(&Rv0);
    }
    Ra.sl[6]=7600; /* line # 7600 */
    Rv0=Lx[5].v[6];
  }
  Ra.sl[6]=7603; /* line # 7603 */
  Lx[5].v[6]=Rv2;
  Ra.sl[6]=7605; /* line # 7605 */
  if (V_curr_disp>Rv3) {
    Ra.sl[6]=7607; /* line # 7607 */
    P_ide_reserve_disp(Rv3);
  }
  Ra.sl[6]=7608; /* line # 7608 */
  P_label_purge(&Rv4);
  Ra.sl[6]=7609; /* line # 7609 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " goto_state "  */
V PAS_COMILER_PRC_00000061(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1222;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7622; /* line # 7622 */
  Rv0=NULL;
  Ra.sl[6]=7623; /* line # 7623 */
  if (V_sy_sym.ub[0]==2) P_ide_int_label();
  Ra.sl[6]=7624; /* line # 7624 */
  if (V_sy_sym.ub[0]!=0) P_src_error(Rd.s+1236,69,3);
  Ra.sl[6]=7625; /* line # 7625 */
  V_err_prt=0;
  Ra.sl[6]=7626; /* line # 7626 */
  Rv1=P_ide_search(8);
  Ra.sl[6]=7627; /* line # 7627 */
  V_err_prt=1;
  Ra.sl[6]=7629; /* line # 7629 */
  if (Rv1==NULL) {
    Ra.sl[6]=7631; /* line # 7631 */
    P_ide_new(3,NULL,&Rv1);
    Ra.sl[6]=7632; /* line # 7632 */
    Rv2=Lx[5].v[13];
    Ra.sl[6]=7633; /* line # 7633 */
    if (((V *)Rv2)[20]==NULL) ((V *)Rv2)[20]=Rv1;
    else {
      Ra.sl[6]=7634; /* line # 7634 */
      ((V *)Lx[5].v[4])[7]=Rv1;
    }
    Ra.sl[6]=7635; /* line # 7635 */
    Lx[5].v[4]=Rv1;
  }
  Ra.sl[6]=7637; /* line # 7637 */
  P_lgt_new(&Rv0,NULL,0,NULL);
  Ra.sl[6]=7638; /* line # 7638 */
  Rv3=Rv0;
  Rv4=Rv1;
  Ra.sl[6]=7640; /* line # 7640 */
  if (((SL *)Rv4)[12]!=V_curr_lex) {
    Ra.sl[6]=7642; /* line # 7642 */
    ((UB *)Rv3)[41]=10;
    Ra.sl[6]=7644; /* line # 7644 */
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|12;
  }
  else {
    Ra.sl[6]=7648; /* line # 7648 */
    ((UB *)Rv4)[54]=((UB *)Rv4)[54]|4;
    Ra.sl[6]=7649; /* line # 7649 */
    if (32&((UB *)Rv4)[54]) {
      Ra.sl[6]=7651; /* line # 7651 */
      P_src_error(Rd.s+1236,70,2);
    }
    else {
      Ra.sl[6]=7653; /* line # 7653 */
      ((SL *)Rv4)[22]=V_cntx_lblvl;
    }
    Ra.sl[6]=7654; /* line # 7654 */
    ((UB *)Rv3)[41]=9;
  }
  Ra.sl[6]=7656; /* line # 7656 */
  ((V *)Rv3)[6]=Rv1;
  Ra.sl[6]=7658; /* line # 7658 */
  P_insymbol();
  Ra.sl[6]=7659; /* line # 7659 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " begin_state "  */
V PAS_COMILER_PRC_00000062(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1240;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7673; /* line # 7673 */
  Rv0=V_cntx_label;
  Ra.sl[6]=7674; /* line # 7674 */
  V_cntx_lblvl=V_cntx_lblvl+1;
  Ra.sl[6]=7675; /* line # 7675 */
  Rv1=PAS_COMILER_PRC_00000035(72,1);
  Ra.sl[6]=7676; /* line # 7676 */
  if (V_sy_sym.ub[0]==72) P_insymbol();
  else {
    Ra.sl[6]=7677; /* line # 7677 */
    P_src_error(Rd.s+1255,54,2);
  }
  Ra.sl[6]=7678; /* line # 7678 */
  P_label_purge(&Rv0);
  Ra.sl[6]=7679; /* line # 7679 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " label_attach "  */
void PAS_COMILER_PRC_00000063(V F_lab_list, V F_trg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1259;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7685; /* line # 7685 */
  if (F_lab_list!=NULL&&F_trg!=NULL) {
    Ra.sl[6]=7686; /* line # 7686 */
    ((V *)F_trg)[4]=F_lab_list;
  }
  Ra.sl[6]=7694; /* line # 7694 */
  while (F_lab_list!=NULL){
    Ra.sl[6]=7695; /* line # 7695 */
    Rv0=F_lab_list;
    Ra.sl[6]=7697; /* line # 7697 */
    ((V *)Rv0)[10]=F_trg;
    F_lab_list=((V *)Rv0)[9];
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " statement "  */
V PAS_COMILER_PRC_00000036(V F_lgp, UB F_bsequ){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Ret;
  register P Lx_Sv;
  Lx_Sv=Lx[4];
  Lx[4].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[1]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+8;
  Ra.v[2]=Rd.s+1273;
  Ra.v[3]=Rd.s+17;
  Ra.sl[8]=7704; /* line # 7704 */
  Rv0=NULL;
  Ra.sl[8]=7705; /* line # 7705 */
  Rv1=NULL;
  Ra.sl[8]=7706; /* line # 7706 */
  Ra.v[0]=NULL;
  Ra.sl[8]=7707; /* line # 7707 */
  Rv2=V_wildtmp_stk;
  Ra.sl[8]=7709; /* line # 7709 */
  Ra.sl[8]=7711; /* line # 7711 */
  Rv3=NULL;
  Ra.sl[8]=7712; /* line # 7712 */
  if (V_sy_sym.ub[0]==1) while (1){
    Ra.sl[8]=7714; /* line # 7714 */
    V_err_prt=0;
    Ra.sl[8]=7715; /* line # 7715 */
    Rv4=P_ide_search(8);
    Ra.sl[8]=7716; /* line # 7716 */
    V_err_prt=1;
    Ra.sl[8]=7718; /* line # 7718 */
    if (Rv4!=NULL) {
      Ra.sl[8]=7720; /* line # 7720 */
      if (((SL *)Rv4)[12]!=V_curr_lex) Rv4=NULL;
      else {
        Ra.sl[8]=7722; /* line # 7722 */
        if (16&((UB *)Rv4)[54]) {
          Ra.sl[8]=7724; /* line # 7724 */
          P_src_error_s(Rd.s+1286,75,3, V_sy_ident.s,NULL);
        }
      }
    }
    Ra.sl[8]=7726; /* line # 7726 */
    if (Rv4==NULL) {
      Ra.sl[8]=7728; /* line # 7728 */
      P_ide_new(3,NULL,&Rv4);
      Ra.sl[8]=7729; /* line # 7729 */
      Rv5=Lx[5].v[13];
      Ra.sl[8]=7730; /* line # 7730 */
      if (((V *)Rv5)[20]==NULL) ((V *)Rv5)[20]=Rv4;
      else {
        Ra.sl[8]=7731; /* line # 7731 */
        ((V *)Lx[5].v[4])[7]=Rv4;
      }
      Ra.sl[8]=7732; /* line # 7732 */
      Lx[5].v[4]=Rv4;
    }
    Ra.sl[8]=7735; /* line # 7735 */
    Rv6=Rv4;
    Ra.sl[8]=7737; /* line # 7737 */
    ((V *)Rv6)[8]=V_cntx_label;
    Ra.sl[8]=7738; /* line # 7738 */
    V_cntx_label=Rv4;
    Ra.sl[8]=7739; /* line # 7739 */
    ((UB *)Rv6)[54]=((UB *)Rv6)[54]|16;
    Ra.sl[8]=7740; /* line # 7740 */
    if (4&((UB *)Rv6)[54]) {
      Ra.sl[8]=7741; /* line # 7741 */
      if (((SL *)Rv6)[22]<V_cntx_lblvl) {
        Ra.sl[8]=7742; /* line # 7742 */
        P_src_error_s(Rd.s+1286,70,2, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[8]=7744; /* line # 7744 */
    if (Rv3==NULL) Rv3=Rv4;
    Ra.sl[8]=7745; /* line # 7745 */
    ((V *)Rv4)[9]=Ra.v[0];
    Ra.sl[8]=7746; /* line # 7746 */
    Ra.v[0]=Rv4;
    Ra.sl[8]=7747; /* line # 7747 */
    P_insymbol();
    if (V_sy_sym.ub[0]!=1)  break;
  }
  Ra.sl[8]=7750; /* line # 7750 */
  if (V_cmp_trace>0) {
    Ra.sl[8]=7751; /* line # 7751 */
    switch (V_sy_sym.ub[0]) {
      case 18:
      case 48:
      case 54:
      case 71:break;
      default:Ra.sl[8]=7756; /* line # 7756 */
      if (Lx[5].sl[28]<2) {
        Ra.sl[8]=7757; /* line # 7757 */
        if (Ra.v[0]!=NULL) {
          Ra.sl[8]=7758; /* line # 7758 */
          if (8&((UB *)Ra.v[0])[54]) Lx[5].sl[28]=2;
          else {
            Ra.sl[8]=7759; /* line # 7759 */
            Lx[5].sl[28]=1;
          }
        }
      }
      Ra.sl[8]=7761; /* line # 7761 */
      Rv1=P_lgt_new_line(Lx[5].v[13],F_lgp, Lx[5].sl[28]);
      Ra.sl[8]=7763; /* line # 7763 */
      if (Ra.v[0]!=NULL) {
        Ra.sl[8]=7765; /* line # 7765 */
        if (Rv1==NULL) {
          Ra.sl[8]=7767; /* line # 7767 */
          if (F_lgp!=NULL) {
            Ra.sl[8]=7768; /* line # 7768 */
            ((V *)Rv3)[9]=((V *)F_lgp)[4];
          }
          Ra.sl[8]=7769; /* line # 7769 */
          PAS_COMILER_PRC_00000063(Ra.v[0],F_lgp);
        }
        else {
          Ra.sl[8]=7772; /* line # 7772 */
          PAS_COMILER_PRC_00000063(Ra.v[0],Rv1);
        }
        Ra.sl[8]=7773; /* line # 7773 */
        Ra.v[0]=NULL;
      }
      Ra.sl[8]=7775; /* line # 7775 */
      Lx[5].sl[28]=0;
      break;
    }
  }
  Ra.sl[8]=7779; /* line # 7779 */
  memcpy(Ra.s+36,V_sy_sym.s,2);
  Ra.sl[8]=7780; /* line # 7780 */
  Ra.sl[8]=7782; /* line # 7782 */
  if ((((Ra.ub[36]!=72&&Ra.ub[36]!=90)&&Ra.ub[36]!=49)&&Ra.ub[36]!=0)&&Ra.ub[36]
  !=18) {
    Ra.sl[8]=7783; /* line # 7783 */
    P_insymbol();
  }
  Ra.sl[8]=7784; /* line # 7784 */
  switch (Ra.ub[36]) {
    case 90:break;
    case 0:Ra.sl[8]=7788; /* line # 7788 */
    Rv4=P_ide_search(2016);
    Ra.sl[8]=7797; /* line # 7797 */
    Rv7=Rv4;
    Ra.sl[8]=7799; /* line # 7799 */
    P_insymbol();
    Ra.sl[8]=7800; /* line # 7800 */
    switch (((UB *)Rv7)[53]) {
      case 10:Ra.sl[8]=7802; /* line # 7802 */
      Rv0=PAS_COMILER_PRC_00000014(Rv4);
      break;
      case 7:Ra.sl[8]=7806; /* line # 7806 */
      Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
      Ra.sl[8]=7807; /* line # 7807 */
      if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
      break;
      case 8:
      case 9:Ra.sl[8]=7812; /* line # 7812 */
      switch (V_sy_sym.ub[0]) {
        case 15:
        case 19:
        case 22:Ra.sl[8]=7816; /* line # 7816 */
        Rv0=PAS_COMILER_PRC_00000054(Rv4);
        break;
        default:Ra.sl[8]=7819; /* line # 7819 */
        if (((UB *)Rv7)[53]==9) Rv0=PAS_COMILER_PRC_00000011(Rv4,0);
        else {
          Ra.sl[8]=7820; /* line # 7820 */
          Rv0=PAS_COMILER_PRC_00000009(Rv4,0);
        }
        Ra.sl[8]=7821; /* line # 7821 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=NULL;
        break;
      }
      break;
      default:Ra.sl[8]=7825; /* line # 7825 */
      Rv0=PAS_COMILER_PRC_00000055(Rv4);
      break;
    }
    break;
    case 71:Ra.sl[8]=7830; /* line # 7830 */
    Rv0=PAS_COMILER_PRC_00000062();
    break;
    case 44:Ra.sl[8]=7831; /* line # 7831 */
    Rv0=PAS_COMILER_PRC_00000057();
    break;
    case 47:
    case 48:
    case 54:Ra.sl[8]=7834; /* line # 7834 */
    Rv0=PAS_COMILER_PRC_00000059(Ra.ub[36]);
    break;
    case 50:Ra.sl[8]=7835; /* line # 7835 */
    Rv0=PAS_COMILER_PRC_00000060();
    break;
    case 55:Ra.sl[8]=7836; /* line # 7836 */
    Rv0=PAS_COMILER_PRC_00000058();
    break;
    case 57:Ra.sl[8]=7837; /* line # 7837 */
    Rv0=PAS_COMILER_PRC_00000056();
    break;
    case 56:Ra.sl[8]=7838; /* line # 7838 */
    Rv0=PAS_COMILER_PRC_00000004(56,NULL);
    break;
    case 33:Ra.sl[8]=7839; /* line # 7839 */
    Rv0=PAS_COMILER_PRC_00000061();
    break;
    case 58:Ra.sl[8]=7841; /* line # 7841 */
    Rv0=PAS_COMILER_PRC_00000016(V_new_entry_proc);
    break;
    case 59:Ra.sl[8]=7842; /* line # 7842 */
    Rv0=PAS_COMILER_PRC_00000016(V_newh_entry_proc);
    break;
    case 60:Ra.sl[8]=7843; /* line # 7843 */
    Rv0=PAS_COMILER_PRC_00000017(V_dispose_entry_proc);
    break;
    case 61:Ra.sl[8]=7845; /* line # 7845 */
    Rv0=PAS_COMILER_PRC_00000012(0);
    break;
    case 62:Ra.sl[8]=7846; /* line # 7846 */
    Rv0=PAS_COMILER_PRC_00000012(1);
    break;
    case 63:Ra.sl[8]=7847; /* line # 7847 */
    Rv0=PAS_COMILER_PRC_00000012(2);
    break;
    case 64:Ra.sl[8]=7848; /* line # 7848 */
    Rv0=PAS_COMILER_PRC_00000012(3);
    break;
    case 65:Ra.sl[8]=7851; /* line # 7851 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    NULL);
    break;
    case 66:Ra.sl[8]=7854; /* line # 7854 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_inp_file, V_inp_std_sel, V_inp_std_gene, V_inp_std_bin,
    V_inp_std_eoln);
    break;
    case 67:Ra.sl[8]=7857; /* line # 7857 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_inp_std_sel, V_inp_std_gene,NULL,V_inp_std_eoln);
    break;
    case 68:Ra.sl[8]=7860; /* line # 7860 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    NULL);
    break;
    case 69:Ra.sl[8]=7863; /* line # 7863 */
    Rv0=PAS_COMILER_PRC_00000013(V_std_out_file, V_out_std_sel, V_out_std_gene, V_out_std_bin,
    V_out_std_eoln);
    break;
    case 70:Ra.sl[8]=7866; /* line # 7866 */
    Rv0=PAS_COMILER_PRC_00000013(NULL,V_out_std_sel, V_out_std_gene,NULL,V_out_std_eoln);
    break;
    case 78:Ra.sl[8]=7870; /* line # 7870 */
    Rv0=PAS_COMILER_PRC_00000054(NULL);
    break;
    default:break;
  }
  Ra.sl[8]=7874; /* line # 7874 */
  if (Ra.v[0]!=NULL) {
    Ra.sl[8]=7876; /* line # 7876 */
    if (Rv0==NULL) P_lgt_new(&Rv0,NULL,17,NULL);
    Ra.sl[8]=7877; /* line # 7877 */
    PAS_COMILER_PRC_00000063(Ra.v[0],Rv0);
  }
  Ra.sl[8]=7881; /* line # 7881 */
  if (Rv0!=NULL) {
    Ra.sl[8]=7883; /* line # 7883 */
    if (Rv1!=NULL) {
      Ra.sl[8]=7885; /* line # 7885 */
      ((V *)Rv1)[0]=Rv0;
      Ra.sl[8]=7886; /* line # 7886 */
      if (F_bsequ) {
        Ra.sl[8]=7888; /* line # 7888 */
        P_lgt_new(&Rv0,NULL,0, Rv1);
        Ra.sl[8]=7889; /* line # 7889 */
        ((UB *)Rv0)[41]=2;
        Ra.sl[8]=7890; /* line # 7890 */
        Lx[5].v[8]=Rv0;
      }
      else {
        Ra.sl[8]=7894; /* line # 7894 */
        Lx[5].v[8]=Rv0;
        Ra.sl[8]=7895; /* line # 7895 */
        Rv0=Rv1;
      }
    }
    else {
      Ra.sl[8]=7899; /* line # 7899 */
      Lx[5].v[8]=Rv0;
    }
  }
  else {
    Ra.sl[8]=7903; /* line # 7903 */
    if (Rv1!=NULL) Rv0=Rv1;
    Ra.sl[8]=7904; /* line # 7904 */
    Lx[5].v[8]=Rv0;
  }
  Ra.sl[8]=7907; /* line # 7907 */
  P_tmpstk_free(Rv2);
  Ra.sl[8]=7908; /* line # 7908 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[1];
  Lx[4]=Lx_Sv;
  return(Ret);
}


/* Procedure/Function : " statelist "  */
V PAS_COMILER_PRC_00000035(UB F_stopper, UB F_seq_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1290;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=7923; /* line # 7923 */
  Rv0=V_src_control;
  ((SL *)Rv0)[6]=((SL *)Rv0)[6]+1;
  Ra.sl[6]=7924; /* line # 7924 */
  Rv1=NULL;
  Ra.sl[6]=7925; /* line # 7925 */
  Rv2=NULL;
  Ra.sl[6]=7926; /* line # 7926 */
  Ra.sl[6]=7928; /* line # 7928 */
  while (V_sy_sym.ub[0]==18)
  P_insymbol();
  Ra.sl[6]=7929; /* line # 7929 */
  if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&!V_emergency_stop)
   {
    Ra.sl[6]=7932; /* line # 7932 */
    Rv1=PAS_COMILER_PRC_00000036(NULL,0);
    Ra.sl[6]=7933; /* line # 7933 */
    Rv2=Lx[5].v[8];
    Ra.sl[6]=7935; /* line # 7935 */
    while (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)
    &&!V_emergency_stop){
      Ra.sl[6]=7938; /* line # 7938 */
      if (V_sy_sym.ub[0]==18) {
        Ra.sl[6]=7939; /* line # 7939 */
        while (V_sy_sym.ub[0]==18)
        P_insymbol();
      }
      else {
        Ra.sl[6]=7940; /* line # 7940 */
        P_src_error(Rd.s+1303,21,2);
      }
      Ra.sl[6]=7941; /* line # 7941 */
      if (((V_sy_sym.ub[0]!=F_stopper&&V_sy_sym.ub[0]!=90)&&V_sy_sym.ub[0]!=72)&&
      !V_emergency_stop) {
        Ra.sl[6]=7944; /* line # 7944 */
        Rv3=PAS_COMILER_PRC_00000036(Rv2,0);
        Ra.sl[6]=7945; /* line # 7945 */
        if (Rv3!=NULL) {
          Ra.sl[6]=7947; /* line # 7947 */
          if (Rv1==NULL) Rv1=Rv3;
          else {
            Ra.sl[6]=7948; /* line # 7948 */
            ((V *)Rv2)[0]=Rv3;
          }
          Ra.sl[6]=7949; /* line # 7949 */
          Rv2=Lx[5].v[8];
        }
      }
    }
  }
  Ra.sl[6]=7955; /* line # 7955 */
  Rv4=V_src_control;
  ((SL *)Rv4)[6]=((SL *)Rv4)[6]-1;
  Ra.sl[6]=7956; /* line # 7956 */
  Lx[5].v[7]=Rv2;
  Ra.sl[6]=7957; /* line # 7957 */
  if (F_seq_flg&&Rv1!=Rv2) {
    Ra.sl[6]=7959; /* line # 7959 */
    P_lgt_new(&Rv2,NULL,0, Rv1);
    Ra.sl[6]=7960; /* line # 7960 */
    ((UB *)Rv2)[41]=2;
    Ra.sl[6]=7961; /* line # 7961 */
    Ret=Rv2;
  }
  else {
    Ra.sl[6]=7963; /* line # 7963 */
    Ret=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " cmp_block "  */
void P_cmp_block(V F_owner, UB F_bproc, SL F_glicd){
  /* Define the automatic variable space. */
  Blk( Ra, 120 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  V Rv6;
  register V Rv7;
  register P Lx_Sv;
  Lx_Sv=Lx[5];
  Lx[5].s=Ra.s;

  /* Code of procedure/function */
  Ra.v[13]=F_owner;
  Ra.sl[28]=F_glicd;
  Ra.v[9]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+72;
  Ra.v[10]=Rd.s+1307;
  Ra.v[11]=Rd.s+17;
  Ra.sl[24]=7971; /* line # 7971 */
  if (V_curr_lex>0) {
    Ra.sl[24]=7973; /* line # 7973 */
    P_new_disp_level(Ra.v[13],4);
  }
  Ra.sl[24]=7977; /* line # 7977 */
  Ra.ub[40]=0;
  Ra.sl[24]=7978; /* line # 7978 */
  Ra.v[6]=NULL;
  Ra.sl[24]=7979; /* line # 7979 */
  Ra.v[1]=NULL;
  Ra.sl[24]=7980; /* line # 7980 */
  Rv0=NULL;
  Ra.sl[24]=7981; /* line # 7981 */
  Rv1=V_cntx_label;
  Ra.sl[24]=7982; /* line # 7982 */
  V_cntx_label=NULL;
  Ra.sl[24]=7983; /* line # 7983 */
  Rv2=Ra.v[13];
  Ra.sl[24]=7985; /* line # 7985 */
  ((V *)Rv2)[19]=NULL;
  Ra.sl[24]=7986; /* line # 7986 */
  ((V *)Rv2)[23]=NULL;
  Ra.sl[24]=7987; /* line # 7987 */
  ((V *)Rv2)[24]=NULL;
  Ra.sl[24]=7990; /* line # 7990 */
  P_compile_set_sbttl(Ra.v[13]);
  Ra.sl[24]=7992; /* line # 7992 */
  Ra.sl[24]=7994; /* line # 7994 */
  Ra.ub[16]=1;
  Ra.sl[24]=7995; /* line # 7995 */
  Ra.v[3]=NULL;
  while (1){
    Ra.sl[24]=7997; /* line # 7997 */
    V_pro_current=Ra.v[13];
    Ra.sl[24]=7998; /* line # 7998 */
    V_cprc_disp=V_curr_disp;
    Ra.sl[24]=8001; /* line # 8001 */
    if (V_sy_sym.ub[0]==15) PAS_COMILER_PRC_00000043(1);
    Ra.sl[24]=8002; /* line # 8002 */
    switch (V_sy_sym.ub[0]) {
      case 28:Ra.sl[24]=8006; /* line # 8006 */
      P_insymbol();
      Ra.sl[24]=8007; /* line # 8007 */
      PAS_COMILER_PRC_00000044();
      break;
      case 29:Ra.sl[24]=8012; /* line # 8012 */
      P_insymbol();
      Ra.sl[24]=8013; /* line # 8013 */
      PAS_COMILER_PRC_00000045();
      break;
      case 30:Ra.sl[24]=8018; /* line # 8018 */
      if (V_sy_init_mod) {
        Ra.sl[24]=8019; /* line # 8019 */
        V_sy_var_init_mod=1;
      }
      Ra.sl[24]=8020; /* line # 8020 */
      P_insymbol();
      Ra.sl[24]=8021; /* line # 8021 */
      PAS_COMILER_PRC_00000046();
      Ra.sl[24]=8022; /* line # 8022 */
      if (V_sy_init_mod) {
        Ra.sl[24]=8023; /* line # 8023 */
        V_sy_var_init_mod=0;
      }
      break;
      case 32:Ra.sl[24]=8026; /* line # 8026 */
      PAS_COMILER_PRC_00000047();
      break;
      case 31:Ra.sl[24]=8028; /* line # 8028 */
      PAS_COMILER_PRC_00000048();
      break;
      case 76:
      case 77:Ra.sl[24]=8033; /* line # 8033 */
      PAS_COMILER_PRC_00000050();
      Ra.sl[24]=8034; /* line # 8034 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=8035; /* line # 8035 */
      V_cntx_varbl=((V *)Ra.v[13])[22];
      break;
      case 71:
      case 72:
      case 90:break;
      default:Ra.sl[24]=8041; /* line # 8041 */
      P_src_error(Rd.s+1320,91,2);
      Ra.sl[24]=8042; /* line # 8042 */
      P_insymbol();
      break;
    }
    if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==71)||V_sy_sym.ub[0]==72)  break;
  }
  Ra.sl[24]=8047; /* line # 8047 */
  if (V_curr_lex>0) {
    Ra.sl[24]=8048; /* line # 8048 */
    if (V_sy_sym.ub[0]==71) {
      Ra.sl[24]=8051; /* line # 8051 */
      P_ide_create_name(Rd.s+1324);
      Ra.sl[24]=8052; /* line # 8052 */
      P_ide_new_typ(21, &V_wildtmp_typ);
      Ra.sl[24]=8054; /* line # 8054 */
      ((SL *)V_wildtmp_typ)[11]=0;
      Ra.sl[24]=8055; /* line # 8055 */
      P_ide_new(5, V_wildtmp_typ, &V_wildtmp_ide);
      Ra.sl[24]=8056; /* line # 8056 */
      ((UW *)V_wildtmp_ide)[42]=96;
      Ra.sl[24]=8057; /* line # 8057 */
      V_wildtmp_psz=0;
      Ra.sl[24]=8058; /* line # 8058 */
      V_wildtmp_pal.ub[0]=0;
      Ra.sl[24]=8059; /* line # 8059 */
      V_wildtmp_stk=NULL;
      Ra.sl[24]=8061; /* line # 8061 */
      V_cntx_lblvl=0;
      Ra.sl[24]=8062; /* line # 8062 */
      V_cprc_disp=V_curr_disp;
      Ra.sl[24]=8063; /* line # 8063 */
      V_pro_current=Ra.v[13];
      Ra.sl[24]=8065; /* line # 8065 */
      P_compile_set_sbttl(Ra.v[13]);
      Ra.sl[24]=8067; /* line # 8067 */
      if (Ra.v[1]!=NULL) {
        Ra.sl[24]=8069; /* line # 8069 */
        if (Rv0!=NULL) ((V *)Rv0)[3]=Ra.v[1];
        else {
          Ra.sl[24]=8070; /* line # 8070 */
          ((V *)Ra.v[13])[23]=Ra.v[1];
        }
        Ra.sl[24]=8071; /* line # 8071 */
        P_src_error(Rd.s+1320,92,3);
      }
      Ra.sl[24]=8075; /* line # 8075 */
      V_sy_label_flag=1;
      Ra.sl[24]=8077; /* line # 8077 */
      P_insymbol();
      Ra.sl[24]=8079; /* line # 8079 */
      Rv3=Ra.v[13];
      Ra.sl[24]=8082; /* line # 8082 */
      ((V *)Rv3)[16]=PAS_COMILER_PRC_00000035(72,0);
      Ra.sl[24]=8084; /* line # 8084 */
      if (((V *)Rv3)[11]!=NULL) {
        Ra.sl[24]=8085; /* line # 8085 */
        if (!Ra.ub[40]) P_src_error(Rd.s+1320,74,3);
      }
      Ra.sl[24]=8088; /* line # 8088 */
      if (((V *)Rv3)[18]!=NULL) {
        Ra.sl[24]=8090; /* line # 8090 */
        ((V *)((V *)Rv3)[17])[0]=((V *)Rv3)[16];
        Ra.sl[24]=8091; /* line # 8091 */
        ((V *)Rv3)[16]=((V *)Rv3)[18];
      }
      Ra.sl[24]=8093; /* line # 8093 */
      ((V *)Rv3)[17]=Ra.v[7];
      Ra.sl[24]=8097; /* line # 8097 */
      Rv4=((V *)Ra.v[13])[19];
      Ra.sl[24]=8098; /* line # 8098 */
      while (Rv4!=NULL){
        Ra.sl[24]=8100; /* line # 8100 */
        Rv5=Rv4;
        Ra.sl[24]=8102; /* line # 8102 */
        V_ope_table.v[((UB *)Rv5)[0]]=((V *)Rv5)[2];
        Ra.sl[24]=8106; /* line # 8106 */
        Rv6=((V *)Rv5)[1];
        Ra.sl[24]=8108; /* line # 8108 */
        PAS__DISPOSE(&Rv4);
        Ra.sl[24]=8109; /* line # 8109 */
        Rv4=Rv6;
      }
      Ra.sl[24]=8113; /* line # 8113 */
      V_sy_label_flag=0;
    }
  }
  Ra.sl[24]=8118; /* line # 8118 */
  if (((UB *)Ra.v[13])[104]>=5) {
    Ra.sl[24]=8120; /* line # 8120 */
    V_cntx_label=((V *)Ra.v[13])[20];
    Ra.sl[24]=8121; /* line # 8121 */
    while (V_cntx_label!=Rv1&&V_cntx_label!=NULL){
      Ra.sl[24]=8122; /* line # 8122 */
      Rv7=V_cntx_label;
      Ra.sl[24]=8124; /* line # 8124 */
      if (4&((UB *)Rv7)[54]) {
        Ra.sl[24]=8127; /* line # 8127 */
        if (!(16&((UB *)Rv7)[54])) P_src_error(Rd.s+1320,66,3);
      }
      Ra.sl[24]=8128; /* line # 8128 */
      V_cntx_label=((V *)Rv7)[7];
    }
  }
  Ra.sl[24]=8131; /* line # 8131 */
  V_cntx_label=Rv1;
  PAS__curr_cntx=Ra.v[9];
  Lx[5]=Lx_Sv;
}


/* Procedure/Function : " cmp_init "  */
void P_cmp_init(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1331;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8151; /* line # 8151 */
  V_emergency_stop=0;
  Ra.sl[6]=8153; /* line # 8153 */
  P_insy_init();
  Ra.sl[6]=8155; /* line # 8155 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8157; /* line # 8157 */
  V_opt_exec=0;
  Ra.sl[6]=8159; /* line # 8159 */
  V_cmp_cmpdbg=0;
  Ra.sl[6]=8161; /* line # 8161 */
  V_cmp_range=0;
  Ra.sl[6]=8162; /* line # 8162 */
  V_cmp_dynamic=0;
  Ra.sl[6]=8163; /* line # 8163 */
  V_cmp_genenv=0;
  Ra.sl[6]=8164; /* line # 8164 */
  V_cmp_listlvl=1;
  Ra.sl[6]=8165; /* line # 8165 */
  V_cmp_igenv=-1;
  Ra.sl[6]=8167; /* line # 8167 */
  V_cmp_macf=0;
  Ra.sl[6]=8168; /* line # 8168 */
  V_cmp_cobj=0;
  Ra.sl[6]=8169; /* line # 8169 */
  V_cmp_objf=0;
  Ra.sl[6]=8170; /* line # 8170 */
  V_cmp_bltt=0;
  Ra.sl[6]=8171; /* line # 8171 */
  V_cmp_opt=1;
  Ra.sl[6]=8172; /* line # 8172 */
  V_cmp_debugopt=0;
  Ra.sl[6]=8173; /* line # 8173 */
  V_cmp_debug=0;
  Ra.sl[6]=8174; /* line # 8174 */
  V_cmp_traceopt=5;
  Ra.sl[6]=8175; /* line # 8175 */
  V_cmp_trace=-1;
  Ra.sl[6]=8176; /* line # 8176 */
  V_cmp_tracecount=0;
  Ra.sl[6]=8177; /* line # 8177 */
  V_cmp_twicedclon=0;
  Ra.sl[6]=8179; /* line # 8179 */
  V_sy_init_mod=1;
  Ra.sl[6]=8180; /* line # 8180 */
  V_sy_generic_qmod=1;
  Ra.sl[6]=8181; /* line # 8181 */
  V_sy_var_init_mod=0;
  Ra.sl[6]=8183; /* line # 8183 */
  V_sy_casedef=0;
  Ra.sl[6]=8185; /* line # 8185 */
  P_insymbol();
  Ra.sl[6]=8187; /* line # 8187 */
  P_compile_set_title();
  Ra.sl[6]=8188; /* line # 8188 */
  P_compile_set_sbttl(V_lex_ident_tree.v[0]);
  Ra.sl[6]=8190; /* line # 8190 */
  P_generation_setting();
  Ra.sl[6]=8193; /* line # 8193 */
  P_cmp_block(V_lex_ident_tree.v[0],1,0);
  Ra.sl[6]=8195; /* line # 8195 */
  if (V_error_result!=0) {
    Ra.sl[6]=8196; /* line # 8196 */
    V_emergency_stop=1;
  }
  Ra.sl[6]=8198; /* line # 8198 */
  if (V_emergency_stop) PAS__EXIT(2);
  Ra.sl[6]=8222; /* line # 8222 */
  V_cntx_procname=V_fptr_size;
  Ra.sl[6]=8223; /* line # 8223 */
  V_cntx_srcfname=V_cntx_procname+V_fptr_size;
  Ra.sl[6]=8224; /* line # 8224 */
  V_cntx_linenbr=V_cntx_srcfname+V_fptr_size;
  Ra.sl[6]=8225; /* line # 8225 */
  V_cntx_size=V_cntx_linenbr+V_inte_size;
  Ra.sl[6]=8226; /* line # 8226 */
  P_ide_new_typ(10, &V_cntx_typ);
  Ra.sl[6]=8227; /* line # 8227 */
  Rv0=V_cntx_typ;
  Ra.sl[6]=8229; /* line # 8229 */
  ((UB *)Rv0)[48]=((UB *)V_typ_std.v[5])[48];
  Ra.sl[6]=8230; /* line # 8230 */
  ((SL *)Rv0)[11]=V_cntx_size;
  Ra.sl[6]=8231; /* line # 8231 */
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=8232; /* line # 8232 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=8233; /* line # 8233 */
  ((V *)Rv0)[14]=NULL;
  Ra.sl[6]=8235; /* line # 8235 */
  if (V_cmp_trace>0) V_cmp_tracecount=0;
  Ra.sl[6]=8236; /* line # 8236 */
  V_sy_init_mod=0;
  Ra.sl[6]=8237; /* line # 8237 */
  V_sy_generic_qmod=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_pass2 "  */
void PAS_COMILER_cmp_pass2(V F_pr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1341;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8245; /* line # 8245 */
  Rv0=F_pr;
  Ra.sl[6]=8254; /* line # 8254 */
  P_lgt_pass1_complet(F_pr);
  Ra.sl[6]=8256; /* line # 8256 */
  if (V_cmp_macf) {
    Ra.sl[6]=8258; /* line # 8258 */
    P_lgt_dump_proc(F_pr);
    Ra.sl[6]=8259; /* line # 8259 */
    P_lst_page();
  }
  Ra.sl[6]=8264; /* line # 8264 */
  switch (((UB *)Rv0)[104]) {
    case 6:
    case 9:
    case 10:Ra.sl[6]=8270; /* line # 8270 */
    P_generate_code_p1(F_pr);
    break;
    default:break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cmp_compile "  */
UB P_cmp_compile(UB F_interactive){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;
  V Rv6;
  SL Rv7;
  register V Rv8;
  register V Rv9;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+1352;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=8294; /* line # 8294 */
  V_emergency_stop=0;
  Ra.sl[6]=8295; /* line # 8295 */
  Rv0=0;
  Ra.sl[6]=8297; /* line # 8297 */
  V_env_file=NULL;
  Ra.sl[6]=8298; /* line # 8298 */
  V_env_first=NULL;
  Ra.sl[6]=8299; /* line # 8299 */
  V_env_last=NULL;
  Ra.sl[6]=8301; /* line # 8301 */
  Ra.sl[6]=8303; /* line # 8303 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8305; /* line # 8305 */
    P_compile_set_title();
    Ra.sl[6]=8311; /* line # 8311 */
    Rv1=V_src_control;
    Ra.sl[6]=8313; /* line # 8313 */
    ((SL *)Rv1)[7]=1;
    Ra.sl[6]=8314; /* line # 8314 */
    ((SL *)Rv1)[8]=V_cmp_listlvl;
    Ra.sl[6]=8318; /* line # 8318 */
    V_sy_ch=32;
    Ra.sl[6]=8319; /* line # 8319 */
    P_insymbol();
    Ra.sl[6]=8321; /* line # 8321 */
    V_sy_fix_range_ctl=1;
    Ra.sl[6]=8323; /* line # 8323 */
    P_compile_set_sbttl(NULL);
    Ra.sl[6]=8325; /* line # 8325 */
    Rv2=PAS__NEW(245);
    Ra.sl[6]=8326; /* line # 8326 */
    V_pro_current=Rv2;
    Ra.sl[6]=8328; /* line # 8328 */
    if (V_sy_sym.ub[0]==15) {
      Ra.sl[6]=8331; /* line # 8331 */
      V_sy_sym.ub[0]=17;
      while (1){
        Ra.sl[6]=8333; /* line # 8333 */
        P_insymbol();
        Ra.sl[6]=8334; /* line # 8334 */
        if (V_sy_sym.ub[0]==0) {
          Ra.sl[6]=8336; /* line # 8336 */
          Rv3=P_level_search(V_attr_list);
          Ra.sl[6]=8337; /* line # 8337 */
          if (Rv3!=NULL) while (1){
            Ra.sl[6]=8339; /* line # 8339 */
            P_insymbol();
            Ra.sl[6]=8340; /* line # 8340 */
            switch (((UB *)Rv3)[54]) {
              case 18:Ra.sl[6]=8343; /* line # 8343 */
              if (V_sy_sym.ub[0]!=13) P_src_error(Rd.s+1367,22,2);
              Ra.sl[6]=8344; /* line # 8344 */
              V_sy_sym.ub[0]=17;
              while (1){
                Ra.sl[6]=8346; /* line # 8346 */
                P_insymbol();
                Ra.sl[6]=8347; /* line # 8347 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8348; /* line # 8348 */
                  P_add_inherit_file(V_sy_string.s);
                }
                else {
                  Ra.sl[6]=8350; /* line # 8350 */
                  P_src_error(Rd.s+1367,58,3);
                }
                Ra.sl[6]=8351; /* line # 8351 */
                P_insymbol();
                if (V_sy_sym.ub[0]!=17)  break;
              }
              Ra.sl[6]=8353; /* line # 8353 */
              if (V_sy_sym.ub[0]==14) P_insymbol();
              else {
                Ra.sl[6]=8354; /* line # 8354 */
                P_src_error(Rd.s+1367,23,2);
              }
              break;
              case 19:Ra.sl[6]=8359; /* line # 8359 */
              if (V_sy_sym.ub[0]==13) {
                Ra.sl[6]=8361; /* line # 8361 */
                P_insymbol();
                Ra.sl[6]=8362; /* line # 8362 */
                if (V_sy_sym.ub[0]==5&&V_sy_string.ub[1]>0) {
                  Ra.sl[6]=8364; /* line # 8364 */
                  Rv4=V_sy_string.ub[1];
                  V_env_file=PAS__NEW((SL)Rv4+2);
                  ((UB *)V_env_file)[0]=Rv4;
                  Ra.sl[6]=8365; /* line # 8365 */
                  PAS__STR_TO_STR(V_env_file,V_sy_string.s);
                  Ra.sl[6]=8366; /* line # 8366 */
                  V_cmp_genenv=1;
                  Ra.sl[6]=8367; /* line # 8367 */
                  V_cmp_igenv=0;
                  Ra.sl[6]=8368; /* line # 8368 */
                  P_insymbol();
                }
                else {
                  Ra.sl[6]=8369; /* line # 8369 */
                  P_src_error(Rd.s+1367,58,2);
                }
                Ra.sl[6]=8370; /* line # 8370 */
                if (V_sy_sym.ub[0]==14) P_insymbol();
                else {
                  Ra.sl[6]=8371; /* line # 8371 */
                  P_src_error(Rd.s+1367,23,2);
                }
              }
              break;
              default:Ra.sl[6]=8376; /* line # 8376 */
              P_src_error_s(Rd.s+1367,3,1, V_sy_ident.s,NULL);
              break;
            }
            if ((V_sy_sym.ub[0]==90||V_sy_sym.ub[0]==17)||V_sy_sym.ub[0]==16)  break;
          }
        }
        else {
          Ra.sl[6]=8380; /* line # 8380 */
          P_src_error(Rd.s+1367,2,3);
        }
        if (V_sy_sym.ub[0]!=17)  break;
      }
      Ra.sl[6]=8382; /* line # 8382 */
      if (V_sy_sym.ub[0]==16) P_insymbol();
      else {
        Ra.sl[6]=8383; /* line # 8383 */
        P_src_error(Rd.s+1367,26,2);
      }
    }
    Ra.sl[6]=8386; /* line # 8386 */
    if (V_cmp_igenv>=0) V_cmp_genenv=1;
    else {
      Ra.sl[6]=8387; /* line # 8387 */
      V_cmp_genenv=0;
    }
    Ra.sl[6]=8389; /* line # 8389 */
    if (V_sy_sym.ub[0]==74) {
      Ra.sl[6]=8391; /* line # 8391 */
      P_insymbol();
      Ra.sl[6]=8392; /* line # 8392 */
      Rv0=1;
      Ra.sl[6]=8393; /* line # 8393 */
      if (V_sy_sym.ub[0]!=0) {
        Ra.sl[6]=8395; /* line # 8395 */
        P_src_error(Rd.s+1367,93,4);
        Ra.sl[6]=8396; /* line # 8396 */
        V_emergency_stop=1;
      }
    }
    else {
      Ra.sl[6]=8400; /* line # 8400 */
      if (V_sy_sym.ub[0]==75) {
        Ra.sl[6]=8402; /* line # 8402 */
        P_insymbol();
        Ra.sl[6]=8403; /* line # 8403 */
        if (V_sy_sym.ub[0]!=0) {
          Ra.sl[6]=8405; /* line # 8405 */
          P_src_error(Rd.s+1367,93,4);
          Ra.sl[6]=8406; /* line # 8406 */
          V_emergency_stop=1;
        }
      }
      else {
        Ra.sl[6]=8410; /* line # 8410 */
        P_src_error(Rd.s+1367,94,4);
      }
    }
  }
  Ra.sl[6]=8413; /* line # 8413 */
  if (!V_emergency_stop) {
    Ra.sl[6]=8415; /* line # 8415 */
    Rv5=Rv2;
    Ra.sl[6]=8418; /* line # 8418 */
    V_curr_lex=V_curr_lex+1;
    Ra.sl[6]=8419; /* line # 8419 */
    P_new_disp_level(Rv2,4);
    Ra.sl[6]=8422; /* line # 8422 */
    V_lex_ident_level.sl[V_curr_lex]=V_curr_disp;
    Ra.sl[6]=8424; /* line # 8424 */
    P_ide_new(9,NULL,&Rv6);
    Ra.sl[6]=8426; /* line # 8426 */
    ((V *)Rv5)[0]=NULL;
    Ra.sl[6]=8427; /* line # 8427 */
    ((V *)Rv5)[1]=NULL;
    Ra.sl[6]=8428; /* line # 8428 */
    ((UW *)Rv5)[8]=128;
    Ra.sl[6]=8429; /* line # 8429 */
    ((V *)Rv5)[3]=((V *)Rv6)[0];
    Ra.sl[6]=8430; /* line # 8430 */
    ((UB *)Rv5)[32]=29;
    Ra.sl[6]=8431; /* line # 8431 */
    ((V *)Rv5)[5]=Rv6;
    Ra.sl[6]=8432; /* line # 8432 */
    ((V *)Rv5)[6]=NULL;
    Ra.sl[6]=8433; /* line # 8433 */
    ((V *)Rv5)[7]=NULL;
    Ra.sl[6]=8434; /* line # 8434 */
    ((V *)Rv5)[8]=NULL;
    Ra.sl[6]=8435; /* line # 8435 */
    ((SL *)Rv5)[18]=0;
    Ra.sl[6]=8436; /* line # 8436 */
    ((SL *)Rv5)[19]=0;
    Ra.sl[6]=8437; /* line # 8437 */
    ((SL *)Rv5)[20]=0;
    Ra.sl[6]=8438; /* line # 8438 */
    ((V *)Rv5)[11]=NULL;
    Ra.sl[6]=8439; /* line # 8439 */
    ((V *)Rv5)[12]=NULL;
    Ra.sl[6]=8440; /* line # 8440 */
    if (Rv0) ((UB *)Rv5)[104]=7;
    else {
      Ra.sl[6]=8441; /* line # 8441 */
      ((UB *)Rv5)[104]=6;
    }
    Ra.sl[6]=8443; /* line # 8443 */
    ((V *)Rv5)[14]=NULL;
    Ra.sl[6]=8444; /* line # 8444 */
    ((V *)Rv5)[15]=NULL;
    Ra.sl[6]=8445; /* line # 8445 */
    ((V *)Rv5)[16]=NULL;
    Ra.sl[6]=8446; /* line # 8446 */
    ((V *)Rv5)[17]=NULL;
    Ra.sl[6]=8447; /* line # 8447 */
    ((V *)Rv5)[18]=NULL;
    Ra.sl[6]=8448; /* line # 8448 */
    ((V *)Rv5)[19]=NULL;
    Ra.sl[6]=8449; /* line # 8449 */
    ((V *)Rv5)[20]=NULL;
    Ra.sl[6]=8450; /* line # 8450 */
    ((V *)Rv5)[21]=NULL;
    Ra.sl[6]=8451; /* line # 8451 */
    ((V *)Rv5)[22]=NULL;
    Ra.sl[6]=8452; /* line # 8452 */
    ((V *)Rv5)[23]=NULL;
    Ra.sl[6]=8453; /* line # 8453 */
    ((V *)Rv5)[24]=NULL;
    Ra.sl[6]=8455; /* line # 8455 */
    ((V *)Rv5)[25]=NULL;
    Ra.sl[6]=8456; /* line # 8456 */
    ((V *)Rv5)[26]=NULL;
    Ra.sl[6]=8457; /* line # 8457 */
    ((V *)Rv5)[27]=NULL;
    Ra.sl[6]=8458; /* line # 8458 */
    ((SL *)Rv5)[56]=-1;
    Ra.sl[6]=8459; /* line # 8459 */
    ((SL *)Rv5)[57]=0;
    Ra.sl[6]=8460; /* line # 8460 */
    ((SL *)Rv5)[58]=0;
    Ra.sl[6]=8461; /* line # 8461 */
    ((SL *)Rv5)[59]=0;
    Ra.sl[6]=8462; /* line # 8462 */
    ((SL *)Rv5)[60]=0;
    Ra.sl[6]=8463; /* line # 8463 */
    ((UB *)Rv5)[244]=0;
    Ra.sl[6]=8465; /* line # 8465 */
    V_pas_main=Rv2;
    Ra.sl[6]=8466; /* line # 8466 */
    P_insymbol();
    Ra.sl[6]=8468; /* line # 8468 */
    P_compile_set_sbttl(V_pas_main);
    Ra.sl[6]=8470; /* line # 8470 */
    if (V_sy_sym.ub[0]==13) {
      Ra.sl[6]=8472; /* line # 8472 */
      V_sy_sym.ub[0]=17;
      Ra.sl[6]=8473; /* line # 8473 */
      while (V_sy_sym.ub[0]==17){
        Ra.sl[6]=8475; /* line # 8475 */
        P_insymbol();
        Ra.sl[6]=8476; /* line # 8476 */
        if (V_sy_sym.ub[0]==0) P_insymbol();
        else {
          Ra.sl[6]=8477; /* line # 8477 */
          P_src_error(Rd.s+1367,95,1);
        }
      }
      Ra.sl[6]=8479; /* line # 8479 */
      if (V_sy_sym.ub[0]==14) P_insymbol();
      else {
        Ra.sl[6]=8480; /* line # 8480 */
        P_src_error(Rd.s+1367,23,2);
      }
    }
    Ra.sl[6]=8482; /* line # 8482 */
    if (V_sy_sym.ub[0]==18) P_insymbol();
    else {
      Ra.sl[6]=8483; /* line # 8483 */
      P_src_error(Rd.s+1367,21,2);
    }
    Ra.sl[6]=8487; /* line # 8487 */
    if (V_env_first!=NULL) P_pas_read_env_file();
    Ra.sl[6]=8489; /* line # 8489 */
    if (V_cmp_debugopt) {
      Ra.sl[6]=8491; /* line # 8491 */
      V_cmp_debug=1;
      Ra.sl[6]=8492; /* line # 8492 */
      V_cmp_traceopt=1;
    }
    Ra.sl[6]=8495; /* line # 8495 */
    if (V_cmp_traceopt>0) {
      Ra.sl[6]=8497; /* line # 8497 */
      P_gen_cntxvar(Rv2,((V *)Rv6)[0]);
      Ra.sl[6]=8498; /* line # 8498 */
      V_cmp_trace=V_cmp_traceopt;
      Ra.sl[6]=8499; /* line # 8499 */
      Rv7=5;
    }
    else {
      Ra.sl[6]=8501; /* line # 8501 */
      Rv7=0;
    }
    Ra.sl[6]=8503; /* line # 8503 */
    P_cmp_block(Rv2,1, Rv7);
    Ra.sl[6]=8505; /* line # 8505 */
    if (V_cmp_trace>0&&!Rv0) {
      Ra.sl[6]=8507; /* line # 8507 */
      Rv8=Rv2;
      Ra.sl[6]=8508; /* line # 8508 */
      P_gen_linetrace(Rv2,((V *)Rv8)+16,((V *)Rv8)+17,6);
    }
    Ra.sl[6]=8510; /* line # 8510 */
    if (V_sy_sym.ub[0]==72) P_insymbol();
    else {
      Ra.sl[6]=8511; /* line # 8511 */
      P_src_error(Rd.s+1367,54,2);
    }
    Ra.sl[6]=8512; /* line # 8512 */
    if (V_sy_sym.ub[0]==0) {
      Ra.sl[6]=8514; /* line # 8514 */
      if (V_sy_sym.ub[0]==0&&P_match(((V *)Rv6)[0],V_sy_ident.s)==0) {
        Ra.sl[6]=8515; /* line # 8515 */
        P_insymbol();
      }
      else {
        Ra.sl[6]=8517; /* line # 8517 */
        P_src_error_s(Rd.s+1367,96,1, V_sy_ident.s,NULL);
      }
    }
    Ra.sl[6]=8519; /* line # 8519 */
    if (V_sy_sym.ub[0]==19) P_insymbol();
    else {
      Ra.sl[6]=8520; /* line # 8520 */
      P_src_error(Rd.s+1367,21,1);
    }
    Ra.sl[6]=8521; /* line # 8521 */
    if (V_sy_sym.ub[0]!=90) {
      Ra.sl[6]=8523; /* line # 8523 */
      P_src_error(Rd.s+1367,991,1);
      Ra.sl[6]=8524; /* line # 8524 */
      while (V_sy_sym.ub[0]!=90)
      P_insymbol();
    }
    else {
      Ra.sl[6]=8526; /* line # 8526 */
      P_src_end_of_line();
    }
    Ra.sl[6]=8527; /* line # 8527 */
    if (V_pro_last==NULL) V_pro_first=Rv2;
    else {
      Ra.sl[6]=8528; /* line # 8528 */
      ((V *)V_pro_last)[0]=Rv2;
    }
    Ra.sl[6]=8529; /* line # 8529 */
    V_pro_last=Rv2;
    Ra.sl[6]=8532; /* line # 8532 */
    if (V_error_result>1) {
      Ra.sl[6]=8533; /* line # 8533 */
      V_emergency_stop=1;
    }
    else {
      Ra.sl[6]=8536; /* line # 8536 */
      Rv9=Rv2;
      Ra.sl[6]=8537; /* line # 8537 */
      if (((V *)Rv9)[16]!=((V *)Rv9)[17]) {
        Ra.sl[6]=8539; /* line # 8539 */
        P_lgt_new(((V *)Rv9)+16,NULL,0,((V *)Rv9)[16]);
        Ra.sl[6]=8540; /* line # 8540 */
        ((UB *)((V *)Rv9)[16])[41]=2;
        Ra.sl[6]=8541; /* line # 8541 */
        ((V *)Rv9)[17]=((V *)Rv9)[16];
      }
      Ra.sl[6]=8543; /* line # 8543 */
      PAS_COMILER_cmp_pass2(Rv2);
    }
    Ra.sl[6]=8546; /* line # 8546 */
    if (V_cmp_macf) {
      Ra.sl[6]=8548; /* line # 8548 */
      P_lgt_dump_static(Rv2);
      Ra.sl[6]=8549; /* line # 8549 */
      P_lst_page();
    }
    Ra.sl[6]=8552; /* line # 8552 */
    if (V_error_result>1) V_emergency_stop=1;
    else {
      Ra.sl[6]=8555; /* line # 8555 */
      P_pas_write_env_file();
      Ra.sl[6]=8556; /* line # 8556 */
      P_generate_code_p2();
    }
  }
  Ra.sl[6]=8560; /* line # 8560 */
  Ret=V_error_result;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}
