#
#       Makefile for pcmp (Pascal Compiler) on WINDOWS 95/NT and UNIX systems
#

PAS	=	cpas -t1 -kc -g -sysc
INC	=	-I/usr/local/include
LIB	=	-L./ -L/usr/local/lib
#
OBJS = pcmp_ident.o pcmp_basdef.o pcmp_insymb.o pcmp_envinh.o\
	pcmp_lgt.o pcmp_dump.o pcmp_expr.o pcmp_comp.o pcmp_genc.o
#
install: pcmp_lib.a pcmp
#
pcmp_lib.a:$(OBJS)
	ar -r pcmp_lib.a $(OBJS)
#
pcmp: pcmp_main.pas pcmp_lib.a cpas_system_name_init.cpas
	$(PAS) pcmp_main $(INC) pcmp_main.pas pcmp_lib.a -o ./pcmp
#
pcmp_ident.o: pcmp_ident.pas
	$(PAS) -c pcmp_ident
#
pcmp_basdef.o: pcmp_basdef.pas
	$(PAS) -c pcmp_basdef
#
pcmp_insymb.o: pcmp_insymb.pas
	$(PAS) -c pcmp_insymb
#
pcmp_envinh.o: pcmp_envinh.pas
	$(PAS) -c pcmp_envinh
#
pcmp_lgt.o: pcmp_lgt.pas
	$(PAS) -c pcmp_lgt
#
pcmp_dump.o: pcmp_dump.pas
	$(PAS) -c pcmp_dump
#
pcmp_expr.o: pcmp_expr.pas
	$(PAS) -c pcmp_expr
#
pcmp_comp.o: pcmp_comp.pas
	$(PAS) -c pcmp_comp
#
pcmp_genc.o: pcmp_genc.pas
	$(PAS) -c pcmp_genc
#
#
clean:
	-rm pcmp*.c pcmp*.o  pcmp*.a
#
end:
