  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   1
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is ".standard.".

       C    1    1  {
       C    1    2  *************************************************************************
       C    1    3  *                                                                       *
       C    1    4  *                                                                       *
       C    1    5  *                     *  C P A S  *  S Y S T E M  *                     *
       C    1    6  *                                                                       *
       C    1    7  *                                                                       *
       C    1    8  *      * * *   C o m p i l a t i o n  - D i p a t c h e r   * * *       *
       C    1    9  *                                                                       *
       C    1   10  *                                                                       *
       C    1   11  *                ---  Version  3.1-B5 -- 31/01/2022 ---                 *
       C    1   12  *                                                                       *
       C    1   13  *                (Second version of the cpas dispatcher)                *
       C    1   14  *                                                                       *
       C    1   15  *           by :                                                        *
       C    1   16  *                                                                       *
       C    1   17  *               P. Wolfers                                              *
       C    1   18  *               www.pierre.wolfers.fr                                   *
       C    1   19  *                                          FRANCE.                      *
       C    1   20  *                                                                       *
       C    1   21  *************************************************************************
       C    1   22  
       C    1   23  
       C    1   24  
       C    1   25  /////////////////////////////////////////////////////////////////////////
       C    1   26  //                                                                     //
       C    1   27  //                                                                     //
       C    1   28  //                  Global Public Licence (GPL)                        //
       C    1   29  //                                                                     //
       C    1   30  //                                                                     //
       C    1   31  // This license described in this file overrides all other licenses    //
       C    1   32  // that might be specified in other files for this library.            //
       C    1   33  //                                                                     //
       C    1   34  // This program is free software; you can redistribute it and/or       //
       C    1   35  // modify it under the terms of the GNU Lesser General Public          //
       C    1   36  // License as published by the Free Software Foundation; either        //
       C    1   37  // version 2.1 of the License, or (at your option) any later version.  //
       C    1   38  //                                                                     //
       C    1   39  // This software is distributed in the hope that it will be useful,    //
       C    1   40  // but WITHOUT ANY WARRANTY; without even the implied warranty of      //
       C    1   41  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
       C    1   42  // Library General Public License for more details.                    //
       C    1   43  //                                                                     //
       C    1   44  // You should have received a copy of the GNU Lesser General Public    //
       C    1   45  // License along with this library (see COPYING.LIB); if not, write to //
       C    1   46  // the Free Software Foundation :                                      //
       C    1   47  //                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
       C    1   48  //                                                                     //
       C    1   49  /////////////////////////////////////////////////////////////////////////
       C    1   50  
       C    1   51  
       C    1   52  }
       C    1   53  
       C    1   54  {************     CPAS  version  V3.1-B5  *************}
       C    1   55  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   2
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is ".standard.".

       C    1   56  {
       C    1   57          *** Modification(s) from major version ****
       C    1   58  
       C    1   59  
       C    1   60  
       C    1   61          Change the Help message and modify some comments.
       C    1   62  .
       C    1   63  
       C    1   64  
       C    1   65  
       C    1   66                          ----
       C    1   67  
       C    1   68                         nothing
       C    1   69  
       C    1   70                          ----
       C    1   71  
       C    1   72  }
       C    1   73  
            1   74  program CPAS_DISPATCHER;
       C    1   75  
       C    1   76  
       C    1   77  
            1   78  %include 'passrc:cpascal_path_env.pas';         { Include the pascal environment Path definitions }
       C    1   79  
            1   80  const
            1   81    max_fref      =                          255; { Maximum sise of one source file reference }
            1   82    cpas_dispatch_setup = 'cpasd_setup.cpasd_data';       { Default name for setup file }
       C    1   83  
            1   84  type
       C    1   85           { *** arguments Definitions *** }
       C    1   86  
            1   87    arg_tsk   =   ( tsk_cpas_cmp,                 { Code for CPAS Compiler }
            1   88                      tsk_cc_cmp                  { Code for C Compiler }
            1   89                  );
       C    1   90  
            1   91    str_ptr   =                          ^string; { String Pointer }
            1   92    arg_ptr   =                         ^arg_rec; { Pointer to an argument (of command line) }
            1   93    mac_ptr   =                         ^mac_rec; { Pointer to a macro symbol definition }
       C    1   94  
       C    1   95  
            1   96    lab_type  =                     string( 30 ); { String use as entry name in the setup file }
       C    1   97  
            1   98    arg_rec( sz: byte ) = record                  { * Identifier Name Definition }
            1   99      next:                              arg_ptr; { Link to the next file name }
            1  100      frem:                              boolean; { Flag to remove the intermediary C file }
            1  101      sarg:                         string( sz )  { Name parameter pointer }
            1  102    end;
       C    1  103  
       C    1  104  
            1  105    mac_rec   = record
            1  106      mac_next: mac_ptr;                           { Link to next symbol definition }
            1  107      mac_args: str_ptr                            { String option for CPAS compiler }
            1  108    end;
       C    1  109  
       C    1  110  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   3
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cpas_dispatcher".

       C    1  111    { Define the managed options of the CC Compiler }
            1  112    mopt_type = ( mopt_cpas,                      { To specify the cpas command name }
            1  113                  mopt_tdir,                      { To specify the -T<dir> option form }
            1  114                  mopt_ccmp,                      { To specify the CC command name }
            1  115                  mopt_comp,                      { To specify the -c option form }
            1  116                  mopt_libs,                      { To specify the -l<lib> option form }
            1  117                  mopt_ldir,                      { To specify the -L<dir> option form }
            1  118                  mopt_idir,                      { To specify the -I<dir> option form }
            1  119                  mopt_defc,                      { To specify the -D<symbol> option form (for C Compiler only }
            1  120                  mopt_opti,                      { To specify an optimization level form }
            1  121                  mopt_exec,                      { To specify the name of executable file form }
            1  122                  mopt_stdl,                      { To specify the PATH to find the CPascal standard library }
            1  123                  mopt_sysc,                      { To specify the system features C options fot each supported sy
                    stem }
            1  124                  mopt_debs                       { To specify the debug form }
            1  125                );
       C    1  126  
       C    1  127    { Define the kind of option specifier forms }
            1  128    moptf_knd = ( moptf_nul,                      { Specify no variable argument }
            1  129                  moptf_spc,
            1  130                  moptf_str,                      { Specified variable argument is a string }
            1  131                  moptf_int,                      { Specified variable argument is an integer }
            1  132                  moptf_enm,                      { Specified variable argument is a literal enum }
            1  133                  moptf_stl,                      { Specified variable argument twin string list }
            1  134                  moptf_fst                       { Specified to define dispatcher flag (cannot be modified) }
            1  135                 );
       C    1  136  
            1  137    moptf_rec = record                            { * Define the  }
            1  138      moptf_name,                                 { The option identifier }
            1  139      moptf_prefix,                               { The prefix string }
            1  140      moptf_suffix:     lab_type;                 { The suffix string } { /// Type use to turn out a bug in pcmp t
                    ask /// }
            1  141      moptf_type:      moptf_knd;                 { The format specifier }
            1  142      moptf_ennum:       arg_ptr                  { The ennum option string pointer (as '<f1>,<f2>,<f3> ... ) }
            1  143    end;
       C    1  144  
            1  145    moptf_tab = array[mopt_type]  of   moptf_rec; { The table of setup field format }
       C    1  146  
       C    1  147  
            1  148    sysopt_ptr   =    ^sysopt_rec;                { Define the pointer type for a system C options }
       C    1  149  
            1  150    sysopt_rec = record                           { * Define the system C option for an OS. }
            1  151      sys_next:                       sysopt_ptr; { Pointer for next OS. }
            1  152      sys_nam:                          lab_type; { Name of OS. }
            1  153      sys_opt:          array[1..4]  of  str_ptr; { The Pascal option for OS feature dependent compilation. }
            1  154    end;
       C    1  155  
       C    1  156  
            1  157  var
            1  158    current_system: [static] string  :=  %SYSTEM; { Get the cuurent (compilation time) system name }
       C    1  159  
       C    1  160  
            1  161    setup_tab:  moptf_tab := [    { * Define the setup identiers table with related default format field }
       C    1  162                 {      name,   prefix, suffix, type,  ennul }
            1  163                 [   'CPAS_cmd', 'pcmp', '', moptf_nul, nil  ],   { mopt_cpas, }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   4
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cpas_dispatcher".

            1  164                 [   'C_TmpDir',     '', '', moptf_nul, nil  ],   { mopt_tdir, }
            1  165                 [     'CC_cmd',  'gcc', '', moptf_nul, nil  ],   { mopt_ccmp, }
            1  166                 [  'C_Compile',   '-c', '', moptf_nul, nil  ],   { mopt_comp, }
            1  167                 [      'C_Lib',   '-l', '', moptf_str, nil  ],   { mopt_libs, }
            1  168                 [   'C_LibDir',   '-L', '', moptf_str, nil  ],   { mopt_ldir, }
            1  169                 [   'C_IncDir',   '-I', '', moptf_str, nil  ],   { mopt_idir, }
            1  170                 [  'C_DefSymb',   '-D', '', moptf_str, nil  ],   { mopt_defc, }
            1  171                 [ 'C_Optimize',   '-O', '', moptf_str, nil  ],   { mopt_opti, }
            1  172                 [     'C_Exec',  '-o ', '', moptf_str, nil  ],   { mopt_exec, }
            1  173                 ['CPasLibPath',     '', '', moptf_fst, nil  ],   { mopt_stdl, }
            1  174                 ['CSysCCmpOpt',     '', '', moptf_stl, nil  ],   { mopt_sysc, }
            1  175                 [    'C_Debug',   '-g', '', moptf_nul, nil  ]    { mopt_debs  }
            1  176               ];
       C    1  177  
            1  178    cdir_fspc,                                    { Cpas out C file directory to use }
            1  179    trg_sys_name,                                 { Target system name for partial cross compilation }
            1  180    setup_fspc:           string( 255 ) :=    ''; { Cpas Dispatcher setup file specification }
       C    1  181  
            1  182    pas_arg_last,                                 { Last argument pointer in the CPAS Compiler argument list }
            1  183    pas_arg_list,                                 { List for CPAS Compiler arguments (a FIFO Queue) }
            1  184    cc__arg_last,                                 { Last argument pointer in the C Compiler argument list }
            1  185    cc__arg_list:         arg_ptr     :=     nil; { List for C Compiler arguments (a FIFO Queue) }
       C    1  186  
            1  187    mac_arg_first,                                { Macro Symbol Queue : First and ... }
            1  188    mac_arg_last:         mac_ptr     :=     nil; { ... last macro symbol to provide to CPAS Compiler. }
       C    1  189  
            1  190    stdl_path,                                    { Standard CPascal Library PATH }
            1  191    main_name:            string( 48 )  :=    ''; { Main name }
       C    1  192  
            1  193    cmp_stdlib_path,                              { Flag to specify the CPascal library path for gcc/ld }
       C    1  194  
            1  195    cmp_verbose,                                  { Flag for the dispatcher verbose option }
            1  196    cmp_ccopt,                                    { Flag to signal option as -l, -L, -I, -o,  }
            1  197    cmp_no_paslib,                                { Flag to do not specify to C compiler the options -lcpas and -l
                    m }
            1  198    cmp_ccmp,                                     { Transmit option to the C compiler }
            1  199    cmp_noccmp,                                   { Do not execute the C Compiler }
            1  200    cmp_optspc,                                   { A optimization is specified when true }
            1  201    cmp_range,                                    { Index/Value out of range check flag }
            1  202    cmp_rsfchk,                                   { Record Selector and Field Matching check flag }
            1  203    cmp_debugopt,                                 { Debug flag }
            1  204    cmp_macf,                                     { P code Listing output (For any compiler debug purpose) }
            1  205    cmp_xcross,                                   { Flag for X<sys_name> cross compilation }
            1  206    cmp_simul,                                    { For Dispatcher debug - do not call any compiler }
            1  207    cmp_keepc,                                    { Flag to keep the intermediary C files }
            1  208    cmp_system,                                   { Option to compile module using system features }
            1  209    cmp_noobjf:           boolean     :=   false; { No object (and C code) output - just check Pascal syntax }
       C    1  210  
            1  211    cmp_optlvl:           integer     :=       2; { Compilation optimization level (-O2 the default is generally a
                     good choice) }
            1  212    cmp_listlvl:          integer     :=      -1; { Lcmp_ccoptisting level output (level of nesting source insert)
                    , (default is no listing) }
            1  213    cmp_traceopt:         integer     :=      -1; { Trace level (0 => No tracing) }
            1  214    cmp_verblvl:          integer     :=       1; { Verbose Level for CPAS-Dispatcher Debugging }
       C    1  215  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   5
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cpas_dispatcher".

            1  216    cpas_name:            lab_type    :=  'pcmp'; { Cpascal Compiler command name (default pcmp) }
            1  217    ccmp_name:            lab_type    :=   'gcc'; { C Compiler command name (default gcc) }
       C    1  218  
            1  219    inp:                                    text; { File variable to use for read }
       C    1  220  
            1  221    sys_o_first,                                  { First and last OS options record to form  ... }
            1  222    sys_o_last:         sysopt_ptr    :=     nil; { ... the C Compiler option list header. }
       C    1  223  
       C    1  224  
       C    1  225  
       C    1  226  
            1  227  procedure LOCATE_EXTENSION( var fnm: [readonly] string; var ie, ip: integer );
       C    1  228  { Look for the extension and directory position in a file specification.
       C    1  229    fnm is the file specification,
       C    1  230    ie is the returned position of the dot mark before the extension or 0,
       C    1  231    ip is the returned position of the end of directory (or device) specification or 0.
       C    1  232    The meaning of 0 result is not found.
       C    1  233  }
            1  234  var
            1  235    i: integer;
       C    1  236  
            1  237  begin
     1      1  238    i := fnm.length;
            1  239    ie := 0;
            1  240    ip := 0;
            1  241    while i > 0 do
            1  242    begin
     2      1  243      case fnm.body[i] of
            1  244        '.':                ie := i;
            1  245        '/', '\', ']', ':': begin  ip := i; i := 0  end;
            1  246      otherwise
            1  247      end;
            1  248      i := i - 1;
            1  249      if ip > ie then ie := 0
     1      1  250    end
     0      1  251  end LOCATE_EXTENSION;
       C    1  252  
       C    1  253  
       C    1  254  
            1  255  procedure ARGUMENT_APPEND( in_var arg: string; tsk: arg_tsk; remflg: boolean := false );
            1  256  var
            1  257    parg:        arg_ptr;
       C    1  258  
            1  259  begin
       C    1  260  (*
       C    1  261  WRITELN( ' ARGUMENT_APPEND( "', arg, '", ', tsk, ' );' );
       C    1  262  *)
     1      1  263    NEW( parg, arg.length );
            1  264    with parg^ do
            1  265    begin
     2      1  266      next := nil;
            1  267      frem := remflg;
            1  268      sarg := arg
     1      1  269    end;
            1  270    case tsk of
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   6
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "argument_append".

            1  271      tsk_cpas_cmp:
            1  272        begin
     2      1  273          if pas_arg_list = nil then pas_arg_list := parg
            1  274                                else pas_arg_last^.next := parg;
            1  275          pas_arg_last := parg
     1      1  276        end;
            1  277      tsk_cc_cmp:
            1  278        begin
       C    1  279  
     2      1  280          if cc__arg_list = nil then cc__arg_list := parg
            1  281                                else cc__arg_last^.next := parg;
            1  282          cc__arg_last := parg
     1      1  283        end
            1  284    end
     0      1  285  end ARGUMENT_APPEND;
       C    1  286  
       C    1  287  
       C    1  288  
            1  289  procedure TRANSLATE_OPTION( copt: mopt_type; sv: string := ''; iv: integer := 0 );
            1  290  var
            1  291    topt:  string;
            1  292    pelm: arg_ptr;
       C    1  293  
            1  294  begin
       C    1  295  (*
       C    1  296  WRITE( ' * TRANSLATE_OPTION( ', copt, ', "', sv, '", ', iv:0, ' );' );
       C    1  297  *)
     1      1  298    with setup_tab[copt] do
            1  299    begin
     2      1  300      WRITEV( topt, moptf_prefix );
            1  301      case moptf_type of
            1  302        moptf_str: WRITEV( topt:false, SUBSTR( sv, iv + 1 ) );
            1  303        moptf_int: WRITEV( topt:false, iv:0 );
            1  304        moptf_enm:
            1  305          begin
     3      1  306            pelm := moptf_ennum;
            1  307            while (pelm <> nil) and (iv >= 0) do
            1  308            with pelm^ do
            1  309            begin
     4      1  310              if iv = 0 then WRITEV( topt:false, sarg );
            1  311              iv := iv - 1;
            1  312              pelm := next
     3      1  313            end;
     2      1  314          end;
            1  315      otherwise
            1  316      end;
            1  317      WRITEV( topt:false, moptf_suffix );
     1      1  318    end;
            1  319    ARGUMENT_APPEND( topt, tsk_cc_cmp )
     0      1  320  end TRANSLATE_OPTION;
       C    1  321  
       C    1  322  
       C    1  323  
            1  324  procedure SET_OPTIONS_AND_PARM;
       C    1  325  { Procedure to set the compiler options and file specifications }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   7
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  326  type
            1  327    opt_codes = ( opt_ccmp,       { -ccmp (Option to send option to the C compiler) }
            1  328                  opt_noccmp,     { -nccmp (To do not invoke the C Compiler) }
            1  329                  opt_c_opt,      { -c (Create object file and stop, it is the default for module file) }
            1  330                  opt_lib_opt,    { -l<library_file> (to specify a library to link, -lm and -lcpas are assumed) }
            1  331                  opt_ldir_opt,   { -L<directory> (to specify a new library directory) }
            1  332                  opt_idir_opt,   { -I<directory> (to specify a new insert source file directory) }
            1  333                  opt_defc_opt,   { -D<symbol> (to define a macro symbol for C compiler) }
            1  334                  opt_opt_opt,    { -O<n> to specy an optimization level to the C compiler }
            1  335                  opt_npl_opt,    { -npl option to do not generate the -lcpas and -lm option of the C compiler }
            1  336                  opt_exec_fsp,   { -o <exec_file> to specify a particular exec file specification (defaulted with
                     source name) }
            1  337                  opt_macro,      { -M<name>[=<string>] option to define Pascal macro symnbol }
            1  338                  opt_range,      { -r (To generate the range check for range type assignation and arry index) }
            1  339                  opt_rsfchk,     { -rs Record Selector field check }
            1  340                  opt_trace,      { -t<n> (To generate the execution line trace on error) }
            1  341                  opt_debug,      { -g or --debugf (old option -d) }
            1  342                  opt_listn,      { --list (old option -l) }
            1  343                  opt_cptree,     { -cp or --tree (old option -c) }
            1  344                  opt_check,      { -ch (old -n option) }
            1  345                  opt_tdir,       { -T<dir> to specify a directoy for temporary files (the default is the user dir
                    ectory) }
            1  346                  opt_verbose,    { Long output for CPAS-D debug }
            1  347                  opt_help,       { -h or --help }
            1  348                  opt_simul,      { To simule compile sequence without compiler call (Dispatcher debugging) }
            1  349                  opt_othsys,     { To set the -x<sysname> options => -nocc }
            1  350                  opt_keepc,      { Option to keep the intermediary C files }
            1  351                  opt_sys_cmp,    { For System compilation RTL, compiler ... }
            1  352                  opt_undef       { Unknown option }
            1  353                );
       C    1  354  
       C    1  355    { Define the table of short form of option names }
            1  356    opt_tabty = array[opt_codes] of string( 6 );
       C    1  357  
       C    1  358  
            1  359  var
            1  360    ierr, i, j, ii, jj, ll, md:  integer;
            1  361    fnm,
            1  362    arg:                   string( 255 );
            1  363    ext:                     string( 8 );
            1  364    optcd:                     opt_codes;
            1  365    pmc:                         mac_ptr;
            1  366    hasinput, pasflg:            boolean;
       C    1  367  
       C    1  368  
            1  369  const
       C    1  370                         { 123456789, 123456789, 123456789, 123456789,   123456789ABC, 123456789ABC, 123456789ABC,
                     123456789ABC  }
            1  371    opt_table = opt_tabty[    '-cc(',   '-nocc',      '-c',     '-l*', {     opt_ccmp,   opt_noccmp,    opt_c_opt,
                      opt_lib_opt, }
            1  372                               '-L*',     '-I*',     '-D*',     '-O*', { opt_ldir_opt, opt_idir_opt, opt_defs_opt,
                      opt_opt_opt, }
            1  373                            '-nplib',      '-o',     '-M*',      '-r', {  opt_npl_opt, opt_exec_fsp,    opt_macro,
                        opt_range, }
            1  374                              '-sfc',     '-t*',      '-g',    '-sl*', {   opt_rsfchk,    opt_trace,    opt_debug,
                        opt_listn, }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   8
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  375                               '-cp',     '-ch',     '-T*',  '-verb*', {   opt_cptree,    opt_check,     opt_tmpf,
                      opt_verbose, }
            1  376                                '-h',  '-simul',     '-x*',     '-kc', {     opt_help,   opt_simul,     opt_othsys
                    ,   opt_keepc, }
            1  377                             '-sysc',   '*ERR*'                        {  opt_sys_cmp, (Undef=Error) }
            1  378                          ];
       C    1  379  
       C    1  380  
       C    1  381  
            1  382  begin { SET_OPTIONS_AND_PARM }
     1      1  383    i  := 1;                                              { Skip the # 0 parameter }
            1  384    md := 0;                                              { Begining with the source file }
            1  385    hasinput  := false;                                   { Set no input file until shown otherwise }
            1  386    while i < argc do
            1  387    begin
     2      1  388      if argv[i] <> nil then
            1  389      begin
     3      1  390        arg := argv[i]^;
            1  391        if arg.length > 1 then                            { It is a real parameter }
            1  392        with arg do
            1  393        begin
     4      1  394          if arg[1] = '-' then
            1  395            if cmp_ccmp then                              { Take all consecutice C Compiler options }
            1  396            begin
     5      1  397              if arg[2] = ')' then cmp_ccmp := false      { Finish the direct C compiler option list }
            1  398              else
            1  399                ARGUMENT_APPEND( arg, tsk_cc_cmp )        {  Put all C compiler option directly in the opt_list }
     4      1  400            end
            1  401            else
            1  402            begin
     5      1  403              optcd := opt_codes"first;
            1  404              repeat
     6      1  405                ii := 2;
            1  406                with opt_table[optcd] do
            1  407                begin
     7      1  408                  ll := length;
            1  409                  if body[ll] = '*' then ll := ll - 1;
            1  410                  repeat                                  { loop to compare the option name with its model }
     8      1  411                  exit if body[ii] <> arg[ii];
            1  412                    ii := ii + 1;
     7      1  413                  until ii > ll                           { Loop on all option name characters }
     6      1  414                end;
            1  415                if ii <= ll then optcd := SUCC( optcd );
     5      1  416              until (ii > ll) or (optcd >= opt_undef);    { stop search when Names matchs or unknown option }
            1  417              if optcd >= opt_undef then optcd := opt_undef;
       C    1  418  
       C    1  419              { Option dispatching }
            1  420              case optcd of
            1  421                opt_ccmp:     cmp_ccmp        :=    true; { Put all C compiler option directly in the opt_list }
       C    1  422  
            1  423                opt_noccmp:   cmp_noccmp      :=    true; { Do not execute the C compiler (to work as the old vers
                    ions <= V2.2 pcmp) }
       C    1  424  
            1  425                opt_c_opt:                                { -c }
            1  426                  begin
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page   9
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

     6      1  427                    cmp_no_paslib := true;                { Suppress the automatic addition of -lcpas and -lm link
                     options }
            1  428                    TRANSLATE_OPTION( mopt_comp )
     5      1  429                  end;
       C    1  430  
            1  431                opt_lib_opt:  TRANSLATE_OPTION( mopt_libs, arg, ll );     { -l<lib> }
       C    1  432  
            1  433                opt_ldir_opt: TRANSLATE_OPTION( mopt_ldir, arg, ll );     { -L<dir> }
       C    1  434  
            1  435                opt_idir_opt: TRANSLATE_OPTION( mopt_idir, arg, ll );     { -I<dir> }
       C    1  436  
            1  437                opt_defc_opt:                             { -D<symbol> (Option to define a macro symbol for C Comp
                    iler). }
            1  438                  begin
     6      1  439                    if optcd = opt_c_opt then cmp_no_paslib := true;
            1  440                    TRANSLATE_OPTION( mopt_defc, arg, ll );       { Send to the C Compiler. }
            1  441                    cmp_ccopt := true
     5      1  442                  end;
       C    1  443  
            1  444                opt_opt_opt:
            1  445                  begin                                   { Get option for CPAS compiler and ... }
     6      1  446                    ll := ll + 1;
            1  447                    if length >= ll then
            1  448                      case body[ll] of
            1  449                        '0', '1', '2', '3': cmp_optlvl := ORD( body[ll] ) - ORD( '0' );
            1  450                      otherwise
     7      1  451                        cmp_optlvl := 2
     6      1  452                      end
            1  453                    else cmp_optlvl := 2;
            1  454                    cmp_optspc := true;
            1  455                    TRANSLATE_OPTION( mopt_opti,,cmp_optlvl )     { Send to the C Compiler. }
     5      1  456                  end;
       C    1  457  
            1  458                opt_exec_fsp:
            1  459                  begin                                           { Get the requested file specification for the e
                    xecutable file }
     6      1  460                    i := i + 1;
            1  461                    TRANSLATE_OPTION( mopt_exec, argv[i]^ );      { Send it as a unique option on the C Compiler f
                    orm -o:<exec_filepath> }
            1  462                    cmp_ccopt := true
     5      1  463                  end;
       C    1  464  
            1  465                opt_macro:                                        { Transfert directly this option to the CPAS com
                    piler }
            1  466                  begin
     6      1  467                    NEW( pmc );
            1  468                    with pmc^ do                                  { Build the Macro argument record }
            1  469                    begin
     7      1  470                      mac_next := nil;
            1  471                      NEW( mac_args, arg.length );
            1  472                      mac_args^ := arg
     6      1  473                    end;
       C    1  474                    { Put it in the Macro argument Queue. }
            1  475                    if mac_arg_first = nil then mac_arg_first := pmc
            1  476                                           else mac_arg_last^.mac_next := pmc;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  10
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  477                    mac_arg_last := pmc
     5      1  478                  end;
       C    1  479  
            1  480                opt_npl_opt:  cmp_no_paslib   :=    true; { Set the flag to suppress the automatic -lcpas and -lm 
                    options for C Compiler }
       C    1  481  
            1  482                opt_range:    cmp_range       :=    true; { Option for Check range statements Generation }
       C    1  483  
            1  484                opt_rsfchk:   cmp_rsfchk      :=    true; { Record Selector field check statements Generation }
       C    1  485  
            1  486                opt_trace:
            1  487                  begin
     6      1  488                    ll := ll + 1;
            1  489                    if length >= ll then                  { Option to set the line updating number for the Error t
                    racing output. }
            1  490                      case body[ll] of                    { A level of 0 suppress the line and source file error t
                    racing output. }
            1  491                        '+': j := 1;
            1  492                        '-': j := 0;
            1  493                        '0'..'9': j := ORD( body[ll] ) - ORD( '0' );
            1  494                      otherwise
            1  495                      end
            1  496                    else j := 1;
            1  497                    cmp_traceopt := j;
            1  498                    if cmp_debugopt then cmp_traceopt := 1
     5      1  499                  end;
       C    1  500  
            1  501                opt_debug:                                { Set the debug option  }
            1  502                  begin
     6      1  503                    cmp_debugopt := true;
            1  504                    TRANSLATE_OPTION( mopt_debs );        { ... also for the C Compiler and ... }
            1  505                    cmp_traceopt := 1                     { ... and force the line error trace for each line. }
     5      1  506                  end;
       C    1  507  
            1  508                opt_listn:                                { Option to enable or disable listing of source and ... 
                    }
            1  509                  begin
     6      1  510                    ll := ll + 1;
            1  511                    if length >= ll then
            1  512                    case body[ll] of
            1  513                      '+': j :=  9;                       { ...and to set maximum listing output level. }
            1  514                      '-': j :=  1;
            1  515                      '0'..'9': j := ORD( body[ll] ) - ORD( '0' );
            1  516                    otherwise
     7      1  517                      j := -1                             { No listing default }
     6      1  518                    end else j := 1;
            1  519                    cmp_listlvl := j
     5      1  520                  end;
       C    1  521  
            1  522                opt_cptree:       cmp_macf    :=    true; { Option to enable the Tree Output Code (for CPAS compil
                    er debugging) }
       C    1  523  
            1  524                opt_check:        cmp_noobjf  :=    true; { No code Generation option - cpas is call only for synt
                    ax checking. }
       C    1  525  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  11
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  526                opt_tdir:                                 { -T<dir> to specify a C temporary directory }
            1  527                  begin
     6      1  528                    cdir_fspc  := SUBSTR( arg, ll+1 );    { Get the specifier directory for the C file }
            1  529                    if cdir_fspc.length = 0 then
            1  530                      cdir_fspc := setup_tab[mopt_tdir].moptf_prefix;
            1  531                    if cdir_fspc[cdir_fspc.length] <> '/' then
            1  532                      cdir_fspc := cdir_fspc||'/';
            1  533                    if hasinput then
            1  534                    begin
     7      1  535                      WRITELN( err, ' CPAS-DISPATCHER Error : The "', arg, '" option must be specified before the 
                    first input file => STOP.' );
            1  536                      PASCAL_EXIT( 2 )
     6      1  537                    end
     5      1  538                  end;
       C    1  539  
            1  540                opt_verbose:                              { Option to set the mode verbose od CPAS-D }
            1  541                  begin
     6      1  542                    ll := ll + 1;
            1  543                    cmp_verbose := true;
            1  544                    if length >= ll then
            1  545                      case body[ll] of
            1  546                        '1',
            1  547                        '2',
            1  548                        '3': cmp_verblvl := ORD( body[ll] ) - ORD( '0' );
            1  549                        '+': cmp_verblvl := 3;
            1  550                      otherwise
            1  551                      end
     5      1  552                  end;
       C    1  553  
            1  554                opt_othsys:                               { -x<sysname> option for partial cross compilation }
            1  555                  begin
     6      1  556                    trg_sys_name := SUBSTR( arg, 3 );     { Get the target system name in -x<system_name> }
            1  557                    if trg_sys_name <> current_system then{ If the system name is not the current ones ... }
            1  558                    begin
     7      1  559                      cmp_noccmp  := true;                { ... we disable the C compiler call and ... }
            1  560                      cmp_xcross  := true                 { ... and validate the -x pcmp options. }
     6      1  561                    end
     5      1  562                  end;
       C    1  563  
            1  564                opt_keepc:        cmp_keepc   :=    true; { Set the option to keep the intermediary C files }
       C    1  565  
            1  566                opt_sys_cmp:      cmp_system  :=    true; { Set the system module(s) compilation mode (add CC spec
                    ific options) }
       C    1  567  
            1  568                opt_help:                                 { Option to output the help message and exit }
            1  569                  begin
     6      1  570                    WRITELN;
            1  571                    WRITELN( ' CPAS Dispatcher command form for CPAS V3.1-B1 (30-JUN-2016)' );
            1  572                    WRITELN;
            1  573                    WRITELN( ' The general form of a cpas command is:' );
            1  574                    WRITELN( '    cpas [<option(s)>] <pascal_file> ... <c_file> ... <o_file> ... <lib_file> ...' )
                    ;
            1  575                    WRITELN;
            1  576                    WRITELN( '    When the <listing_file> is specified the Listing mode is Enabled.' );
            1  577                    WRITELN( '    The default <listing_file> is TT: with listing disable and' );
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  12
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  578                    WRITELN( '    the default <c_file> is the <pascal_file> with the ".c" type.' );
            1  579                    WRITELN( '      Note: TT: is the specification of /dev/tty and NL: is the specification of /de
                    v/null.' );
            1  580                    WRITELN;
            1  581                    WRITELN;
            1  582                    WRITELN( ' The cpas <option(s)> are (major or minor letter) :' );
            1  583                    WRITELN;
            1  584                    WRITELN( '    -cc(     To specify special C compiler options (given after this option and befo
                    re "-)" option).' );
            1  585                    WRITELN( '             Example: -cc( -ansi -Wall -).' );
            1  586                    WRITELN( '    -nocc    To do not call the C compiler after the cpas compiler completion.' );
            1  587                    WRITELN( '    -M<name> or' );
            1  588                    WRITELN( '    -M<name>=<string_value>' );
            1  589                    WRITELN( '             To create the macro identifier <Name>. If <string_value> is specified i
                    t is the string value' );
            1  590                    WRITELN( '             of the macro symbol, else the macro symbol value is a null string.' );
            1  591                    WRITELN( '    -x<sys>  To specify a cross compilation mode where sys is the Kit_Builder target
                     system name.' );
            1  592                    WRITELN( '             This switch set also the -nocc option because the C compiler must be ru
                    n on the target processor.' );
            1  593                    WRITELN( '    -c       To do not performe a link (transmit to C compiler - default for module 
                    source).' );
            1  594                    WRITELN( '    -l<lib>  To specify a library for the link (transmit to C compiler).' );
            1  595                    WRITELN( '    -L<dir>  To specify a library search directory for the link (transmit to C compi
                    ler).' );
            1  596                    WRITELN( '    -nplib   To supress implicite -lcpas -lm option for main module (transmit to C c
                    ompiler).' );
            1  597                    WRITELN( '    -O<n>    To specify the optimization level for the C compiler (default is implem
                    entation dependant).' );
            1  598                    WRITELN( '    -o <f>   To specify the binary executable file to generate (default is <main_fil
                    e> without ".pas").' );
            1  599                    WRITELN( '    -r       To enable the value or index range error detection' );
            1  600                    WRITELN( '             (usefull to detect the out of array index range).' );
            1  601                    WRITELN( '    -rsf     To detect when a record field access does not match with record selecto
                    r value (has no effect presently)' );
            1  602                    WRITELN( '             (usefull to detect an illegal access to a record field.).' );
            1  603                    WRITELN( '    -t<n>    To set the error tracing precision to n lines,' );
            1  604                    WRITELN( '             where n is a single digit 0 to 9 and + or - .' );
            1  605                    WRITELN( '             -t0 and -t- disable the error tracing,' );
            1  606                    WRITELN( '             -t+ is equivalent to -t1 and the default is -t5,' );
            1  607                    WRITELN( '             this options is equivalent to "%pragma trace:<n>;" .' );
            1  608                    WRITELN( '    -g       To enable the future debug generation mode;' );
            1  609                    WRITELN( '             this options induces the -t1 tracing mode.' );
            1  610                    WRITELN( '    -sl<n>   To enable and set the source listing output level to list the included'
                     );
            1  611                    WRITELN( '             source listing with n in the range 1..9 (default is -l1).' );
            1  612                    WRITELN( '             The default listing file name will be <pascal_file_name>.lis for each p
                    ascal source.' );
            1  613                    WRITELN( '    -cp      To enable the logical tree output. The effect is' );
            1  614                    WRITELN( '             equivalent to the macro statement "%pragma cp_list_on;" .' );
            1  615                    WRITELN( '    -ch      To disable the code generation for checking code purpose.' );
            1  616                    WRITELN;
            1  617                    WRITELN( '    -T<dir>  To specify a directory for temporary file as intermediate C files.' );
            1  618                    WRITELN;
            1  619                    WRITELN( '    -kc      To save intermediary C files.' );
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  13
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

            1  620                    WRITELN;
            1  621                    WRITELN( '    -sysc    To specify a compilation using target system specific features.' );
            1  622                    WRITELN;
            1  623                    WRITELN( '    -verb<n> To force the debugging output of the Cpascal Dispatcher itself.' );
            1  624                    WRITELN( '             To debug the setup process, put this option in first argument.' );
            1  625                    WRITELN;
            1  626                    WRITELN( '    -h       To output this help text.' );
            1  627                    WRITELN;
            1  628                    WRITELN( '    -simul   To set the simulation mode with implicite option -verb+.' );
            1  629                    WRITELN;
            1  630                    PASCAL_EXIT( 0 )
     5      1  631                  end;
       C    1  632  
            1  633                opt_simul:
            1  634                  begin
     6      1  635                    cmp_simul   := true; { Set the simulation mode }
            1  636                    cmp_verbose := true;
            1  637                    cmp_verblvl := 3
     5      1  638                  end;
       C    1  639  
            1  640              otherwise { Ignore Unknown Options }
     6      1  641                WRITELN( err, ' CPAS-DISPATCHER Error : unrecognized command line option "', arg, '" => STOP.' );
            1  642                PASCAL_EXIT( 2 )
     5      1  643              end
     4      1  644            end
            1  645          else
            1  646          begin { Get a file specification and put it in the appropriate argument list }
     5      1  647            LOCATE_EXTENSION( arg, ii, jj );
            1  648            if ii > 0 then
            1  649            begin { File specification with a specified extention }
     6      1  650              ext := SUBSTR( arg, ii );
            1  651              pasflg := (ext = '.p') or (ext = '.P') or (ext = '.pas') or (ext = '.PAS');
            1  652              if pasflg then fnm := cdir_fspc||SUBSTR( arg, jj+1, ii-jj-1 )||'.c'
     5      1  653            end
            1  654            else
            1  655            begin { File specification without specified extention }
     6      1  656              pasflg := true;
            1  657              fnm := cdir_fspc||SUBSTR( arg, jj+1 )||'.c';
            1  658              arg := arg||'.pas'
     5      1  659            end;
       C    1  660  
            1  661            if pasflg then
            1  662            begin
     6      1  663              ARGUMENT_APPEND( arg, tsk_cpas_cmp );
            1  664              ARGUMENT_APPEND( fnm, tsk_cc_cmp, not cmp_keepc )
     5      1  665            end
            1  666            else ARGUMENT_APPEND( arg, tsk_cc_cmp );
            1  667            hasinput := true
     4      1  668          end
     3      1  669        end
     2      1  670      end;
            1  671      i := i + 1
     1      1  672    end;
            1  673    if not (cmp_noccmp or cmp_no_paslib) then
            1  674    begin
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  14
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "set_options_and_parm".

     2      1  675      if cmp_stdlib_path then TRANSLATE_OPTION( mopt_ldir, stdl_path );
            1  676      TRANSLATE_OPTION( mopt_libs, 'cpas' );
            1  677      TRANSLATE_OPTION( mopt_libs, 'm' )
     1      1  678    end;
            1  679    if not hasinput then
            1  680    begin
     2      1  681      WRITELN( ' CPAS-DISPATCHER : No input file to compile => STOP.' );
            1  682      PASCAL_EXIT( 2 )
     1      1  683    end
     0      1  684  end SET_OPTIONS_AND_PARM;
       C    1  685  
       C    1  686  
       C    1  687  
       C    1  688  
            1  689  procedure SETUP_PATH_SEARCH;
       C    1  690  { Procedure to locate the setup file }
            1  691  var
            1  692    upath, dir, nam:      string;
            1  693    ib, ie, n:           integer;
            1  694    dir_sep:                char;
            1  695    fnd:                 boolean;
       C    1  696  
            1  697  begin
       C    1  698    {  Select the appropriate setup path and directory separator to search the setup file }
     1      1  699    dir_sep := '/';
            1  700    upath := PASCAL_PATH_ENV;
            1  701    ib  :=     1;
            1  702    n   :=     1;
            1  703    fnd := false;
            1  704    nam := cpas_dispatch_setup;
            1  705    while not fnd and (ib <> 0) do                                    { Loop on all PATH entries }
            1  706    begin
     2      1  707      ie := INDEX( upath, ';', n ); n := n + 1;
            1  708      if ie = 0 then
            1  709      begin  dir := SUBSTR( upath, ib ); ib := 0  end                 { Get one path entry except the last one }
            1  710      else
            1  711      begin  dir := SUBSTR( upath, ib, ie - ib ); ib := ie + 1  end;  { To get the last path entryt }
            1  712      if dir[dir.length] <> dir_sep then begin  dir.length := dir.length + 1; dir[dir.length] := dir_sep  end;
            1  713      setup_fspc := dir||nam;                                         { Build a possible complete setup file speci
                    fication }
            1  714      fnd := FILE_ACCESS_CHECK( setup_fspc, 4 {Read access} )         { Test it for free access to read }
     1      1  715    end;                                                              { End of search loop }
            1  716    if not fnd then                                                   { When the setup is not found, signal it and
                     stop }
            1  717    begin
     2      1  718      WRITELN( ' *** CPAS-DISPATCHER cannot find or open the setup file "', cpas_dispatch_setup, '"' );
            1  719      PASCAL_EXIT( 2 )
     1      1  720    end;
            1  721    if n > 2 then { We use a standard tree for the CPascal environment }
            1  722    begin
     2      1  723      ib := INDEX( dir, dir_sep, -3 );
            1  724      dir.length := ib;
            1  725      dir := dir||'lib'
     1      1  726    end
            1  727    else { We use a debugging Cpascal environment }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  15
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "setup_path_search".

            1  728      dir.length := dir.length - 1;
            1  729    SET_FILE_SPECIFICATION( stdl_path, dir, [case_ena_file] );
     0      1  730  end SETUP_PATH_SEARCH;
       C    1  731  
       C    1  732  
       C    1  733  
            1  734  procedure READ_SETUP_FILE;
       C    1  735  { Read the setup file if found }
            1  736  const
            1  737    mdnam     =   'RSFL';         { Module code name for setup file syntax error }
       C    1  738  
            1  739  type
            1  740    symbol = ( sy_ident,          { An identifier was found }
            1  741               sy_string,         { A string was found }
            1  742               sy_integer,        { An integer value was found }
            1  743               sy_float,          { An floating value was found }
            1  744               sy_comma,          { "," was found }
            1  745               sy_colon,          { ":" was found }
            1  746               sy_semicolon,      { ";" was found }
            1  747               sy_lpar,           { "(" was found }
            1  748               sy_rpar,           { ")" was found }
            1  749               sy_lbra,           { "[" was found }
            1  750               sy_rbra,           { "]" was found }
            1  751               sy_equal,          { "=" was found }
            1  752               sy_eoln,           { End Of Line found }
            1  753               sy_eof,            { End Of File Reached }
            1  754               sy_illegal,        { Illegal syntax found }
            1  755               sy_no_skip         { used only for error without skip }
            1  756             );
       C    1  757  
            1  758    sym_set   =    set of symbol; { used for skip symbol }
       C    1  759  
       C    1  760  
            1  761  [static]
            1  762  var
            1  763    sy_nchar,                                             { Current setup file character index }
            1  764    sy_nline:             integer :=   0;                 { Current setup file line number }
       C    1  765  
            1  766    sy_cline,                                             { Current line of setup file }
            1  767    sy_str:                       string;                 { The current string or identifier }
            1  768    sy_ide:                     lab_type;                 { The current identifier }
            1  769    sy_int:                      integer;                 { The current integer value }
            1  770    sy_flt:                       double;                 { The current float value }
            1  771    sy:                           symbol;                 { Readden (by INSYMBOL) symbol type }
            1  772    sy_noeol:         boolean  :=   true;                 { By default ignore any EOLN }
       C    1  773  
            1  774    pide, plast:                 arg_ptr;                 { Current and last pointer to build indentifier list }
            1  775    mopt:                      mopt_type;                 { The managed option form specification }
            1  776    fnd:                         boolean;
       C    1  777  
            1  778    p1, p2:                   sysopt_ptr;                 { Temporary pointer to include in the list of various OS
                     sys options }
            1  779    sop:                         str_ptr;                 { pointer for string option field }
            1  780    cop:                         integer;                 { Count for system specific setup attribute }
       C    1  781  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  16
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "read_setup_file".

            1  782    exit_flg:         boolean  :=  false;                 { Flag for stop process on setup file error. }
       C    1  783  
       C    1  784  
       C    1  785  
            1  786    procedure INSYMBOL;
            1  787    type
            1  788      ch_type = ( eos, eol, spc, ctl,                     {  EOF, EOLN, Space (= " " or TAB), <all other control c
                    haracter> }
            1  789                  oth, dig, let, quo,                     { other char, digit, letter and assim., "'"  '"' }
            1  790                  dif, lpa, rpa, lbr, rbr,                { '#', '(', ')', '[', ']', }
            1  791                  lac, rac,                               (* '{', '}' *)
            1  792                  oor, oan, oad, osu, omu, odi, opw,      { '!' or '|', '&', '+', '-', '*', '/', '^' }
            1  793                  oeq, olt, ogt,                          { '=', '<', '>' }
            1  794                  scm, spe, s2p, ssc, sas                 { ',', '.', ':', '\' }
            1  795                );
       C    1  796  
            1  797      ch_tab_ty  = array[CHR(0)..CHR(127)] of ch_type;    { Kind of character table }
       C    1  798  
       C    1  799  
            1  800    const
            1  801      ch_tab = ch_tab_ty[
       C    1  802               { 0    1    2    3    4    5    6    7 }     {  Meaning with XON=DC1, XOFF=DC3, SP=' '  }
            1  803        { 000 } eos, eol, ctl, ctl, ctl, ctl, ctl, ctl,     {  NUL, SOH, STX, ETX, EOT, ENQ, ACK, BEL  }
            1  804        { 010 } ctl, spc, ctl, ctl, ctl, ctl, ctl, ctl,     {   BS,  HT,  LF,  VT,  FF,  CR,  SO,  SI  }
            1  805        { 020 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  DLE, DC1, DC2, DC3, DC4, NAK, SYN, ETB  }
            1  806        { 030 } ctl, ctl, ctl, ctl, ctl, ctl, ctl, ctl,     {  CAN,  EM, SUB, ESC,  FS,  GS,  RS,  US  }
            1  807        { 040 } spc, oor, quo, dif, let, let, oan, quo,     {  ' ', '!', '"', '#', '$', '%', '&', "'"  }
            1  808        { 050 } lpa, rpa, omu, oad, scm, osu, spe, odi,     {  '(', ')', '*', '+', ',', '-', '.', '/'  }
            1  809        { 060 } dig, dig, dig, dig, dig, dig, dig, dig,     {  '0', '1', '2', '3', '4', '5', '6', '7'  }
            1  810        { 070 } dig, dig, s2p, ssc, olt, oeq, ogt, oth,     {  '8', '9', ':', ';', '<', '=', '>', '?'  }
            1  811        { 100 } let, let, let, let, let, let, let, let,     {  '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G'  }
            1  812        { 110 } let, let, let, let, let, let, let, let,     {  'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O'  }
            1  813        { 120 } let, let, let, let, let, let, let, let,     {  'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W'  }
            1  814        { 130 } let, let, let, lbr, sas, rbr, opw, let,     {  'X', 'Y', 'Z', '[', '\', ']', '^', '_'  }
            1  815        { 140 } oth, let, let, let, let, let, let, let,     {  '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g'  }
            1  816        { 150 } let, let, let, let, let, let, let, let,     {  'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o'  }
            1  817        { 160 } let, let, let, let, let, let, let, let,     {  'p', 'q', 'r', 's', 't', 'u', 'v', 'w'  }
            1  818        { 170 } let, let, let, lac, oor, rac, oth, ctl      (* 'x', 'y', 'z', '{', '|', '}', '~', DEL *)
            1  819      ];
       C    1  820  
            1  821      C_EOS = CHR( 0 );
            1  822      C_EOL = CHR( 1 );
       C    1  823  
       C    1  824  
            1  825    [static]
            1  826    var
            1  827      quote,
            1  828      inp_cm,
            1  829      inp_ch:   char :=    C_EOL;
            1  830      ch_knd: ch_type   :=   eol;
            1  831      iv, id, nd, sz:    integer;
            1  832      rd, rf, rv:         double;
            1  833      bok, bnc:  boolean := true;
       C    1  834  
            1  835      procedure NEXTCH;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  17
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "PRC_00000000".

       C    1  836      {Procedure to get One character from the input stream }
            1  837      const
            1  838        in_major = ORD( 'A' ) - ORD( 'a' );
       C    1  839  
            1  840      begin
     1      1  841        if EOF( inp ) then
            1  842        begin
     2      1  843          inp_ch := C_EOS;
            1  844          sy_cline.length := sy_nchar;
            1  845          sy_nline := sy_nline + 1
     1      1  846        end
            1  847        else
            1  848        if EOLN( inp ) then
            1  849        begin
     2      1  850          GET( inp ); inp_ch := C_EOL;
            1  851          sy_nline := sy_nline + 1;
            1  852          sy_cline.length := sy_nchar;
            1  853          sy_nchar := 0
     1      1  854        end
            1  855        else
            1  856        begin
     2      1  857          inp_ch := inp^; GET( inp );
            1  858          if inp_ch <= ' ' then inp_ch := ' ';
            1  859          sy_nchar := sy_nchar + 1; sy_cline[sy_nchar] := inp_ch
     1      1  860        end;
            1  861        if (inp_ch >= 'A') and (inp_ch <= 'Z') then
            1  862          inp_cm := CHR( ORD( inp_ch ) - in_major )
            1  863        else
            1  864          inp_cm := inp_ch;
            1  865        ch_knd := ch_tab[inp_cm]
       C    1  866  (*
       C    1  867  ;WRITELN( ' NEXTCH : ch = ', ORD( inp_ch ), ' ', inp_ch, ' ', ch_knd );
       C    1  868  *)
     0      1  869      end NEXTCH;
       C    1  870  
       C    1  871  
            1  872    begin { INSYMBOL }
     1      1  873      while ch_knd = spc do NEXTCH;               { Skip any space character }
            1  874      repeat
     2      1  875        bnc := true;
            1  876        bok := true;
            1  877        case ch_knd of
            1  878          dif: { "#" Other mark of end of line comment }
            1  879            begin
     3      1  880              while (ch_knd <> eos) and (ch_knd <> eol) do NEXTCH;
            1  881              bok := false; bnc := true           { The next syntax unit (EOLN or EOF) is already readden }
     2      1  882            end;
       C    1  883  
            1  884          quo: { String }
            1  885            begin
     3      1  886              sz := 0;                            { Clear the string variable }
            1  887              quote := inp_ch;                    { Keep the memory of quote character }
            1  888              repeat
     4      1  889                NEXTCH;
            1  890              exit if ch_knd = eos;               { Stop on end of file }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  18
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "PRC_00000000".

            1  891                if ch_knd = eol then NEXTCH;      { Ignore any eoln }
            1  892                if inp_ch = quote then            { On a Quote character }
            1  893                begin
     5      1  894                  NEXTCH;                         { Get the next one }
       C    1  895                  { Double quote => Insert one quote in string }
            1  896              exit if inp_ch <> quote;            { Unique Quote => End of String }
     4      1  897                end;
            1  898                if sz < sy_str.capacity then sz := sz + 1; { Check for string overflow }
            1  899                sy_str[sz] := inp_ch              { Put the character in the string }
     3      1  900              until false;
            1  901              sy_str.length := sz;
            1  902              sy := sy_string;                    { We have found a string }
            1  903              bnc := false                        { The next character is already readden }
     2      1  904            end;
       C    1  905  
            1  906          let: { Alpha character => Identifier }
            1  907           begin
     3      1  908              sz := 0;                            { Clear the current identifier name }
            1  909              repeat
     4      1  910                if sz < sy_ide.capacity then      { Check for string overflow }
            1  911                if sz < sy_ide.capacity then sz := sz + 1;
            1  912                sy_ide[sz] := inp_ch;
            1  913                NEXTCH;                           { Get the next character }
     3      1  914              until (ch_knd <> let) and (ch_knd <> dig);
            1  915              sy_ide.length := sz;
            1  916              sy := sy_ident;
            1  917              bnc := false;                       { The next character is already got }
     2      1  918            end;
       C    1  919  
            1  920          dig, spe: { Figures character => Numeric value }
            1  921            begin
     3      1  922              rv := 0.0; rf := 1.0; nd := 0;
            1  923              sy := sy_integer;                   { Assume to be an integer }
            1  924              while ch_knd = dig do
            1  925              begin
     4      1  926                id := ORD( inp_ch ) - ORD( '0' ); { Get the figure value }
            1  927                if id = 0 then nd := nd + 1       { Count of zero at left of decimal period }
            1  928                          else nd := 0;           { ... to allow to use the integer exponentiel form }
            1  929                rv := rv*10.0 + id;               { Form the integer part of the number }
            1  930                NEXTCH                            { Get the next character }
     3      1  931              end;
            1  932              if ch_knd = spe then
            1  933              begin
     4      1  934                nd := 0;                          { Eliminate the integer kind of number }
            1  935                NEXTCH;
            1  936                sy := sy_float;                   { Set to be a floatting number }
            1  937                while ch_knd = dig do
            1  938                begin
     5      1  939                  id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
            1  940                  rf := rf*0.1;
            1  941                  rv := rv + id*rf;               { Form the decimal part of the number }
            1  942                  NEXTCH                          { Get the next character }
     4      1  943                end
     3      1  944              end;
            1  945              if inp_cm = 'e' then
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  19
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "PRC_00000000".

            1  946              begin
     4      1  947                NEXTCH;                           { Gobble up the Exponant character }
            1  948                iv := 0;                          { Prepare the exponant read }
            1  949                rd := 10.0;
            1  950                if (inp_ch = '+') or (inp_ch = '-') then
            1  951                begin                             { Manage the exponant signe }
     5      1  952                  if inp_ch = '-' then rd := 0.1;
            1  953                  NEXTCH
     4      1  954                end;
            1  955                while ch_knd = dig do
            1  956                begin
     5      1  957                  id := ORD( inp_ch )-ORD( '0' ); { Get the figure value }
            1  958                  iv := iv*10 + id;               { Form the exponant value }
            1  959                  NEXTCH                          { Get the next character }
     4      1  960                end;
            1  961                rf := 1.0;
            1  962                while iv <> 0 do                  { Form rf = rd**iv }
            1  963                  if ODD( iv ) then
            1  964                  begin  iv := iv - 1; rf := rf*rd  end
            1  965                  else
            1  966                  begin  iv := iv div 2; rd := SQR( rd )  end;
       C    1  967  
       C    1  968                { Set as impossible value for integer when exponent is < -nd }
            1  969                if nd - iv < 0 then sy := sy_float;
            1  970                rv := rv*rf                       { Finish to form the Real Number }
     3      1  971              end;
       C    1  972              { Set the integer value when it is possible }
            1  973              if (rv <= double( integer"last )) and
            1  974                 (rv >= double( integer"first )) then sy_int := ROUND( rv )
            1  975              else begin  iv := 0; sy := sy_float  end;
            1  976              sy_flt := rv; sy_int := iv;
            1  977              bnc := false                        { The next character is already got }
     2      1  978            end;
       C    1  979  
            1  980          oeq: sy := sy_equal;
       C    1  981  
       C    1  982  
            1  983          lbr: sy := sy_lbra;
            1  984          rbr: sy := sy_rbra;
            1  985          lpa: sy := sy_lpar;
            1  986          rpa: sy := sy_rpar;
            1  987          scm: sy := sy_comma;
            1  988          s2p: sy := sy_colon;
            1  989          ssc: sy := sy_semicolon;
       C    1  990  
            1  991          eol:
            1  992            begin
     3      1  993              NEXTCH;
            1  994              if sy_noeol then bok := false
            1  995                          else sy := sy_eoln;
     2      1  996            end;
       C    1  997  
            1  998          eos: sy := sy_eof;
       C    1  999  
            1 1000          spc: begin  bok := false; NEXTCH  end;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  20
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "PRC_00000000".

       C    1 1001  
            1 1002        otherwise
       C    1 1003          { oor, oan, oad, osu, omu, odi, opw (operators characters) are not supported }
     3      1 1004          sy := sy_illegal
     2      1 1005        end
     1      1 1006      until bok or (ch_knd = eos);
            1 1007      if cmp_verblvl > 2 then
            1 1008      begin
     2      1 1009        WRITE( '    * INSYMBOL Read ', sy );
            1 1010        case sy of
            1 1011          sy_ident:   WRITE( ' (', sy_ide.length:0, ') "', sy_ide, '"' );
            1 1012          sy_string:  WRITE( ' (', sy_str.length:0, ') "', sy_str, '"' );
            1 1013          sy_integer: WRITE( ' = ', sy_int:0 );
            1 1014          sy_float:   WRITE( ' = ', sy_flt:12:7 );
            1 1015        otherwise
            1 1016        end;
            1 1017        WRITELN
     1      1 1018      end;
            1 1019      if bnc then NEXTCH
     0      1 1020    end INSYMBOL;
       C    1 1021  
       C    1 1022  
            1 1023    procedure SKIP_SYMBOL( stp: sym_set := [] );
            1 1024    begin
     1      1 1025      while (not (sy in stp)) and (sy <> sy_eof) do INSYMBOL
     0      1 1026    end SKIP_SYMBOL;
       C    1 1027  
       C    1 1028  
       C    1 1029  
            1 1030    procedure SETUP_ERROR( mdnam: string; nerr: integer; skp: sym_set := [] );
            1 1031    var
            1 1032      ip: integer;
            1 1033      msg: string( 92 ) := 'Undefined syntax error.';
       C    1 1034  
            1 1035    begin
     1      1 1036      ip := sy_nchar;                                     { Keep the Read index in the current line }
            1 1037      WRITELN;
            1 1038      WRITELN( ' *** CPAS-Dispatcher Setup File Syntax Error : ', mdnam, ' # ', nerr:0 );
            1 1039      WRITELN( ' Line # ', sy_nline:3, '  ', sy_cline );
            1 1040      WRITELN( ' ':ip+11, '^' );
            1 1041      case nerr of
            1 1042         1: msg := 'An identifer was expected';
            1 1043         2: msg := 'Unknown identifier';
            1 1044         3: msg := 'A string value was expected';
            1 1045         4: msg := 'An integer value was expected';
            1 1046         6: msg := 'A left parenthesys "(" was expected';
            1 1047         7: msg := 'A left braket "[" was expected';
            1 1048         8: msg := 'A right parenthesys ")" was expected';
            1 1049         9: msg := 'A right braket "]" was expected';
            1 1050        10: msg := '"=" was expected';
            1 1051        11: msg := '"," was expected';
            1 1052        12: msg := '":" was expected';
            1 1053        13: msg := '";" was expected';
            1 1054        14: msg := '"," or ";" was expected';
            1 1055        15: msg := '"," or ")" was expected';
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  21
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "PRC_00000003".

            1 1056        16: msg := '":" or ")" was expected';
            1 1057        17: msg := '":", "," or ")" was expected';
            1 1058        21: msg := 'Unknown format specifier for variable field (known %s, %i, %f, %e or %stl)';
            1 1059        22: msg := ' Element of enum (%e) is not a string or identifier';
            1 1060        otherwise
     2      1 1061          msg := ' Undefined error.'
     1      1 1062      end;
            1 1063      WRITELN( ' *** ', msg, '. ***' );
            1 1064      if not (sy_no_skip in skp) then SKIP_SYMBOL( skp );
            1 1065      exit_flg := true;
            1 1066      PASCAL_EXIT( 2 )
     0      1 1067    end SETUP_ERROR;
       C    1 1068  
       C    1 1069  
            1 1070  begin { READ_SETUP_FILE }
     1      1 1071    if (argc > 1) and (SUBSTR( argv[1]^, 1, 5 ) = '-verb') then
            1 1072    with argv[1]^ do
            1 1073    begin
     2      1 1074      cmp_verbose := true;
            1 1075      if length > 5 then
            1 1076      case body[6] of
            1 1077        '1', '2', '3':
            1 1078            cmp_verblvl := ORD( body[6] ) - ORD( '0' );
            1 1079        '+':
            1 1080            cmp_verblvl := 3;
            1 1081      otherwise
            1 1082      end
     1      1 1083    end;
       C    1 1084  
            1 1085    if cmp_verbose then WRITELN( ' Read Setup file "', setup_fspc, '"' );
       C    1 1086  
            1 1087    OPEN( inp, setup_fspc, [read_file, error_file] );     { Open the setup file (with error tolerance) }
            1 1088    if iostatus = 0 then
            1 1089    begin { OK to read the setup file }
     2      1 1090      if cmp_verblvl > 2 then WRITELN( ' * The setup File is opened. *' );
            1 1091      sy := sy_eoln;
            1 1092      INSYMBOL;
            1 1093      while sy <> sy_eof do                                               { Loop to read all the setup file }
            1 1094      begin
     3      1 1095        if sy <> sy_ident then SETUP_ERROR( mdnam, 1, [sy_semicolon] );   { An identifier was expected }
            1 1096      exit if sy_ide = 'End';
            1 1097        for cmopt := mopt_type"first to mopt_type"last do                 { Loop to find the identifier in the set
                    up possible identifiers }
            1 1098          if setup_tab[cmopt].moptf_name = sy_ide then                    { When the identifier is find ... }
            1 1099          begin  mopt := cmopt; fnd := true; exit  end;
       C    1 1100  
            1 1101        if not fnd then SETUP_ERROR( mdnam, 2, [sy_semicolon] );          { If the identifier is not found => ERRO
                    R }
            1 1102        with setup_tab[mopt] do
            1 1103        begin
     4      1 1104          INSYMBOL;
            1 1105          if sy <> sy_equal then SETUP_ERROR( mdnam, 2, [sy_no_skip] )    { An "=" operator was expected }
            1 1106                            else INSYMBOL;                                { Get the suffix string }
            1 1107          if sy <> sy_string then SETUP_ERROR( mdnam, 3, [sy_no_skip] );  { Not a string ERRROR }
            1 1108          moptf_prefix := sy_str;                                         { Load the prefix string }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  22
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "read_setup_file".

            1 1109          INSYMBOL;
            1 1110          if moptf_type = moptf_fst then
            1 1111          begin
       C    1 1112            { For only one local option code }
       C    1 1113            { Set the flag to automaticaly specify the stdl_path by a mopt_ldir option }
     5      1 1114            if (moptf_prefix[1] = 'Y') or (moptf_prefix[1] = 'y') then cmp_stdlib_path := true
     4      1 1115          end
            1 1116          else
            1 1117          begin { Option that can be tranmitted to the children process }
     5      1 1118            if sy = sy_comma then                           { When some other field are specified ... }
            1 1119            begin
     6      1 1120              INSYMBOL;                                     { Gobble up the comma }
            1 1121              if sy = sy_ident then
            1 1122              begin { When a format was specified, not allowed for dispatcher insternal specification }
     7      1 1123                if sy_ide =   '%s' then   moptf_type := moptf_str
            1 1124                else
            1 1125                if sy_ide =   '%i' then   moptf_type := moptf_int
            1 1126                else
            1 1127                if sy_ide =   '%e' then   moptf_type := moptf_enm
            1 1128                else
            1 1129                if sy_ide = '%stl' then   moptf_type := moptf_stl
            1 1130                else SETUP_ERROR( mdnam, 21, [sy_semicolon] );
            1 1131                INSYMBOL;
            1 1132                case moptf_type of
            1 1133                  moptf_enm:
            1 1134                    begin { Get the various literal value of enum }
     8      1 1135                      if sy <> sy_colon then SETUP_ERROR( mdnam, 16, [sy_no_skip] );
            1 1136                      INSYMBOL;
            1 1137                      if sy <> sy_lpar then SETUP_ERROR( mdnam, 6, [sy_no_skip] );
            1 1138                      sy := sy_comma;
            1 1139                      while sy = sy_comma do
            1 1140                      begin
     9      1 1141                        INSYMBOL;                                     { Gobble up "(" or "," }
            1 1142                        case sy of
            1 1143                          sy_ident:  begin  NEW( pide, sy_ide.length ); pide^.sarg := sy_ide  end;
            1 1144                          sy_string: begin  NEW( pide, sy_str.length ); pide^.sarg := sy_str  end;
            1 1145                        otherwise
    10      1 1146                          SETUP_ERROR( mdnam, 22 )                    { The field must be an identifier }
     9      1 1147                        end;
            1 1148                        pide^.next := nil;
            1 1149                        if moptf_ennum = nil then moptf_ennum := pide { ... and Queue it in the enum list }
            1 1150                                             else plast^.next := pide;{ N.B.: the list must be empty  befor }
            1 1151                        plast := pide;
            1 1152                        INSYMBOL                                      { Gobble the literal identifier }
     8      1 1153                      end;
            1 1154                      if sy <> sy_rpar then SETUP_ERROR( mdnam, 8, [sy_no_skip] )
            1 1155                                       else INSYMBOL                  { Gobble ")" }
     7      1 1156                    end; { End of get enum literals }
       C    1 1157  
            1 1158                  moptf_stl:
            1 1159                    begin
     8      1 1160                      if sy <> sy_colon then SETUP_ERROR( mdnam, 16, [sy_no_skip] )
            1 1161                                        else INSYMBOL;
            1 1162                      if sy <> sy_lpar then SETUP_ERROR( mdnam, 6, [sy_no_skip] );
            1 1163                      sy := sy_comma;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  23
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "read_setup_file".

            1 1164                      repeat
     9      1 1165                        INSYMBOL; { Gobble up "," or initial "(" and read the system name. }
            1 1166                        if sy <> sy_string then SETUP_ERROR( mdnam, 3, [sy_comma,sy_semicolon] );
            1 1167                        NEW( p1 );                                        { Create the option node for this system
                     and ... }
            1 1168                        if sys_o_last = nil then sys_o_first := p1        { ... set the option node links. }
            1 1169                                            else sys_o_last^.sys_next := p1;
            1 1170                        sys_o_last := p1;
            1 1171                        with p1^ do
            1 1172                        begin { Now, we fill the option node }
    10      1 1173                          sys_next    :=     nil;
            1 1174                          sys_nam     :=  sy_str;
            1 1175                          for i := 1 to 4 do sys_opt[i] := nil;           { Initialize each of the four options fi
                    elds ... }
            1 1176                          INSYMBOL;                                       { Gobble up the system name. We must get
                     a colon. }
            1 1177                          if not (sy in [sy_colon,sy_comma,sy_rpar]) then SETUP_ERROR( mdnam, 17, [sy_no_skip] );
            1 1178                          cop := 1;
            1 1179                          while (cop < 5) and (sy = sy_colon) do
            1 1180                          begin
    11      1 1181                            INSYMBOL;                                     { Goggle up the colon and read the optio
                    n string, colon or comma  }
            1 1182                            if sy = sy_string then
            1 1183                            begin
    12      1 1184                              if sy_str.length > 0 then                   { When a string was find, we store it in
                     the option array element # cop. }
            1 1185                              begin
    13      1 1186                                NEW( sop, sy_str.length );
            1 1187                                sop^ := sy_str;
            1 1188                                sys_opt[cop] := sop
    12      1 1189                              end;
            1 1190                              INSYMBOL                                    { Read the expected separator: colon, co
                    mma or right parenthesys }
    11      1 1191                            end;
            1 1192                            cop := cop + 1                                { increment the option index }
    10      1 1193                          end;
            1 1194                          if not (sy in [sy_rpar,sy_comma]) then
            1 1195                              SETUP_ERROR( mdnam, 14, [sy_rpar,sy_comma,sy_semicolon] )
     9      1 1196                        end
     8      1 1197                      until sy in [sy_rpar,sy_semicolon];
            1 1198                      if sy <> sy_rpar then SETUP_ERROR( mdnam, 8, [sy_no_skip] )
            1 1199                                       else INSYMBOL;
            1 1200                      if sy <> sy_semicolon then SETUP_ERROR( mdnam, 13, [sy_semicolon] );
            1 1201                      if cmp_verblvl > 2 then
            1 1202                      begin
     9      1 1203                        WRITELN( ' List of C compiler options when the -sysc cpas option is set :' );
            1 1204                        p1 := sys_o_first;
            1 1205                        while p1 <> nil do
            1 1206                        with p1^ do
            1 1207                        begin
    10      1 1208                          WRITE( "\t", sys_nam:30, ' ' );
            1 1209                          for i := 1 to 4 do
            1 1210                          begin
    11      1 1211                            WRITE( ':' );
            1 1212                            sop := sys_opt[i];
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  24
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "read_setup_file".

            1 1213                            if sop <> nil then WRITE( '"', sop^, '"' )
            1 1214                                          else WRITE( '<empty>' )
    10      1 1215                          end;
            1 1216                          WRITELN;
            1 1217                          p1 := sys_next
     9      1 1218                        end;
            1 1219                        WRITELN
     8      1 1220                      end
     7      1 1221                    end;
       C    1 1222  
            1 1223                otherwise
     8      1 1224                  moptf_ennum := nil
     7      1 1225                end { case moptf_type of }
     6      1 1226              end { End of Variable part of option descriptor }
            1 1227              else moptf_type := moptf_nul
     5      1 1228            end;
            1 1229            if sy = sy_comma then
            1 1230            begin
     6      1 1231              INSYMBOL;                                     { Gobble "," }
            1 1232              if sy <> sy_string then SETUP_ERROR( mdnam, 3 );
            1 1233              moptf_suffix := sy_str;
            1 1234              INSYMBOL                                      { Gobble up the suffix }
     5      1 1235            end
     4      1 1236          end;
            1 1237          if sy <> sy_semicolon then SETUP_ERROR( mdnam, 12 );
            1 1238          INSYMBOL;                                       { Gobble up ";" }
            1 1239          if cmp_verblvl > 1 then
            1 1240          begin
     5      1 1241            WRITE( '    Setup ', moptf_name:16, ' = ''', moptf_prefix, ''', ', moptf_type );
            1 1242            if moptf_ennum <> nil then
            1 1243            begin
     6      1 1244              WRITE( ':(' );
            1 1245              pide := moptf_ennum;
            1 1246              while pide <> nil do
            1 1247                with pide^ do
            1 1248                begin
     7      1 1249                  if pide <> moptf_ennum then WRITE( ',' );
            1 1250                  WRITE( sarg );
            1 1251                  pide := next
     6      1 1252                end;
            1 1253              WRITE( ')' )
     5      1 1254            end;
            1 1255            WRITELN( ', ''', moptf_suffix, ''';' )
     4      1 1256          end;
            1 1257          case mopt of
            1 1258            mopt_cpas: cpas_name := moptf_prefix;
            1 1259            mopt_ccmp: ccmp_name := moptf_prefix;
            1 1260          otherwise
            1 1261          end
     3      1 1262        end
     2      1 1263      end { while sy <> sy_eof do };
            1 1264      CLOSE( inp )        { Close the setup file }
     1      1 1265    end
            1 1266    else
            1 1267    begin { Cannot open the setup file }
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  25
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "read_setup_file".

     2      1 1268      WRITELN( ' *** CPAS-DISPATCHER Error: Cannot open the Setup file "', setup_fspc,
            1 1269               '" for input with err # ', iostatus:0, '. ***' );
            1 1270      exit_flg := true
     1      1 1271    end;
            1 1272  if cmp_system then WRITELN( ' *** Option -sysc is SET.' );
            1 1273    if exit_flg then PASCAL_EXIT( 2 )
     0      1 1274  end READ_SETUP_FILE;
       C    1 1275  
       C    1 1276  
       C    1 1277  
            1 1278  function  SYSTEM_SEARCH( in_var sys: string ): sysopt_ptr;
            1 1279  var
            1 1280    p: sysopt_ptr;
       C    1 1281  
            1 1282  begin
     1      1 1283    p := sys_o_first;
            1 1284    while p <> nil do
            1 1285    with p^ do
            1 1286    begin
     2      1 1287      exit if sys_nam = sys;
            1 1288      p := sys_next
     1      1 1289    end;
            1 1290    SYSTEM_SEARCH := p
     0      1 1291  end SYSTEM_SEARCH;
       C    1 1292  
       C    1 1293  
       C    1 1294  
            1 1295  procedure SET_SYSTEM_OPTION( var cmd: string; opt: arg_tsk );
       C    1 1296  { Routine to insert/append the system options when required }
       C    1 1297  { The command line cmd is assumed already written with the compiler task name (minimum) }
            1 1298  var
            1 1299    sysnam :  str_ptr   :=    nil;
            1 1300    pent:              sysopt_ptr;
       C    1 1301  
            1 1302  begin
     1      1 1303    sysnam := current_system"address;
            1 1304    if trg_sys_name.length > 0 then
            1 1305      if trg_sys_name <> current_system then sysnam := trg_sys_name"address;
            1 1306    pent := SYSTEM_SEARCH( sysnam^ );
            1 1307    if pent <> nil then
            1 1308      with pent^ do
            1 1309        case opt of
            1 1310          tsk_cpas_cmp:
            1 1311            begin
     2      1 1312              WRITEV( cmd:false, ' ', sys_opt[1]^ );
     1      1 1313            end;
       C    1 1314  
            1 1315          tsk_cc_cmp:
            1 1316            begin
     2      1 1317              WRITEV( cmd:false, ' ', sys_opt[2]^ );
     1      1 1318            end;
       C    1 1319  
            1 1320        otherwise
     2      1 1321          ;
     1      1 1322        end;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  26
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cpas_dispatcher".

     0      1 1323  end SET_SYSTEM_OPTION;
       C    1 1324  
       C    1 1325  
       C    1 1326  
            1 1327  function RUN_COMPILER( in_var tsk, cmd: string ): boolean;
            1 1328  var
            1 1329    ipro, iusr, stat:    integer;
            1 1330    emsg:           string := '';
            1 1331    bok:                 boolean;
       C    1 1332  
            1 1333  begin
     1      1 1334    if cmp_verbose then
            1 1335    begin
     2      1 1336      if cmp_simul then WRITE( ' NOEXEC "' )
            1 1337                   else WRITE( ' EXEC "' );
            1 1338      WRITELN( tsk, '" commande "', cmd, '".' )
     1      1 1339    end;
            1 1340    bok := false;
            1 1341    if not cmp_simul then
            1 1342    begin
     2      1 1343      ipro := CREATE_PROCESS( tsk, cmd );
            1 1344      if ipro > 0 then
            1 1345      begin
     3      1 1346        iusr := WAIT_PROCESS( stat, ipro );
            1 1347        if stat <> 0 then WRITEV( emsg, 'Create_Process "', tsk, '" Error # ', stat:0, ' => Stop.' )
            1 1348                     else bok := true
     2      1 1349      end
            1 1350      else
            1 1351        WRITEV( emsg, 'Process "', tsk, '" signal an Error # ', ipro:0, ' => Stop.' );
            1 1352      if not bok then WRITELN( ' CPAS-DISPATCHER: ** ', emsg );
            1 1353      if bok and cmp_verbose then
            1 1354      begin
     3      1 1355        WRITELN( ' EXEC "', tsk, '" resulting status = ', stat:0 )
     2      1 1356      end
     1      1 1357    end
            1 1358    else bok := true;
            1 1359    RUN_COMPILER := bok
     0      1 1360  end RUN_COMPILER;
       C    1 1361  
       C    1 1362  
       C    1 1363  
       C    1 1364  
            1 1365  procedure PAS_SOURCES_MANAGER;
            1 1366  var
            1 1367    cmd:           string( 255 );
            1 1368    iext, ip, lensv:     integer;
            1 1369    carg:                arg_ptr;
            1 1370    pmc:                 mac_ptr;
            1 1371    bok:                 boolean;
       C    1 1372  
            1 1373  begin
     1      1 1374    if cmp_verblvl > 2 then
            1 1375    begin
     2      1 1376      carg := pas_arg_list;
            1 1377      ip := 1;
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  27
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "pas_sources_manager".

            1 1378      WRITELN;
            1 1379      WRITELN( '    *** CPAS Argument list ***' );
            1 1380      while carg <> nil do
            1 1381      with carg^ do
            1 1382      begin
     3      1 1383        WRITELN( ' ', ip:3, '/  "', sarg, '"' );
            1 1384        ip := ip + 1;
            1 1385        carg := next
     2      1 1386      end;
            1 1387      WRITELN
     1      1 1388    end;
       C    1 1389  
            1 1390    WRITEV( cmd, cpas_name );
            1 1391    if cmp_xcross and (trg_sys_name.length > 0) then WRITEV( cmd:false, ' -x', trg_sys_name );
            1 1392    if cmp_traceopt >= 0 then WRITEV( cmd:false, ' -t', cmp_traceopt:0 );
            1 1393    if cmp_optspc then WRITEV( cmd:false, ' -O', cmp_optlvl:0 );
            1 1394    pmc := mac_arg_first;
            1 1395    while pmc <> nil do
            1 1396    begin
     2      1 1397      WRITEV( cmd:false, ' ', pmc^.mac_args );
            1 1398      pmc := pmc^.mac_next
     1      1 1399    end;
            1 1400    if cmp_range then WRITEV( cmd:false, ' -r' );
            1 1401    if cmp_rsfchk then WRITEV( cmd:false, ' -f' );
       C    1 1402  (* Until Debug support is OK.
       C    1 1403    if cmp_debugopt then  WRITEV( cmd:false, ' -d' );
       C    1 1404  *)
            1 1405    if cmp_macf then WRITEV( cmd:false, ' -c' );
            1 1406    if cmp_listlvl > 0 then WRITEV( cmd:false, ' -l', cmp_listlvl:0 );
            1 1407    lensv := cmd.length;
            1 1408    carg := pas_arg_list;
            1 1409    bok := true;
            1 1410    while bok and (carg <> nil) do
            1 1411    with carg^ do
            1 1412    begin
     2      1 1413      if sarg.length > 0 then
            1 1414      begin
     3      1 1415        if not FILE_ACCESS_CHECK( sarg, 4 ) then
            1 1416        begin
     4      1 1417          WRITELN( ' CPAS-Dispatcher Error :  Cannot open or find the Pascal source file "', sarg.length:0, ':',sa
                    rg, '" => stop.' );
            1 1418          PASCAL_EXIT( 2 )
     3      1 1419        end;
            1 1420        cmd.length := lensv;
            1 1421        WRITEV( cmd:false, ' ', sarg );
            1 1422        LOCATE_EXTENSION( sarg, iext, ip );
            1 1423        WRITEV( cmd:false, ' -f ', cdir_fspc, SUBSTR( sarg, ip+1, iext-ip-1 ), '.c' );
            1 1424        if cmp_listlvl > 0 then WRITEV( cmd:false, ' -fl ', sarg:iext-1 );
            1 1425        bok := RUN_COMPILER( cpas_name, cmd )
     2      1 1426      end;
            1 1427      cmd.length := lensv;
            1 1428      carg := next
     1      1 1429    end;
            1 1430    if not bok and not cmp_simul then
            1 1431    begin
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  28
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "pas_sources_manager".

     2      1 1432      WRITELN( ' PASCAL COMPILATION: Stop on Error.' );
            1 1433      PASCAL_EXIT( 2 )
     1      1 1434    end
     0      1 1435  end PAS_SOURCES_MANAGER;
       C    1 1436  
       C    1 1437  
       C    1 1438  
            1 1439  procedure CC_SOURCES_MANAGER;
            1 1440  var
            1 1441    cmd:           string( 255 );
            1 1442    carg:                arg_ptr;
            1 1443    ip:                  integer;
            1 1444    bok:                 boolean;
       C    1 1445  
            1 1446  begin
     1      1 1447    if cmp_verblvl > 2 then
            1 1448    begin
     2      1 1449      carg := cc__arg_list;
            1 1450      ip := 1;
            1 1451      WRITELN;
            1 1452      WRITELN( '    *** CC Argument list ***' );
            1 1453      while carg <> nil do
            1 1454      with carg^ do
            1 1455      begin
     3      1 1456        WRITELN( ' ', ip:3, '/  "', sarg, '"' );
            1 1457        ip := ip + 1;
            1 1458        carg := next
     2      1 1459      end;
            1 1460      WRITELN
     1      1 1461    end;
       C    1 1462  
            1 1463    WRITEV( cmd, ccmp_name );
       C    1 1464  
       C    1 1465    { Put the system compilation option when required. }
            1 1466    if cmp_system then SET_SYSTEM_OPTION( cmd, tsk_cc_cmp );
       C    1 1467  
            1 1468    carg := cc__arg_list;
            1 1469    while carg <> nil do
            1 1470    with carg^ do
            1 1471    begin
     2      1 1472      if sarg.length > 1 then
            1 1473        if sarg[1] = '-' then
            1 1474          WRITEV( cmd:false, ' ', sarg )
            1 1475        else
            1 1476        begin
     3      1 1477          if not FILE_ACCESS_CHECK( sarg, 4 ) then
            1 1478          begin
     4      1 1479            WRITELN( ' CPAS-Dispatcher Error :  Cannot open the C source file "', sarg, '" => stop.' );
            1 1480            PASCAL_EXIT( 2 )
     3      1 1481          end;
            1 1482          WRITEV( cmd:false, ' ', sarg )
     2      1 1483        end;
            1 1484      carg := next
     1      1 1485    end;
       C    1 1486  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  29
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cc_sources_manager".

            1 1487    if main_name.length > 0 then WRITEV( cmd:false, ' -o ', main_name );
       C    1 1488  
            1 1489    bok := RUN_COMPILER( ccmp_name, cmd );
       C    1 1490  
       C    1 1491  (*  WRITEV( cmd:false, ' ', scc ); *)
       C    1 1492  
       C    1 1493  
            1 1494    if not bok and not cmp_simul then
            1 1495    begin
     2      1 1496      WRITELN( ' C COMPILATION: Stop on Error.' );
            1 1497      PASCAL_EXIT( 2 )
     1      1 1498    end
            1 1499    else if not cmp_keepc then
            1 1500    begin { We leave all intermediary C files on error }
     2      1 1501      carg := cc__arg_list;
            1 1502      while carg <> nil do
            1 1503      with carg^ do
            1 1504      begin
     3      1 1505        if frem then
            1 1506        begin
     4      1 1507          if cmp_verbose then
            1 1508          begin
     5      1 1509            if cmp_simul then WRITE( ' NOEXEC ' )
            1 1510                         else WRITE( ' EXEC ' );
            1 1511            WRITELN( ' Delete the temporary file ', sarg, '".' )
     4      1 1512          end;
            1 1513          if not cmp_simul then
            1 1514            if not FILE_REMOVE( sarg ) then
            1 1515              WRITELN( ' CPAS-DISPATCHER/Warning: The temporary file "', sarg, '" cannot be deleted.' )
            1 1516            else
            1 1517              begin  if cmp_verbose then WRITELN( ' The temporary file "', sarg, '" is deleted.' )  end
            1 1518          else
            1 1519            WRITELN( ' Temporary file "', sarg, ' should be deleted.' )
     3      1 1520        end;
            1 1521        carg := next
     2      1 1522      end
     1      1 1523    end
     0      1 1524  end CC_SOURCES_MANAGER;
       C    1 1525  
       C    1 1526  
       C    1 1527  
            1 1528  begin { Main: CPAS_DISPATCHER }
     1      1 1529    SETUP_PATH_SEARCH;                    { Locate the CPAS-DISPATCHER setup file }
            1 1530    READ_SETUP_FILE;                      { Read the setup to define all the C and CPAS usefull options and exec f
                    iles }
       C    1 1531  (* cmp_system
       C    1 1532  for copt := mopt_cpas to mopt_debs do
       C    1 1533  with setup_tab[copt] do
       C    1 1534  begin
       C    1 1535  WRITELN( ' From setup_tab : ', copt, '/ [ "', moptf_name, '", "', moptf_prefix, '", ', moptf_type, ', "', moptf_
                    suffix, '" ]' );
       C    1 1536  end;
       C    1 1537  *)
            1 1538    SET_OPTIONS_AND_PARM;                 { Analyse the CPAS command with these various arguments }
       C    1 1539  
  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022  - Run the 20-MAY-2024 at 08:15:24    Page  30
 The Current Source File is "/run/media/pierre/SSD_Save-2/Soft_News/cpsh_kits/cpascal_src_V3.1B5-2/cpas-dispatcher.pas".

 The Current Compiled Module is "cpas_dispatcher".

            1 1540    PAS_SOURCES_MANAGER;                  { Perform all calls to CPAS Compiler }
       C    1 1541  
            1 1542    if not cmp_noccmp then CC_SOURCES_MANAGER;    { Perform the call of C Compiler }
       C    1 1543  
     0      1 1544  end CPAS_DISPATCHER.
            1 1545  
