/*  P A S - P. WOLFERS SOFTWARE: V3.1-B5 OF 31-JAN-2022 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long int

/* Include the PAS environment file. */
#include <cpas_defs.h>

/* Define the local data section. */
static Blk( Rd, 200 ) = {{
  7,   7, 101, 114, 114,  95, 104, 100, 108,  77,  77,  47, 114, 117, 110,  47,
109, 101, 100, 105,  97,  47, 112, 105, 101, 114, 114, 101,  47,  83,  83,  68,
 95,  83,  97, 118, 101,  45,  50,  47,  83, 111, 102, 116,  95,  78, 101, 119,
115,  47,  99, 112, 115, 104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,
 99,  97, 108,  95, 115, 114,  99,  95,  86,  51,  46,  49,  66,  53,  45,  50,
 47, 101, 115,  48,  46, 112,  97, 115,  11,  11,  76,  39, 101, 114, 114, 101,
117, 114,  32,  35,  32,  16,  16,  32,  97,  32, 101, 116, 101,  32, 100, 101,
116, 101,  99, 116, 101, 101,  46,   3,   3, 102,  97,  99,   7,   7, 101, 115,
115,  97, 105,  95,  48,  12,  12,  10,  32,  33, 110,  32, 100, 101,  32,  49,
 32,  97,  32,  26,  26,  32, 101, 110, 102, 105, 110,  32, 115, 105,  32,  99,
 39, 101, 115, 116,  32, 112, 111, 115, 115, 105,  98, 108, 101,  32,  33,   5,
  5,  32, 105,  32,  61,  32,  10,  10,  44,  32, 102,  97,  99,  40, 105,  41,
 32,  61,   0,   0,   0,   0,   0,   0
}};

/* Define the local static Initialized section. */
static Blk( Ri, 16 ) = {{
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
}};

/* Define the local static section. */
static Blk( Rs, 32 );

static sigjmp_buf G_lb_env;

/* Declaration of external variables. */
extern V PAS__f_error;
extern V PAS__f_output;




/* Procedure/Function : " err_hdl "  */
SL ESSAI_0_err_hdl(SL F_ierr){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=10; /* line # 10 */
  PAS__SELECT_OUT(PAS__f_error);
  PAS__WRITE_STR(Rd.s+88,-1,-1,32);
  PAS__WRITE_INT(F_ierr,12,0);
  PAS__WRITE_STR(Rd.s+101,-1,-1,32);
  PAS__WRITE_EOLN();
  siglongjmp(G_lb_env,1);
  Ret=1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " fac "  */
F ESSAI_0_fac(F F_r_A){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register F Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+119;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=18; /* line # 18 */
  if (fabs(F_r_A-(F)1.000000E+00)<(F)1.000000E-01) Ret=(F)1.000000E+00;
  else Ret=F_r_A*ESSAI_0_fac(F_r_A-(F)1.000000E+00);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " essai_0 "  */
int main( int argc, C * argv[], C * env[] ) {

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  if (sigsetjmp(G_lb_env, 1 )) goto L_l_0;

  Rs.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s;
  Rs.v[1]=Rd.s+124;
  Rs.v[2]=Rd.s+9;
  Rs.sl[6]=23; /* line # 23 */
  PAS__ESTABLISH(ESSAI_0_err_hdl);
  Ri.sl[0]=6;
L_l_1:
  Rs.sl[6]=27; /* line # 27 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+133,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[0],0,0);
  if (Ri.sl[0]>50) {
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+147,-1,-1,32);
  }
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ri.sl[1]=1;
  while (1){
    Rs.sl[6]=32; /* line # 32 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_STR(Rd.s+175,-1,-1,32);
    PAS__WRITE_INT(Ri.sl[1],6,0);
    PAS__WRITE_STR(Rd.s+182,-1,-1,32);
    PAS__WRITE_SNGL(ESSAI_0_fac((float)Ri.sl[1]),10,5,0);
    PAS__WRITE_EOLN();
    Ri.sl[1]=Ri.sl[1]+1;
    if (Ri.sl[2]==0&&Ri.sl[1]==7) {
      Ri.sl[2]=Ri.sl[2]+1;
      Ri.sl[0]=4;
      goto L_l_1;
    }
    if (Ri.sl[2]==1&&Ri.sl[1]==5) {
      Ri.sl[2]=Ri.sl[2]+1;
      Ri.sl[0]=499;
      goto L_l_1;
    }
    if (Ri.sl[1]>500)  break;
  }
L_l_0:
  PAS__curr_cntx=Rs.s;
  Rs.sl[6]=42; /* line # 42 */
  PAS__curr_cntx=Rs.v[0];
  PAS__EXIT( 0 );
}
