program ESPROG;

%include 'PASENV:draw_defs';

const
  SEGSIZE       =   128;                { 128 points/segments max. }
  SEGTBSIZE     =    16;                { Keep only 16 segments max. }
  INITIME_WIDTH = 600.0;                { 600 seconds of with for window time (initial value) }

type
  seg_rec = record
              nseg:       Dint;
              xsta, xend: real
            end;


var
  xs, ys, int: Dfloat;

  unt: unit_type;
  box:      Dint;

  seg_tab: array[0..SEGTBSIZE-1] of seg_rec;

  lrg:   real := 0.1;                   { width of gaussien distribution }

  xst, xwd:     real;                   { Start and width of window graphic time }

  time,                                 { Time from time origine (initial time = 0) }
  delay: real := 0.1;                   { Delta of time - Random }

  ns, np, dum, irp: integer := 0;


  procedure GET_DELAY( time: real; var del, int: real );
  var
    x, y, r: real;

  begin
    x := time - ROUND( time );           { Get the distance to the nearest integer }
    int := EXP( - SQR(x/lrg) );
    repeat r := RANDOM( dum ) until r > 0.0;
    del := 0.1*LN( r/lrg )
  end GET_DELAY;



  procedure CHANGE_BOX( xmin, xmax: Dfloat );
  begin
    DRAW$SEG_END;
    DRAW$CLOSE_BOX;
    DRAW$UPDATE_SEG( 1 );
    DRAW$FREE_BOX( box );
    DRAW$OUT_MODE( 1 );
    DRAW$LINE_ATTR( 1, 2.0 );
    box := DRAW$EASY_BOX_2D( 2.0, 2.0, 26.0, 20.0, xmin, xmax, 0.0, 1.0, 'time(s)', 'cps', 2 );
    DRAW$PLOT_BOX( box );
    DRAW$OPEN_BOX( box );
  end CHANGE_BOX;



  procedure NEW_TSEG;
  var
    xf:  Dfloat;

  begin
    DRAW$SEG_END;
    if ns > 0 then xf := seg_tab[ns].xsta
              else xf := xst;
    ns := ns + 1; if ns >= SEGTBSIZE then ns := ns - SEGTBSIZE;
    with seg_tab[ns] do
      if nseg = 0 then
      begin { Create a new segment }
        nseg := DRAW$NEW_SEG( ns + 10 );
        xsta := xf;
        xend := xf + xwd;
      end
      else
      begin { Re-use an existing segment }
        { We must keep the last xsta }
        CHANGE_BOX( xf, xf + xwd );
        DRAW$UPDATE_SEG( ns + 10 );
        DRAW$OUT_MODE( 2 );
        DRAW$MARKER_ATTR( 2, 2.0 );
      end;
    np := 0
  end NEW_TSEG;



  procedure INCREASE_BOX;
  begin
    if box <> 0 then
    begin
      DRAW$CLOSE_BOX;
      Draw$Free_Box( box )
    end;
    xwd := (time - xst)*1.25;
    box := Draw$Easy_Box_2D( 2.0, 2.0, 26.0, 20.0, xst, xst+xwd, 0.0, 1.0, 'time(s)', 'cps', 2 );
    DRAW$UPDATE_SEG( 1 );
    DRAW$PLOT_BOX( box );
    DRAW$SEG_END;
    DRAW$OPEN_BOX( box );
    DRAW$UPDATE_SEG( ns + 10, 1 ) { Re-select the current curve segment in append mode }
  end INCREASE_BOX;



begin { main }
  { Init the segment table }
  for ii := 0 to SEGTBSIZE-1 do seg_tab[ii].nseg := 0;

  time :=           0.0;                { set initiale window time size }
  xst  :=           0.0;
  xwd  := INITIME_WIDTH;
  ns   :=            -1;                { Start to segment #0 (+10) }

  DRAW$INIT( xs, ys, unt );             { Init DRAW system }
  DRAW$PICTURE( 'Progressive plot example', 30.0, 20.0, true, true );
  DRAW$PIC_VIEW;                        { Set update graphic as soon as mode }
  DRAW$NEW_SEG( 1 );                    { Create THE inbox in the initial state }
  box := Draw$Easy_Box_2D( 2.0, 2.0, 25.0, 15.0, xst, xst+xwd, 0.0, 1.0, 'time(s)', 'cps', 2 );
  DRAW$LINE_ATTR( 1, 2.0 );             { Set the axis line width }
  DRAW$PLOT_BOX( box );                 { Plot the box }

  DRAW$TIME_ANIM( 10 );                 { Set the window refresh period to 10 ms }

  DRAW$OPEN_BOX( box );                 { Open the box }
  ns := 0;                              { Select for the first curve segment }
  NEW_TSEG;                             { Create the first segment }

stop_anim:
  repeat
    DRAW$SET_STOP_ANIM( 0 );            { Clear any stop mode }
    irp := DRAW$DIALOG( 1 );            { Enter in the Dialog Pause }
    if irp >= 0 then
    begin
      DRAW$SET_STOP_ANIM( 1 );          { Set the single stop mode }
      DRAW$OPEN_BOX( box );
      repeat
        np := np + 1;
        GET_DELAY( time, delay, int );  { Simule a Random (Poisson) distribution of individual event }
        time := time + delay;           { Update the current time }
        WRITELN( np:4, '/ ', time:10:3, int:10:4 );
        if time > xst+xwd then INCREASE_BOX;
        if delay > 0.0 then SLEEP( delay );   { Wait for the computed time }
        DRAW$PROG_PLOT( time, int );    { Plot the point }
        if np >= SEGSIZE then           { When the segment is full ... }
        begin
          DRAW_PROG_SETTING( 0 );       { Transfom the current progressive block to normal one }
          NEW_TSEG                      { Skip to the next segment }
        end
      until Draw_Anim_State > 0;        { Loop until the stop animation menu action }
    end
  until irp < 0;                        { Loop until the end menu action }

  DRAW$END                              { Stop The DRAW System. }
end ESPROG.
