/************************************************************************
*                                                                       *
*                                                                       *
*                                                                       *
*              D R A W   -   C L I E N T   L I B R A R Y                *
*                                                                       *
*              (Environment/Header File for DRAW Library)               *
*                                                                       *
*                                                                       *
*                                                                       *
************************************************************************/



#ifndef _DRW_ENV                     /* To avoid Multi-definitions */
#  define _DRW_ENV    0



/***********************************************************************/
/**                                                                   **/
/**           C O N S T A N T E S    D E F I N I T I O N S            **/
/**                                                                   **/
/***********************************************************************/


#  include <draw/draw_constantes.h>  /* Draw Server Constantes definitions */
#  include <draw/draw_apientry.h>    /* Load the Draw API Macro */
/* #  include <draw/draw_l4env.h>    /* load the DRAW L4 Library environment */



# ifdef VMS                          /* Define Init C Run-Time Entry ... */ 
#   ifndef	__DECC                   /* ... Point for VMS VAXC and DECC */
#     define C_CRTL_INIT() VAXC_CRTL_INIT()
#   else
#     define C_CRTL_INIT() DECC_VAXC_CRTL_INIT()
#   endif
#   define DRAW_INI_STAT -1          /* For VMS the Draw_Status is not C init */
# else                               /* For not VMS system, define ... */
#   define DRAW_INI_STAT  0          /* ... normal (Draw_Status) init value */
# endif






/***********************************************************************/
/**                                                                   **/
/**                T Y P E S    D E F I N I T I O N S                 **/
/**                                                                   **/
/***********************************************************************/


typedef unsigned char       Char;   /* UNsigned char named Char */


typedef float  Draw_Point3[3],      /* Define a 3D point */
               Draw_Point[2],       /* Define a 2D point */
               Draw_Color[4];       /* Define a color with alpha */







/***********************************************************************/
/**                                                                   **/
/**            V A R I A B L E S    D E F I N I T I O N S             **/
/**                                                                   **/
/***********************************************************************/

#  ifdef _DRAWLIB_BASE_
#    define extref
#    define extini( val )        = val
#  else
#    define extref extern
#    define extini( val )
#  endif



extref  int   Draw_Status extini( DRAW_INI_STAT );  /* Draw Library Status word */

extref  int   Draw_Buf_Size,         /* Used Buffer size */
              Draw_Inp_Size,         /* Buffer Input (read) Size */
              Draw_Srv_Flg,          /* Server Graphic Capabilities Flag */
              Draw_Srv_Ide;          /* Server Identifieur Number */

extref  char* Draw_Srv_Name;         /* Server Name String */
extref  Char  Draw_Srv_NameLength;   /* Server Name String Length */

extref  float Draw_Currx,            /* Last point X coordinate */
              Draw_Curry,            /* Last point Y coordinate */
              Draw_Currz;            /* Last point Z coordinate */

extref  int   Draw_AnmSSt extini(0); /* Stop Animation State Word */

extref  int   Draw_SrvMod extini(0); /* User Requested/Obtained Server Specification */

extref  int   Draw_PanIde extini(0); /* Identifier of modified Pannel during a Draw_Dialog call  */




/***********************************************************************/
/**                                                                   **/
/**  P R O C E D U R E S / F U N C T I O N S   D E F I N I T I O N S  **/
/**                                                                   **/
/***********************************************************************/

# ifdef VMS

extern void	C_CRTL_INIT();  /* Special VMS Entry Point for C Run Time */

# endif



/********************   Basic Pipe Routines   **************************/

int           Sdrw_Open_Gate();
int           Sdrw_Establish_Connection();
void          Sdrw_Connection_Release();
int           Sdrw_Read();
void          Sdrw_Write();
int           Sdrw_Read_Block( Char* tb, int dim );
void          Sdrw_Write_Block( Char* tb, int dim );
int           Sdrw_Dialog_Request();
void          Sdrw_Put_Char( Char ch );
void          Sdrw_Put_Int( int iv );
void          Sdrw_Put_Float( float fv );
void          Sdrw_Put_String( char * s, int l );
void          Sdrw_Put_Code( int code );
Char          Sdrw_Get_Char();
int           Sdrw_Get_Int();
float         Sdrw_Get_Float();
int           Sdrw_Get_String( char * s );
int           Sdrw_Get_String_SP( char** p, int aflg );
int           Sdrw_Get_Code();




/******************    Basic C Draw Routines    ************************/


void DRW_API( end )();

void Draw_Error( char *mdname, int ierr );

void Draw__Set_Menu_Spc( int cd, int id, char* name, int len, int key );

void Draw__Init( float *x_paper, float *y_paper, Char *unit,
                 Char *usr_id, int usr_len );

Char Draw__Picture( char  *title, int len,     /* Title string */
                    float x_size,              /* Plot Surface Length */
                    float y_size,
                    float z_size,
                    Char   scale,              /* Scale flags */
                    Char  margin               /* Margin/Title flag*/
                  );


void Draw_Out_Mode( int mode );

int Draw_Time_Anim( int per );

void Draw_Set_Stop_Anim( int mod );

void Draw_Mplot( int dim, float *pt, int flg );

void Draw_Plot( float x, float y, Char pen );

void Draw_Plot3( float x, float y, float z, Char pen );

void Draw_Org( float ox, float oy, int irel );

void Draw_Org3( float ox, float oy, float oz, int irel );

void DRW_API( where )( float *x, float *y );

void DRW_API( where3 )( float *x, float *y, float *z );

void Draw_Rplot( float dx, float dy, Char pen );

void Draw_Rplot3( float dx, float dy, float dz, Char pen );

void Draw__String( float x, float y, float theta, float hgt,
                   char * str, int len, int flg );

void Draw_Circle( float x_c, float y_c, float r, float st_a, float nd_a, float prec, int flg );

void Draw_Sphere( float x_c, float y_c, float z_c, float r, int plg, int plt, int flg );

void Draw_Cylinder( float xb, float yb, float zb, float th, float ph,
                    float lg, float rb, float rt, int px, int pz, int flg );

void Draw_Disk( float xc, float yc, float zc, float th, float ph,
                float ri, float re, float sa, float ea, int pt, int pr, int flg );

void Draw_Surface( int nraw, int ncol, int flg, float* vtb );

void Draw_Polyhedral( int nfc, int nvt, int flg, int* fctb, float* vtb );

void DRW_API( wplane3 )( float * mat );

void DRW_API( nplane3 )();




/***************    C - Attribute interface Draw Routines     ****************/

void Draw_Color_Index( int color );

void Draw_Set_Color( float r, float v, float b );

void Draw_Set_ColorA( float r, float v, float b, float a );

void Draw_Define_Color( int icol, float r, float g, float b );

void Draw_Define_ColorA( int icol, float r, float g, float b, float a );

int Draw_Inquire_Color( int icol, float *r, float *g, float *b, float *a );

void Draw_Line_Attr( int n, float r );

void Draw_Marker_Attr( int n, float r );

void Draw_Fill_Attr( int n1, int n2 );

void Draw_Text_Font( int n, int tp );

void Draw_Text_Attr( int n1, int n2, int n3, float re, float rs );


/*****************    C - Input interface Draw routines    *******************/

void DRW_API( _message )( char * str, int *len );

int DRW_API( _get_choice )( int *len, char * menu[], int slen[] );

int DRW_API( _get_answerd )( char * question, int *len );

int DRW_API( _get_string )( char * stit, int *ltit,
                            char * sdef, int *ldef,
                            char * sval, int *capa );

int DRW_API( _get_value )( char *stit, int *ltit, float *val, float *lw, float *up );

int DRW_API( _select_file )( char *   stit, int  *ltit,
                             char * fltr[], int fltl[], int  *flen,
                             int  *    fdx,
                             char *   sdef, int  *ldef,
                             char *   sval, int  *capa, int  *wflg );

int DRW_API( seg_pick )( int *seg_id, int *pick_id );

int Draw_Get_Position( float *xx, float *yy, Char in_epure );

int DRW_API( get_window )( float *x1, float *x2, float *y1, float *y2 );

int Draw_Get_Line_Stroke( float pt[], int capa, int *size,
                          Char keep, Char f_stroke );


/************    C - Segment/matrix interface Draw routines    ***************/

int DRW_API( push_matrix )();

void DRW_API( pop_matrix )();

int Draw_New_Seg( int n );

void DRW_API( seg_end )();

int  Draw_Del_Seg( int n );

int Draw_Update_Seg( int n, int fapp );

void Draw_Include_Seg( int n );

void Draw_Seg_Attr( int seg_id, int det, int hli, int vis, float prior );

void Draw_Set_Pickid( int pic_id );

int  Draw_Detectable( int det_flg );

int DRW_API( seg_inquire )();

void Draw_Progplot( float x, float y );

void Draw_ProgSetting( int seg, int ide );

void Draw_Seg_Unit_Transf( int iseg, int upd );

void Draw_Mat_Unit_Transf( int imat, int upd );

void Draw_Transf_Seg( int iseg, float tx, float ty,
                                float px, float py, float theta,
                                float scx, float scy );

void Draw_Transf_Mat( int imat, float tx, float ty,
                                float px, float py, float theta,
                                float scx, float scy );

void Draw_Transf_Seg3( int iseg, float  tx, float  ty, float  tz,
                                 float  px, float  py, float  pz,
                                 float ome, float chi, float psi,
                                 float scx, float scy, float scz );

void Draw_Transf_Mat3( int imat, float  tx, float  ty, float  tz,
                                 float  px, float  py, float  pz,
                                 float ome, float chi, float psi,
                                 float scx, float scy, float scz );

void Draw_Move_Seg( int iseg, float tx, float ty );

void Draw_Move_Mat( int imat, float tx, float ty );

void Draw_Move_Seg3( int iseg, float tx, float ty, float tz );

void Draw_Move_Mat3( int imat, float tx, float ty, float tz );

void Draw_Rotate_Seg( int iseg, float px, float py, float theta );

void Draw_Rotate_Mat( int imat, float px, float py, float theta );

void Draw_URot_Seg3( int iseg, float  px, float  py, float  pz,
                               float  th, float  ph, float  an );

void Draw_URot_Mat3( int imat, float  px, float  py, float  pz,
                               float  th, float  ph, float  an );

void Draw_Rotate_Seg3( int iseg, float  px, float  py, float  pz,
                                 float ome, float chi, float psi );

void Draw_Rotate_Mat3( int imat, float  px, float  py, float  pz,
                                 float ome, float chi, float psi );

void Draw_Scale_Seg( int iseg, float  px, float  py, float scx, float scy );

void Draw_Scale_Mat( int imat, float  px, float  py, float scx, float scy );

void Draw_Scale_Seg3( int iseg, float  px, float  py, float  pz,
                                float scx, float scy, float scz );

void Draw_Scale_Mat3( int imat, float  px, float  py, float  pz,
                                float scx, float scy, float scz );

int Draw_Get_Seg_Mat( int iseg, float *m );
int Draw_Put_Seg_Mat( int iseg, float *m );
int Draw_Get_Matrix( int imat, float *m );
int Draw_Put_Matrix( int imat, float *m );

int Draw_Seg_Orient( int iseg, float px, float py, float pz, Char immed );
int Draw_Mat_Orient( int imat, float px, float py, float pz, Char immed );



/**************   C - View/Special interface Draw routines    ****************/

void Draw_Pic_View( Char flags );
void Draw_Pic_Reset( Char flags );

void DRW_API( clipbox )( float *limits, Char *md );

int  Draw_Alpha_OnOff( int flg );
int  Draw_Light_OnOff( int light, int flg );
void Draw_Light_Define( int light, int knd, float* prm, int nprm );
void Draw_Mat_Light_Prop( int face, int knd, float* prm, int nprm );

void Draw_View( float dist );

int  Draw_Dialog( int flags );

void DRW_API( zoom )();
void DRW_API( scale )();
void Draw_Reload( Char flg );
void DRW_API( refresh )();
void Draw_Grid( Char flg );
void DRW_API( print )();



/******************    C - L4 interface Draw Routines    *********************/


int Draw_New_Axis( Draw_Point3 u_axis, Draw_Point3 v_axis,
                   float       length, float         vinf,
                   float         vsup, int           ntck, int          flags );


int Draw_New_Box( Draw_Point3 org, int ix, int iy, int iz, int dtb[], int dsz,
                                                           float stb[], int nfz,
                                                           int dtbdim, int stbdim );

void Draw_Free_Box( int ib, Char axflg );

void DRW_API( free_box_list ) ();

void Draw__Set_Axis_Value( int    ax,             /* Axis Identifier */
                           int    cd,             /* Operator Code */
                           int     n,             /* Length Driver Number */
                           float* p1, float* p2,  /* Pointer to the various parameters */
                           float* p3, float* p4,
                           int*   p5, int*   p6, int*   p7 );

int  Draw__Get_Axis_Value( int    ax, int    cd, int     n,
                           float* p1, float* p2, float* p3, float *p4,
                           int*   p5, int*   p6, int*   p7 );

void Draw_Plot_Axis( int ia, Draw_Point3 org, int fvl );

void Draw_Plot_Box( int ib );

void Draw_Open_Box( int ib );

void DRW_API( close_box ) ();

void Draw_Update_Box( int ib );

int  Draw_CV_Box( int flg, float xx, float yy, float zz, float* x, float* y, float* z );



/******************    C - ionum Draw Routines    ************************/


void Draw__Write_Int( char * s, int * ip, int iv, int f );

void Draw__Write_Float( char * s, int * ip,
                        double  dv,       /* The value to output */
                        int     fs,       /* The filed size */
                        int  intsz,       /* The wished integer part size */
                        int   dcsz,       /* The wished decimal part size */
                        int     es );     /* The wished exponent field size */



void Draw__Write_Fix(   char * s, int * ip,
                        double dv,        /* the float number */
                        int    fs,        /* the field size */
                        int  dcsz,        /* the decimal part size */
                        int  dcmin );     /* Minimum of figures */


#endif

