#!/bin/sh
#
# SET up the Linux new Draw Server in the standard current directory.
#
DEF_DIR="$USR_LOCAL"
if ! test $DEF_DIR
then
  DEF_DIR="/usr/local"
fi
echo -n " Give the local target Directory [default is $DEF_DIR] "
read DEST_DIR
if ! test "$DEST_DIR"
then
  DEST_DIR="$DEF_DIR"
fi
if ! test -d "$DEST_DIR"
then
  echo -n " Do you want create it (Possible answerd Y/N) [default is Y] "
  read REP
  if test "$REP" = "n"
  then
    REP = "N"
  fi
  if test "$REP" = "N"
  then
#
#   Error the local directories does not exit and do not create it.
#
    echo "$DEST_DIR cannot be found or created."
    exit 2
  fi
  mkdir $DEST_DIR
  echo " The directory $DEST_DIR is created."
fi
export DEST_DIR
#
#  *** Set The Destination Directory for FLTK Draw Server and Library ***
#
# Create the environment files.
#
cat > draw_setup.sh <<_EOF
export DRAW_SERVER=$DEST_DIR/bin/Draw_Server.exe
export DRAW_SERVER_SETTING=$DEST_DIR/etc/pc_screen_17.draw_setting
export DRAW_FONT=$DEST_DIR/Draw_Fonts/
_EOF

cat > draw_setup.csh <<_EOF
setenv DRAW_SERVER $DEST_DIR/bin/Draw_Server.exe
setenv DRAW_SERVER_SETTING $DEST_DIR/etc/pc_screen_17.draw_setting
setenv DRAW_FONT $DEST_DIR/Draw_Fonts/
_EOF

#
# Put all Draw Kit files in the required directories.
#
if ! test -e "$DEST_DIR/bin"
then
  mkdir $DEST_DIR/bin
fi
cp Draw_Server.exe $DEST_DIR/bin/
#
if ! test -e "$DEST_DIR/etc"
then
  mkdir $DEST_DIR/etc
fi
cp pc_screen_17.draw_setting $DEST_DIR/etc/
cp draw_setup.* $DEST_DIR/etc/
#
if ! test -e "$DEST_DIR/lib"
then
  mkdir $DEST_DIR/lib
fi
cp libdraw.a $DEST_DIR/lib/
#
if ! test -e "$DEST_DIR/include"
then
  mkdir $DEST_DIR/include
fi
cp draw_defs.* $DEST_DIR/include/
if ! test -e "$DEST_DIR/include/draw"
then
  mkdir $DEST_DIR/include/draw
fi
tar -xzvf include_draw.tgz
cp draw/* $DEST_DIR/include/draw/
rm -f -R draw
#
if test -e "$DEST_DIR/cpas"
then
  cp draw_defs.pas $DEST_DIR/cpas/
fi
if ! test -e "$DEST_DIR/Draw_Fonts"
then
  mkdir $DEST_DIR/Draw_Fonts
fi
cp *.Drwfnt $DEST_DIR/Draw_Fonts/
#
# Create the graph area with example files,
#                            documentation file,
#                        and header files for fortran and cpascal.
#
if ! test -e "$DEST_DIR/graph"
then
  mkdir $DEST_DIR/graph
fi
if ! test -e "$DEST_DIR/graph/Draw_Examples"
then
  mkdir $DEST_DIR/graph/Draw_Examples
fi
tar -xzvf Draw_Examples.tgz
cp Draw_Examples/* $DEST_DIR/graph/Draw_Examples/
rm -f -R Draw_Examples
cp draw_version.dat $DEST_DIR/graph/
cp draw_guide.* $DEST_DIR/graph/
cp draw_defs.* $DEST_DIR/graph/
#
# Start a test (if it exist).
#
if test -e draw_ivp.exe
then
  source draw_setup.sh
  cat <<_EOF

  The used Draw server is :         $DRAW_SERVER
  The used display setting is :     $DRAW_SERVER_SETTING
  The used FONT Directory is :      $DRAW_FONT


*********************************************************************************
*                                                                               *
*     Now, We start the Installation Verification Program.                      *
*                                                                               *
*     You must clic on Resume or quit in file menu to end the installation      *
*     process.                                                                  *
*                                                                               *
*********************************************************************************

_EOF
  ./draw_ivp.exe
fi
#
# Send the user setup message
#
cat <<_EOF

*********************************************************************************
*                                                                               *
*     The Draw Library and Server Task was succesfully installed.               *
*                                                                               *
*     To setup the use of DRAW you must insert the following lines	        *
*     in your appropriate setup file (.profile or .bashrc for bash and          *
*     .cshrc for csh or tcsh).                                                  *
*                                                                               *
*     For sh, bash, or ksh shell, you insert the command line :                 *
*       source $DEST_DIR/etc/draw_setup.sh                                      *
*                                                                               *
*     For csh, or tcsh shell, you insert the command line :                     *
*       source $DEST_DIR/etc/draw_setup.csh                                     *
*                                                                               *
*     To Compile and link a program you must specify                            *
*       -L$DEST_DIR/lib/ -ldraw                                                 *
*     and use the appropriate file :                                            *
*       For fortran $DEST_DIR/include/draw_defs.for                             *
*       For cpas    $DEST_DIR/include/draw_defs.pas                             *
*                                                                               *
*     Good Luke!                                                                *
*                                                                               *
*********************************************************************************

_EOF
#
