/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 336 ) = {
  9,   9,  97, 114, 114, 111, 119,  95, 115, 101, 103,  63,  63,  47,  69,  47,
119, 111, 108, 102, 101, 114, 115,  47,  83, 111, 102, 116,  47, 102, 108, 116,
107,  95, 115, 101, 114, 118, 101, 114,  95, 115, 114,  99,  95,  86,  48,  46,
 57,  66,  47,  87, 105, 110, 100, 111, 119, 115,  95,  98, 105, 110,  95, 107,
105, 116,  47, 101, 115, 105, 110,  99,  46, 112,  97, 115,   5,   5,  97, 114,
114, 111, 119,  15,  15, 100, 105, 115, 112, 108,  97, 121,  95, 115, 117, 114,
102,  97,  99, 101,   0,   0,  72,  66,   0,   0,   0,   0,   0,   0,  72,  66,
154, 153,  25,  63, 154, 153,  25,  63, 154, 153,  25,  63,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0, 200,  66,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 128,  63,  17,  17, 101, 115, 115,  97, 105,  95, 115, 121, 115,  95,
105, 110,  99, 108, 117, 100, 101,  13,  13,  69, 115, 115,  97, 105,  32,  71,
114,  97, 112, 104, 105,  99,   5,   5, 120, 115,  32,  61,  32,   8,   8,  32,
 32,  32, 121, 115,  32,  61,  32,  10,  10,  32,  32,  32, 117, 110, 105, 116,
 32,  61,  32,  16,  16,  32,  67, 111, 109, 112, 108, 101, 120,  32,  79,  98,
106, 101,  99, 116, 115,  10,  10,  32,  83, 116,  97, 116, 117, 115,  32,  61,
 32,  14,  14,  32,  80, 105,  99, 107,  32, 111, 102,  32, 115, 101, 103,  32,
 35,  16,  16,  32, 119, 105, 116, 104,  32, 112, 105,  99, 107,  95, 105, 100,
 32,  61,  32,  27,  27,  32,  70, 105, 110,  32,  69, 115, 115,  97, 105,  32,
 73, 110,  99, 108, 117, 100, 101,  32,  79,  98, 106, 101,  99, 116, 115,  46
};

/* Define the local static Initialized section. */
static Blk( Ri, 40 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 24 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL Draw_SrvMod;


/* Function/procedure prototypes. */
void DRW_API( end )();
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
void Draw_Color_Index(SL F_n);
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Plot3(F F_x, F F_y, F F_z, UB F_ipen);
void Draw_View(F F_dist, F F_om, F F_th, F F_nu);
void Draw_Sphere(F F_xc, F F_yc, F F_zc, F F_r, SL F_plg, SL F_plt, SL F_flg);
void Draw_Cylinder(F F_xb, F F_yb, F F_zb, F F_th, F F_ph, F F_lg, F F_rb, F F_rt
, SL F_px, SL F_pz, SL F_flg);
void Draw_Disk(F F_xc, F F_yc, F F_zc, F F_th, F F_ph, F F_ri, F F_re, F F_sa, F
F_ea, SL F_pt, SL F_pr, SL F_flg);
SL Draw_New_Seg(SL F_n);
void DRW_API( seg_end )();
void Draw_Include_Seg(SL F_n);
void Draw_Seg_Attr(SL F_seg_id, SL F_det, SL F_hli, SL F_vis, F F_prior);
void Draw_Set_Pickid(SL F_pic_id);
void Draw_Detectable(SL F_det_flg);
SL DRW_API( push_matrix )();
void DRW_API( pop_matrix )();
void Draw_Move_Seg3(SL F_iseg, F F_tx, F F_ty, F F_tz);
void Draw_Move_Mat3(SL F_imat, F F_tx, F F_ty, F F_tz);
void Draw_Rotate_Seg3(SL F_iseg, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
void Draw_Rotate_Mat3(SL F_imat, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
SL Draw_Get_Seg_Mat(SL F_iseg, V F_m);
SL DRW_API( seg_pick )(SL *F_seg_id, SL *F_pick_id);
SL Draw_Dialog(SL F_flags);
void Draw_Light_OnOff(SL F_light, SL F_flg);
void Draw_Light_Define(SL F_light, SL F_kind, V F_fparm, SL F_sz);
void Draw_Mat_Light_Prop(SL F_face, SL F_kind, V F_fparm, SL F_sz);


/* Procedure/Function : " arrow_seg "  */
SL ESSAI_SLUDE_arrow_seg(F F_m, F F_rd, UB F_flg){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=46; /* line # 46 */
  Rv0=Draw_New_Seg(-1);
  Ra.sl[3]=47; /* line # 47 */
  if (F_flg) {
    Ra.sl[3]=49; /* line # 49 */
    Rv1=F_rd;
    Rv2=(F)3.000000E-01*Rv1;
    Rv3=Rv2;
    Ra.sl[3]=50; /* line # 50 */
    Rv4=(F)0.000000E-01;
    Rv5=F_m;
    Rv6=F_m-(F)5.000000E-01;
    Ra.sl[3]=51; /* line # 51 */
    Draw_Set_Pickid(0);
  }
  else {
    Ra.sl[3]=55; /* line # 55 */
    Rv2=F_rd;
    Rv3=Rv2*(F)5.714286E-01;
    Rv1=Rv2*(F)1.285714E+00;
    Ra.sl[3]=56; /* line # 56 */
    Rv5=F_m*(F)5.000000E-01;
    Rv4=-Rv5;
    Rv6=(F)6.000000E-01*Rv5;
  }
  Ra.sl[3]=58; /* line # 58 */
  Draw_Seg_Attr(Rv0,0,0,0, (F)0.000000E-01);
  Ra.sl[3]=59; /* line # 59 */
  if (!F_flg) Draw_Set_Pickid(1);
  Ra.sl[3]=60; /* line # 60 */
  Draw_Disk((F)0.000000E-01, (F)0.000000E-01, Rv4, (F)1.800000E+02, (F)0.000000E-01,
  (F)0.000000E-01, Rv2, (F)0.000000E-01, (F)3.600000E+02,32,8,4);
  Ra.sl[3]=61; /* line # 61 */
  if (!F_flg) Draw_Set_Pickid(2);
  Ra.sl[3]=62; /* line # 62 */
  Draw_Cylinder((F)0.000000E-01, (F)0.000000E-01, Rv4, (F)0.000000E-01, (F)0.000000E-01,
  Rv6-Rv4, Rv2, Rv3,32,8,4);
  Ra.sl[3]=63; /* line # 63 */
  if (!F_flg) Draw_Set_Pickid(3);
  Ra.sl[3]=64; /* line # 64 */
  Draw_Disk((F)0.000000E-01, (F)0.000000E-01, Rv6, (F)1.800000E+02, (F)0.000000E-01,
  Rv3, Rv1, (F)0.000000E-01, (F)3.600000E+02,32,8,4);
  Ra.sl[3]=65; /* line # 65 */
  if (!F_flg) Draw_Set_Pickid(4);
  Ra.sl[3]=66; /* line # 66 */
  Draw_Cylinder((F)0.000000E-01, (F)0.000000E-01, Rv6, (F)0.000000E-01, (F)0.000000E-01,
  Rv5-Rv6, Rv1, (F)0.000000E-01,32,8,4);
  Ra.sl[3]=67; /* line # 67 */
  DRW_API( seg_end )();
  Ra.sl[3]=68; /* line # 68 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " arrow "  */
SL ESSAI_SLUDE_arrow(SL F_imom, F F_x, F F_y, F F_z, F F_th, F F_ph){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );

  /* Local variable stored in C variable */
  SL Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+76;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=77; /* line # 77 */
  Rv0=DRW_API( push_matrix )();
  Ra.sl[3]=78; /* line # 78 */
  Draw_Move_Mat3(Rv0, F_x, F_y, F_z);
  Ra.sl[3]=79; /* line # 79 */
  Draw_Rotate_Mat3(Rv0, (F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, F_ph,
  F_th, (F)0.000000E-01);
  Ra.sl[3]=80; /* line # 80 */
  Draw_Include_Seg(F_imom);
  Ra.sl[3]=81; /* line # 81 */
  DRW_API( pop_matrix )();
  Ra.sl[3]=82; /* line # 82 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " display_surface "  */
void ESSAI_SLUDE_display_surface(){
  /* Define the automatic variable space. */
  Blk( Ra, 64 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+83;
  Ra.v[2]=Rd.s+11;
  Ra.sl[3]=119; /* line # 119 */
  Ri.sl[0]=ESSAI_SLUDE_arrow_seg((F)1.200000E+01, (F)2.000000E-01,1);
  Ra.sl[3]=120; /* line # 120 */
  Ri.sl[1]=ESSAI_SLUDE_arrow_seg((F)1.600000E+01, (F)2.000000E-01,1);
  Ra.sl[3]=121; /* line # 121 */
  Ri.sl[2]=ESSAI_SLUDE_arrow_seg((F)5.000000E+00, (F)3.500000E-01,0);
  Ra.sl[3]=123; /* line # 123 */
  Ri.sl[3]=Draw_New_Seg(-1);
  Ra.sl[3]=124; /* line # 124 */
  Draw_Seg_Attr(Ri.sl[3],2,0,2, (F)5.000000E-01);
  Ra.sl[3]=125; /* line # 125 */
  Draw_Rotate_Seg3(Ri.sl[3],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)
9.000000E+01, (F)8.000000E+01, (F)-8.000000E+01);
  Ra.sl[3]=127; /* line # 127 */
  Draw_Move_Seg3(Ri.sl[3],(F)-8.000000E+00, (F)-8.000000E+00, (F)-8.000000E+00);
  Ra.sl[3]=131; /* line # 131 */
  Draw_Get_Seg_Mat(Ri.sl[3],Ra.s+16);
  Ra.sl[3]=132; /* line # 132 */
  Rv0=1;
  for( Rf1=3;Rf1>0;Rf1-- ) {
    Ra.sl[3]=134; /* line # 134 */
    Rv1=1;
    for( Rf0=4;Rf0>0;Rf0-- ) {
      Ra.sl[3]=135; /* line # 135 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_SNGL(Ra.f[Rv0*4+Rv1-1],12,2,0);
      Rv1++;
    }
    Ra.sl[3]=136; /* line # 136 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_EOLN();
    Rv0++;
  }
  Ra.sl[3]=138; /* line # 138 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  Ra.sl[3]=149; /* line # 149 */
  Draw_Light_Define(0,0, Rd.s+100,3);
  Ra.sl[3]=150; /* line # 150 */
  Draw_Light_Define(0,1, Rd.s+112,4);
  Ra.sl[3]=151; /* line # 151 */
  Draw_Light_Define(0,2, Rd.s+128,4);
  Ra.sl[3]=152; /* line # 152 */
  Draw_Light_Define(0,3, Rd.s+144,4);
  Ra.sl[3]=154; /* line # 154 */
  Draw_Mat_Light_Prop(0,4, Rd.s+160,1);
  Ra.sl[3]=155; /* line # 155 */
  Draw_Mat_Light_Prop(0,5, Rd.s+164,4);
  Ra.sl[3]=157; /* line # 157 */
  Draw_View((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01);
  Ra.sl[3]=159; /* line # 159 */
  Rs.f[0]=(F)9.000000E+01;
  Rs.f[1]=(F)0.000000E-01;
  Ra.sl[3]=162; /* line # 162 */
  Draw_Set_Pickid(1000);
  Ra.sl[3]=163; /* line # 163 */
  Draw_Detectable(0);
  Ra.sl[3]=165; /* line # 165 */
  Draw_Set_ColorA((F)7.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=166; /* line # 166 */
  Ri.sl[4]=ESSAI_SLUDE_arrow(Ri.sl[0],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
  (F)9.000000E+01, (F)0.000000E-01);
  Ra.sl[3]=167; /* line # 167 */
  Draw_Set_ColorA((F)0.000000E-01, (F)7.000000E-01, (F)0.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=168; /* line # 168 */
  Ri.sl[5]=ESSAI_SLUDE_arrow(Ri.sl[0],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
  (F)9.000000E+01, (F)9.000000E+01);
  Ra.sl[3]=169; /* line # 169 */
  Draw_Set_ColorA((F)0.000000E-01, (F)0.000000E-01, (F)7.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=170; /* line # 170 */
  Ri.sl[6]=ESSAI_SLUDE_arrow(Ri.sl[1],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
  (F)0.000000E-01, (F)0.000000E-01);
  Ra.sl[3]=172; /* line # 172 */
  Draw_Color_Index(1);
  Ra.sl[3]=173; /* line # 173 */
  Draw_Plot3((F)1.200000E+01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[3]=174; /* line # 174 */
  Draw_Plot3((F)1.200000E+01, (F)1.200000E+01, (F)0.000000E-01,1);
  Ra.sl[3]=175; /* line # 175 */
  Draw_Plot3((F)0.000000E-01, (F)1.200000E+01, (F)0.000000E-01,1);
  Ra.sl[3]=176; /* line # 176 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)1.600000E+01,0);
  Ra.sl[3]=177; /* line # 177 */
  Draw_Plot3((F)1.200000E+01, (F)0.000000E-01, (F)1.600000E+01,1);
  Ra.sl[3]=178; /* line # 178 */
  Draw_Plot3((F)1.200000E+01, (F)1.200000E+01, (F)1.600000E+01,1);
  Ra.sl[3]=179; /* line # 179 */
  Draw_Plot3((F)0.000000E-01, (F)1.200000E+01, (F)1.600000E+01,1);
  Ra.sl[3]=180; /* line # 180 */
  Draw_Plot3((F)0.000000E-01, (F)1.200000E+01, (F)1.600000E+01,1);
  Ra.sl[3]=181; /* line # 181 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)1.600000E+01,1);
  Ra.sl[3]=182; /* line # 182 */
  Draw_Plot3((F)1.200000E+01, (F)0.000000E-01, (F)1.600000E+01,0);
  Ra.sl[3]=183; /* line # 183 */
  Draw_Plot3((F)1.200000E+01, (F)0.000000E-01, (F)0.000000E-01,1);
  Ra.sl[3]=184; /* line # 184 */
  Draw_Plot3((F)1.200000E+01, (F)1.200000E+01, (F)1.600000E+01,0);
  Ra.sl[3]=185; /* line # 185 */
  Draw_Plot3((F)1.200000E+01, (F)1.200000E+01, (F)0.000000E-01,1);
  Ra.sl[3]=186; /* line # 186 */
  Draw_Plot3((F)0.000000E-01, (F)1.200000E+01, (F)1.600000E+01,0);
  Ra.sl[3]=187; /* line # 187 */
  Draw_Plot3((F)0.000000E-01, (F)1.200000E+01, (F)0.000000E-01,1);
  Ra.sl[3]=188; /* line # 188 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[3]=190; /* line # 190 */
  Draw_Detectable(1);
  Ra.sl[3]=195; /* line # 195 */
  Draw_Set_Pickid(10);
  Ra.sl[3]=196; /* line # 196 */
  Draw_Set_ColorA((F)2.000000E-01, (F)6.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=197; /* line # 197 */
  Ri.sl[7]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)8.000000E+00, (F)8.000000E+00, (F)0.000000E-01,
  (F)2.200000E+01, (F)4.500000E+01);
  Ra.sl[3]=198; /* line # 198 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=199; /* line # 199 */
  Draw_Set_Pickid(19);
  Ra.sl[3]=200; /* line # 200 */
  Draw_Sphere((F)8.000000E+00, (F)8.000000E+00, (F)0.000000E-01, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=202; /* line # 202 */
  Draw_Set_Pickid(20);
  Ra.sl[3]=203; /* line # 203 */
  Draw_Set_ColorA((F)2.000000E-01, (F)2.000000E-01, (F)6.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=204; /* line # 204 */
  Ri.sl[8]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)4.000000E+00, (F)4.000000E+00, (F)0.000000E-01,
  (F)4.800000E+01, (F)4.500000E+01);
  Ra.sl[3]=205; /* line # 205 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=206; /* line # 206 */
  Draw_Set_Pickid(29);
  Ra.sl[3]=207; /* line # 207 */
  Draw_Sphere((F)4.000000E+00, (F)4.000000E+00, (F)0.000000E-01, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=210; /* line # 210 */
  Draw_Set_Pickid(30);
  Ra.sl[3]=211; /* line # 211 */
  Draw_Set_ColorA((F)2.000000E-01, (F)6.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=212; /* line # 212 */
  Ri.sl[7]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)2.000000E+00, (F)1.000000E+01, (F)8.000000E+00,
  (F)3.500000E+01, (F)2.500000E+01);
  Ra.sl[3]=213; /* line # 213 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=214; /* line # 214 */
  Draw_Set_Pickid(39);
  Ra.sl[3]=215; /* line # 215 */
  Draw_Sphere((F)2.000000E+00, (F)1.000000E+01, (F)8.000000E+00, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=217; /* line # 217 */
  Draw_Set_Pickid(40);
  Ra.sl[3]=218; /* line # 218 */
  Draw_Set_ColorA((F)2.000000E-01, (F)2.000000E-01, (F)6.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=219; /* line # 219 */
  Ri.sl[8]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)1.000000E+01, (F)2.000000E+00, (F)8.000000E+00,
  (F)3.500000E+01, (F)6.500000E+01);
  Ra.sl[3]=220; /* line # 220 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=221; /* line # 221 */
  Draw_Set_Pickid(49);
  Ra.sl[3]=222; /* line # 222 */
  Draw_Sphere((F)1.000000E+01, (F)2.000000E+00, (F)8.000000E+00, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=225; /* line # 225 */
  Draw_Set_Pickid(50);
  Ra.sl[3]=226; /* line # 226 */
  Draw_Set_ColorA((F)2.000000E-01, (F)6.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=227; /* line # 227 */
  Ri.sl[7]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)8.000000E+00, (F)8.000000E+00, (F)1.600000E+01,
  (F)2.200000E+01, (F)4.500000E+01);
  Ra.sl[3]=228; /* line # 228 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=229; /* line # 229 */
  Draw_Set_Pickid(59);
  Ra.sl[3]=230; /* line # 230 */
  Draw_Sphere((F)8.000000E+00, (F)8.000000E+00, (F)1.600000E+01, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=232; /* line # 232 */
  Draw_Set_Pickid(60);
  Ra.sl[3]=233; /* line # 233 */
  Draw_Set_ColorA((F)2.000000E-01, (F)2.000000E-01, (F)6.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=234; /* line # 234 */
  Ri.sl[8]=ESSAI_SLUDE_arrow(Ri.sl[2],(F)4.000000E+00, (F)4.000000E+00, (F)1.600000E+01,
  (F)4.800000E+01, (F)4.500000E+01);
  Ra.sl[3]=235; /* line # 235 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)2.000000E-01, (F)1.000000E+00);
  Ra.sl[3]=236; /* line # 236 */
  Draw_Set_Pickid(69);
  Ra.sl[3]=237; /* line # 237 */
  Draw_Sphere((F)4.000000E+00, (F)4.000000E+00, (F)1.600000E+01, (F)7.000000E-01,32,32,4);
  Ra.sl[3]=239; /* line # 239 */
  DRW_API( seg_end )();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " essai_sys_include "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  UB Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+8;
  Rs.v[3]=Rd.s+180;
  Rs.v[4]=Rd.s+11;
  Rs.sl[5]=249; /* line # 249 */
  Draw_SrvMod=272;
  Rs.sl[5]=251; /* line # 251 */
  Draw_Pas_Init(&Rv0, &Rv1, &Rv2, Rd.s+199);
  Rs.sl[5]=252; /* line # 252 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+214,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_STR(Rd.s+221,-1,-1,32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_STR(Rd.s+231,-1,-1,32);
  PAS__WRITE_INT(Rv2,12,0);
  PAS__WRITE_EOLN();
  Rs.sl[5]=254; /* line # 254 */
  Rv3=Draw_Pas_Picture_3D(Rd.s+243,(F)3.000000E+01, (F)3.000000E+01, (F)3.000000E+01,1,1);
  Rs.sl[5]=256; /* line # 256 */
  Draw_Light_OnOff(0,1);
  Rs.sl[5]=258; /* line # 258 */
  ESSAI_SLUDE_display_surface();
  while (1){
    Rs.sl[5]=261; /* line # 261 */
    Rv4=Draw_Dialog(1);
    Rs.sl[5]=262; /* line # 262 */
    if (Rv4<0)  break;
    while (1){
      Rs.sl[5]=264; /* line # 264 */
      Rv5=DRW_API( seg_pick )(&Rv6, &Rv7);
      Rs.sl[5]=265; /* line # 265 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+261,-1,-1,32);
      PAS__WRITE_INT(Rv5,12,0);
      PAS__WRITE_STR(Rd.s+273,-1,-1,32);
      PAS__WRITE_INT(Rv6,12,0);
      PAS__WRITE_STR(Rd.s+289,-1,-1,32);
      PAS__WRITE_INT(Rv7,12,0);
      PAS__WRITE_EOLN();
      if (Rv5<0)  break;
    }
  }
  Rs.sl[5]=269; /* line # 269 */
  DRW_API( end )();
  Rs.sl[5]=271; /* line # 271 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+307,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[2];
  PAS__EXIT( 0 );
}
