(*

 ************************************************************************
 *                                                                      *
 *                                                                      *
 *                                                                      *
 *               D R A W   -   C L I E N T   L I B R A R Y              *
 *                                                                      *
 *                P A S C A L     E N V I R O N M E N T                 *
 *                                                                      *
 *                        (Pascal Environment)                          *
 *                                                                      *
 *                    Draw Library Version V 2.5 A                      *
 *                                                                      *
 *                     For the Draw_Server V 1.5 C                      *
 *                                                                      *
 *                           30-Oct-2014                                *
 *                                                                      *
 *                               by                                     *
 *                                                                      *
 *                   Pierre Wolfers,  Institut Neel                     *
 *                                                                      *
 *           CNRS GRENOBLE,  25 Avenue des Martyrs, B.P. 166            *
 *                                                                      *
 *                      F 38042 GRENOBLE CEDEX 9                        *
 *                                                                      *
 *                            F R A N C E                               *
 *                                                                      *
 *                                                                      *
 *                                                                      *
 ************************************************************************



/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                  Global Public License (GPL)                        //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This library is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This library is distributed in the hope that it will be useful,     //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

*)
(*
  [environment( 'DRAW_DEFS')]
*)
%pragma code_option c_code '#include <draw/draw_apientry.h>';
(*
module DRAW_DEFS;
*)

const
  raster                =            0;
  centimeter            =            1;


  {   *****   PopUp Menus Flags  ***** }

  Menu_Close            =            0;
  Menu_Open             =            1;
  Menu_Skip             =            2;
  Menu_New              =            3;
  Menu_Entry            =            4;
  Menu_Separ            =            5;
  Menu_Fact             =           16;


  {   *****   Shortcut  codes  ***** }

  Drw_BSPKEY            =      16#ff08;         { Backspace Key }
  Drw_TABKEY            =      16#ff09;         { Tab Key }
  Drw_CLRKEY            =      16#ff0b          { Clear Key (can be '5' with Numlock off) }
  Drw_RETURNKEY         =      16#ff0d;         { Return Key }
  Drw_PAUSEKEY          =      16#ff13;         { Pause + break button }
  Drw_SCROLLKEY         =      16#ff14;         { Scroll Lock button }
  Drw_ESCAPEKEY         =      16#ff1b;         { ESC Key }
  Drw_HOMEKEY           =      16#ff50;         { HOME Key }
  Drw_LEFTKEY           =      16#ff51;         { Left arrow Key }
  Drw_UPKEY             =      16#ff52;         { Up arrow Key }
  Drw_RIGHTKEY          =      16#ff53;         { Right arrow Key }
  Drw_DOWNKEY           =      16#ff54;         { Down arrow Key }
  Drw_PAGEUPKEY         =      16#ff55;         { Page up Key }
  Drw_PAGEDOWNKEY       =      16#ff56;         { Page down Key }
  Drw_ENDKEY            =      16#ff57;         { End key }
  Drw_PRINTKEY          =      16#ff61;         { Print Key }
  Drw_INSERTKEY         =      16#ff63;         { Insert Key }
  Drw_MENUKEY           =      16#ff67;         { Key in lower-right with picture of popup menu }
  Drw_HELPKEY           =      16#ff68;         { Help Key }
  Drw_NUMLOCKKEY        =      16#ff7f;         { Numlock key }
  Drw_KEYPAD            =      16#ff80;         { Add Ascii Value to get keypas key }
  Drw_KEYLAST           =      16#ffbd;         { Last legal keypas key : Drw_KEYPAD + ORD( '=' ) }
  Drw_F0KEY             =      16#ffbd;         { base of Fn Key = Drw_F0KEY + n }
  Drw_FLAST             = Drw_F0KEY+35;         { Largest legal functiopn Key }
  Drw_LEFTSHIFTKEY      =      16#ffe1;         { Left-hand Shift key }
  Drw_RIGHTSHIFTKEY     =      16#ffe2;         { Right-hand Shift key }
  Drw_LEFTCTRLKEY       =      16#ffe3;         { Left-hand Ctrl key }
  Drw_RIGHTCTRLKEY      =      16#ffe4;         { Right-hand Ctrl }
  Drw_CAPSLOCKKEY       =      16#ffe5;         { Caps Lock Key }
  Drw_LEFTMETAKEY       =      16#ffe7;         { The left "Windows" or "Apple" key }
  Drw_RIGHTMETAKEY      =      16#ffe8;         { The right "Windows" or "Apple" key }
  Drw_LEFTALTKEY        =      16#ffe9;         { Left-hand Alt (option on Mac) }
  Drw_RIGHTALTKEY       =      16#ffea;         { Right-hand Alt (option on Mac) }
  Drw_DELETEKEY         =      16#ffff;         { Delete key }

  Drw_SHIFT             =  16#00010000;         { Shift key is held down }
  Drw_CAPSLOCK          =  16#00020000;         { Caps lock key is toggled on }
  Drw_CTRL              =  16#00040000;         { CTRL key held down }
  Drw_ALT               =  16#00080000;         { ALT key held down }
  Drw_NUMLOCK           =  16#00100000;         { NumLock turned on }
  Drw_META              =  16#00400000;         { Windows/APPLE Key }
  Drw_SCROLLLOCK        =  16#00800000;         { Scroll Lock turned on }
  Drw_BUTTON1           =  16#01000000;         { Left Mouse button held down }
  Drw_BUTTON2           =  16#02000000;         { Left Mouse button held down }
  Drw_BUTTON3           =  16#04000000;         { Left Mouse button held down }
  Drw_ANYBUTTON         =  16#7f000000;         { Any mouse button (up to 8) }


  {   *****   Server Capability Flags  ***** }

  DrwSrv_Do_Input       =  16#00000001;         {     1 }
  DrwSrv_Do_3D          =  16#00000002;         {     2 }
  DrwSrv_Do_Animation   =  16#00000004;         {     4 }
  DrwSrv_Do_Blend_alpha =  16#00000008;         {     8 }
  DrwSrv_Do_Lighting    =  16#00000010;         {    16 }

  DrwSrv_Do_User_Menu   =  16#00000040;         {    64 }

  DrwSrv_Enable_Light0  =  16#00000100;         {   256 }
  DrwSrv_Enable_Light1  =  16#00000200;         {   512 }
  DrwSrv_Enable_Light2  =  16#00000400;         {  1024 }
  DrwSrv_Enable_Light3  =  16#00000800;         {  2048 }

  DrwSrv_Enable_FTGL    =  16#00001000;         {  4096 }

  DrwSrv_Disable_IniErr =  16#40000000;         { 2**30 }


  {   *****   Blending Flags and Codes   ***** }

  PLOT_BLD_SOLID        =            0;
  PLOT_BLD_TRANSPARENT  =            1;

  PLTBLEND              =         4096;
  PLTBLEND_ZERO         =            0;
  PLTBLEND_ONE          =            1;
  PLTBLEND_DST_COLOR    =            2;
  PLTBLEND_SRC_COLOR    =            3;
  PLTBLEND_1_M_DST_COLOR=            4;
  PLTBLEND_1_M_SRC_COLOR=            5;
  PLTBLEND_SRC_ALPHA    =            6;
  PLTBLEND_1_M_SRC_ALPHA=            7;
  PLTBLEND_DST_ALPHA    =            8;
  PLTBLEND_1_M_DST_ALPHA=            9;
  PLTBLEND_SRC_ALPHA_SAT=           10;

  PLTBLEND_BENA         =  4096 +  256;
  PLTBLEND_BDIS         =  4096 +  512;
  PLTBLEND_DENA         =  4096 + 1024;
  PLTBLEND_DDIS         =  4096 + 2048;


  {   *****   Light/material_Properties Codes   ***** }

  LIGHT_POSITION        =            0;
  LIGHT_AMBIENT_COLOR   =            1;
  LIGHT_DIFFUSE_COLOR   =            2;
  LIGHT_SPECULAR_COLOR  =            3;
  LIGHT_SPOT_DIRECTION  =            4;
  LIGHT_SPOT_EXPONENT   =            5;
  LIGHT_SPOT_CUTOFF     =            6;
  LIGHT_CONSTANT_ATT    =            7;
  LIGHT_LINEAR_ATT      =            8;
  LIGHT_QUADRATIC_ATT   =            9;

  MAT_FRONT_FACE        =            0;
  MAT_FRONT_AND_BACK    =            1;
  MAT_BACK_FACE         =            2;

  MAT_AMBIENTE_DIFFUSE  =            0;
  MAT_AMBIENT_COLOR     =            1;
  MAT_DIFFUSE_COLOR     =            2;
  MAT_SPECULAR_COLOR    =            3;
  MAT_SHININESS         =            4;
  MAT_EMISSION_COLOR    =            5;


  {   *****   Plot  Flags  ***** }

  PLOT_LINE             =            1;         { Normal Line Out_Mode }
  PLOT_MARKER           =            2;         { Normal Marker Out_Mode }
  PLOT_FILL             =            3;         { Normal Fill Area Out_Mode }
  PLOT_POINTS           =            0;         { GL Conformance to GL_POINTS }
  PLOT_LINES            =           -1;         { GL Conformance to GL_LINES }
  PLOT_LINE_STRIP       =           -2;         { GL Conformance to GL_LINE_STRIP }
  PLOT_LINE_LOOP        =           -3;         { GL Conformance to GL_LINE_LOOP }
  PLOT_TRIANGLES        =           -4;         { GL Conformance to GL_TRIANGLE_STRIP }
  PLOT_TRIANGLE_STRIP   =           -5;         { GL Conformance to GL_TRIANGLE_STRIP }
  PLOT_TRIANGLE_FAN     =           -6;         { GL Conformance to GL_TRIANGLE_FAN }
  PLOT_QUADS            =           -7;         { GL Conformance to GL_QUADS }
  PLOT_QUAD_STRIP       =           -8;         { GL Conformance to GL_QUAD_STRIP }
  PLOT_POLYGON          =           -9;         { GL Conformance to GL_POLYGON }

  PLTFLG_START          =            1;         { PLOT Block Start Flag }
  PLTFLG_END            =            2;         { PLOT Block End Flag }
  PLTFLG_ABS            =            4;         { PLOT Block Absolute Flag }
  PLTFLG_3D             =            8;         { PLOT Block 3D Flag }
  PLTFLG_NRM            =           16;         { PLOT Block Auto Generation of Normal Flag }
  PLTFLG_UNRM           =          128;         { PLOT Block Normal are given or each point in the data block }


  {   ***** Font Style values *****  }

  FONT_DEF_STYLE        =            0;         { Default Font style }
  FONT_BITMAP           =            1;         { Bit Map font style }
  FONT_PIXMAP           =            2;         { Pixel Map Font Style }
  FONT_OUTLINE          =            3;         { OutLine Font Style (vectorial) }
  FONT_POLYGON          =            4;         { Polygon Font Style (vectorial) }
  FONT_EXTRUDE          =            5;         { Extruded Font Style (vectorial) }
  FONT_TEXTURE          =            6;         { Texture Font Style (vectorial) }

  {   ***** Text Path and Alignement values *****  }

  TXT_PATH_RIGHT        =            1;         { Normal text Path from left to right }
  TXT_PATH_LEFT         =            2;         { Text Path From Left to Right }
  TXT_PATH_UP           =            3;         { Text Path From Down to Up }
  TXT_PATH_DOWN         =            4;         { Text Path From Up to Down }

  TXT_HALN_NORMAL       =            1;         { Normal Horizontal Text Alignement = TXT_HALN_LEFT }
  TXT_HALN_LEFT         =            2;         { Horizontal Text Alignement at Left }
  TXT_HALN_CENTRE       =            3          { Horizontal Text Centered Alignement }
  TXT_HALN_RIGHT        =            4;         { Horizontal Text Alignement at Right }
  TXT_HALN_JUSTIFY      =            5;         { Horizontal Text Justified Alignement }

  TXT_VALN_NORMAL       =            1;         { Normal Vertical Text Alignement = TXT_VALN_BASE }
  TXT_VALN_TOP          =            2;         { Vertical Text Alignement at the Top of line (Characters as 'L') }
  TXT_VALN_CAP          =            3;         { Vertical Text Alignement at High of Line (Characters as 'a') }
  TXT_VALN_HALF         =            4;         { Vertical Text Alignement at the middle of line }
  TXT_VALN_BASE         =            5;         { Vertical Text Alignement at the Base of line }
  TXT_VALN_BOTTOM       =            6;         { Vertical Text Alignement at Bottom of line (Characters as 'j') }


  {   *****   Axis Flags   ***** }

  Axis_Log              =  16#00000001;         {        1: Axis is in Log10 Coordinate }
  Axis_Left             =  16#00000002;         {        2: Ticks and displayed value at left position ( else at right ) }
  Axis_VOther           =  16#00000004;         {        4: Value are in other side (than ticks) }
  Axis_NFrs             =  16#00000008;         {        8: Does not display the first Ticks }
  Axis_NFVl             =  16#00000010;         {       16: Does not display the first Value }
  Axis_NLsT             =  16#00000020;         {       32: Does not display the last Ticks }
  Axis_NLVl             =  16#00000040;         {       64: Does not display the last Value }
  Axis_NZer             =  16#00000080;         {      128: Does not display the Zero Ticks }
  Axis_NZVl             =  16#00000100;         {      256: Does not display the Zero Value }
  Axis_Arrow            =  16#00000200;         {      512: Put an arrow at the end of axis }
  Axis_ArroF            =  16#00000400;         {     1024: Fill mode for Axis_Arrow }
  Axis_Tilte            =  16#00000800;         {     2048: Axis character are tilted with ticks }
  Axis_VPath            =  16#00001000;         {     4096: String Path (2 bits) for Ticks Value }
  Axis_Upath            =  16#00004000;         {    16384: String Path (2 bits) for Axis Unit }
  Axis_SpLim            =  16#00010000;         {    65536: Axis Limit auto-adaptation when set }
  Axis_VLeft            =  16#00020000;         {   131072: Left Alignement for Unit String }
  Axis_VRight           =  16#00040000;         {   262144: Right Alignement for Unit String }
  Axis_ULeft            =  16#00080000;         {   524288: Left Alignement for Unit String }
  Axis_URight           =  16#00100000;         {  1048576: Right Alignement for Unit String }
  Axis_UMiddle          =  16#00200000;         {  2097152: Set Unit String at the Middle of Axis }

  Axis_CmAlign          =  16#01000000;         { 16777216: Align axis size and ticks on conveniant scale in cm }


  {   *****   Axis Plot Directives and Flags for Draw_Plot   ***** }

  Axis_Plot_X           =  16#00000001;         {        1: Plot an X axis }
  Axis_Plot_Y           =  16#00000002;         {        2: Plot an Y axis }
  Axis_Plot_Z           =  16#00000003;         {        3: Plot a  Z axis }
  Axis_PFlg_TVl         =  16#00000004;         {        4: Ticks values and Unit String will be Displayed }
  Axis_PFlg_TPrm        =  16#00000008;         {        8: The ticks left and right sides are permutted }
  Axis_PFlg_TSym        =  16#00000010;         {       16: The Ticks must be symmetrized }
  Axis_PFlg_XEnd        =  16#00000020;         {       32: Plot Axis with a shift of x axis size }
  Axis_PFlg_YEnd        =  16#00000040;         {       64: Plot Axis with a shift of Y axis size }
  Axis_PFlg_ZEnd        =  16#00000080;         {      128: Plot Axis with a shift of Z axis size }
  Axis_PFlg_XPos        =  16#00000100;         {      256: Plot Axis at specified X shift }
  Axis_PFlg_YPos        =  16#00000200;         {      512: Plot Axis at specified Y shift }
  Axis_PFlg_ZPos        =  16#00000400;         {     1024: Plot Axis at specified Z shift }
  Axis_Pflg_SymU        =  16#00000800;         {     2048: Apply a mU (mirror u) to tick direction }
  Axis_Pflg_SymV        =  16#00001000;         {     4096: Apply a mV (mirror v) to tick direction }
  Axis_Pflg_SymW        =  16#00002000;         {     8192: Apply a mW (mirror w) to tick direction }
  Axis_Pflg_Rotv        =  16#00004000;         {    16384: Apply an additional rotation of 180 to value and unit strings }


  { Easy Axis code for easy coice of 2D axis system }

  EAxBx_X_Cm            =  16#00000100;         { Cm Alignement for the X axis }
  EAxBx_Y_Cm            =  16#00000200;         { Cm Alignement for the Y axis }
  EAxBx_Z_Cm            =  16#00000400;         { Cm Alignement for the Z axis (reserved) }
  EAxBx_X_Log           =  16#00001000;         { Logaritmic X Axis }
  EAxBx_Y_Log           =  16#00002000;         { Logaritmic Y Axis }
  EAxBx_Z_Log           =  16#00004000;         { Logaritmic Z Axis (reserved) }
  EAxBx_XY_Cm  = EAxBx_X_Cm  + EAxBx_Y_Cm;      { Cm Alignement  on the two axis }
  EAxBx_XYZ_Cm = EAxBx_XY_Cm + EAxBx_Z_Cm;      { Cm Alignement  on the three axis }
  EAxBx_XY_Log = EAxBx_X_Log + EAxBx_Y_Log;     { Log,Log axis box }


  {   *****   Pannel Directives Symbols   ***** }

  Drw_Align_Top         =  16#00000001;         {        1: Label is centered above widget }
  Drw_Align_Bottom      =  16#00000002;         {        2: Label is centered below widget }
  Drw_Align_Left        =  16#00000004;         {        4: Label is to left widget }
  Drw_Align_Right       =  16#00000008;         {        8: Label is to right widget }
  Drw_Align_Center      =  16#00000010;         {       16: (or 0) Label is inside widget }
  Drw_Align_Inside      =  16#00000020;         {       32: Label is centered, image centered }
  Drw_Align_Clip        =  16#00000040;         {       64: The Label is clipped to the widget }
  Drw_Align_Wrap        =  16#00000080;         {      128: The label is word-wrapped }

  Drw_Align_Inside_Top     = Drw_Align_Inside + Drw_Align_Top;   { Label is inside widget at top }
  Drw_Align_Inside_Bottom  = Drw_Align_Inside + Drw_Align_Bottom;{ Label is inside widget at bottom }



type
  Dint          =              cc__int;         { Define the Draw Integer to use }
  Dfloat        =               single;         { Define the Draw Float to use }
  Dbool         =              boolean;         { Define the Draw boolean to use }
  Dbyte         =                 byte;         { Define a Flag byte }


{ unit_type     =  (raster,centimeter); }       { Selected unit capacity }
  unit_type     =                 byte;         { Selected unit capacity }


  Dvalue    =    array[1..1] of Dfloat;         { Unique parameter in an array }
  Dpoint    =    array[1..2] of Dfloat;         { 2D coordinates }
  Dpoint3   =    array[1..3] of Dfloat;         { 3D coordinates }
  Dcolor    =    array[1..4] of Dfloat;         { Color with alpha }
  DMatrix   =   array[1..3,1..4] of Dfloat;     { Transformation Matrix }

  Choice_List( dim, cap: byte )   = array[1..dim] of string( cap );     { Define the item liste for Enum/Literal type }
  Draw_Menu = Choice_List;                                              { Define for compatibility }

var
  [external 'Draw_Srv_Name'] Draw_Server_NamTb: $wild_Pointer;
  [external 'Draw_Srv_NameLength'] Draw_Server_Namln: char;
  [external 'Draw_Srv_Ide']  Draw_Server_Ident: cc__int;
  [external 'Draw_Srv_Flg']  Draw_Server_Flags: cc__int;
  [external 'Draw_SrvMod']   Draw_Server_Mode : cc__int;
  [external 'Draw_AnmSSt']   Draw_Anim_State  : cc__int;
  [external 'Draw_PanIde']   Draw_Pannel_Ident: cc__int;



{******************************************************}
{***********    Basic Draw Routines    ****************}
{******************************************************}


procedure DRAW$END; external 'Draw_End';
{ To end the DRAW session }


procedure DRAW$SET_MENU_SPC( cd: Dint; in_var name: [optional] string; id: Dint := -1; ky: Dint := 0 );
external 'Draw_Pas_Set_Menu_Spc';


function  DRAW$INIT( var x, y: Dfloat; var unit: unit_type; in_var usrid: [optional] string ): Dbool;
{ Start Graphic Server and get the X*Y plot size from the final
  work station driver.
  The resulting unit flag is true when the final work station
  has the metrix attribute, then x and y are in Cm.
  otherwise, x and y are in screen units.
  usrid is the optional user programme string identifier.
  When the DRAW$INIT is a success the returned value is TRUE. }
external 'Draw_Pas_Init';


procedure DRAW$GET_SERVER_NAME( var s: string );
external 'Draw_Pas_Get_Server_Name';


function  DRAW$PICTURE( in_var title:  string;    { Picture title }
                               px, py: Dfloat;    { Picture size in cm. }
                               bscale,            { Scale flag }
                               blimit: Dbool ): Dbool; { Margin/title flag }
{ Set the picture size to be px*py (in Cm.), and the picture title.
  If the flag blimit is set at true, then a margin is allocated around
  the picture and the title is displayed inside it else the title is
  ignored.
  If the bscale flag is set to true, then DRAW$PICTURE try to respect the
  picture size to be Dfloat Cm. If is is not possible (du to the Dfloat size of
  the final work station area, or for a not metrix work station) the flag is
  clear to false value on the return. In this case, or when the input value
  of bscale was false, the picture size is set to the maximum size possible
  in agreement with the work station area. }
external 'Draw_Pas_Picture';

function  DRAW$PICTURE3( in_var title:  string;         { Picture title }
                                px, py, pz: Dfloat;     { Picture size in cm. }
                                bscale,                 { Scale flag }
                                blimit: Dbool ): Dbool; { Margin/title flag }
external 'Draw_Pas_Picture_3D';


procedure DRAW$PICTURE_SCALES( cd: Dint; var xscale, yscale: Dfloat );
external 'Draw_Picture_Scales';


function  DRAW$DIALOG( flags: Dint := 0 ): Dint;
{ To display the picture and give mouse control for grid, zoom etc... }
external 'Draw_Dialog';


procedure DRAW$OUT_MODE( n: Dint );external 'Draw_Out_Mode';

procedure DRAW$SEND_BLOCK( in_var vtb: array[sz: Dint] of Dfloat );
external 'Draw_Pas_Send_Block';


procedure DRAW$SEND_BLOCK( in_var vtb: array[sz: Dint] of Dpoint3 );
external 'Draw_Pas_Send_Block';


function  DRAW$TIME_ANIM( per: Dint ): Dint; external 'Draw_Time_Anim';


procedure DRAW$SET_STOP_ANIM( md: Dint ); external 'Draw_Set_Stop_Anim';


procedure DRAW$MPLOT( in_var   pt: array[sz: Dint] of Dfloat;
                              npt: Dint := 0;
                             flag: Dint := 3 );
external 'Draw_Pas_Mplot';


procedure  DRAW$PROG_PLOT( x, y: Dfloat );
{*****************************************************************}
{                                                                 }
{     Plot in the currently progressive Plot Block.               }
{     If no progressive plot block are opened, a new Prog.        }
{     Plot Block is created.                                      }
{                                                                 }
{*****************************************************************}
external 'Draw_Progplot';


procedure  DRAW_PROG_SETTING( seg, ide: Dint := 0 );
{*****************************************************************}
{                                                                 }
{     To transform a 2D plot block in an progressive Plot Block   }
{     when the 2D plot plot is found in the segment seg (with     }
{     the pick identifier ide. Generate an error if not found.    }
{     When seg<=0 any previously Progressive block is changed     }
{     to a normal 2D plot block.                                  }
{                                                                 }
{*****************************************************************}
external 'Draw_ProgSetting';


procedure DRAW$PLOT( x, y: Dfloat; ipen: Dbool );
{***********************************************}
{                                               }
{     call draw$plot( x, y, ipen )              }
{                                               }
{     x,y coordinate to go                      }
{     ipen := false  to go with pen up          }
{     ipen := true   to go with pen down        }
{                                               }
{***********************************************}
external 'Draw_Plot';


procedure DRAW$PLOT3( x, y, z: Dfloat; ipen: Dbool );
external 'Draw_Plot3';


procedure DRAW$ORG( ox, oy: Dfloat; irel: Dint );
{*****************************************************************}
{                                                                 }
{       Origine pen change                                        }
{                                                                 }
{       call draw$org( ox, oy, irel )                             }
{                                                                 }
{       ox,oy is the vector to applied                            }
{       irel must be 0 for absolute origine change, >0 for        }
{       relative origine change and <0 from original origine.     }
{                                                                 }
{*****************************************************************}
external 'Draw_Org';


procedure DRAW$ORG3( ox, oy, oz: Dfloat; irel: Dint );
external 'Draw_Org3';


procedure DRAW$RPLOT( dx, dy: Dfloat; ipen: Dbool );
{**********************************************}
{                                              }
{     Relative move of the pen                 }
{                                              }
{     call draw$rplot( dx, dy, ipen )          }
{                                              }
{     dx,dy is the vector to applied           }
{     ipen is the pen command                  }
{                                              }
{**********************************************}
external 'Draw_Rplot';


procedure DRAW$RPLOT3( dx, dy, dz: Dfloat; ipen: Dbool ); external 'Draw_Rplot3';


procedure DRAW$WHERE( var x, y: Dfloat ); external 'DRW_API( where )';

procedure DRAW$WHERE3( var x, y, z: Dfloat ); external 'DRW_API( where3 )';

procedure DRAW$STRING( x, y, theta, high: Dfloat; in_var str: string; oflg: Dint := 0 );
external 'Draw_Pas_String';

procedure Draw$Text_In_Box( xx, yy, bx, by: Dfloat; in_var txt: array[sz: Dint] of char; hal, flg: Dint := 0; hc, ls: Dfloat := 1.0 );
external 'Draw_Pas_Text_In_Box';

procedure DRAW$CIRCLE( xcentre, ycentre, rayon: Dfloat;
                       start_angle, end_angle: Dfloat := 0.0; prec: Dfloat := 1.0E-3; flg: Dint := 0 );
external 'Draw_Circle';

procedure DRAW$SPHERE( xc, yc, zc, r: Dfloat; plg, plt: Dint; flg: Dint := 0 );
external 'Draw_Sphere';

procedure DRAW$CYLINDER( xb, yb, zb, th, ph, lg, rb, rt: Dfloat; px, pz: Dint; flg: Dint := 0 );
external 'Draw_Cylinder';

procedure DRAW$DISK( xc, yc, zc, th, ph, ri, re, sa, ea: Dfloat; pt, pr: Dint; flg: Dint := 0 );
external 'Draw_Disk';

procedure DRAW$SURFACE( in_var vtb: array[nraw: Dint, ncol: Dint] of DPoint3; flg: Dint := 0 );
external 'Draw_Pas_Surface';

procedure DRAW$SURFACE( nraw, ncol, flg: Dint := 0 ); external 'Draw_Pas_SurfaceA';

procedure DRAW$SURFACE2( in_var vtb: array[nraw: Dint, ncol: Dint] of Dfloat;
                                 xo, yo, xs, ys: Dfloat; flg: Dint := 0 ); external 'Draw_Pas_Surface2';

procedure DRAW$SURFACE2( nraw, ncol, flg: Dint := 0; xo, yo, xs, ys: Dfloat ); external 'Draw_Pas_Surface2A';

procedure DRAW$SURFACE( nraw, ncol: Dint; vtbp: $Wild_pointer; flg: Dint );
external 'Draw_Surface';

procedure DRAW$POLYHEDRAL( in_var ftb: array[nfc: Dint] of Dint;
                           in_var vtb: array[nvt: Dint] of DPoint3; oflg: Dint := 0 );
external 'Draw_Pas_Polyhedral';

procedure DRAW$POLYHEDRAL( nfc, nvt: Dint; ftbp, vtbp: $Wild_pointer; ofl: Dint );
external 'Draw_Polyhedral';



{*******************************************************}
{************    Attribute Draw Routines    ************}
{*******************************************************}


procedure DRAW$COLOR( n: Dint ); external 'Draw_Color_Index';

procedure DRAW$COLOR( r, v, b: Dfloat; a: Dfloat := 1.0 ); external 'Draw_Set_ColorA';

procedure DRAW$DEFINE_COLOR( icol: Dint; r, g, b: Dfloat; a: Dfloat := 1.0 ); external 'Draw_Define_ColorA';

function  DRAW$INQUIRE_COLOR( icol: Dint; var r, g, b: Dfloat; var a: [optional] Dfloat ): Dint;
external 'Draw_Inquire_Color';

procedure DRAW$LINE_ATTR( n: Dint; r: Dfloat ); external 'Draw_Line_Attr';

procedure DRAW$MARKER_ATTR( n: Dint; r: Dfloat ); external 'Draw_Marker_Attr';

procedure DRAW$FILL_ATTR( n1, n2: Dint ); external 'Draw_Fill_Attr';

procedure DRAW$TEXT_FONT( n: Dint; tp: Dint := 0 ); external 'Draw_Text_Font';

function  DRAW$INSTALL_FONT( ifnt, istl: Dint; in_var fnam: string ): Dint; external 'Draw_Pas_Install_Font';

function  DRAW$FONT_INFO( ifnt: Dint; var fpath: string; var stl: Dint  ): Dint;
external 'Draw_Pas_Font_Info';

function  DRAW$GET_STRING_BOX( ifnt: Dint; in_var str: string; hg: Dfloat; var bx, by: Dfloat ): Dint;
external 'Draw_Pas_Get_String_Box';

procedure DRAW$TEXT_ATTR( n1, n2, n3: Dint; re: Dfloat := 1.0; rs, rd: Dfloat := 0.0 );
external 'Draw_Text_Attr';

procedure DRAW$PUSH_ATTR; external 'Draw_Push_Attr';

procedure DRAW$POP_ATTR; external 'Draw_Pop_Attr';



{**********************************************************}
{************       input Draw Routines        ************}
{**********************************************************}

procedure DRAW$MESSAGE( in_var str: string ); external 'Draw_Pas_Message';

procedure DRAW$STRING_DISPLAY( in_var str: string ); external 'Draw_Pas_Str_Dspl';

function  DRAW$GET_CHOICE( in_var title: string;
                           in_var menu: array[dim: Dint, cap: Dint] of char;
                                   nsz: Dint := 0 ): Dint; external 'Draw_Pas_Get_Arr_Choice';

function  DRAW$GET_CHOICE( in_var title: string;
                           in_var  menu: array[dim: Dint] of ^string;
                                    nsz: Dint := 0 ): Dint; external 'Draw_Pas_Get_Str_Choice';

function  DRAW$GET_CHOICE( in_var title: string;
                           in_var  menu: Choice_List; nsz: Dint := 0 ): Dint; external 'Draw_Pas_Get_M_Choice';

function  DRAW$GET_ANSWERD( in_var title: string ): Dint; external 'Draw_Pas_Get_Answerd';

function  DRAW$GET_STRING( in_var title, default: string;
                              var        value  : string ): Dint; external 'Draw_Pas_Get_String';

function  DRAW$GET_VALUE( in_var title: string; var val: Dfloat; lw, up: Dfloat ): Dint; external 'Draw_Pas_Get_Value';

function  DRAW$GET_COLOR( in_var title: string; var r, g, b: Dfloat ): Dint; external 'Draw_Pas_Get_Color';

function  DRAW$SELECT_FILE( in_var title: string;
                            in_var filtr: Choice_List;
                            in_var defst: string;
                               var resul: string;
                               var flidx: Dint;
                                   nwflg, nszfl: Dint := 0 ): Dint; external 'Draw_Pas_Select_MFile';

function  DRAW$SELECT_FILE( in_var title: string;
                            in_var filtr: array[dim: Dint] of ^string;
                            in_var defst: string;
                               var resul: string;
                               var flidx: Dint;
                                   nwflg, nszfl: Dint := 0 ): Dint; external 'Draw_Pas_Select_File';

function  DRAW$SEG_PICK( var  seg_id, pick_id: Dint ): Dint; external 'Draw_Seg_Pick';

function  DRAW$GET_POSITION( var xx, yy: Dfloat; in_epure: Dbool := true ): Dint; external 'Draw_Get_Position';

function  DRAW$GET_WINDOW( var x1, x2, y1, y2: Dfloat ): Dint; external 'Draw_Get_Window';

function  DRAW$GET_CURVE( var    pt: array[cap: Dint] of Dfloat;
                          var  rdim: Dint;
                              bplot: Dbool;
                               stfl: Dbool := false ): Dint; external 'Draw_Get_Curve';

procedure DRAW$ECHO_POSITION( cursor: Dint ); external 'Draw_Echo_Pos';

procedure DRAW$ECHO_LINE( col, md, knd: Dint; sz: Dfloat ); external 'Draw_Echo_Line';




{**********************************************************}
{************     Segment  Draw  Routines      ************}
{**********************************************************}


function  DRAW$NEW_SEG( n: Dint := -1 ): Dint; external 'Draw_New_Seg';

procedure DRAW$SEG_END; external 'Draw_Seg_End';

procedure DRAW$DEL_SEG( n: Dint ); external 'Draw_Del_Seg';

function  DRAW$UPDATE_SEG( n: Dint; fapp: Dint := 0 ): Dint; external 'Draw_Update_Seg';

procedure DRAW$INCLUDE_SEG( n: Dint ); external 'Draw_Include_Seg';

procedure DRAW$SEG_ATTR( seg_id, det, hli, vis: Dint; prior:  Dfloat ); external 'Draw_Seg_Attr';

procedure DRAW$SET_PICKID( pic_id: Dint ); external 'Draw_Set_Pickid';

function  DRAW$DETECTABLE( det_flg: Dint ): Dint; external 'Draw_Detectable';

function  DRAW$SEG_INQUIRE: Dint; external 'Draw_Seg_Inquire';

function  DRAW$PUSH_MATRIX: Dint; external 'Draw_Push_Matrix';

procedure DRAW$POP_MATRIX; external 'Draw_Pop_Matrix';

procedure DRAW$SEG_UNIT_TRANSF( iseg: Dint; update: Dint := 0 ); external 'Draw_Seg_Unit_Transf';

procedure DRAW$MAT_UNIT_TRANSF( imat: Dint; update: Dint := 0 ); external 'Draw_Mat_Unit_Transf';

procedure DRAW$TRANSF_SEG(  iseg: Dint; tx, ty, px, py, theta, scx, scy: Dfloat ); external 'Draw_Transf_Seg';

procedure DRAW$TRANSF_Mat(  imat: Dint; tx, ty, px, py, theta, scx, scy: Dfloat ); external 'Draw_Transf_Mat';

procedure DRAW$TRANSF_SEG3( iseg: Dint;  tx,  ty,  tz,  px,  py,  pz,
                                        ome, chi, psi, scx, scy, scz: Dfloat ); external 'Draw_Transf_Seg3';

procedure DRAW$TRANSF_MAT3( imat: Dint;  tx,  ty,  tz,  px,  py,  pz,
                                        ome, chi, psi, scx, scy, scz: Dfloat ); external 'Draw_Transf_Mat3';

procedure DRAW$MOVE_SEG(  iseg: Dint; tx, ty: Dfloat ); external 'Draw_Move_Seg';

procedure DRAW$MOVE_MAT(  imat: Dint; tx, ty: Dfloat ); external 'Draw_Move_Mat';

procedure DRAW$MOVE_SEG3( iseg: Dint; tx, ty, tz: Dfloat ); external 'Draw_Move_Seg3';

procedure DRAW$MOVE_MAT3( imat: Dint; tx, ty, tz: Dfloat ); external 'Draw_Move_Mat3';

procedure DRAW$ROTATE_SEG(  iseg: Dint; px, py, theta: Dfloat ); external 'Draw_Rotate_Seg';

procedure DRAW$ROTATE_MAT(  imat: Dint; px, py, theta: Dfloat ); external 'Draw_Rotate_Mat';

procedure DRAW$UROT_SEG3( iseg: Dint;  px,  py,  pz, th, ph, an: Dfloat ); external 'Draw_URot_Seg3';

procedure DRAW$UROT_MAT3( imat: Dint;  px,  py,  pz, th, ph, an: Dfloat ); external 'Draw_URot_Mat3';

procedure DRAW$ROTATE_SEG3( iseg: Dint;  px,  py,  pz, ome, chi, psi: Dfloat ); external 'Draw_Rotate_Seg3';

procedure DRAW$ROTATE_MAT3( imat: Dint;  px,  py,  pz, ome, chi, psi: Dfloat ); external 'Draw_Rotate_Mat3';

procedure DRAW$SCALE_SEG(  iseg: Dint;  px,  py, scx, scy: Dfloat ); external 'Draw_Scale_Seg';

procedure DRAW$SCALE_MAT(  imat: Dint;  px,  py, scx, scy: Dfloat ); external 'Draw_Scale_Mat';

procedure DRAW$SCALE_SEG3( iseg: Dint;  px,  py,  pz, scx, scy, scz: Dfloat ); external 'Draw_Scale_Seg3';

procedure DRAW$SCALE_MAT3( imat: Dint;  px,  py,  pz, scx, scy, scz: Dfloat ); external 'Draw_Scale_Mat3';

function  DRAW$GET_SEG_MAT( iseg: Dint; var m: DMatrix ): Dint; external 'Draw_Get_Seg_Mat';

function  DRAW$PUT_SEG_MAT( iseg: Dint; in_var m: DMatrix ): Dint; external 'Draw_Put_Seg_Mat';

function  DRAW$GET_MATRIX( imat: Dint; var m: DMatrix ): Dint; external 'Draw_Get_Matrix';

function  DRAW$PUT_MATRIX( imat: Dint; in_var m: DMatrix ): Dint; external 'Draw_Put_Matrix';

function  DRAW$SEG_ORIENTATION( iseg: Dint; px, py, pz: Dfloat; interaction: boolean := false ): Dint;
external 'Draw_Seg_Orient';

function  DRAW$MAT_ORIENTATION( imat: Dint; px, py, pz: Dfloat; interaction: boolean := false ): Dint;
external 'Draw_Mat_Orient';

function  DRAW$SEG_MOVE( iseg: Dint; interaction: boolean := false ): Dint; external 'Draw_Seg_Move';

function  DRAW$MAT_MOVE( imat: Dint; interaction: boolean := false ): Dint; external 'Draw_Mat_move';



{**********************************************************}
{************         View Draw Routines       ************}
{**********************************************************}

procedure DRAW$PIC_VIEW( flags: Dbyte := 0 );    external 'Draw_Pic_View';

procedure DRAW$PIC_RESET( flags: Dbyte := 0 );   external 'Draw_Pic_Reset';

procedure DRAW$CLIPBOX( var lim: [optional] array[lsz: Dint] of Dfloat;
                        var imd: [optional] array[msz: Dint] of Byte ); external 'Draw_Clipbox';

procedure DRAW$ALPHA_SET( flg: Dint );           external 'Draw_Alpha_Set';

procedure DRAW$LIGHT_ON_OFF( light, flg: Dint ); external 'Draw_Light_OnOff';

procedure DRAW$LIGHT_DEFINE( light, kind: Dint; in_var fparm: array[sz:Dint] of Dfloat );
external 'Draw_Light_Define';

procedure DRAW$LIGHT_DEFINE( light, kind: Dint; in_var fval: Dfloat; fvalsz: Dint := 1 );
external 'Draw_Light_Define';

procedure DRAW$MAT_LIGHT_PROP( face, kind: Dint; in_var fparm: array[sz:Dint] of Dfloat );
external 'Draw_Mat_Light_Prop';

procedure DRAW$MAT_LIGHT_PROP( face, kind: Dint; in_var fval: Dfloat; fvalsz: Dint := 1 );
external 'Draw_Mat_Light_Prop';

procedure DRAW$VIEW( dist: Dfloat := 0.0 ); external 'Draw_View';

procedure DRAW$ZOOM;                 external 'Draw_Zoom';

procedure DRAW$SCALE;                external 'Draw_Scale';

procedure DRAW$RELOAD( flg: Dbool ); external 'Draw_Reload';

procedure DRAW$REFRESH;              external 'Draw_Refresh';

procedure DRAW$GRID( flg: Dbool );   external 'Draw_Grid';

procedure DRAW$PRINT;                external 'Draw_Print';



{**********************************************************}
{************       Axis  Draw  Routines       ************}
{**********************************************************}

function  DRAW$NEW_AXIS( in_var u_axis, v_axis: Dpoint3; length, vinf, vsup: Dfloat; ntck, flags: Dint := 0 ): Dint;
external 'Draw_New_Axis';


function  DRAW$NEW_BOX( in_var org: Dpoint3; ix, iy, iz: Dint;
                        in_var dtb: array[sz: Dint] of Dint;
                               stb: $wild_pointer := nil; nf, sz1, sz2: Dint := 0 ): Dint;
external 'Draw_New_Box';


function  DRAW$NEW_BOX( in_var org: Dpoint3; ix, iy, iz: Dint;
                        in_var dtb: array[sz: Dint] of Dint;
                        in_var stb: array[nf: Dint] of Dfloat;
                               dtbsz, stbsz: Dint := 0 ): Dint;
external 'Draw_New_Box';


function  DRAW$EASY_BOX_2D( ox, oy, sx, sy, mx1, mx2, my1, my2: Dfloat;
                            in_var ux, uy: [optional] string; ns: Dint := 0 ): Dint;
external 'Draw_Easy_Box_2D';


procedure DRAW$FREE_BOX( ib: Dint; axflg: Dbool := false );
external 'Draw_Free_Box';


procedure DRAW$FREE_BOX_LIST;
external 'Draw_Free_Box_List';



procedure DRAW$SET_AXIS_VALUE( ia, cd,  n: Dint; in_var p1, p2, p3, p4: [optional] Dfloat;
                                                 in_var p5, p6, p7:     [optional] Dint );
external 'Draw_Set_Axis_Value';

procedure DRAW$GET_AXIS_VALUE( ia, cd,  n: Dint; var p1, p2, p3, p4: [optional] Dfloat;
                                                 var p5, p6, p7:     [optional] Dint );
external 'Draw_Get_Axis_Value';

procedure DRAW$SET_AXIS_TICKS( ia, n, nt: Dint );
external 'Draw_Set_Axis_Ticks';

procedure DRAW$SET_AXIS_TICKS( ia, n, nt: Dint; in_var tfre: array[$sf:Dint] of Dint;
                                                in_var tknd: array[$sk:Dint] of Dint;
                                                in_var tsiz: array[$sl:Dint] of Dfloat );
external 'Draw_Set_Axis_Ticks';

function  DRAW$GET_AXIS_TICKS( ia, n, nt: Dint ): Dint;
external 'Draw_Get_Axis_Ticks';

function  DRAW$GET_AXIS_TICKS( ia, n, nt: Dint; var tfre: array[$sf:Dint] of Dint;
                                                var tknd: array[$sk:Dint] of Dint;
                                                var tsiz: array[$sl:Dint] of Dfloat ): Dint;
external 'Draw_Get_Axis_Ticks';

procedure DRAW$SET_AXIS_UNIT( ia: Dint; in_var unit: string );
external 'Draw_Set_Axis_Unit';

function  DRAW$GET_AXIS_UNIT( ia: Dint; var unit: string ): Dint;
external 'Draw_Get_Axis_Unit';

procedure DRAW$SET_AXIS_FLAGS( io, flg: Dint );
external 'Draw_Set_Axis_Flags';

function  DRAW$GET_AXIS_FLAGS( io: Dint ): Dint;
external 'Draw_Get_Axis_Flags';

function  DRAW$GET_BOX_VALUE( box, cd: Dint; var itb: array[sz: Dint] of Dint ): Dint;
external 'Draw_Get_Box_Value';

function  DRAW$GET_BOX_VALUE( box, cd: Dint; var ftb: array[sz: Dint] of Dfloat ): Dint;
external 'Draw_Get_Box_Value';

procedure DRAW$PLOT_AXIS( ia: Dint; in_var org: Dpoint3; fvl: Dint );
external 'Draw_Plot_Axis';

procedure DRAW$PLOT_BOX( ib: Dint );
external 'Draw_Plot_Box';


procedure DRAW$OPEN_BOX( ib: Dint );
external 'Draw_Open_Box';


procedure DRAW$CLOSE_BOX;
external 'Draw_Close_Box';


function  DRAW$CONV_BOX( tbox: Dbool; xd, yd, zd: Dfloat; var xr, yr, zr: Dfloat ): Dint;
external 'Draw_CV_Box';




{**********************************************************}
{************      Pannel  Draw  Routines      ************}
{**********************************************************}


procedure DRAW$PANNEL_ATTR( id, aln: Dint ); external 'Draw_Pannel_Align';

procedure DRAW$PANNEL_ATTR( id: Dint; lbf: Dbool; sz: Dfloat ); external 'Draw_Pannel_Fsize';

procedure DRAW$PANNEL_ATTR( id: Dint; lbf: Dbool; in_var nam: string; opt: Dint ); external 'Draw_Pas_Pannel_Font';

function  DRAW$PANNEL_CREATE( w, h: Dfloat; in_var t: string ): Dint; external 'Draw_Pas_Pannel_Create';

function  DRAW$PANNEL_ADD( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                           var bv: Dbool ): Dint; external 'Draw_Pas_Pannel_B_Item';

function  DRAW$PANNEL_ADD( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                           var ev: Dint; choice: Choice_List; min: Dint := 1 ): Dint; external 'Draw_Pas_Pannel_E_Item';

function  DRAW$PANNEL_ADD_E1( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                              var ev: Dint;
                              in_var choice: array[dim: Dint, cap: Dint] of char;
                              nsz: Dint; min: Dint := 1 ): Dint; external 'Draw_Pas_Pannel_E1_Item';

function  DRAW$PANNEL_ADD( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                           var sv: string; edi: Dbool := true ): Dint; external 'Draw_Pas_Pannel_S_Item';

function  DRAW$PANNEL_ADD( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                           var iv: Dint; min, max: Dint ): Dint; external 'Draw_Pas_Pannel_I_Item';

function  DRAW$PANNEL_ADD( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                           var fv: Dfloat; min, max, step: Dfloat ): Dint; external 'Draw_Pas_Pannel_F_Item';

function  DRAW$PANNEL_ADD_TEXT( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                                in_var txt: array[sz: Dint] of char ): Dint; external 'Draw_Pas_Pannel_Text_Item';

function  DRAW$PANNEL_ADD_FRAME( ide: Dint; x, y, w, h: Dfloat; in_var lab: string;
                                 flw: Dfloat := 0.0; stl: Dint := 0 ): Dint; external 'Draw_Pas_Pannel_Frame_Item';

function  DRAW$PANNEL_CHANGE( ide, itm: Dint ): Dint; external 'Draw_Pannel_Change';

function  DRAW$PANNEL_NEW_TEXT( ide, itm: Dint; in_var txt: array[sz: Dint] of char ): Dint;
external 'Draw_Pas_Pannel_New_Text';

function  DRAW$PANNEL_ENADIS( ide, itm: Dint ): Dint; external 'Draw_Pannel_EnaDis';

procedure DRAW$PANNEL_DELETE( ide: Dint ); external 'Draw_Pannel_Delete';

procedure DRAW$PANNEL_OPEN( ide: Dint ); external 'Draw_Pannel_Open';

procedure DRAW$PANNEL_CLOSE( ide: Dint ); external 'Draw_Pannel_Close';

function  DRAW$PANNEL_GET( ide: Dint ): Dint; external 'Draw_Pannel_Get';

function  DRAW$PANNEL_PUT( ide: Dint ): Dint; external 'Draw_Pannel_Put';

function  DRAW$PANNEL_REQUEST( ide: Dint ): Dint; external 'Draw_Pannel_Request';


(*
end.
*)
