/*  P A S - P. WOLFERS SOFTWARE: V3.0-A OF 31-OCT-2014 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 736 ) = {
 15,  15, 100, 105, 115, 112, 108,  97, 121,  95, 115, 117, 114, 102,  97,  99,
101,  68,  68,  47, 104, 111, 109, 101,  47, 112, 105, 101, 114, 114, 101,  47,
 83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,  95, 115,
114,  99,  95,  86,  49,  46,  53,  67,  45,  98,  97, 115, 101,  47,  68, 114,
 97, 119,  95,  69, 120,  97, 109, 112, 108, 101, 115,  47,  47, 101, 115, 115,
117, 114, 102,  46, 112,  97, 115,  28,  28,  90,  32,  61,  32,  69, 120, 112,
 40,  32,  45,  32,  53,  42,  40,  32, 120,  94,  50,  32,  43,  32, 121,  94,
 50,  32,  41,  32,  41,   7,   7,  32,  79, 109, 101,  32,  61,  32,   8,   8,
 44,  32,  67, 104, 105,  32,  61,  32,   8,   8,  44,  32,  80, 104, 105,  32,
 61,  32,  18,  18,  32,  67, 114, 101,  97, 116, 101,  32,  83, 101, 103, 109,
101, 110, 116,  32,  35,  32,  55,  55,  32,  84, 104, 101,  32,  70, 105, 103,
117, 114, 101,  32,  99,  97, 110,  32,  98, 101,  32, 114, 111, 116,  97, 116,
101, 100,  32, 119, 105, 116, 104,  32, 116, 104, 101,  32, 109, 111, 117, 115,
101,  32,  40,  98, 121,  32, 100, 101, 102,  97, 117, 108, 116,  41,  46,   0,
  0,   0, 128,  63,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0,   0,   0,   0,   0, 128,  63,
  0,   0,   0,   0,   0,   0, 128, 191,   0,   0,   0,   0,   0,   0, 128, 191,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0, 128,  63,   0,   0,   0,   0,   6,   6,  67, 109,  32,  40,  88,  41,
  6,   6,  67, 109,  32,  40,  89,  41,   8,   8,  71,  97, 117, 115, 115, 105,
 97, 110,   0,   0, 205, 204, 204, 190, 205, 204,  76,  63,   3,   0,   0,   0,
  5,   0,   0,   0,   2,   0,   0,   0,   0,   0,  16, 193,   0,   0,   0,  64,
  7,   0,   0,   0,   0,   0,  52,  67, 205, 204, 204, 190, 205, 204,  76,  63,
  3,   0,   0,   0,   5,   0,   0,   0,   2,   0,   0,   0,   0,   0,  52,  67,
  7,   0,   0,   0,   3,   0,   0,   0,   5,   0,   0,   0,   2,   0,   0,   0,
  7,   0,   0,   0,   0,   0,  32, 193,   0,   0,  32, 193,   0,   0, 160, 192,
 20,  20, 117, 112, 100,  97, 116, 101,  95,  97, 110, 103, 108, 101,  95, 100,
105, 115, 112, 108,  97, 121,   7,   7,  32,  79, 109, 101,  32,  61,  32,   8,
  8,  44,  32,  67, 104, 105,  32,  61,  32,   8,   8,  44,  32,  80, 104, 105,
 32,  61,  32,  11,  11, 114, 111, 116,  97, 116, 101,  95, 112, 108, 111, 116,
 13,  13, 117, 112, 100,  97, 116, 101,  95,  97, 110, 103, 108, 101, 115,  13,
 13, 101, 115, 115,  97, 105,  95, 115, 117, 114, 102,  97,  99, 101,   7,   7,
 38,  82, 111, 116,  97, 116, 101,   6,   6,  38,  79, 109, 101, 103,  97,   4,
  4,  38,  67, 104, 105,   4,   4,  38,  80, 104, 105,   5,   5,  38,  68, 105,
115, 116,  13,  13,  69, 115, 115,  97, 105,  32,  71, 114,  97, 112, 104, 105,
 99,   5,   5, 120, 115,  32,  61,  32,   8,   8,  32,  32,  32, 121, 115,  32,
 61,  32,  10,  10,  32,  32,  32, 117, 110, 105, 116,  32,  61,  32,  18,  18,
 83, 117, 114, 102,  97,  99, 101,  32,  71,  97, 117, 115, 115, 105, 101, 110,
110, 101,  20,  20,  32,  68, 105,  97, 108, 111, 103, 117, 101,  32,  97, 110,
115, 119, 101, 114, 100,  32,  61,  32,  20,  20,  69, 117, 108, 101, 114, 105,
 97, 110,  32,  65, 110, 103, 108, 101,  32,  79, 109, 101, 103,  97,  18,  18,
 69, 117, 108, 101, 114, 105,  97, 110,  32,  65, 110, 103, 108, 101,  32,  67,
104, 105,  18,  18,  69, 117, 108, 101, 114, 105,  97, 110,  32,  65, 110, 103,
108, 101,  32,  80, 104, 105,  16,  16,  68, 105, 115, 116,  97, 110,  99, 101,
 32, 111, 102,  32,  86, 105, 101, 119,  22,  22,  32,  69, 110, 100,  32, 111,
102,  32,  69, 115, 115,  97, 105,  32,  83, 117, 114, 102,  97,  99, 101,  46
};

/* Define the local static Initialized section. */
static Blk( Ri, 288 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 31280 );

/* Declaration of external variables. */
extern V PAS__f_output;


/* Function/procedure prototypes. */
void Draw_End();
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id, SL F_ky);
UB Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
SL Draw_Dialog(SL F_flags);
void Draw_Out_Mode(SL F_n);
void Draw_Plot3(F F_x, F F_y, F F_z, UB F_ipen);
void Draw_Pas_String(F F_x, F F_y, F F_theta, F F_high, V F_str, SL F_oflg);
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Line_Attr(SL F_n, F F_r);
void Draw_Fill_Attr(SL F_n1, SL F_n2);
void Draw_Text_Font(SL F_n, SL F_tp);
void Draw_Text_Attr(SL F_n1, SL F_n2, SL F_n3, F F_re, F F_rs, F F_rd);
SL Draw_Pas_Get_Value(V F_title, F *F_val, F F_lw, F F_up);
SL Draw_New_Seg(SL F_n);
void Draw_Seg_End();
SL Draw_Update_Seg(SL F_n, SL F_fapp);
void Draw_Seg_Unit_Transf(SL F_iseg, SL F_update);
void Draw_Rotate_Seg3(SL F_iseg, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
SL Draw_Get_Seg_Mat(SL F_iseg, V F_m);
SL Draw_Seg_Orient(SL F_iseg, F F_px, F F_py, F F_pz, UB F_interaction);
void Draw_View(F F_dist);
SL Draw_New_Axis(V F_u_axis, V F_v_axis, F F_length, F F_vinf, F F_vsup, SL F_ntck
, SL F_flags);
SL Draw_New_Box(V F_org, SL F_ix, SL F_iy, SL F_iz, V F_dtb, SL F_sz, V F_stb, SL
F_nf, SL F_sz1, SL F_sz2);
void Draw_Set_Axis_Value(SL F_ia, SL F_cd, SL F_n, F *F_p1, F *F_p2, F *F_p3, F *
F_p4, SL *F_p5, SL *F_p6, SL *F_p7);
void Draw_Set_Axis_Unit(SL F_ia, V F_unit);
void Draw_Plot_Box(SL F_ib);
void Draw_Open_Box(SL F_ib);
void Draw_Close_Box();


/* Procedure/Function : " display_surface "  */
void ESSAI_SFACE_display_surface(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  SL Rv2;
  F Rv3;
  F Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=48; /* line # 48 */
  Draw_View(Ri.f[0]);
  Ra.sl[6]=50; /* line # 50 */
  Draw_Text_Attr(3,5,1, (F)1.000000E+00, (F)0.000000E-01, (F)0.000000E-01);
  Ra.sl[6]=51; /* line # 51 */
  Draw_Text_Font(3,0);
  Ra.sl[6]=52; /* line # 52 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.300000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Rd.s+87,0);
  Ra.sl[6]=54; /* line # 54 */
  Ri.sl[1]=Draw_New_Seg(2);
  Ra.sl[6]=56; /* line # 56 */
  Ri.f[2]=(F)9.000000E+01;
  Ri.f[3]=(F)8.000000E+01;
  Ri.f[4]=(F)-4.000000E+01;
  Ra.sl[6]=58; /* line # 58 */
  PAS__VWRITE_INIT(Ri.s+20,1);
  PAS__WRITE_STR(Rd.s+117,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[2],8,2,0);
  PAS__WRITE_STR(Rd.s+126,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[3],8,3,0);
  PAS__WRITE_STR(Rd.s+136,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[4],8,3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=59; /* line # 59 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.500000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Ri.s+20,0);
  Ra.sl[6]=61; /* line # 61 */
  Draw_Seg_End();
  Ra.sl[6]=63; /* line # 63 */
  Ri.sl[70]=Draw_New_Seg(3);
  Ra.sl[6]=64; /* line # 64 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+146,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[70],3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=66; /* line # 66 */
  Draw_Rotate_Seg3(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, Ri
  .f[2],Ri.f[3],Ri.f[4]);
  Ra.sl[6]=67; /* line # 67 */
  Draw_Seg_Orient(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=69; /* line # 69 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+166,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=111; /* line # 111 */
  Rs.sl[0]=Draw_New_Axis(Rd.s+224,Rd.s+236,(F)2.000000E+01, (F)-1.000000E+00, (F)
1.000000E+00,-3,2097152);
  Ra.sl[6]=113; /* line # 113 */
  Rs.sl[1]=Draw_New_Axis(Rd.s+248,Rd.s+260,(F)2.000000E+01, (F)-1.000000E+00, (F)
1.000000E+00,-3,2097152);
  Ra.sl[6]=115; /* line # 115 */
  Rs.sl[2]=Draw_New_Axis(Rd.s+272,Rd.s+284,(F)2.000000E+01, (F)0.000000E-01, (F)
1.000000E+00,-3,1536);
  Ra.sl[6]=119; /* line # 119 */
  Draw_Set_Axis_Unit(Rs.sl[0],Rd.s+296);
  Ra.sl[6]=120; /* line # 120 */
  Draw_Set_Axis_Unit(Rs.sl[1],Rd.s+304);
  Ra.sl[6]=121; /* line # 121 */
  Draw_Set_Axis_Unit(Rs.sl[2],Rd.s+312);
  Ra.sl[6]=126; /* line # 126 */
  Draw_Set_Axis_Value(Rs.sl[0],2,124, NULL, NULL, Rd.f+81,Rd.f+82,Rd.sl+83,Rd.sl+
84,Rd.sl+85);
  Ra.sl[6]=127; /* line # 127 */
  Draw_Set_Axis_Value(Rs.sl[0],4,16, NULL, NULL, Rd.f+86,Rd.f+87,Rd.sl+88,NULL, NULL);
  Ra.sl[6]=128; /* line # 128 */
  Draw_Set_Axis_Value(Rs.sl[1],2,126, NULL, Rd.f+89,Rd.f+90,Rd.f+91,Rd.sl+92,Rd.
  sl+93,Rd.sl+94);
  Ra.sl[6]=129; /* line # 129 */
  Draw_Set_Axis_Value(Rs.sl[1],4,18, NULL, Rd.f+95,NULL, NULL, Rd.sl+96,NULL, NULL);
  Ra.sl[6]=130; /* line # 130 */
  Draw_Set_Axis_Value(Rs.sl[2],2,112, NULL, NULL, NULL, NULL, Rd.sl+97,Rd.sl+98,
  Rd.sl+99);
  Ra.sl[6]=131; /* line # 131 */
  Draw_Set_Axis_Value(Rs.sl[2],4,16, NULL, NULL, NULL, NULL, Rd.sl+100,NULL, NULL);
  Ra.sl[6]=133; /* line # 133 */
  Rs.sl[3]=5;
  Ra.sl[6]=135; /* line # 135 */
  Rs.sl[4]=14;
  Ra.sl[6]=137; /* line # 137 */
  Rs.sl[5]=2090;
  Ra.sl[6]=139; /* line # 139 */
  Rs.sl[6]=4161;
  Ra.sl[6]=142; /* line # 142 */
  Rs.sl[7]=7;
  Ra.sl[6]=145; /* line # 145 */
  Rs.sl[8]=Draw_New_Box(Rd.s+404,Rs.sl[0],Rs.sl[1],Rs.sl[2],Rs.s+12,5,NULL,0,0,0);
  Ra.sl[6]=147; /* line # 147 */
  Draw_Line_Attr(1, (F)2.000000E+00);
  Ra.sl[6]=149; /* line # 149 */
  Draw_Plot_Box(Rs.sl[8]);
  Ra.sl[6]=151; /* line # 151 */
  Draw_Line_Attr(1, (F)1.000000E+00);
  Ra.sl[6]=153; /* line # 153 */
  Draw_Open_Box(Rs.sl[8]);
  Ra.sl[6]=155; /* line # 155 */
  Draw_Out_Mode(1);
  Ra.sl[6]=158; /* line # 158 */
  Rv0=-25;
  for( Rf1=51;Rf1>0;Rf1-- ) {
    Ra.sl[6]=160; /* line # 160 */
    Rv1=(float)Rv0/(F)2.500000E+01;
    Ra.sl[6]=161; /* line # 161 */
    Rv2=-25;
    for( Rf0=51;Rf0>0;Rf0-- ) {
      Ra.sl[6]=163; /* line # 163 */
      Rv3=(float)Rv2/(F)2.500000E+01;
      Ra.sl[6]=164; /* line # 164 */
      Rv4=exp( -(PAS__IFPOWER(Rv1,2)+PAS__IFPOWER(Rv3,2))*(F)5.000000E+00);
      Ra.sl[6]=165; /* line # 165 */
      Rs.f[Rv0*153+Rv2*3+3909]=Rv1;
      Ra.sl[6]=166; /* line # 166 */
      Rs.f[Rv0*153+Rv2*3+3910]=Rv3;
      Ra.sl[6]=167; /* line # 167 */
      Rs.f[Rv0*153+Rv2*3+3911]=Rv4;
      Rv2++;
    }
    Rv0++;
  }
  Ra.sl[6]=184; /* line # 184 */
  Draw_Set_ColorA((F)3.000000E-01, (F)5.000000E-01, (F)7.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=185; /* line # 185 */
  Draw_Fill_Attr(2,1);
  Ra.sl[6]=188; /* line # 188 */
  Draw_Out_Mode(-5);
  Ra.sl[6]=190; /* line # 190 */
  Rv5=-25;
  for( Rf1=50;Rf1>0;Rf1-- ) {
    Ra.sl[6]=192; /* line # 192 */
    Draw_Plot3(Rs.f[Rv5*153+3834],Rs.f[Rv5*153+3835],Rs.f[Rv5*153+3836],0);
    Ra.sl[6]=193; /* line # 193 */
    Rv6=-25;
    for( Rf0=50;Rf0>0;Rf0-- ) {
      Ra.sl[6]=195; /* line # 195 */
      Draw_Plot3(Rs.f[(Rv5+1)*153+Rv6*3+3909],Rs.f[(Rv5+1)*153+Rv6*3+3910],Rs.f[
      (Rv5+1)*153+Rv6*3+3911],1);
      Ra.sl[6]=196; /* line # 196 */
      Draw_Plot3(Rs.f[Rv5*153+(Rv6+1)*3+3909],Rs.f[Rv5*153+(Rv6+1)*3+3910],Rs.f[
      Rv5*153+(Rv6+1)*3+3911],1);
      Rv6++;
    }
    Ra.sl[6]=198; /* line # 198 */
    Draw_Plot3(Rs.f[(Rv5+1)*153+3984],Rs.f[(Rv5+1)*153+3985],Rs.f[(Rv5+1)*153+3986]
    ,1);
    Rv5++;
  }
  Ra.sl[6]=200; /* line # 200 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=202; /* line # 202 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)1.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=203; /* line # 203 */
  Draw_Fill_Attr(1,1);
  Ra.sl[6]=204; /* line # 204 */
  Draw_Out_Mode(-5);
  Ra.sl[6]=206; /* line # 206 */
  Rv7=-25;
  for( Rf1=50;Rf1>0;Rf1-- ) {
    Ra.sl[6]=208; /* line # 208 */
    Draw_Plot3(Rs.f[Rv7*153+3834],Rs.f[Rv7*153+3835],Rs.f[Rv7*153+3836],0);
    Ra.sl[6]=209; /* line # 209 */
    Rv8=-25;
    for( Rf0=50;Rf0>0;Rf0-- ) {
      Ra.sl[6]=211; /* line # 211 */
      Draw_Plot3(Rs.f[(Rv7+1)*153+Rv8*3+3909],Rs.f[(Rv7+1)*153+Rv8*3+3910],Rs.f[
      (Rv7+1)*153+Rv8*3+3911],1);
      Ra.sl[6]=212; /* line # 212 */
      Draw_Plot3(Rs.f[Rv7*153+(Rv8+1)*3+3909],Rs.f[Rv7*153+(Rv8+1)*3+3910],Rs.f[
      Rv7*153+(Rv8+1)*3+3911],1);
      Rv8++;
    }
    Ra.sl[6]=214; /* line # 214 */
    Draw_Plot3(Rs.f[(Rv7+1)*153+3984],Rs.f[(Rv7+1)*153+3985],Rs.f[(Rv7+1)*153+3986]
    ,1);
    Rv7++;
  }
  Ra.sl[6]=216; /* line # 216 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=218; /* line # 218 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)1.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=219; /* line # 219 */
  Draw_Out_Mode(1);
  Ra.sl[6]=240; /* line # 240 */
  Draw_Close_Box();
  Ra.sl[6]=241; /* line # 241 */
  Draw_Seg_End();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " update_angle_display "  */
void ESSAI_SFACE_update_angle_diplay(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+416;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=247; /* line # 247 */
  Draw_Update_Seg(Ri.sl[1],0);
  Ra.sl[6]=248; /* line # 248 */
  PAS__VWRITE_INIT(Ri.s+20,1);
  PAS__WRITE_STR(Rd.s+438,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[2],8,2,0);
  PAS__WRITE_STR(Rd.s+447,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[3],8,3,0);
  PAS__WRITE_STR(Rd.s+457,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[4],8,3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=249; /* line # 249 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.500000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Ri.s+20,0);
  Ra.sl[6]=250; /* line # 250 */
  Draw_Seg_End();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rotate_plot "  */
void ESSAI_SFACE_rotate_plot(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+467;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=261; /* line # 261 */
  Rv0=(F)1.745329E-02*Ri.f[2];
  Rv1=(F)1.745329E-02*Ri.f[3];
  Rv2=(F)1.745329E-02*Ri.f[4];
  Ra.sl[6]=262; /* line # 262 */
  Rv3=cos(Rv0);
  Rv4=sin(Rv0);
  Ra.sl[6]=263; /* line # 263 */
  Rv5=cos(Rv1);
  Rv6=sin(Rv1);
  Ra.sl[6]=264; /* line # 264 */
  Rv7=cos(Rv2);
  Rv8=sin(Rv2);
  Ra.sl[6]=266; /* line # 266 */
  ESSAI_SFACE_update_angle_diplay();
  Ra.sl[6]=268; /* line # 268 */
  Draw_View(Ri.f[0]);
  Ra.sl[6]=269; /* line # 269 */
  Draw_Seg_Unit_Transf(Ri.sl[70],0);
  Ra.sl[6]=270; /* line # 270 */
  Draw_Rotate_Seg3(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, Ri
  .f[2],Ri.f[3],Ri.f[4]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " update_angles "  */
void ESSAI_SFACE_update_angles(){
  /* Define the automatic variable space. */
  Blk( Ra, 80 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  register F Rgf;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+480;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=301; /* line # 301 */
  Rv0=Draw_Get_Seg_Mat(Ri.sl[70],Ra.s+28);
  Ra.sl[6]=302; /* line # 302 */
  if (Rv0>0) {
    Ra.sl[6]=308; /* line # 308 */
    Rv1=Ra.f[17];
    Ra.sl[6]=309; /* line # 309 */
    Rv2=sqrt((F)1.000000E+00-Rv1*Rv1);
    Ra.sl[6]=310; /* line # 310 */
    if (fabs(Rv2)<(F)1.000000E-05) {
      Ra.sl[6]=312; /* line # 312 */
      Ri.f[2]=(F)0.000000E-01;
      Ra.sl[6]=313; /* line # 313 */
      if (Rv1>(F)0.000000E-01) Ri.f[3]=(F)0.000000E-01;
      else {
        Ra.sl[6]=314; /* line # 314 */
        Ri.f[3]=(F)1.800000E+02;
      }
      Ra.sl[6]=315; /* line # 315 */
      Ri.f[4]=atan2(Ra.f[8]/Rv1, -Ra.f[7]/Rv1)/(F)1.745329E-02;
    }
    else {
      Ra.sl[6]=319; /* line # 319 */
      Rv3= -Ra.f[15]/Rv2;
      Ra.sl[6]=320; /* line # 320 */
      Rv4=Ra.f[16]/Rv2;
      Ra.sl[6]=321; /* line # 321 */
      Rv5=Ra.f[9]/Rv2;
      Ra.sl[6]=322; /* line # 322 */
      Rv6=Ra.f[13]/Rv2;
      Ra.sl[6]=323; /* line # 323 */
      Ri.f[2]=atan2(Rv6,Rv5)/(F)1.745329E-02;
      Ra.sl[6]=324; /* line # 324 */
      Ri.f[4]=atan2(Rv4,Rv3)/(F)1.745329E-02;
      Ra.sl[6]=325; /* line # 325 */
      Ri.f[3]=acos(Rv1)/(F)1.745329E-02;
    }
    Ra.sl[6]=327; /* line # 327 */
    ESSAI_SFACE_update_angle_diplay();
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " essai_surface "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[3906]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+31248;
  Rs.v[3907]=Rd.s+495;
  Rs.v[3908]=Rd.s+17;
  Rs.sl[7818]=364; /* line # 364 */
  Draw_Pas_Set_Menu_Spc(2, NULL,-1,0);
  Rs.sl[7818]=365; /* line # 365 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+510,-1,0);
  Rs.sl[7818]=366; /* line # 366 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+519,-1,0);
  Rs.sl[7818]=367; /* line # 367 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+527,-1,0);
  Rs.sl[7818]=368; /* line # 368 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+533,-1,0);
  Rs.sl[7818]=369; /* line # 369 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+539,-1,0);
  Rs.sl[7818]=370; /* line # 370 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Rs.sl[7818]=371; /* line # 371 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1,0);
  Rs.sl[7818]=373; /* line # 373 */
  Draw_Pas_Init(&Rv0, &Rv1, &Rv2, Rd.s+546);
  Rs.sl[7818]=374; /* line # 374 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+561,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_STR(Rd.s+568,-1,-1,32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_STR(Rd.s+578,-1,-1,32);
  PAS__WRITE_INT(Rv2,12,0);
  PAS__WRITE_EOLN();
  Rs.sl[7818]=377; /* line # 377 */
  Rv3=1;
  Rs.sl[7818]=378; /* line # 378 */
  Rv4=1;
  Rs.sl[7818]=379; /* line # 379 */
  Rv5=Draw_Pas_Picture_3D(Rd.s+590,(F)4.800000E+01, (F)3.600000E+01, (F)4.800000E+01,
  Rv3, Rv4);
  Rs.sl[7818]=384; /* line # 384 */
  ESSAI_SFACE_display_surface();
  while (1){
    Rs.sl[7818]=387; /* line # 387 */
    Rv6=Draw_Dialog(3);
    Rs.sl[7818]=388; /* line # 388 */
    if (Rv6==100000) ESSAI_SFACE_update_angles();
    else {
      Rs.sl[7818]=391; /* line # 391 */
      if (Rv6>=1) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+610,-1,-1,32);
        PAS__WRITE_INT(Rv6,0,0);
        PAS__WRITE_EOLN();
      }
      else {
        Rs.sl[7818]=392; /* line # 392 */
        if (Rv6<0) goto L_l_0;
      }
      Rs.sl[7818]=393; /* line # 393 */
      switch (Rv6) {
        case 1:Rs.sl[7818]=396; /* line # 396 */
        Rv7=Draw_Pas_Get_Value(Rd.s+632,Ri.f+2,(F)-1.800000E+02, (F)1.800000E+02);
        Rs.sl[7818]=397; /* line # 397 */
        if (Rv7!=1) Ri.f[2]=(F)9.000000E+01;
        Rs.sl[7818]=398; /* line # 398 */
        ESSAI_SFACE_rotate_plot();
        break;
        case 2:Rs.sl[7818]=403; /* line # 403 */
        Rv7=Draw_Pas_Get_Value(Rd.s+654,Ri.f+3,(F)-1.800000E+02, (F)1.800000E+02);
        Rs.sl[7818]=404; /* line # 404 */
        if (Rv7!=1) Ri.f[3]=(F)8.000000E+01;
        Rs.sl[7818]=405; /* line # 405 */
        ESSAI_SFACE_rotate_plot();
        break;
        case 3:Rs.sl[7818]=410; /* line # 410 */
        Rv7=Draw_Pas_Get_Value(Rd.s+674,Ri.f+4,(F)-1.800000E+02, (F)1.800000E+02);
        Rs.sl[7818]=411; /* line # 411 */
        if (Rv7!=1) Ri.f[4]=(F)-4.000000E+01;
        Rs.sl[7818]=412; /* line # 412 */
        ESSAI_SFACE_rotate_plot();
        break;
        case 4:Rs.sl[7818]=417; /* line # 417 */
        Rv7=Draw_Pas_Get_Value(Rd.s+694,Ri.f,(F)0.000000E-01, (F)5.000000E+02);
        Rs.sl[7818]=418; /* line # 418 */
        if (Rv7!=1) Ri.f[0]=(F)0.000000E-01;
        Rs.sl[7818]=419; /* line # 419 */
        ESSAI_SFACE_rotate_plot();
        break;
      }
    }
    if (Rv6==0)  break;
  }
L_l_0:
  Rs.sl[7818]=426; /* line # 426 */
  Draw_End();
  Rs.sl[7818]=427; /* line # 427 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+712,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[3906];
  PAS__EXIT( 0 );
}
