/*  P A S - P. WOLFERS SOFTWARE: V2.0-4 OF 15-OCT-2006 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 672 ) = {
 15,  15, 100, 105, 115, 112, 108,  97, 121,  95, 115, 117, 114, 102,  97,  99,
101,  77,  77,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,
 95, 116,  99, 115, 104,  47,  83, 111, 102, 116,  47, 102, 108, 116, 107,  95,
115, 101, 114, 118, 101, 114,  95, 115, 114,  99,  95,  86,  48,  46,  57,  66,
 47,  76, 105, 110, 117, 120,  95, 120,  56,  54,  95,  54,  52,  95,  98, 105,
110,  95, 107, 105, 116,  47, 101, 115, 115, 117, 114, 102,  46, 112,  97, 115,
 28,  28,  90,  32,  61,  32,  69, 120, 112,  40,  32,  45,  32,  53,  42,  40,
 32, 120,  94,  50,  32,  43,  32, 121,  94,  50,  32,  41,  32,  41,   7,   7,
 32,  79, 109, 101,  32,  61,  32,   8,   8,  44,  32,  67, 104, 105,  32,  61,
 32,   8,   8,  44,  32,  80, 104, 105,  32,  61,  32,  18,  18,  32,  67, 114,
101,  97, 116, 101,  32,  83, 101, 103, 109, 101, 110, 116,  32,  35,  32,  55,
 55,  32,  84, 104, 101,  32,  70, 105, 103, 117, 114, 101,  32,  99,  97, 110,
 32,  98, 101,  32, 114, 111, 116,  97, 116, 101, 100,  32, 119, 105, 116, 104,
 32, 116, 104, 101,  32, 109, 111, 117, 115, 101,  32,  40,  98, 121,  32, 100,
101, 102,  97, 117, 108, 116,  41,  46,   0,   0, 128,  63,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 128,  63,   0,   0, 128,  63,
  0,   0,   0,   0,   0,   0, 128,  63,   0,   0,   0,   0,   0,   0, 128, 191,
  0,   0,   0,   0,   0,   0, 128, 191,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0, 128,  63,   0,   0, 128,  63,   0,   0, 128,  63,   0,   0,   0,   0,
  6,   6,  67, 109,  32,  40,  88,  41,   6,   6,  67, 109,  32,  40,  89,  41,
  8,   8,  71,  97, 117, 115, 115, 105,  97, 110,   0,   0,   4,   0,   0,   0,
  5,   0,   0,   0,   2,   0,   0,   0,   0,   0,  52,  67,   4,   0,   0,   0,
  5,   0,   0,   0,   2,   0,   0,   0,   0,   0,  52,  67,   4,   0,   0,   0,
  5,   0,   0,   0,   2,   0,   0,   0,   0,   0,  32, 193,   0,   0,  32, 193,
  0,   0, 160, 192,  11,  11, 114, 111, 116,  97, 116, 101,  95, 112, 108, 111,
116,   7,   7,  32,  79, 109, 101,  32,  61,  32,   8,   8,  44,  32,  67, 104,
105,  32,  61,  32,   8,   8,  44,  32,  80, 104, 105,  32,  61,  32,  13,  13,
101, 115, 115,  97, 105,  95, 115, 117, 114, 102,  97,  99, 101,   7,   7,  38,
 82, 111, 116,  97, 116, 101,   6,   6,  38,  79, 109, 101, 103,  97,   4,   4,
 38,  67, 104, 105,   4,   4,  38,  80, 104, 105,   5,   5,  38,  68, 105, 115,
116,  13,  13,  69, 115, 115,  97, 105,  32,  71, 114,  97, 112, 104, 105,  99,
  5,   5, 120, 115,  32,  61,  32,   8,   8,  32,  32,  32, 121, 115,  32,  61,
 32,  10,  10,  32,  32,  32, 117, 110, 105, 116,  32,  61,  32,  18,  18,  83,
117, 114, 102,  97,  99, 101,  32,  71,  97, 117, 115, 115, 105, 101, 110, 110,
101,  20,  20,  32,  68, 105,  97, 108, 111, 103, 117, 101,  32,  97, 110, 115,
119, 101, 114, 100,  32,  61,  32,  20,  20,  69, 117, 108, 101, 114, 105,  97,
110,  32,  65, 110, 103, 108, 101,  32,  79, 109, 101, 103,  97,  18,  18,  69,
117, 108, 101, 114, 105,  97, 110,  32,  65, 110, 103, 108, 101,  32,  67, 104,
105,  18,  18,  69, 117, 108, 101, 114, 105,  97, 110,  32,  65, 110, 103, 108,
101,  32,  80, 104, 105,  16,  16,  68, 105, 115, 116,  97, 110,  99, 101,  32,
111, 102,  32,  86, 105, 101, 119,  22,  22,  32,  69, 110, 100,  32, 111, 102,
 32,  69, 115, 115,  97, 105,  32,  83, 117, 114, 102,  97,  99, 101,  46,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 288 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 31280 );

/* Declaration of external variables. */
extern V PAS__f_output;


/* Function/procedure prototypes. */
void DRW_API( end )();
void Draw_Pas_Set_Menu_Spc(SL F_cd, V F_name, SL F_id);
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
void Draw_Set_ColorA(F F_r, F F_v, F F_b, F F_a);
void Draw_Out_Mode(SL F_n);
void Draw_Plot3(F F_x, F F_y, F F_z, UB F_ipen);
void Draw_Pas_String(F F_x, F F_y, F F_theta, F F_high, V F_str, SL F_oflg);
void Draw_View(F F_dist, F F_om, F F_th, F F_nu);
void Draw_Line_Attr(SL F_n, F F_r);
void Draw_Fill_Attr(SL F_n1, SL F_n2);
void Draw_Text_Font(SL F_n, SL F_tp);
void Draw_Text_Attr(SL F_n1, SL F_n2, SL F_n3, F F_re, F F_rs);
SL Draw_New_Seg(SL F_n);
void DRW_API( seg_end )();
SL Draw_Update_Seg(SL F_n, SL F_fapp);
void Draw_Seg_Unit_Transf(SL F_iseg, SL F_update);
void Draw_Rotate_Seg3(SL F_iseg, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
SL Draw_Seg_Orient(SL F_iseg, F F_px, F F_py, F F_pz, UB F_interaction);
SL Draw_Pas_Get_Value(V F_title, F *F_val, F F_lwlim, F F_uplim);
SL Draw_Dialog(SL F_flags);
SL Draw_New_Axis(V F_u_axis, V F_v_axis, F F_length, F F_vinf, F F_vsup, SL F_ntck
, SL F_flags);
SL Draw_New_Box(V F_org, SL F_ix, SL F_iy, SL F_iz, V F_dtb, SL F_sz, V F_stb, SL
F_nf, SL F_sz1, SL F_sz2);
void Draw__Set_Axis_Value(SL F_ia, SL F_cd, SL F_n, F *F_p1, F *F_p2, F *F_p3, F
*F_p4, SL *F_p5, SL *F_p6, SL *F_p7);
void Draw_Set_Axis_Unit(SL F_ia, V F_unit);
void Draw_Plot_Box(SL F_ib);
void Draw_Open_Box(SL F_ib);
void DRW_API( close_box )();


/* Procedure/Function : " display_surface "  */
void ESSAI_SFACE_display_surface(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  F Rv1;
  SL Rv2;
  F Rv3;
  F Rv4;
  SL Rv5;
  SL Rv6;
  SL Rv7;
  SL Rv8;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=48; /* line # 48 */
  Draw_View(Ri.f[0],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01);
  Ra.sl[6]=50; /* line # 50 */
  Draw_Text_Attr(3,5,1, (F)1.000000E+00, (F)0.000000E-01);
  Ra.sl[6]=51; /* line # 51 */
  Draw_Text_Font(3,0);
  Ra.sl[6]=52; /* line # 52 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.300000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Rd.s+96,0);
  Ra.sl[6]=54; /* line # 54 */
  Ri.sl[1]=Draw_New_Seg(2);
  Ra.sl[6]=56; /* line # 56 */
  Ri.f[2]=(F)9.000000E+01;
  Ri.f[3]=(F)8.000000E+01;
  Ri.f[4]=(F)-4.000000E+01;
  Ra.sl[6]=58; /* line # 58 */
  PAS__VWRITE_INIT(Ri.s+20,1);
  PAS__WRITE_STR(Rd.s+126,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[2],8,2,0);
  PAS__WRITE_STR(Rd.s+135,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[3],8,3,0);
  PAS__WRITE_STR(Rd.s+145,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[4],8,3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=59; /* line # 59 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.500000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Ri.s+20,0);
  Ra.sl[6]=61; /* line # 61 */
  DRW_API( seg_end )();
  Ra.sl[6]=63; /* line # 63 */
  Ri.sl[70]=Draw_New_Seg(3);
  Ra.sl[6]=64; /* line # 64 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+155,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[70],3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=66; /* line # 66 */
  Draw_Rotate_Seg3(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, Ri
  .f[2],Ri.f[3],Ri.f[4]);
  Ra.sl[6]=67; /* line # 67 */
  Draw_Seg_Orient(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=69; /* line # 69 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+175,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=111; /* line # 111 */
  Rs.sl[0]=Draw_New_Axis(Rd.s+232,Rd.s+244,(F)2.000000E+01, (F)-1.000000E+00, (F)
1.000000E+00,-3,0);
  Ra.sl[6]=113; /* line # 113 */
  Rs.sl[1]=Draw_New_Axis(Rd.s+256,Rd.s+268,(F)2.000000E+01, (F)-1.000000E+00, (F)
1.000000E+00,-3,0);
  Ra.sl[6]=115; /* line # 115 */
  Rs.sl[2]=Draw_New_Axis(Rd.s+280,Rd.s+292,(F)2.000000E+01, (F)0.000000E-01, (F)
1.000000E+00,-3,1536);
  Ra.sl[6]=119; /* line # 119 */
  Draw_Set_Axis_Unit(Rs.sl[0],Rd.s+304);
  Ra.sl[6]=120; /* line # 120 */
  Draw_Set_Axis_Unit(Rs.sl[1],Rd.s+312);
  Ra.sl[6]=121; /* line # 121 */
  Draw_Set_Axis_Unit(Rs.sl[2],Rd.s+320);
  Ra.sl[6]=123; /* line # 123 */
  Draw__Set_Axis_Value(Rs.sl[0],2,112, NULL, NULL, NULL, NULL, Rd.sl+83,Rd.sl+84,
  Rd.sl+85);
  Ra.sl[6]=124; /* line # 124 */
  Draw__Set_Axis_Value(Rs.sl[1],2,114, NULL, Rd.f+86,NULL, NULL, Rd.sl+87,Rd.sl+
88,Rd.sl+89);
  Ra.sl[6]=125; /* line # 125 */
  Draw__Set_Axis_Value(Rs.sl[1],4,2, NULL, Rd.f+90,NULL, NULL, NULL, NULL, NULL);
  Ra.sl[6]=126; /* line # 126 */
  Draw__Set_Axis_Value(Rs.sl[2],2,112, NULL, NULL, NULL, NULL, Rd.sl+91,Rd.sl+92,
  Rd.sl+93);
  Ra.sl[6]=128; /* line # 128 */
  Rs.sl[3]=5;
  Ra.sl[6]=130; /* line # 130 */
  Rs.sl[4]=14;
  Ra.sl[6]=132; /* line # 132 */
  Rs.sl[5]=2090;
  Ra.sl[6]=134; /* line # 134 */
  Rs.sl[6]=4161;
  Ra.sl[6]=137; /* line # 137 */
  Rs.sl[7]=7;
  Ra.sl[6]=140; /* line # 140 */
  Rs.sl[8]=Draw_New_Box(Rd.s+376,Rs.sl[0],Rs.sl[1],Rs.sl[2],Rs.s+12,5,NULL,0,0,0);
  Ra.sl[6]=142; /* line # 142 */
  Draw_Line_Attr(1, (F)1.000000E+00);
  Ra.sl[6]=144; /* line # 144 */
  Draw_Plot_Box(Rs.sl[8]);
  Ra.sl[6]=146; /* line # 146 */
  Draw_Open_Box(Rs.sl[8]);
  Ra.sl[6]=148; /* line # 148 */
  Draw_Out_Mode(1);
  Ra.sl[6]=151; /* line # 151 */
  Rv0=-25;
  for( Rf1=51;Rf1>0;Rf1-- ) {
    Ra.sl[6]=153; /* line # 153 */
    Rv1=(float)Rv0/(F)2.500000E+01;
    Ra.sl[6]=154; /* line # 154 */
    Rv2=-25;
    for( Rf0=51;Rf0>0;Rf0-- ) {
      Ra.sl[6]=156; /* line # 156 */
      Rv3=(float)Rv2/(F)2.500000E+01;
      Ra.sl[6]=157; /* line # 157 */
      Rv4=exp(-(PAS__IFPOWER(Rv1,2)+PAS__IFPOWER(Rv3,2))*(F)5.000000E+00);
      Ra.sl[6]=158; /* line # 158 */
      Rs.f[Rv0*153+Rv2*3+3909]=Rv1;
      Ra.sl[6]=159; /* line # 159 */
      Rs.f[Rv0*153+Rv2*3+3910]=Rv3;
      Ra.sl[6]=160; /* line # 160 */
      Rs.f[Rv0*153+Rv2*3+3911]=Rv4;
      Rv2++;
    }
    Rv0++;
  }
  Ra.sl[6]=177; /* line # 177 */
  Draw_Set_ColorA((F)3.000000E-01, (F)5.000000E-01, (F)7.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=178; /* line # 178 */
  Draw_Fill_Attr(2,1);
  Ra.sl[6]=181; /* line # 181 */
  Draw_Out_Mode(-5);
  Ra.sl[6]=183; /* line # 183 */
  Rv5=-25;
  for( Rf1=50;Rf1>0;Rf1-- ) {
    Ra.sl[6]=185; /* line # 185 */
    Draw_Plot3(Rs.f[Rv5*153+3834],Rs.f[Rv5*153+3835],Rs.f[Rv5*153+3836],0);
    Ra.sl[6]=186; /* line # 186 */
    Rv6=-25;
    for( Rf0=50;Rf0>0;Rf0-- ) {
      Ra.sl[6]=188; /* line # 188 */
      Draw_Plot3(Rs.f[(Rv5+1)*153+Rv6*3+3909],Rs.f[(Rv5+1)*153+Rv6*3+3910],Rs.f[
      (Rv5+1)*153+Rv6*3+3911],1);
      Ra.sl[6]=189; /* line # 189 */
      Draw_Plot3(Rs.f[Rv5*153+(Rv6+1)*3+3909],Rs.f[Rv5*153+(Rv6+1)*3+3910],Rs.f[
      Rv5*153+(Rv6+1)*3+3911],1);
      Rv6++;
    }
    Ra.sl[6]=191; /* line # 191 */
    Draw_Plot3(Rs.f[(Rv5+1)*153+3984],Rs.f[(Rv5+1)*153+3985],Rs.f[(Rv5+1)*153+3986]
    ,1);
    Rv5++;
  }
  Ra.sl[6]=193; /* line # 193 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=195; /* line # 195 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)1.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=196; /* line # 196 */
  Draw_Fill_Attr(1,1);
  Ra.sl[6]=197; /* line # 197 */
  Draw_Out_Mode(-5);
  Ra.sl[6]=199; /* line # 199 */
  Rv7=-25;
  for( Rf1=50;Rf1>0;Rf1-- ) {
    Ra.sl[6]=201; /* line # 201 */
    Draw_Plot3(Rs.f[Rv7*153+3834],Rs.f[Rv7*153+3835],Rs.f[Rv7*153+3836],0);
    Ra.sl[6]=202; /* line # 202 */
    Rv8=-25;
    for( Rf0=50;Rf0>0;Rf0-- ) {
      Ra.sl[6]=204; /* line # 204 */
      Draw_Plot3(Rs.f[(Rv7+1)*153+Rv8*3+3909],Rs.f[(Rv7+1)*153+Rv8*3+3910],Rs.f[
      (Rv7+1)*153+Rv8*3+3911],1);
      Ra.sl[6]=205; /* line # 205 */
      Draw_Plot3(Rs.f[Rv7*153+(Rv8+1)*3+3909],Rs.f[Rv7*153+(Rv8+1)*3+3910],Rs.f[
      Rv7*153+(Rv8+1)*3+3911],1);
      Rv8++;
    }
    Ra.sl[6]=207; /* line # 207 */
    Draw_Plot3(Rs.f[(Rv7+1)*153+3984],Rs.f[(Rv7+1)*153+3985],Rs.f[(Rv7+1)*153+3986]
    ,1);
    Rv7++;
  }
  Ra.sl[6]=209; /* line # 209 */
  Draw_Plot3((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,0);
  Ra.sl[6]=211; /* line # 211 */
  Draw_Set_ColorA((F)8.000000E-01, (F)5.000000E-01, (F)1.000000E-01, (F)1.000000E+00);
  Ra.sl[6]=212; /* line # 212 */
  Draw_Out_Mode(1);
  Ra.sl[6]=233; /* line # 233 */
  DRW_API( close_box )();
  Ra.sl[6]=234; /* line # 234 */
  DRW_API( seg_end )();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " rotate_plot "  */
void ESSAI_SFACE_rotate_plot(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  F Rv2;
  F Rv3;
  F Rv4;
  F Rv5;
  F Rv6;
  F Rv7;
  F Rv8;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+388;
  Ra.v[2]=Rd.s+17;
  Ra.sl[6]=245; /* line # 245 */
  Rv0=(F)1.745329E-02*Ri.f[2];
  Rv1=(F)1.745329E-02*Ri.f[3];
  Rv2=(F)1.745329E-02*Ri.f[4];
  Ra.sl[6]=246; /* line # 246 */
  Rv3=cos(Rv0);
  Rv4=sin(Rv0);
  Ra.sl[6]=247; /* line # 247 */
  Rv5=cos(Rv1);
  Rv6=sin(Rv1);
  Ra.sl[6]=248; /* line # 248 */
  Rv7=cos(Rv2);
  Rv8=sin(Rv2);
  Ra.sl[6]=250; /* line # 250 */
  Draw_Update_Seg(Ri.sl[1],0);
  Ra.sl[6]=252; /* line # 252 */
  PAS__VWRITE_INIT(Ri.s+20,1);
  PAS__WRITE_STR(Rd.s+401,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[2],8,2,0);
  PAS__WRITE_STR(Rd.s+410,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[3],8,3,0);
  PAS__WRITE_STR(Rd.s+420,-1,-1,32);
  PAS__WRITE_SNGL(Ri.f[4],8,3,0);
  PAS__WRITE_EOLN();
  Ra.sl[6]=253; /* line # 253 */
  Draw_Pas_String((F)0.000000E-01, (F)-1.500000E+01, (F)0.000000E-01, (F)1.000000E+00,
  Ri.s+20,0);
  Ra.sl[6]=255; /* line # 255 */
  DRW_API( seg_end )();
  Ra.sl[6]=257; /* line # 257 */
  Draw_View(Ri.f[0],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01);
  Ra.sl[6]=258; /* line # 258 */
  Draw_Seg_Unit_Transf(Ri.sl[70],0);
  Ra.sl[6]=259; /* line # 259 */
  Draw_Rotate_Seg3(Ri.sl[70],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, Ri
  .f[2],Ri.f[3],Ri.f[4]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " essai_surface "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  UB Rv2;
  UB Rv3;
  UB Rv4;
  UB Rv5;
  SL Rv6;
  SL Rv7;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[3906]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+31248;
  Rs.v[3907]=Rd.s+430;
  Rs.v[3908]=Rd.s+17;
  Rs.sl[7818]=295; /* line # 295 */
  Draw_Pas_Set_Menu_Spc(2, NULL,-1);
  Rs.sl[7818]=296; /* line # 296 */
  Draw_Pas_Set_Menu_Spc(3, Rd.s+445,-1);
  Rs.sl[7818]=297; /* line # 297 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+454,-1);
  Rs.sl[7818]=298; /* line # 298 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+462,-1);
  Rs.sl[7818]=299; /* line # 299 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+468,-1);
  Rs.sl[7818]=300; /* line # 300 */
  Draw_Pas_Set_Menu_Spc(4, Rd.s+474,-1);
  Rs.sl[7818]=301; /* line # 301 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1);
  Rs.sl[7818]=302; /* line # 302 */
  Draw_Pas_Set_Menu_Spc(0, NULL,-1);
  Rs.sl[7818]=304; /* line # 304 */
  Draw_Pas_Init(&Rv0, &Rv1, &Rv2, Rd.s+481);
  Rs.sl[7818]=305; /* line # 305 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+496,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_STR(Rd.s+503,-1,-1,32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_STR(Rd.s+513,-1,-1,32);
  PAS__WRITE_INT(Rv2,12,0);
  PAS__WRITE_EOLN();
  Rs.sl[7818]=308; /* line # 308 */
  Rv3=1;
  Rs.sl[7818]=309; /* line # 309 */
  Rv4=1;
  Rs.sl[7818]=310; /* line # 310 */
  Rv5=Draw_Pas_Picture_3D(Rd.s+525,(F)4.800000E+01, (F)3.600000E+01, (F)4.800000E+01,
  Rv3, Rv4);
  Rs.sl[7818]=315; /* line # 315 */
  ESSAI_SFACE_display_surface();
  while (1){
    Rs.sl[7818]=318; /* line # 318 */
    Rv6=Draw_Dialog(1);
    Rs.sl[7818]=319; /* line # 319 */
    if (Rv6>=1) {
      Rs.sl[7818]=320; /* line # 320 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_STR(Rd.s+545,-1,-1,32);
      PAS__WRITE_INT(Rv6,0,0);
      PAS__WRITE_EOLN();
    }
    else {
      Rs.sl[7818]=322; /* line # 322 */
      if (Rv6<0) goto L_l_0;
    }
    Rs.sl[7818]=323; /* line # 323 */
    switch (Rv6) {
      case 1:Rs.sl[7818]=326; /* line # 326 */
      Rv7=Draw_Pas_Get_Value(Rd.s+567,Ri.f+2,(F)-1.800000E+02, (F)1.800000E+02);
      Rs.sl[7818]=327; /* line # 327 */
      if (Rv7!=1) Ri.f[2]=(F)9.000000E+01;
      Rs.sl[7818]=328; /* line # 328 */
      ESSAI_SFACE_rotate_plot();
      break;
      case 2:Rs.sl[7818]=333; /* line # 333 */
      Rv7=Draw_Pas_Get_Value(Rd.s+589,Ri.f+3,(F)-1.800000E+02, (F)1.800000E+02);
      Rs.sl[7818]=334; /* line # 334 */
      if (Rv7!=1) Ri.f[3]=(F)8.000000E+01;
      Rs.sl[7818]=335; /* line # 335 */
      ESSAI_SFACE_rotate_plot();
      break;
      case 3:Rs.sl[7818]=340; /* line # 340 */
      Rv7=Draw_Pas_Get_Value(Rd.s+609,Ri.f+4,(F)-1.800000E+02, (F)1.800000E+02);
      Rs.sl[7818]=341; /* line # 341 */
      if (Rv7!=1) Ri.f[4]=(F)-4.000000E+01;
      Rs.sl[7818]=342; /* line # 342 */
      ESSAI_SFACE_rotate_plot();
      break;
      case 4:Rs.sl[7818]=347; /* line # 347 */
      Rv7=Draw_Pas_Get_Value(Rd.s+629,Ri.f,(F)0.000000E-01, (F)5.000000E+02);
      Rs.sl[7818]=348; /* line # 348 */
      if (Rv7!=1) Ri.f[0]=(F)0.000000E-01;
      Rs.sl[7818]=349; /* line # 349 */
      ESSAI_SFACE_rotate_plot();
      break;
    }
    if (Rv6==0)  break;
  }
L_l_0:
  Rs.sl[7818]=355; /* line # 355 */
  DRW_API( end )();
  Rs.sl[7818]=356; /* line # 356 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+647,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[3906];
  PAS__EXIT( 0 );
}
