/*  P A S - P. WOLFERS SOFTWARE: V2.1-E OF 31-AUG-2009 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ long long int
#include <draw/draw_apientry.h>

/* Include the PAS environment file. */
#include "/usr/local/cpas/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 224 ) = {
 15,  15, 100, 105, 115, 112, 108,  97, 121,  95, 115, 117, 114, 102,  97,  99,
101,  70,  70,  47, 104, 111, 109, 101,  47, 119, 111, 108, 102, 101, 114, 115,
 47,  83, 111, 102, 116,  47,  68, 114,  97, 119,  95,  70,  76,  84,  75,  95,
115, 114,  99,  95,  86,  49,  46,  52,  67,  45,  98,  97, 115, 101,  47,  68,
114,  97, 119,  95,  69, 120,  97, 109, 112, 108, 101, 115,  47,  46,  47,  47,
101, 115, 115, 111, 108,  46, 112,  97, 115,  13,  13,  32, 105, 109,  32, 112,
108,  97, 110, 101, 116,  32,  35,  32,  16,  16,  32, 105, 109,  32, 115,  97,
116, 101, 108, 108, 105, 116, 101,  32,  35,  32,  13,  13, 101, 115, 115,  97,
105,  95, 115, 121, 115,  95, 115, 111, 108,  13,  13,  69, 115, 115,  97, 105,
 32,  71, 114,  97, 112, 104, 105,  99,   5,   5, 120, 115,  32,  61,  32,   8,
  8,  32,  32,  32, 121, 115,  32,  61,  32,  10,  10,  32,  32,  32, 117, 110,
105, 116,  32,  61,  32,   8,   8,  80, 108,  97, 110, 101, 116, 101, 115,  26,
 26,  32,  70, 105, 110,  32,  69, 115, 115,  97, 105,  32,  83, 121, 115, 116,
101, 109,  32,  83, 111, 108,  97, 105, 114, 101,  46,   0,   0,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 16 ) = {
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 24 );

/* Declaration of external variables. */
extern V PAS__f_output;
extern SL Draw_AnmSSt;


/* Function/procedure prototypes. */
void Draw_End();
SL Draw_Pas_Init(F *F_x, F *F_y, UB *F_unit, V F_usrid);
UB Draw_Pas_Picture_3D(V F_title, F F_px, F F_py, F F_pz, UB F_bscale, UB F_blimit)
;
SL Draw_Dialog(SL F_flags);
SL Draw_Time_Anim(SL F_per);
void Draw_Set_Stop_Anim(SL F_md);
void Draw_Sphere(F F_xc, F F_yc, F F_zc, F F_r, SL F_plg, SL F_plt, SL F_flg);
void Draw_Color_Index(SL F_n);
SL Draw_New_Seg(SL F_n);
void Draw_Seg_End();
SL Draw_Push_Matrix();
void Draw_Pop_Matrix();
void Draw_Transf_Mat3(SL F_imat, F F_tx, F F_ty, F F_tz, F F_px, F F_py, F F_pz, 
F F_ome, F F_chi, F F_psi, F F_scx, F F_scy, F F_scz);
void Draw_Rotate_Mat3(SL F_imat, F F_px, F F_py, F F_pz, F F_ome, F F_chi, F F_psi)
;
void Draw_Pic_View(UB F_flags);


/* Procedure/Function : " display_surface "  */
void ESSAI_S_SOL_display_surface(){
  /* Define the automatic variable space. */
  Blk( Ra, 16 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+17;
  Ra.sl[3]=40; /* line # 40 */
  Ri.sl[0]=Draw_New_Seg(1);
  Ra.sl[3]=41; /* line # 41 */
  Rs.f[0]=(F)9.000000E+01;
  Rs.f[1]=(F)0.000000E-01;
  Ra.sl[3]=42; /* line # 42 */
  Draw_Color_Index(2);
  Ra.sl[3]=43; /* line # 43 */
  Draw_Sphere((F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)5.000000E+00,32,32,0);
  Ra.sl[3]=44; /* line # 44 */
  Ri.sl[1]=Draw_Push_Matrix();
  Ra.sl[3]=47; /* line # 47 */
  Draw_Rotate_Mat3(Ri.sl[1],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)
9.000000E+01, (F)8.000000E+01, Rs.f[0]);
  Ra.sl[3]=49; /* line # 49 */
  Draw_Color_Index(3);
  Ra.sl[3]=50; /* line # 50 */
  Draw_Sphere((F)2.000000E+01, (F)0.000000E-01, (F)0.000000E-01, (F)1.000000E+00,32,32,0);
  Ra.sl[3]=51; /* line # 51 */
  Ri.sl[2]=Draw_Push_Matrix();
  Ra.sl[3]=54; /* line # 54 */
  Draw_Transf_Mat3(Ri.sl[2],(F)2.000000E+01, (F)0.000000E-01, (F)0.000000E-01, (F)
0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
  Rs.f[1],(F)1.000000E+00, (F)1.000000E+00, (F)1.000000E+00);
  Ra.sl[3]=58; /* line # 58 */
  Draw_Color_Index(1);
  Ra.sl[3]=59; /* line # 59 */
  Draw_Sphere((F)5.000000E+00, (F)0.000000E-01, (F)0.000000E-01, (F)2.500000E-01,32,32,0);
  Ra.sl[3]=60; /* line # 60 */
  Draw_Pop_Matrix();
  Ra.sl[3]=61; /* line # 61 */
  Draw_Pop_Matrix();
  Ra.sl[3]=62; /* line # 62 */
  Draw_Seg_End();
  Ra.sl[3]=63; /* line # 63 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+89,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[1],12,0);
  PAS__WRITE_STR(Rd.s+104,-1,-1,32);
  PAS__WRITE_INT(Ri.sl[2],12,0);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " essai_sys_sol "  */
main( int argc, C * argv[], C * env[] ) {
  /* Local variable stored in C variable */
  F Rv0;
  F Rv1;
  UB Rv2;
  UB Rv3;
  SL Rv4;
  SL Rv5;
  register int Rf1, Rf0;

  /* Code of procedure/function */
  PAS__INIT( argc, argv, env );
  Rs.v[2]=PAS__curr_cntx;
  PAS__curr_cntx=Rs.s+8;
  Rs.v[3]=Rd.s+122;
  Rs.v[4]=Rd.s+17;
  Rs.sl[5]=74; /* line # 74 */
  Draw_Pas_Init(&Rv0, &Rv1, &Rv2, Rd.s+137);
  Rs.sl[5]=75; /* line # 75 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+152,-1,-1,32);
  PAS__WRITE_SNGL(Rv0,16,-6,0);
  PAS__WRITE_STR(Rd.s+159,-1,-1,32);
  PAS__WRITE_SNGL(Rv1,16,-6,0);
  PAS__WRITE_STR(Rd.s+169,-1,-1,32);
  PAS__WRITE_INT(Rv2,12,0);
  PAS__WRITE_EOLN();
  Rs.sl[5]=77; /* line # 77 */
  Rv3=Draw_Pas_Picture_3D(Rd.s+181,(F)6.000000E+01, (F)3.000000E+01, (F)6.000000E+01,1,1);
  Rs.sl[5]=79; /* line # 79 */
  Draw_Pic_View(0);
  Rs.sl[5]=80; /* line # 80 */
  Draw_Time_Anim(25);
  Rs.sl[5]=82; /* line # 82 */
  ESSAI_S_SOL_display_surface();
L_l_0:
  Rs.sl[5]=86; /* line # 86 */
  Draw_Set_Stop_Anim(0);
  Rs.sl[5]=88; /* line # 88 */
  Rv4=Draw_Dialog(1);
  Rs.sl[5]=89; /* line # 89 */
  if (Rv4>=0) {
    Rs.sl[5]=91; /* line # 91 */
    Draw_Set_Stop_Anim(1);
    Rs.sl[5]=92; /* line # 92 */
    for( Rf1=5;Rf1>0;Rf1-- ) {
      Rs.sl[5]=93; /* line # 93 */
      Rv5=1;
      for( Rf0=720;Rf0>0;Rf0-- ) {
        Rs.sl[5]=95; /* line # 95 */
        Rs.f[0]=(F)5.000000E-01*(float)Rv5+(F)9.000000E+01;
        Rs.sl[5]=96; /* line # 96 */
        Rs.f[1]=(F)2.500000E+00*(float)Rv5+(F)9.000000E+01;
        Rs.sl[5]=101; /* line # 101 */
        Draw_Rotate_Mat3(Ri.sl[1],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
        (F)0.000000E-01, (F)0.000000E-01, (F)5.000000E-01);
        Rs.sl[5]=109; /* line # 109 */
        Draw_Rotate_Mat3(Ri.sl[2],(F)0.000000E-01, (F)0.000000E-01, (F)0.000000E-01,
        (F)0.000000E-01, (F)0.000000E-01, (F)2.500000E+00);
        Rs.sl[5]=112; /* line # 112 */
        if (Draw_AnmSSt>0) goto L_l_0;
        Rs.sl[5]=115; /* line # 115 */
        PAS__DELAY((F)2.500000E-02);
        Rv5++;
      }
    }
  }
  Rs.sl[5]=118; /* line # 118 */
  Draw_End();
  Rs.sl[5]=119; /* line # 119 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+191,-1,-1,32);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Rs.v[2];
  PAS__EXIT( 0 );
}
