{
*************************************************************************
*                                                                       *
*                                                                       *
*                       *  P A S  *  S Y S T E M                        *
*                                                                       *
*                                                                       *
*                    * * *   C o m p i l e r    * * *                   *
*                                                                       *
*                                                                       *
*             ---   FIRST STEP OPTIMIZING MODULE   ---                  *
*                                                                       *
*              ---  Version  3.2-A0 -- 31/10/2016 ---                   *
*                                                                       *
*           by :                                                        *
*                                                                       *
*               P. Wolfers                                              *
*                   c.n.r.s.                                            *
*                   Laboratoire Louis Neel                              *
*                   B.P.  166 X   38042  Grenoble Cedex                 *
*                                          FRANCE.                      *
*                                                                       *
*************************************************************************


/////////////////////////////////////////////////////////////////////////
//                                                                     //
//                                                                     //
//                  Global Public Licence (GPL)                        //
//                                                                     //
//                                                                     //
// This license described in this file overrides all other licenses    //
// that might be specified in other files for this library.            //
//                                                                     //
// This program is free software; you can redistribute it and/or       //
// modify it under the terms of the GNU Lesser General Public          //
// License as published by the Free Software Foundation; either        //
// version 2.1 of the License, or (at your option) any later version.  //
//                                                                     //
// This software is distributed in the hope that it will be useful,    //
// but WITHOUT ANY WARRANTY; without even the implied warranty of      //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU   //
// Library General Public License for more details.                    //
//                                                                     //
// You should have received a copy of the GNU Lesser General Public    //
// License along with this library (see COPYING.LIB); if not, write to //
// the Free Software Foundation :                                      //
//                      Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

}


{************     CPAS  version    *************}

{
[inherit(     'lib:cpas_b__str_env',
              'lib:cpas_b__src_env',

              'lib:pas_env')]
}
module PAS_LGT; { lgt node evaluation }
{*************************************}

{ *** Include basic compiler environment *** }
%include 'passrc:pcmp_env';

var
  stack_size,                                  { Top of dynamic stack }
  stack_curr,                                  { Current dynamic stack pointer }
  arr_disp:            integer;                { address shift for array with descriptor }

  srv_local:           svp_ptr;                { Local variable routine queue }

  prm_obj:             lgt_ptr;                { Base object to refer }
  prm_lst:             ide_ptr;                { Formal list of the current type }
  srv_gen:             boolean;                { Flag for service routine generation }


function LGT_MAKE_BIC( i1, i2: integer ): integer;
var
  al1, al2: align_long;

begin
  al1.int := i1; al2.int := i2;
  al1.bits := al1.bits - al2.bits;
  LGT_MAKE_BIC := al1.int
end LGT_MAKE_BIC;




function LGT_TYPE_SCAN( lgp: lgt_ptr; sb: boolean := false ): lgt_ptr;
var
  lgcase, lgr, lgt: lgt_ptr;



  function VARIANT_IN_EXEC( lgtw: lgt_ptr; dyn: boolean ): lgt_ptr;
  { If lgtw^.lgt_parmlst = nil => type size def (use lgt_typ)
    lgt_null with lgt_typ -> form_variant (case in a record)
    lgt_null with lgt_typ -> any head type form (generic)
    else use expression.
  }
  var
    lgr, lgt: lgt_ptr;

  begin
    with lgtw^ do
      if (lgt_parmlst = nil) and (lgt_kind = lgt_null) then
      begin
        comp_typ_ptr := lgt_typ;                               { Set the resulted type pointer }
        if lgt_typ <> nil then                                 { Type size request }
          with lgt_typ^ do
            if typ_size > 0 then lgr := LGT_NEW_ECONST( int_typ, typ_size )
                            else lgr := LGT_TYPE_SCAN( typ_comp_size, true )
        else lgr := LGT_NEW_ECONST( int_typ, 0 )
      end
      else
      begin { Case expression }
        lgr := LGT_TYPE_SCAN( lgtw, true );
        comp_typ_ptr := lgr^.lgt_typ                           { Set the resulted typ pointer }
      end;

    if dyn and srv_gen then
      with lgr^ do                                             { We must change the Work entries to Statement }
        if (lgt_kind = lgt_srvref) and (lgt_icode = 0) then    { If lgr is a single reference to V0, we must replace it ... }
          begin  lgt_kind := lgt_null; lgt_typ := nil  end     { by a null statement to avoid to generate "V0 := V0" }
        else
        begin { We form the statement "V0 := <Expr>" }
          LGT_NEW( lgt, int_typ, lgt_srvref, nil );            { Create the V0 reference }
          lgt^.lgt_nxt := lgr;                                 { Link it with the <Expr> tree }
          LGT_NEW( lgr, int_typ, lgt_codep, lgt );             { Create the istore node }
          lgr^.lgt_pcode := pcod_istore
        end;

    VARIANT_IN_EXEC := lgr
  end VARIANT_IN_EXEC;



  function LGT_SUBSCAN( lgp: lgt_ptr ): lgt_ptr;
  const
    mdnam = 'SEVL';

  var
    ires, v1, v2, v3:                  integer;
    lgr, lgt0, lgt1, lgt2, lgt3:       lgt_ptr;
    idp:                               ide_ptr;
    ptab:                              tab_ptr;
    bcte:                              boolean;


  begin { LGT_SUBSCAN }
(*
if lgp <> nil then
with lgp^ do
begin
  WRITE( ' Node Kind is ', lgt_kind );
  if lgt_kind = lgt_codep then WRITE( ' ', lgt_pcode );
  WRITELN
end;
*)
    lgr := nil; ires := 0;
    if lgp <> nil then
    with lgp^ do
    case lgt_kind of
      lgt_null: { Link to a parameter/expression }
        if lgt_parmlst <> nil then lgr := LGT_SUBSCAN( lgt_parmlst )
                              else lgr := lgp                  { Formal type given };

      lgt_varbl:
        with lgt_ide^ do
          if ide_class = cla_tparam then
            if srv_gen then
            begin { Generate a reference to a routine's formal }
              LGT_NEW( lgr, int_typ, lgt_srvref, nil );
              ires := -1;
              idp := prm_lst;
              while (idp <> nil) and (idp <> lgt_ide) do
              begin  idp := idp^.ide_nxt; ires := ires - 1  end;
              if idp <> nil then lgr^.lgt_icode := ires        { Found formal }
                            else lgr^.lgt_icode := 0           { Not Found }
            end
            else
              if prm_obj <> nil then                           { Use basis and offset }
              begin { prm_obj^ is the access node to the allocated object }
                LGT_COPY_TREE( prm_obj, lgr );                 { Copy all the prm_obj Tree }
                if (lgr^.lgt_kind = lgt_varbl) or
                   (lgr^.lgt_kind = lgt_indir) or
                {  (lgr^.lgt_kind = lgt_index) or }
                   (lgr^.lgt_kind = lgt_offset) then
                begin
                  { /// lgr^.lgt_disp := lgr^.lgt_disp + arr_disp;   { Apply the descripor shift for array element reference }
                  { /// lgr^.lgt_disp := 0; }
                  lgr^.lgt_typ := lgt_typ
                end
                else LGT_NEW( lgr, lgt_typ, lgt_offset, lgr );
                with lgr^ do
                begin
                  lgt_disp := lgt_disp + ide_toffset;
                end;

              end
              else
              case ide_tkind of
                tpa_sub: { Used during the builting of a sub-type }
                  if ide_cteval <> nil then ires := ide_cteval^.val_ival
                                       else lgr := lgp;

                tpa_eval: lgr := LGT_SUBSCAN( ide_tlink2 );

                tpa_dycte:
                  if ide_tlink2^.lgt_kind = lgt_const then
                    ires := ide_tlink2^.lgt_cte^.val_ival      { Cte value }
                  else
                  begin
                    lgr := LGT_LINK( ide_tlink2 );             { Dynamic value }
                    lgr^.lgt_typ := ide_typ
                  end;
              otherwise
              end
          else { Not formal type but  Dynamic expression }
            if (lgt_typ^.typ_form <= form_int) or
               (lgt_typ^.typ_form = form_range) then LGT_NEW_COPY( lgp, lgr );

      lgt_const:
        with lgt_cte^ do
          if val_kind <= form_int then ires := val_ival
          else { Illegal constante type, ennumerated type was expected }
            SRC_ERROR( mdnam, 111, e_severe );

      lgt_srvcall:
        begin { Call a service routine }
          lgt0 := lgt_parmlst;
          lgt1 := nil;
          while lgt0 <> nil do
          begin
            lgr := LGT_SUBSCAN( lgt0 );
            if lgt1 = nil then lgt1 := lgr
                          else lgt2^.lgt_nxt := lgr;
            lgt2 := lgr;
            lgt0 := lgt0^.lgt_nxt
          end;
          LGT_NEW_COPY( lgp, lgr );
          lgr^.lgt_parmlst := lgt1
        end;

      lgt_codep:
        if lgt_parmlst <> nil then
        begin
          lgt1 := LGT_SUBSCAN( lgt_parmlst );
          lgt2 := nil; lgt3 := nil;
          with lgt_parmlst^ do
            if lgt_nxt <> nil then
            begin
              lgt2 := LGT_SUBSCAN( lgt_nxt );
              if lgt_nxt^.lgt_nxt <> nil then lgt3 := LGT_SUBSCAN( lgt_nxt^.lgt_nxt );
            end;

          bcte := true;
          if lgt1^.lgt_kind <> lgt_const then bcte := false
          else
            if lgt2 <> nil then
              if lgt2^.lgt_kind <> lgt_const then bcte := false
              else
                if lgt3 <> nil then
                  if lgt3^.lgt_kind <> lgt_const then bcte := false;

          if bcte then
          begin { The operation works only with cte. => We can Compute now }
            v1 := lgt1^.lgt_cte^.val_ival; LGT_FREE( lgt1 );
            if lgt2 <> nil then
            begin
              v2 := lgt2^.lgt_cte^.val_ival; LGT_FREE( lgt2 );
              if lgt3 <> nil then
              begin
                v3 := lgt3^.lgt_cte^.val_ival; LGT_FREE( lgt3 )
              end
            end;

            case lgt_pcode of
              pcod_noop: ires :=  v1;
              pcod_ineg: ires := -v1;

              pcod_succ,
              pcod_inc:  ires :=  v1 + 1;
              pcod_pred,
              pcod_dec:  ires :=  v1 - 1;

              pcod_not:  ires := 1 - v1;
              pcod_iodd: ires := ORD( ODD( v1) );
              pcod_iabs: ires := ABS( v1 );
              pcod_isqr: ires := SQR( v1 );

              pcod_iadd: ires := v1 + v2;
              pcod_isub: ires := v1 - v2;
              pcod_imul: ires := v1 * v2;
              pcod_idiv: if v2 <> 0 then ires := v1 div v2
                                    else ires := maxint;

              pcod_imod: if v2 <> 0 then ires := v1 mod v2
                                    else ires := 0;
              pcod_ipow: if v1 <> 0 then ires := v1**v2
                                    else ires := 0;

              pcod_and:  ires := ORD( (v1 <> 0) and (v2 <> 0) );
              pcod_or:   ires := ORD( (v1 <> 0) or (v2 <> 0) );
              pcod_xor:  ires := ORD( (v1 <> 0) <> (v2 <> 0) );
              pcod_bic:  ires := LGT_MAKE_BIC( v1, v2 );

              pcod_eq, pcod_ne,
              pcod_ult,pcod_ule,pcod_uge,pcod_ugt,
              pcod_ilt,pcod_ile,pcod_ige,pcod_igt:
                begin
                  v1 := v1 - v2;
                  case lgt_pcode of
                    pcod_ilt, pcod_ult: ires := ORD( v1 < 0 );
                    pcod_ile, pcod_ule: ires := ORD( v1 <= 0 );
                    pcod_ige, pcod_uge: ires := ORD( v1 >= 0 );
                    pcod_igt, pcod_ugt: ires := ORD( v1 > 0 );
                    pcod_ne:            ires := ORD( v1 <> 0 );
                    pcod_eq:            ires := ORD( v1 = 0 )
                  end { case lgt_pcode in }
                end;

              pcod_range:
                begin
                  ires := v1;
                  if (ires < v2) or (ires > v3) then SRC_ERROR( mdnam, 112, e_severe )
                end;

            otherwise
            end { case lgt_pcode over }
          end
          else                                                 { Dynamic expression }
          begin
            if lgt2 <> nil then
            begin
              lgt1^.lgt_nxt := lgt2;
              if lgt3 <> nil then lgt2^.lgt_nxt := lgt3
            end;
            LGT_NEW( lgr, lgt_typ, lgt_codep, lgt1 );
            lgr^.lgt_pcode := lgt_pcode
          end
        end;

      lgt_ctlflow:
        if lgt_stm = stm_case then                             { Case handling }
        begin { Case in a type definition }
          tcas_flag := true;                                   { Set the flag for Case is used }
          lgt1 := lgt_parmlst;                                 { Get cte. table }
          v1   := lgt1^.lgt_disp;                              { Get minimum of case }
          v2   := lgt1^.lgt_cte^.val_size + v1 - 1;            { Get maximum value }
          ptab := lgt1^.lgt_cte^.val_tab;                      { Get table address }
          lgt1 := lgt1^.lgt_nxt;                               { Get other selection }
          lgt0 := lgt1^.lgt_nxt;                               { Get selector def. }
          lgt2 := LGT_SUBSCAN( lgt0 );                         { Get selector value }
          lgt0 := lgt0^.lgt_nxt;                               { Get work # 0 def. }
          if lgt2^.lgt_kind = lgt_const then
          begin { The case selector is a constante }
            ires := lgt2^.lgt_cte^.val_ival;
            LGT_FREE( lgt2 );
            if (ires < v1) or (ires > v2) then { other case } lgt0 := lgt1
            else
            begin
              ires := ORD( ptab^.lw[ires-v1] );
              if ires < 0 then lgt := lgt1 else
              begin { Get the selection }
                while (ires > 0) and (lgt0 <> nil) do
                begin
                  lgt0 := lgt0^.lgt_nxt;
                  ires := ires - 1
                end;
                if lgt0 = nil then lgt0 := lgt1
              end
            end;
            lgr := VARIANT_IN_EXEC( lgt0, false )
          end
          else
          begin { Dynamic Case Selector : we must create a Special routine }
            LGT_NEW_COPY( lgp, lgr );                          { Copy the case node }
            LGT_NEW_COPY( lgt_parmlst, lgr^.lgt_parmlst );     { ... and the case tab }
            lgt1 := lgr^.lgt_parmlst;                          { lgt1 -> new case table }
            VAL_COPY( lgt_parmlst^.lgt_cte, lgt1^.lgt_cte, false );
            lgt0 := lgt_parmlst^.lgt_nxt;                      { lgt -> model other def. }
            lgt1^.lgt_nxt := VARIANT_IN_EXEC( lgt0, true );    { Set the other case }
            lgt1^.lgt_nxt^.lgt_nxt := lgt2;                    { Link with case selector }
            lgt0 := lgt0^.lgt_nxt^.lgt_nxt;                    { Skip to first model work }
            while lgt0 <> nil do
            begin { Scan for all work entries of the case }
              lgt2^.lgt_nxt := VARIANT_IN_EXEC( lgt0, true );
              lgt2 := lgt2^.lgt_nxt; lgt0 := lgt0^.lgt_nxt
            end;
            { Here the Case construct is made }
            if srv_gen then
            begin { When we must generate a special type case routine }
              lgcase := lgr;                                   { The case is a separate statement }
              LGT_NEW( lgr, int_typ, lgt_srvref, nil );        { Set the Local variable V0 as the case result }
              lgr^.lgt_icode := 0
            end
          end

        end
        else
        if lgt_stm = stm_if then
        begin { If expression}
          { /// Not Presently Implemented /// }
        end
        else { Illegal expression in a type definition }
        begin
          if cmp_cmpdbg then
            WRITELN( lst_current^.lst_file, ' ctlflow stm = ', lgt_stm );
          SRC_ERROR( mdnam, 995, e_severe )
        end

    otherwise
      { Illegal expression in a type definition }
      SRC_ERROR( mdnam, 994, e_severe )
    end { case lgt_kind };
    if lgr = nil then lgr := LGT_NEW_ECONST( int_typ, ires );  { When result is a cte. mpuit it in lgt_rec form }
    LGT_SUBSCAN := lgr
  end LGT_SUBSCAN;



begin { LGT_TYPE_SCAN }
  lgcase := nil;
  lgr := LGT_SUBSCAN( lgp );                                   { Get the result <expr> }
  if lgcase <> nil then
  begin
    if sb then
      with lgr^ do { Inside a case, we must generate a statement of form "V0 := <Expr>" }
        if (lgt_kind = lgt_srvref) and (lgt_icode = 0) then    { If lgr is a single reference to V0, we must replace it ... }
          begin  lgt_kind := lgt_null; lgt_typ := nil  end     { by a null statement to avoid to generate "V0 := V0" }
        else
        begin { We form the statement "V0 := <Expr>" }
          LGT_NEW( lgt, int_typ, lgt_srvref, nil );            { Create the V0 reference }
          lgt^.lgt_nxt := lgr;                                 { Link it with the <Expr> tree }
          LGT_NEW( lgr, int_typ, lgt_codep, lgt );             { Create the istore node }
          lgr^.lgt_pcode := pcod_istore
        end
    else LGT_NEW( lgr, int_typ, lgt_srvret, lgr );             { We must generate a statement of form "return <Expr>" }
    { Now a must build a sequence with the case this last statement }
    lgcase^.lgt_nxt := lgr;                                    { link the two statements }
    LGT_NEW( lgr, nil, lgt_ctlflow, lgcase );
    lgr^.lgt_stm := stm_sequence                               { Form a Statement Sequence }
  end;
  LGT_TYPE_SCAN := lgr                                         { Return the <Expr> or resulting statement Sequence }
end LGT_TYPE_SCAN;



[global]
procedure LGT_GEN_ROUTINE( ty: typ_ptr );
var
  idp:              ide_ptr;
  lgt, lgtf, lgtl:  lgt_ptr;
  srv:              srv_ptr;
  svpc, svpf, svpl: svp_ptr;

begin { LGT_GEN_ROUTINE }
  srv_gen := true;
  prm_obj :=  nil;
  with ty^ do
  if typ_sizesrv = nil then
  begin { Not already done }
    { Build the Formal Routine List }
    svpf := nil;               { Init the Formal Parameter list to empty state }
    prm_lst := typ_parmlst;
    idp := prm_lst;
    lgtf := nil;
    while idp <> nil do
    with idp^ do
    begin
      { Create the formal and put it in the formal queue }
      NEW( svpc );
      with svpc^ do
      begin  svp_nxt := nil; svp_typ := ide_typ  end;
      if svpf = nil then svpf := svpc
                    else svpl^.svp_nxt := svpc;
      svpl := svpc;
      { Create the effective list element }
      lgt := LGT_LINK( ide_tlink );
      if lgtf = nil then lgtf := lgt
                    else lgtl^.lgt_nxt := lgt;
      lgtl := lgt;
      idp := ide_nxt
    end;

    NEW( srv_local );          { Create the Local Variable V0 }
    with srv_local^ do
    begin
      svp_nxt := nil; svp_typ := typ_std[form_int]
    end;
    lgt  := LGT_TYPE_SCAN( typ_comp_size );
    NEW( srv );
    with srv^ do
    begin                      { Create the Service Routine Descriptor }
      srv_nxt :=                 nil;
      srv_typ :=             int_typ;
      srv_count := SUCC( srv_count );
      srv_ide :=         - srv_count;
      srv_cod :=                 lgt;
      srv_lva :=           srv_local;
      srv_prm :=                svpf
    end;
    { Put the routine in the routine queue }
    if srv_first = nil then srv_first := srv
                       else srv_last^.srv_nxt := srv;
    srv_last := srv;
    { Generate the function call node }
    LGT_NEW( typ_sizesrv, int_typ, lgt_srvcall, lgtf );
    typ_sizesrv^.lgt_srvfunc := srv
  end
end LGT_GEN_ROUTINE;




[global]
function LGT_TYPE_EVAL( troot, prm_actual: lgt_ptr; ty: typ_ptr := nil; elm_arr: boolean := false ): lgt_ptr;
{ prm_actual is the pointer of the related variable location as :
  lgt_const, lgt_varbl (cla_varbl), lgt_offset, lgt_indir }
const
  mdnam = 'EVAL';

var
  lgr: lgt_ptr;
  ivr: integer;
  ber: boolean;

begin
if cmp_cmpdbg then
begin
  WRITELN( lst_current^.lst_file, ' --- TREE ' );
  LGT_WRITE( 8, 0, troot );
  WRITELN( lst_current^.lst_file, ' --- OBJ ' );
  if prm_actual <> nil then LGT_WRITE( 8, 0, prm_actual )
end;
  arr_disp :=          0;
  srv_gen  :=      false;
  prm_obj  := prm_actual;

  { Get the array address descriptor shift when required }
  if elm_arr and (prm_obj <> nil) then
  with prm_obj^ do
    if lgt_typ <> nil then
    with lgt_typ^ do
      if typ_form = form_array then arr_disp := typ_descr_size;

  lgr := LGT_TYPE_SCAN( troot );

  if ty <> nil then
  with ty^, lgr^ do
  begin
    if (lgt_kind = lgt_const) and (lgt_typ = int_typ) then
    begin { Cte range Check }
      ivr := lgt_cte^.val_ival;
      if typ_unsigned then ber := (ivr < typ_umin) or (ivr > typ_umax)
                      else ber := (ivr < typ_min) or (ivr > typ_max);
      if ber then SRC_ERROR( mdnam, 112, e_severe )
    end
    else
    begin { Dynamic range Check: Not presently implemented. }

    end
  end;

if cmp_cmpdbg then
begin
  WRITELN( lst_current^.lst_file, ' RES' );
  LGT_WRITE( 8, 0, lgr );
end;

  LGT_TYPE_EVAL := lgr
end LGT_TYPE_EVAL;




[global]
function LGT_TYPE_COMPUTE( expr, expe: lgt_ptr; dvl: integer; obj: lgt_ptr ): lgt_ptr;
{ Compute statement generation for a type related quantity of the object obj or, in nil,
  driven by ide_tkind for a user expression (as in NEW_CALL), where :
     dvl      is the default constant value,
     expe     the standard expression for the compiler, and
     expr     the executable sequence calling a service routine when required.
}
var
  lgr: lgt_ptr;

begin
  if expe = nil then
    lgr := LGT_NEW_ECONST( int_typ, dvl )
  else
  begin
    lgr := LGT_TYPE_EVAL( expe, obj );
    if (lgr <> nil) and (expr <> nil) then
      { if expr <> nil then a service routine is used => a case is in the expression }
      if lgr^.lgt_kind <> lgt_const then  { The case is valuable when the selector was a constant => cte. result }
      begin
        { Destroy the unusable lgt tree }
        LGT_FREE_TREE( lgr );
        { Activate the fservice routine code generation }
        with expr^ do
          if lgt_srvfunc <> nil then
            with lgt_srvfunc^ do
              if srv_ide < 0 then srv_ide := ABS( srv_ide );
        { Generate the service routine call }
        lgr := LGT_TYPE_EVAL( expr, obj )
      end
  end;
  LGT_TYPE_COMPUTE := lgr
end LGT_TYPE_COMPUTE;



function LGT_CVAL_UNA( lop, pobj: lgt_ptr ): lgt_ptr;
const
  mdnam = 'CUVL';

var
  r: double;

begin
  with pobj^, lgt_cte^ do
  begin
    case lop^.lgt_pcode of
      pcod_not:    val_ival := ORD( val_ival <= 0 );

      pcod_iodd:   val_ival := ORD( ODD( val_ival ) );

      pcod_succ:   val_ival := val_ival + 1;

      pcod_pred:   val_ival := val_ival - 1;

      pcod_com:    val_set.siv := -1 - val_set.siv;

      pcod_ineg:   val_ival := - val_ival;

      pcod_fneg,
      pcod_gneg:   val_rval := - val_rval;

      pcod_iabs:   val_ival := ABS( val_ival );
      pcod_fabs,
      pcod_gabs:   val_rval := ABS( val_rval );

      pcod_isqr:   val_ival := SQR( val_ival );
      pcod_fsqr,
      pcod_gsqr:   val_rval := SQR( val_rval );

      pcod_cvif,
      pcod_cvig:   val_rval := val_ival;

      pcod_cvfi,
      pcod_cvgi:   val_ival := ROUND( val_rval );

      pcod_ftrunc,
      pcod_gtrunc:  val_ival := TRUNC( val_rval );

      pcod_sqrt,
      pcod_gsqrt: if val_rval < 0.0 then SRC_ERROR( mdnam, 801, e_error )
                                    else val_rval := SQRT(val_rval);

      pcod_sin,
      pcod_gsin: val_rval := SIN( val_rval );
      pcod_cos,
      pcod_gcos: val_rval := COS( val_rval );
      pcod_tan,
      pcod_gtan: val_rval := TAN( val_rval );

      pcod_asin,
      pcod_gasin:
          if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 802, e_error )
                                   else val_rval := ARCSIN( val_rval );
      pcod_acos,
      pcod_gacos:
          if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 803, e_error )
                                   else val_rval := ARCCOS( val_rval );
      pcod_atan,
      pcod_gatan:  val_rval := ARCTAN( val_rval );

      pcod_exp,
      pcod_gexp: val_rval := EXP(val_rval);
      pcod_log,
      pcod_glog:
          if val_rval <= 0.0 then SRC_ERROR( mdnam, 804, e_error )
                             else val_rval := LN(val_rval);

      pcod_sinh,
      pcod_gsinh: val_rval := SINH( val_rval );
      pcod_cosh,
      pcod_gcosh: val_rval := COSH( val_rval );
      pcod_tanh,
      pcod_gtanh: val_rval := TANH( val_rval );

      pcod_asinh,
      pcod_gasinh: val_rval := ARGSINH( val_rval );
      pcod_acosh,
      pcod_gacosh: if val_rval > 1.0 then SRC_ERROR( mdnam, 805, e_error )
                                     else val_rval := ARGCOSH( val_rval );
      pcod_atanh,
      pcod_gatanh:
          if ABS( val_rval ) > 1.0 then SRC_ERROR( mdnam, 806, e_error )
                                   else val_rval := ARGTANH( val_rval );

    otherwise { no op in compile time }
        { no operation }
    end;
    lgt_typ := lop^.lgt_typ; lgt_disp := lop^.lgt_disp;
    lgt_status := lop^.lgt_status
  end;
  LGT_CVAL_UNA := pobj
end LGT_CVAL_UNA;



function LGT_CVAL_BIN( lop, ob1, ob2: lgt_ptr ): lgt_ptr;
var
  ic: integer;
  rc: double;

begin
  with ob1^.lgt_cte^, ob2^ do
  case lop^.lgt_pcode of

    pcod_ipow: val_ival := val_ival ** lgt_cte^.val_ival;

    pcod_fpow,
    pcod_gpow: val_rval := val_rval ** lgt_cte^.val_rval;

    pcod_fipw,
    pcod_gipw: val_rval := val_rval ** lgt_cte^.val_ival;

    pcod_iadd: val_ival := val_ival + lgt_cte^.val_ival;
    pcod_isub: val_ival := val_ival - lgt_cte^.val_ival;
    pcod_imul: val_ival := val_ival * lgt_cte^.val_ival;
    pcod_idiv: val_ival := val_ival div lgt_cte^.val_ival;
    pcod_imod: val_ival := val_ival mod lgt_cte^.val_ival;

    pcod_fadd,
    pcod_gadd: val_rval := val_rval + lgt_cte^.val_rval;
    pcod_fsub,
    pcod_gsub: val_rval := val_rval - lgt_cte^.val_rval;
    pcod_fmul,
    pcod_gmul: val_rval := val_rval * lgt_cte^.val_rval;
    pcod_fdiv,
    pcod_gdiv: val_rval := val_rval / lgt_cte^.val_rval;

    pcod_and:  val_ival := ORD((val_ival > 0) and (lgt_cte^.val_ival > 0));
    pcod_or:   val_ival := ORD((val_ival > 0) or  (lgt_cte^.val_ival > 0));
    pcod_xor:  val_ival := ORD((val_ival > 0) <>  (lgt_cte^.val_ival > 0));

    { basic set operators }
    pcod_band: val_set.ssv := val_set.ssv * lgt_cte^.val_set.ssv;
    pcod_bxor: val_set.ssv := (val_set.ssv + lgt_cte^.val_set.ssv)
                             -(val_set.ssv * lgt_cte^.val_set.ssv);
    pcod_bic:  val_set.ssv := val_set.ssv - lgt_cte^.val_set.ssv;
    pcod_bis:  val_set.ssv := val_set.ssv + lgt_cte^.val_set.ssv;
    pcod_bit:  val_ival := ORD((val_set.ssv * lgt_cte^.val_set.ssv) <> []);


    pcod_setgen:    { Never called here };
    pcod_lsetgen:   { Never called here };
    pcod_lsetaddel: { Never called here };

    pcod_setlt, pcod_setle, pcod_setge,
    pcod_setgt, pcod_seteq, pcod_setne:
      begin
        case lop^.lgt_pcode of
          pcod_setlt,
          pcod_setle: ic := ORD( val_set.ssv <= lgt_cte^.val_set.ssv );
          pcod_setge,
          pcod_setgt: ic := ORD( val_set.ssv >= lgt_cte^.val_set.ssv );
          pcod_seteq: ic := ORD( val_set.ssv <> lgt_cte^.val_set.ssv );
          pcod_setne: ic := ORD( val_set.ssv =  lgt_cte^.val_set.ssv );
        otherwise
        end;
        val_kind := form_lit;
        val_size := 0;
        val_ival := ic
      end;

    pcod_inset: ic := ORD( val_ival in lgt_cte^.val_set.ssv );

    pcod_ult, pcod_ule, pcod_uge, pcod_ugt, pcod_ne, pcod_eq,
    pcod_ilt, pcod_ile, pcod_ige, pcod_igt:
      begin   { /// unsigned and signed are same }
        ic := val_ival - lgt_cte^.val_ival;
        case (ORD(lop^.lgt_pcode) - ORD(pcod_ult)) mod 6 of
          0 { lt }: val_ival := ORD( ic < 0 );
          1 { le }: val_ival := ORD( ic <= 0 );
          2 { ge }: val_ival := ORD( ic >= 0 );
          3 { gt }: val_ival := ORD( ic > 0 );
          4 { ne }: val_ival := ORD( ic <> 0 );
          5 { eq }: val_ival := ORD( ic = 0 )
        end
      end;

    pcod_flt, pcod_fle, pcod_fge, pcod_fgt, pcod_fne, pcod_feq,
    pcod_glt, pcod_gle, pcod_gge, pcod_ggt, pcod_gne, pcod_geq:
      begin
        rc := val_rval - lgt_cte^.val_rval;
        case (ORD(lop^.lgt_pcode) - ORD(pcod_flt)) mod 6 of
          0 { lt }: val_ival := ORD( rc < 0 );
          1 { le }: val_ival := ORD( rc <= 0 );
          2 { ge }: val_ival := ORD( rc >= 0 );
          3 { gt }: val_ival := ORD( rc > 0 );
          4 { ne }: val_ival := ORD( rc <> 0 );
          5 { eq }: val_ival := ORD( rc = 0 )
        end
      end;

    pcod__ne, pcod__eq:
      begin
        { /// block compare }
      end; 

    pcod_gphas,
    pcod_phas: val_rval := ARCTAN( val_rval, lgt_cte^.val_rval )

  otherwise
  end;
  with ob1^ do
  begin
    lgt_typ := lop^.lgt_typ; lgt_disp := lop^.lgt_disp;
    lgt_status := lop^.lgt_status
  end;
  LGT_CVAL_BIN := ob1
end LGT_CVAL_BIN;



procedure LGT_DO_INSERT( lgt_head: lgt_ptr; bfirst: boolean );
{ The pointer value lgt_head can not be changed }
begin
  with lgt_head^ do
    if bfirst then { first statement for insertion }
    begin
      lgt_inslst^.lgt_nxt := lgt_parmlst;
      lgt_parmlst := lgt_inshde
    end
    else
    begin
      lgt_inslst^.lgt_nxt := lgt_nxt;
      lgt_nxt := lgt_inshde
    end;
  lgt_inslst := nil; lgt_inshde := nil
end LGT_DO_INSERT;



procedure LGT_INSERT( lgt: lgt_ptr );
begin
  if lgt_inslst = nil then
    lgt_inshde := lgt
  else
    lgt_inslst^.lgt_nxt := lgt;
  lgt_inslst := lgt; lgt^.lgt_nxt := nil
end LGT_INSERT;



procedure LGT_INLINE_EXP( callnode: lgt_ptr );
{ make the inline procedure expanssion }
var
  inlproc:                        pro_ptr;
  iresloc, lgt_res, lgt_pro_def,
  lgt1, lgt2, lgt3:               lgt_ptr;
  fp:                             ide_ptr;


function LGT_MCOP( troot: lgt_ptr ): lgt_ptr;
const
  mdnam = 'MCOP';

var
  ires, v1, v2:                   integer;
  loop_sav, lgr, lgt, lgt1, lgt2: lgt_ptr;
  ptab:                           tab_ptr;




begin { LGT_MCOP }
  lgr := nil; ires := 0;
  if troot <> nil then
  with troot^ do
  case lgt_kind of  
    lgt_dynall: ;

    lgt_empty:
      LGT_NEW_COPY( troot, lgr );

    lgt_null:
      begin
        LGT_NEW_COPY( troot, lgr );
        lgr^.lgt_parmlst := LGT_MCOP( lgt_parmlst ) { follow the link }
      end;

    lgt_varbl: { is a cla_varbl only }
      if lgt_ide <> nil then
      with lgt_ide^ do
      begin
        if ide_owner = inlproc then
          { owner is the inline procedure to expand }
          case ide_vkind of
            var_decl: { only local to this inline procedure }
              { the others are an other allocation class as global/static/ext.}
              begin
                { local variable use }
                LGT_NEW_COPY( troot, lgr );
                with lgr^ do
                if ide_all = nil then { first use }
                begin
                  ALL_NEW( ide_all, lgt_typ, nil, var_decl );
                  ide_all^.all_acc := ide_vacc;
                  lgt_alloc := ide_all;
                  { the all_ide pointer is unusable when the inline procedure
                    is deleted from the current scope }
                  { The memory allocation is local to the current procedure }
                  with lgt_alloc^ do
                  begin
                    { read/write, only local ? }
                    if not (var_intaccess in ide_vacc) then
                      all_acc := all_acc + [var_used];
                    all_first_u := lgr; all_last_u := lgr
                  end
                end
                else
                begin
                  lgr^.lgt_alloc := ide_all;
                  ide_all^.all_last_u^.lgt_parmlst := lgr;
                  ide_all^.all_last_u := lgr { not the first use }
                end
              end;

            var_formal, var_vformal, var_refer:
              { inline procedure parameter }
              with ide_all^ do
              begin
                { it is a formal, we use the formal definition link }
                if (lgt_typ = all_first_u^.lgt_typ) and
                   (lgt_disp = 0) then { use direct ref. }
                begin
                  lgr := all_first_u;

                end
                else
                if all_first_u^.lgt_kind = lgt_varbl then
                { it is the a direct addr. }
                with all_first_u^ do
                begin
                  LGT_NEW_COPY( troot, lgr );
                  lgr^.lgt_ide := lgt_ide;
                  lgr^.lgt_alloc := lgt_alloc;
                  lgr^.lgt_disp := lgr^.lgt_disp + lgt_disp;
                  with lgt_alloc^ do
                  begin
                    if all_first_u = nil then all_first_u := lgr;
                    if all_last_u <> nil then all_last_u^.lgt_parmlst := lgr;
                    all_last_u := lgr
                  end
                end
                else
                begin
                  LGT_NEW_COPY( troot, lgr );
                  lgr^.lgt_kind := lgt_offset;
                  { get the effective link value }
                  lgr^.lgt_parmlst := all_first_u
                end;
                all_last_u := lgr { update use flag pointer }
              end;

            var_result: { write of a function result }
              begin
                if (lgt_typ = lgt_res^.lgt_typ) and
                   (lgt_disp = 0) then { use direct ref. }
                begin
                  lgr := lgt_res;
                end
                else
                if lgt_res^.lgt_kind = lgt_varbl then { it is the a direct addr. }
                with lgt_res^ do
                begin
                  LGT_NEW_COPY( troot, lgr );
                  lgr^.lgt_ide := lgt_ide;
                  lgr^.lgt_alloc := lgt_alloc;
                  lgr^.lgt_disp := lgr^.lgt_disp + lgt_disp;
                  with lgt_alloc^ do
                  begin
                    if all_first_u = nil then all_first_u := lgr;
                    if all_last_u <> nil then all_last_u^.lgt_parmlst := lgr;
                    all_last_u := lgr
                  end
                end
                else
                begin { we must generate an offset node }
                  LGT_NEW_COPY( lgt_res, lgr );
                  with lgr^ do
                  begin
                    lgt_typ := troot^.lgt_typ;
                    lgt_disp := lgt_disp + troot^.lgt_disp
                  end
                end
              end;

          otherwise
            { the local variable referenced by any not inline local
              function or procedure (var_decl) are allocated
              by the compilation of this procedure or function }
            { use the previously allocated record }
            LGT_NEW_COPY( troot, lgr )
          end { case }
        else
          { The static/external/global object are allocated in first }
          { use the previuosly allocated record }
          LGT_NEW_COPY( troot, lgr )
      end
      else
      begin { Temporary definition }
        LGT_NEW_COPY( troot, lgr );
        ALL_NEW( lgr^.lgt_alloc, lgt_typ, nil, var_tmp );
        with lgr^.lgt_alloc^ do
        begin
          all_first_u := lgr; all_last_u := lgr
        end
      end;

    lgt_call:
      with lgt_pro^ do
      begin { we generate a call node }
        LGT_NEW_COPY( troot, lgr );
        lgt := lgt_parmlst; lgt1 := nil;
        while lgt <> nil do
        begin
          lgt2 := LGT_MCOP( lgt ); lgt := lgt^.lgt_nxt;
          if lgt1 = nil then
            lgr^.lgt_parmlst := lgt2
          else
            lgt1^.lgt_nxt := lgt2;
          lgt1 := lgt2
        end
      end;

    lgt_proref: { /// };

    lgt_result:
      begin
        lgt1 := LGT_MCOP( lgt_parmlst );
        if iresloc = nil then iresloc := lgt1
      end;

    lgt_const:
      LGT_NEW_COPY( troot, lgr ); { create a cte copy }

    lgt_offset, lgt_indir, lgt_address, lgt_refer:
      begin
        LGT_NEW_COPY( troot, lgr );
        lgr^.lgt_parmlst := LGT_MCOP( troot^.lgt_parmlst )
      end;

    lgt_index:
      begin
        LGT_NEW_COPY( troot, lgr );
        lgt1 := lgr; lgt2 := troot^.lgt_parmlst;
        { get the array reference }
        lgt1^.lgt_parmlst := LGT_MCOP( lgt2 );
        lgt1 := lgt1^.lgt_parmlst; lgt2 := lgt2^.lgt_nxt;
        { get the index reference }
        lgt1^.lgt_nxt := LGT_MCOP( lgt2 );
        lgt1 := lgt1^.lgt_nxt; lgt2 := lgt2^.lgt_nxt;
        { get the element size reference }
        lgt1^.lgt_nxt := LGT_MCOP( lgt2 );
        { /// LGT_INDEX_OPTIMIZE( lgr ) /// }
      end;

    lgt_srcinfo:
      begin
        LGT_NEW_COPY( troot, lgr );
        lgt  := lgt_parmlst;
        lgt1 := nil;
        while lgt <> nil do
        begin
          lgt2 := LGT_MCOP( lgt );
          if lgt1 = nil then troot^.lgt_parmlst := lgt2
                        else lgt1^.lgt_nxt := lgt2;
          lgt1 := lgt2;
          lgt  := lgt^.lgt_nxt
        end
      end;

    lgt_codep:
      begin
        ires := 0;
        lgt  := nil;
        lgr  := lgt_parmlst;
        while lgr <> nil do
        begin
          lgt1 := LGT_MCOP( lgr );
          if lgt = nil then lgt := lgt1
                       else lgt2^.lgt_nxt := lgt1;
          lgt2 := lgt1;
          if (lgt1^.lgt_kind = lgt_const) and (ires >= 0) then ires := ires + 1
                                                          else ires := -1;
          lgr  := lgr^.lgt_nxt
        end;
        case ires of
          1: { Unary operator with a Constant Argument }
             lgr := LGT_CVAL_UNA( troot, lgt );

          2: { Binary operator with Constant Arguments }
             lgr := LGT_CVAL_BIN( troot, lgt, lgt2 );

        otherwise
          LGT_NEW_COPY( troot, lgr );
          lgr^.lgt_parmlst := lgt
        end
      end;

    lgt_ctlflow:
        { control flow statement }
        case lgt_stm of
          stm_case:
            { case handling }
            begin { case in a type definition }
              lgt1 := lgt_parmlst; { get cte. table }
              v1   := lgt1^.lgt_disp; { get minimum of case }
              { get maximum value }
              v2   := lgt1^.lgt_cte^.val_size + v1 - 1;
              ptab := lgt1^.lgt_cte^.val_tab; { get table address }
              lgt1 := lgt1^.lgt_nxt; { get other selection }
              lgt  := lgt1^.lgt_nxt; { get selector def. }
              lgt2 := LGT_MCOP( lgt ); { get selector value }
              lgt  := lgt^.lgt_nxt; { get work # 0 def. }
              if lgt2^.lgt_kind = lgt_const then
              begin { the case selector is a constante }
                ires := lgt2^.lgt_cte^.val_ival; LGT_FREE( lgt2 );
                if (ires < v1) or (ires > v2) then { other case } lgt := lgt1
                else
                begin
                  ires := ORD( ptab^.lw[ires-v1] );
                  if ires < 0 then lgt := lgt1 else
                    { get the selection }
                    while (ires > 0) and (lgt <> nil) do
                    begin
                      lgt := lgt^.lgt_nxt;
                      ires := ires - 1
                    end
                end;
                lgr := LGT_MCOP( lgt )
              end
              else
              begin { dynamic selector we must copy the case to exec tree }
                LGT_NEW_COPY( troot, lgr ); { copy the case node }
                LGT_NEW_COPY( lgt_parmlst, lgr^.lgt_parmlst ); { and the case tab }
                lgt1 := lgr^.lgt_parmlst; { lgt1 -> new case table }
                VAL_COPY( lgt_parmlst^.lgt_cte, lgt1^.lgt_cte, false );
                lgt := lgt_parmlst^.lgt_nxt; { lgt -> model other def. }
                lgt1^.lgt_nxt := LGT_MCOP( lgt ); { set the other case }
                lgt1^.lgt_nxt^.lgt_nxt := lgt2; { link with case selector }
                lgt := lgt^.lgt_nxt^.lgt_nxt; { skip to first model work }
                while lgt <> nil do
                begin
                  lgt2^.lgt_nxt := LGT_MCOP( lgt );
                  lgt2 := lgt2^.lgt_nxt; lgt := lgt^.lgt_nxt
                end
              end
            end;

        stm_sequence, stm_loop, stm_parallel:
          begin
            LGT_NEW_COPY( troot, lgr );
            loop_sav := lgt_nxt; lgt_nxt := lgr; { set the new exit target }
            lgt := lgt_parmlst; lgt1 := nil;
            while lgt <> nil do
            begin
              lgt2 := LGT_MCOP( lgt ); lgt := lgt^.lgt_nxt;
              if lgt2 <> nil then
              begin
                if lgt1 = nil then
                  lgr^.lgt_parmlst := lgt2
                else
                  lgt1^.lgt_nxt := lgt2;
                lgt1 := lgt2
              end
            end;
            lgt_nxt := loop_sav { restore troot next's link }
          end;

        stm_return:
          begin
            lgt1 := LGT_MCOP( lgt_parmlst );
            if iresloc = nil then iresloc := lgt1
          end;

        stm_exit:
          begin
            { get condition if it exist }
            lgt2 := LGT_MCOP( lgt_parmlst^.lgt_nxt );
            lgt := lgt_parmlst;
            if lgt2 <> nil then
              with lgt2^ do
                if (lgt_kind = lgt_const) and (lgt_cte^.val_ival = 0) then
                  lgt := nil;
            if lgt <> nil then { a target exists }
            begin
              LGT_NEW_COPY( troot, lgr ); { create the exit node }
              LGT_NEW_COPY( lgt, lgt1 ); { and the exit target parm }
              lgr^.lgt_parmlst := lgt1; lgt1^.lgt_nxt := lgt2; { link parm }
              with lgt1^ do
                if lgt_kind = lgt_proref then
                begin
                  if lgt_pro = inlproc then { this is this inline procedure }
                  begin { link to any previous inlproc ref }
                    lgt1^.lgt_parmlst := lgt_pro_def; lgt_pro_def := lgt1
                  end
                  { the other procedure are not changed }
                end
                else { loop/sequ/for target in the inline procedure }
                  { set the new exit target }
                  lgt1^.lgt_parmlst := lgt^.lgt_parmlst^.lgt_nxt
            end
          end;

        stm_for:
          begin
            lgt1 := LGT_MCOP( lgt_parmlst ); { get for initial count }
            lgt := lgt_parmlst^.lgt_nxt;  { get the for sequence begining }

            if lgt <> nil then
            begin
              with lgt1^ do
                if lgt_kind = lgt_const then
                begin
                  ires := lgt_cte^.val_ival;
                  if ires < 1 then { anything to do for this for ? }
                  begin { nothing to generate or no loop to generate }
                    LGT_FREE( lgt1 ); LGT_FREE_TREE( lgt );
                    lgr := nil
                  end
                  else
                    if ires = 1 then
                    begin { no for node to generate }
                      LGT_FREE( lgt1 ); lgt1 := nil;
                      LGT_NEW( lgr, nil, lgt_ctlflow, nil );
                      lgr^.lgt_stm := stm_sequence
                    end
                    else
                    begin
                      LGT_NEW( lgr, nil, lgt_ctlflow, lgt1 );
                      lgr^.lgt_stm := stm_for
                    end
                end
                else
                begin
                  LGT_NEW( lgr, nil, lgt_ctlflow, lgt1 );
                  lgr^.lgt_stm := stm_for
                end;

              if lgr <> nil then
              begin
                loop_sav := lgt_nxt; lgt_nxt := lgr; { link target }
                while lgt <> nil do
                begin
                  lgt2 := LGT_MCOP( lgt ); lgt := lgt^.lgt_nxt;
                  if lgt2 <> nil then
                  begin
                    if lgt1 = nil then
                      lgr^.lgt_parmlst := lgt2
                    else
                      lgt1^.lgt_nxt := lgt2;
                    lgt2 := lgt1
                  end
                end;
                lgt_nxt := loop_sav { restore nxt link for troot }
              end
            end
            else
              LGT_FREE_TREE( lgt1 );
          end;

        stm_if:
          begin
            lgt1 := LGT_MCOP( lgt_parmlst );
            if lgt1 <> nil then
            begin
              lgt3 := lgt_parmlst^.lgt_nxt;
              if lgt1^.lgt_kind = lgt_const then
              begin
                if lgt1^.lgt_cte^.val_ival > 0 then { true }
                  lgr := LGT_MCOP( lgt1^.lgt_nxt )
                else
                  with lgt1^.lgt_nxt^ do
                    if lgt_nxt <> nil then
                      lgr := LGT_MCOP( lgt_nxt )
              end
              else
              begin
                lgt1^.lgt_parmlst := LGT_MCOP( lgt3 );
                if lgt3^.lgt_nxt <> nil then
                  lgt1^.lgt_parmlst^.lgt_nxt := LGT_MCOP( lgt3^.lgt_nxt );
                LGT_NEW_COPY( troot, lgr );
                lgr^.lgt_parmlst := lgt1
              end
            end
          end;

      otherwise

      end { case stm of };


  otherwise
  end { case lgt_kind };

  LGT_MCOP := lgr
end LGT_MCOP;



begin { LGT_INLINE_EXP }
  inlproc := callnode^.lgt_pro;
  iresloc := nil;
  with inlproc^ do
  begin
    lgt_pro_def := nil;  { set the inline proc. ref. list to empty }
    { attach all formal to actual }
    lgt1 := callnode^.lgt_parmlst;
    fp := pro_parmlst;
    if pro_typ <> nil then { it is a function }
    if pro_parmlst <> nil then
    if pro_parmlst^.ide_vkind = var_result then
    { scan only for large parameter }
    begin
      LGT_SCAN( lgt1 ); { scan the result definition }
      iresloc := lgt1;
      with lgt1^ do
        if lgt_ide = nil then { without identifier }
          with lgt_alloc^ do
            if all_first_u = all_last_u then
            begin
              all_first_u := nil; all_last_u := nil
            end;
      lgt_res := lgt1; lgt2 := lgt1;
      fp := fp^.ide_nxt; lgt1 := lgt1^.lgt_nxt;
      lgt2^.lgt_nxt := nil; { delete the next link of effective }
    end;

    { set the link between each formal and corresponding actual }
    while lgt1 <> nil do
    begin
      with fp^, ide_all^ do
      begin
        LGT_SCAN( lgt1 );
        all_first_u := lgt1;
        all_last_u := nil { flag set as not used }
      end;
      lgt2 := lgt1;
      fp := fp^.ide_nxt; lgt1 := lgt1^.lgt_nxt;
      lgt2^.lgt_nxt := nil; { delete the next link of effective }
    end;

    { clear all local variable memory allocation links }
    fp := pro_loclst;
    while fp <> nil do
    begin { there is a list of cla_varbl definition }
      with fp^ do
        case ide_vkind of
          var_decl:
            ide_all := nil;

        otherwise
          { nothing to do for global/external and static variables }
        end { case };
      fp := fp^.ide_nxt
    end;

    { expand the procedure }
    lgt2 := LGT_MCOP( pro_lgt );

    if lgt_pro_def <> nil then
    { release the exit link to this inline procedure }
    repeat
      lgt1 := lgt_pro_def;
      lgt_pro_def := lgt_pro_def^.lgt_parmlst;
      with lgt1^ do
      begin
        lgt_kind := lgt_null; { change to null link }
        lgt_parmlst := lgt2
      end
    until lgt_pro_def = nil;

    fp := inlproc^.pro_parmlst;

    { set the function result }
    if pro_typ <> nil then { it is a function }
      if iresloc <> nil then
      with lgt2^ do
      begin
        lgt_typ := pro_typ; { set the new type }
        lgt_status := [lgt_reg,lgt_in,lgt_out];

        LGT_NEW( lgt_nxt, lgt_typ, lgt_varbl, nil);
        lgt_nxt^.lgt_ide := nil;
        lgt_nxt^.lgt_alloc := lgt_res^.lgt_alloc;
        lgt_res^.lgt_alloc^.all_last_u := lgt_nxt; { set the last use }
        pro_parmlst^.ide_all^.all_first_u := nil; { erase for next use }

        fp := fp^.ide_nxt
      end
      else
      begin

      end;

    { we must free all unused parameter lgt trees }
    while fp <> nil do
    begin
      with fp^.ide_all^ do
        if all_last_u <> nil then { used parameter }
        begin
        end
        else { unused effective parameter }
          LGT_FREE_TREE( all_first_u );
      fp := fp^.ide_nxt
    end;

    { the call node must be replaced by a sequence }
    with callnode^ do
    begin
      lgt_kind := lgt_ctlflow;
      lgt_stm := stm_sequence;
      lgt_parmlst := lgt2
    end;
  end
end LGT_INLINE_EXP;



procedure LGT_EXTRACT_CTE( lgt: lgt_ptr );
var
  offset,            { Offset Count }
  moffset: integer;  { Required offset }
  pv, res: val_ptr;  { Pointer to the current value block, and for result }
  ty:      typ_ptr;  { Required type }


  procedure EXTRACT_DATA_VALUE( var pv: val_ptr );
  { To extract a value from a structured constant }
  var
    top,               { Top of the current structure }
    isc:      integer; { Count down for descriptor field }
    pv1:      val_ptr; { Pointer of current sub-object val_rec }

  begin
    res := nil;
    if pv <> nil then
    with pv^ do
    if val_typ <> nil then
    with val_typ^ do
    begin
      offset := IDE_TYP_ALIGN( offset, val_typ ); { Get the start address of object }

      if typ_size > 0 then top := offset + typ_size
      else
      begin
        top := offset + val_size;
        if (val_kind = form_string) and (typ_form = form_record) then
          { The constant is kept as a form_string value without descriptor }
          top := top + typ_descr_size { we must add the record descriptor size }
      end;

      if moffset >= top then
      begin { The present object does not include the specified one }
        offset := top;
        pv     := val_next;
        return
      end;

      { *** The current object includes the searched out one *** }

      if (val_kind = form_string) and (typ_form = form_array) and
         (typ_aeltype = typ_std[form_char]) and (ty = typ_std[form_char]) then
      begin { form_string is used for a packed array of char => Special localisation }
        VAL_NEW( res, ty );                       { Create the character cte record }
        res^.val_ival := ORD( val_str^[moffset-offset+1] );
        return
      end;

      { *** The Standard Search of val_rec *** }

      case val_kind of                            { Select the kind of structured object }
        form_char, form_lit, form_wlit, form_ennum,
        form_int, form_range, form_nil, form_single,
        form_double, form_wset, form_wwset, form_set:
          begin                                   { The object is found }
            VAL_COPY( pv, res, false );           { Make a copy of the val_rec }
            return
          end;

        form_string:
          begin                                   { For a string constant object }
            isc := moffset - offset;              { Get the relative offset }
            VAL_NEW( res, ty );                   { Create the new Value record }
            if isc < stri_descrsz then            { Access to string Capacity }
              res^.val_ival := val_str^.capacity
            else
            if isc < stri_stroffset then          { Acces to string Length }
              res^.val_ival := val_str^.length
            else                                  { Acces to a string character }
              res^.val_ival := ORD( val_str^.body[isc - (stri_stroffset - 1)] );
            return
          end;

        form_record, form_conf, form_array:
          begin                                   { For a structured constant object }
            pv1 := val_lst;                       { Start the Sub-Object Search Scan }
            isc := val_descr;                     { To manage the descriptor field }
            while (pv1 <> nil) and (res = nil) do
            with pv1^ do
            begin { Sub-Object Search Scan }
              if (isc = 0) and (val_kind = form_array) then
                offset := IDE_TYP_ALIGN( offset, typ_aeltype ); { Align on element type }
              EXTRACT_DATA_VALUE( pv1 );
              if isc > 0 then isc := isc - 1
            end
          end;

      otherwise
      end
    end;
  end EXTRACT_DATA_VALUE;



begin { LGT_EXTRACT_CTE }
  with lgt^ do
  if (lgt_cte <> nil) and (lgt_typ <> nil) then
  begin
    offset  := 0;         { Initialize the offset count }
    moffset := lgt_disp;  { Get the Offset in the memory structure }
    ty      := lgt_typ;   { ... and the type of the selected object inside }
    pv      := lgt_cte;   { Start from the current structure }
    res     := nil;       { Mark as not found }
    EXTRACT_DATA_VALUE( pv );
    if res <> nil then lgt_cte := res { Set the result when the search is a success }
  end
end LGT_EXTRACT_CTE;



[global]
procedure LGT_EXTRACT_SIMPLE_CTE( lgt: lgt_ptr );
begin
  if lgt <> nil then
  with lgt^ do
    if (lgt_kind = lgt_const) and (lgt_typ <> nil) and (lgt_cte <> nil) then
      if lgt_typ^.typ_simple and lgt_cte^.val_typ <> nil then
        if not lgt_cte^.val_typ^.typ_simple then
          LGT_EXTRACT_CTE( lgt )
end LGT_EXTRACT_SIMPLE_CTE;



[global]
procedure LGT_SCAN( head: lgt_ptr );
var
  lgt_insavhde,
  lgt_insavlst,
  lgt1, lgt2:     lgt_ptr;
  pf:             ide_ptr;
  stack_save,
  svsz, ipa, idv: integer;


procedure LGT_SCAN_BLOCK( lgt: lgt_ptr );
var
  lgt1: lgt_ptr;

begin
  { Save old insert list and init new one's to empty }
  lgt_insavhde := lgt_inshde; lgt_insavlst := lgt_inslst;
  lgt_inslst   := nil; lgt_inshde := nil;
  LGT_SCAN( lgt );
  if lgt_inslst <> nil then
    if (lgt^.lgt_kind <> lgt_ctlflow) or (lgt^.lgt_stm <> stm_sequence) then
    begin
      LGT_NEW_COPY( lgt, lgt1 );
      with lgt^ do
      begin
        lgt_kind    := lgt_ctlflow;
        lgt_stm     := stm_sequence;
        lgt_parmlst := lgt_inshde
      end;
      lgt_inslst^.lgt_nxt := lgt1
    end
    else
      LGT_DO_INSERT( lgt, true );
  { Restore the old insert list }
  lgt_inshde := lgt_insavhde; lgt_inslst := lgt_insavlst
end LGT_SCAN_BLOCK;



procedure LGT_SCAN_CASE( lgt: lgt_ptr; ncase: integer );
var
  ptab:           tab_ptr;
  min, sz:        integer;
  curr, oth, sel: lgt_ptr;

begin
  with lgt^, lgt_cte^ do
  begin
    min  := lgt_disp; sz  := val_size;
    ptab :=  val_tab; oth :=  lgt_nxt
  end;
  if oth^.lgt_kind <> lgt_null then
  LGT_SCAN_BLOCK( oth );
  sel := oth^.lgt_nxt;
  LGT_SCAN( sel );
  curr := sel^.lgt_nxt;
  while curr <> nil do
  begin
    LGT_SCAN_BLOCK( curr );
    curr := curr^.lgt_nxt
  end
end LGT_SCAN_CASE;



function LGT_CHECK_UNA( var lgt: lgt_ptr; pcd: pcod_codes ): boolean;
{ Change the tree for second binary operator where the second
  parameter is a node pcod_xneg (with x =i/f/g) or the unique
  parameter for node pcod_xneg, pcod_com, pcod_not.
  lgt is the pointer of related parameter of binary or unary operator,
  and pcd the code to check. The unused node are linked as
  unused parameters of the primary operator. }

var
  lg1, lg2:      lgt_ptr;
  bch, bct, bfl: boolean;

begin
  lg1 := lgt;
  lg2 := lgt;
  bct := true;
  bch := false;
  bfl := false;
  while bct and (lg1 <> nil) do
  with lg1^ do
  begin
    case lgt_kind of
      lgt_codep:
        begin
          if lgt_pcode = pcd then
          begin { node to skip with flip-flop }
            bfl := true;
            bch := not bch
          end
          else
            bct := false
        end;

      lgt_const:
        if lgt_cte <> nil then
        with lgt_cte^ do
        begin
          case pcd of
            pcod_ineg: if val_ival < 0 then
                       begin val_ival := - val_ival; bch := not bch  end;
            pcod_iadd: if val_ival < 0 then
                       begin val_ival := - val_ival; bch := not bch  end;
            pcod_fneg,
            pcod_gneg: if val_rval < 0.0 then
                       begin val_rval := - val_rval; bch := not bch  end;
            pcod_fadd,
            pcod_gadd: if val_rval < 0.0 then
                       begin val_rval := - val_rval; bch := not bch  end;
          otherwise
          end;
          bct := false
        end;

      lgt_null: ;

    otherwise
      bct := false
    end;
    if bct then lg1 := lgt_parmlst { loop when continue the search }
  end;
  if bfl then { node to suppress }
  begin
    LGT_SCAN( lg1 );        { perform the scan for the parameter }
    lgt := LGT_LINK( lg1 ); { Set a link to the direct parameter }
    lg1^.lgt_nxt := lg2     { append the old parameter to the parameter list }
  end
  else LGT_SCAN( lgt );
  LGT_CHECK_UNA := bch
end LGT_CHECK_UNA;



function LGT_PASS_LINK( lgt: lgt_ptr ): lgt_ptr;
begin
  if lgt <> nil then
  with lgt^ do
    if lgt_kind = lgt_null then LGT_PASS_LINK := LGT_PASS_LINK( lgt_parmlst )
                           else LGT_PASS_LINK := lgt
end LGT_PASS_LINK;



function LGT_IS_CONST( lgt: lgt_ptr; var pv: [optional] val_ptr ): val_ptr;
var
  rs: boolean := false;

begin
  lgt := LGT_PASS_LINK( lgt );
  if lgt <> nil then
  with lgt^ do
    if lgt_kind = lgt_const then LGT_IS_CONST := lgt_cte (* /// before lgt_cte incompatible pointer *)
                            else LGT_IS_CONST := nil
  else LGT_IS_CONST := nil
end LGT_IS_CONST;



function LGT_CTE_IN_2( var lgt: lgt_ptr ): val_ptr;
var
  p1, p2: val_ptr;
  l1, l2: lgt_ptr;

begin
  l1 := lgt^.lgt_parmlst;
  p1 := LGT_IS_CONST( l1 );
  l2 := lgt^.lgt_nxt;
  p2 := LGT_IS_CONST( l2 );
  if p1 <> nil then
  with lgt^ do
    if (p2 = nil) or (l2^.lgt_kind = lgt_null) then
    begin { Do a permuttation }
      lgt_parmlst := l2; l2^.lgt_nxt := l1; l1^.lgt_nxt := nil;
      LGT_CTE_IN_2 := p1
    end
    else
    begin { Two constantes => perform the operation }
      case lgt_pcode of
        pcod_iadd:
          if lgt_typ^.typ_unsigned then
             lgt_parmlst := LGT_NEW_ECONST( lgt_typ, p1^.val_uval + p2^.val_uval )
            else
             lgt_parmlst := LGT_NEW_ECONST( lgt_typ, p1^.val_ival + p2^.val_ival );
        pcod_fadd,
        pcod_gadd:
             lgt_parmlst := LGT_NEW_ECONSTR( lgt_typ, p1^.val_rval + p2^.val_rval );
        pcod_imul:
          if lgt_typ^.typ_unsigned then
             lgt_parmlst := LGT_NEW_ECONST( lgt_typ, p1^.val_uval * p2^.val_uval )
            else
             lgt_parmlst := LGT_NEW_ECONST( lgt_typ, p1^.val_ival * p2^.val_ival );
        pcod_fmul,
        pcod_gmul:
             lgt_parmlst := LGT_NEW_ECONSTR( lgt_typ, p1^.val_rval * p2^.val_rval );
      otherwise
      end;
      LGT_FREE( l1 ); LGT_FREE( l2 );
      LGT_CTE_IN_2 := nil
    end
  else
    LGT_CTE_IN_2 := p2
end LGT_CTE_IN_2;



(*
procedure LGT_FIT_OPER( lgt: lgt_ptr  );
var
  lg1:    lgt_ptr;
  pcd: pcod_codes;

{
function LGT_PASS_LINK( lgt: lgt_ptr ): lgt_ptr;
function LGT_IS_CONST( lgt: lgt_ptr; var pv: [optional] val_ptr ): lgt_ptr;
function LGT_CTE_IN_2( var lgt: lgt_ptr ): boolean;
}

begin
  lg1 := lgt;

  if lgt <> nil then
  with lgt^ do
  if lgt_kind = lgt_codep then
  begin
    case lgt_pcode of
      pcod_iadd, pcod_fadd, pcod_gadd,
      pcod_imul, pcod_fmul, pcod_gmul:
        if LGT_CTE_IN_2( lgt ) then
        if 
        begin

        end;
    otherwise
    end
  end
end LGT_FIT_OPER;
*)




begin { LGT_SCAN }
  if head <> nil then
  with head^ do
  begin
    case lgt_kind of
      lgt_dynall:
        begin { This node is used only to induce the LGT_SCAN }
          lgt1 := lgt_parmlst;
          { Save old insert list and init new one's to empty }
          while lgt1 <> nil do
          begin
            LGT_SCAN( lgt1 );
            lgt1 := lgt1^.lgt_nxt
          end
        end;

      lgt_ctlflow:
        begin
          case lgt_stm of
            stm_case:
              LGT_SCAN_CASE( lgt_parmlst, lgt_disp );

            stm_if:
              if lgt_parmlst <> nil then
              begin
                LGT_SCAN( lgt_parmlst );                       { Management of Boolean expression }
                lgt1 := lgt_parmlst^.lgt_nxt;
                while lgt1 <> nil do
                begin
                  if lgt_typ = nil then LGT_SCAN_BLOCK( lgt1 )
                                   else LGT_SCAN( lgt1 );
                  lgt1 := lgt1^.lgt_nxt
                end
              end;

            stm_goto:
              begin { * Link to more common section }
              end;

            stm_sequence, stm_parallel, stm_loop, stm_for:
              begin
                lgt1 := lgt_parmlst; lgt2 := nil;
                if (lgt_stm = stm_for) or (lgt_stm = stm_loop) then
                begin
                  LGT_SCAN( lgt1 );
                  lgt2 := lgt1; lgt1 := lgt1^.lgt_nxt
                end;
                { Save old insert list and init new one's to empty }
                lgt_insavhde := lgt_inshde; lgt_insavlst := lgt_inslst;
                lgt_inslst := nil; lgt_inshde := nil;
                while lgt1 <> nil do
                begin
                  LGT_SCAN( lgt1 );
                  if lgt_inslst <> nil then                    { We have some nodes to insert }
                    if lgt2 = nil then LGT_DO_INSERT( head, true )
                                  else LGT_DO_INSERT( lgt2, false );
                  lgt2 := lgt1; lgt1 := lgt1^.lgt_nxt
                end;
                { Restore the old insert list }
                lgt_inshde := lgt_insavhde; lgt_inslst := lgt_insavlst
              end;

            stm_exit: { * Only for the condition }
              begin
                lgt1 := lgt_parmlst;                           { There are always a Null node for the target ref. }
                lgt2 := lgt1^.lgt_parmlst;
                while lgt2 <> nil do
                  if lgt2^.lgt_kind = lgt_srcinfo then
                    lgt2 := lgt2^.lgt_nxt
                   else
                     begin
                       lgt1^.lgt_parmlst := lgt2; lgt2 := nil
                     end;
                LGT_SCAN( lgt1^.lgt_nxt )
              end;

            stm_return: { * Scan the expression to return }
              LGT_SCAN( lgt_parmlst );

          otherwise
          end
        end;

      lgt_srcinfo:
        begin
          lgt1 := lgt_parmlst;
          while lgt1 <> nil do
          begin
            LGT_SCAN( lgt1 );
            lgt1 := lgt1^.lgt_nxt
          end
        end;

      lgt_codep:
        if lgt_parmlst <> nil then
        begin
          case lgt_pcode of
            pcod_iadd:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_ineg ) then
                  lgt_pcode := pcod_isub
              end;
            pcod_fadd:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_fneg ) then
                  lgt_pcode := pcod_fsub
              end;
            pcod_gadd:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_gneg ) then
                  lgt_pcode := pcod_gsub
              end;

            pcod_isub:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_ineg ) then
                  lgt_pcode := pcod_iadd
              end;
            pcod_fsub:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_fneg ) then
                  lgt_pcode := pcod_fadd
              end;
            pcod_gsub:
              begin
                LGT_SCAN( lgt_parmlst );
                if LGT_CHECK_UNA( lgt_parmlst^.lgt_nxt, pcod_gneg ) then
                  lgt_pcode := pcod_gadd
              end;

            pcod_ineg:
              if LGT_CHECK_UNA( lgt_parmlst, pcod_ineg ) then
                lgt_pcode := pcod_noop;
            pcod_fneg:
              if LGT_CHECK_UNA( lgt_parmlst, pcod_fneg ) then
                lgt_pcode := pcod_noop;
            pcod_gneg:
              if LGT_CHECK_UNA( lgt_parmlst, pcod_gneg ) then
                lgt_pcode := pcod_noop;

            pcod_not:
              if LGT_CHECK_UNA( lgt_parmlst, pcod_not ) then
                lgt_pcode := pcod_noop;
            pcod_com:
              if LGT_CHECK_UNA( lgt_parmlst, pcod_com ) then
                lgt_pcode := pcod_noop;

            pcod_imod:
              begin
                lgt1 := lgt_parmlst;
                if lgt1 <> nil then
                begin
                  LGT_SCAN( lgt1 ); lgt1 := lgt1^.lgt_nxt;
                  if lgt1 <> nil then
                  begin
                    LGT_SCAN( lgt1 );
                    if LGT_IMASKP2( lgt1 ) >= 0 then lgt_pcode := pcod_band
                  end
                end
              end;

          otherwise
            lgt1 := lgt_parmlst;
            while lgt1 <> nil do
            begin
              LGT_SCAN( lgt1 ); lgt1 := lgt1^.lgt_nxt
            end
          end
        end;

      lgt_refer:
        begin { * To generate a reference of a simple expression }
          lgt1 := lgt_parmlst;
          if (not binline) and (lgt1 <> nil) and (lgt_typ <> nil) then
          if lgt1^.lgt_kind = lgt_const then
          begin { Set the simple constant as a data constant }
            lgt_parmlst := nil;
            lgt_kind    := lgt_const;
            lgt_disp    := lgt_disp + lgt1^.lgt_disp;
            if lgt_lrf in lgt1^.lgt_status then
            begin { Link reference exist => creates a new lgt node }
              lgt_cte  := nil;
              VAL_COPY( lgt1^.lgt_cte, lgt_cte, false )
            end
            else
            begin { Can free the old lgt node }
              lgt_cte := lgt1^.lgt_cte;
              VAL_NEW( lgt_cte, lgt_typ );
              LGT_FREE( lgt1 )
            end;
            { Now set the node as a data section allocation }
            if lgt_cte <> nil then
            with lgt_cte^ do
              if val_all = nil then
              begin
                ALL_NEW( val_all, lgt_typ, lgt_lide, var_data );
                if all_fdata = nil then all_fdata := val_all
                                   else all_ldata^.all_nxt := val_all;
                val_all^.all_prd := all_ldata;
                all_ldata := val_all;
                with val_all^ do
                begin
                  all_cte  := lgt_cte;
                  with all_cte^ do
                    val_nuse := val_nuse + 1;
                  all_first_u := head; all_last_u := head
                end
              end
              else
              with val_all^ do
              begin
                if all_first_u = nil then all_first_u := head
                                     else all_last_u^.lgt_parmlst := head;
                all_last_u := head
              end
          end
          else
          begin { Expression as a by value Effective Parameter }
            LGT_SCAN( lgt1 );
            lgt_disp   := IDE_TYP_ALIGN( stack_curr, lgt_typ );
            stack_curr := lgt_disp + lgt_typ^.typ_size;
            if stack_size < stack_curr then stack_size := stack_curr
          end
        end;

      lgt_index, lgt_indir, lgt_offset, lgt_address, lgt_iproref, lgt_srvcall:
        begin
          lgt1 := lgt_parmlst;
(*
if lgt_kind = lgt_indir then
begin
  WRITELN( lst_current^.lst_file, ' Indir node' );
  LGT_WRITE_TREE( 10, head );
end;
*)
          while lgt1 <> nil do
          begin
            LGT_SCAN( lgt1 ); lgt1 := lgt1^.lgt_nxt
          end
        end;

      lgt_empty: { Nothing to do : Can be used to set a label at the end of a sequence };

      lgt_null: { Link to more common section }
        begin { /// should not be used /// }
            { LGT_SCAN( lgt_parmlst ) }
        end;

      lgt_call, lgt_icall:
        with lgt_pro^ do
          if prf_inline in pro_flags then LGT_INLINE_EXP( head )       { Only possible for generic entry } 
          else
          begin { pro_decl or other true call }
            stack_save := stack_curr;
            pf   := pro_parmlst;                               { Get the formal argument list head }
            lgt1 := lgt_parmlst;                               { Get the effective argument list head }
            if lgt_kind = lgt_icall then
            begin { * Indirect call => the first arg. is the entry pointer }
              LGT_SCAN( lgt1 );                                { Scan the entry expression }
              lgt1 := lgt1^.lgt_nxt                            { Skip to the begin of argument list }
            end
            else
            begin { * Direct call }
              pro_flags := pro_flags + [prf_refer];            { Flag the use of reference of Formal Entry }
              if pro_flags*[prf_define,prf_callfw] = [] then
                pro_flags := pro_flags + [prf_callfw];         { Flag when reference before definition }
              if pro_pkind = pro_formal then
                if curr_lex <> pro_lex then
                  pro_flags := pro_flags + [prf_intaccess]     { Flag any formal entry internal call }
            end;
            while lgt1 <> nil do
            begin
              LGT_SCAN( lgt1 );
              if lgt1^.lgt_typ <> nil then
              begin
                if var_image in pf^.ide_vacc then
                with pf^, lgt1^.lgt_typ^ do
                  { Allocate or/and use ennum table }
                  case typ_form of
                    form_lit:
                      if typ_idetab <> nil then LGT_SCAN( typ_idetab );
                    form_set, form_lset:
                      if typ_seltype <> nil then
                      with typ_seltype^ do
                        if typ_form in [form_lit,form_int,form_char] then
                          if typ_idetab <> nil then LGT_SCAN( typ_idetab );
                  otherwise
                  end
              end;
              pf   := pf^.ide_nxt;
              lgt1 := lgt1^.lgt_nxt
            end;
            stack_curr := stack_save
          end;

      lgt_proref:
        with lgt_pro^ do
        begin
          pro_flags := pro_flags + [prf_refer];                { Flag the use of reference of Formal Entry }
          if not (prf_define in pro_flags) then
            pro_flags := pro_flags + [prf_callfw];             { Flag when reference before definition }
          if curr_lex <> pro_lex then
            pro_flags := pro_flags + [prf_intaccess]           { Flag the Internal Reference when required }
        end;

      lgt_srvret,
      lgt_result: LGT_SCAN( lgt_parmlst );

      lgt_varbl:
        if not binline then
        begin { Nothing to do for inline procedure/function }
          if lgt_ide <> nil then { A declared variable }
          with lgt_ide^ do
          begin { We must allocate some address to each variable }
            { It is always a variable access }
            { Cannot be a var_result access }
            if ide_all = nil then
            begin
              { The first variable access to a decl/declin must be
                with a more internal lex level if used in a local
                function/procedure. In this case we change decl/declin
                to local/localin, and to decltmp/decltmpin in the normal
                owner access }
              ide_vacc := ide_vacc + [var_used];
              if curr_lex <> ide_lex then
                ide_vacc := ide_vacc + [var_intaccess];
              ALL_NEW( ide_all, ide_typ, lgt_ide, ide_vkind );
              if var_intaccess in ide_vacc then
                ide_all^.all_first_u := nil { unusable }
              else
                ide_all^.all_first_u := head;
              case ide_vkind of
                var_imported,
                var_standard,
                var_external:
                  begin
                    if all_fextern = nil then all_fextern := ide_all
                                         else all_lextern^.all_nxt := ide_all;
                    ide_all^.all_prd := all_lextern;
                    all_lextern := ide_all
                  end;

                var_global:
                  begin
                    ide_all^.all_cte := ide_inival;
                    if all_fglobal = nil then all_fglobal := ide_all
                                         else all_lglobal^.all_nxt := ide_all;
                    ide_all^.all_prd := all_lglobal;
                    all_lglobal := ide_all
                  end;

                var_tmp,
                var_decl:
                  if ide_lex <= 1 then
                  begin
                    ide_all^.all_cte := ide_inival;
                    if all_fstatic = nil then all_fstatic := ide_all
                                         else all_lstatic^.all_nxt := ide_all;
                    ide_all^.all_prd := all_lstatic;
                    all_lstatic := ide_all
                  end
                  else
                  with ide_owner^ do
                  begin { True automatic variable }
                    if pro_fdyn_all = nil then pro_fdyn_all := ide_all
                                          else pro_ldyn_all^.all_nxt := ide_all;
                    ide_all^.all_prd := pro_ldyn_all;
                    pro_ldyn_all := ide_all
                  end;

                var_static:
                  begin
                    ide_all^.all_cte := ide_inival;
                    if all_fstatic = nil then all_fstatic := ide_all
                                         else all_lstatic^.all_nxt := ide_all;
                    ide_all^.all_prd := all_lstatic;
                    all_lstatic := ide_all
                  end;
              otherwise
              end
            end
            else
              with ide_all^ do
              case ide_vkind of
                var_standard, var_external,
                var_static, var_global, var_decl, var_imported:
                  if (all_last_u <> nil) and (all_last_u <> head) then
                    all_last_u^.lgt_parmlst := head;

                var_formal, var_vformal:
                  begin
                    ide_vacc := ide_vacc + [var_used];
                    if curr_lex <> ide_lex then
                      ide_vacc := ide_vacc + [var_intaccess];
                    all_acc  := ide_vacc
                  end;
 
              otherwise
              end;
            lgt_alloc := ide_all;
            ide_all^.all_last_u := head
          end
          else { Temporary object reference }
          begin
            if lgt_alloc = nil then ALL_NEW( lgt_alloc, lgt_typ, nil, var_tmp );
            with lgt_alloc^ do
            begin
              if all_first_u = nil then
              begin { First reference }
                if all_lex <= 1 then
                begin
                  if all_fstatic = nil then all_fstatic := lgt_alloc
                                       else all_lstatic^.all_nxt := lgt_alloc;
                  lgt_alloc^.all_prd := all_lstatic;
                  all_lstatic := lgt_alloc
                end
                else
                with all_owner^ do
                begin { True automatic variable }
                  if pro_fdyn_all = nil then pro_fdyn_all := lgt_alloc
                                        else pro_ldyn_all^.all_nxt := lgt_alloc;
                  lgt_alloc^.all_prd := pro_ldyn_all;
                  pro_ldyn_all := lgt_alloc
                end;
                all_first_u := head; all_last_u := head;

                { Now insert the descriptor init statements when required }
                with lgt_typ^ do
                if (typ_descr_size > 0) and (typ_parmlst <> nil) then
                begin
                  pf := typ_parmlst;
                  while pf <> nil do
                  begin
                    { Get access to the tmp variable }
                    LGT_NEW_COPY( head, lgt2 );
                    lgt2^.lgt_typ  := pf^.ide_typ;
                    lgt2^.lgt_disp := pf^.ide_toffset;
                    lgt2^.lgt_nxt  := LGT_NEW_ECONST( pf^.ide_typ,
                                                    pf^.ide_cteval^.val_ival );
                    lgt1 := LGT_NEW_CODE( pcod_istore, lgt2 );
                    if lgt_inshde = nil then lgt_inshde := lgt1
                                        else lgt_inslst^.lgt_nxt := lgt1;
                    lgt_inslst := lgt1;
                    pf := pf^.ide_nxt
                  end
                end
              end
              else
              begin
                if all_first_u = nil then all_first_u := head
                                     else all_last_u^.lgt_parmlst := head;
                all_last_u := head
              end
            end
          end
        end;

      lgt_agregat:
        begin
          lgt1 := lgt_parmlst;
          LGT_SCAN( lgt1 );
          lgt1 := lgt1^.lgt_nxt;
          if lgt1 <> nil then lgt1 := lgt1^.lgt_nxt;
          while lgt1 <> nil do
          begin
            LGT_SCAN( lgt1 ); lgt1 := lgt1^.lgt_nxt
          end
        end;

      lgt_const:
        if not binline then
          { Nothing to do for inline procedure/function }
          { The small constant can be stay as immediat value,
            but the other must be have a static address to allocate
            in the appropriate lex if no address is already given }
          if lgt_cte <> nil then
          with lgt_cte^ do
          begin
            if val_typ <> nil then
            with val_typ^ do
              if not typ_simple then
                if lgt_typ^.typ_simple then
                  { Extract the simple value from the structured cte. }
                  LGT_EXTRACT_CTE( head )
                else
                begin
                  if val_all = nil then
                  begin { Create the Cte Memory allocation }
                    svsz := typ_size; { We must Preserve the Original Type size}
                    if val_size > 0 then
                      if lgt_typ = typ_std[form_record] then
                        typ_size := val_size + typ_descr_size
                      else
                        typ_size := val_size;
                    ALL_NEW( val_all, lgt_typ, lgt_lide, var_data );
                    typ_size := svsz;
                    if all_fdata = nil then all_fdata := val_all
                                       else all_ldata^.all_nxt := val_all;
                    val_all^.all_prd := all_ldata;
                    all_ldata := val_all;
                    with val_all^ do
                    begin
                      all_cte  := lgt_cte;
                      with all_cte^ do
                        val_nuse := val_nuse + 1;
                      all_first_u := head; all_last_u := head
                    end
                  end
                end;


            if not lgt_typ^.typ_simple then
              if val_kind <> form_wild then { Do not handle any case table }
                if val_all = nil then
                begin
                                 {/// ident_ptr was nil before ///}
                end
                else
                  with val_all^ do
                  begin
                    if all_first_u = nil then all_first_u := head
                                         else all_last_u^.lgt_parmlst := head;
                    all_last_u := head
                  end;
          end;

    otherwise
    end
  end
end LGT_SCAN;



[global]
procedure LGT_ALL_FPARM( pr: pro_ptr );
{ Called by PROC_BODY to allocate room for Formal parameters }
var
  fp: ide_ptr;
  lg: lgt_ptr;

begin
  with pr^ do
  begin
    fp := pro_parmlst;
    while fp <> nil do
    begin
      with fp^ do
        if ide_class = cla_fentry then
        begin
          ALL_NEW( ide_f_all, typ_std[form_nil], fp, var_pformal );
          ide_entry^.pro_f_all := ide_f_all
        end
        else
        begin
          ALL_NEW( ide_all, typ_std[form_nil], fp, ide_vkind );
          if ide_typ <> nil then
          with ide_typ^ do
            if (not typ_simple) and (ide_vkind = var_vformal) and
               (typ_size < 0) then
            begin
              { All_size_exp is set as the size expr. for dynamic by value } 
              lg := LGT_NEW_IDREF( fp, nil );
              ide_all^.all_size_exp := LGT_TYPE_EVAL( typ_comp_size, lg )
            end
        end;
      fp := fp^.ide_nxt
    end
  end
end LGT_ALL_FPARM;



procedure LGT_ALL_DYNAMIC( pr: pro_ptr );
{ For the first version, Only the formal by value can be dynamics }
var
  fp:            ide_ptr;
  lg0, lg1, lg2: lgt_ptr;

begin
  lg1 := nil;
  with pr^ do
  begin
    fp := pro_parmlst;
    while fp <> nil do
    begin                                      { Scan the Formal List }
      with fp^ do
        if (ide_class = cla_varbl) and (ide_all <> nil) then
        with ide_all^ do                       { For all allocated formal except entry points }
          if all_size_exp <> nil then
          begin                                { When an expression size is specified by LGT_ALL_FPARM }
            { Append to a list of Size expression(s) }

            lg0 := all_size_exp;
            if lg1 = nil then lg1 := lg0
                         else lg2^.lgt_nxt := lg0;
            lg2 := lg0
          end;
      fp := fp^.ide_nxt
    end;

    { When some dynamic object(s) must be created }
    if lg1 <> nil then { Not empty list }
    begin { Now create a lgt_dynall node to pack all this dynamic ref. }
      LGT_NEW( lg0, nil, lgt_dynall, lg1 );
      { and insert it in the procedure code }
      if pro_lgt = nil then
        pro_lgt := lg0                         { Empty code Procedure/Function }
      else
      with pro_lgt^ do
        if (lgt_kind = lgt_ctlflow) and (lgt_stm = stm_sequence) then
        begin                                  { Insert the new node before the procedure/function code }
          lg0^.lgt_nxt := lgt_parmlst;
          lgt_parmlst  := lg0
        end
        else
        begin                                  { One statement Procedure/Function: build a Procedure sequ. }
          lg0^.lgt_nxt := pro_lgt;
          LGT_NEW( pro_lgt, nil, lgt_ctlflow, lg0 );
          pro_lgt^.lgt_stm := stm_sequence
        end
    end
  end
end LGT_ALL_DYNAMIC;



[global]
procedure LGT_PASS1_COMPLET( pr: pro_ptr );
begin { LGT_PASS1_COMPLET }
  lgt_inshde        := nil; { set insert queue to empty }
  lgt_inslst        := nil;
  stack_size        :=   0; { Set dynamic stack to empty state }
  stack_curr        :=   0;

  with pr^ do
  begin
    pro_flags := pro_flags + [prf_define];
    { do an all_rec allocation for each procedure parameter }
    binline  := (pro_pkind = pro_inline);
    LGT_ALL_DYNAMIC( pr ); { Create all the dynamic objects when required }
    LGT_SCAN( pro_lgt );
    pro_stk_size := stack_size
  end
end LGT_PASS1_COMPLET;

end.
