/*  P A S - P. WOLFERS SOFTWARE: V3.1-B2 OF 30-JUN-2016 
  ***  PASCAL II implementation in C. *** */

/* Set specific Macro setting. */
#define CC_TYPE_SW short
#define CC_TYPE_SL   int
#define CC_TYPE_SQ  long long int

/* Include the PAS environment file. */
#include "/home/pierre/Soft/cpsh_kits/cpascal_src_V3.2A0/cpas_defs.h"

/* Define the local data section. */
static Blk( Rd, 1624 ) = {
  7,   7, 116,  97,  98,  95, 110, 101, 119,  61,  61,  47, 104, 111, 109, 101,
 47, 112, 105, 101, 114, 114, 101,  47,  83, 111, 102, 116,  47,  99, 112, 115,
104,  95, 107, 105, 116, 115,  47,  99, 112,  97, 115,  99,  97, 108,  95, 115,
114,  99,  95,  86,  51,  46,  50,  65,  48,  47, 112,  99, 109, 112,  95, 105,
100, 101, 110, 116,  46, 112,  97, 115,   8,   8, 116,  97,  98,  95, 102, 114,
101, 101,   8,   8, 115, 116, 114,  95,  99, 111, 112, 121,  11,  11, 115, 114,
 99,  95, 101, 114, 114, 111, 114,  95, 115,   7,   7, 118,  97, 108,  95, 110,
101, 119,   8,   8, 118,  97, 108,  95, 102, 114, 101, 101,   4,   4,  86,  70,
 82,  69,  13,  13, 118,  97, 108,  95, 102, 114, 101, 101,  95, 116, 114, 101,
101,   8,   8, 118,  97, 108,  95,  99, 111, 112, 121,   7,   7,  97, 108, 108,
 95, 110, 101, 119,   8,   8,  97, 108, 108,  95, 102, 114, 101, 101,   7,   7,
108, 103, 116,  95, 110, 101, 119,  11,  11,  97, 108, 108,  95, 110, 101, 119,
 95, 116, 109, 112,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,  99, 111,
112, 121,  13,  13, 108, 103, 116,  95,  99, 111, 112, 121,  95, 116, 114, 101,
101,   8,   8, 108, 103, 116,  95, 102, 114, 101, 101,  13,  13, 108, 103, 116,
 95, 102, 114, 101, 101,  95, 116, 114, 101, 101,  14,  14, 108, 103, 116,  95,
110, 101, 119,  95, 101,  99, 111, 110, 115, 116,  15,  15, 108, 103, 116,  95,
110, 101, 119,  95, 101,  99, 111, 110, 115, 116, 114,  14,  14, 108, 103, 116,
 95, 103, 101, 116,  95, 101,  99, 111, 110, 115, 116,  11,  11, 108, 103, 116,
 95, 105, 109,  97, 115, 107, 112,  50,  12,  12, 108, 103, 116,  95, 110, 101,
119,  95,  99, 111, 100, 101,  12,  12, 108, 103, 116,  95, 110, 101, 119,  95,
 99,  97, 108, 108,   8,   8, 108, 103, 116,  95, 108, 105, 110, 107,  13,  13,
108, 103, 116,  95, 110, 101, 119,  95, 105, 100, 114, 101, 102,  10,  10, 108,
103, 116,  95, 116, 109, 112, 114, 101, 102,  14,  14, 108, 103, 116,  95, 110,
101, 119,  95,  97, 100, 100, 115, 117,  98,  14,  14, 110, 101, 119,  95, 100,
105, 115, 112,  95, 108, 101, 118, 101, 108,   4,   4,  78,  68,  76,  86,  16,
 16, 105, 100, 101,  95, 114, 101, 115, 101, 114, 118, 101,  95, 100, 105, 115,
112,   5,   5, 109,  97, 116,  99, 104,  12,  12, 110, 101, 119,  95, 105, 110,
116,  95, 110,  97, 109, 101,  12,  12, 108, 101, 118, 101, 108,  95, 115, 101,
 97, 114,  99, 104,  10,  10, 108, 101, 120,  95, 115, 101,  97, 114,  99, 104,
  9,   9,  97, 110, 121,  95,  99, 108,  97, 115, 115,   7,   7, 105, 100, 101,
 95, 110, 101, 119,   4,   4,  78,  69,  87,  73,  10,  10, 105, 100, 101,  95,
115, 101,  97, 114,  99, 104,   4,   4,  83,  82,  67,  73,  11,  11, 103, 101,
110,  95,  99, 110, 116, 120, 118,  97, 114,  12,  12, 108, 103, 116,  95, 110,
101, 119,  95, 108, 105, 110, 101,  13,  13, 103, 101, 110,  95, 108, 105, 110,
101, 116, 114,  97,  99, 101,  11,  11, 108,  97,  98, 101, 108,  95, 112, 117,
114, 103, 101,   4,   4,  76,  65,  66,  80,  14,  14, 116, 121, 112,  95,  97,
108, 105, 103, 110, 101, 109, 101, 110, 116,  13,  13, 105, 100, 101,  95, 116,
121, 112,  95,  97, 108, 105, 103, 110,  16,  16,  97, 108, 108,  95, 116, 121,
112,  95,  97, 108, 108, 111,  99,  97, 116, 101,  12,  12,  99, 116, 101,  95,
 97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 105, 100, 101,  95, 110, 101,
119,  95, 116, 121, 112,  17,  17, 105, 100, 101,  95, 110, 101, 119,  95, 116,
121, 112,  95, 114,  97, 110, 103, 101,  15,  15, 116, 109, 112, 115, 116, 107,
 95,  97, 108, 108, 111,  99,  97, 116, 101,  11,  11, 116, 109, 112, 115, 116,
107,  95, 102, 114, 101, 101,  13,  13, 102, 114, 101, 101,  95, 105, 100, 101,
 95, 108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95, 116, 121, 112,  95,
108, 105, 115, 116,  13,  13, 102, 114, 101, 101,  95, 111, 112, 101,  95, 108,
105, 115, 116,  17,  17, 102, 114, 101, 101,  95, 103, 101, 110, 101, 114, 105,
 99,  95, 108, 105, 115, 116,  12,  12, 105, 100, 101,  95, 102, 114, 101, 101,
 95, 108, 101, 120,  15,  15, 105, 100, 101,  95,  99, 114, 101,  97, 116, 101,
 95, 110,  97, 109, 101,  13,  13, 105, 100, 101,  95, 105, 110, 116,  95, 108,
 97,  98, 101, 108,   4,   4,  73,  76,  65,  66,  22,  22, 105, 100, 101,  95,
115, 101,  97, 114,  99, 104,  95, 102, 114, 111, 109,  95, 110,  97, 109, 101,
105, 100,  15,  15, 115, 101, 116,  95, 103,  98, 108,  95, 100, 101, 102,  95,
110,  97, 109,  16,  16, 115, 101, 116,  95, 101, 110, 118,  95, 102, 105, 108,
101,  95, 115, 112,  99,  13,  13, 119, 105, 101, 119,  95, 111, 112, 101, 114,
 95, 100, 101, 102,  15,  15,  32,  42,  32,  72, 101, 114, 101,  32, 105, 115,
 32, 116, 104, 101,  32,  23,  23,  32, 101, 110, 116, 114, 121,  32, 100, 101,
102, 105, 110, 105, 116, 105, 111, 110,  32, 108, 105, 115, 116,  58,   0,   0,
 33,   0,   0,   0,  17,   0,   9, 102, 111, 114, 109,  95,  99, 104,  97, 114,
  0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114, 109,  95, 108, 105,
116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114, 109,  95,
105, 110, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114,
109,  95, 115, 105, 110, 103, 108, 101,   0,   0,   0,   0,   0,   0,  11, 102,
111, 114, 109,  95, 100, 111, 117,  98, 108, 101,   0,   0,   0,   0,   0,   0,
 12, 102, 111, 114, 109,  95, 112, 111, 105, 110, 116, 101, 114,   0,   0,   0,
  0,   0,  11, 102, 111, 114, 109,  95, 102, 101, 110, 116, 114, 121,   0,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 105, 108, 101,   0,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,  97, 114, 114,  97,
121,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95,  99, 111,
110, 102,   0,   0,   0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95,
114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,   0,   8, 102, 111, 114,
109,  95, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,   0,   9, 102,
111, 114, 109,  95, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,   0,
  8, 102, 111, 114, 109,  95, 110, 105, 108,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 119, 108, 105, 116,   0,   0,   0,   0,
  0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 101, 110, 110, 117, 109,   0,
  0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95, 119, 102, 105, 108,
101,   0,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 119, 115,
101, 116,   0,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114, 109,  95,
119, 108, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,  10, 102, 111, 114,
109,  95, 119, 119, 115, 101, 116,   0,   0,   0,   0,   0,   0,   0,  12, 102,
111, 114, 109,  95, 119, 114, 101,  99, 111, 114, 100,   0,   0,   0,   0,   0,
  9, 102, 111, 114, 109,  95, 119, 105, 108, 100,   0,   0,   0,   0,   0,   0,
  0,   0,  10, 102, 111, 114, 109,  95, 114,  97, 110, 103, 101,   0,   0,   0,
  0,   0,   0,   0,  12, 102, 111, 114, 109,  95, 118,  97, 114, 105,  97, 110,
116,   0,   0,   0,   0,   0,  17, 102, 111, 114, 109,  95, 111, 114, 103,  97,
110, 105, 122,  97, 116, 105, 111, 110,  16, 102, 111, 114, 109,  95,  99, 111,
110, 115, 116, 114, 117,  99, 116, 111, 114,   0,  12, 102, 111, 114, 109,  95,
112, 114, 105, 118,  97, 116, 101,   0,   0,   0,   0,   0,  12, 102, 111, 114,
109,  95, 103, 101, 110, 101, 114, 105,  99,   0,   0,   0,   0,   0,   9, 102,
111, 114, 109,  95, 101, 113, 115, 116,   0,   0,   0,   0,   0,   0,   0,   0,
  9, 102, 111, 114, 109,  95, 101, 113, 117, 118,   0,   0,   0,   0,   0,   0,
  0,   0,   9, 102, 111, 114, 109,  95, 101, 113, 115, 101,   0,   0,   0,   0,
  0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 110, 117, 108, 108,   0,   0,
  0,   0,   0,   0,   0,   0,  11, 102, 111, 114, 109,  95, 115, 116, 114, 105,
110, 103,   0,   0,   0,   0,   0,   0,   9, 102, 111, 114, 109,  95, 102, 114,
101, 101,   0,   0,   0,   0,   0,   0,   0,   0,   2,   2,  44,  32,   4,   4,
 32,  61,  62,  32,  10,  10,  80, 114, 111,  99, 101, 100, 117, 114, 101,  32,
  9,   9,  70, 117, 110,  99, 116, 105, 111, 110,  32,   2,   2,  58,  32,   5,
  5,  60,  70,  82,  77,  61,   2,   2,  44,  32,   2,   2,  58,  32,   5,   5,
 60,  70,  82,  77,  61,   0,   0,   0
};

/* Define the local static Initialized section. */
static Blk( Ri, 264 ) = {
  0, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  0,   0,   0,   0,   0,   0,   0,   0
};

/* Define the local static section. */
static Blk( Rs, 16 );

/* Declaration of external variables. */
extern V V_val_free_list;
extern SL V_curr_lex;
extern V V_all_free_list;
extern V V_pro_current;
extern UB V_cmp_genenv;
extern V V_lgt_free_list;
extern V V_int_typ;
extern SL V_curr_disp;
extern Blk(V_lex_ident_tree, 4160 );
extern V V_curr_ident;
extern Blk(V_sy_ident, 32 );
extern SL V_ident_disp;
extern Blk(V_lex_ident_level, 128 );
extern SL V_cprc_disp;
extern UB V_cmp_twicedclon;
extern UB V_cmp_twicedcl;
extern SL V_cmp_igenv;
extern UB V_sy_var_init_mod;
extern V V_std_inp_file;
extern V V_std_out_file;
extern V V_std_err_file;
extern Blk(V_sy_string, 264 );
extern UB V_err_prt;
extern Blk(V_ide_udptr, 120 );
extern V V_cntx_varbl;
extern V V_cntx_typ;
extern SL V_cmp_trace;
extern V V_src_control;
extern SL V_cmp_tracecount;
extern UB V_cntx_srinf;
extern Blk(V_typ_std, 272 );
extern V V_srf_list;
extern V V_cntx_label;
extern SL V_cntx_lblvl;
extern V V_all_fdata;
extern V V_all_ldata;
extern SL V_inte_size;
extern V V_wildtmp_stk;
extern V V_wildtmp_typ;
extern Blk(V_wildtmp_pal, 8 );
extern SL V_wildtmp_psz;
extern Blk(V_ope_table, 240 );
extern SL V_sy_ival;
extern Blk(V_sy_sym, 8 );
extern V V_env_first;
extern V V_env_last;
extern V PAS__f_output;
extern Blk(V_opname, 960 );


/* Function/procedure prototypes. */
void P_err_put_symbol(V F_symb, SL F_len);
void P_src_error(V F_modnam, SL F_number, UB F_severity);
void P_val_free_tree(V *F_p);
void P_free_typ_list(V *F_p);
void P_free_generic_list(V *F_f, V *F_l);


/* Procedure/Function : " tab_new "  */
V P_tab_new(SL F_sz){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=92; /* line # 92 */
  Ret=PAS__NEW(F_sz*4);
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " tab_free "  */
void P_tab_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );


  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+72;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=101; /* line # 101 */
  PAS__DISPOSE(F_p);
  Ra.sl[6]=102; /* line # 102 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " str_copy "  */
void P_str_copy(V *F_target, V *F_src){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register UB Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+82;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=114; /* line # 114 */
  if ((*F_target)!=(*F_src)) {
    Ra.sl[6]=115; /* line # 115 */
    if ((*F_src)==NULL) {
      Ra.sl[6]=117; /* line # 117 */
      if ((*F_target)!=NULL) ((UB *)(*F_target))[1]=0;
    }
    else {
      Ra.sl[6]=122; /* line # 122 */
      if (((UB *)(*F_src))[1]>0&&(*F_target)==NULL) {
        Rv0=((UB *)(*F_src))[1];
        (*F_target)=PAS__NEW((SL)Rv0+2);
        ((UB *)(*F_target))[0]=Rv0;
      }
      Ra.sl[6]=123; /* line # 123 */
      (*F_target)=(*F_src);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " src_error_s "  */
void P_src_error_s(V F_modulesy, SL F_number, UB F_severity, V F_id1, V F_id2){
  /* Define the automatic variable space. */
  Blk( Ra, 72 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  memcpy( Ra.s+68,F_modulesy,4);
  Ra.ub[0]=32;
  Ra.v[5]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s+40;
  Ra.v[6]=Rd.s+92;
  Ra.v[7]=Rd.s+9;
  Ra.sl[16]=138; /* line # 138 */
  if (F_id1!=NULL) {
    Ra.sl[16]=139; /* line # 139 */
    Ra.sl[16]=141; /* line # 141 */
    Ra.ub[1]=((UB *)F_id1)[0];
    Ra.sl[16]=142; /* line # 142 */
    Rv0=1;
    for( Rf0=((UB *)F_id1)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv0+1]=((C *)F_id1)[Rv0];
      Rv0++;
    }
    Ra.sl[16]=143; /* line # 143 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[16]=145; /* line # 145 */
  if (F_id2!=NULL) {
    Ra.sl[16]=146; /* line # 146 */
    Ra.sl[16]=148; /* line # 148 */
    Ra.ub[1]=((UB *)F_id2)[0];
    Ra.sl[16]=149; /* line # 149 */
    Rv1=1;
    for( Rf0=((UB *)F_id2)[0];Rf0>0;Rf0-- ) {
      Ra.c[Rv1+1]=((C *)F_id2)[Rv1];
      Rv1++;
    }
    Ra.sl[16]=150; /* line # 150 */
    P_err_put_symbol(Ra.s+2,(SL)Ra.ub[1]);
  }
  Ra.sl[16]=152; /* line # 152 */
  P_src_error(Ra.s+68,F_number, F_severity);
  PAS__curr_cntx=Ra.v[5];
}


/* Procedure/Function : " val_new "  */
void P_val_new(V *F_p, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+105;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=161; /* line # 161 */
  if ((*F_p)==NULL) {
    Ra.sl[6]=163; /* line # 163 */
    if (V_val_free_list==NULL) {
      Ra.sl[6]=164; /* line # 164 */
      (*F_p)=PAS__NEW(64);
    }
    else {
      Ra.sl[6]=167; /* line # 167 */
      (*F_p)=V_val_free_list;
      Ra.sl[6]=168; /* line # 168 */
      V_val_free_list=((V *)(*F_p))[0];
    }
    Ra.sl[6]=170; /* line # 170 */
    Rv0=(*F_p);
    Ra.sl[6]=172; /* line # 172 */
    ((V *)Rv0)[0]=NULL;
    Ra.sl[6]=173; /* line # 173 */
    ((SL *)Rv0)[2]=0;
    Ra.sl[6]=174; /* line # 174 */
    ((SL *)Rv0)[3]=1;
    Ra.sl[6]=175; /* line # 175 */
    ((UW *)Rv0)[8]=16416;
    Ra.sl[6]=176; /* line # 176 */
    ((SL *)Rv0)[5]=-1;
    Ra.sl[6]=177; /* line # 177 */
    ((SL *)Rv0)[6]=0;
    Ra.sl[6]=178; /* line # 178 */
    ((SL *)Rv0)[7]=V_curr_lex;
    Ra.sl[6]=179; /* line # 179 */
    ((V *)Rv0)[4]=F_ty;
    Ra.sl[6]=180; /* line # 180 */
    ((V *)Rv0)[5]=NULL;
    Ra.sl[6]=181; /* line # 181 */
    if (F_ty==NULL) ((UB *)Rv0)[48]=31;
    else {
      Ra.sl[6]=184; /* line # 184 */
      ((UB *)Rv0)[48]=((UB *)F_ty)[92];
      Ra.sl[6]=185; /* line # 185 */
      switch (((UB *)Rv0)[48]) {
        case 0:
        case 1:
        case 2:
        case 14:
        case 15:
        case 22:Ra.sl[6]=188; /* line # 188 */
        ((SL *)Rv0)[13]=0;
        break;
        case 3:
        case 4:Ra.sl[6]=190; /* line # 190 */
        ((G *)Rv0)[7]=0.000000000000000E-001;
        break;
        case 32:Ra.sl[6]=192; /* line # 192 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=194; /* line # 194 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 12:
        case 18:Ra.sl[6]=196; /* line # 196 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 6:Ra.sl[6]=198; /* line # 198 */
        ((V *)Rv0)[7]=NULL;
        break;
        case 21:Ra.sl[6]=200; /* line # 200 */
        ((V *)Rv0)[7]=NULL;
        break;
        default:break;
      }
    }
  }
  else {
    Ra.sl[6]=207; /* line # 207 */
    Rv1=(*F_p);
    Ra.sl[6]=208; /* line # 208 */
    ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free "  */
void P_val_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+114;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=217; /* line # 217 */
  Rv0=(*F_p);
  Ra.sl[6]=218; /* line # 218 */
  if (((SL *)Rv0)[3]==1&&((UB *)Rv0)[48]!=33) {
    Ra.sl[6]=220; /* line # 220 */
    switch (((UB *)Rv0)[48]) {
      case 32:Ra.sl[6]=221; /* line # 221 */
      if (((V *)Rv0)[7]!=NULL) PAS__DISPOSE(((V *)Rv0)+7);
      break;
      case 8:
      case 9:
      case 10:Ra.sl[6]=223; /* line # 223 */
      P_val_free_tree(((V *)Rv0)+7);
      break;
      case 21:Ra.sl[6]=224; /* line # 224 */
      if (((V *)Rv0)[7]!=NULL) P_tab_free(((V *)Rv0)+7);
      break;
      case 12:Ra.sl[6]=225; /* line # 225 */
      if (((V *)Rv0)[7]!=NULL) PAS__DISPOSE(((V *)Rv0)+7);
      break;
      default:break;
    }
    Ra.sl[6]=228; /* line # 228 */
    ((SL *)Rv0)[3]=0;
    Ra.sl[6]=229; /* line # 229 */
    ((UB *)Rv0)[48]=33;
    Ra.sl[6]=230; /* line # 230 */
    ((V *)Rv0)[0]=V_val_free_list;
    Ra.sl[6]=231; /* line # 231 */
    ((SL *)Rv0)[2]=0;
    Ra.sl[6]=232; /* line # 232 */
    V_val_free_list=(*F_p);
  }
  else {
    Ra.sl[6]=235; /* line # 235 */
    if (((SL *)Rv0)[3]>1) ((SL *)Rv0)[3]=((SL *)Rv0)[3]-1;
    else {
      Ra.sl[6]=236; /* line # 236 */
      P_src_error(Rd.s+126,998,1);
    }
  }
  Ra.sl[6]=237; /* line # 237 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_free_tree "  */
void P_val_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+130;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=249; /* line # 249 */
  Rv0=(*F_p);
  Ra.sl[6]=250; /* line # 250 */
  (*F_p)=NULL;
  Ra.sl[6]=251; /* line # 251 */
  while (Rv0!=NULL){
    Ra.sl[6]=253; /* line # 253 */
    Rv1=Rv0;
    Ra.sl[6]=254; /* line # 254 */
    if (((SL *)Rv0)[3]>1) Rv0=NULL;
    else {
      Ra.sl[6]=255; /* line # 255 */
      Rv0=((V *)Rv0)[0];
    }
    Ra.sl[6]=256; /* line # 256 */
    P_val_free(&Rv1);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " val_copy "  */
void P_val_copy(V *F_v1, V *F_v2, UB F_bfree){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+145;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=272; /* line # 272 */
  if ((*F_v2)!=NULL) P_val_free(F_v2);
  Ra.sl[6]=273; /* line # 273 */
  if ((*F_v1)==NULL) (*F_v2)=NULL;
  else {
    Ra.sl[6]=275; /* line # 275 */
    if (F_bfree&&((SL *)(*F_v1))[3]==1) {
      Ra.sl[6]=277; /* line # 277 */
      (*F_v2)=(*F_v1);
      (*F_v1)=NULL;
    }
    else {
      Ra.sl[6]=281; /* line # 281 */
      P_val_new(F_v2,((V *)(*F_v1))[4]);
      Ra.sl[6]=282; /* line # 282 */
      memcpy((*F_v2),(*F_v1),64);
      Ra.sl[6]=283; /* line # 283 */
      Rv0=(*F_v2);
      Ra.sl[6]=285; /* line # 285 */
      ((V *)Rv0)[0]=NULL;
      Ra.sl[6]=286; /* line # 286 */
      ((SL *)Rv0)[3]=1;
      Ra.sl[6]=287; /* line # 287 */
      ((SL *)Rv0)[7]=V_curr_lex;
      Ra.sl[6]=288; /* line # 288 */
      switch (((UB *)Rv0)[48]) {
        case 32:Ra.sl[6]=290; /* line # 290 */
        if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[6]=292; /* line # 292 */
          ((V *)Rv0)[7]=NULL;
          Ra.sl[6]=293; /* line # 293 */
          P_str_copy(((V *)Rv0)+7,((V *)(*F_v1))+7);
        }
        break;
        case 8:
        case 9:
        case 10:Ra.sl[6]=297; /* line # 297 */
        if (((V *)Rv0)[7]!=NULL) {
          Ra.sl[6]=298; /* line # 298 */
          Rv1=((V *)Rv0)[7];
          Ra.sl[6]=299; /* line # 299 */
          ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
        }
        break;
        case 21:Ra.sl[6]=303; /* line # 303 */
        ((V *)Rv0)[7]=P_tab_new(((SL *)Rv0)[6]);
        Ra.sl[6]=304; /* line # 304 */
        Rv2=((V *)(*F_v1))[7];
        Ra.sl[6]=305; /* line # 305 */
        Rv3=0;
        for( Rf0=(((SL *)Rv0)[6]-1)+1;Rf0>0;Rf0-- ) {
          Ra.sl[6]=306; /* line # 306 */
          ((SL *)((V *)Rv0)[7])[Rv3]=((SL *)Rv2)[Rv3];
          Rv3++;
        }
        break;
        default:break;
      }
      Ra.sl[6]=312; /* line # 312 */
      if (F_bfree) P_val_free(F_v1);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new "  */
void P_all_new(V *F_p, V F_ty, V F_id, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+155;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=323; /* line # 323 */
  if (V_all_free_list==NULL) (*F_p)=PAS__NEW(112);
  else {
    Ra.sl[6]=326; /* line # 326 */
    (*F_p)=V_all_free_list;
    V_all_free_list=((V *)(*F_p))[0];
  }
  Ra.sl[6]=328; /* line # 328 */
  Rv0=(*F_p);
  Rv1=F_ty;
  Ra.sl[6]=330; /* line # 330 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[6]=331; /* line # 331 */
  ((V *)Rv0)[1]=NULL;
  Ra.sl[6]=332; /* line # 332 */
  memcpy(Rv0+16,Rv1+48,1);
  Ra.sl[6]=333; /* line # 333 */
  ((V *)Rv0)[3]=F_ty;
  Ra.sl[6]=334; /* line # 334 */
  ((UW *)Rv0)[16]=0;
  Ra.sl[6]=335; /* line # 335 */
  ((UB *)Rv0)[34]=F_kind;
  Ra.sl[6]=336; /* line # 336 */
  ((V *)Rv0)[5]=V_pro_current;
  Ra.sl[6]=337; /* line # 337 */
  ((SL *)Rv0)[12]=-1;
  Ra.sl[6]=338; /* line # 338 */
  ((SL *)Rv0)[13]=abs(((SL *)Rv1)[11]);
  Ra.sl[6]=339; /* line # 339 */
  ((SL *)Rv0)[14]=-1;
  Ra.sl[6]=340; /* line # 340 */
  ((SL *)Rv0)[15]=V_curr_lex;
  Ra.sl[6]=341; /* line # 341 */
  ((SL *)Rv0)[16]=-1;
  Ra.sl[6]=342; /* line # 342 */
  ((SL *)Rv0)[17]=-1;
  Ra.sl[6]=343; /* line # 343 */
  ((V *)Rv0)[9]=NULL;
  Ra.sl[6]=344; /* line # 344 */
  ((V *)Rv0)[10]=NULL;
  Ra.sl[6]=345; /* line # 345 */
  ((V *)Rv0)[11]=NULL;
  Ra.sl[6]=346; /* line # 346 */
  ((V *)Rv0)[12]=F_id;
  Ra.sl[6]=347; /* line # 347 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=349; /* line # 349 */
  if (F_id!=NULL&&((SL *)Rv1)[11]>0) {
    Ra.sl[6]=350; /* line # 350 */
    Rv2=F_id;
    Ra.sl[6]=352; /* line # 352 */
    ((SL *)Rv0)[15]=((SL *)Rv2)[10];
    Ra.sl[6]=353; /* line # 353 */
    ((V *)Rv0)[5]=((V *)Rv2)[6];
    Ra.sl[6]=354; /* line # 354 */
    switch (((UB *)Rv2)[56]) {
      case 7:Ra.sl[6]=357; /* line # 357 */
      ((UW *)Rv0)[16]=16384;
      Ra.sl[6]=358; /* line # 358 */
      if (((V *)Rv2)[9]!=NULL) {
        Ra.sl[6]=359; /* line # 359 */
        if (1024&((UW *)((V *)Rv2)[9])[8]) ((UW *)Rv0)[16]=((UW *)Rv0)[16]|4;
      }
      break;
      case 5:Ra.sl[6]=364; /* line # 364 */
      ((SL *)Rv0)[12]=((SL *)Rv2)[15];
      Ra.sl[6]=365; /* line # 365 */
      ((UW *)Rv0)[16]=((UW *)Rv2)[32];
      break;
      case 4:Ra.sl[6]=370; /* line # 370 */
      if (((V *)Rv2)[8]!=NULL) {
        Ra.sl[6]=371; /* line # 371 */
        Rv3=((V *)Rv2)[8];
        Ra.sl[6]=373; /* line # 373 */
        ((SL *)Rv0)[12]=((SL *)Rv3)[5];
        Ra.sl[6]=374; /* line # 374 */
        ((UW *)Rv0)[16]=((UW *)Rv3)[8]|1;
      }
      else {
        Ra.sl[6]=377; /* line # 377 */
        ((UW *)Rv0)[16]=16417;
      }
      Ra.sl[6]=379; /* line # 379 */
      if (V_curr_lex!=((SL *)Rv0)[15]) {
        Ra.sl[6]=380; /* line # 380 */
        ((UW *)Rv0)[16]=((UW *)Rv0)[16]|4;
      }
      break;
      default:break;
    }
  }
  else {
    Ra.sl[6]=388; /* line # 388 */
    ((UW *)Rv0)[16]=97;
    Ra.sl[6]=389; /* line # 389 */
    if (V_curr_lex>1||!V_cmp_genenv) {
      Ra.sl[6]=390; /* line # 390 */
      ((UW *)Rv0)[16]=((UW *)Rv0)[16]|16384;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_free "  */
void P_all_free(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+164;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=402; /* line # 402 */
  Rv0=F_p;
  Rv1=((V *)Rv0)[5];
  Ra.sl[6]=404; /* line # 404 */
  if (((V *)Rv0)[1]!=NULL) {
    Ra.sl[6]=405; /* line # 405 */
    ((V *)((V *)Rv0)[1])[0]=((V *)Rv0)[0];
  }
  else {
    Ra.sl[6]=407; /* line # 407 */
    switch (((UB *)Rv0)[34]) {
      case 2:
      case 3:break;
      default:Ra.sl[6]=412; /* line # 412 */
      if (((V *)Rv1)[25]==F_p) ((V *)Rv1)[25]=((V *)Rv0)[0];
      Ra.sl[6]=414; /* line # 414 */
      if (((V *)Rv1)[26]==F_p) ((V *)Rv1)[26]=((V *)Rv0)[1];
      break;
    }
  }
  Ra.sl[6]=417; /* line # 417 */
  if (((V *)Rv0)[13]!=NULL) P_val_free(((V *)Rv0)+13);
  Ra.sl[6]=420; /* line # 420 */
  if (F_p!=NULL) {
    Ra.sl[6]=422; /* line # 422 */
    ((V *)F_p)[0]=V_all_free_list;
    V_all_free_list=F_p;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new "  */
void P_lgt_new(V *F_p, V F_ty, UB F_knd, V F_prm){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+174;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=436; /* line # 436 */
  (*F_p)=NULL;
  Ra.sl[6]=437; /* line # 437 */
  if (V_lgt_free_list==NULL) (*F_p)=PAS__NEW(64);
  else {
    Ra.sl[6]=440; /* line # 440 */
    (*F_p)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[6]=442; /* line # 442 */
  Rv0=(*F_p);
  Ra.sl[6]=444; /* line # 444 */
  ((V *)Rv0)[0]=NULL;
  Ra.sl[6]=445; /* line # 445 */
  ((V *)Rv0)[1]=F_prm;
  Ra.sl[6]=446; /* line # 446 */
  ((SL *)Rv0)[4]=0;
  Ra.sl[6]=447; /* line # 447 */
  ((UW *)Rv0)[10]=3;
  Ra.sl[6]=448; /* line # 448 */
  ((V *)Rv0)[3]=F_ty;
  Ra.sl[6]=449; /* line # 449 */
  ((V *)Rv0)[4]=NULL;
  Ra.sl[6]=450; /* line # 450 */
  ((UB *)Rv0)[40]=F_knd;
  Ra.sl[6]=451; /* line # 451 */
  switch (F_knd) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 16:
    case 24:
    case 25:Ra.sl[6]=458; /* line # 458 */
    if (F_prm!=NULL) ((UW *)Rv0)[10]=((UW *)F_prm)[10]|4;
    else {
      Ra.sl[6]=459; /* line # 459 */
      ((UW *)Rv0)[10]=5;
    }
    Ra.sl[6]=460; /* line # 460 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 18:Ra.sl[6]=465; /* line # 465 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=466; /* line # 466 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 15:Ra.sl[6]=470; /* line # 470 */
    ((SL *)Rv0)[11]=0;
    break;
    case 0:Ra.sl[6]=474; /* line # 474 */
    ((UB *)Rv0)[41]=0;
    Ra.sl[6]=475; /* line # 475 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 6:Ra.sl[6]=479; /* line # 479 */
    ((UB *)Rv0)[41]=0;
    break;
    case 20:Ra.sl[6]=482; /* line # 482 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 17:
    case 19:
    case 21:
    case 22:
    case 23:Ra.sl[6]=486; /* line # 486 */
    ((SL *)Rv0)[11]=0;
    break;
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:Ra.sl[6]=490; /* line # 490 */
    ((V *)Rv0)[6]=NULL;
    break;
    case 13:Ra.sl[6]=494; /* line # 494 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=495; /* line # 495 */
    ((V *)Rv0)[7]=NULL;
    break;
    case 14:Ra.sl[6]=500; /* line # 500 */
    ((V *)Rv0)[6]=NULL;
    Ra.sl[6]=501; /* line # 501 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=502; /* line # 502 */
    ((UW *)Rv0)[10]=1;
    Ra.sl[6]=503; /* line # 503 */
    if (F_ty!=NULL) {
      Ra.sl[6]=504; /* line # 504 */
      if (!((UB *)F_ty)[91]) ((UW *)Rv0)[10]=5;
    }
    break;
    default:Ra.sl[6]=509; /* line # 509 */
    ((V *)Rv0)[6]=NULL;
    break;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " all_new_tmp "  */
V P_all_new_tmp(V F_ty, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  register V Rv2;
  register V Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+183;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=525; /* line # 525 */
  if (V_all_free_list==NULL) Rv0=PAS__NEW(112);
  else {
    Ra.sl[6]=528; /* line # 528 */
    Rv0=V_all_free_list;
    V_all_free_list=((V *)Rv0)[0];
  }
  Ra.sl[6]=530; /* line # 530 */
  P_lgt_new(&Rv1, F_ty,13,NULL);
  Ra.sl[6]=531; /* line # 531 */
  ((V *)Rv1)[7]=Rv0;
  Ra.sl[6]=532; /* line # 532 */
  Rv2=Rv0;
  Rv3=F_ty;
  Ra.sl[6]=534; /* line # 534 */
  ((V *)Rv2)[0]=NULL;
  Ra.sl[6]=535; /* line # 535 */
  ((V *)Rv2)[1]=NULL;
  Ra.sl[6]=536; /* line # 536 */
  memcpy(Rv2+16,Rv3+48,1);
  Ra.sl[6]=537; /* line # 537 */
  ((V *)Rv2)[3]=F_ty;
  Ra.sl[6]=538; /* line # 538 */
  ((UW *)Rv2)[16]=16481;
  Ra.sl[6]=539; /* line # 539 */
  ((UB *)Rv2)[34]=0;
  Ra.sl[6]=540; /* line # 540 */
  if (F_id==NULL) {
    Ra.sl[6]=542; /* line # 542 */
    ((V *)Rv2)[5]=V_pro_current;
    Ra.sl[6]=543; /* line # 543 */
    ((SL *)Rv2)[15]=V_curr_lex;
  }
  else {
    Ra.sl[6]=547; /* line # 547 */
    ((V *)Rv2)[5]=((V *)F_id)[6];
    Ra.sl[6]=548; /* line # 548 */
    ((SL *)Rv2)[15]=((SL *)F_id)[10];
  }
  Ra.sl[6]=550; /* line # 550 */
  ((SL *)Rv2)[12]=-1;
  Ra.sl[6]=551; /* line # 551 */
  ((SL *)Rv2)[13]=abs(((SL *)Rv3)[11]);
  Ra.sl[6]=552; /* line # 552 */
  ((SL *)Rv2)[14]=-1;
  Ra.sl[6]=553; /* line # 553 */
  ((SL *)Rv2)[16]=-1;
  Ra.sl[6]=554; /* line # 554 */
  ((SL *)Rv2)[17]=-1;
  Ra.sl[6]=555; /* line # 555 */
  ((V *)Rv2)[9]=NULL;
  Ra.sl[6]=556; /* line # 556 */
  ((V *)Rv2)[10]=NULL;
  Ra.sl[6]=557; /* line # 557 */
  ((V *)Rv2)[11]=NULL;
  Ra.sl[6]=558; /* line # 558 */
  ((V *)Rv2)[12]=NULL;
  Ra.sl[6]=559; /* line # 559 */
  ((V *)Rv2)[13]=NULL;
  Ra.sl[6]=561; /* line # 561 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_copy "  */
void P_lgt_new_copy(V F_model, V *F_copy){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+196;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=570; /* line # 570 */
  (*F_copy)=NULL;
  Ra.sl[6]=571; /* line # 571 */
  if (V_lgt_free_list==NULL) (*F_copy)=PAS__NEW(64);
  else {
    Ra.sl[6]=574; /* line # 574 */
    (*F_copy)=V_lgt_free_list;
    V_lgt_free_list=((V *)V_lgt_free_list)[0];
  }
  Ra.sl[6]=576; /* line # 576 */
  memcpy((*F_copy),F_model,64);
  Ra.sl[6]=577; /* line # 577 */
  Rv0=(*F_copy);
  Ra.sl[6]=578; /* line # 578 */
  if (((UB *)Rv0)[40]==14) {
    Ra.sl[6]=579; /* line # 579 */
    if (((V *)Rv0)[7]!=NULL) {
      Rv1=((V *)Rv0)[7];
      ((SL *)Rv1)[3]=((SL *)Rv1)[3]+1;
    }
  }
  Ra.sl[6]=580; /* line # 580 */
  ((V *)(*F_copy))[0]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_copy_tree "  */
void P_lgt_copy_tree(V F_src, V *F_dst){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  V Rv2;
  V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+210;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=591; /* line # 591 */
  if (F_src!=NULL) {
    Ra.sl[6]=592; /* line # 592 */
    if (((UB *)F_src)[40]==16) P_lgt_copy_tree(((V *)F_src)[1],F_dst);
    else {
      Ra.sl[6]=595; /* line # 595 */
      Rv0=((V *)F_src)[1];
      Ra.sl[6]=596; /* line # 596 */
      Rv1=NULL;
      Ra.sl[6]=597; /* line # 597 */
      while (Rv0!=NULL){
        Ra.sl[6]=599; /* line # 599 */
        P_lgt_copy_tree(Rv0, &Rv2);
        Ra.sl[6]=600; /* line # 600 */
        if (Rv1==NULL) Rv1=Rv2;
        else {
          Ra.sl[6]=601; /* line # 601 */
          ((V *)Rv3)[0]=Rv2;
        }
        Ra.sl[6]=602; /* line # 602 */
        Rv3=Rv2;
        Ra.sl[6]=603; /* line # 603 */
        Rv0=((V *)Rv0)[0];
      }
      Ra.sl[6]=605; /* line # 605 */
      P_lgt_new_copy(F_src, F_dst);
      Ra.sl[6]=606; /* line # 606 */
      ((V *)(*F_dst))[1]=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free "  */
void P_lgt_free(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+225;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=616; /* line # 616 */
  Rv0=(*F_p);
  Ra.sl[6]=617; /* line # 617 */
  if (((UB *)Rv0)[40]!=25) {
    Ra.sl[6]=619; /* line # 619 */
    if (((UB *)Rv0)[40]==14) {
      Ra.sl[6]=620; /* line # 620 */
      if (((V *)Rv0)[7]!=NULL) P_val_free(((V *)Rv0)+7);
    }
    Ra.sl[6]=621; /* line # 621 */
    ((V *)Rv0)[0]=V_lgt_free_list;
    Ra.sl[6]=622; /* line # 622 */
    ((UB *)Rv0)[40]=25;
    Ra.sl[6]=623; /* line # 623 */
    V_lgt_free_list=(*F_p);
  }
  Ra.sl[6]=625; /* line # 625 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_free_tree "  */
void P_lgt_free_tree(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+235;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=637; /* line # 637 */
  Rv0=(*F_p);
  Ra.sl[6]=638; /* line # 638 */
  while (Rv0!=NULL){
    Ra.sl[6]=639; /* line # 639 */
    if (((UB *)Rv0)[40]==25) Rv0=NULL;
    else {
      Ra.sl[6]=641; /* line # 641 */
      if (((UB *)Rv0)[40]!=16) {
        Ra.sl[6]=642; /* line # 642 */
        P_lgt_free_tree(((V *)Rv0)+1);
      }
      Ra.sl[6]=643; /* line # 643 */
      Rv1=((V *)Rv0)[0];
      Ra.sl[6]=644; /* line # 644 */
      P_lgt_free(&Rv0);
      Ra.sl[6]=645; /* line # 645 */
      Rv0=Rv1;
    }
  }
  Ra.sl[6]=647; /* line # 647 */
  (*F_p)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_econst "  */
V P_lgt_new_econst(V F_ty, SL F_iv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+250;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=659; /* line # 659 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Ra.sl[6]=660; /* line # 660 */
  Rv1=Rv0;
  Ra.sl[6]=662; /* line # 662 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=663; /* line # 663 */
  P_val_new(((V *)Rv1)+7,F_ty);
  Ra.sl[6]=664; /* line # 664 */
  ((SL *)((V *)Rv1)[7])[13]=F_iv;
  Ra.sl[6]=666; /* line # 666 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_econstr "  */
V P_lgt_new_econstr(V F_ty, G F_rv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+266;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=678; /* line # 678 */
  P_lgt_new(&Rv0, F_ty,14,NULL);
  Ra.sl[6]=679; /* line # 679 */
  Rv1=Rv0;
  Ra.sl[6]=681; /* line # 681 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=682; /* line # 682 */
  P_val_new(((V *)Rv1)+7,F_ty);
  Ra.sl[6]=683; /* line # 683 */
  ((G *)((V *)Rv1)[7])[7]=F_rv;
  Ra.sl[6]=685; /* line # 685 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_get_econst "  */
SL P_lgt_get_econst(V F_lgt, SL F_idf){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+283;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=697; /* line # 697 */
  Rv0=F_idf;
  Ra.sl[6]=698; /* line # 698 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=699; /* line # 699 */
    Rv1=F_lgt;
    Ra.sl[6]=700; /* line # 700 */
    if (((UB *)Rv1)[40]==14&&((V *)Rv1)[7]!=NULL) {
      Ra.sl[6]=701; /* line # 701 */
      Rv2=((V *)Rv1)[7];
      Ra.sl[6]=702; /* line # 702 */
      switch (((UB *)Rv2)[48]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=703; /* line # 703 */
        Rv0=((SL *)Rv2)[13];
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=706; /* line # 706 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_imaskp2 "  */
SL P_lgt_imaskp2(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+299;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=720; /* line # 720 */
  Rv0=-1;
  Ra.sl[6]=721; /* line # 721 */
  if (F_lgt!=NULL) {
    Ra.sl[6]=722; /* line # 722 */
    Rv1=F_lgt;
    Ra.sl[6]=723; /* line # 723 */
    if (((UB *)Rv1)[40]==14&&((V *)Rv1)[7]!=NULL) {
      Ra.sl[6]=724; /* line # 724 */
      Rv2=((V *)Rv1)[7];
      Ra.sl[6]=726; /* line # 726 */
      switch (((UB *)Rv2)[48]) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=729; /* line # 729 */
        Rv3=((SL *)Rv2)[13];
        Ra.sl[6]=730; /* line # 730 */
        if (Rv3!=0) {
          Ra.sl[6]=732; /* line # 732 */
          Rv0=0;
          Ra.sl[6]=733; /* line # 733 */
          while (!(Rv3&1)){
            Ra.sl[6]=734; /* line # 734 */
            Rv3=Rv3/2;
            Rv0=Rv0+1;
          }
          Ra.sl[6]=735; /* line # 735 */
          if (Rv3==1) {
            Ra.sl[6]=737; /* line # 737 */
            Rv3=((SL *)Rv2)[13]-1;
            ((SL *)Rv2)[13]=Rv3;
          }
          else {
            Ra.sl[6]=740; /* line # 740 */
            Rv0=-1;
          }
        }
        break;
        default:break;
      }
    }
  }
  Ra.sl[6]=746; /* line # 746 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_code "  */
V P_lgt_new_code(UB F_pcd, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+312;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=758; /* line # 758 */
  P_lgt_new(&Rv0, V_int_typ,6, F_par);
  Ra.sl[6]=759; /* line # 759 */
  ((UB *)Rv0)[41]=F_pcd;
  Ra.sl[6]=760; /* line # 760 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_call "  */
V P_lgt_new_call(V F_pty, V F_pro, V F_par){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+326;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=772; /* line # 772 */
  P_lgt_new(&Rv0, F_pty,8, F_par);
  Ra.sl[6]=773; /* line # 773 */
  if (F_pty!=NULL) {
    Ra.sl[6]=774; /* line # 774 */
    if (!((UB *)F_pty)[91]) {
      Ra.sl[6]=775; /* line # 775 */
      Rv1=Rv0;
      Ra.sl[6]=776; /* line # 776 */
      ((UW *)Rv1)[10]=((UW *)Rv1)[10]|4;
    }
  }
  Ra.sl[6]=777; /* line # 777 */
  ((V *)Rv0)[6]=F_pro;
  Ra.sl[6]=778; /* line # 778 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_link "  */
V P_lgt_link(V F_lgt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+340;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=790; /* line # 790 */
  P_lgt_new(&Rv0,((V *)F_lgt)[3],16, F_lgt);
  Ra.sl[6]=791; /* line # 791 */
  ((UW *)Rv0)[10]=((UW *)F_lgt)[10];
  Ra.sl[6]=792; /* line # 792 */
  ((UW *)F_lgt)[10]=((UW *)F_lgt)[10]|256;
  Ra.sl[6]=793; /* line # 793 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_idref "  */
V P_lgt_new_idref(V F_id, V F_lnk){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  register V Rv4;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+350;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=805; /* line # 805 */
  Rv0=NULL;
  Ra.sl[6]=806; /* line # 806 */
  Rv1=F_id;
  Ra.sl[6]=808; /* line # 808 */
  switch (((UB *)Rv1)[56]) {
    case 5:Ra.sl[6]=811; /* line # 811 */
    P_lgt_new(&Rv0,((V *)Rv1)[4],13,NULL);
    Ra.sl[6]=812; /* line # 812 */
    Rv2=Rv0;
    Ra.sl[6]=814; /* line # 814 */
    ((V *)Rv2)[0]=F_lnk;
    Ra.sl[6]=815; /* line # 815 */
    ((V *)Rv2)[4]=F_id;
    Ra.sl[6]=816; /* line # 816 */
    ((V *)Rv2)[6]=F_id;
    Ra.sl[6]=817; /* line # 817 */
    ((UW *)Rv1)[32]=((UW *)Rv1)[32]|1;
    Ra.sl[6]=818; /* line # 818 */
    ((V *)Rv2)[7]=((V *)F_id)[11];
    Ra.sl[6]=819; /* line # 819 */
    ((UW *)Rv2)[10]=4;
    Ra.sl[6]=820; /* line # 820 */
    if (32&((UW *)Rv1)[32]) ((UW *)Rv2)[10]=((UW *)Rv2)[10]|1;
    Ra.sl[6]=821; /* line # 821 */
    if (64&((UW *)Rv1)[32]) ((UW *)Rv2)[10]=((UW *)Rv2)[10]|2;
    break;
    case 4:Ra.sl[6]=827; /* line # 827 */
    P_lgt_new(&Rv0,((V *)Rv1)[4],14,NULL);
    Ra.sl[6]=828; /* line # 828 */
    Rv3=Rv0;
    Ra.sl[6]=830; /* line # 830 */
    ((V *)Rv3)[0]=F_lnk;
    Ra.sl[6]=831; /* line # 831 */
    ((V *)Rv3)[4]=F_id;
    Ra.sl[6]=832; /* line # 832 */
    if (((V *)Rv3)[3]!=NULL) {
      Ra.sl[6]=833; /* line # 833 */
      if (((UB *)((V *)Rv3)[3])[91]) {
        Ra.sl[6]=835; /* line # 835 */
        P_val_copy(((V *)Rv1)+8,((V *)Rv3)+7,0);
        Ra.sl[6]=836; /* line # 836 */
        Rv4=((V *)Rv3)[7];
        Ra.sl[6]=838; /* line # 838 */
        ((V *)Rv4)[4]=((V *)Rv3)[3];
        Ra.sl[6]=839; /* line # 839 */
        ((UB *)Rv4)[48]=((UB *)((V *)Rv3)[3])[92];
      }
    }
    Ra.sl[6]=842; /* line # 842 */
    if (((V *)Rv3)[7]==NULL) {
      Ra.sl[6]=844; /* line # 844 */
      ((V *)Rv3)[7]=((V *)Rv1)[8];
      Ra.sl[6]=845; /* line # 845 */
      P_val_new(((V *)Rv3)+7,NULL);
    }
    break;
    default:break;
  }
  Ra.sl[6]=865; /* line # 865 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_tmpref "  */
V P_lgt_tmpref(V F_ty, UB F_nwt, UB F_frt){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+365;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=876; /* line # 876 */
  P_lgt_new(&Rv0, F_ty,18,NULL);
  Ra.sl[6]=877; /* line # 877 */
  Rv1=Rv0;
  Ra.sl[6]=879; /* line # 879 */
  ((V *)Rv1)[6]=NULL;
  Ra.sl[6]=880; /* line # 880 */
  ((V *)Rv1)[7]=NULL;
  Ra.sl[6]=881; /* line # 881 */
  if (F_nwt) ((UW *)Rv1)[10]=((UW *)Rv1)[10]|512;
  Ra.sl[6]=882; /* line # 882 */
  if (F_frt) ((UW *)Rv1)[10]=((UW *)Rv1)[10]|1024;
  Ra.sl[6]=884; /* line # 884 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lgt_new_addsub "  */
V P_lgt_new_addsub(UB F_bsub, UB F_bfree, V F_lgt1, V F_lgt2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  V Rv1;
  SL Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+377;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=897; /* line # 897 */
  Rv0=NULL;
  Ra.sl[6]=898; /* line # 898 */
  Rv1=((V *)F_lgt1)[3];
  Ra.sl[6]=899; /* line # 899 */
  if (((UB *)F_lgt1)[40]==14) {
    Ra.sl[6]=901; /* line # 901 */
    Rv2=((SL *)((V *)F_lgt1)[7])[13];
    Ra.sl[6]=902; /* line # 902 */
    if (((UB *)F_lgt2)[40]==14) {
      Ra.sl[6]=904; /* line # 904 */
      Rv3=((SL *)((V *)F_lgt2)[7])[13];
      Ra.sl[6]=905; /* line # 905 */
      if (F_bsub) Rv0=P_lgt_new_econst(Rv1, Rv2-Rv3);
      else {
        Ra.sl[6]=906; /* line # 906 */
        Rv0=P_lgt_new_econst(Rv1, Rv2+Rv3);
      }
      Ra.sl[6]=907; /* line # 907 */
      if (F_bfree) {
        Ra.sl[6]=909; /* line # 909 */
        P_lgt_free(&F_lgt1);
        P_lgt_free(&F_lgt2);
      }
    }
    else {
      Ra.sl[6]=913; /* line # 913 */
      if (Rv2==0) {
        Ra.sl[6]=915; /* line # 915 */
        if (F_bfree) P_lgt_free(&F_lgt1);
        Ra.sl[6]=916; /* line # 916 */
        if (F_bsub) Rv0=P_lgt_new_code(46, F_lgt2);
        else {
          Ra.sl[6]=917; /* line # 917 */
          Rv0=F_lgt2;
        }
      }
    }
  }
  else {
    Ra.sl[6]=921; /* line # 921 */
    if (((UB *)F_lgt2)[40]==14) {
      Ra.sl[6]=922; /* line # 922 */
      if (((SL *)((V *)F_lgt2)[7])[13]==0) {
        Ra.sl[6]=924; /* line # 924 */
        Rv0=F_lgt1;
        Ra.sl[6]=925; /* line # 925 */
        if (F_bfree) P_lgt_free(&F_lgt2);
      }
    }
  }
  Ra.sl[6]=928; /* line # 928 */
  if (Rv0==NULL) {
    Ra.sl[6]=930; /* line # 930 */
    ((V *)F_lgt1)[0]=F_lgt2;
    Ra.sl[6]=931; /* line # 931 */
    if (F_bsub) Rv0=P_lgt_new_code(50, F_lgt1);
    else {
      Ra.sl[6]=932; /* line # 932 */
      Rv0=P_lgt_new_code(49, F_lgt1);
    }
  }
  Ra.sl[6]=934; /* line # 934 */
  ((V *)Rv0)[3]=Rv1;
  Ra.sl[6]=935; /* line # 935 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_disp_level "  */
void P_new_disp_level(V F_ow, UB F_kind){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+393;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=947; /* line # 947 */
  if (V_curr_disp<64) {
    Ra.sl[6]=949; /* line # 949 */
    V_curr_disp=V_curr_disp+1;
    Ra.sl[6]=950; /* line # 950 */
    if (V_curr_disp>0) {
      Ra.sl[6]=951; /* line # 951 */
      memcpy((V_lex_ident_tree.s+V_curr_disp*64),(V_lex_ident_tree.s+(V_curr_disp-
1)*64),60);
    }
    Ra.sl[6]=952; /* line # 952 */
    Rv0=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=954; /* line # 954 */
    ((SL *)Rv0)[12]=V_curr_lex;
    Ra.sl[6]=955; /* line # 955 */
    if (F_ow!=NULL) {
      Ra.sl[6]=956; /* line # 956 */
      ((V *)Rv0)[0]=F_ow;
    }
    Ra.sl[6]=957; /* line # 957 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=958; /* line # 958 */
    ((V *)Rv0)[2]=NULL;
    Ra.sl[6]=959; /* line # 959 */
    ((UB *)Rv0)[24]=F_kind;
    Ra.sl[6]=960; /* line # 960 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=961; /* line # 961 */
    ((V *)Rv0)[5]=NULL;
    Ra.sl[6]=962; /* line # 962 */
    ((SL *)Rv0)[14]=0;
  }
  else {
    Ra.sl[6]=964; /* line # 964 */
    P_src_error(Rd.s+411,1001,3);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_reserve_disp "  */
void P_ide_reserve_disp(SL F_prv){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+415;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=976; /* line # 976 */
  Rv0=V_lex_ident_tree.v[V_curr_disp*8];
  Ra.sl[6]=980; /* line # 980 */
  if (Rv0!=NULL) {
    Ra.sl[6]=981; /* line # 981 */
    Rv1=(V_lex_ident_tree.s+V_curr_disp*64);
    Rv2=Rv0;
    Ra.sl[6]=982; /* line # 982 */
    if (((V *)Rv1)[4]!=NULL) {
      Ra.sl[6]=984; /* line # 984 */
      ((V *)((V *)Rv1)[4])[3]=((V *)Rv2)[21];
      Ra.sl[6]=985; /* line # 985 */
      ((V *)Rv2)[21]=((V *)Rv1)[1];
    }
  }
  Ra.sl[6]=987; /* line # 987 */
  V_curr_disp=F_prv;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " match "  */
SL P_match(V F_s1, V F_s2){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  SL Rv2;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+433;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1003; /* line # 1003 */
  if (((UB *)F_s1)[0]<((UB *)F_s2)[0]) Rv0=((UB *)F_s1)[0];
  else {
    Ra.sl[6]=1004; /* line # 1004 */
    Rv0=((UB *)F_s2)[0];
  }
  Ra.sl[6]=1005; /* line # 1005 */
  Rv1=1;
  Ra.sl[6]=1006; /* line # 1006 */
  Rv2=0;
  Ra.sl[6]=1007; /* line # 1007 */
  while (Rv1<=Rv0&&Rv2==0){
    Ra.sl[6]=1009; /* line # 1009 */
    Rv2=(SL)((C *)F_s1)[Rv1]-(SL)((C *)F_s2)[Rv1];
    Rv1=Rv1+1;
  }
  Ra.sl[6]=1011; /* line # 1011 */
  if (Rv1>Rv0&&Rv2==0) Rv2=((UB *)F_s1)[0]-((UB *)F_s2)[0];
  Ra.sl[6]=1012; /* line # 1012 */
  Ret=Rv2;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " new_int_name "  */
V P_new_int_name(V F_head, SL *F_nbs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  SL Rv2;
  SL Rv3;
  SL Rv4;
  register int Rgi;
  register int Rgj;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+28,F_head,4);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+440;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1029; /* line # 1029 */
  Rv0=NULL;
  Ra.sl[6]=1030; /* line # 1030 */
  Rv0=PAS__NEW(32);
  Ra.sl[6]=1031; /* line # 1031 */
  Rv1=Rv0;
  Ra.sl[6]=1033; /* line # 1033 */
  Rv2=1;
  for( Rf0=4;Rf0>0;Rf0-- ) {
    ((C *)Rv1)[Rv2]=Ra.c[Rv2+27];
    Rv2++;
  }
  Ra.sl[6]=1034; /* line # 1034 */
  Rv3=12;
  ((UB *)Rv1)[0]=Rv3;
  Ra.sl[6]=1035; /* line # 1035 */
  Rv4=(*F_nbs);
  Ra.sl[6]=1036; /* line # 1036 */
  while (Rv3>4){
    Ra.sl[6]=1038; /* line # 1038 */
    ((C *)Rv1)[Rv3]=(C)(48+PAS__I_MOD(Rv4,10));
    Ra.sl[6]=1039; /* line # 1039 */
    Rv4=Rv4/10;
    Ra.sl[6]=1040; /* line # 1040 */
    Rv3=Rv3-1;
  }
  Ra.sl[6]=1043; /* line # 1043 */
  (*F_nbs)=(*F_nbs)+1;
  Ra.sl[6]=1044; /* line # 1044 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " level_search "  */
V P_level_search(V F_fp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  register V Rv2;
  SL Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+454;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1058; /* line # 1058 */
  Rv0=F_fp;
  Ra.sl[6]=1059; /* line # 1059 */
  Rv1=0;
  Ra.sl[6]=1060; /* line # 1060 */
  Rs.v[0]=NULL;
  Ra.sl[6]=1061; /* line # 1061 */
  while (!Rv1&&Rv0!=NULL){
    Ra.sl[6]=1062; /* line # 1062 */
    Rv2=Rv0;
    Ra.sl[6]=1064; /* line # 1064 */
    Rs.v[0]=Rv0;
    Ra.sl[6]=1065; /* line # 1065 */
    if (V_curr_ident==NULL) Rv3=P_match(((V *)Rv2)[0],V_sy_ident.s);
    else {
      Ra.sl[6]=1066; /* line # 1066 */
      Rv3=P_match(((V *)Rv2)[0],V_curr_ident);
    }
    Ra.sl[6]=1067; /* line # 1067 */
    if (Rv3==0) Rv1=1;
    else {
      Ra.sl[6]=1068; /* line # 1068 */
      if (Rv3>0) {
        Ra.sl[6]=1069; /* line # 1069 */
        Rs.ub[8]=1;
        Ra.sl[6]=1070; /* line # 1070 */
        Rv0=((V *)Rv0)[1];
      }
      else {
        Ra.sl[6]=1073; /* line # 1073 */
        Rs.ub[8]=0;
        Ra.sl[6]=1074; /* line # 1074 */
        Rv0=((V *)Rv0)[2];
      }
    }
  }
  Ra.sl[6]=1077; /* line # 1077 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " lex_search "  */
V P_lex_search(SL F_disp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  UB Rv3;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+468;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1090; /* line # 1090 */
  V_ident_disp=F_disp;
  Ra.sl[6]=1091; /* line # 1091 */
  if (V_lex_ident_tree.ub[V_ident_disp*64+24]==4) Rv0=4;
  else {
    Ra.sl[6]=1092; /* line # 1092 */
    Rv0=6;
  }
  while (1){
    Ra.sl[6]=1094; /* line # 1094 */
    Rv1=P_level_search(V_lex_ident_tree.v[V_ident_disp*8+1]);
    Ra.sl[6]=1095; /* line # 1095 */
    if (V_ident_disp==F_disp) {
      Ra.sl[6]=1096; /* line # 1096 */
      Rv2=Rs.v[0];
      Ra.sl[6]=1097; /* line # 1097 */
      Rv3=Rs.ub[8];
    }
    Ra.sl[6]=1099; /* line # 1099 */
    V_ident_disp=V_ident_disp-1;
    if ((Rv1!=NULL||V_ident_disp<V_lex_ident_level.sl[V_curr_lex])||Rv0!=V_lex_ident_tree
    .ub[V_ident_disp*64+24])  break;
  }
  Ra.sl[6]=1102; /* line # 1102 */
  Rs.v[0]=Rv2;
  Rs.ub[8]=Rv3;
  Ra.sl[6]=1103; /* line # 1103 */
  Ret=Rv1;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " any_class "  */
UB P_any_class(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  register UB Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+480;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1115; /* line # 1115 */
  Rv0=0;
  Ra.sl[6]=1116; /* line # 1116 */
  if (F_fs!=0) {
    Ra.sl[6]=1117; /* line # 1117 */
    while (!(1<<Rv0&F_fs))
    Rv0=Rv0+1;
  }
  Ra.sl[6]=1118; /* line # 1118 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_new "  */
void P_ide_new(UB F_fc, V F_ty, V *F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  V Rv1;
  register V Rv2;
  UB Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  register V Rv12;
  SL Rv13;
  register V Rv14;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+491;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1140; /* line # 1140 */
  if (F_fc==3) Rv0=V_cprc_disp;
  else {
    Ra.sl[6]=1141; /* line # 1141 */
    Rv0=V_curr_disp;
  }
  Ra.sl[6]=1143; /* line # 1143 */
  Rv1=P_lex_search(Rv0);
  Ra.sl[6]=1149; /* line # 1149 */
  if (Rv1!=NULL) {
    Ra.sl[6]=1151; /* line # 1151 */
    Rv2=Rv1;
    Ra.sl[6]=1152; /* line # 1152 */
    switch (((UB *)Rv2)[56]) {
      case 5:Ra.sl[6]=1153; /* line # 1153 */
      Rv3=((UB *)Rv2)[66]==4;
      break;
      case 4:Ra.sl[6]=1154; /* line # 1154 */
      Rv3=((UB *)Rv2)[80]==4;
      break;
      default:Ra.sl[6]=1156; /* line # 1156 */
      Rv3=0;
      break;
    }
    Ra.sl[6]=1159; /* line # 1159 */
    if (!(Rv3&&V_cmp_twicedclon)) {
      Ra.sl[6]=1161; /* line # 1161 */
      V_cmp_twicedcl=1;
      Ra.sl[6]=1162; /* line # 1162 */
      P_src_error_s(Rd.s+502,101,2, V_sy_ident.s,NULL);
    }
    else {
      Ra.sl[6]=1165; /* line # 1165 */
      ((V *)Rv1)[3]=NULL;
    }
  }
  else {
    Ra.sl[6]=1169; /* line # 1169 */
    Rv1=NULL;
    Ra.sl[6]=1170; /* line # 1170 */
    switch (F_fc) {
      case 3:Ra.sl[6]=1172; /* line # 1172 */
      Rv1=PAS__NEW(104);
      Ra.sl[6]=1173; /* line # 1173 */
      Rv4=Rv1;
      Ra.sl[6]=1175; /* line # 1175 */
      ((UB *)Rv4)[57]=0;
      Ra.sl[6]=1176; /* line # 1176 */
      ((V *)Rv4)[8]=NULL;
      Ra.sl[6]=1177; /* line # 1177 */
      ((V *)Rv4)[9]=NULL;
      Ra.sl[6]=1178; /* line # 1178 */
      ((V *)Rv4)[10]=NULL;
      Ra.sl[6]=1179; /* line # 1179 */
      ((V *)Rv4)[11]=NULL;
      Ra.sl[6]=1180; /* line # 1180 */
      ((SL *)Rv4)[24]=0;
      Ra.sl[6]=1181; /* line # 1181 */
      ((SL *)Rv4)[25]=-1;
      break;
      case 10:Ra.sl[6]=1187; /* line # 1187 */
      Rv1=PAS__NEW(80);
      Ra.sl[6]=1188; /* line # 1188 */
      Rv5=Rv1;
      Ra.sl[6]=1190; /* line # 1190 */
      ((V *)Rv5)[8]=NULL;
      Ra.sl[6]=1191; /* line # 1191 */
      ((V *)Rv5)[9]=NULL;
      break;
      case 7:Ra.sl[6]=1197; /* line # 1197 */
      Rv1=PAS__NEW(88);
      Ra.sl[6]=1198; /* line # 1198 */
      Rv6=Rv1;
      Ra.sl[6]=1200; /* line # 1200 */
      ((V *)Rv6)[8]=NULL;
      Ra.sl[6]=1201; /* line # 1201 */
      ((V *)Rv6)[9]=NULL;
      Ra.sl[6]=1202; /* line # 1202 */
      ((V *)Rv6)[10]=NULL;
      break;
      case 1:
      case 8:
      case 9:Ra.sl[6]=1209; /* line # 1209 */
      Rv1=PAS__NEW(96);
      Ra.sl[6]=1210; /* line # 1210 */
      Rv7=Rv1;
      Ra.sl[6]=1212; /* line # 1212 */
      ((V *)Rv7)[8]=NULL;
      Ra.sl[6]=1213; /* line # 1213 */
      ((V *)Rv7)[9]=NULL;
      Ra.sl[6]=1214; /* line # 1214 */
      ((V *)Rv7)[10]=NULL;
      Ra.sl[6]=1215; /* line # 1215 */
      ((V *)Rv7)[11]=NULL;
      break;
      case 4:Ra.sl[6]=1220; /* line # 1220 */
      Rv1=PAS__NEW(81);
      Ra.sl[6]=1221; /* line # 1221 */
      Rv8=Rv1;
      Ra.sl[6]=1223; /* line # 1223 */
      ((V *)Rv8)[8]=NULL;
      Ra.sl[6]=1224; /* line # 1224 */
      ((V *)Rv8)[9]=NULL;
      Ra.sl[6]=1225; /* line # 1225 */
      ((UB *)Rv8)[80]=11;
      break;
      case 2:Ra.sl[6]=1230; /* line # 1230 */
      Rv1=PAS__NEW(96);
      Ra.sl[6]=1231; /* line # 1231 */
      Rv9=Rv1;
      Ra.sl[6]=1233; /* line # 1233 */
      ((SL *)Rv9)[15]=0;
      Ra.sl[6]=1234; /* line # 1234 */
      ((UB *)Rv9)[64]=0;
      Ra.sl[6]=1235; /* line # 1235 */
      ((V *)Rv9)[9]=NULL;
      Ra.sl[6]=1236; /* line # 1236 */
      ((V *)Rv9)[10]=NULL;
      Ra.sl[6]=1237; /* line # 1237 */
      ((V *)Rv9)[11]=NULL;
      break;
      case 5:Ra.sl[6]=1242; /* line # 1242 */
      Rv1=PAS__NEW(96);
      Ra.sl[6]=1243; /* line # 1243 */
      Rv10=Rv1;
      Ra.sl[6]=1245; /* line # 1245 */
      if (V_curr_lex>1) {
        Ra.sl[6]=1247; /* line # 1247 */
        ((SL *)Rv10)[15]=-1;
        Ra.sl[6]=1248; /* line # 1248 */
        ((UW *)Rv10)[32]=16384;
      }
      else {
        Ra.sl[6]=1252; /* line # 1252 */
        ((SL *)Rv10)[15]=V_cmp_igenv;
        Ra.sl[6]=1253; /* line # 1253 */
        ((UW *)Rv10)[32]=0;
      }
      Ra.sl[6]=1255; /* line # 1255 */
      ((UB *)Rv10)[66]=0;
      Ra.sl[6]=1256; /* line # 1256 */
      ((V *)Rv10)[9]=NULL;
      Ra.sl[6]=1257; /* line # 1257 */
      ((V *)Rv10)[10]=NULL;
      Ra.sl[6]=1258; /* line # 1258 */
      ((V *)Rv10)[11]=NULL;
      Ra.sl[6]=1260; /* line # 1260 */
      if (V_sy_var_init_mod) {
        Ra.sl[6]=1261; /* line # 1261 */
        if (V_std_inp_file==NULL) V_std_inp_file=Rv1;
        else {
          Ra.sl[6]=1263; /* line # 1263 */
          if (V_std_out_file==NULL) V_std_out_file=Rv1;
          else {
            Ra.sl[6]=1265; /* line # 1265 */
            if (V_std_err_file==NULL) V_std_err_file=Rv1;
          }
        }
      }
      break;
      case 6:Ra.sl[6]=1269; /* line # 1269 */
      Rv1=PAS__NEW(64);
      Ra.sl[6]=1270; /* line # 1270 */
      ((SL *)Rv1)[15]=0;
      break;
      case 12:Ra.sl[6]=1274; /* line # 1274 */
      Rv1=PAS__NEW(58);
      Ra.sl[6]=1275; /* line # 1275 */
      ((UB *)Rv1)[57]=0;
      break;
    }
    Ra.sl[6]=1280; /* line # 1280 */
    Rv11=Rv1;
    Ra.sl[6]=1282; /* line # 1282 */
    ((UB *)Rv11)[56]=F_fc;
    Ra.sl[6]=1283; /* line # 1283 */
    ((V *)Rv11)[0]=PAS__NEW(32);
    Ra.sl[6]=1284; /* line # 1284 */
    Rv12=((V *)Rv11)[0];
    Ra.sl[6]=1286; /* line # 1286 */
    ((UB *)Rv12)[0]=V_sy_ident.ub[0];
    Ra.sl[6]=1287; /* line # 1287 */
    Rv13=1;
    for( Rf0=((UB *)Rv12)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv12)[Rv13]=V_sy_ident.c[Rv13];
      Rv13++;
    }
    Ra.sl[6]=1289; /* line # 1289 */
    ((V *)Rv11)[1]=NULL;
    Ra.sl[6]=1290; /* line # 1290 */
    ((V *)Rv11)[2]=NULL;
    Ra.sl[6]=1291; /* line # 1291 */
    ((V *)Rv11)[3]=NULL;
    Ra.sl[6]=1292; /* line # 1292 */
    ((V *)Rv11)[4]=F_ty;
    Ra.sl[6]=1293; /* line # 1293 */
    ((SL *)Rv11)[10]=V_curr_lex;
    Ra.sl[6]=1294; /* line # 1294 */
    ((V *)Rv11)[6]=V_lex_ident_tree.v[Rv0*8];
    Ra.sl[6]=1298; /* line # 1298 */
    if (Rs.v[0]==NULL) V_lex_ident_tree.v[Rv0*8+1]=Rv1;
    else {
      Ra.sl[6]=1299; /* line # 1299 */
      if (Rs.ub[8]) ((V *)Rs.v[0])[1]=Rv1;
      else {
        Ra.sl[6]=1300; /* line # 1300 */
        ((V *)Rs.v[0])[2]=Rv1;
      }
    }
    Ra.sl[6]=1302; /* line # 1302 */
    Rv14=(V_lex_ident_tree.s+Rv0*64);
    Ra.sl[6]=1304; /* line # 1304 */
    if (((V *)Rv14)[4]!=NULL) ((V *)((V *)Rv14)[4])[3]=Rv1;
    Ra.sl[6]=1305; /* line # 1305 */
    ((V *)Rv14)[4]=Rv1;
    Ra.sl[6]=1308; /* line # 1308 */
    V_cmp_twicedcl=0;
  }
  Ra.sl[6]=1310; /* line # 1310 */
  if (Ri.ub[0]) {
    Ra.sl[6]=1312; /* line # 1312 */
    PAS__STR_TO_STR(V_sy_string.s,Ri.s+1);
    Ra.sl[6]=1313; /* line # 1313 */
    Ri.ub[0]=0;
  }
  Ra.sl[6]=1315; /* line # 1315 */
  (*F_ip)=Rv1;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search "  */
V P_ide_search(UW F_fs){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+506;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1339; /* line # 1339 */
  V_ident_disp=V_curr_disp;
  while (1){
    Ra.sl[6]=1341; /* line # 1341 */
    Rv0=P_level_search(V_lex_ident_tree.v[V_ident_disp*8+1]);
    Ra.sl[6]=1342; /* line # 1342 */
    if (Rv0!=NULL) {
      Ra.sl[6]=1344; /* line # 1344 */
      if (!(1<<((UB *)Rv0)[56]&F_fs)) {
        Ra.sl[6]=1346; /* line # 1346 */
        if (V_err_prt) P_src_error_s(Rd.s+520,103,2, V_sy_ident.s,NULL);
        Ra.sl[6]=1347; /* line # 1347 */
        Rv0=NULL;
        Ra.sl[6]=1348; /* line # 1348 */
        V_ident_disp=V_ident_disp -1;
      }
    }
    else {
      Ra.sl[6]=1351; /* line # 1351 */
      V_ident_disp=V_ident_disp -1;
    }
    if (Rv0!=NULL||V_ident_disp<0)  break;
  }
  Ra.sl[6]=1353; /* line # 1353 */
  if (Rv0==NULL&&V_err_prt) {
    Ra.sl[6]=1355; /* line # 1355 */
    P_src_error_s(Rd.s+520,104,3, V_sy_ident.s,NULL);
    Ra.sl[6]=1357; /* line # 1357 */
    Rv0=V_ide_udptr.v[P_any_class(F_fs)];
  }
  Ra.sl[6]=1359; /* line # 1359 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_cntxvar "  */
void P_gen_cntxvar(V F_pr, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+524;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1369; /* line # 1369 */
  Rv0=F_pr;
  Ra.sl[6]=1371; /* line # 1371 */
  ((V *)Rv0)[22]=PAS__NEW(96);
  Ra.sl[6]=1372; /* line # 1372 */
  V_cntx_varbl=((V *)Rv0)[22];
  Ra.sl[6]=1373; /* line # 1373 */
  Rv1=((V *)Rv0)[22];
  Ra.sl[6]=1375; /* line # 1375 */
  ((V *)Rv1)[0]=F_id;
  Ra.sl[6]=1376; /* line # 1376 */
  ((V *)Rv1)[1]=NULL;
  Ra.sl[6]=1377; /* line # 1377 */
  ((V *)Rv1)[2]=NULL;
  Ra.sl[6]=1378; /* line # 1378 */
  ((V *)Rv1)[3]=NULL;
  Ra.sl[6]=1379; /* line # 1379 */
  ((V *)Rv1)[4]=V_cntx_typ;
  Ra.sl[6]=1380; /* line # 1380 */
  ((SL *)Rv1)[10]=V_curr_lex;
  Ra.sl[6]=1381; /* line # 1381 */
  ((V *)Rv1)[6]=F_pr;
  Ra.sl[6]=1382; /* line # 1382 */
  ((UB *)Rv1)[56]=5;
  Ra.sl[6]=1383; /* line # 1383 */
  ((SL *)Rv1)[15]=-1;
  Ra.sl[6]=1384; /* line # 1384 */
  ((UW *)Rv1)[32]=16385;
  Ra.sl[6]=1385; /* line # 1385 */
  if (V_curr_lex<=1) ((UB *)Rv1)[66]=2;
  else {
    Ra.sl[6]=1386; /* line # 1386 */
    ((UB *)Rv1)[66]=1;
  }
  Ra.sl[6]=1387; /* line # 1387 */
  ((V *)Rv1)[9]=NULL;
  Ra.sl[6]=1388; /* line # 1388 */
  ((V *)Rv1)[10]=((V *)Rv0)[3];
  Ra.sl[6]=1389; /* line # 1389 */
  ((V *)Rv1)[11]=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " lgt_new_line "  */
V P_lgt_new_line(V F_pr, V F_lgp, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  UB Rv1;
  UB Rv2;
  register V Rv3;
  register V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;
  register V Rv11;
  V Rv12;
  register V Rv13;
  register V Rv14;
  register V Rv15;
  register UB Rv16;
  register V Rv17;
  register V Rv18;
  SL Rv19;
  register V Rv20;
  register int Rf0;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+537;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1414; /* line # 1414 */
  Rv0=NULL;
  Ra.sl[6]=1415; /* line # 1415 */
  Rv1=0;
  Ra.sl[6]=1416; /* line # 1416 */
  Rv2=0;
  Ra.sl[6]=1417; /* line # 1417 */
  if (V_cmp_trace>0) {
    Ra.sl[6]=1418; /* line # 1418 */
    Rv3=V_src_control;
    Rv4=F_pr;
    Ra.sl[6]=1420; /* line # 1420 */
    if (V_cmp_tracecount<=((SL *)Rv3)[10]||F_icd!=0) {
      Ra.sl[6]=1423; /* line # 1423 */
      if (V_cntx_srinf&&F_icd==0) F_icd=1;
      Ra.sl[6]=1424; /* line # 1424 */
      switch (F_icd) {
        case 0:
        case 1:
        case 2:Ra.sl[6]=1427; /* line # 1427 */
        if (F_lgp==((V *)Rv4)[15]&&F_lgp!=NULL) {
          Ra.sl[6]=1428; /* line # 1428 */
          switch (((SL *)F_lgp)[11]) {
            case 0:
            case 1:
            case 2:
            case 4:Ra.sl[6]=1429; /* line # 1429 */
            Rv1=1;
            break;
            default:break;
          }
        }
        Ra.sl[6]=1432; /* line # 1432 */
        Rv2=V_cntx_srinf;
        break;
        case 3:
        case 5:Ra.sl[6]=1435; /* line # 1435 */
        Rv2=1;
        break;
        default:break;
      }
      Ra.sl[6]=1440; /* line # 1440 */
      V_cntx_srinf=0;
      Ra.sl[6]=1442; /* line # 1442 */
      if (Rv2) {
        Ra.sl[6]=1444; /* line # 1444 */
        P_lgt_new(&Rv0, V_typ_std.v[10],14,NULL);
        Ra.sl[6]=1445; /* line # 1445 */
        Rv5=Rv0;
        Rv6=V_srf_list;
        Ra.sl[6]=1447; /* line # 1447 */
        ((V *)Rv5)[7]=((V *)Rv6)[1];
        Ra.sl[6]=1448; /* line # 1448 */
        P_val_new(((V *)Rv5)+7,V_typ_std.v[10]);
        Ra.sl[6]=1449; /* line # 1449 */
        Rv7=((V *)Rv5)[7];
        Ra.sl[6]=1450; /* line # 1450 */
        if (((SL *)Rv7)[3]<=2) {
          Ra.sl[6]=1452; /* line # 1452 */
          ((V *)Rv7)[4]=((V *)Rv5)[3];
          Ra.sl[6]=1453; /* line # 1453 */
          ((UB *)Rv7)[48]=32;
          Ra.sl[6]=1454; /* line # 1454 */
          ((SL *)Rv7)[6]=((UB *)((V *)Rv7)[7])[1];
        }
      }
      Ra.sl[6]=1459; /* line # 1459 */
      if (Rv1) {
        Ra.sl[6]=1461; /* line # 1461 */
        Rv8=F_lgp;
        Ra.sl[6]=1462; /* line # 1462 */
        if (((V *)Rv8)[1]!=NULL) {
          Ra.sl[6]=1464; /* line # 1464 */
          ((SL *)Rv8)[4]=((SL *)Rv3)[10];
          Ra.sl[6]=1465; /* line # 1465 */
          if (Rv2) {
            Ra.sl[6]=1466; /* line # 1466 */
            if (((SL *)Rv8)[11]<2) {
              Ra.sl[6]=1467; /* line # 1467 */
              Rv9=((V *)Rv8)[1];
              Ra.sl[6]=1469; /* line # 1469 */
              if (((V *)Rv9)[1]!=NULL) P_lgt_free_tree(((V *)Rv9)+1);
              Ra.sl[6]=1470; /* line # 1470 */
              ((V *)Rv9)[1]=Rv0;
            }
            else {
              Ra.sl[6]=1473; /* line # 1473 */
              Rv10=((V *)Rv8)[1];
              Ra.sl[6]=1474; /* line # 1474 */
              if (((V *)Rv10)[1]!=NULL) {
                Ra.sl[6]=1475; /* line # 1475 */
                Rv11=((V *)Rv10)[1];
                Ra.sl[6]=1477; /* line # 1477 */
                if (((V *)Rv11)[1]!=NULL) P_lgt_free_tree(((V *)Rv11)+1);
                Ra.sl[6]=1478; /* line # 1478 */
                ((V *)Rv11)[1]=Rv0;
              }
            }
          }
        }
      }
      else {
        Ra.sl[6]=1484; /* line # 1484 */
        if (F_icd==3||F_icd==5) {
          Ra.sl[6]=1486; /* line # 1486 */
          P_lgt_new(&Rv12, V_typ_std.v[10],14,NULL);
          Ra.sl[6]=1487; /* line # 1487 */
          Rv13=Rv12;
          Ra.sl[6]=1489; /* line # 1489 */
          ((V *)Rv13)[7]=NULL;
          Ra.sl[6]=1490; /* line # 1490 */
          P_val_new(((V *)Rv13)+7,V_typ_std.v[10]);
          Ra.sl[6]=1491; /* line # 1491 */
          Rv14=((V *)Rv13)[7];
          Rv15=V_cntx_varbl;
          Ra.sl[6]=1493; /* line # 1493 */
          ((UB *)Rv14)[48]=32;
          Ra.sl[6]=1494; /* line # 1494 */
          Rv16=((UB *)((V *)Rv15)[0])[0];
          ((V *)Rv14)[7]=PAS__NEW((SL)Rv16+2);
          ((UB *)((V *)Rv14)[7])[0]=Rv16;
          Ra.sl[6]=1495; /* line # 1495 */
          Rv17=((V *)Rv14)[7];
          Rv18=((V *)Rv15)[0];
          Ra.sl[6]=1497; /* line # 1497 */
          ((UB *)Rv17)[1]=((UB *)Rv17)[0];
          Ra.sl[6]=1498; /* line # 1498 */
          Rv19=1;
          for( Rf0=((UB *)Rv17)[0];Rf0>0;Rf0-- ) {
            ((C *)Rv17)[Rv19+1]=((C *)Rv18)[Rv19];
            Rv19++;
          }
          Ra.sl[6]=1499; /* line # 1499 */
          ((SL *)Rv14)[6]=((UB *)Rv17)[0];
          Ra.sl[6]=1503; /* line # 1503 */
          ((V *)Rv12)[0]=Rv0;
          Ra.sl[6]=1504; /* line # 1504 */
          Rv0=Rv12;
        }
        Ra.sl[6]=1506; /* line # 1506 */
        Rv0=P_lgt_new_idref(V_cntx_varbl, Rv0);
        Ra.sl[6]=1507; /* line # 1507 */
        P_lgt_new(&Rv0,NULL,23, Rv0);
        Ra.sl[6]=1508; /* line # 1508 */
        Rv20=Rv0;
        Ra.sl[6]=1510; /* line # 1510 */
        ((SL *)Rv20)[4]=((SL *)Rv3)[10];
        Ra.sl[6]=1511; /* line # 1511 */
        ((SL *)Rv20)[11]=F_icd;
        Ra.sl[6]=1513; /* line # 1513 */
        ((V *)F_pr)[15]=Rv0;
      }
      Ra.sl[6]=1515; /* line # 1515 */
      V_cmp_tracecount=((SL *)Rv3)[10]+V_cmp_trace;
    }
  }
  Ra.sl[6]=1518; /* line # 1518 */
  if (Rv1) Ret=NULL;
  else {
    Ra.sl[6]=1519; /* line # 1519 */
    Ret=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " gen_linetrace "  */
void P_gen_linetrace(V F_pr, V *F_lgh, V *F_lgl, SL F_icd){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+551;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1692; /* line # 1692 */
  if ((*F_lgh)==NULL) (*F_lgl)=NULL;
  Ra.sl[6]=1693; /* line # 1693 */
  Rv0=P_lgt_new_line(F_pr, (*F_lgl),F_icd);
  Ra.sl[6]=1694; /* line # 1694 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1696; /* line # 1696 */
    if ((*F_lgh)==NULL) (*F_lgh)=Rv0;
    else {
      Ra.sl[6]=1697; /* line # 1697 */
      ((V *)(*F_lgl))[0]=Rv0;
    }
    Ra.sl[6]=1698; /* line # 1698 */
    (*F_lgl)=Rv0;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " label_purge "  */
void P_label_purge(V *F_prv_cntx){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+566;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1714; /* line # 1714 */
  Rv0=V_cntx_label;
  Ra.sl[6]=1715; /* line # 1715 */
  V_cntx_label=(*F_prv_cntx);
  Ra.sl[6]=1716; /* line # 1716 */
  while (Rv0!=(*F_prv_cntx)&&Rv0!=NULL){
    Ra.sl[6]=1718; /* line # 1718 */
    Rv1=Rv0;
    Ra.sl[6]=1720; /* line # 1720 */
    Rv2=((V *)Rv1)[9];
    Ra.sl[6]=1723; /* line # 1723 */
    if (16&((UB *)Rv1)[57]) {
      Ra.sl[6]=1725; /* line # 1725 */
      ((UB *)Rv1)[57]=((UB *)Rv1)[57]|32;
      Ra.sl[6]=1726; /* line # 1726 */
      ((V *)Rv1)[9]=NULL;
    }
    else {
      Ra.sl[6]=1730; /* line # 1730 */
      if (8&((UB *)Rv1)[57]) {
        Ra.sl[6]=1732; /* line # 1732 */
        P_src_error_s(Rd.s+581,67,3,((V *)Rv1)[0],NULL);
      }
      Ra.sl[6]=1733; /* line # 1733 */
      ((V *)Rv1)[9]=V_cntx_label;
      Ra.sl[6]=1734; /* line # 1734 */
      V_cntx_label=Rv0;
    }
    Ra.sl[6]=1737; /* line # 1737 */
    Rv0=Rv2;
  }
  Ra.sl[6]=1739; /* line # 1739 */
  V_cntx_lblvl=V_cntx_lblvl-1;
  Ra.sl[6]=1740; /* line # 1740 */
  (*F_prv_cntx)=V_cntx_label;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " typ_alignement "  */
SL P_typ_alignement(SL F_iaddr, V F_aln){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  register SL Ret;

  /* Code of procedure/function */
  memcpy( Ra.s+36,F_aln,1);
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+585;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1752; /* line # 1752 */
  Ra.sl[6]=1754; /* line # 1754 */
  Ra.sl[7]=F_iaddr+Ra.ub[36];
  Ra.sl[8]=Ra.ub[36];
  Ra.sl[6]=1755; /* line # 1755 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1756; /* line # 1756 */
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " ide_typ_align "  */
SL P_ide_typ_align(SL F_iaddr, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;
  register SL Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+601;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1769; /* line # 1769 */
  Rv0=F_ty;
  Ra.sl[6]=1771; /* line # 1771 */
  Ra.sl[7]=F_iaddr+((UB *)Rv0)[48];
  Ra.sl[8]=((UB *)Rv0)[48];
  Ra.sl[6]=1772; /* line # 1772 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1773; /* line # 1773 */
  Ret=Ra.sl[7];
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " all_typ_allocate "  */
void P_all_typ_allocate(SL *F_iaddr, V F_al){
  /* Define the automatic variable space. */
  Blk( Ra, 40 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+616;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1786; /* line # 1786 */
  Rv0=F_al;
  Ra.sl[6]=1788; /* line # 1788 */
  Ra.sl[7]=(*F_iaddr)+((UB *)Rv0)[16];
  Ra.sl[6]=1789; /* line # 1789 */
  Ra.sl[8]=((UB *)Rv0)[16];
  Ra.sl[6]=1790; /* line # 1790 */
  Ra.ul[7]=Ra.ul[7]&~Ra.ul[8];
  Ra.sl[6]=1791; /* line # 1791 */
  ((SL *)Rv0)[17]=Ra.sl[7];
  Ra.sl[6]=1792; /* line # 1792 */
  (*F_iaddr)=Ra.sl[7]+abs(((SL *)Rv0)[13]);
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " cte_allocate "  */
void P_cte_allocate(V F_vp, V F_id){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  SL Rv3;
  register V Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+634;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1806; /* line # 1806 */
  if (F_id==NULL) Rv0=((V *)F_vp)[4];
  else {
    Ra.sl[6]=1807; /* line # 1807 */
    Rv0=((V *)F_id)[4];
  }
  Ra.sl[6]=1808; /* line # 1808 */
  if (Rv0!=NULL) {
    Ra.sl[6]=1809; /* line # 1809 */
    Rv1=Rv0;
    Rv2=F_vp;
    Ra.sl[6]=1810; /* line # 1810 */
    if (!((UB *)Rv1)[91]&&((UB *)Rv2)[48]!=21) {
      Ra.sl[6]=1812; /* line # 1812 */
      Rv3=((SL *)Rv1)[11];
      Ra.sl[6]=1813; /* line # 1813 */
      if (((SL *)Rv2)[6]>0) {
        Ra.sl[6]=1814; /* line # 1814 */
        if (Rv0==V_typ_std.v[10]) {
          Ra.sl[6]=1815; /* line # 1815 */
          ((SL *)Rv1)[11]=((SL *)Rv2)[6]+((SL *)Rv1)[10];
        }
        else {
          Ra.sl[6]=1817; /* line # 1817 */
          ((SL *)Rv1)[11]=((SL *)Rv2)[6];
        }
      }
      else {
        Ra.sl[6]=1818; /* line # 1818 */
        ((SL *)Rv1)[11]=0;
      }
      Ra.sl[6]=1819; /* line # 1819 */
      P_all_new(((V *)Rv2)+5,Rv0, F_id,11);
      Ra.sl[6]=1820; /* line # 1820 */
      if (F_id!=NULL) ((V *)F_id)[9]=((V *)Rv2)[5];
      Ra.sl[6]=1821; /* line # 1821 */
      ((SL *)Rv1)[11]=Rv3;
      Ra.sl[6]=1822; /* line # 1822 */
      if (V_all_fdata==NULL) V_all_fdata=((V *)Rv2)[5];
      else {
        Ra.sl[6]=1823; /* line # 1823 */
        ((V *)V_all_ldata)[0]=((V *)Rv2)[5];
      }
      Ra.sl[6]=1824; /* line # 1824 */
      ((V *)((V *)Rv2)[5])[1]=V_all_ldata;
      Ra.sl[6]=1825; /* line # 1825 */
      V_all_ldata=((V *)Rv2)[5];
      Ra.sl[6]=1826; /* line # 1826 */
      Rv4=((V *)Rv2)[5];
      Ra.sl[6]=1828; /* line # 1828 */
      ((V *)Rv4)[13]=F_vp;
      Ra.sl[6]=1829; /* line # 1829 */
      Rv5=((V *)Rv4)[13];
      ((SL *)Rv5)[3]=((SL *)Rv5)[3]+1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ "  */
void P_ide_new_typ(UB F_frm, V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  register V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+648;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1840; /* line # 1840 */
  (*F_p)=PAS__NEW(128);
  Ra.sl[6]=1841; /* line # 1841 */
  if ((*F_p)!=NULL) {
    Ra.sl[6]=1842; /* line # 1842 */
    Rv0=(*F_p);
    Ra.sl[6]=1844; /* line # 1844 */
    ((V *)Rv0)[0]=NULL;
    Ra.sl[6]=1845; /* line # 1845 */
    ((V *)Rv0)[1]=NULL;
    Ra.sl[6]=1846; /* line # 1846 */
    Rv1=(V_lex_ident_tree.s+V_curr_disp*64);
    Ra.sl[6]=1848; /* line # 1848 */
    ((V *)Rv0)[2]=((V *)Rv1)[5];
    Ra.sl[6]=1849; /* line # 1849 */
    ((V *)Rv1)[5]=(*F_p);
    Ra.sl[6]=1851; /* line # 1851 */
    ((V *)Rv0)[3]=NULL;
    Ra.sl[6]=1852; /* line # 1852 */
    ((V *)Rv0)[4]=NULL;
    Ra.sl[6]=1853; /* line # 1853 */
    ((SL *)Rv0)[10]=0;
    Ra.sl[6]=1854; /* line # 1854 */
    ((SL *)Rv0)[11]=V_inte_size;
    Ra.sl[6]=1855; /* line # 1855 */
    ((UB *)Rv0)[48]=0;
    Ra.sl[6]=1856; /* line # 1856 */
    ((V *)Rv0)[7]=NULL;
    Ra.sl[6]=1857; /* line # 1857 */
    ((V *)Rv0)[8]=NULL;
    Ra.sl[6]=1858; /* line # 1858 */
    ((V *)Rv0)[9]=NULL;
    Ra.sl[6]=1859; /* line # 1859 */
    ((V *)Rv0)[10]=NULL;
    Ra.sl[6]=1860; /* line # 1860 */
    ((UB *)Rv0)[88]=0;
    Ra.sl[6]=1861; /* line # 1861 */
    ((UB *)Rv0)[89]=0;
    Ra.sl[6]=1862; /* line # 1862 */
    ((UB *)Rv0)[90]=0;
    Ra.sl[6]=1863; /* line # 1863 */
    switch (F_frm) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 11:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 19:
      case 22:
      case 30:Ra.sl[6]=1868; /* line # 1868 */
      ((UB *)Rv0)[91]=1;
      break;
      default:Ra.sl[6]=1870; /* line # 1870 */
      ((UB *)Rv0)[91]=0;
      break;
    }
    Ra.sl[6]=1872; /* line # 1872 */
    ((UB *)Rv0)[92]=F_frm;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_new_typ_range "  */
void P_ide_new_typ_range(SL F_min, SL F_max, V F_parent, V *F_typ){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+661;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1884; /* line # 1884 */
  P_ide_new_typ(2, F_typ);
  Ra.sl[6]=1885; /* line # 1885 */
  Rv0=(*F_typ);
  Ra.sl[6]=1887; /* line # 1887 */
  ((V *)Rv0)[12]=NULL;
  Ra.sl[6]=1888; /* line # 1888 */
  ((V *)Rv0)[13]=NULL;
  Ra.sl[6]=1889; /* line # 1889 */
  if (F_parent!=NULL) {
    Ra.sl[6]=1891; /* line # 1891 */
    ((V *)Rv0)[0]=F_parent;
    Ra.sl[6]=1892; /* line # 1892 */
    ((UB *)Rv0)[92]=((UB *)F_parent)[92];
    Ra.sl[6]=1893; /* line # 1893 */
    ((SL *)Rv0)[11]=((SL *)F_parent)[11];
    Ra.sl[6]=1894; /* line # 1894 */
    memcpy(Rv0+48,F_parent+48,1);
    Ra.sl[6]=1895; /* line # 1895 */
    ((UB *)Rv0)[112]=((UB *)F_parent)[112];
  }
  else {
    Ra.sl[6]=1899; /* line # 1899 */
    ((UB *)Rv0)[48]=0;
    Ra.sl[6]=1900; /* line # 1900 */
    ((UB *)Rv0)[112]=F_min>=0;
    Ra.sl[6]=1901; /* line # 1901 */
    ((SL *)Rv0)[11]=4;
  }
  Ra.sl[6]=1903; /* line # 1903 */
  ((UB *)Rv0)[88]=1;
  Ra.sl[6]=1904; /* line # 1904 */
  ((SL *)Rv0)[29]=F_min;
  ((SL *)Rv0)[30]=F_max;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_allocate "  */
void P_tmpstk_allocate(V F_lgt, V F_ty){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+680;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1916; /* line # 1916 */
  Rv0=PAS__NEW(24);
  Ra.sl[6]=1917; /* line # 1917 */
  ((V *)Rv0)[0]=V_wildtmp_stk;
  Ra.sl[6]=1918; /* line # 1918 */
  ((V *)Rv0)[1]=F_lgt;
  Ra.sl[6]=1919; /* line # 1919 */
  if (V_wildtmp_stk!=NULL) {
    Ra.sl[6]=1920; /* line # 1920 */
    ((SL *)Rv0)[5]=((SL *)V_wildtmp_stk)[4];
  }
  else {
    Ra.sl[6]=1922; /* line # 1922 */
    ((SL *)Rv0)[5]=0;
  }
  Ra.sl[6]=1924; /* line # 1924 */
  ((SL *)Rv0)[4]=P_typ_alignement(((SL *)Rv0)[5],F_ty+48);
  Ra.sl[6]=1925; /* line # 1925 */
  ((SL *)F_lgt)[4]=((SL *)Rv0)[4];
  Ra.sl[6]=1930; /* line # 1930 */
  ((SL *)Rv0)[4]=((SL *)Rv0)[4]+abs(((SL *)F_ty)[11]);
  Ra.sl[6]=1932; /* line # 1932 */
  if (((UB *)V_wildtmp_typ)[48]<((UB *)F_ty)[48]) {
    Ra.sl[6]=1934; /* line # 1934 */
    memcpy(V_wildtmp_pal.s,V_wildtmp_typ+48,1);
    Ra.sl[6]=1935; /* line # 1935 */
    memcpy(V_wildtmp_typ+48,F_ty+48,1);
  }
  Ra.sl[6]=1938; /* line # 1938 */
  if (((SL *)V_wildtmp_typ)[11]<((SL *)Rv0)[4]) {
    Ra.sl[6]=1940; /* line # 1940 */
    V_wildtmp_psz=((SL *)V_wildtmp_typ)[11];
    Ra.sl[6]=1941; /* line # 1941 */
    ((SL *)V_wildtmp_typ)[11]=((SL *)Rv0)[4];
  }
  Ra.sl[6]=1943; /* line # 1943 */
  V_wildtmp_stk=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " tmpstk_free "  */
void P_tmpstk_free(V F_stkp){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+697;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1954; /* line # 1954 */
  while (F_stkp!=V_wildtmp_stk&&V_wildtmp_stk!=NULL){
    Ra.sl[6]=1956; /* line # 1956 */
    Rv0=V_wildtmp_stk;
    Ra.sl[6]=1957; /* line # 1957 */
    V_wildtmp_stk=((V *)V_wildtmp_stk)[0];
    Ra.sl[6]=1958; /* line # 1958 */
    PAS__DISPOSE(&Rv0);
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ide_list "  */
void P_free_ide_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  V Rv2;
  register V Rv3;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+710;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=1973; /* line # 1973 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=1975; /* line # 1975 */
    Rv0=(*F_p);
    Ra.sl[6]=1977; /* line # 1977 */
    Rv1=((V *)(*F_p))[3];
    Ra.sl[6]=1978; /* line # 1978 */
    switch (((UB *)Rv0)[56]) {
      case 3:
      case 13:Ra.sl[6]=1980; /* line # 1980 */
      PAS__DISPOSE(F_p);
      break;
      case 4:Ra.sl[6]=1984; /* line # 1984 */
      P_val_free(((V *)Rv0)+8);
      PAS__DISPOSE(F_p);
      break;
      case 2:Ra.sl[6]=1989; /* line # 1989 */
      if (((V *)Rv0)[11]!=NULL) {
        Ra.sl[6]=1990; /* line # 1990 */
        P_val_free(((V *)Rv0)+11);
      }
      Ra.sl[6]=1991; /* line # 1991 */
      PAS__DISPOSE(F_p);
      break;
      case 5:Ra.sl[6]=1996; /* line # 1996 */
      if (((V *)Rv0)[9]!=NULL) {
        Ra.sl[6]=1997; /* line # 1997 */
        P_val_free(((V *)Rv0)+9);
      }
      Ra.sl[6]=1998; /* line # 1998 */
      PAS__DISPOSE(F_p);
      break;
      case 6:Ra.sl[6]=2001; /* line # 2001 */
      PAS__DISPOSE(F_p);
      break;
      case 10:Ra.sl[6]=2005; /* line # 2005 */
      Rv2=((V *)Rv0)[8];
      Ra.sl[6]=2006; /* line # 2006 */
      while (Rv2!=NULL){
        Ra.sl[6]=2008; /* line # 2008 */
        Rv2=((V *)((V *)Rv0)[8])[0];
        Ra.sl[6]=2010; /* line # 2010 */
        PAS__DISPOSE(((V *)Rv0)+8);
        Ra.sl[6]=2011; /* line # 2011 */
        ((V *)Rv0)[8]=Rv2;
      }
      Ra.sl[6]=2013; /* line # 2013 */
      PAS__DISPOSE(F_p);
      break;
      case 7:Ra.sl[6]=2018; /* line # 2018 */
      Rv3=((V *)Rv0)[9];
      Ra.sl[6]=2020; /* line # 2020 */
      P_free_ide_list(((V *)Rv3)+8);
      Ra.sl[6]=2021; /* line # 2021 */
      P_free_typ_list(((V *)Rv3)+12);
      Ra.sl[6]=2023; /* line # 2023 */
      PAS__DISPOSE(((V *)Rv0)+9);
      Ra.sl[6]=2024; /* line # 2024 */
      PAS__DISPOSE(F_p);
      break;
      case 0:Ra.sl[6]=2027; /* line # 2027 */
      PAS__DISPOSE(F_p);
      break;
      case 1:
      case 8:
      case 9:Ra.sl[6]=2033; /* line # 2033 */
      P_free_generic_list(((V *)Rv0)+10,((V *)Rv0)+11);
      Ra.sl[6]=2034; /* line # 2034 */
      PAS__DISPOSE(F_p);
      break;
      default:break;
    }
    Ra.sl[6]=2039; /* line # 2039 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_typ_list "  */
void P_free_typ_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+725;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2052; /* line # 2052 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=2054; /* line # 2054 */
    Rv0=(*F_p);
    Ra.sl[6]=2056; /* line # 2056 */
    if (((V *)Rv0)[10]!=NULL) {
      Ra.sl[6]=2057; /* line # 2057 */
      P_val_free(((V *)Rv0)+10);
    }
    Ra.sl[6]=2058; /* line # 2058 */
    P_free_ide_list(((V *)Rv0)+4);
    Ra.sl[6]=2059; /* line # 2059 */
    P_lgt_free_tree(((V *)Rv0)+9);
    Ra.sl[6]=2060; /* line # 2060 */
    Rv1=((V *)Rv0)[2];
    Ra.sl[6]=2061; /* line # 2061 */
    switch (((UB *)Rv0)[92]) {
      case 0:
      case 1:
      case 2:Ra.sl[6]=2065; /* line # 2065 */
      P_free_ide_list(((V *)Rv0)+12);
      Ra.sl[6]=2066; /* line # 2066 */
      P_lgt_free(((V *)Rv0)+13);
      break;
      case 8:Ra.sl[6]=2068; /* line # 2068 */
      P_lgt_free_tree(((V *)Rv0)+13);
      break;
      case 10:
      case 23:Ra.sl[6]=2071; /* line # 2071 */
      if (((UB *)Rv0)[92]==10) {
        Ra.sl[6]=2072; /* line # 2072 */
        P_free_ide_list(((V *)Rv0)+12);
      }
      Ra.sl[6]=2073; /* line # 2073 */
      P_lgt_free_tree(((V *)Rv0)+14);
      break;
      case 22:Ra.sl[6]=2076; /* line # 2076 */
      if (((V *)Rv0)[12]!=NULL) P_lgt_free_tree(((V *)Rv0)+12);
      Ra.sl[6]=2077; /* line # 2077 */
      if (((V *)Rv0)[13]!=NULL) P_lgt_free_tree(((V *)Rv0)+13);
      Ra.sl[6]=2078; /* line # 2078 */
      if (((V *)Rv0)[14]!=NULL) P_lgt_free_tree(((V *)Rv0)+14);
      break;
      case 6:Ra.sl[6]=2081; /* line # 2081 */
      Rv2=((V *)Rv0)[13];
      Ra.sl[6]=2083; /* line # 2083 */
      P_free_ide_list(((V *)Rv2)+8);
      Ra.sl[6]=2084; /* line # 2084 */
      P_free_typ_list(((V *)Rv2)+12);
      Ra.sl[6]=2086; /* line # 2086 */
      PAS__DISPOSE(((V *)Rv0)+13);
      break;
      default:break;
    }
    Ra.sl[6]=2090; /* line # 2090 */
    P_lgt_free_tree(((V *)Rv0)+7);
    Ra.sl[6]=2091; /* line # 2091 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=2093; /* line # 2093 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_ope_list "  */
void PAS_IDENT_free_ope_list(V *F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  V Rv1;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+740;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2106; /* line # 2106 */
  while ((*F_p)!=NULL){
    Ra.sl[6]=2108; /* line # 2108 */
    Rv0=(*F_p);
    Ra.sl[6]=2110; /* line # 2110 */
    V_ope_table.v[((UB *)Rv0)[0]]=((V *)Rv0)[2];
    Ra.sl[6]=2111; /* line # 2111 */
    P_free_generic_list(((V *)Rv0)+3,((V *)Rv0)+4);
    Ra.sl[6]=2112; /* line # 2112 */
    Rv1=((V *)Rv0)[1];
    Ra.sl[6]=2114; /* line # 2114 */
    PAS__DISPOSE(F_p);
    Ra.sl[6]=2115; /* line # 2115 */
    (*F_p)=Rv1;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " free_generic_list "  */
void P_free_generic_list(V *F_f, V *F_l){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+755;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2128; /* line # 2128 */
  if ((*F_f)!=NULL) while (1){
    Ra.sl[6]=2130; /* line # 2130 */
    Rv0=(*F_f);
    Ra.sl[6]=2131; /* line # 2131 */
    Rv1=Rv0;
    Ra.sl[6]=2132; /* line # 2132 */
    if (!((UB *)Rv1)[8]) {
      Ra.sl[6]=2134; /* line # 2134 */
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=2136; /* line # 2136 */
      if (((UB *)Rv2)[104]==10) {
        Ra.sl[6]=2138; /* line # 2138 */
        P_free_ide_list(((V *)Rv2)+23);
        Ra.sl[6]=2139; /* line # 2139 */
        P_free_ide_list(((V *)Rv2)+21);
        Ra.sl[6]=2140; /* line # 2140 */
        P_free_typ_list(((V *)Rv2)+24);
        Ra.sl[6]=2141; /* line # 2141 */
        PAS_IDENT_free_ope_list(((V *)Rv2)+19);
      }
      Ra.sl[6]=2143; /* line # 2143 */
      P_free_ide_list(((V *)Rv2)+8);
      Ra.sl[6]=2144; /* line # 2144 */
      P_free_typ_list(((V *)Rv2)+12);
      Ra.sl[6]=2147; /* line # 2147 */
      if (((UB *)Rv2)[104]==9) {
        Ra.sl[6]=2149; /* line # 2149 */
        if (((V *)Rv2)[25]!=NULL) {
          Ra.sl[6]=2151; /* line # 2151 */
          ((V *)((V *)Rv2)[26])[0]=V_all_free_list;
          Ra.sl[6]=2152; /* line # 2152 */
          V_all_free_list=((V *)Rv2)[25];
        }
      }
      Ra.sl[6]=2156; /* line # 2156 */
      PAS__DISPOSE(((V *)Rv1)+2);
    }
    Ra.sl[6]=2158; /* line # 2158 */
    if ((*F_f)!=(*F_l)) (*F_f)=((V *)(*F_f))[0];
    Ra.sl[6]=2159; /* line # 2159 */
    PAS__DISPOSE(&Rv0);
    if ((*F_f)==(*F_l))  break;
  }
  Ra.sl[6]=2161; /* line # 2161 */
  (*F_f)=NULL;
  (*F_l)=NULL;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_free_lex "  */
void P_ide_free_lex(V F_p){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+774;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2173; /* line # 2173 */
  if (F_p!=NULL) {
    Ra.sl[6]=2174; /* line # 2174 */
    Rv0=F_p;
    Ra.sl[6]=2175; /* line # 2175 */
    if (((UB *)Rv0)[104]!=10) {
      Ra.sl[6]=2178; /* line # 2178 */
      P_free_ide_list(((V *)Rv0)+23);
      Ra.sl[6]=2179; /* line # 2179 */
      P_free_ide_list(((V *)Rv0)+21);
      Ra.sl[6]=2180; /* line # 2180 */
      P_free_typ_list(((V *)Rv0)+24);
      Ra.sl[6]=2181; /* line # 2181 */
      PAS_IDENT_free_ope_list(((V *)Rv0)+19);
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_create_name "  */
void P_ide_create_name(V F_name){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+788;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2194; /* line # 2194 */
  PAS__STR_TO_STR(Ri.s+1,V_sy_string.s);
  Ra.sl[6]=2195; /* line # 2195 */
  Ri.ub[0]=1;
  Ra.sl[6]=2196; /* line # 2196 */
  Rv0=PAS__LENGTH_STR(F_name);
  Ra.sl[6]=2197; /* line # 2197 */
  if (Rv0>31) Rv0=31;
  Ra.sl[6]=2198; /* line # 2198 */
  Rv1=1;
  for( Rf0=Rv0;Rf0>0;Rf0-- ) {
    Ra.sl[6]=2199; /* line # 2199 */
    V_sy_ident.c[Rv1]=((C *)F_name)[Rv1+1];
    Rv1++;
  }
  Ra.sl[6]=2200; /* line # 2200 */
  V_sy_ident.ub[0]=Rv0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_int_label "  */
void P_ide_int_label(){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  SL Rv0;
  SL Rv1;
  register int Rgi;
  register int Rgj;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+805;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2215; /* line # 2215 */
  Rv0=V_sy_ival;
  Ra.sl[6]=2216; /* line # 2216 */
  if (Rv0<=0||Rv0>9999) {
    Ra.sl[6]=2218; /* line # 2218 */
    P_src_error(Rd.s+822,68,3);
    Ra.sl[6]=2219; /* line # 2219 */
    Rv0=0;
  }
  Ra.sl[6]=2221; /* line # 2221 */
  Rv1=5;
  Ra.sl[6]=2222; /* line # 2222 */
  while (Rv1>1){
    Ra.sl[6]=2224; /* line # 2224 */
    V_sy_ident.c[Rv1]=(C)(PAS__I_MOD(Rv0,10)+48);
    Ra.sl[6]=2225; /* line # 2225 */
    Rv1=Rv1-1;
    Ra.sl[6]=2226; /* line # 2226 */
    Rv0=Rv0/10;
  }
  Ra.sl[6]=2228; /* line # 2228 */
  V_sy_ident.c[1]=46;
  Ra.sl[6]=2229; /* line # 2229 */
  V_sy_ident.ub[0]=5;
  Ra.sl[6]=2230; /* line # 2230 */
  V_sy_sym.ub[0]=0;
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " ide_search_from_nameid "  */
V P_ide_search_from_nameid(V F_ip){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Ret;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+826;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2245; /* line # 2245 */
  Rv0=NULL;
  Ra.sl[6]=2246; /* line # 2246 */
  if (F_ip!=NULL) {
    Ra.sl[6]=2247; /* line # 2247 */
    Rv1=F_ip;
    Ra.sl[6]=2248; /* line # 2248 */
    if (((V *)Rv1)[0]!=NULL) {
      Ra.sl[6]=2250; /* line # 2250 */
      V_curr_ident=((V *)F_ip)[0];
      Ra.sl[6]=2251; /* line # 2251 */
      Rv0=P_ide_search(1<<((UB *)Rv1)[56]);
      Ra.sl[6]=2252; /* line # 2252 */
      V_curr_ident=NULL;
    }
  }
  Ra.sl[6]=2254; /* line # 2254 */
  Ret=Rv0;
  PAS__curr_cntx=Ra.v[0];
  return(Ret);
}


/* Procedure/Function : " set_gbl_def_nam "  */
void P_set_gbl_def_nam(V *F_trg, V F_src, C F_ach){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  register V Rv0;
  SL Rv1;
  SL Rv2;
  SL Rv3;
  register int Rf0;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+850;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2266; /* line # 2266 */
  (*F_trg)=PAS__NEW(32);
  Ra.sl[6]=2267; /* line # 2267 */
  Rv0=(*F_trg);
  Ra.sl[6]=2269; /* line # 2269 */
  ((C *)Rv0)[1]=F_ach;
  ((C *)Rv0)[2]=95;
  Ra.sl[6]=2270; /* line # 2270 */
  if (((UB *)F_src)[0]<=29) {
    Ra.sl[6]=2272; /* line # 2272 */
    Rv1=1;
    for( Rf0=((UB *)F_src)[0];Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv1+2)]=((C *)F_src)[Rv1];
      Rv1++;
    }
    Ra.sl[6]=2273; /* line # 2273 */
    ((UB *)Rv0)[0]=((UB *)F_src)[0]+2;
  }
  else {
    Ra.sl[6]=2277; /* line # 2277 */
    Rv2=1;
    for( Rf0=27;Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv2+2)]=((C *)F_src)[Rv2];
      Rv2++;
    }
    Ra.sl[6]=2278; /* line # 2278 */
    Rv3=((UB *)F_src)[0]-3;
    for( Rf0=(((UB *)F_src)[0]+1)-(((UB *)F_src)[0]-3);Rf0>0;Rf0-- ) {
      ((C *)Rv0)[(Rv3+2)]=((C *)F_src)[Rv3];
      Rv3++;
    }
    Ra.sl[6]=2279; /* line # 2279 */
    ((UB *)Rv0)[0]=31;
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " set_env_file_spc "  */
void P_set_env_file_spc(V F_pcur){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  UB Rv0;
  V Rv1;
  V Rv2;
  V Rv3;
  register UB Rv4;
  register V Rv5;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+867;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2296; /* line # 2296 */
  Rv0=0;
  Ra.sl[6]=2297; /* line # 2297 */
  Rv1=V_env_first;
  Ra.sl[6]=2298; /* line # 2298 */
  Rv2=NULL;
  Ra.sl[6]=2299; /* line # 2299 */
  Rv3=NULL;
  Ra.sl[6]=2300; /* line # 2300 */
  Rv4=V_sy_string.ub[1];
  Rv3=PAS__NEW((SL)Rv4+2);
  ((UB *)Rv3)[0]=Rv4;
  Ra.sl[6]=2301; /* line # 2301 */
  PAS__STR_TO_STR(Rv3,V_sy_string.s);
  Ra.sl[6]=2302; /* line # 2302 */
  while (!Rv0&&Rv1!=NULL){
    Ra.sl[6]=2304; /* line # 2304 */
    if (PAS__MATCH_STR(Rv3,((V *)Rv1)[1])==0) Rv0=1;
    else {
      Ra.sl[6]=2307; /* line # 2307 */
      Rv2=Rv1;
      Ra.sl[6]=2308; /* line # 2308 */
      Rv1=((V *)Rv1)[0];
    }
  }
  Ra.sl[6]=2312; /* line # 2312 */
  if (Rv0) PAS__DISPOSE(&Rv3);
  else {
    Ra.sl[6]=2315; /* line # 2315 */
    Rv1=PAS__NEW(28);
    Ra.sl[6]=2316; /* line # 2316 */
    Rv5=Rv1;
    Ra.sl[6]=2318; /* line # 2318 */
    ((V *)Rv5)[0]=F_pcur;
    Ra.sl[6]=2319; /* line # 2319 */
    ((V *)Rv5)[1]=Rv3;
    Ra.sl[6]=2320; /* line # 2320 */
    ((SL *)Rv5)[6]=0;
    Ra.sl[6]=2322; /* line # 2322 */
    if (F_pcur!=NULL) {
      Ra.sl[6]=2324; /* line # 2324 */
      if (F_pcur==V_env_first) V_env_first=Rv1;
    }
    else {
      Ra.sl[6]=2328; /* line # 2328 */
      if (V_env_first==NULL) V_env_first=Rv1;
      else {
        Ra.sl[6]=2329; /* line # 2329 */
        ((V *)V_env_last)[0]=Rv1;
      }
      Ra.sl[6]=2330; /* line # 2330 */
      V_env_last=Rv1;
    }
  }
  PAS__curr_cntx=Ra.v[0];
}


/* Procedure/Function : " wiew_oper_def "  */
void P_wiew_oper_def(UB F_op){
  /* Define the automatic variable space. */
  Blk( Ra, 32 );

  /* Local variable stored in C variable */
  V Rv0;
  register V Rv1;
  register V Rv2;
  register V Rv3;
  V Rv4;
  register V Rv5;
  register V Rv6;
  register V Rv7;
  register V Rv8;
  register V Rv9;
  register V Rv10;

  /* Code of procedure/function */
  Ra.v[0]=PAS__curr_cntx;
  PAS__curr_cntx=Ra.s;
  Ra.v[1]=Rd.s+885;
  Ra.v[2]=Rd.s+9;
  Ra.sl[6]=2344; /* line # 2344 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_STR(Rd.s+900,-1,-1,32);
  PAS__WRITE_CHT((V_opname.s+F_op*32+1),31, V_opname.ub[F_op*32],-1,32);
  PAS__WRITE_STR(Rd.s+917,-1,-1,32);
  PAS__WRITE_EOLN();
  Ra.sl[6]=2345; /* line # 2345 */
  Rv0=((V *)V_ope_table.v[F_op])[3];
  Ra.sl[6]=2346; /* line # 2346 */
  while (Rv0!=NULL){
    Ra.sl[6]=2347; /* line # 2347 */
    Rv1=Rv0;
    Ra.sl[6]=2349; /* line # 2349 */
    PAS__SELECT_OUT(PAS__f_output);
    PAS__WRITE_FCHAR(32,8,-1,1,32);
    Ra.sl[6]=2350; /* line # 2350 */
    if (((UB *)Rv1)[8]) {
      Ra.sl[6]=2352; /* line # 2352 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(40);
      Ra.sl[6]=2353; /* line # 2353 */
      if (((V *)Rv1)[3]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_CHAR(32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[3])[92],Rd.s+944,0,-1,32);
      }
      Ra.sl[6]=2354; /* line # 2354 */
      if (((V *)Rv1)[4]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1562,-1,-1,32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[4])[92],Rd.s+944,0,-1,32);
      }
      Ra.sl[6]=2355; /* line # 2355 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(41);
      Ra.sl[6]=2356; /* line # 2356 */
      if (((V *)Rv1)[2]!=NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1566,-1,-1,32);
        PAS__WRITE_ENM(((UB *)((V *)Rv1)[2])[92],Rd.s+944,0,-1,32);
      }
      Ra.sl[6]=2357; /* line # 2357 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_EOLN();
    }
    else {
      Ra.sl[6]=2360; /* line # 2360 */
      Rv2=((V *)Rv1)[2];
      Ra.sl[6]=2362; /* line # 2362 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_FCHAR(32,8,-1,1,32);
      Ra.sl[6]=2363; /* line # 2363 */
      if (((V *)Rv2)[11]==NULL) {
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1572,-1,-1,32);
      }
      else {
        Ra.sl[6]=2364; /* line # 2364 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1584,-1,-1,32);
      }
      Ra.sl[6]=2365; /* line # 2365 */
      Rv3=((V *)Rv2)[3];
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHT(Rv3+1,31,((UB *)Rv3)[0],-1,32);
      PAS__WRITE_CHAR(40);
      Ra.sl[6]=2366; /* line # 2366 */
      Rv4=((V *)Rv2)[8];
      Ra.sl[6]=2367; /* line # 2367 */
      while (Rv4!=NULL){
        Ra.sl[6]=2368; /* line # 2368 */
        Rv5=Rv4;
        Ra.sl[6]=2370; /* line # 2370 */
        if (((UB *)Rv5)[66]!=6) {
          Ra.sl[6]=2372; /* line # 2372 */
          Rv6=((V *)Rv5)[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHAR(32);
          PAS__WRITE_CHT(Rv6+1,31,((UB *)Rv6)[0],-1,32);
          PAS__WRITE_STR(Rd.s+1595,-1,-1,32);
          Ra.sl[6]=2373; /* line # 2373 */
          Rv7=((V *)Rv5)[4];
          Ra.sl[6]=2374; /* line # 2374 */
          if (((V *)Rv7)[3]!=NULL) {
            Ra.sl[6]=2375; /* line # 2375 */
            Rv8=((V *)((V *)Rv7)[3])[0];
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_CHT(Rv8+1,31,((UB *)Rv8)[0],-1,32);
          }
          else {
            Ra.sl[6]=2377; /* line # 2377 */
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+1599,-1,-1,32);
            PAS__WRITE_ENM(((UB *)Rv7)[92],Rd.s+944,0,-1,32);
            PAS__WRITE_CHAR(62);
          }
          Ra.sl[6]=2378; /* line # 2378 */
          if (((V *)Rv5)[3]!=NULL) {
            PAS__SELECT_OUT(PAS__f_output);
            PAS__WRITE_STR(Rd.s+1606,-1,-1,32);
          }
        }
        Ra.sl[6]=2380; /* line # 2380 */
        Rv4=((V *)Rv5)[3];
      }
      Ra.sl[6]=2382; /* line # 2382 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(41);
      Ra.sl[6]=2383; /* line # 2383 */
      if (((V *)Rv2)[11]!=NULL) {
        Ra.sl[6]=2384; /* line # 2384 */
        Rv9=((V *)Rv2)[11];
        Ra.sl[6]=2386; /* line # 2386 */
        PAS__SELECT_OUT(PAS__f_output);
        PAS__WRITE_STR(Rd.s+1610,-1,-1,32);
        Ra.sl[6]=2387; /* line # 2387 */
        if (((V *)Rv9)[3]!=NULL) {
          Ra.sl[6]=2388; /* line # 2388 */
          Rv10=((V *)((V *)Rv9)[3])[0];
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_CHT(Rv10+1,31,((UB *)Rv10)[0],-1,32);
        }
        else {
          Ra.sl[6]=2390; /* line # 2390 */
          PAS__SELECT_OUT(PAS__f_output);
          PAS__WRITE_STR(Rd.s+1614,-1,-1,32);
          PAS__WRITE_ENM(((UB *)Rv9)[92],Rd.s+944,0,-1,32);
          PAS__WRITE_CHAR(62);
        }
      }
      Ra.sl[6]=2392; /* line # 2392 */
      PAS__SELECT_OUT(PAS__f_output);
      PAS__WRITE_CHAR(59);
      PAS__WRITE_EOLN();
    }
    Ra.sl[6]=2394; /* line # 2394 */
    Rv0=((V *)Rv1)[0];
  }
  Ra.sl[6]=2396; /* line # 2396 */
  PAS__SELECT_OUT(PAS__f_output);
  PAS__WRITE_EOLN();
  PAS__curr_cntx=Ra.v[0];
}
